package visionai_poc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeLabel invokes the visionai_poc.RecognizeLabel API synchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizelabel.html
func (client *Client) RecognizeLabel(request *RecognizeLabelRequest) (response *RecognizeLabelResponse, err error) {
	response = CreateRecognizeLabelResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeLabelWithChan invokes the visionai_poc.RecognizeLabel API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizelabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeLabelWithChan(request *RecognizeLabelRequest) (<-chan *RecognizeLabelResponse, <-chan error) {
	responseChan := make(chan *RecognizeLabelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeLabel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeLabelWithCallback invokes the visionai_poc.RecognizeLabel API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizelabel.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeLabelWithCallback(request *RecognizeLabelRequest, callback func(response *RecognizeLabelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeLabelResponse
		var err error
		defer close(result)
		response, err = client.RecognizeLabel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeLabelRequest is the request struct for api RecognizeLabel
type RecognizeLabelRequest struct {
	*requests.RpcRequest
	Method   string `position:"Body" name:"Method"`
	ImageUrl string `position:"Body" name:"ImageUrl"`
	Url      string `position:"Body" name:"Url"`
}

// RecognizeLabelResponse is the response struct for api RecognizeLabel
type RecognizeLabelResponse struct {
	*responses.BaseResponse
	Code     string                   `json:"Code" xml:"Code"`
	Success  bool                     `json:"Success" xml:"Success"`
	Message  string                   `json:"Message" xml:"Message"`
	Response ResponseInRecognizeLabel `json:"Response" xml:"Response"`
}

// CreateRecognizeLabelRequest creates a request to invoke RecognizeLabel API
func CreateRecognizeLabelRequest() (request *RecognizeLabelRequest) {
	request = &RecognizeLabelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("visionai-poc", "2020-04-08", "RecognizeLabel", "", "")
	return
}

// CreateRecognizeLabelResponse creates a response to parse from RecognizeLabel response
func CreateRecognizeLabelResponse() (response *RecognizeLabelResponse) {
	response = &RecognizeLabelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
