package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsUpPeakPublishStreamData invokes the vs.DescribeVsUpPeakPublishStreamData API synchronously
func (client *Client) DescribeVsUpPeakPublishStreamData(request *DescribeVsUpPeakPublishStreamDataRequest) (response *DescribeVsUpPeakPublishStreamDataResponse, err error) {
	response = CreateDescribeVsUpPeakPublishStreamDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsUpPeakPublishStreamDataWithChan invokes the vs.DescribeVsUpPeakPublishStreamData API asynchronously
func (client *Client) DescribeVsUpPeakPublishStreamDataWithChan(request *DescribeVsUpPeakPublishStreamDataRequest) (<-chan *DescribeVsUpPeakPublishStreamDataResponse, <-chan error) {
	responseChan := make(chan *DescribeVsUpPeakPublishStreamDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsUpPeakPublishStreamData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsUpPeakPublishStreamDataWithCallback invokes the vs.DescribeVsUpPeakPublishStreamData API asynchronously
func (client *Client) DescribeVsUpPeakPublishStreamDataWithCallback(request *DescribeVsUpPeakPublishStreamDataRequest, callback func(response *DescribeVsUpPeakPublishStreamDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsUpPeakPublishStreamDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsUpPeakPublishStreamData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsUpPeakPublishStreamDataRequest is the request struct for api DescribeVsUpPeakPublishStreamData
type DescribeVsUpPeakPublishStreamDataRequest struct {
	*requests.RpcRequest
	StartTime    string           `position:"Query" name:"StartTime"`
	ShowLog      string           `position:"Query" name:"ShowLog"`
	DomainName   string           `position:"Query" name:"DomainName"`
	EndTime      string           `position:"Query" name:"EndTime"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	DomainSwitch string           `position:"Query" name:"DomainSwitch"`
}

// DescribeVsUpPeakPublishStreamDataResponse is the response struct for api DescribeVsUpPeakPublishStreamData
type DescribeVsUpPeakPublishStreamDataResponse struct {
	*responses.BaseResponse
	RequestId                          string                             `json:"RequestId" xml:"RequestId"`
	DescribeVsUpPeakPublishStreamDatas DescribeVsUpPeakPublishStreamDatas `json:"DescribeVsUpPeakPublishStreamDatas" xml:"DescribeVsUpPeakPublishStreamDatas"`
}

// CreateDescribeVsUpPeakPublishStreamDataRequest creates a request to invoke DescribeVsUpPeakPublishStreamData API
func CreateDescribeVsUpPeakPublishStreamDataRequest() (request *DescribeVsUpPeakPublishStreamDataRequest) {
	request = &DescribeVsUpPeakPublishStreamDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsUpPeakPublishStreamData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsUpPeakPublishStreamDataResponse creates a response to parse from DescribeVsUpPeakPublishStreamData response
func CreateDescribeVsUpPeakPublishStreamDataResponse() (response *DescribeVsUpPeakPublishStreamDataResponse) {
	response = &DescribeVsUpPeakPublishStreamDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
