package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenVsService invokes the vs.OpenVsService API synchronously
func (client *Client) OpenVsService(request *OpenVsServiceRequest) (response *OpenVsServiceResponse, err error) {
	response = CreateOpenVsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenVsServiceWithChan invokes the vs.OpenVsService API asynchronously
func (client *Client) OpenVsServiceWithChan(request *OpenVsServiceRequest) (<-chan *OpenVsServiceResponse, <-chan error) {
	responseChan := make(chan *OpenVsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenVsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenVsServiceWithCallback invokes the vs.OpenVsService API asynchronously
func (client *Client) OpenVsServiceWithCallback(request *OpenVsServiceRequest, callback func(response *OpenVsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenVsServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenVsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenVsServiceRequest is the request struct for api OpenVsService
type OpenVsServiceRequest struct {
	*requests.RpcRequest
}

// OpenVsServiceResponse is the response struct for api OpenVsService
type OpenVsServiceResponse struct {
	*responses.BaseResponse
	OrderId   string `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateOpenVsServiceRequest creates a request to invoke OpenVsService API
func CreateOpenVsServiceRequest() (request *OpenVsServiceRequest) {
	request = &OpenVsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "OpenVsService", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenVsServiceResponse creates a response to parse from OpenVsService response
func CreateOpenVsServiceResponse() (response *OpenVsServiceResponse) {
	response = &OpenVsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
