package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RebuildAppEnv invokes the webplus.RebuildAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/rebuildappenv.html
func (client *Client) RebuildAppEnv(request *RebuildAppEnvRequest) (response *RebuildAppEnvResponse, err error) {
	response = CreateRebuildAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// RebuildAppEnvWithChan invokes the webplus.RebuildAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/rebuildappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RebuildAppEnvWithChan(request *RebuildAppEnvRequest) (<-chan *RebuildAppEnvResponse, <-chan error) {
	responseChan := make(chan *RebuildAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RebuildAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RebuildAppEnvWithCallback invokes the webplus.RebuildAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/rebuildappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RebuildAppEnvWithCallback(request *RebuildAppEnvRequest, callback func(response *RebuildAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RebuildAppEnvResponse
		var err error
		defer close(result)
		response, err = client.RebuildAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RebuildAppEnvRequest is the request struct for api RebuildAppEnv
type RebuildAppEnvRequest struct {
	*requests.RoaRequest
	DryRun requests.Boolean `position:"Body" name:"DryRun"`
	EnvId  string           `position:"Body" name:"EnvId"`
}

// RebuildAppEnvResponse is the response struct for api RebuildAppEnv
type RebuildAppEnvResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	Code            string          `json:"Code" xml:"Code"`
	Message         string          `json:"Message" xml:"Message"`
	EnvChangeDetail EnvChangeDetail `json:"EnvChangeDetail" xml:"EnvChangeDetail"`
}

// CreateRebuildAppEnvRequest creates a request to invoke RebuildAppEnv API
func CreateRebuildAppEnvRequest() (request *RebuildAppEnvRequest) {
	request = &RebuildAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "RebuildAppEnv", "/pop/v1/wam/appEnv/rebuild", "", "")
	request.Method = requests.POST
	return
}

// CreateRebuildAppEnvResponse creates a response to parse from RebuildAppEnv response
func CreateRebuildAppEnvResponse() (response *RebuildAppEnvResponse) {
	response = &RebuildAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
