//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresources_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/resources/armresources"
)

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtScope.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginCreateOrUpdateAtScope(ctx,
		"<scope>",
		"<deployment-name>",
		armresources.Deployment{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentProperties{
				Mode:       armresources.DeploymentModeIncremental.ToPtr(),
				Parameters: map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{
					URI: to.StringPtr("<uri>"),
				},
			},
			Tags: map[string]*string{
				"tagKey1": to.StringPtr("tag-value-1"),
				"tagKey2": to.StringPtr("tag-value-2"),
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCreateOrUpdateAtScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtTenant.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtTenantScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginCreateOrUpdateAtTenantScope(ctx,
		"<deployment-name>",
		armresources.ScopedDeployment{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentProperties{
				Mode:       armresources.DeploymentModeIncremental.ToPtr(),
				Parameters: map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{
					URI: to.StringPtr("<uri>"),
				},
			},
			Tags: map[string]*string{
				"tagKey1": to.StringPtr("tag-value-1"),
				"tagKey2": to.StringPtr("tag-value-2"),
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCreateOrUpdateAtTenantScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnTenant.json
func ExampleDeploymentsClient_BeginWhatIfAtTenantScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginWhatIfAtTenantScope(ctx,
		"<deployment-name>",
		armresources.ScopedDeploymentWhatIf{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentWhatIfProperties{
				Mode:         armresources.DeploymentModeIncremental.ToPtr(),
				Parameters:   map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientWhatIfAtTenantScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentAtManagementGroup.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginCreateOrUpdateAtManagementGroupScope(ctx,
		"<group-id>",
		"<deployment-name>",
		armresources.ScopedDeployment{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentProperties{
				Mode:       armresources.DeploymentModeIncremental.ToPtr(),
				Parameters: map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{
					URI: to.StringPtr("<uri>"),
				},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCreateOrUpdateAtManagementGroupScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnManagementGroup.json
func ExampleDeploymentsClient_BeginWhatIfAtManagementGroupScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginWhatIfAtManagementGroupScope(ctx,
		"<group-id>",
		"<deployment-name>",
		armresources.ScopedDeploymentWhatIf{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentWhatIfProperties{
				Mode:         armresources.DeploymentModeIncremental.ToPtr(),
				Parameters:   map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientWhatIfAtManagementGroupScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentSubscriptionTemplateSpecsWithId.json
func ExampleDeploymentsClient_BeginCreateOrUpdateAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginCreateOrUpdateAtSubscriptionScope(ctx,
		"<deployment-name>",
		armresources.Deployment{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentProperties{
				Mode:       armresources.DeploymentModeIncremental.ToPtr(),
				Parameters: map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{
					ID: to.StringPtr("<id>"),
				},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCreateOrUpdateAtSubscriptionScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnSubscription.json
func ExampleDeploymentsClient_BeginWhatIfAtSubscriptionScope() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginWhatIfAtSubscriptionScope(ctx,
		"<deployment-name>",
		armresources.DeploymentWhatIf{
			Location: to.StringPtr("<location>"),
			Properties: &armresources.DeploymentWhatIfProperties{
				Mode:         armresources.DeploymentModeIncremental.ToPtr(),
				Parameters:   map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientWhatIfAtSubscriptionScopeResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PutDeploymentResourceGroup.json
func ExampleDeploymentsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginCreateOrUpdate(ctx,
		"<resource-group-name>",
		"<deployment-name>",
		armresources.Deployment{
			Properties: &armresources.DeploymentProperties{
				Mode:       armresources.DeploymentModeIncremental.ToPtr(),
				Parameters: map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{
					QueryString: to.StringPtr("<query-string>"),
					URI:         to.StringPtr("<uri>"),
				},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCreateOrUpdateResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/PostDeploymentWhatIfOnResourceGroup.json
func ExampleDeploymentsClient_BeginWhatIf() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	poller, err := client.BeginWhatIf(ctx,
		"<resource-group-name>",
		"<deployment-name>",
		armresources.DeploymentWhatIf{
			Properties: &armresources.DeploymentWhatIfProperties{
				Mode:         armresources.DeploymentModeIncremental.ToPtr(),
				Parameters:   map[string]interface{}{},
				TemplateLink: &armresources.TemplateLink{},
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	res, err := poller.PollUntilDone(ctx, 30*time.Second)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientWhatIfResult)
}

// x-ms-original-file: specification/resources/resource-manager/Microsoft.Resources/stable/2021-04-01/examples/CalculateTemplateHash.json
func ExampleDeploymentsClient_CalculateTemplateHash() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	client := armresources.NewDeploymentsClient("<subscription-id>", cred, nil)
	res, err := client.CalculateTemplateHash(ctx,
		map[string]interface{}{
			"$schema":        "http://schemas.management.azure.com/deploymentTemplate?api-version=2014-04-01-preview",
			"contentVersion": "1.0.0.0",
			"outputs": map[string]interface{}{
				"string": map[string]interface{}{
					"type":  "string",
					"value": "myvalue",
				},
			},
			"parameters": map[string]interface{}{
				"string": map[string]interface{}{
					"type": "string",
				},
			},
			"resources": []interface{}{},
			"variables": map[string]interface{}{
				"array": []interface{}{
					float64(1),
					float64(2),
					float64(3),
					float64(4),
				},
				"bool": true,
				"int":  float64(42),
				"object": map[string]interface{}{
					"object": map[string]interface{}{
						"location": "West US",
						"vmSize":   "Large",
					},
				},
				"string": "string",
			},
		},
		nil)
	if err != nil {
		log.Fatal(err)
	}
	log.Printf("Response result: %#v\n", res.DeploymentsClientCalculateTemplateHashResult)
}
