//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresources

import (
	"encoding/json"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
	"time"
)

type APIProfile struct {
	// READ-ONLY; The API version.
	APIVersion *string `json:"apiVersion,omitempty" azure:"ro"`

	// READ-ONLY; The profile version.
	ProfileVersion *string `json:"profileVersion,omitempty" azure:"ro"`
}

// Alias - The alias type.
type Alias struct {
	// The default path for an alias.
	DefaultPath *string `json:"defaultPath,omitempty"`

	// The default pattern for an alias.
	DefaultPattern *AliasPattern `json:"defaultPattern,omitempty"`

	// The alias name.
	Name *string `json:"name,omitempty"`

	// The paths for an alias.
	Paths []*AliasPath `json:"paths,omitempty"`

	// The type of the alias.
	Type *AliasType `json:"type,omitempty"`

	// READ-ONLY; The default alias path metadata. Applies to the default path and to any alias path that doesn't have metadata
	DefaultMetadata *AliasPathMetadata `json:"defaultMetadata,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Alias.
func (a Alias) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "defaultMetadata", a.DefaultMetadata)
	populate(objectMap, "defaultPath", a.DefaultPath)
	populate(objectMap, "defaultPattern", a.DefaultPattern)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "paths", a.Paths)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// AliasPath - The type of the paths for alias.
type AliasPath struct {
	// The API versions.
	APIVersions []*string `json:"apiVersions,omitempty"`

	// The path of an alias.
	Path *string `json:"path,omitempty"`

	// The pattern for an alias path.
	Pattern *AliasPattern `json:"pattern,omitempty"`

	// READ-ONLY; The metadata of the alias path. If missing, fall back to the default metadata of the alias.
	Metadata *AliasPathMetadata `json:"metadata,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type AliasPath.
func (a AliasPath) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiVersions", a.APIVersions)
	populate(objectMap, "metadata", a.Metadata)
	populate(objectMap, "path", a.Path)
	populate(objectMap, "pattern", a.Pattern)
	return json.Marshal(objectMap)
}

type AliasPathMetadata struct {
	// READ-ONLY; The attributes of the token that the alias path is referring to.
	Attributes *AliasPathAttributes `json:"attributes,omitempty" azure:"ro"`

	// READ-ONLY; The type of the token that the alias path is referring to.
	Type *AliasPathTokenType `json:"type,omitempty" azure:"ro"`
}

// AliasPattern - The type of the pattern for an alias path.
type AliasPattern struct {
	// The alias pattern phrase.
	Phrase *string `json:"phrase,omitempty"`

	// The type of alias pattern
	Type *AliasPatternType `json:"type,omitempty"`

	// The alias pattern variable.
	Variable *string `json:"variable,omitempty"`
}

// BasicDependency - Deployment dependency information.
type BasicDependency struct {
	// The ID of the dependency.
	ID *string `json:"id,omitempty"`

	// The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`

	// The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// ClientBeginCreateOrUpdateByIDOptions contains the optional parameters for the Client.BeginCreateOrUpdateByID method.
type ClientBeginCreateOrUpdateByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginCreateOrUpdateOptions contains the optional parameters for the Client.BeginCreateOrUpdate method.
type ClientBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginDeleteByIDOptions contains the optional parameters for the Client.BeginDeleteByID method.
type ClientBeginDeleteByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginDeleteOptions contains the optional parameters for the Client.BeginDelete method.
type ClientBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginMoveResourcesOptions contains the optional parameters for the Client.BeginMoveResources method.
type ClientBeginMoveResourcesOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginUpdateByIDOptions contains the optional parameters for the Client.BeginUpdateByID method.
type ClientBeginUpdateByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginUpdateOptions contains the optional parameters for the Client.BeginUpdate method.
type ClientBeginUpdateOptions struct {
	// placeholder for future optional parameters
}

// ClientBeginValidateMoveResourcesOptions contains the optional parameters for the Client.BeginValidateMoveResources method.
type ClientBeginValidateMoveResourcesOptions struct {
	// placeholder for future optional parameters
}

// ClientCheckExistenceByIDOptions contains the optional parameters for the Client.CheckExistenceByID method.
type ClientCheckExistenceByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientCheckExistenceOptions contains the optional parameters for the Client.CheckExistence method.
type ClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// ClientGetByIDOptions contains the optional parameters for the Client.GetByID method.
type ClientGetByIDOptions struct {
	// placeholder for future optional parameters
}

// ClientGetOptions contains the optional parameters for the Client.Get method.
type ClientGetOptions struct {
	// placeholder for future optional parameters
}

// ClientListByResourceGroupOptions contains the optional parameters for the Client.ListByResourceGroup method.
type ClientListByResourceGroupOptions struct {
	// Comma-separated list of additional properties to be included in the response. Valid values include createdTime, changedTime
	// and provisioningState. For example, $expand=createdTime,changedTime.
	Expand *string
	// The filter to apply on the operation.
	// The properties you can use for eq (equals) or ne (not equals) are: location, resourceType, name, resourceGroup, identity,
	// identity/principalId, plan, plan/publisher, plan/product, plan/name,
	// plan/version, and plan/promotionCode.
	// For example, to filter by a resource type, use: $filter=resourceType eq 'Microsoft.Network/virtualNetworks'
	// You can use substringof(value, property) in the filter. The properties you can use for substring are: name and resourceGroup.
	// For example, to get all resources with 'demo' anywhere in the name, use: $filter=substringof('demo', name)
	// You can link more than one substringof together by adding and/or operators.
	// You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1'
	// and tagValue eq 'Value1'. When you filter by a tag name and value, the tags for
	// each resource are not returned in the results.
	// You can use some properties together when filtering. The combinations you can use are: substringof and/or resourceType,
	// plan and plan/publisher and plan/name, identity and identity/principalId.
	Filter *string
	// The number of results to return. If null is passed, returns all resources.
	Top *int32
}

// ClientListOptions contains the optional parameters for the Client.List method.
type ClientListOptions struct {
	// Comma-separated list of additional properties to be included in the response. Valid values include createdTime, changedTime
	// and provisioningState. For example, $expand=createdTime,changedTime.
	Expand *string
	// The filter to apply on the operation.
	// Filter comparison operators include eq (equals) and ne (not equals) and may be used with the following properties: location,
	// resourceType, name, resourceGroup, identity, identity/principalId, plan,
	// plan/publisher, plan/product, plan/name, plan/version, and plan/promotionCode.
	// For example, to filter by a resource type, use $filter=resourceType eq 'Microsoft.Network/virtualNetworks'
	// substringof(value, property) can be used to filter for substrings of the following currently-supported properties: name
	// and resourceGroup
	// For example, to get all resources with 'demo' anywhere in the resource name, use $filter=substringof('demo', name)
	// Multiple substring operations can also be combined using and/or operators.
	// Note that any truncated number of results queried via $top may also not be compatible when using a filter.
	// Resources can be filtered by tag names and values. For example, to filter for a tag name and value, use $filter=tagName
	// eq 'tag1' and tagValue eq 'Value1'. Note that when resources are filtered by tag
	// name and value, the original tags for each resource will not be returned in the results. Any list of additional properties
	// queried via $expand may also not be compatible when filtering by tag
	// names/values.
	// For tag names only, resources can be filtered by prefix using the following syntax: $filter=startswith(tagName, 'depart').
	// This query will return all resources with a tag name prefixed by the phrase
	// depart (i.e.department, departureDate, departureTime, etc.)
	// Note that some properties can be combined when filtering resources, which include the following: substringof() and/or resourceType,
	// plan and plan/publisher and plan/name, and identity and
	// identity/principalId.
	Filter *string
	// The number of results to return. If null is passed, returns all resources.
	Top *int32
}

// CloudError - An error response for a resource management request.
type CloudError struct {
	// Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows
	// the OData error response format.)
	Error *ErrorResponse `json:"error,omitempty"`
}

// DebugSetting - The debug setting.
type DebugSetting struct {
	// Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent,
	// or both requestContent and responseContent separated by a comma. The default is
	// none. When setting this value, carefully consider the type of information you are passing in during deployment. By logging
	// information about the request or response, you could potentially expose
	// sensitive data that is retrieved through the deployment operations.
	DetailLevel *string `json:"detailLevel,omitempty"`
}

// Dependency - Deployment dependency information.
type Dependency struct {
	// The list of dependencies.
	DependsOn []*BasicDependency `json:"dependsOn,omitempty"`

	// The ID of the dependency.
	ID *string `json:"id,omitempty"`

	// The dependency resource name.
	ResourceName *string `json:"resourceName,omitempty"`

	// The dependency resource type.
	ResourceType *string `json:"resourceType,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Dependency.
func (d Dependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "dependsOn", d.DependsOn)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "resourceName", d.ResourceName)
	populate(objectMap, "resourceType", d.ResourceType)
	return json.Marshal(objectMap)
}

// Deployment operation parameters.
type Deployment struct {
	// REQUIRED; The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Deployment.
func (d Deployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", d.Location)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	return json.Marshal(objectMap)
}

// DeploymentExportResult - The deployment export result.
type DeploymentExportResult struct {
	// The template content.
	Template map[string]interface{} `json:"template,omitempty"`
}

// DeploymentExtended - Deployment information.
type DeploymentExtended struct {
	// the location of the deployment.
	Location *string `json:"location,omitempty"`

	// Deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the deployment.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the deployment.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the deployment.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentExtended.
func (d DeploymentExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", d.ID)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "tags", d.Tags)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// DeploymentExtendedFilter - Deployment filter.
type DeploymentExtendedFilter struct {
	// The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty"`
}

// DeploymentListResult - List of deployments.
type DeploymentListResult struct {
	// An array of deployments.
	Value []*DeploymentExtended `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentListResult.
func (d DeploymentListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DeploymentOperation - Deployment operation information.
type DeploymentOperation struct {
	// Deployment properties.
	Properties *DeploymentOperationProperties `json:"properties,omitempty"`

	// READ-ONLY; Full deployment operation ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Deployment operation ID.
	OperationID *string `json:"operationId,omitempty" azure:"ro"`
}

// DeploymentOperationProperties - Deployment operation properties.
type DeploymentOperationProperties struct {
	// READ-ONLY; The duration of the operation.
	Duration *string `json:"duration,omitempty" azure:"ro"`

	// READ-ONLY; The name of the current provisioning operation.
	ProvisioningOperation *ProvisioningOperation `json:"provisioningOperation,omitempty" azure:"ro"`

	// READ-ONLY; The state of the provisioning.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The HTTP request message.
	Request *HTTPMessage `json:"request,omitempty" azure:"ro"`

	// READ-ONLY; The HTTP response message.
	Response *HTTPMessage `json:"response,omitempty" azure:"ro"`

	// READ-ONLY; Deployment operation service request id.
	ServiceRequestID *string `json:"serviceRequestId,omitempty" azure:"ro"`

	// READ-ONLY; Operation status code from the resource provider. This property may not be set if a response has not yet been
	// received.
	StatusCode *string `json:"statusCode,omitempty" azure:"ro"`

	// READ-ONLY; Operation status message from the resource provider. This property is optional. It will only be provided if
	// an error was received from the resource provider.
	StatusMessage *StatusMessage `json:"statusMessage,omitempty" azure:"ro"`

	// READ-ONLY; The target resource.
	TargetResource *TargetResource `json:"targetResource,omitempty" azure:"ro"`

	// READ-ONLY; The date and time of the operation.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentOperationProperties.
func (d DeploymentOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "duration", d.Duration)
	populate(objectMap, "provisioningOperation", d.ProvisioningOperation)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "request", d.Request)
	populate(objectMap, "response", d.Response)
	populate(objectMap, "serviceRequestId", d.ServiceRequestID)
	populate(objectMap, "statusCode", d.StatusCode)
	populate(objectMap, "statusMessage", d.StatusMessage)
	populate(objectMap, "targetResource", d.TargetResource)
	populateTimeRFC3339(objectMap, "timestamp", d.Timestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentOperationProperties.
func (d *DeploymentOperationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "duration":
			err = unpopulate(val, &d.Duration)
			delete(rawMsg, key)
		case "provisioningOperation":
			err = unpopulate(val, &d.ProvisioningOperation)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &d.ProvisioningState)
			delete(rawMsg, key)
		case "request":
			err = unpopulate(val, &d.Request)
			delete(rawMsg, key)
		case "response":
			err = unpopulate(val, &d.Response)
			delete(rawMsg, key)
		case "serviceRequestId":
			err = unpopulate(val, &d.ServiceRequestID)
			delete(rawMsg, key)
		case "statusCode":
			err = unpopulate(val, &d.StatusCode)
			delete(rawMsg, key)
		case "statusMessage":
			err = unpopulate(val, &d.StatusMessage)
			delete(rawMsg, key)
		case "targetResource":
			err = unpopulate(val, &d.TargetResource)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, &d.Timestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DeploymentOperationsClientGetAtManagementGroupScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtManagementGroupScope
// method.
type DeploymentOperationsClientGetAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtScope
// method.
type DeploymentOperationsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtSubscriptionScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtSubscriptionScope
// method.
type DeploymentOperationsClientGetAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetAtTenantScopeOptions contains the optional parameters for the DeploymentOperationsClient.GetAtTenantScope
// method.
type DeploymentOperationsClientGetAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientGetOptions contains the optional parameters for the DeploymentOperationsClient.Get method.
type DeploymentOperationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentOperationsClientListAtManagementGroupScopeOptions contains the optional parameters for the DeploymentOperationsClient.ListAtManagementGroupScope
// method.
type DeploymentOperationsClientListAtManagementGroupScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtScopeOptions contains the optional parameters for the DeploymentOperationsClient.ListAtScope
// method.
type DeploymentOperationsClientListAtScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtSubscriptionScopeOptions contains the optional parameters for the DeploymentOperationsClient.ListAtSubscriptionScope
// method.
type DeploymentOperationsClientListAtSubscriptionScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListAtTenantScopeOptions contains the optional parameters for the DeploymentOperationsClient.ListAtTenantScope
// method.
type DeploymentOperationsClientListAtTenantScopeOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsClientListOptions contains the optional parameters for the DeploymentOperationsClient.List method.
type DeploymentOperationsClientListOptions struct {
	// The number of results to return.
	Top *int32
}

// DeploymentOperationsListResult - List of deployment operations.
type DeploymentOperationsListResult struct {
	// An array of deployment operations.
	Value []*DeploymentOperation `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentOperationsListResult.
func (d DeploymentOperationsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// DeploymentProperties - Deployment properties.
type DeploymentProperties struct {
	// REQUIRED; The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode,
	// resources are deployed without deleting existing resources that are not included in
	// the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included
	// in the template are deleted. Be careful when using Complete mode as you may
	// unintentionally delete resources.
	Mode *DeploymentMode `json:"mode,omitempty"`

	// The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`

	// Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable
	// to nested templates. If not specified, default value is outer.
	ExpressionEvaluationOptions *ExpressionEvaluationOptions `json:"expressionEvaluationOptions,omitempty"`

	// The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`

	// Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide
	// the parameter values directly in the request rather than link to an existing
	// parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or
	// a well formed JSON string.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink
	// property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`

	// The template content. You use this element when you want to pass the template syntax directly in the request rather than
	// link to an existing template. It can be a JObject or well-formed JSON string.
	// Use either the templateLink property or the template property, but not both.
	Template map[string]interface{} `json:"template,omitempty"`

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`
}

// DeploymentPropertiesExtended - Deployment properties with additional details.
type DeploymentPropertiesExtended struct {
	// READ-ONLY; The correlation ID of the deployment.
	CorrelationID *string `json:"correlationId,omitempty" azure:"ro"`

	// READ-ONLY; The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty" azure:"ro"`

	// READ-ONLY; The list of deployment dependencies.
	Dependencies []*Dependency `json:"dependencies,omitempty" azure:"ro"`

	// READ-ONLY; The duration of the template deployment.
	Duration *string `json:"duration,omitempty" azure:"ro"`

	// READ-ONLY; The deployment error.
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`

	// READ-ONLY; The deployment mode. Possible values are Incremental and Complete.
	Mode *DeploymentMode `json:"mode,omitempty" azure:"ro"`

	// READ-ONLY; The deployment on error behavior.
	OnErrorDeployment *OnErrorDeploymentExtended `json:"onErrorDeployment,omitempty" azure:"ro"`

	// READ-ONLY; Array of provisioned resources.
	OutputResources []*ResourceReference `json:"outputResources,omitempty" azure:"ro"`

	// READ-ONLY; Key/value pairs that represent deployment output.
	Outputs map[string]interface{} `json:"outputs,omitempty" azure:"ro"`

	// READ-ONLY; Deployment parameters.
	Parameters map[string]interface{} `json:"parameters,omitempty" azure:"ro"`

	// READ-ONLY; The URI referencing the parameters.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty" azure:"ro"`

	// READ-ONLY; The list of resource providers needed for the deployment.
	Providers []*Provider `json:"providers,omitempty" azure:"ro"`

	// READ-ONLY; Denotes the state of provisioning.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; The hash produced for the template.
	TemplateHash *string `json:"templateHash,omitempty" azure:"ro"`

	// READ-ONLY; The URI referencing the template.
	TemplateLink *TemplateLink `json:"templateLink,omitempty" azure:"ro"`

	// READ-ONLY; The timestamp of the template deployment.
	Timestamp *time.Time `json:"timestamp,omitempty" azure:"ro"`

	// READ-ONLY; Array of validated resources.
	ValidatedResources []*ResourceReference `json:"validatedResources,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentPropertiesExtended.
func (d DeploymentPropertiesExtended) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "correlationId", d.CorrelationID)
	populate(objectMap, "debugSetting", d.DebugSetting)
	populate(objectMap, "dependencies", d.Dependencies)
	populate(objectMap, "duration", d.Duration)
	populate(objectMap, "error", d.Error)
	populate(objectMap, "mode", d.Mode)
	populate(objectMap, "onErrorDeployment", d.OnErrorDeployment)
	populate(objectMap, "outputResources", d.OutputResources)
	populate(objectMap, "outputs", d.Outputs)
	populate(objectMap, "parameters", d.Parameters)
	populate(objectMap, "parametersLink", d.ParametersLink)
	populate(objectMap, "providers", d.Providers)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "templateHash", d.TemplateHash)
	populate(objectMap, "templateLink", d.TemplateLink)
	populateTimeRFC3339(objectMap, "timestamp", d.Timestamp)
	populate(objectMap, "validatedResources", d.ValidatedResources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentPropertiesExtended.
func (d *DeploymentPropertiesExtended) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, &d.CorrelationID)
			delete(rawMsg, key)
		case "debugSetting":
			err = unpopulate(val, &d.DebugSetting)
			delete(rawMsg, key)
		case "dependencies":
			err = unpopulate(val, &d.Dependencies)
			delete(rawMsg, key)
		case "duration":
			err = unpopulate(val, &d.Duration)
			delete(rawMsg, key)
		case "error":
			err = unpopulate(val, &d.Error)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, &d.Mode)
			delete(rawMsg, key)
		case "onErrorDeployment":
			err = unpopulate(val, &d.OnErrorDeployment)
			delete(rawMsg, key)
		case "outputResources":
			err = unpopulate(val, &d.OutputResources)
			delete(rawMsg, key)
		case "outputs":
			err = unpopulate(val, &d.Outputs)
			delete(rawMsg, key)
		case "parameters":
			err = unpopulate(val, &d.Parameters)
			delete(rawMsg, key)
		case "parametersLink":
			err = unpopulate(val, &d.ParametersLink)
			delete(rawMsg, key)
		case "providers":
			err = unpopulate(val, &d.Providers)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &d.ProvisioningState)
			delete(rawMsg, key)
		case "templateHash":
			err = unpopulate(val, &d.TemplateHash)
			delete(rawMsg, key)
		case "templateLink":
			err = unpopulate(val, &d.TemplateLink)
			delete(rawMsg, key)
		case "timestamp":
			err = unpopulateTimeRFC3339(val, &d.Timestamp)
			delete(rawMsg, key)
		case "validatedResources":
			err = unpopulate(val, &d.ValidatedResources)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// DeploymentValidateResult - Information from validate template deployment response.
type DeploymentValidateResult struct {
	// The template deployment properties.
	Properties *DeploymentPropertiesExtended `json:"properties,omitempty"`

	// READ-ONLY; The deployment validation error.
	Error *ErrorResponse `json:"error,omitempty" azure:"ro"`
}

// DeploymentWhatIf - Deployment What-if operation parameters.
type DeploymentWhatIf struct {
	// REQUIRED; The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`

	// The location to store the deployment data.
	Location *string `json:"location,omitempty"`
}

// DeploymentWhatIfProperties - Deployment What-if properties.
type DeploymentWhatIfProperties struct {
	// REQUIRED; The mode that is used to deploy resources. This value can be either Incremental or Complete. In Incremental mode,
	// resources are deployed without deleting existing resources that are not included in
	// the template. In Complete mode, resources are deployed and existing resources in the resource group that are not included
	// in the template are deleted. Be careful when using Complete mode as you may
	// unintentionally delete resources.
	Mode *DeploymentMode `json:"mode,omitempty"`

	// The debug setting of the deployment.
	DebugSetting *DebugSetting `json:"debugSetting,omitempty"`

	// Specifies whether template expressions are evaluated within the scope of the parent template or nested template. Only applicable
	// to nested templates. If not specified, default value is outer.
	ExpressionEvaluationOptions *ExpressionEvaluationOptions `json:"expressionEvaluationOptions,omitempty"`

	// The deployment on error behavior.
	OnErrorDeployment *OnErrorDeployment `json:"onErrorDeployment,omitempty"`

	// Name and value pairs that define the deployment parameters for the template. You use this element when you want to provide
	// the parameter values directly in the request rather than link to an existing
	// parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or
	// a well formed JSON string.
	Parameters map[string]interface{} `json:"parameters,omitempty"`

	// The URI of parameters file. You use this element to link to an existing parameters file. Use either the parametersLink
	// property or the parameters property, but not both.
	ParametersLink *ParametersLink `json:"parametersLink,omitempty"`

	// The template content. You use this element when you want to pass the template syntax directly in the request rather than
	// link to an existing template. It can be a JObject or well-formed JSON string.
	// Use either the templateLink property or the template property, but not both.
	Template map[string]interface{} `json:"template,omitempty"`

	// The URI of the template. Use either the templateLink property or the template property, but not both.
	TemplateLink *TemplateLink `json:"templateLink,omitempty"`

	// Optional What-If operation settings.
	WhatIfSettings *DeploymentWhatIfSettings `json:"whatIfSettings,omitempty"`
}

// DeploymentWhatIfSettings - Deployment What-If operation settings.
type DeploymentWhatIfSettings struct {
	// The format of the What-If results
	ResultFormat *WhatIfResultFormat `json:"resultFormat,omitempty"`
}

// DeploymentsClientBeginCreateOrUpdateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtManagementGroupScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginCreateOrUpdateAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginCreateOrUpdateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtSubscriptionScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginCreateOrUpdateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdateAtTenantScope
// method.
type DeploymentsClientBeginCreateOrUpdateAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginCreateOrUpdateOptions contains the optional parameters for the DeploymentsClient.BeginCreateOrUpdate
// method.
type DeploymentsClientBeginCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginDeleteAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtManagementGroupScope
// method.
type DeploymentsClientBeginDeleteAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginDeleteAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtScope
// method.
type DeploymentsClientBeginDeleteAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginDeleteAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtSubscriptionScope
// method.
type DeploymentsClientBeginDeleteAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginDeleteAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginDeleteAtTenantScope
// method.
type DeploymentsClientBeginDeleteAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginDeleteOptions contains the optional parameters for the DeploymentsClient.BeginDelete method.
type DeploymentsClientBeginDeleteOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginValidateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtManagementGroupScope
// method.
type DeploymentsClientBeginValidateAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginValidateAtScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtScope
// method.
type DeploymentsClientBeginValidateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginValidateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtSubscriptionScope
// method.
type DeploymentsClientBeginValidateAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginValidateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginValidateAtTenantScope
// method.
type DeploymentsClientBeginValidateAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginValidateOptions contains the optional parameters for the DeploymentsClient.BeginValidate method.
type DeploymentsClientBeginValidateOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginWhatIfAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtManagementGroupScope
// method.
type DeploymentsClientBeginWhatIfAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginWhatIfAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtSubscriptionScope
// method.
type DeploymentsClientBeginWhatIfAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginWhatIfAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.BeginWhatIfAtTenantScope
// method.
type DeploymentsClientBeginWhatIfAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientBeginWhatIfOptions contains the optional parameters for the DeploymentsClient.BeginWhatIf method.
type DeploymentsClientBeginWhatIfOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCalculateTemplateHashOptions contains the optional parameters for the DeploymentsClient.CalculateTemplateHash
// method.
type DeploymentsClientCalculateTemplateHashOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtManagementGroupScope
// method.
type DeploymentsClientCancelAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtScope method.
type DeploymentsClientCancelAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtSubscriptionScope
// method.
type DeploymentsClientCancelAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.CancelAtTenantScope
// method.
type DeploymentsClientCancelAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCancelOptions contains the optional parameters for the DeploymentsClient.Cancel method.
type DeploymentsClientCancelOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtManagementGroupScope
// method.
type DeploymentsClientCheckExistenceAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtScope
// method.
type DeploymentsClientCheckExistenceAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtSubscriptionScope
// method.
type DeploymentsClientCheckExistenceAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.CheckExistenceAtTenantScope
// method.
type DeploymentsClientCheckExistenceAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientCheckExistenceOptions contains the optional parameters for the DeploymentsClient.CheckExistence method.
type DeploymentsClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtManagementGroupScope
// method.
type DeploymentsClientExportTemplateAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtScope
// method.
type DeploymentsClientExportTemplateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtSubscriptionScope
// method.
type DeploymentsClientExportTemplateAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.ExportTemplateAtTenantScope
// method.
type DeploymentsClientExportTemplateAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientExportTemplateOptions contains the optional parameters for the DeploymentsClient.ExportTemplate method.
type DeploymentsClientExportTemplateOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.GetAtManagementGroupScope
// method.
type DeploymentsClientGetAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtScopeOptions contains the optional parameters for the DeploymentsClient.GetAtScope method.
type DeploymentsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.GetAtSubscriptionScope
// method.
type DeploymentsClientGetAtSubscriptionScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.GetAtTenantScope method.
type DeploymentsClientGetAtTenantScopeOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientGetOptions contains the optional parameters for the DeploymentsClient.Get method.
type DeploymentsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DeploymentsClientListAtManagementGroupScopeOptions contains the optional parameters for the DeploymentsClient.ListAtManagementGroupScope
// method.
type DeploymentsClientListAtManagementGroupScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtScopeOptions contains the optional parameters for the DeploymentsClient.ListAtScope method.
type DeploymentsClientListAtScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtSubscriptionScopeOptions contains the optional parameters for the DeploymentsClient.ListAtSubscriptionScope
// method.
type DeploymentsClientListAtSubscriptionScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListAtTenantScopeOptions contains the optional parameters for the DeploymentsClient.ListAtTenantScope
// method.
type DeploymentsClientListAtTenantScopeOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// DeploymentsClientListByResourceGroupOptions contains the optional parameters for the DeploymentsClient.ListByResourceGroup
// method.
type DeploymentsClientListByResourceGroupOptions struct {
	// The filter to apply on the operation. For example, you can use $filter=provisioningState eq '{state}'.
	Filter *string
	// The number of results to get. If null is passed, returns all deployments.
	Top *int32
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info map[string]interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.)
type ErrorResponse struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorResponse `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// ExportTemplateRequest - Export resource group template request parameters.
type ExportTemplateRequest struct {
	// The export template options. A CSV-formatted list containing zero or more of the following: 'IncludeParameterDefaultValue',
	// 'IncludeComments', 'SkipResourceNameParameterization',
	// 'SkipAllParameterization'
	Options *string `json:"options,omitempty"`

	// The IDs of the resources to filter the export by. To export all resources, supply an array with single entry '*'.
	Resources []*string `json:"resources,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ExportTemplateRequest.
func (e ExportTemplateRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "options", e.Options)
	populate(objectMap, "resources", e.Resources)
	return json.Marshal(objectMap)
}

// ExpressionEvaluationOptions - Specifies whether template expressions are evaluated within the scope of the parent template
// or nested template.
type ExpressionEvaluationOptions struct {
	// The scope to be used for evaluation of parameters, variables and functions in a nested template.
	Scope *ExpressionEvaluationOptionsScopeType `json:"scope,omitempty"`
}

// ExtendedLocation - Resource extended location.
type ExtendedLocation struct {
	// The extended location name.
	Name *string `json:"name,omitempty"`

	// The extended location type.
	Type *ExtendedLocationType `json:"type,omitempty"`
}

// GenericResource - Resource information.
type GenericResource struct {
	// Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`

	// The resource properties.
	Properties map[string]interface{} `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type GenericResource.
func (g GenericResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", g.ExtendedLocation)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "identity", g.Identity)
	populate(objectMap, "kind", g.Kind)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "managedBy", g.ManagedBy)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "plan", g.Plan)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// GenericResourceExpanded - Resource information.
type GenericResourceExpanded struct {
	// Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The kind of the resource.
	Kind *string `json:"kind,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// ID of the resource that manages this resource.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The plan of the resource.
	Plan *Plan `json:"plan,omitempty"`

	// The resource properties.
	Properties map[string]interface{} `json:"properties,omitempty"`

	// The SKU of the resource.
	SKU *SKU `json:"sku,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The changed time of the resource. This is only present if requested via the $expand query parameter.
	ChangedTime *time.Time `json:"changedTime,omitempty" azure:"ro"`

	// READ-ONLY; The created time of the resource. This is only present if requested via the $expand query parameter.
	CreatedTime *time.Time `json:"createdTime,omitempty" azure:"ro"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The provisioning state of the resource. This is only present if requested via the $expand query parameter.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type GenericResourceExpanded.
func (g GenericResourceExpanded) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populateTimeRFC3339(objectMap, "changedTime", g.ChangedTime)
	populateTimeRFC3339(objectMap, "createdTime", g.CreatedTime)
	populate(objectMap, "extendedLocation", g.ExtendedLocation)
	populate(objectMap, "id", g.ID)
	populate(objectMap, "identity", g.Identity)
	populate(objectMap, "kind", g.Kind)
	populate(objectMap, "location", g.Location)
	populate(objectMap, "managedBy", g.ManagedBy)
	populate(objectMap, "name", g.Name)
	populate(objectMap, "plan", g.Plan)
	populate(objectMap, "properties", g.Properties)
	populate(objectMap, "provisioningState", g.ProvisioningState)
	populate(objectMap, "sku", g.SKU)
	populate(objectMap, "tags", g.Tags)
	populate(objectMap, "type", g.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GenericResourceExpanded.
func (g *GenericResourceExpanded) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return err
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "changedTime":
			err = unpopulateTimeRFC3339(val, &g.ChangedTime)
			delete(rawMsg, key)
		case "createdTime":
			err = unpopulateTimeRFC3339(val, &g.CreatedTime)
			delete(rawMsg, key)
		case "extendedLocation":
			err = unpopulate(val, &g.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, &g.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, &g.Identity)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, &g.Kind)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, &g.Location)
			delete(rawMsg, key)
		case "managedBy":
			err = unpopulate(val, &g.ManagedBy)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, &g.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, &g.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, &g.Properties)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, &g.ProvisioningState)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, &g.SKU)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, &g.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, &g.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return err
		}
	}
	return nil
}

// GenericResourceFilter - Resource filter.
type GenericResourceFilter struct {
	// The resource type.
	ResourceType *string `json:"resourceType,omitempty"`

	// The tag name.
	Tagname *string `json:"tagname,omitempty"`

	// The tag value.
	Tagvalue *string `json:"tagvalue,omitempty"`
}

// HTTPMessage - HTTP message.
type HTTPMessage struct {
	// HTTP message content.
	Content map[string]interface{} `json:"content,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource. The user identity dictionary key references will be ARM resource
	// ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
	UserAssignedIdentities map[string]*IdentityUserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	populate(objectMap, "type", i.Type)
	populate(objectMap, "userAssignedIdentities", i.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

type IdentityUserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}

// MoveInfo - Parameters of move resources.
type MoveInfo struct {
	// The IDs of the resources.
	Resources []*string `json:"resources,omitempty"`

	// The target resource group.
	TargetResourceGroup *string `json:"targetResourceGroup,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type MoveInfo.
func (m MoveInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "resources", m.Resources)
	populate(objectMap, "targetResourceGroup", m.TargetResourceGroup)
	return json.Marshal(objectMap)
}

// OnErrorDeployment - Deployment on error behavior.
type OnErrorDeployment struct {
	// The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`

	// The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
	Type *OnErrorDeploymentType `json:"type,omitempty"`
}

// OnErrorDeploymentExtended - Deployment on error behavior with additional details.
type OnErrorDeploymentExtended struct {
	// The deployment to be used on error case.
	DeploymentName *string `json:"deploymentName,omitempty"`

	// The deployment on error behavior type. Possible values are LastSuccessful and SpecificDeployment.
	Type *OnErrorDeploymentType `json:"type,omitempty"`

	// READ-ONLY; The state of the provisioning for the on error deployment.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// Operation - Microsoft.Resources operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation.
	Description *string `json:"description,omitempty"`

	// Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.Resources
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed: Profile, endpoint, etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Microsoft.Resources operations. It contains a list of operations and
// a URL link to get the next set of results.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Microsoft.Resources operations.
	Value []*Operation `json:"value,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ParametersLink - Entity representing the reference to the deployment parameters.
type ParametersLink struct {
	// REQUIRED; The URI of the parameters file.
	URI *string `json:"uri,omitempty"`

	// If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`
}

// Permission - Role definition permissions.
type Permission struct {
	// Allowed actions.
	Actions []*string `json:"actions,omitempty"`

	// Allowed Data actions.
	DataActions []*string `json:"dataActions,omitempty"`

	// Denied actions.
	NotActions []*string `json:"notActions,omitempty"`

	// Denied Data actions.
	NotDataActions []*string `json:"notDataActions,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Permission.
func (p Permission) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "actions", p.Actions)
	populate(objectMap, "dataActions", p.DataActions)
	populate(objectMap, "notActions", p.NotActions)
	populate(objectMap, "notDataActions", p.NotDataActions)
	return json.Marshal(objectMap)
}

// Plan for the resource.
type Plan struct {
	// The plan ID.
	Name *string `json:"name,omitempty"`

	// The offer ID.
	Product *string `json:"product,omitempty"`

	// The promotion code.
	PromotionCode *string `json:"promotionCode,omitempty"`

	// The publisher ID.
	Publisher *string `json:"publisher,omitempty"`

	// The plan's version.
	Version *string `json:"version,omitempty"`
}

// Provider - Resource provider information.
type Provider struct {
	// The namespace of the resource provider.
	Namespace *string `json:"namespace,omitempty"`

	// The provider authorization consent state.
	ProviderAuthorizationConsentState *ProviderAuthorizationConsentState `json:"providerAuthorizationConsentState,omitempty"`

	// READ-ONLY; The provider ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The registration policy of the resource provider.
	RegistrationPolicy *string `json:"registrationPolicy,omitempty" azure:"ro"`

	// READ-ONLY; The registration state of the resource provider.
	RegistrationState *string `json:"registrationState,omitempty" azure:"ro"`

	// READ-ONLY; The collection of provider resource types.
	ResourceTypes []*ProviderResourceType `json:"resourceTypes,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Provider.
func (p Provider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", p.ID)
	populate(objectMap, "namespace", p.Namespace)
	populate(objectMap, "providerAuthorizationConsentState", p.ProviderAuthorizationConsentState)
	populate(objectMap, "registrationPolicy", p.RegistrationPolicy)
	populate(objectMap, "registrationState", p.RegistrationState)
	populate(objectMap, "resourceTypes", p.ResourceTypes)
	return json.Marshal(objectMap)
}

// ProviderConsentDefinition - The provider consent.
type ProviderConsentDefinition struct {
	// A value indicating whether authorization is consented or not.
	ConsentToAuthorization *bool `json:"consentToAuthorization,omitempty"`
}

// ProviderExtendedLocation - The provider extended location.
type ProviderExtendedLocation struct {
	// The extended locations for the azure location.
	ExtendedLocations []*string `json:"extendedLocations,omitempty"`

	// The azure location.
	Location *string `json:"location,omitempty"`

	// The extended location type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ProviderExtendedLocation.
func (p ProviderExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocations", p.ExtendedLocations)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// ProviderListResult - List of resource providers.
type ProviderListResult struct {
	// An array of resource providers.
	Value []*Provider `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ProviderListResult.
func (p ProviderListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// ProviderPermission - The provider permission
type ProviderPermission struct {
	// The application id.
	ApplicationID *string `json:"applicationId,omitempty"`

	// Role definition properties.
	ManagedByRoleDefinition *RoleDefinition `json:"managedByRoleDefinition,omitempty"`

	// The provider authorization consent state.
	ProviderAuthorizationConsentState *ProviderAuthorizationConsentState `json:"providerAuthorizationConsentState,omitempty"`

	// Role definition properties.
	RoleDefinition *RoleDefinition `json:"roleDefinition,omitempty"`
}

// ProviderPermissionListResult - List of provider permissions.
type ProviderPermissionListResult struct {
	// An array of provider permissions.
	Value []*ProviderPermission `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ProviderPermissionListResult.
func (p ProviderPermissionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// ProviderRegistrationRequest - The provider registration definition.
type ProviderRegistrationRequest struct {
	// The provider consent.
	ThirdPartyProviderConsent *ProviderConsentDefinition `json:"thirdPartyProviderConsent,omitempty"`
}

// ProviderResourceType - Resource type managed by the resource provider.
type ProviderResourceType struct {
	// The API version.
	APIVersions []*string `json:"apiVersions,omitempty"`

	// The aliases that are supported by this resource type.
	Aliases []*Alias `json:"aliases,omitempty"`

	// The additional capabilities offered by this resource type.
	Capabilities *string `json:"capabilities,omitempty"`

	// The location mappings that are supported by this resource type.
	LocationMappings []*ProviderExtendedLocation `json:"locationMappings,omitempty"`

	// The collection of locations where this resource type can be created.
	Locations []*string `json:"locations,omitempty"`

	// The properties.
	Properties map[string]*string `json:"properties,omitempty"`

	// The resource type.
	ResourceType *string        `json:"resourceType,omitempty"`
	ZoneMappings []*ZoneMapping `json:"zoneMappings,omitempty"`

	// READ-ONLY; The API profiles for the resource provider.
	APIProfiles []*APIProfile `json:"apiProfiles,omitempty" azure:"ro"`

	// READ-ONLY; The default API version.
	DefaultAPIVersion *string `json:"defaultApiVersion,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ProviderResourceType.
func (p ProviderResourceType) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "apiProfiles", p.APIProfiles)
	populate(objectMap, "apiVersions", p.APIVersions)
	populate(objectMap, "aliases", p.Aliases)
	populate(objectMap, "capabilities", p.Capabilities)
	populate(objectMap, "defaultApiVersion", p.DefaultAPIVersion)
	populate(objectMap, "locationMappings", p.LocationMappings)
	populate(objectMap, "locations", p.Locations)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "resourceType", p.ResourceType)
	populate(objectMap, "zoneMappings", p.ZoneMappings)
	return json.Marshal(objectMap)
}

// ProviderResourceTypeListResult - List of resource types of a resource provider.
type ProviderResourceTypeListResult struct {
	// An array of resource types.
	Value []*ProviderResourceType `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ProviderResourceTypeListResult.
func (p ProviderResourceTypeListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// ProviderResourceTypesClientListOptions contains the optional parameters for the ProviderResourceTypesClient.List method.
type ProviderResourceTypesClientListOptions struct {
	// The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientGetAtTenantScopeOptions contains the optional parameters for the ProvidersClient.GetAtTenantScope method.
type ProvidersClientGetAtTenantScopeOptions struct {
	// The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientGetOptions contains the optional parameters for the ProvidersClient.Get method.
type ProvidersClientGetOptions struct {
	// The $expand query parameter. For example, to include property aliases in response, use $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientListAtTenantScopeOptions contains the optional parameters for the ProvidersClient.ListAtTenantScope method.
type ProvidersClientListAtTenantScopeOptions struct {
	// The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider
	// metadata. To include property aliases in response, use
	// $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientListOptions contains the optional parameters for the ProvidersClient.List method.
type ProvidersClientListOptions struct {
	// The properties to include in the results. For example, use &$expand=metadata in the query string to retrieve resource provider
	// metadata. To include property aliases in response, use
	// $expand=resourceTypes/aliases.
	Expand *string
}

// ProvidersClientProviderPermissionsOptions contains the optional parameters for the ProvidersClient.ProviderPermissions
// method.
type ProvidersClientProviderPermissionsOptions struct {
	// placeholder for future optional parameters
}

// ProvidersClientRegisterAtManagementGroupScopeOptions contains the optional parameters for the ProvidersClient.RegisterAtManagementGroupScope
// method.
type ProvidersClientRegisterAtManagementGroupScopeOptions struct {
	// placeholder for future optional parameters
}

// ProvidersClientRegisterOptions contains the optional parameters for the ProvidersClient.Register method.
type ProvidersClientRegisterOptions struct {
	// The third party consent for S2S.
	Properties *ProviderRegistrationRequest
}

// ProvidersClientUnregisterOptions contains the optional parameters for the ProvidersClient.Unregister method.
type ProvidersClientUnregisterOptions struct {
	// placeholder for future optional parameters
}

// Resource - Specified resource.
type Resource struct {
	// Resource extended location.
	ExtendedLocation *ExtendedLocation `json:"extendedLocation,omitempty"`

	// Resource location
	Location *string `json:"location,omitempty"`

	// Resource tags
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "extendedLocation", r.ExtendedLocation)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// ResourceGroup - Resource group information.
type ResourceGroup struct {
	// REQUIRED; The location of the resource group. It cannot be changed after the resource group has been created. It must be
	// one of the supported Azure locations.
	Location *string `json:"location,omitempty"`

	// The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The resource group properties.
	Properties *ResourceGroupProperties `json:"properties,omitempty"`

	// The tags attached to the resource group.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The ID of the resource group.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource group.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource group.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGroup.
func (r ResourceGroup) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "location", r.Location)
	populate(objectMap, "managedBy", r.ManagedBy)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// ResourceGroupExportResult - Resource group export result.
type ResourceGroupExportResult struct {
	// The template export error.
	Error *ErrorResponse `json:"error,omitempty"`

	// The template content.
	Template map[string]interface{} `json:"template,omitempty"`
}

// ResourceGroupFilter - Resource group filter.
type ResourceGroupFilter struct {
	// The tag name.
	TagName *string `json:"tagName,omitempty"`

	// The tag value.
	TagValue *string `json:"tagValue,omitempty"`
}

// ResourceGroupListResult - List of resource groups.
type ResourceGroupListResult struct {
	// An array of resource groups.
	Value []*ResourceGroup `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGroupListResult.
func (r ResourceGroupListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// ResourceGroupPatchable - Resource group information.
type ResourceGroupPatchable struct {
	// The ID of the resource that manages this resource group.
	ManagedBy *string `json:"managedBy,omitempty"`

	// The name of the resource group.
	Name *string `json:"name,omitempty"`

	// The resource group properties.
	Properties *ResourceGroupProperties `json:"properties,omitempty"`

	// The tags attached to the resource group.
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ResourceGroupPatchable.
func (r ResourceGroupPatchable) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "managedBy", r.ManagedBy)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "tags", r.Tags)
	return json.Marshal(objectMap)
}

// ResourceGroupProperties - The resource group properties.
type ResourceGroupProperties struct {
	// READ-ONLY; The provisioning state.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ResourceGroupsClientBeginDeleteOptions contains the optional parameters for the ResourceGroupsClient.BeginDelete method.
type ResourceGroupsClientBeginDeleteOptions struct {
	// The resource types you want to force delete. Currently, only the following is supported: forceDeletionTypes=Microsoft.Compute/virtualMachines,Microsoft.Compute/virtualMachineScaleSets
	ForceDeletionTypes *string
}

// ResourceGroupsClientBeginExportTemplateOptions contains the optional parameters for the ResourceGroupsClient.BeginExportTemplate
// method.
type ResourceGroupsClientBeginExportTemplateOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientCheckExistenceOptions contains the optional parameters for the ResourceGroupsClient.CheckExistence
// method.
type ResourceGroupsClientCheckExistenceOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientCreateOrUpdateOptions contains the optional parameters for the ResourceGroupsClient.CreateOrUpdate
// method.
type ResourceGroupsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientGetOptions contains the optional parameters for the ResourceGroupsClient.Get method.
type ResourceGroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ResourceGroupsClientListOptions contains the optional parameters for the ResourceGroupsClient.List method.
type ResourceGroupsClientListOptions struct {
	// The filter to apply on the operation.
	// You can filter by tag names and values. For example, to filter for a tag name and value, use $filter=tagName eq 'tag1'
	// and tagValue eq 'Value1'
	Filter *string
	// The number of results to return. If null is passed, returns all resource groups.
	Top *int32
}

// ResourceGroupsClientUpdateOptions contains the optional parameters for the ResourceGroupsClient.Update method.
type ResourceGroupsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ResourceListResult - List of resource groups.
type ResourceListResult struct {
	// An array of resources.
	Value []*GenericResourceExpanded `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type ResourceListResult.
func (r ResourceListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// ResourceProviderOperationDisplayProperties - Resource provider operation's display properties.
type ResourceProviderOperationDisplayProperties struct {
	// Operation description.
	Description *string `json:"description,omitempty"`

	// Resource provider operation.
	Operation *string `json:"operation,omitempty"`

	// Operation provider.
	Provider *string `json:"provider,omitempty"`

	// Operation description.
	Publisher *string `json:"publisher,omitempty"`

	// Operation resource.
	Resource *string `json:"resource,omitempty"`
}

// ResourceReference - The resource Id model.
type ResourceReference struct {
	// READ-ONLY; The fully qualified resource Id.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// RoleDefinition - Role definition properties.
type RoleDefinition struct {
	// The role definition ID.
	ID *string `json:"id,omitempty"`

	// If this is a service role.
	IsServiceRole *bool `json:"isServiceRole,omitempty"`

	// The role definition name.
	Name *string `json:"name,omitempty"`

	// Role definition permissions.
	Permissions []*Permission `json:"permissions,omitempty"`

	// Role definition assignable scopes.
	Scopes []*string `json:"scopes,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type RoleDefinition.
func (r RoleDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", r.ID)
	populate(objectMap, "isServiceRole", r.IsServiceRole)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "permissions", r.Permissions)
	populate(objectMap, "scopes", r.Scopes)
	return json.Marshal(objectMap)
}

// SKU for the resource.
type SKU struct {
	// The SKU capacity.
	Capacity *int32 `json:"capacity,omitempty"`

	// The SKU family.
	Family *string `json:"family,omitempty"`

	// The SKU model.
	Model *string `json:"model,omitempty"`

	// The SKU name.
	Name *string `json:"name,omitempty"`

	// The SKU size.
	Size *string `json:"size,omitempty"`

	// The SKU tier.
	Tier *string `json:"tier,omitempty"`
}

// ScopedDeployment - Deployment operation parameters.
type ScopedDeployment struct {
	// REQUIRED; The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The deployment properties.
	Properties *DeploymentProperties `json:"properties,omitempty"`

	// Deployment tags
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ScopedDeployment.
func (s ScopedDeployment) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", s.Location)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "tags", s.Tags)
	return json.Marshal(objectMap)
}

// ScopedDeploymentWhatIf - Deployment What-if operation parameters.
type ScopedDeploymentWhatIf struct {
	// REQUIRED; The location to store the deployment data.
	Location *string `json:"location,omitempty"`

	// REQUIRED; The deployment properties.
	Properties *DeploymentWhatIfProperties `json:"properties,omitempty"`
}

// StatusMessage - Operation status message object.
type StatusMessage struct {
	// The error reported by the operation.
	Error *ErrorResponse `json:"error,omitempty"`

	// Status of the deployment operation.
	Status *string `json:"status,omitempty"`
}

// SubResource - Sub-resource.
type SubResource struct {
	// Resource ID
	ID *string `json:"id,omitempty"`
}

// TagCount - Tag count.
type TagCount struct {
	// Type of count.
	Type *string `json:"type,omitempty"`

	// Value of count.
	Value *int32 `json:"value,omitempty"`
}

// TagDetails - Tag details.
type TagDetails struct {
	// The total number of resources that use the resource tag. When a tag is initially created and has no associated resources,
	// the value is 0.
	Count *TagCount `json:"count,omitempty"`

	// The tag name.
	TagName *string `json:"tagName,omitempty"`

	// The list of tag values.
	Values []*TagValue `json:"values,omitempty"`

	// READ-ONLY; The tag name ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type TagDetails.
func (t TagDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "count", t.Count)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "tagName", t.TagName)
	populate(objectMap, "values", t.Values)
	return json.Marshal(objectMap)
}

// TagValue - Tag information.
type TagValue struct {
	// The tag value count.
	Count *TagCount `json:"count,omitempty"`

	// The tag value.
	TagValue *string `json:"tagValue,omitempty"`

	// READ-ONLY; The tag value ID.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// Tags - A dictionary of name and value pairs.
type Tags struct {
	// Dictionary of
	Tags map[string]*string `json:"tags,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type Tags.
func (t Tags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// TagsClientCreateOrUpdateAtScopeOptions contains the optional parameters for the TagsClient.CreateOrUpdateAtScope method.
type TagsClientCreateOrUpdateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientCreateOrUpdateOptions contains the optional parameters for the TagsClient.CreateOrUpdate method.
type TagsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// TagsClientCreateOrUpdateValueOptions contains the optional parameters for the TagsClient.CreateOrUpdateValue method.
type TagsClientCreateOrUpdateValueOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteAtScopeOptions contains the optional parameters for the TagsClient.DeleteAtScope method.
type TagsClientDeleteAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteOptions contains the optional parameters for the TagsClient.Delete method.
type TagsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// TagsClientDeleteValueOptions contains the optional parameters for the TagsClient.DeleteValue method.
type TagsClientDeleteValueOptions struct {
	// placeholder for future optional parameters
}

// TagsClientGetAtScopeOptions contains the optional parameters for the TagsClient.GetAtScope method.
type TagsClientGetAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsClientListOptions contains the optional parameters for the TagsClient.List method.
type TagsClientListOptions struct {
	// placeholder for future optional parameters
}

// TagsClientUpdateAtScopeOptions contains the optional parameters for the TagsClient.UpdateAtScope method.
type TagsClientUpdateAtScopeOptions struct {
	// placeholder for future optional parameters
}

// TagsListResult - List of subscription tags.
type TagsListResult struct {
	// An array of tags.
	Value []*TagDetails `json:"value,omitempty"`

	// READ-ONLY; The URL to use for getting the next set of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// MarshalJSON implements the json.Marshaller interface for type TagsListResult.
func (t TagsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// TagsPatchResource - Wrapper resource for tags patch API request only.
type TagsPatchResource struct {
	// The operation type for the patch API.
	Operation *TagsPatchOperation `json:"operation,omitempty"`

	// The set of tags.
	Properties *Tags `json:"properties,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type TagsPatchResource.
func (t TagsPatchResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "operation", t.Operation)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// TagsResource - Wrapper resource for tags API requests and responses.
type TagsResource struct {
	// REQUIRED; The set of tags.
	Properties *Tags `json:"properties,omitempty"`

	// READ-ONLY; The ID of the tags wrapper resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the tags wrapper resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the tags wrapper resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// TargetResource - Target resource.
type TargetResource struct {
	// The ID of the resource.
	ID *string `json:"id,omitempty"`

	// The name of the resource.
	ResourceName *string `json:"resourceName,omitempty"`

	// The type of the resource.
	ResourceType *string `json:"resourceType,omitempty"`
}

// TemplateHashResult - Result of the request to calculate template hash. It contains a string of minified template and its
// hash.
type TemplateHashResult struct {
	// The minified template string.
	MinifiedTemplate *string `json:"minifiedTemplate,omitempty"`

	// The template hash.
	TemplateHash *string `json:"templateHash,omitempty"`
}

// TemplateLink - Entity representing the reference to the template.
type TemplateLink struct {
	// If included, must match the ContentVersion in the template.
	ContentVersion *string `json:"contentVersion,omitempty"`

	// The resource id of a Template Spec. Use either the id or uri property, but not both.
	ID *string `json:"id,omitempty"`

	// The query string (for example, a SAS token) to be used with the templateLink URI.
	QueryString *string `json:"queryString,omitempty"`

	// The relativePath property can be used to deploy a linked template at a location relative to the parent. If the parent template
	// was linked with a TemplateSpec, this will reference an artifact in the
	// TemplateSpec. If the parent was linked with a URI, the child deployment will be a combination of the parent and relativePath
	// URIs
	RelativePath *string `json:"relativePath,omitempty"`

	// The URI of the template to deploy. Use either the uri or id property, but not both.
	URI *string `json:"uri,omitempty"`
}

// WhatIfChange - Information about a single resource change predicted by What-If operation.
type WhatIfChange struct {
	// REQUIRED; Type of change that will be made to the resource when the deployment is executed.
	ChangeType *ChangeType `json:"changeType,omitempty"`

	// REQUIRED; Resource ID
	ResourceID *string `json:"resourceId,omitempty"`

	// The predicted snapshot of the resource after the deployment is executed.
	After map[string]interface{} `json:"after,omitempty"`

	// The snapshot of the resource before the deployment is executed.
	Before map[string]interface{} `json:"before,omitempty"`

	// The predicted changes to resource properties.
	Delta []*WhatIfPropertyChange `json:"delta,omitempty"`

	// The explanation about why the resource is unsupported by What-If.
	UnsupportedReason *string `json:"unsupportedReason,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type WhatIfChange.
func (w WhatIfChange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "after", w.After)
	populate(objectMap, "before", w.Before)
	populate(objectMap, "changeType", w.ChangeType)
	populate(objectMap, "delta", w.Delta)
	populate(objectMap, "resourceId", w.ResourceID)
	populate(objectMap, "unsupportedReason", w.UnsupportedReason)
	return json.Marshal(objectMap)
}

// WhatIfOperationProperties - Deployment operation properties.
type WhatIfOperationProperties struct {
	// List of resource changes predicted by What-If operation.
	Changes []*WhatIfChange `json:"changes,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type WhatIfOperationProperties.
func (w WhatIfOperationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "changes", w.Changes)
	return json.Marshal(objectMap)
}

// WhatIfOperationResult - Result of the What-If operation. Contains a list of predicted changes and a URL link to get to
// the next set of results.
type WhatIfOperationResult struct {
	// Error when What-If operation fails.
	Error *ErrorResponse `json:"error,omitempty"`

	// What-If operation properties.
	Properties *WhatIfOperationProperties `json:"properties,omitempty"`

	// Status of the What-If operation.
	Status *string `json:"status,omitempty"`
}

// WhatIfPropertyChange - The predicted change to the resource property.
type WhatIfPropertyChange struct {
	// REQUIRED; The path of the property.
	Path *string `json:"path,omitempty"`

	// REQUIRED; The type of property change.
	PropertyChangeType *PropertyChangeType `json:"propertyChangeType,omitempty"`

	// The value of the property after the deployment is executed.
	After map[string]interface{} `json:"after,omitempty"`

	// The value of the property before the deployment is executed.
	Before map[string]interface{} `json:"before,omitempty"`

	// Nested property changes.
	Children []*WhatIfPropertyChange `json:"children,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type WhatIfPropertyChange.
func (w WhatIfPropertyChange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "after", w.After)
	populate(objectMap, "before", w.Before)
	populate(objectMap, "children", w.Children)
	populate(objectMap, "path", w.Path)
	populate(objectMap, "propertyChangeType", w.PropertyChangeType)
	return json.Marshal(objectMap)
}

type ZoneMapping struct {
	// The location of the zone mapping.
	Location *string   `json:"location,omitempty"`
	Zones    []*string `json:"zones,omitempty"`
}

// MarshalJSON implements the json.Marshaller interface for type ZoneMapping.
func (z ZoneMapping) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "location", z.Location)
	populate(objectMap, "zones", z.Zones)
	return json.Marshal(objectMap)
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, v interface{}) error {
	if data == nil {
		return nil
	}
	return json.Unmarshal(data, v)
}
