//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armresources

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"reflect"
)

// ClientListByResourceGroupPager provides operations for iterating over paged responses.
type ClientListByResourceGroupPager struct {
	client    *Client
	current   ClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ResourceListResult.NextLink == nil || len(*p.current.ResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ClientListByResourceGroupResponse page.
func (p *ClientListByResourceGroupPager) PageResponse() ClientListByResourceGroupResponse {
	return p.current
}

// ClientListPager provides operations for iterating over paged responses.
type ClientListPager struct {
	client    *Client
	current   ClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ResourceListResult.NextLink == nil || len(*p.current.ResourceListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ClientListResponse page.
func (p *ClientListPager) PageResponse() ClientListResponse {
	return p.current
}

// DeploymentOperationsClientListAtManagementGroupScopePager provides operations for iterating over paged responses.
type DeploymentOperationsClientListAtManagementGroupScopePager struct {
	client    *DeploymentOperationsClient
	current   DeploymentOperationsClientListAtManagementGroupScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentOperationsClientListAtManagementGroupScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentOperationsClientListAtManagementGroupScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentOperationsClientListAtManagementGroupScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentOperationsListResult.NextLink == nil || len(*p.current.DeploymentOperationsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtManagementGroupScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentOperationsClientListAtManagementGroupScopeResponse page.
func (p *DeploymentOperationsClientListAtManagementGroupScopePager) PageResponse() DeploymentOperationsClientListAtManagementGroupScopeResponse {
	return p.current
}

// DeploymentOperationsClientListAtScopePager provides operations for iterating over paged responses.
type DeploymentOperationsClientListAtScopePager struct {
	client    *DeploymentOperationsClient
	current   DeploymentOperationsClientListAtScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentOperationsClientListAtScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentOperationsClientListAtScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentOperationsClientListAtScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentOperationsListResult.NextLink == nil || len(*p.current.DeploymentOperationsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentOperationsClientListAtScopeResponse page.
func (p *DeploymentOperationsClientListAtScopePager) PageResponse() DeploymentOperationsClientListAtScopeResponse {
	return p.current
}

// DeploymentOperationsClientListAtSubscriptionScopePager provides operations for iterating over paged responses.
type DeploymentOperationsClientListAtSubscriptionScopePager struct {
	client    *DeploymentOperationsClient
	current   DeploymentOperationsClientListAtSubscriptionScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentOperationsClientListAtSubscriptionScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentOperationsClientListAtSubscriptionScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentOperationsClientListAtSubscriptionScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentOperationsListResult.NextLink == nil || len(*p.current.DeploymentOperationsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtSubscriptionScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentOperationsClientListAtSubscriptionScopeResponse page.
func (p *DeploymentOperationsClientListAtSubscriptionScopePager) PageResponse() DeploymentOperationsClientListAtSubscriptionScopeResponse {
	return p.current
}

// DeploymentOperationsClientListAtTenantScopePager provides operations for iterating over paged responses.
type DeploymentOperationsClientListAtTenantScopePager struct {
	client    *DeploymentOperationsClient
	current   DeploymentOperationsClientListAtTenantScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentOperationsClientListAtTenantScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentOperationsClientListAtTenantScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentOperationsClientListAtTenantScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentOperationsListResult.NextLink == nil || len(*p.current.DeploymentOperationsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtTenantScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentOperationsClientListAtTenantScopeResponse page.
func (p *DeploymentOperationsClientListAtTenantScopePager) PageResponse() DeploymentOperationsClientListAtTenantScopeResponse {
	return p.current
}

// DeploymentOperationsClientListPager provides operations for iterating over paged responses.
type DeploymentOperationsClientListPager struct {
	client    *DeploymentOperationsClient
	current   DeploymentOperationsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentOperationsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentOperationsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentOperationsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentOperationsListResult.NextLink == nil || len(*p.current.DeploymentOperationsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentOperationsClientListResponse page.
func (p *DeploymentOperationsClientListPager) PageResponse() DeploymentOperationsClientListResponse {
	return p.current
}

// DeploymentsClientListAtManagementGroupScopePager provides operations for iterating over paged responses.
type DeploymentsClientListAtManagementGroupScopePager struct {
	client    *DeploymentsClient
	current   DeploymentsClientListAtManagementGroupScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentsClientListAtManagementGroupScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentsClientListAtManagementGroupScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentsClientListAtManagementGroupScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentListResult.NextLink == nil || len(*p.current.DeploymentListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtManagementGroupScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentsClientListAtManagementGroupScopeResponse page.
func (p *DeploymentsClientListAtManagementGroupScopePager) PageResponse() DeploymentsClientListAtManagementGroupScopeResponse {
	return p.current
}

// DeploymentsClientListAtScopePager provides operations for iterating over paged responses.
type DeploymentsClientListAtScopePager struct {
	client    *DeploymentsClient
	current   DeploymentsClientListAtScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentsClientListAtScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentsClientListAtScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentsClientListAtScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentListResult.NextLink == nil || len(*p.current.DeploymentListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentsClientListAtScopeResponse page.
func (p *DeploymentsClientListAtScopePager) PageResponse() DeploymentsClientListAtScopeResponse {
	return p.current
}

// DeploymentsClientListAtSubscriptionScopePager provides operations for iterating over paged responses.
type DeploymentsClientListAtSubscriptionScopePager struct {
	client    *DeploymentsClient
	current   DeploymentsClientListAtSubscriptionScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentsClientListAtSubscriptionScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentsClientListAtSubscriptionScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentsClientListAtSubscriptionScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentListResult.NextLink == nil || len(*p.current.DeploymentListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtSubscriptionScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentsClientListAtSubscriptionScopeResponse page.
func (p *DeploymentsClientListAtSubscriptionScopePager) PageResponse() DeploymentsClientListAtSubscriptionScopeResponse {
	return p.current
}

// DeploymentsClientListAtTenantScopePager provides operations for iterating over paged responses.
type DeploymentsClientListAtTenantScopePager struct {
	client    *DeploymentsClient
	current   DeploymentsClientListAtTenantScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentsClientListAtTenantScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentsClientListAtTenantScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentsClientListAtTenantScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentListResult.NextLink == nil || len(*p.current.DeploymentListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtTenantScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentsClientListAtTenantScopeResponse page.
func (p *DeploymentsClientListAtTenantScopePager) PageResponse() DeploymentsClientListAtTenantScopeResponse {
	return p.current
}

// DeploymentsClientListByResourceGroupPager provides operations for iterating over paged responses.
type DeploymentsClientListByResourceGroupPager struct {
	client    *DeploymentsClient
	current   DeploymentsClientListByResourceGroupResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, DeploymentsClientListByResourceGroupResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *DeploymentsClientListByResourceGroupPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *DeploymentsClientListByResourceGroupPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.DeploymentListResult.NextLink == nil || len(*p.current.DeploymentListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listByResourceGroupHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current DeploymentsClientListByResourceGroupResponse page.
func (p *DeploymentsClientListByResourceGroupPager) PageResponse() DeploymentsClientListByResourceGroupResponse {
	return p.current
}

// OperationsClientListPager provides operations for iterating over paged responses.
type OperationsClientListPager struct {
	client    *OperationsClient
	current   OperationsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, OperationsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *OperationsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *OperationsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.OperationListResult.NextLink == nil || len(*p.current.OperationListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current OperationsClientListResponse page.
func (p *OperationsClientListPager) PageResponse() OperationsClientListResponse {
	return p.current
}

// ProvidersClientListAtTenantScopePager provides operations for iterating over paged responses.
type ProvidersClientListAtTenantScopePager struct {
	client    *ProvidersClient
	current   ProvidersClientListAtTenantScopeResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ProvidersClientListAtTenantScopeResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ProvidersClientListAtTenantScopePager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ProvidersClientListAtTenantScopePager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ProviderListResult.NextLink == nil || len(*p.current.ProviderListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listAtTenantScopeHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ProvidersClientListAtTenantScopeResponse page.
func (p *ProvidersClientListAtTenantScopePager) PageResponse() ProvidersClientListAtTenantScopeResponse {
	return p.current
}

// ProvidersClientListPager provides operations for iterating over paged responses.
type ProvidersClientListPager struct {
	client    *ProvidersClient
	current   ProvidersClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ProvidersClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ProvidersClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ProvidersClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ProviderListResult.NextLink == nil || len(*p.current.ProviderListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ProvidersClientListResponse page.
func (p *ProvidersClientListPager) PageResponse() ProvidersClientListResponse {
	return p.current
}

// ResourceGroupsClientListPager provides operations for iterating over paged responses.
type ResourceGroupsClientListPager struct {
	client    *ResourceGroupsClient
	current   ResourceGroupsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, ResourceGroupsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *ResourceGroupsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *ResourceGroupsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.ResourceGroupListResult.NextLink == nil || len(*p.current.ResourceGroupListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current ResourceGroupsClientListResponse page.
func (p *ResourceGroupsClientListPager) PageResponse() ResourceGroupsClientListResponse {
	return p.current
}

// TagsClientListPager provides operations for iterating over paged responses.
type TagsClientListPager struct {
	client    *TagsClient
	current   TagsClientListResponse
	err       error
	requester func(context.Context) (*policy.Request, error)
	advancer  func(context.Context, TagsClientListResponse) (*policy.Request, error)
}

// Err returns the last error encountered while paging.
func (p *TagsClientListPager) Err() error {
	return p.err
}

// NextPage returns true if the pager advanced to the next page.
// Returns false if there are no more pages or an error occurred.
func (p *TagsClientListPager) NextPage(ctx context.Context) bool {
	var req *policy.Request
	var err error
	if !reflect.ValueOf(p.current).IsZero() {
		if p.current.TagsListResult.NextLink == nil || len(*p.current.TagsListResult.NextLink) == 0 {
			return false
		}
		req, err = p.advancer(ctx, p.current)
	} else {
		req, err = p.requester(ctx)
	}
	if err != nil {
		p.err = err
		return false
	}
	resp, err := p.client.pl.Do(req)
	if err != nil {
		p.err = err
		return false
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		p.err = runtime.NewResponseError(resp)
		return false
	}
	result, err := p.client.listHandleResponse(resp)
	if err != nil {
		p.err = err
		return false
	}
	p.current = result
	return true
}

// PageResponse returns the current TagsClientListResponse page.
func (p *TagsClientListPager) PageResponse() TagsClientListResponse {
	return p.current
}
