/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ChangeListener;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.cellrenderer.DefaultListCellRenderer;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ScrollPane;
import net.yura.mobile.logging.Logger;

public class List
extends Component
implements ActionListener {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 3;
    private Button selectButton;
    private boolean useSelectButton;
    private ListCellRenderer renderer;
    private int current;
    private ActionListener al;
    private ChangeListener chl;
    private String actionCommand;
    private boolean loop;
    private int layoutOrientation;
    private boolean doubleClick;
    private int fixedCellHeight = -1;
    private int fixedCellWidth = -1;
    private long doubleClickTime;
    private int doubleClickX;
    private int doubleClickY;
    private boolean clearSelectionOnClick = false;
    private boolean addMode;
    private boolean selectedCreated;
    private int ensureIndexIsVisible = -1;
    private Vector items;
    private Vector selected;

    public List() {
        this((Vector)null);
    }

    public List(Vector a) {
        this(a, new DefaultListCellRenderer(), 0);
    }

    public List(ListCellRenderer a) {
        this(null, a, 0);
    }

    public List(Vector a, ListCellRenderer b, int h) {
        this.items = a;
        if (this.items == null) {
            this.items = new Vector();
        }
        this.setCellRenderer(b);
        this.layoutOrientation = h;
        this.setSelectedIndex(-1);
    }

    public void setListData(Vector a) {
        this.items = a;
        this.contentsChanged();
    }

    public void contentsChanged() {
        if (this.current >= this.getSize()) {
            this.setSelectedIndex(-1);
        } else if (this.current == -1 && this.getSize() > 0 && this.isFocusOwner()) {
            this.setSelectedIndex(0);
        }
    }

    public void setSelectedValue(Object a) {
        this.setSelectedIndex(this.indexOf(a));
    }

    public Vector getItems() {
        return this.items;
    }

    public String toString() {
        return super.toString() + this.items;
    }

    protected void workoutMinimumSize() {
        if (this.fixedCellWidth != -1 && this.fixedCellHeight != -1) {
            int s = this.getSize();
            if (this.layoutOrientation == 3) {
                this.width = this.fixedCellWidth * s;
                this.height = this.fixedCellHeight;
            } else {
                this.width = this.fixedCellWidth;
                this.height = this.fixedCellHeight * s;
            }
        } else {
            int totalHeight = 0;
            int totalWidth = 0;
            for (int i = 0; i < this.getSize(); ++i) {
                int h;
                Object item = this.getElementAt(i);
                Component c = this.renderer.getListCellRendererComponent(this, item, i, i == this.current, false);
                c.workoutPreferredSize();
                int w = this.fixedCellWidth == -1 ? c.getWidthWithBorder() : this.fixedCellWidth;
                int n = h = this.fixedCellHeight == -1 ? c.getHeightWithBorder() : this.fixedCellHeight;
                if (this.layoutOrientation == 3) {
                    if (totalHeight < h) {
                        totalHeight = h;
                    }
                } else {
                    totalHeight += h;
                }
                if (this.layoutOrientation == 3) {
                    totalWidth += w;
                    continue;
                }
                if (totalWidth >= w) continue;
                totalWidth = w;
            }
            this.width = totalWidth;
            this.height = totalHeight;
        }
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        if (this.ensureIndexIsVisible != -1) {
            if (this.ensureIndexIsVisible >= this.getSize()) {
                this.ensureIndexIsVisible = -1;
                return;
            }
            Component c = this.getRendererComponentFor(this.ensureIndexIsVisible);
            boolean yes = this.isRectVisible(c.getXWithBorder(), c.getYWithBorder(), c.getWidthWithBorder(), c.getHeightWithBorder());
            if (!yes) {
                this.ensureIndexIsVisible(this.ensureIndexIsVisible);
            }
        }
    }

    public void setLayoutOrientation(int layoutOrientation) {
        this.layoutOrientation = layoutOrientation;
    }

    public int getLayoutOrientation() {
        return this.layoutOrientation;
    }

    public void addActionListener(ActionListener l) {
        if (this.al != null) {
            Logger.warn("trying to add a ActionListener when there is already one registered");
        }
        if (l == null) {
            Logger.warn("trying to add a null ActionListener");
        }
        this.al = l;
    }

    public void removeActionListener(ActionListener l) {
        if (this.al == l) {
            this.al = null;
        } else {
            Logger.warn("trying to remove a ActionListener that is not registered");
        }
        if (l == null) {
            Logger.warn("trying to remove a null ActionListener");
        }
    }

    public ActionListener getActionListener() {
        return this.al;
    }

    public void setActionCommand(String ac) {
        this.actionCommand = ac;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setLoop(boolean l) {
        this.loop = l;
    }

    public void setDoubleClick(boolean b) {
        this.doubleClick = b;
    }

    public void setCellRenderer(ListCellRenderer cellRenderer) {
        this.renderer = cellRenderer;
    }

    public int[] locationToIndex(int x, int y) {
        int ri = -1;
        int roffset = 0;
        int size = this.getSize();
        if (!(size == 0 || this.layoutOrientation == 3 && x < 0 || this.layoutOrientation == 0 && y < 0 || this.layoutOrientation == 3 && x > this.width || this.layoutOrientation == 0 && y > this.height)) {
            if (this.layoutOrientation == 3 && this.fixedCellWidth != -1) {
                ri = x / this.fixedCellWidth;
                if (ri < 0 || ri >= size) {
                    ri = -1;
                } else {
                    roffset = ri * this.fixedCellWidth;
                }
            } else if (this.layoutOrientation == 0 && this.fixedCellHeight != -1) {
                ri = y / this.fixedCellHeight;
                if (ri < 0 || ri >= size) {
                    ri = -1;
                } else {
                    roffset = ri * this.fixedCellHeight;
                }
            } else {
                Component comp = null;
                int offset = 0;
                for (int i = 0; i < size; ++i) {
                    comp = this.getComponentFor(i, offset);
                    int cw = comp.getWidthWithBorder();
                    int ch = comp.getHeightWithBorder();
                    int cx = comp.getXWithBorder();
                    int cy = comp.getYWithBorder();
                    if ((this.layoutOrientation == 0 || x >= cx && x < cx + cw) && (this.layoutOrientation == 3 || y >= cy && y < cy + ch)) {
                        ri = i;
                        roffset = offset;
                        break;
                    }
                    offset += this.layoutOrientation == 3 ? cw : ch;
                }
            }
        }
        return new int[]{ri, roffset};
    }

    public void paintComponent(Graphics2D g) {
        this.ensureIndexIsVisible = -1;
        boolean good = false;
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int[] objects = this.locationToIndex(clipx, clipy);
        int i = objects[0];
        int offset = objects[1];
        if (i < 0) {
            if (this.layoutOrientation == 3 && clipx < 0 || this.layoutOrientation == 0 && clipy < 0) {
                i = 0;
                offset = 0;
            } else {
                return;
            }
        }
        while (i < this.getSize()) {
            Component c = this.getComponentFor(i, offset);
            int x = c.getXWithBorder();
            int y = c.getYWithBorder();
            if (x < clipx + clipw && x + c.getWidthWithBorder() > clipx && y < clipy + cliph && y + c.getHeightWithBorder() > clipy) {
                x = c.getX();
                y = c.getY();
                good = true;
                g.translate(x, y);
                c.paint(g);
                g.translate(-x, -y);
            } else if (good) break;
            offset += this.layoutOrientation == 3 ? c.getWidthWithBorder() : c.getHeightWithBorder();
            ++i;
        }
    }

    public void addListSelectionListener(ChangeListener aThis) {
        this.chl = aThis;
    }

    public ListCellRenderer getCellRenderer() {
        return this.renderer;
    }

    public Component getRendererComponentFor(int a) {
        if (this.layoutOrientation == 3 && this.fixedCellWidth != -1) {
            return this.getComponentFor(a, a * this.fixedCellWidth);
        }
        if (this.layoutOrientation == 0 && this.fixedCellHeight != -1) {
            return this.getComponentFor(a, a * this.fixedCellHeight);
        }
        int offset = 0;
        if (this.layoutOrientation == 3 || this.layoutOrientation == 0) {
            int i = 0;
            while (true) {
                Component c = this.getComponentFor(i, offset);
                if (i == a) {
                    return c;
                }
                offset += this.layoutOrientation == 3 ? c.getWidthWithBorder() : c.getHeightWithBorder();
                ++i;
            }
        }
        return this.getComponentFor(a, offset);
    }

    protected Component getComponentFor(int i, int offset) {
        Object item = this.getElementAt(i);
        Component c = this.renderer.getListCellRendererComponent(this, item, i, this.isSelectedIndex(i), this.isFocusOwner() && i == this.current);
        if (this.fixedCellWidth == -1 || this.fixedCellHeight == -1) {
            c.workoutPreferredSize();
        }
        int w = this.fixedCellWidth != -1 ? this.fixedCellWidth : c.getWidthWithBorder();
        int h = this.fixedCellHeight != -1 ? this.fixedCellHeight : c.getHeightWithBorder();
        c.setBoundsWithBorder(this.layoutOrientation == 3 ? offset : 0, this.layoutOrientation == 3 ? 0 : offset, this.layoutOrientation == 3 ? w : this.width, this.layoutOrientation == 3 ? this.height : h);
        return c;
    }

    public void focusLost() {
        super.focusLost();
        if (this.useSelectButton) {
            this.getWindow().removeCommand(this.selectButton);
            this.selectButton = null;
        }
        this.repaint();
    }

    public void focusGained() {
        super.focusGained();
        if (this.getSize() != 0) {
            if (this.current == -1 || this.current >= this.getSize()) {
                this.setSelectedIndex(0);
            } else {
                this.ensureIndexIsVisible(this.current);
            }
        }
        if (this.useSelectButton) {
            this.selectButton = new Button((String)DesktopPane.get("selectText"));
            this.selectButton.setActionCommand("select");
            this.selectButton.setMnemonic(-6);
            this.selectButton.addActionListener(this);
            this.getWindow().addCommand(this.selectButton);
        }
    }

    public void processMouseEvent(int type, int x, int y, KeyEvent keys) {
        super.processMouseEvent(type, x, y, keys);
        if (this.isFocusable()) {
            if (type == 1 || type == 0) {
                int i = this.locationToIndex(x, y)[0];
                if (i >= 0) {
                    this.selectNewPointer(i, keys);
                } else {
                    this.setSelectedIndex(-1);
                }
            } else if (type == 2) {
                if (this.isCtrlKeyDown(keys)) {
                    return;
                }
                if (this.doubleClick) {
                    long time = System.currentTimeMillis();
                    if (time < this.doubleClickTime + 300L && x > this.doubleClickX - 5 && x < this.doubleClickX + 5 && y > this.doubleClickY - 5 && y < this.doubleClickY + 5) {
                        this.mouseClicked(x, y);
                    }
                    this.doubleClickTime = time;
                    this.doubleClickX = x;
                    this.doubleClickY = y;
                } else {
                    this.mouseClicked(x, y);
                }
            }
        }
    }

    public void mouseClicked(int x, int y) {
        this.fireActionPerformed();
    }

    public boolean consumesMotionEvents() {
        ScrollPane sp = (ScrollPane)DesktopPane.getAncestorOfClass(ScrollPane.class, this);
        return sp == null || sp.getViewPortHeight() >= sp.getView().getHeight() && sp.getViewPortWidth() >= sp.getView().getWidth();
    }

    private void selectNewPointer(int i, KeyEvent keys) {
        if (this.isCtrlKeyDown(keys)) {
            this.toggleHelper(this.current, this.selected == null, false);
            this.toggleHelper(i, true, true);
        } else if (this.selected != null && (this.clearSelectionOnClick || this.selected.isEmpty()) && this.selectedCreated) {
            this.clearSelection();
        }
        this.setSelectedIndex(i);
    }

    private void selectNewKey(int i, KeyEvent keys) {
        if (this.isCtrlKeyDown(keys)) {
            this.toggleHelper(this.current, i == this.current || this.addMode, i == this.current || !this.addMode);
            this.toggleHelper(i, i != this.current && this.addMode, i != this.current && !this.addMode);
        } else if (this.selected != null && this.selected.isEmpty() && this.selectedCreated) {
            this.clearSelection();
        }
        this.setSelectedIndex(i);
    }

    private boolean isCtrlKeyDown(KeyEvent keys) {
        return keys.isDownKey(-50) || keys.isDownKey(35);
    }

    private void toggleHelper(int i, boolean addTest, boolean removeTest) {
        Object obj;
        if (i < 0 || !addTest && !removeTest) {
            return;
        }
        if (this.selected == null) {
            this.selectedCreated = true;
            this.selected = new Vector();
        }
        if (this.selected.contains(obj = this.getElementAt(i))) {
            if (removeTest) {
                this.selected.removeElement(obj);
            }
        } else if (addTest) {
            this.selected.addElement(obj);
        }
    }

    public boolean processKeyEvent(KeyEvent keypad) {
        int keyCode;
        int size = this.getSize();
        if (size == 0) {
            if (keypad.justPressedAction(8) || keypad.justPressedKey(10)) {
                return this.fireActionPerformed();
            }
            return false;
        }
        if (keypad.justPressedKey(-50) || keypad.justPressedKey(35)) {
            this.addMode = this.selected == null || !this.isSelectedIndex(this.current);
        }
        int next = this.current + 1;
        int prev = this.current - 1;
        if (this.loop) {
            if (next >= size) {
                int n = next = size == 0 ? -1 : 0;
            }
            if (prev < 0) {
                prev = size - 1;
            }
        } else if (next >= size) {
            next = -1;
        }
        if ((keyCode = keypad.getIsDownKey()) >= 9 && keyCode < 65535 && keyCode != 35 && keyCode != 10) {
            keyCode = keypad.getKeyChar(keyCode, KeyEvent.getChars((char)keyCode, 0), false);
            for (int i = 0; i < this.getSize(); ++i) {
                String item = String.valueOf(this.getElementAt(i));
                String string = item = item == null ? "null" : item.toLowerCase();
                if ("".equals(item) || item.charAt(0) != keyCode) continue;
                this.selectNewKey(i, keypad);
                return true;
            }
            return false;
        }
        if (keypad.isDownAction(6)) {
            if (this.layoutOrientation != 3 && next > -1) {
                this.selectNewKey(next, keypad);
                return true;
            }
            if (this.layoutOrientation != 0 && this.current != -1) {
                Component c = this.getRendererComponentFor(this.current);
                int y = this.getYOnScreen();
                this.scrollRectToVisible(c.getXWithBorder(), c.getHeightWithBorder() - 1, c.getWidthWithBorder(), 1, true);
                if (y != this.getYOnScreen()) {
                    return true;
                }
            }
            return false;
        }
        if (keypad.isDownAction(1)) {
            if (this.layoutOrientation != 3 && prev > -1) {
                this.selectNewKey(prev, keypad);
                return true;
            }
            if (this.layoutOrientation != 0 && this.current != -1) {
                Component c = this.getRendererComponentFor(this.current);
                int y = this.getYOnScreen();
                this.scrollRectToVisible(c.getXWithBorder(), 0, c.getWidthWithBorder(), 1, true);
                if (y != this.getYOnScreen()) {
                    return true;
                }
            }
            return false;
        }
        if (keypad.isDownAction(5)) {
            if (this.layoutOrientation != 0 && next > -1) {
                this.selectNewKey(next, keypad);
                return true;
            }
            if (this.layoutOrientation != 3 && this.current != -1) {
                Component c = this.getRendererComponentFor(this.current);
                int x = this.getXOnScreen();
                this.scrollRectToVisible(c.getWidthWithBorder() - 1, c.getYWithBorder(), 1, c.getHeightWithBorder(), true);
                if (x != this.getXOnScreen()) {
                    return true;
                }
            }
            return false;
        }
        if (keypad.isDownAction(2)) {
            if (this.layoutOrientation != 0 && prev > -1) {
                this.selectNewKey(prev, keypad);
                return true;
            }
            if (this.layoutOrientation != 3 && this.current != -1) {
                Component c = this.getRendererComponentFor(this.current);
                int x = this.getXOnScreen();
                this.scrollRectToVisible(0, c.getYWithBorder(), 1, c.getHeightWithBorder(), true);
                if (x != this.getXOnScreen()) {
                    return true;
                }
            }
            return false;
        }
        if (keypad.justPressedAction(8) || keypad.justPressedKey(10)) {
            if (this.isCtrlKeyDown(keypad)) {
                this.selectNewKey(this.current, keypad);
                return true;
            }
            return this.fireActionPerformed();
        }
        return false;
    }

    public boolean fireActionPerformed() {
        if (this.al != null) {
            this.al.actionPerformed(this.actionCommand);
            return true;
        }
        return false;
    }

    public Object getSelectedValue() {
        if (this.current == -1) {
            return null;
        }
        return this.getElementAt(this.current);
    }

    public int getSelectedIndex() {
        return this.current;
    }

    public void setSelectedIndex(int a) {
        this.setSelectedIndex(a, true);
    }

    public void setSelectedIndex(int a, boolean moveScroll) {
        int old = this.current;
        this.current = a;
        if (this.current != -1 && moveScroll) {
            this.ensureIndexIsVisible(this.current);
        }
        if (this.current != old) {
            this.repaint();
            if (this.chl != null) {
                this.chl.changeEvent(this, this.current);
            }
        }
    }

    public void makeVisible() {
        System.out.println("skip makeVisible");
    }

    public void ensureIndexIsVisible(int i) {
        int size;
        int pos;
        if (this.layoutOrientation == 3 && this.fixedCellWidth != -1) {
            pos = i * this.fixedCellWidth;
            size = this.fixedCellWidth;
        } else if (this.layoutOrientation == 0 && this.fixedCellHeight != -1) {
            pos = i * this.fixedCellHeight;
            size = this.fixedCellHeight;
        } else {
            Component c = this.getRendererComponentFor(i);
            if (this.layoutOrientation == 3) {
                pos = c.getXWithBorder();
                size = c.getWidthWithBorder();
            } else {
                pos = c.getYWithBorder();
                size = c.getHeightWithBorder();
            }
        }
        int offset = this.layoutOrientation == 3 ? this.posY : this.posX;
        Component p = this.parent;
        while (p != null && !(p instanceof ScrollPane)) {
            offset += this.layoutOrientation == 3 ? p.posY : p.posX;
            p = p.parent;
        }
        if (this.layoutOrientation == 3) {
            this.scrollRectToVisible(pos, -offset, size, 1, false);
        } else {
            this.scrollRectToVisible(-offset, pos, 1, size, false);
        }
        this.ensureIndexIsVisible = i;
    }

    public void actionPerformed(String actionCommand) {
        if (this.selectButton.getActionCommand().equals(actionCommand)) {
            this.fireActionPerformed();
        } else {
            Logger.warn("unknown command in List actionPerformed: " + actionCommand);
        }
    }

    public boolean isUseSelectButton() {
        return this.useSelectButton;
    }

    public void setUseSelectButton(boolean useSelectButton) {
        this.useSelectButton = useSelectButton;
    }

    public String getDefaultName() {
        return "List";
    }

    public void updateUI() {
        super.updateUI();
        if (this.renderer != null) {
            this.renderer.updateUI();
        }
        if (this.selectButton != null) {
            this.selectButton.updateUI();
        }
    }

    public String getToolTipText() {
        if (this.current != -1) {
            Component c = this.getRendererComponentFor(this.current);
            return c.getToolTipText();
        }
        return super.getToolTipText();
    }

    public int getToolTipLocationX() {
        if (this.current != -1) {
            Component c = this.getRendererComponentFor(this.current);
            return c.getX() + c.getToolTipLocationX();
        }
        return super.getToolTipLocationX();
    }

    public int getToolTipLocationY() {
        if (this.current != -1) {
            Component c = this.getRendererComponentFor(this.current);
            return c.getY() + c.getToolTipLocationY();
        }
        return super.getToolTipLocationY();
    }

    public void setFixedCellHeight(int height) {
        if (height == 0) {
            throw new RuntimeException("trying to setFixedCellHeight to 0");
        }
        this.fixedCellHeight = height;
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellWidth(int width) {
        if (width == 0) {
            throw new RuntimeException("trying to setFixedCellWidth to 0");
        }
        this.fixedCellWidth = width;
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setPrototypeCellValue(Object prototypeCellValue) {
        Component c = this.renderer.getListCellRendererComponent(this, prototypeCellValue, 0, false, false);
        c.workoutPreferredSize();
        if (this.getLayoutOrientation() == 0) {
            this.setFixedCellHeight(c.getHeightWithBorder());
        } else {
            this.setFixedCellWidth(c.getWidthWithBorder());
        }
    }

    public int getFirstVisibleIndex() {
        int y;
        int[] v = this.getVisibleRect();
        int x = v[0];
        int i = this.locationToIndex(x, y = v[1])[0];
        if (i < 0 && (this.layoutOrientation == 3 && x < 0 || this.layoutOrientation == 0 && y < 0)) {
            return 0;
        }
        return i;
    }

    public int getLastVisibleIndex() {
        int y;
        int[] v = this.getVisibleRect();
        int x = v[0] + v[2] - 1;
        int i = this.locationToIndex(x, y = v[1] + v[3] - 1)[0];
        if (i < 0 && (this.layoutOrientation == 3 && x >= 0 || this.layoutOrientation == 0 && y >= 0)) {
            return this.getSize() - 1;
        }
        return i;
    }

    public Vector getSelectedValues() {
        if (this.selected == null) {
            Vector<Object> v = new Vector<Object>(1);
            if (this.current >= 0) {
                v.addElement(this.getElementAt(this.current));
            }
            return v;
        }
        return this.selected;
    }

    public void setSelectedValues(Vector v) {
        this.selected = v;
    }

    public int indexOf(Object a) {
        int i = -1;
        int s = this.getSize();
        for (int c = 0; c < s; ++c) {
            Object b = this.getElementAt(c);
            if (a != b && (a == null || !a.equals(b))) continue;
            i = c;
            break;
        }
        return i;
    }

    public Object getElementAt(int index) {
        return this.items != null ? this.items.elementAt(index) : null;
    }

    public void setElementAt(Object object, int index) {
        this.items.setElementAt(object, index);
    }

    public void insertElementAt(Object object, int index) {
        this.items.insertElementAt(object, index);
    }

    public int getSize() {
        return this.items != null ? this.items.size() : -1;
    }

    public void addElement(Object a) {
        this.items.addElement(a);
        this.contentsChanged();
    }

    public boolean removeElement(Object obj) {
        int idx = this.indexOf(obj);
        if (idx >= 0) {
            this.removeElementAt(idx);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        this.items.removeAllElements();
        this.contentsChanged();
    }

    public void removeElementAt(int i) {
        this.items.removeElementAt(i);
        if (this.current > i) {
            --this.current;
        } else if (this.current == i) {
            this.setSelectedIndex(-1);
        }
    }

    public boolean isSelectedIndex(int index) {
        return this.selected == null ? this.current == index : this.selected.contains(this.getElementAt(index));
    }

    public void clearSelection() {
        this.selected = null;
    }
}

