/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.logging;

import java.io.IOException;
import java.io.PrintStream;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import net.yura.mobile.logging.CallStack;
import net.yura.mobile.logging.Logger;

public class FilesystemLogger
extends Logger {
    private Logger logger;
    private static FileConnection file;
    private static PrintStream log;

    public FilesystemLogger(Logger logger) {
        this.logger = logger;
    }

    public FilesystemLogger() {
        this(new Logger());
    }

    private static void open() throws IOException {
        file = (FileConnection)Connector.open((String)(System.getProperty("fileconn.dir.photos") + System.currentTimeMillis() + ".log"), (int)2);
        file.create();
        log = new PrintStream(file.openOutputStream());
    }

    protected synchronized void log(String message, int level) {
        this.logger.log(message, level);
        try {
            if (log == null) {
                FilesystemLogger.open();
            }
            log.println(this.toString(level) + message);
        }
        catch (IOException e) {
            this.logger.log(null, e, 2);
        }
    }

    protected synchronized void log(String error, Throwable throwable, int level) {
        this.logger.log(error, throwable, level);
        try {
            if (log == null) {
                FilesystemLogger.open();
            }
            String stacktrace = CallStack.getStacktrace();
            log.print(this.toString(level) + (error == null ? "" : error + " ") + (stacktrace.length() == 0 ? throwable.toString() + "\n" : stacktrace));
        }
        catch (IOException e) {
            this.logger.log(null, e, 2);
        }
    }

    public static void close() {
        try {
            file.close();
        }
        catch (IOException e) {
            Logger.warn(null, e);
        }
    }
}

