/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.FileUtils;
import org.dita.dost.util.Job;

public final class DITAOTCopy
extends Task {
    private String includes = null;
    private File includesFile = null;
    private String relativePaths = null;
    private File destDir = null;

    public void setIncludes(String incld) {
        this.includes = incld;
    }

    public void setIncludesfile(File includesFile) {
        this.includesFile = includesFile;
    }

    public void setTodir(File destdir) {
        this.destDir = destdir;
    }

    public void setRelativePaths(String relPaths) {
        if (!relPaths.trim().isEmpty()) {
            this.relativePaths = relPaths;
        }
    }

    public void execute() throws BuildException {
        if (this.includes == null && this.includesFile == null) {
            return;
        }
        if (this.destDir == null) {
            throw new BuildException("Destination directory not defined");
        }
        if (!this.destDir.exists()) {
            try {
                Files.createDirectories(this.destDir.toPath(), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
        try {
            FileUtils fileUtils = FileUtils.newFileUtils();
            List<String> incs = this.getIncludes();
            if (this.relativePaths == null) {
                for (String inc : incs) {
                    File srcFile = new File(inc);
                    if (!srcFile.exists()) continue;
                    File destFile = new File(this.destDir, srcFile.getName());
                    fileUtils.copyFile(srcFile, destFile);
                }
            } else {
                for (String inc : incs) {
                    File srcFile = new File(inc);
                    File destFile = null;
                    for (String rel : this.relativePaths.split(",")) {
                        File temp = new File(this.destDir, rel);
                        if (!temp.getName().equalsIgnoreCase(srcFile.getName())) continue;
                        destFile = temp;
                        break;
                    }
                    if (!srcFile.exists() || destFile == null) continue;
                    fileUtils.copyFile(srcFile, destFile);
                }
            }
        }
        catch (IOException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private List<String> getIncludes() throws IOException {
        if (this.includes == null && this.includesFile == null) {
            Job job = (Job)this.getProject().getReference("job");
            return job.getFileInfo(fi -> fi.isFlagImage).stream().map(fi -> fi.file.toString()).collect(Collectors.toList());
        }
        if (this.includesFile != null) {
            ArrayList<String> res = new ArrayList<String>();
            try (BufferedReader r = new BufferedReader(new FileReader(this.includesFile));){
                String line;
                while ((line = r.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    res.add(line.trim());
                }
            }
            return res;
        }
        return Arrays.asList(this.includes.split(","));
    }
}

