/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.checkers.OptInNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J2\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002R\u0018\u0010\u0014\u001a\u00020\u0011*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirAnnotationCallChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;)V", "getSubclassOptInApplicabilityAndMessage", "Lkotlin/Pair;", "", "", "firKlass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "representation", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "getRepresentation", "(Lorg/jetbrains/kotlin/descriptors/ClassKind;)Ljava/lang/String;", "checkOptInIsEnabled", "element", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkOptInArgumentIsMarker", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "annotationClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "source", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInAnnotationCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,141:1\n46#2:142\n1878#3,3:143\n58#4:146\n61#4:147\n*S KotlinDebug\n*F\n+ 1 FirOptInAnnotationCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInAnnotationCallChecker\n*L\n47#1:142\n70#1:143,3\n87#1:146\n90#1:147\n*E\n"})
public final class FirOptInAnnotationCallChecker
extends FirExpressionChecker<FirAnnotationCall> {
    @NotNull
    public static final FirOptInAnnotationCallChecker INSTANCE = new FirOptInAnnotationCallChecker();

    private FirOptInAnnotationCallChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirAnnotationCall expression2) {
        block12: {
            boolean isSubclassOptIn;
            ClassId classId;
            block11: {
                Intrinsics.checkNotNullParameter(context2, "context");
                Intrinsics.checkNotNullParameter(reporter, "reporter");
                Intrinsics.checkNotNullParameter(expression2, "expression");
                ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(FirTypeUtilsKt.getConeType(expression2.getAnnotationTypeRef()));
                if (coneClassLikeLookupTag == null) {
                    return;
                }
                ConeClassLikeLookupTag lookupTag = coneClassLikeLookupTag;
                classId = lookupTag.getClassId();
                boolean isRequiresOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getREQUIRES_OPT_IN_CLASS_ID());
                boolean isOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID());
                isSubclassOptIn = Intrinsics.areEqual(classId, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID());
                if (!isRequiresOptIn && !isOptIn) break block11;
                this.checkOptInIsEnabled(expression2.getSource(), context2, reporter);
                if (!isOptIn) break block12;
                Object $this$arguments$iv = expression2;
                boolean $i$f$getArguments222 = false;
                List<FirExpression> arguments = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments.isEmpty()) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getOPT_IN_WITHOUT_ARGUMENTS(), null, 8, null);
                } else {
                    FirExpression $i$f$getArguments222 = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                    List<FirRegularClassSymbol> list = $i$f$getArguments222 != null ? FirAnnotationHelpersKt.extractClassesFromArgument($i$f$getArguments222, context2.getSession()) : null;
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    $this$arguments$iv = ((Iterable)list).iterator();
                    int $i$f$getArguments222 = 0;
                    while ($this$arguments$iv.hasNext()) {
                        int index = $i$f$getArguments222++;
                        FirRegularClassSymbol classSymbol = (FirRegularClassSymbol)$this$arguments$iv.next();
                        KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression2, index);
                        this.checkOptInArgumentIsMarker(classSymbol, classId, source, reporter, context2);
                    }
                }
                break block12;
            }
            if (isSubclassOptIn) {
                FirClass declaration;
                Object $this$arguments$iv = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClass firClass = declaration = $this$arguments$iv instanceof FirClass ? (FirClass)$this$arguments$iv : null;
                if (declaration != null) {
                    $this$arguments$iv = this.getSubclassOptInApplicabilityAndMessage(declaration);
                    boolean isSubclassOptInApplicable = (Boolean)((Pair)$this$arguments$iv).component1();
                    String message2 = (String)((Pair)$this$arguments$iv).component2();
                    if (!isSubclassOptInApplicable && message2 != null) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSUBCLASS_OPT_IN_INAPPLICABLE(), (Object)message2, null, 16, null);
                        return;
                    }
                }
                FirExpression firExpression = FirAnnotationUtilsKt.findArgumentByName$default(expression2, OptInNames.INSTANCE.getOPT_IN_ANNOTATION_CLASS(), false, 2, null);
                List<FirRegularClassSymbol> list = firExpression != null ? FirAnnotationHelpersKt.extractClassesFromArgument(firExpression, context2.getSession()) : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List<FirRegularClassSymbol> classSymbols = list;
                Iterable $this$forEachIndexed$iv = classSymbols;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void classSymbol;
                    int n2;
                    if ((n2 = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)item$iv;
                    int index = n2;
                    boolean bl = false;
                    KtSourceElement source = FirOptInUsageBaseChecker.INSTANCE.getSourceForIsMarkerDiagnostic(expression2, index);
                    INSTANCE.checkOptInArgumentIsMarker((FirRegularClassSymbol)classSymbol, classId, source, reporter, context2);
                }
            }
        }
    }

    @NotNull
    public final Pair<Boolean, String> getSubclassOptInApplicabilityAndMessage(@NotNull FirClass firKlass) {
        Intrinsics.checkNotNullParameter(firKlass, "firKlass");
        ClassKind kind = firKlass.getClassKind();
        String classKindRepresentation = this.getRepresentation(kind);
        if (kind == ClassKind.ENUM_CLASS || kind == ClassKind.OBJECT || kind == ClassKind.ANNOTATION_CLASS) {
            return TuplesKt.to(false, classKindRepresentation);
        }
        Modality modality = FirHelpersKt.modality(firKlass);
        if (modality == Modality.FINAL || modality == Modality.SEALED) {
            Boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            String string = modality.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
            return TuplesKt.to(bl, stringBuilder.append(string).append(' ').append(classKindRepresentation).toString());
        }
        FirMemberDeclaration $this$isFun$iv = firKlass;
        boolean $i$f$isFun = false;
        if ($this$isFun$iv.getStatus().isFun()) {
            return TuplesKt.to(false, "fun interface");
        }
        FirClassLikeDeclaration $this$isLocal$iv = firKlass;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            return TuplesKt.to(false, "local " + classKindRepresentation);
        }
        return TuplesKt.to(true, null);
    }

    private final String getRepresentation(ClassKind $this$representation) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[$this$representation.ordinal()] == 1) {
            string = "enum entry";
        } else {
            String string2 = $this$representation.getCodeRepresentation();
            string = string2;
            Intrinsics.checkNotNull(string2);
        }
        return string;
    }

    private final void checkOptInIsEnabled(KtSourceElement element, CheckerContext context2, DiagnosticReporter reporter) {
        LanguageVersionSettings languageVersionSettings = FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession());
        List<String> optInFqNames = languageVersionSettings.getFlag(AnalysisFlags.getOptIn());
        if (!languageVersionSettings.supportsFeature(LanguageFeature.OptInRelease) && !optInFqNames.contains(OptInNames.INSTANCE.getREQUIRES_OPT_IN_FQ_NAME().asString())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)element, FirErrors.INSTANCE.getOPT_IN_IS_NOT_ENABLED(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void checkOptInArgumentIsMarker(FirRegularClassSymbol classSymbol, ClassId annotationClassId, KtSourceElement source, DiagnosticReporter reporter, CheckerContext context2) {
        FirOptInUsageBaseChecker $this$checkOptInArgumentIsMarker_u24lambda_u241 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        if (FirOptInUsageBaseChecker.loadExperimentalityForMarkerAnnotation$default($this$checkOptInArgumentIsMarker_u24lambda_u241, classSymbol, context2.getSession(), null, 2, null) == null) {
            KtDiagnosticFactory1<ClassId> ktDiagnosticFactory1;
            ClassId classId = annotationClassId;
            if (Intrinsics.areEqual(classId, OptInNames.INSTANCE.getOPT_IN_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getOPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else if (Intrinsics.areEqual(classId, OptInNames.INSTANCE.getSUBCLASS_OPT_IN_REQUIRED_CLASS_ID())) {
                ktDiagnosticFactory1 = FirErrors.INSTANCE.getSUBCLASS_OPT_IN_ARGUMENT_IS_NOT_MARKER();
            } else {
                return;
            }
            KtDiagnosticFactory1<ClassId> diagnostic = ktDiagnosticFactory1;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)classSymbol.getClassId(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ClassKind.values().length];
            try {
                nArray[ClassKind.ENUM_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

