using System.Diagnostics.Contracts;

namespace Microsoft.Dafny;

public class AutoGeneratedOrigin : OriginWrapper {

  public AutoGeneratedOrigin(IOrigin wrappedOrigin)
    : base(wrappedOrigin) {
    Contract.Requires(wrappedOrigin != null);
  }

  public static IOrigin Unwrap(IOrigin token) {
    if (token is AutoGeneratedOrigin autoGeneratedToken) {
      return Unwrap(autoGeneratedToken.WrappedOrigin);
    }

    return token;
  }

  public static bool Is(IOrigin tok) {
    while (tok is OriginWrapper w) {
      if (w is AutoGeneratedOrigin) {
        return true;
      }
      tok = w.WrappedOrigin;
    }
    return false;
  }

  public static Expression WrapExpression(Expression expr) {
    return Expression.CreateParensExpression(new AutoGeneratedOrigin(expr.Origin), expr);
  }

  public override bool IsCopy => true;
}