/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;

public abstract class ListenerHandle
implements AutoCloseable {
    protected final XMPPConnection connection;
    protected final StanzaListener listener;

    private ListenerHandle(XMPPConnection connection, StanzaListener listener) {
        this.connection = connection;
        this.listener = listener;
    }

    public abstract boolean removeListener();

    @Override
    public final void close() {
        this.removeListener();
    }

    static class SyncStanzaListenerHandle
    extends ListenerHandle {
        SyncStanzaListenerHandle(XMPPConnection connection, StanzaListener listener) {
            super(connection, listener);
        }

        @Override
        public boolean removeListener() {
            return this.connection.removeSyncStanzaListener(this.listener);
        }
    }

    static class AsyncStanzaListenerHandle
    extends ListenerHandle {
        AsyncStanzaListenerHandle(XMPPConnection connection, StanzaListener listener) {
            super(connection, listener);
        }

        @Override
        public boolean removeListener() {
            return this.connection.removeAsyncStanzaListener(this.listener);
        }
    }

    static class StanzaListenerHandle
    extends ListenerHandle {
        StanzaListenerHandle(XMPPConnection connection, StanzaListener listener) {
            super(connection, listener);
        }

        @Override
        public boolean removeListener() {
            return this.connection.removeStanzaListener(this.listener);
        }
    }
}

