/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.mam.element.MamElementFactory;
import org.jivesoftware.smackx.mam.element.MamFinIQ;
import org.jivesoftware.smackx.rsm.packet.RSMSet;
import org.jivesoftware.smackx.rsm.provider.RSMSetProvider;
import org.jxmpp.JxmppContext;

public class MamFinIQProvider
extends IqProvider<MamFinIQ> {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MamFinIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        MamElementFactory elementFactory = MamElementFactory.forParser(parser);
        String queryId = parser.getAttributeValue("", "queryid");
        boolean complete = ParserUtils.getBooleanAttribute(parser, "complete", false);
        boolean stable = ParserUtils.getBooleanAttribute(parser, "stable", true);
        RSMSet rsmSet = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    if (!parser.getName().equals("set")) break;
                    rsmSet = (RSMSet)RSMSetProvider.INSTANCE.parse(parser);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return elementFactory.newFinIQ(queryId, rsmSet, complete, stable);
                }
            }
        }
    }
}

