/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.muc.DirectMucInvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.packet.GroupChatInvitation;
import org.jxmpp.jid.EntityBareJid;

public final class DirectMucInvitationManager
extends Manager {
    private static final Map<XMPPConnection, DirectMucInvitationManager> INSTANCES = new WeakHashMap<XMPPConnection, DirectMucInvitationManager>();
    private final List<DirectMucInvitationListener> directMucInvitationListeners = new ArrayList<DirectMucInvitationListener>();
    private final ServiceDiscoveryManager serviceDiscoveryManager;

    public static synchronized DirectMucInvitationManager getInstanceFor(XMPPConnection connection) {
        DirectMucInvitationManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new DirectMucInvitationManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    private DirectMucInvitationManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor(connection);
        this.connection().addAsyncStanzaListener(stanza -> {
            GroupChatInvitation invitation = stanza.getExtension(GroupChatInvitation.class);
            for (DirectMucInvitationListener listener : this.directMucInvitationListeners) {
                listener.invitationReceived(invitation, stanza);
            }
        }, new StanzaExtensionFilter("x", "jabber:x:conference"));
        this.serviceDiscoveryManager.addFeature("jabber:x:conference");
    }

    public void inviteToMuc(MultiUserChat muc, EntityBareJid user) throws SmackException.NotConnectedException, InterruptedException {
        this.inviteToMuc(muc, user, null, null, false, null);
    }

    public void inviteToMuc(MultiUserChat muc, EntityBareJid user, String password, String reason, boolean continueAsOneToOneChat, String thread) throws SmackException.NotConnectedException, InterruptedException {
        this.inviteToMuc(user, new GroupChatInvitation(muc.getRoom(), reason, password, continueAsOneToOneChat, thread));
    }

    public void inviteToMuc(EntityBareJid jid, GroupChatInvitation invitation) throws SmackException.NotConnectedException, InterruptedException {
        Message invitationMessage = ((MessageBuilder)((MessageBuilder)MessageBuilder.buildMessage().to(jid)).addExtension(invitation)).build();
        this.connection().sendStanza(invitationMessage);
    }

    public boolean userSupportsInvitations(EntityBareJid jid) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return this.serviceDiscoveryManager.supportsFeature(jid, "jabber:x:conference");
    }

    public synchronized void addInvitationListener(DirectMucInvitationListener listener) {
        this.directMucInvitationListeners.add(listener);
    }

    public synchronized void removeInvitationListener(DirectMucInvitationListener listener) {
        this.directMucInvitationListeners.remove(listener);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(DirectMucInvitationManager::getInstanceFor);
    }
}

