/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.util.Date;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class PubkeyElement
implements ExtensionElement {
    public static final String NAMESPACE = "urn:xmpp:openpgp:0";
    public static final String ELEMENT = "pubkey";
    public static final String ATTR_DATE = "date";
    private final PubkeyDataElement dataElement;
    private final Date date;

    public PubkeyElement(PubkeyDataElement dataElement, Date date) {
        this.dataElement = Objects.requireNonNull(dataElement);
        this.date = date;
    }

    public PubkeyDataElement getDataElement() {
        return this.dataElement;
    }

    public Date getDate() {
        return this.date;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this).optAttribute(ATTR_DATE, this.date).rightAngleBracket().append(this.getDataElement()).closeElement(this);
        return xml;
    }

    public static class PubkeyDataElement
    implements ExtensionElement {
        public static final String ELEMENT = "data";
        private final String b64Data;
        private transient byte[] pubKeyBytesCache;

        public PubkeyDataElement(String b64Data) {
            this.b64Data = Objects.requireNonNull(b64Data);
        }

        public String getB64Data() {
            return this.b64Data;
        }

        public byte[] getPubKeyBytes() {
            if (this.pubKeyBytesCache == null) {
                this.pubKeyBytesCache = Base64.decode(this.b64Data);
            }
            return (byte[])this.pubKeyBytesCache.clone();
        }

        @Override
        public String getElementName() {
            return ELEMENT;
        }

        @Override
        public String getNamespace() {
            return PubkeyElement.NAMESPACE;
        }

        @Override
        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder(this, enclosingNamespace).rightAngleBracket().append(this.b64Data).closeElement(this);
            return xml;
        }
    }
}

