/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.stringprep.simple;

import java.util.Arrays;
import java.util.Locale;
import org.jxmpp.JxmppContext;
import org.jxmpp.XmppAddressParttype;
import org.jxmpp.stringprep.XmppStringprep;
import org.jxmpp.stringprep.XmppStringprepException;
import org.jxmpp.util.ArraysUtil;

public final class SimpleXmppStringprep
implements XmppStringprep {
    private static SimpleXmppStringprep instance;
    public static final String NAME = "simple";
    private static final char[] LOCALPART_FURTHER_EXCLUDED_CHARACTERS;
    private static final char[] USERNAME_CASE_MAPPED_EXCLUDED_CHARACTERS;
    private static final char[] LOCALPART_EXCLUDED_CHARACTERS;

    public static void setup() {
        JxmppContext.setDefaultXmppStringprep(SimpleXmppStringprep.getInstance());
    }

    public static SimpleXmppStringprep getInstance() {
        if (instance == null) {
            instance = new SimpleXmppStringprep();
        }
        return instance;
    }

    private SimpleXmppStringprep() {
    }

    @Override
    public String localprep(String string2) throws XmppStringprepException {
        string2 = SimpleXmppStringprep.simpleStringprep(string2);
        SimpleXmppStringprep.ensurePartDoesNotContain(XmppAddressParttype.localpart, string2, LOCALPART_EXCLUDED_CHARACTERS);
        SimpleXmppStringprep.ensureValid(XmppAddressParttype.localpart, string2);
        return string2;
    }

    private static void ensurePartDoesNotContain(XmppAddressParttype parttype, String input, char[] excludedChars) throws XmppStringprepException {
        assert (SimpleXmppStringprep.isSorted(excludedChars));
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            int forbiddenCharPos = Arrays.binarySearch(excludedChars, c);
            if (forbiddenCharPos < 0) continue;
            throw new XmppStringprepException(input, parttype.getCapitalizedName() + " must not contain '" + excludedChars[forbiddenCharPos] + "'");
        }
    }

    public static void ensureLocalpartDoesNotIncludeFurtherExcludedCharacters(String localpart) throws XmppStringprepException {
        SimpleXmppStringprep.ensurePartDoesNotContain(XmppAddressParttype.localpart, localpart, LOCALPART_FURTHER_EXCLUDED_CHARACTERS);
    }

    @Override
    public String domainprep(String string2) throws XmppStringprepException {
        string2 = SimpleXmppStringprep.simpleStringprep(string2);
        SimpleXmppStringprep.ensureValid(XmppAddressParttype.localpart, string2);
        return string2;
    }

    @Override
    public String resourceprep(String string2) throws XmppStringprepException {
        SimpleXmppStringprep.ensureValid(XmppAddressParttype.resourcepart, string2);
        return string2;
    }

    private static String simpleStringprep(String string2) {
        String res = string2.toLowerCase(Locale.US);
        return res;
    }

    private static boolean isSorted(char[] chars) {
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i - 1] <= chars[i]) continue;
            return false;
        }
        return true;
    }

    private static void ensureValid(XmppAddressParttype parttype, String input) throws XmppStringprepException {
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            boolean disallowedAsciiChar = SimpleXmppStringprep.isDisallowedAsciiChar(c);
            if (!disallowedAsciiChar) continue;
            throw new XmppStringprepException(input, parttype.getCapitalizedName() + " does contain disallowed ASCII character at pos " + i);
        }
    }

    private static boolean isDisallowedAsciiChar(char c) {
        if (c >= ' ') {
            return false;
        }
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return false;
            }
        }
        return true;
    }

    static {
        LOCALPART_FURTHER_EXCLUDED_CHARACTERS = new char[]{'\"', '&', '\'', '/', ':', '<', '>', '@'};
        USERNAME_CASE_MAPPED_EXCLUDED_CHARACTERS = new char[]{' '};
        Arrays.sort(LOCALPART_FURTHER_EXCLUDED_CHARACTERS);
        LOCALPART_EXCLUDED_CHARACTERS = ArraysUtil.concatenate(LOCALPART_FURTHER_EXCLUDED_CHARACTERS, USERNAME_CASE_MAPPED_EXCLUDED_CHARACTERS);
        Arrays.sort(LOCALPART_EXCLUDED_CHARACTERS);
    }
}

