/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum CompressionAlgorithm {
    UNCOMPRESSED(0),
    ZIP(1),
    ZLIB(2),
    BZIP2(3);

    private static final Map<Integer, CompressionAlgorithm> MAP;
    private final int algorithmId;

    @Nullable
    public static CompressionAlgorithm fromId(int id) {
        return MAP.get(id);
    }

    @Nonnull
    public static CompressionAlgorithm requireFromId(int id) {
        CompressionAlgorithm algorithm = CompressionAlgorithm.fromId(id);
        if (algorithm == null) {
            throw new NoSuchElementException("No CompressionAlgorithm found for id " + id);
        }
        return algorithm;
    }

    private CompressionAlgorithm(int id) {
        this.algorithmId = id;
    }

    public int getAlgorithmId() {
        return this.algorithmId;
    }

    static {
        MAP = new ConcurrentHashMap<Integer, CompressionAlgorithm>();
        for (CompressionAlgorithm c : CompressionAlgorithm.values()) {
            MAP.put(c.algorithmId, c);
        }
    }
}

