/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.algorithm;

public class Trustworthiness {
    private final int amount;
    private final int depth;
    public static final int THRESHOLD_FULLY_CONVINCED = 120;
    public static final int MARGINALLY_CONVINCED = 60;
    public static final int NOT_TRUSTED = 0;

    public Trustworthiness(int amount, int depth) {
        this.amount = Trustworthiness.capAmount(amount);
        this.depth = Trustworthiness.capDepth(depth);
    }

    public int getAmount() {
        return this.amount;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean isNotTrusted() {
        return this.getAmount() == 0;
    }

    public boolean isMarginallyTrusted() {
        return this.getAmount() > 0;
    }

    public boolean isFullyTrusted() {
        return this.getAmount() >= 120;
    }

    public boolean isIntroducer() {
        return this.getDepth() >= 1;
    }

    public boolean canIntroduce(int otherDepth) {
        return this.getDepth() > otherDepth;
    }

    public boolean canIntroduce(Trustworthiness other) {
        return this.canIntroduce(other.getDepth());
    }

    public static Builder fullyTrusted() {
        return new Builder(120);
    }

    public static Builder marginallyTrusted() {
        return new Builder(60);
    }

    public static Builder untrusted() {
        return new Builder(0);
    }

    private static int capAmount(int amount) {
        if (amount < 0 || amount > 255) {
            throw new IllegalArgumentException("Trust amount MUST be a value between 0 and 255");
        }
        return amount;
    }

    private static int capDepth(int depth) {
        if (depth < 0 || depth > 255) {
            throw new IllegalArgumentException("Trust depth MUST be a value between 0 and 255");
        }
        return depth;
    }

    public static final class Builder {
        private final int amount;

        private Builder(int amount) {
            this.amount = amount;
        }

        public Trustworthiness introducer() {
            return new Trustworthiness(this.amount, 1);
        }

        public Trustworthiness metaIntroducer() {
            return new Trustworthiness(this.amount, 2);
        }

        public Trustworthiness metaIntroducerOfDepth(int n) {
            return new Trustworthiness(this.amount, n);
        }
    }
}

