# `cora-macs` LaTeX Package

## Overview

The `cora-macs` package is a LaTeX package designed to assist in the representation and manipulation of continuous sets, operations, neural networks, and color schemes tailored for use in the context of cyber-physical systems. It provides a comprehensive set of macros that streamline the process of documenting complex mathematical objects and operations.

## Authors

- **Tobias Ladner**
- **Lukas Koller**

TUM - Cyber-Physical Systems Group

Visit our website: [TUM CPS Group](https://www.ce.cit.tum.de/cps)

## Features

- **Continuous Sets**: Macros for defining and working with intervals, zonotopes, polynomial zonotopes, and other set-based representations.
- **Operations**: A collection of macros for common mathematical operations used in cyber-physical systems analysis.
- **Neural Networks**: Notations for layers, activations, set propagation, and more.
- **Color Schemes**: Predefined color palettes including TUM-specific colors and custom `cora-macs` colors.

## Installation

To use the `cora-macs` package in your LaTeX documents, follow these steps:

1. **Download the Package**: Download the `cora-macs.sty` file and save it to your project directory or in a directory where LaTeX can find it (e.g., in the local `texmf` tree).

2. **Include the Package**: Add the following line to the preamble of your LaTeX document:
   ```latex
   \usepackage[options]{cora-macs}
   ```
   Replace `[options]` with the desired options (e.g., `sets`, `operations`, `nn`, `colors`, `tumcolors`).

## Usage

### Basic Example

Here’s a simple example of how to use some of the features provided by the `cora-macs` package:

```latex
\documentclass{article}
\usepackage[sets, operations]{cora-macs}

\begin{document}

% Define a set
\contSet{X} = \shortContSet{a}{b}{X}

% Use an operation
\diag{A} = \operator{diag}{A}

\end{document}
```

### Options

- **`sets`**: Enables macros for working with continuous sets.
- **`operations`**: Enables macros for common operations in mathematical analysis.
- **`nn`**: Enables macros related to neural networks.
- **`colors`**: Defines a set of colors specific to the `cora-macs` package.
- **`tumcolors`**: Defines TUM-specific colors.

You can combine these options as needed when including the package.

## Documentation

For detailed documentation, including a complete list of commands and options, please refer to the [documentation](./documentation.pdf).

## License

This project is licensed under the MIT License - see the [LICENSE](./LICENSE) file for details.

## Acknowledgments

This package was developed as part of the work done by the Cyber-Physical Systems Group at TUM. We would like to thank the contributors and users who provided valuable feedback.

## Contributing

If you wish to contribute to the `cora-macs` package, feel free to submit a pull request or open an issue on the repository.

## Contact

For questions, issues, or suggestions, please contact:

- Tobias Ladner - [tobias.ladner@tum.de](mailto:tobias.ladner@tum.de)
- Lukas Koller - [lukas.koller@tum.de](mailto:lukas.koller@tum.de)

---

Developed at TUM - Cyber-Physical Systems Group