<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pgbouncer/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pgbouncer/metadata.yaml"
sidebar_label: "PgBouncer"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# PgBouncer


<img src="https://netdata.cloud/img/postgres.svg" width="150"/>


Plugin: go.d.plugin
Module: pgbouncer

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors PgBouncer servers.

Executed queries:

- `SHOW VERSION;`
- `SHOW CONFIG;`
- `SHOW DATABASES;`
- `SHOW STATS;`
- `SHOW POOLS;`

Information about the queries can be found in the [PgBouncer Documentation](https://www.pgbouncer.org/usage.html).




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per PgBouncer instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| pgbouncer.client_connections_utilization | used | percentage |

### Per database

These metrics refer to the database.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| database | database name |
| postgres_database | Postgres database name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| pgbouncer.db_client_connections | active, waiting, cancel_req | connections |
| pgbouncer.db_server_connections | active, idle, used, tested, login | connections |
| pgbouncer.db_server_connections_utilization | used | percentage |
| pgbouncer.db_clients_wait_time | time | seconds |
| pgbouncer.db_client_max_wait_time | time | seconds |
| pgbouncer.db_transactions | transactions | transactions/s |
| pgbouncer.db_transactions_time | time | seconds |
| pgbouncer.db_transaction_avg_time | time | seconds |
| pgbouncer.db_queries | queries | queries/s |
| pgbouncer.db_queries_time | time | seconds |
| pgbouncer.db_query_avg_time | time | seconds |
| pgbouncer.db_network_io | received, sent | B/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Create netdata user

Create a user with `stats_users` permissions to query your PgBouncer instance.

To create the `netdata` user:

- Add `netdata` user to the `pgbouncer.ini` file:

  ```text
  stats_users = netdata
  ```

- Add a password for the `netdata` user to the `userlist.txt` file:

  ```text
  "netdata" "<PASSWORD>"
  ```

- To verify the credentials, run the following command

  ```bash
  psql -h localhost -U netdata -p 6432 pgbouncer -c "SHOW VERSION;" >/dev/null 2>&1 && echo OK || echo FAIL
  ```

  When it prompts for a password, enter the password you added to `userlist.txt`.



### Configuration

#### File

The configuration file name for this integration is `go.d/pgbouncer.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/pgbouncer.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| dsn | PgBouncer server DSN (Data Source Name). See [DSN syntax](https://www.postgresql.org/docs/current/libpq-connect.html#LIBPQ-CONNSTRING). | postgres://postgres:postgres@127.0.0.1:6432/pgbouncer | yes |
| timeout | Query timeout in seconds. | 1 | no |

</details>

#### Examples

##### TCP socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: 'postgres://postgres:postgres@127.0.0.1:6432/pgbouncer'

```
</details>

##### Unix socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: 'host=/tmp dbname=pgbouncer user=postgres port=6432'

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    dsn: 'postgres://postgres:postgres@127.0.0.1:6432/pgbouncer'

  - name: remote
    dsn: 'postgres://postgres:postgres@203.0.113.10:6432/pgbouncer'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `pgbouncer` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m pgbouncer
  ```

### Getting Logs

If you're encountering problems with the `pgbouncer` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep pgbouncer
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep pgbouncer /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep pgbouncer
```


