use super::derive;

use super::expand_with;

#[test]
pub(crate) fn insertable_1() {
    let input = quote::quote! {
        struct User {
            id: i32,
            name: String,
        }
    };

    expand_with(
        &crate::derive_insertable_inner as &dyn Fn(_) -> _,
        input,
        derive(syn::parse_quote!(#[derive(Insertable)])),
        "insertable_1",
    );
}
