'use client';
'use strict';

var React = require('react');
var useCallbackRef = require('../use-callback-ref/use-callback-ref.cjs');

function useDebouncedCallback(callback, delay) {
  const handleCallback = useCallbackRef.useCallbackRef(callback);
  const debounceTimerRef = React.useRef(0);
  React.useEffect(() => () => window.clearTimeout(debounceTimerRef.current), []);
  return React.useCallback(
    (...args) => {
      window.clearTimeout(debounceTimerRef.current);
      debounceTimerRef.current = window.setTimeout(() => handleCallback(...args), delay);
    },
    [handleCallback, delay]
  );
}

exports.useDebouncedCallback = useDebouncedCallback;
//# sourceMappingURL=use-debounced-callback.cjs.map
