'use client';
'use strict';

var React = require('react');

const DEFAULT_EVENTS = [
  "keypress",
  "mousemove",
  "touchmove",
  "click",
  "scroll"
];
const DEFAULT_OPTIONS = {
  events: DEFAULT_EVENTS,
  initialState: true
};
function useIdle(timeout, options) {
  const { events, initialState } = { ...DEFAULT_OPTIONS, ...options };
  const [idle, setIdle] = React.useState(initialState);
  const timer = React.useRef(-1);
  React.useEffect(() => {
    const handleEvents = () => {
      setIdle(false);
      if (timer.current) {
        window.clearTimeout(timer.current);
      }
      timer.current = window.setTimeout(() => {
        setIdle(true);
      }, timeout);
    };
    events.forEach((event) => document.addEventListener(event, handleEvents));
    timer.current = window.setTimeout(() => {
      setIdle(true);
    }, timeout);
    return () => {
      events.forEach((event) => document.removeEventListener(event, handleEvents));
    };
  }, [timeout]);
  return idle;
}

exports.useIdle = useIdle;
//# sourceMappingURL=use-idle.cjs.map
