/******************************************************************************
 *{@C
 *      Copyright:      2006-2022 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dGl2ps
 *      Filename:       gl2ps.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the gl2ps library.
 *
 *****************************************************************************/

%module gl2ps

%{
#include <stdio.h>
#if defined (WIN32)
#include <windows.h>
#include <wingdi.h>
#endif
#include "gl2ps.h"
%}

%include tcl3dDefines.i

// The gl2psBeginPage function expects a "FILE *" as input. So we wrap the
// C functions from stdio.h: fopen and fclose.
FILE *fopen(const char *filename, const char *mode);
int fclose(FILE *);

%include "gl2ps.h"
