/******************************************************************************
 *{@C
 *      Copyright:      2006-2016 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dUtilArcBall.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Arcball functions for mouse manipulation.
 *
 *                      This C implementation has been derived from the ArcBall
 *                      class contained in NeHe's lesson 48. 
 *
 *                      It's original copyright and version history are:
 *                      (C) 1999-2003 Tatewake.com
 *                      08/17/2003 - (TJG) - Creation
 *                      09/23/2003 - (TJG) - Bug fix and optimization
 *                      09/25/2003 - (TJG) - Version for NeHe Basecode users
 *
 *****************************************************************************/

#ifndef __TCL3D_UTIL_ARCBALL_H__
#define __TCL3D_UTIL_ARCBALL_H__

typedef struct arcBallStruct {
    float stVec[3];      /* Saved click vector  */
    float enVec[3];      /* Saved drag vector   */
    float adjustWidth;   /* Mouse bounds width  */
    float adjustHeight;  /* Mouse bounds height */
} ArcBallStruct;

typedef struct arcBallStruct *ArcBall;

#ifdef __cplusplus
   extern "C" {
#endif

    ArcBall tcl3dNewArcBall (float newWidth, float newHeight);
    void    tcl3dDeleteArcBall (ArcBall b);
    void    tcl3dSetArcBallBounds (ArcBall b, float newWidth, float newHeight);
    void    tcl3dArcBallClick (ArcBall b, float mx, float my);
    void    tcl3dArcBallDrag (ArcBall b, float mx, float my, float *newRot);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_UTIL_ARCBALL_H__ */
