// JavaScript Cookie Library.  Assembled by James A. Pattie
// Xperience, Inc.  (http://www.pcxperience.com/)
// 01/22/2002
// Borrowed from http://www.xs4all.nl/~ppk/js/cookies.html
// 2004-03-05 Added to the HTMLObject project.
// 2005-04-06 Updated to support specifying the domain and path parameters.

function encodeCookiePart(value)
{
  if (value.length > 0)
  {
    // first we need to convert: + -> %2b, % -> %25, convert % first.
    value = value.replace(/%/g, "%25");
    value = value.replace(/[+]/g, "%2b");
    value = value.replace(/ /g, "+");

    value = escape(value);
  }

  return value;
}

function decodeCookiePart(value)
{
  // turn the +'s back into spaces.
  value = value.replace(/\+/g, " ");

  value = unescape(value);

  // turn the %2b back into +
  value = value.replace(/%2b/, "+");

  return value;
}

function createCookie(name,value,days,domain,path)
{
 if (days)
 {
  var date = new Date();
  date.setTime(date.getTime()+(days*24*60*60*1000));
  var expires = "; expires="+date.toGMTString();
 }
 else var expires = "";
 var domainPath = "";
 if (domain && domain.length > 0)
 {
   domainPath += "; domain=" + domain;
 }
 if (path && path.length > 0)
 {
   domainPath += "; path=" + path;
 }
 else
 {
   domainPath += "; path=/";
 }
 var ck = encodeCookiePart(name)+"="+encodeCookiePart(value)+expires+domainPath;
 document.cookie = ck;
 //alert(ck);
}

function readCookie(name)
{
 var nameEQ = encodeCookiePart(name) + "=";
 var ca = document.cookie.split(';');
 for(var i=0;i<ca.length;i++)
 {
  var c = ca[i];
  while (c.charAt(0)==' ') c = c.substring(1,c.length);
  if (c.indexOf(nameEQ) == 0) return decodeCookiePart(c.substring(nameEQ.length,c.length));
 }
 return null;
}

function eraseCookie(name, domain, path)
{
 createCookie(name,"",-1, domain, path);
}



