/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpFilter {
    private static final String IP_FILTER_RULE_CHAR = "0123456789-.* ";
    private static final Pattern PATTERN = Pattern.compile("(([0-9]*)(-([0-9]*))?)");
    private static final Logger logger = LoggerFactory.getLogger(IpFilter.class);
    String rawFilter;
    List<Predicate> matchers = new ArrayList<Predicate>();
    Set<String> logged = new HashSet<String>();

    public IpFilter() {
    }

    public IpFilter(String f) {
        this.setRawFilter(f);
    }

    public synchronized String getRawFilter() {
        return this.rawFilter;
    }

    public synchronized void setRawFilter(String rawFilter) {
        if (this.rawFilter != null && this.rawFilter.equals(rawFilter)) {
            return;
        }
        this.matchers.clear();
        this.logged.clear();
        this.rawFilter = rawFilter;
        if (rawFilter != null) {
            String[] rules;
            for (String r : rules = rawFilter.split("[,;]")) {
                Predicate p = this.parse(r);
                if (p == null) continue;
                this.matchers.add(p);
            }
        }
    }

    public String toString() {
        return "IpFilter:" + this.getNormalizedFilter();
    }

    public String getNormalizedFilter() {
        StringBuilder b = new StringBuilder();
        for (Predicate r : this.matchers) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(r);
        }
        return b.toString();
    }

    public boolean isMatch(InetAddress addr) {
        for (Predicate predicate : this.matchers) {
            if (!predicate.match(addr)) continue;
            return true;
        }
        return false;
    }

    public boolean allowed(InetAddress addr) {
        boolean log = this.isFirstDecision(addr);
        if (this.matchers.size() == 0) {
            if (log) {
                logger.info("No IP filter specified, access granted to " + addr);
            }
            return true;
        }
        for (Predicate p : this.matchers) {
            if (!p.match(addr)) continue;
            if (log) {
                logger.info("Access granted to " + addr + " by rule: " + p);
            }
            return true;
        }
        if (log) {
            logger.info("Access denied to " + addr);
        }
        return false;
    }

    Predicate parse(String rule) {
        if ((rule = rule.trim()).length() == 0) {
            return null;
        }
        for (int i = 0; i < rule.length(); ++i) {
            if (IP_FILTER_RULE_CHAR.indexOf(rule.charAt(i)) != -1) continue;
            return new HostNamePredicate(rule);
        }
        String[] tags = rule.split("\\.");
        return new IpPredicate(tags);
    }

    private synchronized boolean isFirstDecision(InetAddress addr) {
        String ip = addr.getHostAddress();
        if (!this.logged.contains(ip)) {
            this.logged.add(ip);
            return true;
        }
        return false;
    }

    private static void eq(String name, Object obj, Object obj2) {
        if (obj == null || !obj.equals(obj2)) {
            throw new RuntimeException(name + " expected : '" + obj + "' <> actual : '" + obj2 + "'");
        }
        logger.debug("EQ: " + name + '=' + obj);
    }

    public static void main(String[] args) {
        IpFilter.eq("f1", "192.168.0.1,192.168.0.5", new IpFilter(" 192.168.0.1, 192.168.0.5").getNormalizedFilter());
        IpFilter.eq("f2", "192.168.0.*,192.1-6.3-.5", new IpFilter(" 192.168.0.*, 192.1-6.3-.5").getNormalizedFilter());
        IpFilter.eq("f3", "2-3.5,myhost", new IpFilter(" 3-2. 5;myhost").getNormalizedFilter());
    }

    static class IpPredicate
    implements Predicate {
        List<ByteRule> rules;

        public IpPredicate(String[] tags) {
            this.rules = new ArrayList<ByteRule>(tags.length);
            for (String s : tags) {
                s = s.trim();
                this.rules.add(this.parseTag(s));
            }
        }

        ByteRule parseTag(String s) {
            if ("*".equals(s)) {
                return new ByteRule(-1, -1);
            }
            Matcher matcher = PATTERN.matcher(s);
            if (matcher.matches()) {
                String start = matcher.group(2);
                String middle = matcher.group(3);
                String ending = matcher.group(4);
                if (IpPredicate.valid(start)) {
                    int x = Integer.parseInt(start);
                    if (IpPredicate.valid(ending)) {
                        return new ByteRule(x, Integer.parseInt(ending));
                    }
                    if (IpPredicate.valid(middle)) {
                        return new ByteRule(x, -1);
                    }
                    return new ByteRule(x, x);
                }
                if (IpPredicate.valid(ending)) {
                    return new ByteRule(-1, Integer.parseInt(ending));
                }
            }
            throw new IllegalArgumentException("Tag is not understood:" + s);
        }

        private static boolean valid(String s) {
            return s != null && s.length() > 0;
        }

        @Override
        public boolean match(InetAddress addr) {
            byte[] b = addr.getAddress();
            for (int i = 0; i < this.rules.size() && i < b.length; ++i) {
                int value;
                int n = value = b[i] < 0 ? b[i] + 256 : b[i];
                if (this.rules.get(i).match(value)) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (ByteRule r : this.rules) {
                if (b.length() > 0) {
                    b.append('.');
                }
                b.append(r);
            }
            return b.toString();
        }

        static class ByteRule {
            int min;
            int max;

            public ByteRule(int a, int b) {
                this.min = a;
                this.max = b;
                if (b > -1 && a > -1 && b < a) {
                    this.max = a;
                    this.min = b;
                }
            }

            boolean match(int value) {
                if (this.min >= 0 && value < this.min) {
                    return false;
                }
                return this.max < 0 || value <= this.max;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                if (this.min >= 0) {
                    builder.append(this.min);
                    if (this.max > this.min) {
                        builder.append('-').append(this.max);
                    } else if (this.max < 0) {
                        builder.append('-');
                    }
                } else if (this.max >= 0) {
                    builder.append('-').append(this.max);
                } else {
                    builder.append('*');
                }
                return builder.toString();
            }
        }
    }

    static class HostNamePredicate
    implements Predicate {
        String name;

        public HostNamePredicate(String n) {
            this.name = n.toLowerCase().trim();
        }

        @Override
        public boolean match(InetAddress addr) {
            return addr.getHostName().contains(this.name);
        }

        public String toString() {
            return this.name;
        }
    }

    static interface Predicate {
        public boolean match(InetAddress var1);
    }
}

