/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;
import net.pms.Messages;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.dlna.DLNAResource;
import net.pms.encoders.FFmpegBase;
import net.pms.encoders.PlayerPurpose;
import net.pms.formats.Format;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.util.PlayerUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegDVRMSRemux
extends FFmpegBase {
    private final Logger logger = LoggerFactory.getLogger(FFmpegDVRMSRemux.class);
    private final PmsConfiguration configuration;
    private JTextField altffpath;
    public static final String ID = "ffmpegdvrmsremux";

    public FFmpegDVRMSRemux(PmsConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
    }

    @Override
    public PlayerPurpose getPurpose() {
        return PlayerPurpose.MISC_PLAYER;
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public String name() {
        return "FFmpeg DVR-MS Remux";
    }

    @Override
    public int type() {
        return 4;
    }

    @Deprecated
    protected String[] getDefaultArgs() {
        return new String[]{"-vcodec", "copy", "-acodec", "copy", "-threads", "2", "-g", "1", "-qscale", "1", "-qmin", "2", "-f", "vob", "-copyts"};
    }

    @Override
    @Deprecated
    public String[] args() {
        return this.getDefaultArgs();
    }

    @Override
    public String mimeType() {
        return "video/mpeg";
    }

    @Override
    public ProcessWrapper launchTranscode(DLNAResource dlna, DLNAMediaInfo media, OutputParams params) throws IOException {
        String[] customSettingsArray;
        String ffmpegAlternativePath = this.configuration.getFfmpegAlternativePath();
        ArrayList<String> cmdList = new ArrayList<String>();
        String filename = dlna.getSystemName();
        cmdList.addAll(this.getGlobalOptions(this.logger));
        if (ffmpegAlternativePath != null && ffmpegAlternativePath.length() > 0) {
            cmdList.add(ffmpegAlternativePath);
        } else {
            cmdList.add(this.executable());
        }
        if (params.timeseek > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + params.timeseek);
        }
        cmdList.add("-i");
        cmdList.add(filename);
        for (String arg : this.args()) {
            cmdList.add(arg);
        }
        String customSettingsString = this.configuration.getMPEG2MainSettingsFFmpeg();
        if (StringUtils.isNotBlank(customSettingsString) && (customSettingsArray = StringUtils.split(customSettingsString)) != null) {
            for (String option : customSettingsArray) {
                cmdList.add(option);
            }
        }
        cmdList.add("pipe:");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        cmdArray = this.finalizeTranscoderArgs(filename, dlna, media, params, cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.runInNewThread();
        return pw;
    }

    @Override
    public JComponent config() {
        FormLayout layout = new FormLayout("left:pref, 3dlu, p, 3dlu, 0:grow", "p, 3dlu, p, 3dlu, 0:grow");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setBorder(Borders.EMPTY_BORDER);
        builder.setOpaque(false);
        CellConstraints cc = new CellConstraints();
        JComponent cmp = builder.addSeparator(Messages.getString("FFmpegDVRMSRemux.1"), cc.xyw(1, 1, 5));
        cmp = (JComponent)cmp.getComponent(0);
        cmp.setFont(cmp.getFont().deriveFont(1));
        builder.addLabel(Messages.getString("FFmpegDVRMSRemux.0"), cc.xy(1, 3));
        this.altffpath = new JTextField(this.configuration.getFfmpegAlternativePath());
        this.altffpath.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FFmpegDVRMSRemux.this.configuration.setFfmpegAlternativePath(FFmpegDVRMSRemux.this.altffpath.getText());
            }
        });
        builder.add((Component)this.altffpath, cc.xyw(3, 3, 3));
        return builder.getPanel();
    }

    @Override
    public boolean isPlayerCompatible(RendererConfiguration mediaRenderer) {
        return mediaRenderer.isTranscodeToMPEGPSAC3();
    }

    @Override
    public boolean isCompatible(DLNAResource resource) {
        return PlayerUtil.isVideo(resource, Format.Identifier.DVRMS);
    }
}

