/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import net.pms.network.RequestHandlerV2;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerPipelineFactory
implements ChannelPipelineFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerPipelineFactory.class);
    private ChannelGroup group;

    public HttpServerPipelineFactory(ChannelGroup group) {
        this.group = group;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        logger.trace("Creating new pipeline");
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new HttpRequestDecoder());
        pipeline.addLast("aggregator", new HttpChunkAggregator(65536));
        pipeline.addLast("encoder", new HttpResponseEncoder());
        pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
        pipeline.addLast("handler", new RequestHandlerV2(this.group));
        return pipeline;
    }
}

