// Code generated by go-bindata. (@generated) DO NOT EDIT.

 //Package server generated by go-bindata.// sources:
// swagger.json
package server

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)
type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// ModTime return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _swaggerJson = []byte(`{
  "swagger": "2.0",
  "info": {
    "title": "Chronograf",
    "description": "API endpoints for Chronograf",
    "version": "1.8.5"
  },
  "schemes": ["http"],
  "basePath": "/chronograf/v1",
  "consumes": ["application/json"],
  "produces": ["application/json"],
  "paths": {
    "/": {
      "get": {
        "tags": ["routes"],
        "summary": "Lists all the endpoints",
        "description": "List of the endpoints.",
        "responses": {
          "200": {
            "description": "Returns the links to the top level endpoints.",
            "schema": {
              "$ref": "#/definitions/Routes"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources": {
      "get": {
        "tags": ["sources"],
        "summary": "Configured data sources",
        "description": "These data sources store time series data.",
        "responses": {
          "200": {
            "description": "An array of data sources",
            "schema": {
              "$ref": "#/definitions/Sources"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources"],
        "summary": "Create new data source",
        "parameters": [
          {
            "name": "source",
            "in": "body",
            "description": "Configuration options for data source",
            "schema": {
              "$ref": "#/definitions/Source"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Data source successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created data source resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/Source"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}": {
      "get": {
        "tags": ["sources"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "summary": "Configured data sources",
        "description": "These data sources store time series data.",
        "responses": {
          "200": {
            "description": "Data source used to supply time series information.",
            "schema": {
              "$ref": "#/definitions/Source"
            }
          },
          "404": {
            "description": "Unknown source id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources"],
        "summary": "Update data source configuration",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of a data source",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "data source configuration",
            "schema": {
              "$ref": "#/definitions/Source"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Data source's configuration was changed",
            "schema": {
              "$ref": "#/definitions/Source"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent data source.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          }
        ],
        "summary": "This specific data source will be removed from the data store.  All associated kapacitor resources and kapacitor rules resources are also removed.",
        "responses": {
          "204": {
            "description": "data source has been removed"
          },
          "404": {
            "description": "Unknown data source id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/queries": {
      "post": {
        "tags": ["sources", "queries"],
        "description": "Used to analyze queries for structure`+"`"+`",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "queries",
            "in": "body",
            "description": "Query Parameters",
            "schema": {
              "$ref": "#/definitions/Queries"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Result of the analysis of the query.",
            "schema": {
              "$ref": "#/definitions/QueriesResponse"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/proxy": {
      "post": {
        "tags": ["sources", "proxy"],
        "description": "Query the backend time series data source and return the response according to `+"`"+`format`+"`"+`",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Query Parameters",
            "schema": {
              "$ref": "#/definitions/Proxy"
            },
            "required": true
          },
          {
            "name": "uuid",
            "in": "body",
            "type": "string",
            "description": "Client id for the query, will be returned with results",
            "required": false
          }
        ],
        "responses": {
          "200": {
            "description": "Result of the query from the backend time series data source.",
            "schema": {
              "$ref": "#/definitions/ProxyResponse"
            }
          },
          "400": {
            "description": "Any query that results in a data source error (syntax error, etc) will cause this response.  The error message will be passed back in the body",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "408": {
            "description": "Timeout trying to query data source.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/write": {
      "post": {
        "tags": ["sources", "write"],
        "description": "Write points to the backend time series data source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Write Parameters",
            "schema": {
              "type": "string",
              "format": "byte"
            },
            "required": true
          },
          {
            "name": "db",
            "in": "query",
            "description": "Sets the target database for the write.",
            "type": "string",
            "required": true
          },
          {
            "name": "rp",
            "in": "query",
            "description": "Sets the target retention policy for the write. InfluxDB writes to the DEFAULT retention policy if you do not specify a retention policy.",
            "type": "string"
          },
          {
            "name": "precision",
            "in": "query",
            "description": "Sets the precision for the supplied Unix time values. InfluxDB assumes that timestamps are in nanoseconds if you do not specify precision.",
            "type": "string",
            "enum": ["ns", "u", "ms", "s", "m", "h"]
          },
          {
            "name": "consistency",
            "in": "query",
            "description": "Sets the write consistency for the point. InfluxDB assumes that the write consistency is one if you do not specify consistency. See the InfluxEnterprise documentation for detailed descriptions of each consistency option.",
            "type": "string",
            "enum": ["any", "one", "quorum", "all"]
          }
        ],
        "responses": {
          "204": {
            "description": "Points written successfuly to database."
          },
          "400": {
            "description": "Any query that results in a data source error (syntax error, etc) will cause this response.  The error message will be passed back in the body",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "408": {
            "description": "Timeout trying to query data source.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/health": {
      "get": {
        "tags": ["sources"],
        "summary": "Health check for source",
        "description": "Returns if the tsdb source can be contacted",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Source was able to be contacted"
          },
          "404": {
            "description": "Source could not be contacted",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/permissions": {
      "get": {
        "tags": ["sources", "users"],
        "summary": "Retrieve possible permissions for this data source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of all possible permissions",
            "schema": {
              "$ref": "#/definitions/AllPermissions"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/users": {
      "get": {
        "tags": ["sources", "users"],
        "summary": "Retrieve all data sources users",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of all users",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Users"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "users"],
        "summary": "Create new user for this data source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "user",
            "in": "body",
            "description": "Configuration options for new user",
            "schema": {
              "$ref": "#/definitions/InfluxDB-User"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "User successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created user resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/InfluxDB-User"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/users/{user_id}": {
      "get": {
        "tags": ["sources", "users"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "user_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific user",
            "required": true
          }
        ],
        "summary": "Returns information about a specific user",
        "description": "Specific User within a data source",
        "responses": {
          "200": {
            "description": "Information relating to the user",
            "schema": {
              "$ref": "#/definitions/InfluxDB-User"
            }
          },
          "404": {
            "description": "Unknown user or unknown source",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "users"],
        "summary": "Update user configuration",
        "description": "Update one parameter at a time (one of password, permissions or roles)",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "user_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific user",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "user configuration",
            "schema": {
              "$ref": "#/definitions/InfluxDB-User"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Users's configuration was changed",
            "schema": {
              "$ref": "#/definitions/InfluxDB-User"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent user or source.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "users"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "user_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific user",
            "required": true
          }
        ],
        "summary": "This specific user will be removed from the data source",
        "responses": {
          "204": {
            "description": "User has been removed"
          },
          "404": {
            "description": "Unknown user id or data source",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/roles": {
      "get": {
        "tags": ["sources", "users", "roles"],
        "summary": "Retrieve all data sources roles.  Available only in Influx Enterprise",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of all roles",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Roles"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "users", "roles"],
        "summary": "Create new role for this data source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "roleuser",
            "in": "body",
            "description": "Configuration options for new role",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Role"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Role successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created role resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/InfluxDB-Role"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/roles/{role_id}": {
      "get": {
        "tags": ["sources", "users", "roles"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "role_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific role",
            "required": true
          }
        ],
        "summary": "Returns information about a specific role",
        "description": "Specific role within a data source",
        "responses": {
          "200": {
            "description": "Information relating to the role",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Role"
            }
          },
          "404": {
            "description": "Unknown role or unknown source",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "users", "roles"],
        "summary": "Update role configuration",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "role_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific role",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "role configuration",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Role"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Roles's configuration was changed",
            "schema": {
              "$ref": "#/definitions/InfluxDB-Role"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent role or source.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "users", "roles"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "role_id",
            "in": "path",
            "type": "string",
            "description": "ID of the specific role",
            "required": true
          }
        ],
        "summary": "This specific role will be removed from the data source",
        "responses": {
          "204": {
            "description": "Role has been removed"
          },
          "404": {
            "description": "Unknown role id or data source",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/dbs/": {
      "get": {
        "tags": ["databases"],
        "summary": "Retrieve all databases for a source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of all databases for a source",
            "schema": {
              "$ref": "#/definitions/Databases"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["databases"],
        "summary": "Create new database for a source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "database",
            "in": "body",
            "description": "Configuration options for a database",
            "schema": {
              "$ref": "#/definitions/Database"
            },
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Database successfully created.",
            "schema": {
              "$ref": "#/definitions/Database"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/dbs/{db}": {
      "delete": {
        "tags": ["databases"],
        "summary": "Delete database for a source",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "db",
            "in": "path",
            "type": "string",
            "description": "Name of the database",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Database has been deleted"
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/dbs/{db}/rps": {
      "get": {
        "tags": ["retention policies"],
        "summary": "Retrieve all retention policies for a database",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "db",
            "in": "path",
            "type": "string",
            "description": "Name of the database",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of all retention policies for a database",
            "schema": {
              "$ref": "#/definitions/RetentionPolicies"
            }
          },
          "404": {
            "description": "Specified retention policy does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["retention policies"],
        "summary": "Create new retention policy for a database",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "db",
            "in": "path",
            "type": "string",
            "description": "Name of the database",
            "required": true
          },
          {
            "name": "rp",
            "in": "body",
            "description": "Configuration options for the retention policy",
            "schema": {
              "$ref": "#/definitions/RetentionPolicy"
            },
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Retention Policy successfully created.",
            "schema": {
              "$ref": "#/definitions/RetentionPolicy"
            }
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/dbs/{db}/rps/{rp}": {
      "patch": {
        "tags": ["retention policies"],
        "summary": "Alter retention policy for a database",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "db",
            "in": "path",
            "type": "string",
            "description": "Name of the database",
            "required": true
          },
          {
            "name": "rp",
            "in": "path",
            "type": "string",
            "description": "Name of the retention policy",
            "required": true
          },
          {
            "name": "rp",
            "in": "body",
            "description": "Configuration options for the retention policy",
            "schema": {
              "$ref": "#/definitions/RetentionPolicy"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Retention Policy was altered",
            "schema": {
              "$ref": "#/definitions/RetentionPolicy"
            }
          },
          "404": {
            "description": "Database or source does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["retention policies"],
        "summary": "Delete retention policy for a database",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "name": "db",
            "in": "path",
            "type": "string",
            "description": "Name of the database",
            "required": true
          },
          {
            "name": "rp",
            "in": "path",
            "type": "string",
            "description": "Name of the retention policy",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Retention Policy has been deleted"
          },
          "404": {
            "description": "Data source id does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal service error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/dbs/{db}/measurements": {
      "get": {
        "tags": ["measurements"],
        "summary": "Retrieve measurements in a database",
        "parameters": [
          {
            "in": "path",
            "name": "id",
            "type": "string",
            "description": "ID of the data source",
            "required": true
          },
          {
            "in": "path",
            "name": "db",
            "type": "string",
            "description": "Name of the database",
            "required": true
          },
          {
            "in": "query",
            "name": "limit",
            "type": "integer",
            "minimum": 1,
            "default": 100,
            "description": "The upper limit of the number of available database measurements to return.",
            "required": false
          },
          {
            "in": "query",
            "name": "offset",
            "type": "integer",
            "minimum": 0,
            "default": 0,
            "description": "The number of measurements to skip before starting to collect the result set.",
            "required": false
          }
        ],
        "responses": {
          "200": {
            "description": "Listing of measurements for a database",
            "schema": {
              "$ref": "#/definitions/MeasurementsResponse"
            }
          },
          "400": {
            "description": "Unable to connect to source; or unable to get measurements from database.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Source not found.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Invalid source id param value in path; or invalid limit or offset param value in query.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal service error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/kapacitors": {
      "get": {
        "tags": ["sources", "kapacitors"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          }
        ],
        "summary": "Retrieve list of configured kapacitors",
        "responses": {
          "200": {
            "description": "An array of kapacitors",
            "schema": {
              "$ref": "#/definitions/Kapacitors"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "kapacitors"],
        "summary": "Create new kapacitor backend",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapacitor",
            "in": "body",
            "description": "Configuration options for kapacitor",
            "schema": {
              "$ref": "#/definitions/Kapacitor"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Kapacitor source successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created kapacitor resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/Kapacitor"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/kapacitors/{kapa_id}": {
      "get": {
        "tags": ["sources", "kapacitors"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor",
            "required": true
          }
        ],
        "summary": "Configured kapacitors",
        "description": "Retrieve information on a single kapacitor instance",
        "responses": {
          "200": {
            "description": "Kapacitor connection information",
            "schema": {
              "$ref": "#/definitions/Kapacitor"
            }
          },
          "404": {
            "description": "Unknown data source or kapacitor id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "kapacitors"],
        "summary": "Update kapacitor configuration",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of a kapacitor backend",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "kapacitor configuration",
            "schema": {
              "$ref": "#/definitions/Kapacitor"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Kapacitor's configuration was changed",
            "schema": {
              "$ref": "#/definitions/Kapacitor"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent data source or kapacitor.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "kapacitors"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor",
            "required": true
          }
        ],
        "summary": "Remove Kapacitor backend",
        "description": "This specific kapacitor will be removed. All associated rule resources will also be removed from the store.",
        "responses": {
          "204": {
            "description": "kapacitor has been removed."
          },
          "404": {
            "description": "Unknown Data source or Kapacitor id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/kapacitors/{kapa_id}/rules": {
      "get": {
        "tags": ["sources", "kapacitors", "rules"],
        "description": "Get all defined alert rules.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "All alert rules for this specific kapacitor are returned",
            "schema": {
              "$ref": "#/definitions/Rules"
            }
          },
          "404": {
            "description": "Data source or Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "kapacitors", "rules"],
        "description": "Create kapacitor alert rule",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          },
          {
            "name": "rule",
            "in": "body",
            "description": "Rule to generate alert rule",
            "schema": {
              "$ref": "#/definitions/Rule"
            },
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Kapacitor alert rule successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created kapacitor rule resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/Rule"
            }
          },
          "404": {
            "description": "Source ID or Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Source ID , Kapacitor ID or alert are unprocessable",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error; generally a problem creating alert in kapacitor",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/kapacitors/{kapa_id}/rules/{rule_id}": {
      "get": {
        "tags": ["sources", "kapacitors", "rules"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor",
            "required": true
          },
          {
            "name": "rule_id",
            "in": "path",
            "type": "string",
            "description": "ID of the rule",
            "required": true
          }
        ],
        "summary": "Specific kapacitor alert rule",
        "description": "Alerting rule for kapacitor",
        "responses": {
          "200": {
            "description": "Alert exists and has a specific TICKscript",
            "schema": {
              "$ref": "#/definitions/Rule"
            }
          },
          "404": {
            "description": "Unknown data source, kapacitor id, or rule id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": ["sources", "kapacitors", "rules"],
        "summary": "Update rule alert rule configuration",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of a kapacitor backend",
            "required": true
          },
          {
            "name": "rule_id",
            "in": "path",
            "type": "string",
            "description": "ID of a rule",
            "required": true
          },
          {
            "name": "rule",
            "in": "body",
            "description": "Rule update",
            "schema": {
              "$ref": "#/definitions/Rule"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Alert configuration was changed",
            "schema": {
              "$ref": "#/definitions/Rule"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent data source, kapacitor, or rule.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "kapacitors", "rules"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor",
            "required": true
          },
          {
            "name": "rule_id",
            "in": "path",
            "type": "string",
            "description": "ID of the rule",
            "required": true
          }
        ],
        "summary": "This specific alert rule will be removed.",
        "responses": {
          "204": {
            "description": "Alert rule has been removed."
          },
          "404": {
            "description": "Unknown Data source, Kapacitor id, or alert rule",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/kapacitors/{kapa_id}/proxy": {
      "get": {
        "tags": ["sources", "kapacitors", "proxy"],
        "description": "GET to `+"`"+`path`+"`"+` of kapacitor.  The response and status code from kapacitor is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The kapacitor API path to use in the proxy redirect",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Kapacitor returned no content"
          },
          "404": {
            "description": "Data source or Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from kapacitor",
            "schema": {
              "$ref": "#/definitions/KapacitorProxyResponse"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "kapacitors", "proxy"],
        "description": "DELETE to `+"`"+`path`+"`"+` of kapacitor. The response and status code from kapacitor is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The kapacitor API path to use in the proxy redirect",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Kapacitor returned no content"
          },
          "404": {
            "description": "Data source or Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from kapacitor",
            "schema": {
              "$ref": "#/definitions/KapacitorProxyResponse"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "kapacitors", "proxy"],
        "description": "PATCH body directly to configured kapacitor.  The response and status code from kapacitor is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The kapacitor API path to use in the proxy redirect",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Kapacitor body",
            "schema": {
              "$ref": "#/definitions/KapacitorProxy"
            },
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Kapacitor returned no content"
          },
          "404": {
            "description": "Data source or Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from kapacitor",
            "schema": {
              "$ref": "#/definitions/KapacitorProxyResponse"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "kapacitors", "proxy"],
        "description": "POST body directly to configured kapacitor.  The response and status code from kapacitor is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "kapa_id",
            "in": "path",
            "type": "string",
            "description": "ID of the kapacitor backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The kapacitor API path to use in the proxy redirect",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Kapacitor body",
            "schema": {
              "$ref": "#/definitions/KapacitorProxy"
            },
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Kapacitor returned no content"
          },
          "404": {
            "description": "Kapacitor ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from kapacitor",
            "schema": {
              "$ref": "#/definitions/KapacitorProxyResponse"
            }
          }
        }
      }
    },
    "/sources/{id}/services": {
      "get": {
        "tags": ["sources", "services"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          }
        ],
        "summary": "Retrieve list of services for a source",
        "responses": {
          "200": {
            "description": "An array of services",
            "schema": {
              "$ref": "#/definitions/Services"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "services"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "service",
            "in": "body",
            "description": "Configuration options for the service",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          }
        ],
        "summary": "Create a new service",
        "responses": {
          "200": {
            "description": "Returns the newly created service",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          },
          "504": {
            "description": "Gateway timeout happens when the server cannot connect to the service",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/services/{srv_id}": {
      "get": {
        "tags": ["sources", "services"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the service",
            "required": true
          }
        ],
        "summary": "Retrieve a service",
        "description": "Retrieve a single service by id",
        "responses": {
          "200": {
            "description": "Service connection information",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          },
          "404": {
            "description": "Unknown data source or service id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "services"],
        "summary": "Update service configuration",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of a service backend",
            "required": true
          },
          {
            "name": "service",
            "in": "body",
            "description": "service configuration",
            "schema": {
              "$ref": "#/definitions/Service"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Service configuration was changed",
            "schema": {
              "$ref": "#/definitions/Service"
            }
          },
          "504": {
            "description": "Gateway timeout happens when the server cannot connect to the service",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Unprocessable entity happens when the service ID provided does not exist",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "services"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the service",
            "required": true
          }
        ],
        "summary": "Remove Service backend",
        "description": "This specific service will be removed.",
        "responses": {
          "204": {
            "description": "service has been removed."
          },
          "404": {
            "description": "Unknown Data source or Service id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/services/{srv_id}/proxy": {
      "get": {
        "tags": ["sources", "services", "proxy"],
        "description": "GET to `+"`"+`path`+"`"+` of Service.  The response and status code from Service is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the service backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The Service API path to use in the proxy redirect",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Service returned no content"
          },
          "404": {
            "description": "Data source or Service ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from the service",
            "schema": {
              "$ref": "#/definitions/ServiceProxyResponse"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "services", "proxy"],
        "description": "DELETE to `+"`"+`path`+"`"+` of Service. The response and status code from the service is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the Service backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The Service API path to use in the proxy redirect",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Service returned no content"
          },
          "404": {
            "description": "Data source or Service ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from the service",
            "schema": {
              "$ref": "#/definitions/ServiceProxyResponse"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "services", "proxy"],
        "description": "PATCH body directly to configured service.  The response and status code from Service is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the Service backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The Service API path to use in the proxy redirect",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Service body",
            "schema": {
              "$ref": "#/definitions/ServiceProxy"
            },
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Service returned no content"
          },
          "404": {
            "description": "Data source or Service ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from Service",
            "schema": {
              "$ref": "#/definitions/ServiceProxyResponse"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "services", "proxy"],
        "description": "POST body directly to configured Service.  The response and status code from Service is directly returned.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "srv_id",
            "in": "path",
            "type": "string",
            "description": "ID of the Service backend.",
            "required": true
          },
          {
            "name": "path",
            "in": "query",
            "type": "string",
            "description": "The Service API path to use in the proxy redirect",
            "required": true
          },
          {
            "name": "query",
            "in": "body",
            "description": "Service body",
            "schema": {
              "$ref": "#/definitions/ServiceProxy"
            },
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Service returned no content"
          },
          "404": {
            "description": "Service ID does not exist.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Response directly from Service",
            "schema": {
              "$ref": "#/definitions/ServiceProxyResponse"
            }
          }
        }
      }
    },
    "/mappings": {
      "get": {
        "tags": ["layouts", "mappings"],
        "summary": "Mappings between app names and measurements",
        "description": "Mappings provide a means to alias measurement names found within a telegraf database and application layouts found within Chronograf\n",
        "responses": {
          "200": {
            "description": "An array of mappings",
            "schema": {
              "$ref": "#/definitions/Mappings"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/layouts": {
      "get": {
        "tags": ["layouts"],
        "summary": "Pre-configured layouts",
        "parameters": [
          {
            "name": "measurement",
            "in": "query",
            "description": "Returns layouts with this measurement",
            "required": false,
            "type": "array",
            "items": {
              "type": "string"
            },
            "collectionFormat": "multi"
          },
          {
            "name": "app",
            "in": "query",
            "description": "Returns layouts with this app",
            "required": false,
            "type": "array",
            "items": {
              "type": "string"
            },
            "collectionFormat": "multi"
          }
        ],
        "description": "Layouts are a collection of `+"`"+`Cells`+"`"+` that visualize time-series data.\n",
        "responses": {
          "200": {
            "description": "An array of layouts",
            "schema": {
              "$ref": "#/definitions/Layouts"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["layouts"],
        "summary": "Create new layout",
        "parameters": [
          {
            "name": "layout",
            "in": "body",
            "description": "Defines the layout and queries of the cells within the layout.",
            "schema": {
              "$ref": "#/definitions/Layout"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Layout successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created layout"
              }
            },
            "schema": {
              "$ref": "#/definitions/Layout"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/layouts/{id}": {
      "get": {
        "tags": ["layouts"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the layout",
            "required": true
          }
        ],
        "summary": "Specific pre-configured layout containing cells and queries.",
        "description": "layouts will hold information about how to layout the page of graphs.\n",
        "responses": {
          "200": {
            "description": "Returns the specified layout containing `+"`"+`cells`+"`"+`.",
            "schema": {
              "$ref": "#/definitions/Layout"
            }
          },
          "404": {
            "description": "Unknown layout id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["layouts"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the layout",
            "required": true
          }
        ],
        "summary": "This specific layout will be removed from the data store",
        "responses": {
          "204": {
            "description": "Layout has been removed."
          },
          "404": {
            "description": "Unknown layout id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": ["layouts"],
        "summary": "Replace layout configuration.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of a layout",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "layout  configuration update parameters",
            "schema": {
              "$ref": "#/definitions/Layout"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Layout has been replaced and the new layout is returned.",
            "schema": {
              "$ref": "#/definitions/Layout"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent layout.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/dashboards": {
      "get": {
        "tags": ["dashboards"],
        "summary": "List of all dashboards",
        "responses": {
          "200": {
            "description": "An array of dashboards",
            "schema": {
              "$ref": "#/definitions/Dashboards"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["dashboards"],
        "summary": "Create new dashboard",
        "parameters": [
          {
            "name": "dashboard",
            "in": "body",
            "description": "Configuration options for new dashboard",
            "schema": {
              "$ref": "#/definitions/DashboardCreate"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Dashboard successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created dashboard resource."
              }
            },
            "schema": {
              "$ref": "#/definitions/Dashboard"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/dashboards/{id}": {
      "get": {
        "tags": ["dashboards"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "integer",
            "description": "ID of the dashboard",
            "required": true
          }
        ],
        "summary": "Specific dashboard",
        "description": "Dashboards contain visual display information as well as links to queries",
        "responses": {
          "200": {
            "description": "Returns the specified dashboard with links to queries.",
            "schema": {
              "$ref": "#/definitions/Dashboard"
            }
          },
          "404": {
            "description": "Unknown dashboard id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["dashboards"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "integer",
            "description": "ID of the layout",
            "required": true
          }
        ],
        "summary": "Deletes the specified dashboard",
        "responses": {
          "204": {
            "description": "Dashboard has been removed."
          },
          "404": {
            "description": "Unknown dashboard id",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": ["dashboards"],
        "summary": "Replace dashboard information.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "integer",
            "description": "ID of a dashboard",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "dashboard configuration update parameters",
            "schema": {
              "$ref": "#/definitions/Dashboard"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Dashboard has been replaced and the new dashboard is returned.",
            "schema": {
              "$ref": "#/definitions/Dashboard"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent dashboard.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["layouts"],
        "summary": "Update dashboard information.",
        "description": "Update either the dashboard name or the dashboard cells",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "integer",
            "description": "ID of a dashboard",
            "required": true
          },
          {
            "name": "config",
            "in": "body",
            "description": "dashboard configuration update parameters. Must be either name or cells",
            "schema": {
              "$ref": "#/definitions/Dashboard"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Dashboard has been updated and the new dashboard is returned.",
            "schema": {
              "$ref": "#/definitions/Dashboard"
            }
          },
          "404": {
            "description": "Happens when trying to access a non-existent dashboard.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "A processing or an unexpected error.",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/organizations": {
      "get": {
        "tags": ["organizations", "users"],
        "summary": "Retrieve all organizations",
        "description": "Returns all organizations from the store",
        "responses": {
          "200": {
            "description": "Successfully retrieved all organizations from the store",
            "schema": {
              "$ref": "#/definitions/Organizations"
            }
          },
          "400": {
            "description": "Failed to retrieve organizations from store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["organizations", "users"],
        "summary": "Create new organization",
        "description": "Creates a Chronograf organization in the store",
        "parameters": [
          {
            "name": "organization",
            "in": "body",
            "description": "Organization to create",
            "schema": {
              "$ref": "#/definitions/Organization"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "Organization successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created organization resource"
              }
            },
            "schema": {
              "$ref": "#/definitions/Organization"
            }
          },
          "400": {
            "description": "Invalid JSON – unable to encode or decode; or failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Invalid data schema provided to server for organization",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/organizations/{id}": {
      "get": {
        "tags": ["organizations", "users"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the organization",
            "required": true
          }
        ],
        "summary": "Retrieve a specific organization",
        "description": "Returns a specific organization from the store",
        "responses": {
          "200": {
            "description": "An Organization object",
            "schema": {
              "$ref": "#/definitions/Organization"
            }
          },
          "400": {
            "description": "Failed to load organization from store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["organizations", "users"],
        "summary": "Update existing organization",
        "description": "Updates a Chronograf organization in the store",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the organization",
            "required": true
          },
          {
            "name": "organization",
            "in": "body",
            "description": "Updated organization",
            "schema": {
              "$ref": "#/definitions/Organization"
            },
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "Organization successfully updated",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the updated organization resource"
              }
            },
            "schema": {
              "$ref": "#/definitions/Organization"
            }
          },
          "400": {
            "description": "Invalid JSON – unable to encode or decode; or failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Invalid data schema provided to server for organization",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["organizations", "users"],
        "summary": "Delete organization",
        "description": "Deletes a Chronograf organization in the store",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the organization",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Organization successfully deleted"
          },
          "400": {
            "description": "Failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "Organization not found",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/users": {
      "get": {
        "tags": ["organizations", "users"],
        "summary": "Retrieve all Chronograf users within the current organization",
        "description": "Returns all Chronograf users within the current organization from the store",
        "responses": {
          "200": {
            "description": "Successfully retrieved all users from the store",
            "schema": {
              "$ref": "#/definitions/Users"
            }
          },
          "400": {
            "description": "Failed to load users from store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["organizations", "users"],
        "summary": "Create new user",
        "description": "Creates a Chronograf user in the store",
        "parameters": [
          {
            "name": "user",
            "in": "body",
            "description": "User to create",
            "schema": {
              "$ref": "#/definitions/User"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "User successfully created",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the newly created user resource"
              }
            },
            "schema": {
              "$ref": "#/definitions/User"
            }
          },
          "400": {
            "description": "Invalid JSON – unable to encode or decode; or failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "401": {
            "description": "Unauthorized to perform this operation",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Invalid data schema provided to server for user",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/users/{id}": {
      "get": {
        "tags": ["organizations", "users"],
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the user",
            "required": true
          }
        ],
        "summary": "Retrieve a specific user",
        "description": "Returns a specific user from the store",
        "responses": {
          "200": {
            "description": "An User object",
            "schema": {
              "$ref": "#/definitions/User"
            }
          },
          "400": {
            "description": "Failed to load user from store; or failed to parse user ID as valid",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["organizations", "users"],
        "summary": "Update existing user",
        "description": "Updates a Chronograf user in the store",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the user",
            "required": true
          },
          {
            "name": "user",
            "in": "body",
            "description": "Updated user",
            "schema": {
              "$ref": "#/definitions/User"
            },
            "required": true
          }
        ],
        "responses": {
          "201": {
            "description": "User successfully updated",
            "headers": {
              "Location": {
                "type": "string",
                "format": "url",
                "description": "Location of the updated user resource"
              }
            },
            "schema": {
              "$ref": "#/definitions/User"
            }
          },
          "400": {
            "description": "Invalid JSON – unable to encode or decode; failed to parse user id as valid; or failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "401": {
            "description": "Unauthorized to perform operation",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "User not found",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Invalid data schema provided to server for user",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["organizations", "users"],
        "summary": "Delete user",
        "description": "Deletes a Chronograf user in the store",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the user",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "User successfully deleted"
          },
          "400": {
            "description": "Failed to parse user id as valid; failed to retrieve user from context; or failed to perform operation in data store",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "403": {
            "description": "Forbidden to access this route",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "404": {
            "description": "User not found",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/chronograf/v1/config": {
      "get": {
        "tags": ["config"],
        "summary": "Returns the global application configuration",
        "description": "All global application configurations",
        "responses": {
          "200": {
            "description": "Returns an object with the global configurations",
            "schema": {
              "$ref": "#/definitions/Config"
            }
          },
          "404": {
            "description": "Could not find global application config",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/chronograf/v1/config/auth": {
      "get": {
        "tags": ["config"],
        "summary": "Returns the global application configuration for auth",
        "description": "All global application configuration for auth",
        "responses": {
          "200": {
            "description": "Returns an object with the global application configuration for auth",
            "schema": {
              "$ref": "#/definitions/AuthConfig"
            }
          },
          "404": {
            "description": "Could not find auth configuration",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": ["config"],
        "summary": "Updates the global application configuration for auth",
        "description": "Replaces the global application configuration for auth",
        "parameters": [
          {
            "name": "auth",
            "in": "body",
            "description": "Auth configuration update object",
            "schema": {
              "$ref": "#/definitions/AuthConfig"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Returns an object with the updated auth configuration",
            "schema": {
              "$ref": "#/definitions/AuthConfig"
            }
          },
          "404": {
            "description": "Could not find auth configuration",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/chronograf/v1/org_config": {
      "get": {
        "tags": ["organization config"],
        "summary": "Retrieve the organization configuration",
        "description": "Organization-specific configurations such as log viewer configs",
        "responses": {
          "200": {
            "description": "Returns an object with the organization-specific configurations",
            "schema": {
              "$ref": "#/definitions/OrganizationConfig"
            }
          },
          "404": {
            "description": "Could not find organization config",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/chronograf/v1/org_config/logviewer": {
      "get": {
        "tags": ["organization config"],
        "summary": "Retrieve the organization-specific log viewer configurations",
        "description": "Retrieve the log viewer configurations for the user's current organization",
        "responses": {
          "200": {
            "description": "Returns an log viewer configuration object",
            "schema": {
              "$ref": "#/definitions/LogViewerConfig"
            }
          },
          "404": {
            "description": "Could not find the log viewer configuration for this organization",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "put": {
        "tags": ["organization config"],
        "summary": "Update the log viewer configuration",
        "description": "Update the log viewer configuration for a specific organization",
        "parameters": [
          {
            "name": "logViewer",
            "in": "body",
            "description": "Log Viewer configuration update object",
            "schema": {
              "$ref": "#/definitions/LogViewerConfig"
            },
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Returns an object with the updated log viewer configurations",
            "schema": {
              "$ref": "#/definitions/LogViewerConfig"
            }
          },
          "404": {
            "description": "Could not find log viewer configurations for the specified organization",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/annotations/": {
      "get": {
        "tags": ["sources", "annotations"],
        "description": "Retrieve a list of user-defined annotations.",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "since",
            "in": "query",
            "type": "string",
            "description": "RFC3339 datetime to retrieve annotations after",
            "required": true
          },
          {
            "name": "until",
            "in": "query",
            "type": "string",
            "description": "RFC3339 datetime to retrieve annotations until (defaults to now if not supplied)",
            "required": false
          },
          {
            "name": "tag",
            "in": "query",
            "type": "string",
            "description": "An InfluxQL binary expression for querying annotations by their tags",
            "required": false,
            "example": "repo =~ /chronograf/"
          }
        ],
        "responses": {
          "200": {
            "description": "List of annotations",
            "schema": {
              "$ref": "#/definitions/AnnotationsResponse"
            }
          },
          "422": {
            "description": "Source ID not supplied",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "post": {
        "tags": ["sources", "annotations"],
        "description": "Create an annotation",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "annotation",
            "in": "body",
            "description": "Annotation to be created",
            "required": true,
            "schema": {
              "$ref": "#/definitions/UpdateAnnotationRequest"
            }
          }
        ],
        "responses": {
          "201": {
            "description": "The created annotation",
            "schema": {
              "$ref": "#/definitions/Annotation"
            }
          },
          "400": {
            "description": "Invalid data schema provided to server for annotation",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    },
    "/sources/{id}/annotations/{annotation_id}": {
      "get": {
        "tags": ["sources", "annotations"],
        "description": "Retrieve a single annotation",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "annotation_id",
            "in": "path",
            "type": "string",
            "description": "ID of the annotation",
            "required": true
          }
        ],
        "responses": {
          "200": {
            "description": "Annotation for supplied ID",
            "schema": {
              "$ref": "#/definitions/Annotation"
            }
          },
          "400": {
            "description": "Annotation not found",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "422": {
            "description": "Source or annotation ID not supplied",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "delete": {
        "tags": ["sources", "annotations"],
        "description": "Delete an annotation",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "annotation_id",
            "in": "path",
            "type": "string",
            "description": "ID of the annotation",
            "required": true
          }
        ],
        "responses": {
          "204": {
            "description": "Annotation has been removed"
          },
          "422": {
            "description": "Source or annotation ID not supplied",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      },
      "patch": {
        "tags": ["sources", "annotations"],
        "description": "Update an annotation",
        "parameters": [
          {
            "name": "id",
            "in": "path",
            "type": "string",
            "description": "ID of the source",
            "required": true
          },
          {
            "name": "annotation_id",
            "in": "path",
            "type": "string",
            "description": "ID of the annotation",
            "required": true
          },
          {
            "name": "annotation",
            "in": "body",
            "description": "Updated annotation data",
            "required": true,
            "schema": {
              "$ref": "#/definitions/UpdateAnnotationRequest"
            }
          }
        ],
        "responses": {
          "200": {
            "description": "The updated annotation",
            "schema": {
              "$ref": "#/definitions/Annotation"
            }
          },
          "422": {
            "description": "Source or annotation ID not supplied",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          },
          "default": {
            "description": "Unexpected internal server error",
            "schema": {
              "$ref": "#/definitions/Error"
            }
          }
        }
      }
    }
  },
  "definitions": {
    "Organization": {
      "type": "object",
      "description": "A group of Chronograf users with various role-based access-control.",
      "properties": {
        "defaultRole": {
          "description": "The default role that new users in this organization will have.",
          "type": "string",
          "enum": ["member", "viewer", "editor", "admin"]
        },
        "id": {
          "type": "string",
          "description": "Unique identifier representing an organization resource. The Default organization will have the id 'default', and any further will start at '1' and increment.",
          "readOnly": true
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          },
          "readOnly": true
        },
        "name": {
          "type": "string",
          "description": "User-facing name of the organization resource."
        }
      },
      "required": ["name"],
      "example": {
        "defaultRole": "viewer",
        "id": "1",
        "links": {
          "self": "/chronograf/v1/organizations/1"
        },
        "name": "Chronogiraffes"
      }
    },
    "Organizations": {
      "type": "object",
      "required": ["organizations"],
      "properties": {
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          },
          "readOnly": true
        },
        "organizations": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Organization"
          }
        }
      }
    },
    "User": {
      "type": "object",
      "description": "A Chronograf user with role-based access-control to an organization's resources.",
      "properties": {
        "id": {
          "type": "string",
          "description": "Unique identifier representing a user resource",
          "readOnly": true
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          },
          "readOnly": true
        },
        "name": {
          "type": "string",
          "description": "Username (as taken from principal given by auth provider)",
          "readOnly": true
        },
        "provider": {
          "type": "string",
          "description": "OAuth provider used to authenticate",
          "readOnly": true
        },
        "roles": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Role"
          }
        },
        "scheme": {
          "type": "string",
          "description": "Scheme used to authenticate (only OAuth2 currently supported)",
          "readOnly": true
        },
        "superAdmin": {
          "type": "boolean",
          "description": "If user has the ability to perform CRUD operations on Organizations, across Organizations, and on other SuperAdmin users"
        }
      },
      "required": ["id", "name", "provider", "roles", "scheme"],
      "example": {
        "id": "1",
        "links": {
          "self": "/chronograf/v1/users/1"
        },
        "name": "pineapple@cubeoctohedron.flux",
        "provider": "github",
        "roles": {
          "name": "editor",
          "organization": "SpaceTeam"
        },
        "scheme": "oauth2",
        "superAdmin": false
      }
    },
    "Users": {
      "type": "object",
      "required": ["users"],
      "properties": {
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          }
        },
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/User"
          }
        }
      }
    },
    "Role": {
      "type": "object",
      "properties": {
        "name": {
          "description": "A Chronograf user's role within an organization.",
          "type": "string",
          "enum": ["member", "viewer", "editor", "admin"]
        },
        "organization": {
          "type": "string",
          "description": "Name of organization user belongs to"
        }
      }
    },
    "Databases": {
      "type": "object",
      "required": ["databases"],
      "properties": {
        "databases": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Database"
          }
        }
      }
    },
    "Database": {
      "type": "object",
      "required": ["name"],
      "example": {
        "name": "NOAA_water_database",
        "duration": "3d",
        "replication": 3,
        "shardDuration": "3h",
        "retentionPolicies": [
          {
            "name": "weekly",
            "duration": "7d",
            "replication": 1,
            "shardDuration": "7d",
            "default": true,
            "links": {
              "self": "/chronograf/v1/sources/1/dbs/NOAA_water_database/rps/liquid"
            }
          }
        ],
        "links": {
          "self": "/chronograf/v1/sources/1/dbs/NOAA_water_database",
          "rps": "/chronograf/v1/sources/1/dbs/NOAA_water_database/rps",
          "measurements": "/chronograf/v1/sources/1/dbs/NOAA_water_database/measurements?limit=100&offset=0"
        }
      },
      "properties": {
        "name": {
          "type": "string",
          "description": "The identifying name of the database"
        },
        "duration": {
          "type": "string",
          "description": "the duration of the default retention policy"
        },
        "replication": {
          "type": "integer",
          "format": "int32",
          "description": "how many copies of the data are stored in the cluster"
        },
        "shardDuration": {
          "type": "string",
          "description": "the interval spanned by each shard group"
        },
        "retentionPolicies": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/RetentionPolicy"
          }
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            },
            "rps": {
              "type": "string",
              "description": "Link to retention policies for this database",
              "format": "url"
            },
            "measurements": {
              "type": "string",
              "description": "Link to measurements for this database",
              "format": "url"
            }
          }
        }
      }
    },
    "Kapacitors": {
      "type": "object",
      "required": ["kapacitors"],
      "properties": {
        "kapacitors": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Kapacitor"
          }
        }
      }
    },
    "Kapacitor": {
      "type": "object",
      "required": ["name", "url"],
      "example": {
        "id": "4",
        "name": "kapa",
        "url": "http://localhost:9092",
        "active": false,
        "insecureSkipVerify": false,
        "links": {
          "proxy": "/chronograf/v1/sources/4/kapacitors/4/proxy",
          "self": "/chronograf/v1/sources/4/kapacitors/4",
          "rules": "/chronograf/v1/sources/4/kapacitors/4/rules"
        }
      },
      "properties": {
        "id": {
          "type": "string",
          "description": "Unique identifier representing a kapacitor instance.",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "description": "User facing name of kapacitor instance."
        },
        "username": {
          "type": "string",
          "description": "Username for authentication to kapacitor."
        },
        "password": {
          "type": "string",
          "description": "Password is in cleartext."
        },
        "url": {
          "type": "string",
          "format": "url",
          "description": "URL for the kapacitor backend (e.g. http://localhost:9092)"
        },
        "insecureSkipVerify": {
          "type": "boolean",
          "description": "True means any certificate presented by the kapacitor is accepted.  Typically used for self-signed certs. Probably should only be used for testing."
        },
        "active": {
          "type": "boolean",
          "description": "Indicates whether the kapacitor is the current kapacitor being used for a source"
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            },
            "proxy": {
              "type": "string",
              "description": "URL location of proxy endpoint for this kapacitor",
              "format": "url"
            },
            "rules": {
              "type": "string",
              "description": "URL location of rules endpoint for this kapacitor",
              "format": "url"
            }
          }
        }
      }
    },
    "KapacitorProxy": {
      "description": "Entirely used as the body for the request to the kapacitor backend.",
      "type": "object"
    },
    "KapacitorProxyResponse": {
      "description": "Entire response from the kapacitor backend.",
      "type": "object"
    },
    "Services": {
      "type": "object",
      "required": ["services"],
      "properties": {
        "services": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Service"
          }
        }
      }
    },
    "Service": {
      "type": "object",
      "required": ["name", "url"],
      "example": {
        "id": "1",
        "sourceID": "1",
        "url": "http://localhost:8093",
        "insecureSkipVerify": false,
        "type": "flux",
        "metadata": {
          "active": true
        },
        "links": {
          "proxy": "/chronograf/v1/sources/1/services/1/proxy",
          "self": "/chronograf/v1/sources/1/services/1",
          "source": "/chronograf/v1/sources/1"
        }
      },
      "properties": {
        "id": {
          "type": "string",
          "description": "Unique identifier representing a service.",
          "readOnly": true
        },
        "sourceID": {
          "type": "string",
          "description": "Unique identifier of the source associated with this service"
        },
        "name": {
          "type": "string",
          "description": "User facing name of the service."
        },
        "username": {
          "type": "string",
          "description": "Credentials for using this service"
        },
        "url": {
          "type": "string",
          "format": "url",
          "description": "URL for the service backend (e.g. http://localhost:8093)"
        },
        "insecureSkipVerify": {
          "type": "boolean",
          "description": "True means any certificate presented by the service is accepted. Typically used for self-signed certs. Probably should only be used for testing."
        },
        "type": {
          "type": "string",
          "description": "Indicates what kind of service this is (e.g. flux service)"
        },
        "metadata": {
          "type": "object",
          "properties": {
            "active": {
              "type": "boolean",
              "description": "Indicates whether the service is the current service being used for a source"
            }
          }
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            },
            "proxy": {
              "type": "string",
              "description": "URL location of proxy endpoint for this service",
              "format": "url"
            },
            "source": {
              "type": "string",
              "description": "URL location of the source this service is associated with",
              "format": "url"
            }
          }
        }
      }
    },
    "ServiceProxy": {
      "description": "Entirely used as the body for the request to the service backend.",
      "type": "object"
    },
    "ServiceProxyResponse": {
      "description": "Entire response from the service backend.",
      "type": "object"
    },
    "Rules": {
      "type": "object",
      "required": ["rules"],
      "properties": {
        "rules": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Rule"
          }
        }
      }
    },
    "Query": {
      "type": "object",
      "properties": {
        "query": {
          "type": "string",
          "description": "InfluxQL statement to be analyzed",
          "example": {
            "query": "select max(usage_system) from telegraf.autogen.cpu group by time(10m)"
          }
        }
      }
    },
    "QueryResponse": {
      "type": "object",
      "properties": {
        "query": {
          "type": "string",
          "example": {
            "query": "select max(usage_system) from telegraf.autogen.cpu group by time(10m)"
          },
          "description": "InfluxQL statement to be analyzed"
        },
        "queryConfig": {
          "$ref": "#/definitions/QueryConfig"
        }
      }
    },
    "Queries": {
      "type": "object",
      "properties": {
        "queries": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Query"
          }
        }
      }
    },
    "QueriesResponse": {
      "type": "object",
      "properties": {
        "queries": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/QueryResponse"
          }
        }
      }
    },
    "QueryConfig": {
      "type": "object",
      "example": {
        "id": "ce72917d-1ecb-45ea-a6cb-4c122deb93c7",
        "database": "telegraf",
        "measurement": "cpu",
        "retentionPolicy": "autogen",
        "fields": [
          {
            "value": "max",
            "type": "func",
            "args": [
              {
                "value": "usage_system",
                "type": "field"
              }
            ]
          }
        ],
        "tags": {},
        "groupBy": {
          "time": "10m",
          "tags": []
        },
        "areTagsAccepted": true,
        "range": {
          "lower": "15m",
          "upper": "now"
        }
      },
      "properties": {
        "id": {
          "type": "string"
        },
        "database": {
          "type": "string"
        },
        "measurement": {
          "type": "string"
        },
        "retentionPolicy": {
          "type": "string"
        },
        "areTagsAccepted": {
          "type": "boolean"
        },
        "rawText": {
          "type": "string"
        },
        "tags": {
          "type": "object"
        },
        "groupBy": {
          "type": "object",
          "properties": {
            "time": {
              "type": "string"
            },
            "tags": {
              "type": "array",
              "items": {
                "type": "string"
              }
            }
          },
          "required": ["time", "tags"]
        },
        "fields": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Field"
          }
        },
        "range": {
          "type": "object",
          "properties": {
            "lower": {
              "type": "string"
            },
            "upper": {
              "type": "string"
            }
          },
          "required": ["lower", "upper"]
        }
      },
      "required": [
        "database",
        "measurement",
        "retentionPolicy",
        "areTagsAccepted",
        "tags",
        "groupBy",
        "fields"
      ]
    },
    "KapacitorNode": {
      "type": "object",
      "description": "Represents a node in the kapacitor TICKscript graph",
      "required": ["name"],
      "properties": {
        "name": {
          "type": "string",
          "description": "Name of the kapacitor node e.g. slack"
        },
        "args": {
          "type": "array",
          "description": "All arguments to the named node",
          "items": {
            "type": "string"
          }
        },
        "properties": {
          "type": "array",
          "description": "All properties attached to the kapacitor node",
          "items": {
            "$ref": "#/definitions/KapacitorProperty"
          }
        }
      }
    },
    "Field": {
      "type": "object",
      "required": ["type", "value"],
      "description": "Represents a field to be returned from an InfluxQL query",
      "properties": {
        "value": {
          "description": "value is the value of the field.  Meaning of the value is implied by the `+"`"+`type`+"`"+` key",
          "type": "string"
        },
        "type": {
          "description": "type describes the field type. func is a function; field is a field reference",
          "type": "string",
          "enum": ["func", "field", "integer", "number", "regex", "wildcard"]
        },
        "alias": {
          "description": "Alias overrides the field name in the returned response.  Applies only if type is `+"`"+`func`+"`"+`",
          "type": "string"
        },
        "args": {
          "description": "Args are the arguments to the function",
          "type": "array",
          "items": {
            "$ref": "#/definitions/Field"
          }
        }
      }
    },
    "KapacitorProperty": {
      "type": "object",
      "description": "Represents a property attached to a node in the kapacitor TICKscript graph",
      "required": ["name"],
      "properties": {
        "name": {
          "type": "string",
          "description": "Name of the kapacitor property e.g. channel for a slack node"
        },
        "args": {
          "type": "array",
          "description": "All arguments to the named property",
          "items": {
            "type": "string"
          }
        }
      }
    },
    "RetentionPolicies": {
      "type": "object",
      "required": ["retentionPolicies"],
      "properties": {
        "retentionPolicies": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/RetentionPolicy"
          }
        }
      }
    },
    "RetentionPolicy": {
      "type": "object",
      "required": ["name", "duration", "replication"],
      "example": {
        "name": "weekly",
        "duration": "7d",
        "replication": 1,
        "shardDuration": "7d",
        "default": true,
        "links": {
          "self": "/chronograf/v1/sources/1/dbs/NOAA_water_database/rps/liquid"
        }
      },
      "properties": {
        "name": {
          "type": "string",
          "description": "The identifying name of the retention policy"
        },
        "duration": {
          "type": "string",
          "description": "the duration of the retention policy"
        },
        "replication": {
          "type": "integer",
          "format": "int32",
          "description": "how many copies of the data are stored in the cluster"
        },
        "shardDuration": {
          "type": "string",
          "description": "the interval spanned by each shard group"
        },
        "default": {
          "type": "boolean",
          "description": "Indicates whether this retention policy should be the default"
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          }
        }
      }
    },
    "MeasurementsResponse": {
      "type": "object",
      "properties": {
        "measurements": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Measurement"
          }
        },
        "links": {
          "type": "object",
          "description": "Links to paginated measurements, relative to the current page.",
          "properties": {
            "self": {
              "type": "string",
              "format": "url",
              "description": "Current page measurements",
              "required": true
            },
            "first": {
              "type": "string",
              "format": "url",
              "description": "First page of measurements",
              "required": true
            },
            "next": {
              "type": "string",
              "format": "url",
              "description": "Next page of measurements",
              "required": true
            },
            "prev": {
              "type": "string",
              "format": "url",
              "description": "Previous page of measurements, if not at the first page.",
              "required": false
            }
          }
        }
      },
      "example": {
        "measurements": [
          {
            "name": "alerts"
          },
          {
            "name": "annotations"
          }
        ],
        "links": {
          "self": "/chronograf/v1/sources/1/dbs/chronograf/measurements?limit=100&offset=0",
          "first": "/chronograf/v1/sources/1/dbs/chronograf/measurements?limit=100&offset=0",
          "next": "/chronograf/v1/sources/1/dbs/chronograf/measurements?limit=100&offset=100"
        }
      }
    },
    "Measurement": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string",
          "description": "Measurement name."
        }
      }
    },
    "Rule": {
      "type": "object",
      "example": {
        "id": "chronograf-v1-b2b065ea-79bd-4e4f-8c0d-d0ef68477d38",
        "query": {
          "id": "ce72917d-1ecb-45ea-a6cb-4c122deb93c7",
          "database": "telegraf",
          "measurement": "cpu",
          "retentionPolicy": "autogen",
          "fields": [
            {
              "value": "max",
              "type": "func",
              "args": [
                {
                  "value": "usage_system",
                  "type": "field"
                }
              ]
            }
          ],
          "tags": {},
          "groupBy": {
            "time": "10m",
            "tags": []
          },
          "areTagsAccepted": true
        },
        "every": "30s",
        "alerts": ["alerta"],
        "alertNodes": [
          {
            "name": "alerta",
            "args": [],
            "properties": []
          }
        ],
        "message": "too much spam",
        "details": "muh body",
        "trigger": "threshold",
        "values": {
          "operator": "greater than",
          "value": "10"
        },
        "name": "Untitled Rule",
        "tickscript": "var db = 'telegraf'\n\nvar rp = 'autogen'\n\nvar measurement = 'cpu'\n\nvar groupBy = []\n\nvar whereFilter = lambda: TRUE\n\nvar period = 10m\n\nvar every = 30s\n\nvar name = 'Untitled Rule'\n\nvar idVar = name + ':{{.Group}}'\n\nvar message = 'too much spam'\n\nvar idTag = 'alertID'\n\nvar levelTag = 'level'\n\nvar messageField = 'message'\n\nvar durationField = 'duration'\n\nvar outputDB = 'chronograf'\n\nvar outputRP = 'autogen'\n\nvar outputMeasurement = 'alerts'\n\nvar triggerType = 'threshold'\n\nvar details = 'muh body'\n\nvar crit = 10\n\nvar data = stream\n    |from()\n        .database(db)\n        .retentionPolicy(rp)\n        .measurement(measurement)\n        .groupBy(groupBy)\n        .where(whereFilter)\n    |window()\n        .period(period)\n        .every(every)\n        .align()\n    |max('usage_system')\n        .as('value')\n\nvar trigger = data\n    |alert()\n        .crit(lambda: \"value\" > crit)\n        .stateChangesOnly()\n        .message(message)\n        .id(idVar)\n        .idTag(idTag)\n        .levelTag(levelTag)\n        .messageField(messageField)\n        .durationField(durationField)\n        .details(details)\n        .alerta()\n\ntrigger\n    |influxDBOut()\n        .create()\n        .database(outputDB)\n        .retentionPolicy(outputRP)\n        .measurement(outputMeasurement)\n        .tag('alertName', name)\n        .tag('triggerType', triggerType)\n\ntrigger\n    |httpOut('output')\n",
        "type": "stream",
        "dbrps": [
          {
            "db": "telegraf",
            "rp": "autogen"
          }
        ],
        "status": "disabled",
        "executing": false,
        "error": "",
        "created": "2017-05-05T16:16:03.471138388-05:00",
        "modified": "2017-05-23T15:57:42.625909746-05:00",
        "last-enabled": "2017-05-05T16:16:25.890210217-05:00",
        "links": {
          "self": "/chronograf/v1/sources/5/kapacitors/5/rules/chronograf-v1-b2b065ea-79bd-4e4f-8c0d-d0ef68477d38",
          "kapacitor": "/chronograf/v1/sources/5/kapacitors/5/proxy?path=%2Fkapacitor%2Fv1%2Ftasks%2Fchronograf-v1-b2b065ea-79bd-4e4f-8c0d-d0ef68477d38",
          "output": "/chronograf/v1/sources/5/kapacitors/5/proxy?path=%2Fkapacitor%2Fv1%2Ftasks%2Fchronograf-v1-b2b065ea-79bd-4e4f-8c0d-d0ef68477d38%2Foutput"
        }
      },
      "required": ["query", "every", "trigger"],
      "properties": {
        "id": {
          "type": "string",
          "description": "ID for this rule; the ID is shared with kapacitor"
        },
        "query": {
          "$ref": "#/definitions/QueryConfig"
        },
        "name": {
          "type": "string",
          "description": "User facing name of the alerting rule"
        },
        "every": {
          "type": "string",
          "description": "Golang duration string specifying how often the alert condition is checked"
        },
        "alerts": {
          "type": "array",
          "description": "Array of alerting services to warn if the alert is triggered",
          "items": {
            "type": "string",
            "enum": [
              "alerta",
              "post",
              "http",
              "hipchat",
              "kafka",
              "opsgenie",
              "opsgenie2",
              "pagerduty",
              "pagerduty2",
              "victorops",
              "email",
              "exec",
              "log",
              "pushover",
              "sensu",
              "slack",
              "smtp",
              "talk",
              "telegram",
              "tcp"
            ]
          }
        },
        "alertNodes": {
          "type": "array",
          "description": "Arguments and properties to add to alert",
          "items": {
            "$ref": "#/definitions/KapacitorNode"
          }
        },
        "message": {
          "type": "string",
          "description": "Message to send when alert occurs."
        },
        "details": {
          "type": "string",
          "description": "Template for constructing a detailed HTML message for the alert. (Currently, only used for email/smtp"
        },
        "trigger": {
          "type": "string",
          "description": "Trigger defines the alerting structure; deadman alert if no data are received for the specified time range; relative alert if the data change relative to the data in a different time range; threshold alert if the data cross a boundary",
          "enum": ["deadman", "relative", "threshold"]
        },
        "values": {
          "type": "object",
          "description": "Alerting logic for trigger type",
          "properties": {
            "change": {
              "description": "Specifies if the change is percent or absolute",
              "type": "string",
              "enum": ["% change", "change"]
            },
            "period": {
              "description": "Length of time before deadman is alerted (golang duration)",
              "type": "string"
            },
            "shift": {
              "description": "Amount of time to look into the past to compare to the present (golang duration)",
              "type": "string"
            },
            "operator": {
              "description": "Operator for alert comparison",
              "type": "string",
              "enum": [
                "greater than",
                "less than",
                "equal to or less than",
                "equal to or greater",
                "equal to",
                "not equal to",
                "inside range",
                "outside range"
              ]
            },
            "value": {
              "description": "Value is the boundary value when alert goes critical",
              "type": "string"
            },
            "rangeValue": {
              "description": "Optional value for range comparisions",
              "type": "string"
            }
          }
        },
        "dbrps": {
          "type": "array",
          "description": "List of database retention policy pairs the task is allowed to access.",
          "items": {
            "$ref": "#/definitions/DBRP"
          }
        },
        "tickscript": {
          "type": "string",
          "description": "TICKscript representing this rule"
        },
        "status": {
          "type": "string",
          "description": "Represents if this rule is enabled or disabled in kapacitor",
          "enum": ["enabled", "disabled"]
        },
        "executing": {
          "type": "boolean",
          "description": "Whether the task is currently executing.",
          "readOnly": true
        },
        "type": {
          "type": "string",
          "description": "Represents the task type where stream is data streamed to kapacitor and batch is queried by kapacitor.",
          "enum": ["stream", "batch"]
        },
        "error": {
          "type": "string",
          "description": "Any error encountered when kapacitor executes the task.",
          "readOnly": true
        },
        "created": {
          "type": "string",
          "description": "Date the task was first created",
          "readOnly": true
        },
        "modified": {
          "type": "string",
          "description": "Date the task was last modified",
          "readOnly": true
        },
        "last-enabled": {
          "type": "string",
          "description": "Date the task was last set to status enabled",
          "readOnly": true
        },
        "links": {
          "type": "object",
          "required": ["self", "kapacitor"],
          "properties": {
            "self": {
              "description": "Self link pointing to this rule resource",
              "type": "string",
              "format": "uri"
            },
            "kapacitor": {
              "description": "Link pointing to the kapacitor proxy for this rule including the path query parameter.",
              "type": "string",
              "format": "uri"
            },
            "output": {
              "description": "Link pointing to the kapacitor httpOut node of the tickscript; includes the path query argument",
              "type": "string",
              "format": "uri"
            }
          }
        }
      }
    },
    "DBRP": {
      "type": "object",
      "description": "Database retention policy pair",
      "properties": {
        "db": {
          "description": "Database name",
          "type": "string"
        },
        "rp": {
          "description": "Retention policy",
          "type": "string"
        }
      },
      "required": ["db", "rp"]
    },
    "Sources": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/Source"
      }
    },
    "Source": {
      "type": "object",
      "example": {
        "id": "4",
        "name": "Influx 1",
        "type": "influx",
        "url": "http://localhost:8086",
        "default": false,
        "telegraf": "telegraf",
        "defaultRP": "customRP",
        "organization": "default",
        "authentication": "basic",
        "role": "viewer",
        "links": {
          "self": "/chronograf/v1/sources/4",
          "kapacitors": "/chronograf/v1/sources/4/kapacitors",
          "proxy": "/chronograf/v1/sources/4/proxy",
          "write": "/chronograf/v1/sources/4/write",
          "queries": "/chronograf/v1/sources/4/queries",
          "permissions": "/chronograf/v1/sources/4/permissions",
          "users": "/chronograf/v1/sources/4/users",
          "roles": "/chronograf/v1/sources/4/roles",
          "health": "/chronograf/v1/sources/4/health"
        }
      },
      "required": ["url"],
      "properties": {
        "id": {
          "type": "string",
          "description": "Unique identifier representing a specific data source.",
          "readOnly": true
        },
        "name": {
          "type": "string",
          "description": "User facing name of data source"
        },
        "type": {
          "type": "string",
          "description": "Format of the data source",
          "readOnly": true,
          "enum": ["influx", "influx-enterprise", "influx-relay"]
        },
        "username": {
          "type": "string",
          "description": "Username for authentication to data source"
        },
        "password": {
          "type": "string",
          "description": "Password is in cleartext."
        },
        "sharedSecret": {
          "type": "string",
          "description": "JWT signing secret for optional Authorization: Bearer to InfluxDB"
        },
        "url": {
          "type": "string",
          "format": "url",
          "description": "URL for the time series data source backend (e.g. http://localhost:8086)"
        },
        "metaUrl": {
          "type": "string",
          "format": "url",
          "description": "URL for the influxdb meta node"
        },
        "insecureSkipVerify": {
          "type": "boolean",
          "description": "True means any certificate presented by the source is accepted.  Typically used for self-signed certs. Probably should only be used for testing."
        },
        "default": {
          "type": "boolean",
          "description": "Indicates whether this source is the default source"
        },
        "telegraf": {
          "type": "string",
          "description": "Database where telegraf information is stored for this source",
          "default": "telegraf"
        },
        "defaultRP": {
          "type": "string",
          "description": "Default retention policy used in Host-related queries proxied to InfluxDB from the Host List and Host pages.",
          "default": ""
        },
        "organization": {
          "type": "string",
          "description": "Organization that this source belongs to, when Chronograf auth is in use",
          "default": "default"
        },
        "role": {
          "type": "string",
          "description": "Not used currently. Can be used to designate a minimum role required to access this source.",
          "default": "viewer"
        },
        "version": {
          "type": "string",
          "description": "Version of influxDB being run, unknown if not found"
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            },
            "proxy": {
              "type": "string",
              "description": "URL location of proxy endpoint for this source",
              "format": "url"
            },
            "write": {
              "type": "string",
              "description": "URL location of write endpoint for this source",
              "format": "url"
            },
            "queries": {
              "type": "string",
              "description": "URL location of the queries endpoint for this source",
              "format": "url"
            },
            "kapacitors": {
              "type": "string",
              "description": "URL location of the kapacitors endpoint for this source",
              "format": "url"
            },
            "users": {
              "type": "string",
              "description": "URL location of the users endpoint for this source",
              "format": "url"
            },
            "permissions": {
              "type": "string",
              "description": "URL location of the permissions endpoint for this source",
              "format": "url"
            },
            "roles": {
              "type": "string",
              "description": "Optional path to the roles endpoint IFF it is supported on this source",
              "format": "url"
            },
            "health": {
              "type": "string",
              "description": "Path to determine if source is healthy",
              "format": "url"
            }
          }
        }
      }
    },
    "Proxy": {
      "type": "object",
      "example": {
        "query": "select $myfield from cpu where time > now() - 10m",
        "db": "telegraf",
        "rp": "autogen",
        "tempVars": [
          {
            "tempVar": ":myfield:",
            "values": [
              {
                "type": "fieldKey",
                "value": "usage_user"
              }
            ]
          }
        ]
      },
      "required": ["query"],
      "properties": {
        "query": {
          "type": "string"
        },
        "db": {
          "type": "string"
        },
        "rp": {
          "type": "string"
        },
        "epoch": {
          "description": "timestamp return format",
          "type": "string",
          "enum": ["h", "m", "s", "ms", "u", "ns"]
        },
        "tempVars": {
          "type": "array",
          "description": "Template variables to replace within an InfluxQL query",
          "items": {
            "$ref": "#/definitions/TemplateVariable"
          }
        }
      }
    },
    "TemplateVariable": {
      "type": "object",
      "description": "Named variable within an InfluxQL query to be replaced with values",
      "properties": {
        "tempVar": {
          "type": "string",
          "description": "String to replace within an InfluxQL statement"
        },
        "values": {
          "type": "array",
          "description": "Values used to replace tempVar.",
          "items": {
            "$ref": "#/definitions/TemplateValue"
          }
        }
      }
    },
    "TemplateValue": {
      "type": "object",
      "description": "Value use to replace a template in an InfluxQL query.  The type governs the output format",
      "properties": {
        "value": {
          "type": "string",
          "description": "Specific value that will be encoded based on type"
        },
        "type": {
          "type": "string",
          "enum": ["csv", "tagKey", "tagValue", "fieldKey", "timeStamp", "map"],
          "description": "The type will change the format of the output value. tagKey/fieldKey are double quoted; tagValue are single quoted; csv and timeStamp are not quoted."
        },
        "key": {
          "type": "string",
          "description": "This will be the key for a specific value of a template variable. Used if the templateVar type is 'map'"
        }
      }
    },
    "ProxyResponse": {
      "type": "object",
      "example": {
        "results": [
          {
            "statement_id": 0,
            "series": [
              {
                "name": "cpu",
                "columns": [
                  "time",
                  "cpu",
                  "host",
                  "usage_guest",
                  "usage_guest_nice",
                  "usage_idle",
                  "usage_iowait",
                  "usage_irq",
                  "usage_nice",
                  "usage_softirq",
                  "usage_steal",
                  "usage_system",
                  "usage_user"
                ],
                "values": [
                  [
                    1487785510000,
                    "cpu-total",
                    "ChristohersMBP2.lan",
                    0,
                    0,
                    76.6916354556804,
                    0,
                    0,
                    0,
                    0,
                    0,
                    4.781523096129837,
                    18.526841448189764
                  ]
                ]
              }
            ]
          }
        ]
      },
      "properties": {
        "results": {
          "description": "results from influx",
          "type": "object"
        }
      }
    },
    "InfluxDB-Roles": {
      "type": "array",
      "items": {
        "$ref": "#/definitions/InfluxDB-Role"
      },
      "example": {
        "roles": [
          {
            "users": [
              {
                "name": "admin",
                "links": {
                  "self": "/chronograf/v1/sources/3/users/admin"
                }
              }
            ],
            "name": "timetravelers",
            "permissions": [
              {
                "scope": "database",
                "name": "telegraf",
                "allowed": ["ReadData", "WriteData"]
              }
            ],
            "links": {
              "self": "/chronograf/v1/sources/3/roles/timetravelers"
            }
          }
        ]
      }
    },
    "InfluxDB-Role": {
      "type": "object",
      "required": ["name"],
      "properties": {
        "name": {
          "type": "string",
          "description": "Unique name of the role",
          "maxLength": 254,
          "minLength": 1
        },
        "users": {
          "$ref": "#/definitions/InfluxDB-Users"
        },
        "permissions": {
          "$ref": "#/definitions/InfluxDB-Permissions"
        },
        "links": {
          "type": "object",
          "description": "URL relations of this role",
          "properties": {
            "self": {
              "type": "string",
              "format": "url",
              "description": "URI of resource."
            }
          }
        }
      },
      "example": {
        "users": [
          {
            "name": "admin",
            "links": {
              "self": "/chronograf/v1/sources/3/users/admin"
            }
          }
        ],
        "name": "timetravelers",
        "permissions": [
          {
            "scope": "database",
            "name": "telegraf",
            "allowed": ["ReadData", "WriteData"]
          }
        ],
        "links": {
          "self": "/chronograf/v1/sources/3/roles/timetravelers"
        }
      }
    },
    "InfluxDB-Users": {
      "type": "object",
      "properties": {
        "users": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/InfluxDB-User"
          }
        }
      },
      "example": {
        "users": [
          {
            "name": "docbrown",
            "permissions": [
              {
                "scope": "all",
                "allowed": [
                  "ViewAdmin",
                  "ViewChronograf",
                  "CreateDatabase",
                  "CreateUserAndRole",
                  "DropDatabase",
                  "DropData",
                  "ReadData",
                  "WriteData",
                  "ManageShard",
                  "ManageContinuousQuery",
                  "ManageQuery",
                  "ManageSubscription",
                  "Monitor",
                  "KapacitorAPI"
                ]
              }
            ],
            "roles": [
              {
                "name": "timetravelers",
                "permissions": [
                  {
                    "scope": "database",
                    "name": "telegraf",
                    "allowed": ["ReadData", "WriteData"]
                  }
                ],
                "links": {
                  "self": "/chronograf/v1/sources/3/roles/timetravelers"
                }
              }
            ],
            "links": {
              "self": "/chronograf/v1/sources/3/users/docbrown"
            }
          }
        ]
      }
    },
    "InfluxDB-User": {
      "type": "object",
      "properties": {
        "name": {
          "type": "string",
          "description": "Unique name of the user",
          "maxLength": 254,
          "minLength": 1
        },
        "password": {
          "type": "string"
        },
        "permissions": {
          "$ref": "#/definitions/InfluxDB-Permissions"
        },
        "roles": {
          "$ref": "#/definitions/InfluxDB-Roles"
        },
        "links": {
          "type": "object",
          "description": "URL relations of this user",
          "properties": {
            "self": {
              "type": "string",
              "format": "url",
              "description": "URI of resource."
            }
          }
        }
      },
      "example": {
        "name": "docbrown",
        "permissions": [
          {
            "scope": "all",
            "allowed": [
              "ViewAdmin",
              "ViewChronograf",
              "CreateDatabase",
              "CreateUserAndRole",
              "DropDatabase",
              "DropData",
              "ReadData",
              "WriteData",
              "ManageShard",
              "ManageContinuousQuery",
              "ManageQuery",
              "ManageSubscription",
              "Monitor",
              "KapacitorAPI"
            ]
          }
        ],
        "roles": [
          {
            "name": "timetravelers",
            "permissions": [
              {
                "scope": "database",
                "name": "telegraf",
                "allowed": ["ReadData", "WriteData"]
              }
            ],
            "links": {
              "self": "/chronograf/v1/sources/3/roles/timetravelers"
            }
          }
        ],
        "links": {
          "self": "/chronograf/v1/sources/3/users/docbrown"
        }
      }
    },
    "InfluxDB-Permissions": {
      "description": "Permissions represent the entire set of permissions a InfluxDB User or InfluxDB Role may have",
      "type": "array",
      "items": {
        "$ref": "#/definitions/InfluxDB-Permission"
      }
    },
    "InfluxDB-Permission": {
      "description": "Permission is a specific allowance for InfluxDB User or InfluxDB Role bound to a scope of the data source",
      "type": "object",
      "required": ["scope", "allowed"],
      "properties": {
        "scope": {
          "type": "string",
          "description": "Describes if the permission is for all databases or restricted to one database",
          "enum": ["all", "database"]
        },
        "name": {
          "type": "string",
          "description": "If the scope is database this identifies the name of the database"
        },
        "allowed": {
          "$ref": "#/definitions/InfluxDB-Allowances"
        }
      },
      "example": {
        "scope": "database",
        "name": "telegraf",
        "allowed": ["READ", "WRITE"]
      }
    },
    "AllPermissions": {
      "description": "All possible permissions for this particular datasource.  Used as a static list",
      "type": "object",
      "properties": {
        "permissions": {
          "$ref": "#/definitions/InfluxDB-Permissions"
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "description": "Relative link back to the permissions endpoint",
              "type": "string",
              "format": "uri"
            },
            "source": {
              "description": "Relative link to host with these permissiosn",
              "type": "string",
              "format": "uri"
            }
          }
        }
      }
    },
    "InfluxDB-Allowances": {
      "description": "Allowances defines what actions a user can have on a scoped permission",
      "type": "array",
      "items": {
        "type": "string",
        "description": "OSS InfluxDB is READ and WRITE.  Enterprise is all others",
        "enum": [
          "READ",
          "WRITE",
          "NoPermissions",
          "ViewAdmin",
          "ViewChronograf",
          "CreateDatabase",
          "CreateUserAndRole",
          "AddRemoveNode",
          "DropDatabase",
          "DropData",
          "ReadData",
          "WriteData",
          "Rebalance",
          "ManageShard",
          "ManageContinuousQuery",
          "ManageQuery",
          "ManageSubscription",
          "Monitor",
          "CopyShard",
          "KapacitorAPI",
          "KapacitorConfigAPI"
        ]
      }
    },
    "Layouts": {
      "required": ["layouts"],
      "type": "object",
      "properties": {
        "layouts": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Layout"
          }
        }
      }
    },
    "Layout": {
      "type": "object",
      "required": ["cells", "app", "measurement"],
      "properties": {
        "id": {
          "type": "string",
          "description": "ID is an opaque string that uniquely identifies this layout."
        },
        "app": {
          "type": "string",
          "description": "App is the user facing name of this Layout"
        },
        "measurement": {
          "type": "string",
          "description": "Measurement is the descriptive name of the time series data."
        },
        "cells": {
          "type": "array",
          "description": "Cells are the individual visualization elements.",
          "items": {
            "$ref": "#/definitions/Cell"
          }
        },
        "link": {
          "$ref": "#/definitions/Link"
        }
      },
      "example": {
        "id": "0e980b97-c162-487b-a815-3f955df62430",
        "app": "docker",
        "measurement": "docker_container_net",
        "autoflow": true,
        "cells": [
          {
            "x": 0,
            "y": 0,
            "w": 4,
            "h": 4,
            "i": "4c79cefb-5152-410c-9b88-74f9bff7ef23",
            "name": "Docker - Container Network",
            "queries": [
              {
                "query": "SELECT derivative(mean(\"tx_bytes\"), 10s) AS \"net_tx_bytes\" FROM \"docker_container_net\"",
                "groupbys": ["\"container_name\""]
              },
              {
                "query": "SELECT derivative(mean(\"rx_bytes\"), 10s) AS \"net_rx_bytes\" FROM \"docker_container_net\"",
                "groupbys": ["\"container_name\""]
              }
            ],
            "type": ""
          }
        ],
        "link": {
          "href": "/chronograf/v1/layouts/0e980b97-c162-487b-a815-3f955df62430",
          "rel": "self"
        }
      }
    },
    "Mappings": {
      "type": "object",
      "required": ["mappings"],
      "properties": {
        "mappings": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Mapping"
          }
        }
      }
    },
    "Mapping": {
      "type": "object",
      "required": ["measurement", "name"],
      "properties": {
        "measurement": {
          "description": "The measurement where data for this mapping is found",
          "type": "string"
        },
        "name": {
          "description": "The application name which will be assigned to the corresponding measurement",
          "type": "string"
        }
      },
      "example": {
        "measurement": "riak",
        "name": "riak"
      }
    },
    "Cell": {
      "type": "object",
      "required": ["i", "x", "y", "w", "h"],
      "properties": {
        "i": {
          "description": "Unique ID of Cell",
          "type": "string",
          "format": "uuid4"
        },
        "x": {
          "description": "X-coordinate of Cell in the Dashboard",
          "type": "integer",
          "format": "int32"
        },
        "y": {
          "description": "Y-coordinate of Cell in the Dashboard",
          "type": "integer",
          "format": "int32"
        },
        "w": {
          "description": "Width of Cell in the Dashboard",
          "type": "integer",
          "format": "int32",
          "minimum": 1,
          "default": 4
        },
        "h": {
          "description": "Height of Cell in the Dashboard",
          "type": "integer",
          "format": "int32",
          "minimum": 1,
          "default": 4
        },
        "name": {
          "description": "Title of Cell in the Dashboard",
          "type": "string"
        },
        "queries": {
          "description": "Time-series data queries for Cell",
          "type": "array",
          "items": {
            "$ref": "#/definitions/DashboardQuery"
          }
        },
        "axes": {
          "description": "The viewport for a Cell's visualizations",
          "type": "object",
          "properties": {
            "x": {
              "$ref": "#/definitions/Axis"
            },
            "y": {
              "$ref": "#/definitions/Axis"
            },
            "y2": {
              "$ref": "#/definitions/Axis"
            }
          }
        },
        "type": {
          "description": "Cell visualization type",
          "type": "string",
          "enum": [
            "single-stat",
            "line",
            "line-plus-single-stat",
            "line-stacked",
            "line-stepplot",
            "bar",
            "gauge",
            "table"
          ],
          "default": "line"
        },
        "colors": {
          "description": "Colors define encoding data into a visualization",
          "type": "array",
          "items": {
            "$ref": "#/definitions/DashboardColor"
          }
        },
        "legend": {
          "description": "Legend define encoding of the data into a cell's legend",
          "type": "object",
          "properties": {
            "type": {
              "description": "type is the style of the legend",
              "type": "string",
              "enum": ["static"]
            },
            "orientation": {
              "description": "orientation is the location of the legend with respect to the cell graph",
              "type": "string",
              "enum": ["top", "bottom", "left", "right"]
            }
          }
        },
        "tableOptions": {
          "verticalTimeAxis": {
            "description": "verticalTimeAxis describes the orientation of the table by indicating whether the time axis will be displayed vertically",
            "type": "boolean"
          },
          "sortBy": {
            "description": "sortBy contains the name of the series that is used for sorting the table",
            "type": "object",
            "$ref": "#/definitions/RenamableField"
          },
          "wrapping": {
            "description": "wrapping describes the text wrapping style to be used in table cells",
            "type": "string",
            "enum": ["truncate", "wrap", "single-line"]
          },
          "fixFirstColumn": {
            "description": "fixFirstColumn indicates whether the first column of the table should be locked",
            "type": "boolean"
          }
        },
        "fieldOptions": {
          "description": "fieldOptions represent the fields retrieved by the query with customization options",
          "type": "array",
          "items": {
            "$ref": "#/definitions/RenamableField"
          }
        },
        "timeFormat": {
          "description": "timeFormat describes the display format for time values according to moment.js date formatting",
          "type": "string"
        },
        "decimalPoints": {
          "description": "decimal points indicates whether and how many digits to show after decimal point",
          "type": "object",
          "properties": {
            "isEnforced": {
              "description": "Indicates whether decimal point setting should be enforced",
              "type": "bool"
            },
            "digits": {
              "description": "The number of digits after decimal to display",
              "type": "integer"
            }
          }
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          }
        }
      },
      "example": {
        "x": 5,
        "y": 5,
        "w": 4,
        "h": 4,
        "name": "usage_user",
        "queries": [
          {
            "query": "SELECT mean(\"usage_user\") AS \"usage_user\" FROM \"cpu\"",
            "label": "%"
          }
        ],
        "type": "line"
      }
    },
    "LayoutQuery": {
      "type": "object",
      "required": ["query"],
      "properties": {
        "label": {
          "description": "Optional Y-axis user-facing label for this query",
          "type": "string"
        },
        "range": {
          "description": "Optional default range of the Y-axis",
          "type": "object",
          "required": ["upper", "lower"],
          "properties": {
            "upper": {
              "description": "Upper bound of the display range of the Y-axis",
              "type": "integer",
              "format": "int64"
            },
            "lower": {
              "description": "Lower bound of the display range of the Y-axis",
              "type": "integer",
              "format": "int64"
            }
          }
        },
        "query": {
          "type": "string"
        },
        "wheres": {
          "description": "Defines the condition clauses for influxdb",
          "type": "array",
          "items": {
            "type": "string"
          }
        },
        "groupbys": {
          "description": "Defines the group by clauses for influxdb",
          "type": "array",
          "items": {
            "type": "string"
          }
        }
      },
      "example": {
        "label": "# warnings",
        "query": "SELECT count(\"check_id\") as \"Number Warning\" FROM consul_health_checks",
        "wheres": ["\"status\" = 'warning'"],
        "groupbys": ["\"service_name\""]
      }
    },
    "DashboardQuery": {
      "type": "object",
      "required": ["query"],
      "properties": {
        "label": {
          "description": "Optional Y-axis user-facing label for this query",
          "type": "string"
        },
        "range": {
          "description": "Optional default range of the Y-axis",
          "type": "object",
          "required": ["upper", "lower"],
          "properties": {
            "upper": {
              "description": "Upper bound of the display range of the Y-axis",
              "type": "integer",
              "format": "int64"
            },
            "lower": {
              "description": "Lower bound of the display range of the Y-axis",
              "type": "integer",
              "format": "int64"
            }
          }
        },
        "query": {
          "type": "string"
        },
        "source": {
          "type": "string",
          "format": "url",
          "description": "Optional URI for data source for this query"
        },
        "type": {
          "description": "The language used by the query (either influxql or flux",
          "type": "string"
        },
        "queryConfig": {
          "$ref": "#/definitions/QueryConfig"
        }
      },
      "example": {
        "id": "4",
        "cells": [
          {
            "x": 0,
            "y": 0,
            "w": 4,
            "h": 4,
            "name": "",
            "queries": [
              {
                "query": "SELECT mean(\"usage_user\") AS \"mean_usage_user\" FROM \"cpu\"",
                "label": "%",
                "type": "influxql",
                "queryConfig": {
                  "database": "",
                  "measurement": "cpu",
                  "retentionPolicy": "",
                  "fields": [
                    {
                      "value": "mean",
                      "type": "func",
                      "alias": "mean_usage_user",
                      "args": [
                        {
                          "value": "usage_user",
                          "type": "field"
                        }
                      ]
                    }
                  ],
                  "tags": {},
                  "groupBy": {
                    "time": "",
                    "tags": []
                  },
                  "areTagsAccepted": false
                }
              }
            ],
            "type": "line"
          }
        ],
        "name": "dashboard name",
        "links": {
          "self": "/chronograf/v1/dashboards/4"
        }
      }
    },
    "Dashboards": {
      "description": "a list of dashboards",
      "type": "object",
      "properties": {
        "dashboards": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Dashboard"
          }
        }
      }
    },
    "DashboardCreate": {
      "type": "object",
      "properties": {
        "cells": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Cell"
          }
        },
        "name": {
          "description": "the user-facing name of the dashboard",
          "type": "string"
        }
      },
      "example": {
        "cells": [
          {
            "x": 5,
            "y": 5,
            "w": 4,
            "h": 4,
            "name": "usage_user",
            "queries": [
              {
                "query": "SELECT mean(\"usage_user\") AS \"usage_user\" FROM \"cpu\"",
                "db": "telegraf",
                "label": "%"
              }
            ],
            "type": "line"
          },
          {
            "x": 0,
            "y": 0,
            "w": 4,
            "h": 4,
            "name": "usage_system",
            "queries": [
              {
                "query": "SELECT mean(\"usage_system\") AS \"usage_system\" FROM \"cpu\"",
                "db": "telegraf",
                "label": "%"
              }
            ],
            "type": "line"
          }
        ],
        "name": "lalalalala"
      }
    },
    "Dashboard": {
      "type": "object",
      "properties": {
        "id": {
          "description": "the unique dashboard id",
          "type": "string"
        },
        "cells": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Cell"
          }
        },
        "name": {
          "description": "the user-facing name of the dashboard",
          "type": "string"
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          }
        }
      },
      "example": {
        "id": "4",
        "cells": [
          {
            "x": 5,
            "y": 5,
            "w": 4,
            "h": 4,
            "name": "usage_user",
            "queries": [
              {
                "query": "SELECT mean(\"usage_user\") AS \"usage_user\" FROM \"cpu\"",
                "db": "telegraf",
                "label": "%"
              }
            ],
            "type": "line"
          },
          {
            "x": 0,
            "y": 0,
            "w": 4,
            "h": 4,
            "name": "usage_system",
            "queries": [
              {
                "query": "SELECT mean(\"usage_system\") AS \"usage_system\" FROM \"cpu\"",
                "db": "telegraf",
                "label": "%"
              }
            ],
            "type": "line"
          }
        ],
        "name": "lalalalala",
        "links": {
          "self": "/chronograf/v1/dashboards/4"
        }
      }
    },
    "DashboardColor": {
      "type": "object",
      "description": "Color defines an encoding of a data value into color space",
      "properties": {
        "id": {
          "description": "ID is the unique id of the cell color",
          "type": "string"
        },
        "type": {
          "description": "Type is how the color is used.",
          "type": "string",
          "enum": ["min", "max", "threshold"]
        },
        "hex": {
          "description": "Hex is the hex number of the color",
          "type": "string",
          "maxLength": 7,
          "minLength": 7
        },
        "name": {
          "description": "Name is the user-facing name of the hex color",
          "type": "string"
        },
        "value": {
          "description": "Value is the data value mapped to this color",
          "type": "string"
        }
      }
    },
    "Axis": {
      "type": "object",
      "description": "A description of a particular axis for a visualization",
      "properties": {
        "bounds": {
          "type": "array",
          "minItems": 0,
          "maxItems": 2,
          "description": "The extents of an axis in the form [lower, upper]. Clients determine whether bounds are to be inclusive or exclusive of their limits",
          "items": {
            "type": "integer",
            "format": "int64"
          }
        },
        "label": {
          "description": "label is a description of this Axis",
          "type": "string"
        },
        "prefix": {
          "description": "Prefix represents a label prefix for formatting axis values.",
          "type": "string"
        },
        "suffix": {
          "description": "Suffix represents a label suffix for formatting axis values.",
          "type": "string"
        },
        "base": {
          "description": "Base represents the radix for formatting axis values.",
          "type": "string"
        },
        "scale": {
          "description": "Scale is the axis formatting scale. Supported: \"log\", \"linear\"",
          "type": "string"
        }
      }
    },
    "RenamableField": {
      "description": "Describes a field that can be renamed and made visible or invisible",
      "type": "object",
      "properties": {
        "internalName": {
          "description": "This is the calculated name of a field",
          "readOnly": true,
          "type": "string"
        },
        "displayName": {
          "description": "This is the name that a field is renamed to by the user",
          "type": "string"
        },
        "visible": {
          "description": "Indicates whether this field should be visible on the table",
          "type": "boolean"
        }
      }
    },
    "Config": {
      "description": "Global application configuration",
      "type": "object",
      "properties": {
        "auth": {
          "$ref": "#/definitions/AuthConfig"
        }
      },
      "example": {
        "auth": {
          "superAdminNewUsers": true
        }
      }
    },
    "AuthConfig": {
      "description": "Global application configuration for auth",
      "type": "object",
      "required": ["superAdminNewUsers"],
      "properties": {
        "superAdminNewUsers": {
          "type": "boolean",
          "default": true
        }
      },
      "example": {
        "superAdminNewUsers": true
      }
    },
    "OrganizationConfig": {
      "description": "Configurations for a specific organization",
      "type": "object",
      "required": ["logViewer"],
      "properties": {
        "organization": {
          "type": "string",
          "readOnly": true
        },
        "logViewer": {
          "$ref": "#/definitions/LogViewerConfig"
        }
      },
      "example": {
        "organization": "default",
        "logViewer": {
          "columns": [
            {
              "name": "severity",
              "position": 0,
              "encodings": [
                {
                  "type": "label",
                  "value": "icon"
                },
                {
                  "type": "label",
                  "value": "text"
                },
                {
                  "type": "visibility",
                  "value": "visible"
                },
                {
                  "type": "color",
                  "name": "ruby",
                  "value": "emergency"
                },
                {
                  "type": "color",
                  "name": "rainforest",
                  "value": "info"
                },
                {
                  "type": "displayName",
                  "value": "Log Severity!"
                }
              ]
            },
            {
              "name": "messages",
              "position": 1,
              "encodings": [
                {
                  "type": "visibility",
                  "value": "hidden"
                }
              ]
            }
          ]
        }
      }
    },
    "LogViewerConfig": {
      "description": "Contains the organization-specific configuration for the log viewer",
      "type": "object",
      "required": ["columns"],
      "properties": {
        "columns": {
          "description": "Defines the order, names, and visibility of columns in the log viewer table",
          "type": "array",
          "items": {
            "$ref": "#/definitions/LogViewerColumn"
          }
        }
      },
      "example": {
        "columns": [
          {
            "name": "severity",
            "position": 0,
            "encodings": [
              {
                "type": "label",
                "value": "icon"
              },
              {
                "type": "label",
                "value": "text"
              },
              {
                "type": "visibility",
                "value": "visible"
              },
              {
                "type": "color",
                "name": "ruby",
                "value": "emergency"
              },
              {
                "type": "color",
                "name": "rainforest",
                "value": "info"
              },
              {
                "type": "displayName",
                "value": "Log Severity!"
              }
            ]
          },
          {
            "name": "messages",
            "position": 1,
            "encodings": [
              {
                "type": "visibility",
                "value": "hidden"
              }
            ]
          }
        ]
      }
    },
    "LogViewerColumn": {
      "description": "Contains the organization-specific configuration for the log viewer",
      "type": "object",
      "required": ["name", "encodings", "position"],
      "properties": {
        "name": {
          "description": "Unique identifier name of the column",
          "type": "string"
        },
        "position": {
          "type": "integer",
          "format": "int32"
        },
        "encodings": {
          "description": "Composable encoding options for the column",
          "type": "array",
          "items": {
            "description": "Type and value and optional name of an encoding",
            "type": "object",
            "required": ["type", "value"],
            "properties": {
              "type": {
                "type": "string"
              },
              "value": {
                "type": "string"
              },
              "name": {
                "type": "string"
              }
            }
          }
        }
      },
      "example": {
        "name": "severity",
        "position": 0,
        "encodings": [
          {
            "type": "label",
            "value": "icon"
          },
          {
            "type": "label",
            "value": "text"
          },
          {
            "type": "visibility",
            "value": "visible"
          },
          {
            "type": "color",
            "name": "ruby",
            "value": "emergency"
          },
          {
            "type": "color",
            "name": "rainforest",
            "value": "info"
          },
          {
            "type": "displayName",
            "value": "Log Severity!"
          }
        ]
      }
    },
    "Routes": {
      "type": "object",
      "properties": {
        "me": {
          "description": "Location of the me endpoint.",
          "type": "string",
          "format": "url"
        },
        "layouts": {
          "description": "Location of the layouts endpoint",
          "type": "string",
          "format": "url"
        },
        "sources": {
          "description": "Location of the sources endpoint",
          "type": "string",
          "format": "url"
        },
        "mappings": {
          "description": "Location of the application mappings endpoint",
          "type": "string",
          "format": "url"
        },
        "dashboards": {
          "description": "location of the dashboards endpoint",
          "type": "string",
          "format": "url"
        },
        "external": {
          "description": "external links provided to client, ex. status feed URL",
          "type": "object",
          "properties": {
            "statusFeed": {
              "description": "link to a JSON Feed for the News Feed on client's Status Page",
              "type": "string",
              "format": "url"
            },
            "custom": {
              "description": "a collection of custom links set by the user to be rendered in the client User menu",
              "type": "array",
              "items": {
                "type": "object",
                "properties": {
                  "name": {
                    "type": "string"
                  },
                  "url": {
                    "type": "string",
                    "format": "url"
                  }
                }
              }
            }
          }
        }
      },
      "example": {
        "layouts": "/chronograf/v1/layouts",
        "mappings": "/chronograf/v1/mappings",
        "sources": "/chronograf/v1/sources",
        "me": "/chronograf/v1/me",
        "dashboards": "/chronograf/v1/dashboards",
        "external": {
          "statusFeed": "http://news.influxdata.com/feed.json",
          "custom": [
            {
              "name": "InfluxData",
              "url": "https://www.influxdata.com"
            }
          ]
        }
      }
    },
    "Link": {
      "type": "object",
      "required": ["rel", "href"],
      "readOnly": true,
      "description": "URI of resource.",
      "properties": {
        "rel": {
          "type": "string"
        },
        "href": {
          "type": "string",
          "format": "url"
        }
      }
    },
    "Error": {
      "type": "object",
      "properties": {
        "code": {
          "type": "integer",
          "format": "int32"
        },
        "message": {
          "type": "string"
        }
      }
    },
    "AnnotationsResponse": {
      "type": "object",
      "properties": {
        "queries": {
          "type": "array",
          "items": {
            "$ref": "#/definitions/Annotation"
          }
        }
      },
      "example": {
        "annotations": [
          {
            "id": "50ee18e8-8115-4fac-abed-24ce89e96047",
            "startTime": "2018-07-09T18:08:15.933Z",
            "endTime": "2018-07-09T18:08:15.933Z",
            "text": "unknown event",
            "tags": {},
            "links": {
              "self": "/chronograf/v1/sources/1/annotations/50ee18e8-8115-4fac-abed-24ce89e96047"
            }
          },
          {
            "id": "59434c1c-fa16-40e9-8b92-af71544cc3eb",
            "startTime": "2018-07-09T17:48:04.23Z",
            "endTime": "2018-07-09T17:48:08.652Z",
            "text": "todo: investigate this spike",
            "tags": {
              "repo": "influxdata/chronograf"
            },
            "links": {
              "self": "/chronograf/v1/sources/1/annotations/59434c1c-fa16-40e9-8b92-af71544cc3eb"
            }
          }
        ]
      }
    },
    "Annotation": {
      "type": "object",
      "properties": {
        "id": {
          "type": "string",
          "description": "ID of the annotation",
          "example": {
            "id": "b19c707a-ac7b-4518-86e3-0ee52e563934"
          }
        },
        "startTime": {
          "type": "string",
          "description": "RFC3339 datetime for the start of the annotation",
          "example": {
            "startTime": "2018-07-09T15:49:07.064Z"
          }
        },
        "endTime": {
          "type": "string",
          "description": "RFC3339 datetime for the end of the annotation",
          "example": {
            "endTime": "2018-07-09T15:49:07.064Z"
          }
        },
        "text": {
          "type": "string",
          "description": "A user-facing description of the annotation",
          "example": {
            "text": "my annotation"
          }
        },
        "tags": {
          "type": "object",
          "description": "A set of user-defined tags associated with the annotation",
          "additionalProperties": {
            "type": "string"
          }
        },
        "links": {
          "type": "object",
          "properties": {
            "self": {
              "type": "string",
              "description": "Self link mapping to this resource",
              "format": "url"
            }
          }
        }
      },
      "example": {
        "id": "59434c1c-fa16-40e9-8b92-af71544cc3eb",
        "startTime": "2018-07-09T17:48:04.23Z",
        "endTime": "2018-07-09T17:48:08.652Z",
        "text": "no name",
        "tags": {
          "repo": "influxdata/chronograf"
        },
        "links": {
          "self": "/chronograf/v1/sources/1/annotations/59434c1c-fa16-40e9-8b92-af71544cc3eb"
        }
      }
    },
    "UpdateAnnotationRequest": {
      "type": "object",
      "properties": {
        "startTime": {
          "type": "string",
          "description": "RFC3339 datetime for the start of the annotation",
          "example": {
            "startTime": "2018-07-09T15:49:07.064Z"
          }
        },
        "endTime": {
          "type": "string",
          "description": "RFC3339 datetime for the end of the annotation",
          "example": {
            "endTime": "2018-07-09T15:49:07.064Z"
          }
        },
        "text": {
          "type": "string",
          "description": "A user-facing description of the annotation",
          "example": {
            "text": "my annotation"
          }
        },
        "tags": {
          "type": "object",
          "description": "A set of user-defined tags associated with the annotation",
          "additionalProperties": {
            "type": "string"
          }
        }
      },
      "example": {
        "text": "new annotation text"
      }
    }
  }
}
`)

func swaggerJsonBytes() ([]byte, error) {
	return _swaggerJson, nil
}

func swaggerJson() (*asset, error) {
	bytes, err := swaggerJsonBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "swagger.json", size: 185129, mode: os.FileMode(420), modTime: time.Unix(1594590827, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"swagger.json": swaggerJson,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"swagger.json": &bintree{swaggerJson, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
