/*========================== begin_copyright_notice ============================

Copyright (C) 2023-2025 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/

//     File Name:  md_metric_sets_PVC_GT2.cpp
//
//     Abstract:   C++ automated generated file that defines Metric Sets
//                 for each Concurrent Group

#include "md_concurrent_group.h"
#include "md_metric_set.h"
#include "md_metric_sets_PVC_GT2.h"
#include "md_information.h"
#include "md_metric.h"
#include "md_utils.h"
#include <algorithm>

#if MD_INCLUDE_PVC_GT2_METRICS

namespace MetricsDiscoveryInternal::MetricSets_PVC_GT2_OA
{
    TCompletionCode AddInformationSet( CConcurrentGroup* concurrentGroup )
    {
        CInformation* information = nullptr;

        information = concurrentGroup->AddInformation( "QueryBeginTime", "Query Begin Time", "The measurement begin time.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_TIMESTAMP, "ns", nullptr, 0 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x1c0" ) );
        MD_CHECK_CC( information->SetOverflowFunction( "NS_TIME" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyMHz", "GPU Core Frequency", "The last GPU core (unslice) frequency in the measurement.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 1 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 0x1ff AND 16666 UMUL 1000 UDIV" ) );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "qw@0x218 1000000 UDIV" ) );

        information = concurrentGroup->AddInformation( "XveSliceFrequencyMHz", "XVE Slice Frequency", "The last GPU Execution Unit slice frequency in the measurement.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, "MHz", nullptr, 2 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 25 >> dw@0x0 9 >> 0x3 AND OR 16666 UMUL 1000 UDIV" ) );

        information = concurrentGroup->AddInformation( "ReportReason", "Report Reason", "The reason of the report.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_REPORT_REASON, nullptr, nullptr, 3 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 19 >> 0x7f AND" ) );

        information = concurrentGroup->AddInformation( "ContextIdValid", "Context ID Valid", "When set indicates render context is valid", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_FLAG, nullptr, nullptr, 4 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 16 >> 0x1 AND" ) );

        information = concurrentGroup->AddInformation( "ContextId", "Context ID", "The context tag in which report has been taken.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_CONTEXT_ID_TAG, nullptr, nullptr, 5 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 0xffbfffff AND dw@0x0 16 >> 0x1 AND UMUL" ) );

        information = concurrentGroup->AddInformation( "SourceId", "SourceId", "SourceId", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 6 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x0 26 >> 0x3f AND" ) );

        information = concurrentGroup->AddInformation( "CoreFrequencyChanged", "GPU Core Frequency Changed", "The flag indicating that GPU core frequency has changed.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 7 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x214" ) );

        information = concurrentGroup->AddInformation( "QuerySplitOccurred", "Query Split Occurred", "The flag indicating that query has been split during execution on the GPU.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 8 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x210" ) );

        information = concurrentGroup->AddInformation( "ReportId", "Query report id", "Query report identification number.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 9 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x220" ) );

        information = concurrentGroup->AddInformation( "ReportsCount", "Query reports count", "The number of available query reports.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_VALUE, nullptr, nullptr, 10 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x224" ) );

        information = concurrentGroup->AddInformation( "OverrunOccured", "Query Overrun Occurred", "The flag indicating that Oa buffer has been overran.", "Exception", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 11 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1dc" ) );

        information = concurrentGroup->AddInformation( "MidQueryTimer", "Mid Query Timer", "The flag indicating that timer report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 12 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryProgramming", "Mid Query Programming", "The flag indicating that counter programming report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 13 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMarker", "Mid Query Marker", "The flag indicating that query marker report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 14 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x04 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryCtxSwitch", "Mid Query Context Switch", "The flag indicating that context switch report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 15 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryC6", "Mid Query C6", "The flag indicating that C6 report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 16 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryFreqChange", "Mid Query Freq Change", "The flag indicating that frequency change report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 17 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x20 AND" ) );

        information = concurrentGroup->AddInformation( "MidQueryMmioTrigger", "Mid Query Mmio Trigger", "The flag indicating that mmio trigger report was detected during query.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 18 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x1d8 0x40 AND" ) );

        information = concurrentGroup->AddInformation( "StreamMarker", "Stream marker", "Stream marker value.", "Report Meta Data", API_TYPE_IOSTREAM, INFORMATION_TYPE_VALUE, nullptr, nullptr, 19 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetSnapshotReportReadEquation( "dw@0x08 dw@0x0 19 >> 0x8 AND 0x0 == UMUL" ) );

        information = concurrentGroup->AddInformation( "ReportError", "Query report error", "An error in the query execution, the received report should be ignored.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 20 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x33 AND" ) );

        information = concurrentGroup->AddInformation( "ReportLost", "Query report lost", "Begin or end query report has not been triggered due to hw limitations.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 21 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x01 AND" ) );

        information = concurrentGroup->AddInformation( "ReportInconsistent", "Query report inconsistent", "The contextId inconsistency in the Oa buffer within the query window.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 22 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x02 AND" ) );

        information = concurrentGroup->AddInformation( "ReportCtxSwitchLost", "Query report context switch lost", "Other contexts activity is not filter out from the query report.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 23 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x08 AND" ) );

        information = concurrentGroup->AddInformation( "ReportWithoutWorkload", "Query report missing workload", "Missing workload between query begin and query end.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 24 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x10 AND" ) );

        information = concurrentGroup->AddInformation( "ReportContextMismatch", "Query report context mismatch", "Contexts on query begin and query end are different.", "Report Meta Data", API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL, INFORMATION_TYPE_FLAG, nullptr, nullptr, 25 );
        MD_CHECK_PTR( information );
        MD_CHECK_CC( information->SetDeltaReportReadEquation( "dw@0x2ac 0x20 AND" ) );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CComputeBasicMetricSet::CComputeBasicMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CComputeBasicMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "L3_BYTE_READ", "L3 Byte Read",
            "Number of bytes read from L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$L3BankTotalCount 64 ==", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "4096 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "L3_BYTE_WRITE", "L3 Byte Write",
            "Number of bytes written to L3",
            "L3Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$L3BankTotalCount 64 ==", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xdc dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL 7 UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x178 qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL 7 UDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "4096 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        metric = AddMetric( "XVE_ATOMIC_ACCESS_COUNT", "XVE Atomic Access Count",
            "Number of shader atomic memory accesses",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x98" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x120" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_BARRIER_MESSAGE_COUNT", "XVE Barrier Message Count",
            "Number of shader barrier messages",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "messages", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x9c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x128" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL", "XVE Inst Executed ALU0 All",
            "Number of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL", "XVE Inst Executed ALU1 All",
            "Number of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL", "XVE Inst Executed XMX All",
            "Number of execution slots taken by instructions executed on XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL", "XVE Inst Executed Send All",
            "Number of instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 19 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL", "XVE Inst Executed Control All",
            "Number of instructions executed on Jump Pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 20 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "$GpuCoreClocks $VectorEngineTotalCount UMUL" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_ALU1_ACTIVE", "XVE Pipe ALU0 And ALU1 Active",
            "Percentage of time in which ALU0 and ALU1 pipes are both actively executing a Gen ISA instruction",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 21 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x44:0xad" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x78" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_PIPE_ALU0_AND_XMX_ACTIVE", "XVE_PIPE_ALU0_AND_XMX_ACTIVE",
            "Percentage of time in which ALU0 and XMX pipes are both actively executing a Gen ISA instruction.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 22 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x48:0xae" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x80" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU0_ALL_UTILIZATION", "XVE Inst Executed ALU0 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU0 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 23 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x38:0xaa" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x60" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_ALU1_ALL_UTILIZATION", "XVE Inst Executed ALU1 All Utilization",
            "Percentage of execution slots taken by instructions executed on ALU1 pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 24 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x3c:0xab" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x68" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_SEND_ALL_UTILIZATION", "XVE Inst Executed Send All Utilization",
            "Percentage of time taken by instructions executed on SEND pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 25 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x50:0xb0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x90" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_CONTROL_ALL_UTILIZATION", "XVE Inst Executed Control All Utilization",
            "Percentage of time taken by instructions executed on Jump pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 26 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x4c:0xaf" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x88" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_INST_EXECUTED_XMX_ALL_UTILIZATION", "XVE Inst Executed XMX All Utilization",
            "Percentage of execution slots taken by instructions executed on XMX pipe",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 27 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x40:0xac" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x70" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x044c2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x064c7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0461e000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06002000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08007005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06082005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08087000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x004c0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a4c0140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x124c0340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00610000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12610005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00200010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02200010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02000010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1000000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00280002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02280002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02080010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e08000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00080000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04482000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06487000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04822000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06827000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00480010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08480140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10480340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00820010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08820005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1082000d, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x046d2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x066d7140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x006d0010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e6d0340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000007, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04692140, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06697000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00690010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c690340, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x014085e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3340a5e5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01410a0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410a0f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01034555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01048aaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f504404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e74000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e74000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea8000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea8000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f98080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e88000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0c484, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f18010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f19010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f24404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f42020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c70010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d90404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb0404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00404, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d31002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc4000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd2000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf4000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c11000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c43000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ffbf, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1c500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x285000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a501801, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500030, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x305000a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32501400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2250060c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26501405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f501010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30280, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ed0800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed0800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef2020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f40200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e10400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e10400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f72020, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e20800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e20800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d31000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cc1010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cd0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02cd0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cf1010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c10200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c01010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d61010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e70040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e70040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ea00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ea00c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00808, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10080, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f500101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f00101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f20101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f3000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f31400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ec0202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ed0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ed0008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ef0202, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f40002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e10004, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e4000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e4000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c70001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02ca0002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d90101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c80001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00cb0101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d00101, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x40800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00400000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000040, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe658, 0x00009001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe758, 0x0000a003, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe45c, 0x01002001, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CGpuOffloadMetricSet::CGpuOffloadMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CGpuOffloadMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SYSMEM_BYTE_READ", "SysMem Byte Read",
            "Number of system memory bytes read (upstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SYSMEM_BYTE_WRITE", "SysMem Byte Write",
            "Number of system memory bytes written (upstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_RECEIVE", "Stack To Stack Data Byte Receive",
            "Number of data bytes received (incoming write read return)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xe8 dw@0xec UADD dw@0xf0 UADD dw@0xf4 UADD dw@0xf8 UADD dw@0xfc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x190 qw@0x198 UADD qw@0x1a0 UADD qw@0x1a8 UADD qw@0x1b0 UADD qw@0x1b8 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "STACK_TO_STACK_DATA_BYTE_TRANSMIT", "Stack To Stack Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xd0 dw@0xd4 UADD dw@0xd8 UADD dw@0xdc UADD dw@0xe0 UADD dw@0xe4 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x160 qw@0x168 UADD qw@0x170 UADD qw@0x178 UADD qw@0x180 UADD qw@0x188 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04306824, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00300000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02300000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2a50140a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2c500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x2e500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500010, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01406a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x334056a5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01418000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f41a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01070050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010800a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01035500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0104aa50, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaaa, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01050050, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0106000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f501c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22f32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f42a00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f402a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d01c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d11500, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d10150, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d21c70, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22d32000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d30012, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d30092, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08d40617, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad40019, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40103, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d40005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000009, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f50e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24f32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f48000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4a80a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d14000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15405, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2e380, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24d32480, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ad405c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cd40658, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d400c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40144, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00010000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CMemProfileMetricSet::CMemProfileMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CMemProfileMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_BYTE_READ", "Host To GpuMem Byte Read",
            "Number of bytes read by host from GPU local (HBM) memory (downstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "HOST_TO_GPUMEM_BYTE_WRITE", "Host To GpuMem Byte Write",
            "Number of bytes written by host to GPU local (HBM) memory (downstream)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "64 $Self UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_RECEIVE", "Scaleup Data Byte Receive",
            "Number of data bytes received (incoming write read return to GPU)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xf4 dw@0xf8 UADD dw@0xfc UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x1a8 qw@0x1b0 UADD qw@0x1b8 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "SCALEUP_DATA_BYTE_TRANSMIT", "Scaleup Data Byte Transmit",
            "Number of data bytes sent (outgoing write read return from GPU)",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xe8 dw@0xec UADD dw@0xf0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x190 qw@0x198 UADD qw@0x1a0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14307fc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0050ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0030000e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a300285, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02300000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3250140a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14d45014, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16d40015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f50fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f0fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f15550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00f2fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26f32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28f30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02f4aaa0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d0fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d15550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00d2fc00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x26d32492, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x28d30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ed40617, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10d400d9, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12d40144, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02d40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33405550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f41fff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03070005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0308000a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03035550, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0304aaa5, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03050005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01060300, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x10800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00010000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataportProfileMetricSet::CDataportProfileMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataportProfileMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ", "DATAPORT BYTE READ ",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "64 dw@0xfc dw@0xf8 UADD dw@0xf4 UADD dw@0xf0 UADD dw@0xec UADD dw@0xe8 UADD dw@0xe4 UADD dw@0xe0 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "64 qw@0x1b8 qw@0x1b0 UADD qw@0x1a8 UADD qw@0x1a0 UADD qw@0x198 UADD qw@0x190 UADD qw@0x188 UADD qw@0x180 UADD UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "64 $XeCoreTotalCount $GpuCoreClocks UMUL UMUL" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE", "DATAPORT BYTE WRITE ",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "32 $XeCoreTotalCount UMUL dw@0xd8 dw@0xd4 UADD dw@0xd0 UADD dw@0xcc UADD dw@0xc8 UADD dw@0xc4 UADD dw@0xc0 UADD UMUL $XeCoreTotalCount $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD USUB UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "32 $XeCoreTotalCount UMUL qw@0x170 qw@0x168 UADD qw@0x160 UADD qw@0x158 UADD qw@0x150 UADD qw@0x148 UADD qw@0x140 UADD UMUL $XeCoreTotalCount $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD USUB UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "32 $XeCoreTotalCount $GpuCoreClocks UMUL UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030580, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c02000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c13600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c23f60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c3141b, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileReadsMetricSet_XeCore0::CL1ProfileReadsMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileReadsMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000feff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileReadsMetricSet_XeCore4::CL1ProfileReadsMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileReadsMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_READ", "Load Store Cache Byte Read",
            "Number of bytes read out of the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_READ", "SLM Byte Read",
            "Number of bytes read from SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "512 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4190f, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40105, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e40083, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e40001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000feff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet_XeCore0::CL1ProfileSlmBankConflictsMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xcc 2 dw@0xc8 UMUL UADD 4 dw@0xc4 UMUL UADD 8 dw@0xc0 UMUL UADD UADD UMUL 3 UDIV $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x158 2 qw@0x150 UMUL UADD 4 qw@0x148 UMUL UADD 8 qw@0x140 UMUL UADD UADD UMUL 3 UDIV $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0cc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ac5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21c51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0dc40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07c54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09c50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0bc5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c100ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c200ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ff8f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileSlmBankConflictsMetricSet_XeCore4::CL1ProfileSlmBankConflictsMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileSlmBankConflictsMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "SLM_BANK_CONFLICT_COUNT", "SLM Bank Conflict Count",
            "Number of SLM accesses resulting in a bank conflict.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD dw@0xec 2 dw@0xe8 UMUL UADD 4 dw@0xe4 UMUL UADD 8 dw@0xe0 UMUL UADD UADD dw@0xcc 2 dw@0xc8 UMUL UADD 4 dw@0xc4 UMUL UADD 8 dw@0xc0 UMUL UADD UADD UMUL 3 UDIV $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD qw@0x198 2 qw@0x190 UMUL UADD 4 qw@0x188 UMUL UADD 8 qw@0x180 UMUL UADD UADD qw@0x158 2 qw@0x150 UMUL UADD 4 qw@0x148 UMUL UADD 8 qw@0x140 UMUL UADD UADD UMUL 3 UDIV $XeCoreTotalCount UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x20e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ce40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x06e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ae5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e4298e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25e414c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x21e51800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23e50005, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30042, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012300ff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323ffff, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0de40c40, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe40ff0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e4007e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e403c0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07e54201, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09e50be0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0be5002e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6ff00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20055, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25555, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c306db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ff8f, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileWritesMetricSet_XeCore0::CL1ProfileWritesMetricSet_XeCore0( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileWritesMetricSet_XeCore0::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore0 $GtSlice1XeCore0 UADD $GtSlice2XeCore0 UADD $GtSlice3XeCore0 UADD $GtSlice4XeCore0 UADD $GtSlice5XeCore0 UADD $GtSlice6XeCore0 UADD $GtSlice7XeCore0 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0203fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ec4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0303fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05c40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fc4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c00001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c05554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c10003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000feff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CL1ProfileWritesMetricSet_XeCore4::CL1ProfileWritesMetricSet_XeCore4( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CL1ProfileWritesMetricSet_XeCore4::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "GpuSliceClocksCount", "Gpu Slice Clocks Count",
            "Number of slice clock cycles",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178 $SliceTotalCount UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuSliceFrequencyMHz", "AVG GPU Slice Frequency",
            "Average GPU Slice Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuSliceClocksCount 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "LOAD_STORE_CACHE_BYTE_WRITE", "Load Store Cache Byte Write",
            "Number of bytes written to the Load Store Cache, excluding SLM accesses.",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "SLM_BYTE_WRITE", "SLM Byte Write",
            "Number of bytes written to SLM",
            "L1Cache", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 $XeCoreTotalCount UMUL dw@0xfc 2 dw@0xf8 UMUL UADD 4 dw@0xf4 UMUL UADD 8 dw@0xf0 UMUL UADD 16 dw@0xec UMUL UADD 32 dw@0xe8 UMUL UADD 64 dw@0xe4 UMUL UADD dw@0xc0 2 dw@0xc4 UMUL UADD 4 dw@0xc8 UMUL UADD 8 dw@0xcc UMUL UADD 16 dw@0xd0 UMUL UADD 32 dw@0xd4 UMUL UADD 64 dw@0xd8 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 $XeCoreTotalCount UMUL qw@0x1b8 2 qw@0x1b0 UMUL UADD 4 qw@0x1a8 UMUL UADD 8 qw@0x1a0 UMUL UADD 16 qw@0x198 UMUL UADD 32 qw@0x190 UMUL UADD 64 qw@0x188 UMUL UADD qw@0x140 2 qw@0x148 UMUL UADD 4 qw@0x150 UMUL UADD 8 qw@0x158 UMUL UADD 16 qw@0x160 UMUL UADD 32 qw@0x168 UMUL UADD 64 qw@0x170 UMUL UADD USUB UMUL $GtSlice0XeCore4 $GtSlice1XeCore4 UADD $GtSlice2XeCore4 UADD $GtSlice3XeCore4 UADD $GtSlice4XeCore4 UADD $GtSlice5XeCore4 UADD $GtSlice6XeCore4 UADD $GtSlice7XeCore4 UADD UDIV" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "256 $XeCoreTotalCount UMUL $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_READ", "GPU Memory Byte Read",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) read bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xa0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x130" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "GPU_MEMORY_BYTE_WRITE", "GPU Memory Byte Write",
            "Number of device local memory (HBM, GDDR, LPDDR, etc.) write bytes",
            "Memory", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xb8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x138" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 128 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1024 $GpuCoreClocks UMUL" ) );

        metric = AddMetric( "XVE_ACTIVE", "XVE Active",
            "Percentage of time in which at least one pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x2c:0xa7" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x48" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_STALL", "XVE Stall",
            "Percentage of time in which any threads are loaded but not even a single pipe is active in XVE",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x30:0xa8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x50" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_BUSY", "XVE Busy",
            "Any XVE thread loaded.",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x34:0xa9" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x58" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 0 UGT" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "1" ) );

        metric = AddMetric( "XVE_THREADS_OCCUPANCY_ALL", "XVE Threads Occupancy All",
            "Percentage of thread slots occupied",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_2 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_FLOAT, "percent", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "8 rd40@0x34:0xa9 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "8 qw@0x58 FMUL $VectorEngineThreadsCount FDIV" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "EuAggrDurationSlice" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );
        MD_CHECK_CC( metric->SetMaxValueEquation( "100" ) );

        metric = AddMetric( "XVE_COMPUTE_THREAD_COUNT", "XVE Compute Thread Count",
            "Number of compute shader hardware threads dispatched",
            "VectorEngine", ( METRIC_GROUP_NAME_ID_EU_ARRAY * 0x1000000 ), USAGE_FLAG_TIER_3 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "threads", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "rd40@0x20:0xa4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x30" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 40" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0223fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0ee4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15e41908, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0323fffc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e40008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05e40c00, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0fe4034e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11e402cc, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13e4024a, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e40000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e50001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03e55554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01e6fe01, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c20001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c25554, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c30003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000feff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd48, 0x000f0000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc00, 0x0004000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc04, 0x00007ffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc08, 0x0002000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc0c, 0x0000bffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc10, 0x0001000a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc14, 0x0000dffe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc18, 0x0000800a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc1c, 0x0000effe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc20, 0x0000400a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc24, 0x0000f7fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc28, 0x0000200a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc2c, 0x0000fbfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc30, 0x0000100a, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc34, 0x0000fdfe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc38, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc3c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe458, 0x00005004, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xe558, 0x00000008, REGISTER_TYPE_FLEX ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CTestOaMetricSet::CTestOaMetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CTestOaMetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "Counter0", "TestCounter0",
            "HW test counter 0. Factor: 0.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter1", "TestCounter1",
            "HW test counter 1. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter2", "TestCounter2",
            "HW test counter 2. Factor: 1.0",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter3", "TestCounter3",
            "HW test counter 3. Factor: 0.5",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter4", "TestCounter4",
            "HW test counter 4. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter5", "TestCounter5",
            "HW test counter 5. Factor: 0.3333",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter6", "TestCounter6",
            "HW test counter 6. Factor: 0.16666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter7", "TestCounter7",
            "HW test counter 7. Factor: 0.6666",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "Counter8", "TestCounter8",
            "HW test counter 8. Should be equal to 1 in IOStream or in OAG query mode",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "events", 0, 0, HW_UNIT_GPU, nullptr, nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000008, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x3b410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x33400001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x07410006, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f410cc0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x4f410000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03040002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x0000000c, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00500100, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x30500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x32500000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0xf0800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd940, 0x00000004, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd944, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd948, 0x00000003, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd94c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd950, 0x00000007, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd954, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd958, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd95c, 0x0000fff7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd960, 0x00100002, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd964, 0x0000ffcf, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd968, 0x00100082, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd96c, 0x0000ffef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd970, 0x001000c2, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd974, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd978, 0x00100001, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd97c, 0x0000ffe7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport1MetricSet::CDataport1MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport1MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE0", "Dataport Byte Read Xecore0",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE1", "Dataport Byte Read Xecore1",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE2", "Dataport Byte Read Xecore2",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE3", "Dataport Byte Read Xecore3",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE4", "Dataport Byte Read Xecore4",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE5", "Dataport Byte Read Xecore5",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE6", "Dataport Byte Read Xecore6",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE7", "Dataport Byte Read Xecore7",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE0", "Dataport Byte Write Xecore0",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE1", "Dataport Byte Write Xecore1",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE2", "Dataport Byte Write Xecore2",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE3", "Dataport Byte Write Xecore3",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE4", "Dataport Byte Write Xecore4",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE5", "Dataport Byte Write Xecore5",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE6", "Dataport Byte Write Xecore6",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE7", "Dataport Byte Write Xecore7",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice0XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00fe, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport2MetricSet::CDataport2MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport2MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE8", "Dataport Byte Read Xecore8",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE9", "Dataport Byte Read Xecore9",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE10", "Dataport Byte Read Xecore10",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE11", "Dataport Byte Read Xecore11",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE12", "Dataport Byte Read Xecore12",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE13", "Dataport Byte Read Xecore13",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE14", "Dataport Byte Read Xecore14",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE15", "Dataport Byte Read Xecore15",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE8", "Dataport Byte Write Xecore8",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE9", "Dataport Byte Write Xecore9",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE10", "Dataport Byte Write Xecore10",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE11", "Dataport Byte Write Xecore11",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE12", "Dataport Byte Write Xecore12",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE13", "Dataport Byte Write Xecore13",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE14", "Dataport Byte Write Xecore14",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE15", "Dataport Byte Write Xecore15",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice1XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00fd, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport3MetricSet::CDataport3MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport3MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE16", "Dataport Byte Read Xecore16",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE17", "Dataport Byte Read Xecore17",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE18", "Dataport Byte Read Xecore18",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE19", "Dataport Byte Read Xecore19",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE20", "Dataport Byte Read Xecore20",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE21", "Dataport Byte Read Xecore21",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE22", "Dataport Byte Read Xecore22",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE23", "Dataport Byte Read Xecore23",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE16", "Dataport Byte Write Xecore16",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE17", "Dataport Byte Write Xecore17",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE18", "Dataport Byte Write Xecore18",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE19", "Dataport Byte Write Xecore19",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE20", "Dataport Byte Write Xecore20",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE21", "Dataport Byte Write Xecore21",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE22", "Dataport Byte Write Xecore22",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE23", "Dataport Byte Write Xecore23",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice2XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00fb, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport4MetricSet::CDataport4MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport4MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE24", "Dataport Byte Read Xecore24",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE25", "Dataport Byte Read Xecore25",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE26", "Dataport Byte Read Xecore26",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE27", "Dataport Byte Read Xecore27",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE28", "Dataport Byte Read Xecore28",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE29", "Dataport Byte Read Xecore29",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE30", "Dataport Byte Read Xecore30",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE31", "Dataport Byte Read Xecore31",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE24", "Dataport Byte Write Xecore24",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE25", "Dataport Byte Write Xecore25",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE26", "Dataport Byte Write Xecore26",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE27", "Dataport Byte Write Xecore27",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE28", "Dataport Byte Write Xecore28",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE29", "Dataport Byte Write Xecore29",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE30", "Dataport Byte Write Xecore30",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE31", "Dataport Byte Write Xecore31",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice3XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00f7, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport5MetricSet::CDataport5MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport5MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE32", "Dataport Byte Read Xecore32",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE33", "Dataport Byte Read Xecore33",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE34", "Dataport Byte Read Xecore34",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE35", "Dataport Byte Read Xecore35",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE36", "Dataport Byte Read Xecore36",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE37", "Dataport Byte Read Xecore37",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE38", "Dataport Byte Read Xecore38",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE39", "Dataport Byte Read Xecore39",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE32", "Dataport Byte Write Xecore32",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE33", "Dataport Byte Write Xecore33",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE34", "Dataport Byte Write Xecore34",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE35", "Dataport Byte Write Xecore35",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE36", "Dataport Byte Write Xecore36",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE37", "Dataport Byte Write Xecore37",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE38", "Dataport Byte Write Xecore38",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE39", "Dataport Byte Write Xecore39",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice4XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x24c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00ef, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport6MetricSet::CDataport6MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport6MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE40", "Dataport Byte Read Xecore40",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE41", "Dataport Byte Read Xecore41",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE42", "Dataport Byte Read Xecore42",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE43", "Dataport Byte Read Xecore43",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE44", "Dataport Byte Read Xecore44",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE45", "Dataport Byte Read Xecore45",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE46", "Dataport Byte Read Xecore46",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE47", "Dataport Byte Read Xecore47",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE40", "Dataport Byte Write Xecore40",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE41", "Dataport Byte Write Xecore41",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE42", "Dataport Byte Write Xecore42",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE43", "Dataport Byte Write Xecore43",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE44", "Dataport Byte Write Xecore44",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE45", "Dataport Byte Write Xecore45",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE46", "Dataport Byte Write Xecore46",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE47", "Dataport Byte Write Xecore47",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice5XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0f3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1f3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x050b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x170b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x090b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x010b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x030b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x051b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0d1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x151b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x091b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x011b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x031b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x052b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0b2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x132b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x092b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x012b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x032b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x05330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x09330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x053b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x093b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x113b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x013b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x033b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x01c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x03c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x23c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000002, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x25c30001, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd900, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd904, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd910, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd914, 0x00800000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xd920, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdd40, 0x00000000, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x2b2c, 0x0000ffff, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0xdc48, 0x00ff00df, REGISTER_TYPE_OA ) );
        MD_CHECK_CC( RefreshConfigRegisters() );

        return CC_OK;

    exception:
        return CC_ERROR_GENERAL;
    }

    CDataport7MetricSet::CDataport7MetricSet( CMetricsDevice& device, CConcurrentGroup* concurrentGroup, const char* symbolicName, const char* shortName, uint32_t apiMask, uint32_t category, uint32_t snapshotReportSize, uint32_t deltaReportSize, TReportType reportType, TByteArrayLatest* platformMask, uint32_t gtMask /*= GT_TYPE_ALL*/, bool isCustom /*= false*/ )
        : CMetricSet( device, concurrentGroup, symbolicName, shortName, apiMask, category, snapshotReportSize, deltaReportSize, reportType, platformMask, gtMask, isCustom )
    {
    }

    TCompletionCode CDataport7MetricSet::Initialize()
    {
        CMetric* metric           = nullptr;
        m_params.InformationCount = m_concurrentGroup->GetInformationCount();
        MD_CHECK_CC( SetApiSpecificId( "GPAV", 0, 0x40000000, 0x80000203, 0, 0, "Intel Performance Counters for GT Set Dynamic", 0, "Intel_Raw_Hardware_Counters_Set_0_Query", 0 ) );

        metric = AddMetric( "GpuTime", "GPU Time Elapsed",
            "Time elapsed on the GPU during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_DURATION, RESULT_UINT64, "ns", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 0 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x04 1000000000 UMUL $GpuTimestampFrequency UDIV" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x00" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "NS_TIME" ) );

        metric = AddMetric( "GpuCoreClocks", "GPU Core Clocks",
            "The total number of GPU core clocks elapsed during the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "cycles", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 1 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0x0c" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x08" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "AvgGpuCoreFrequencyMHz", "AVG GPU Core Frequency",
            "Average GPU Core Frequency in the measurement.",
            "GPU", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_TIER_1 | USAGE_FLAG_OVERVIEW | USAGE_FLAG_SYSTEM | USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_EVENT, RESULT_UINT64, "MHz", 0, 0, HW_UNIT_GPU, nullptr, nullptr, "oa.fixed", 2 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$GpuCoreClocks 1000 UMUL $$GpuTime UDIV" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE48", "Dataport Byte Read Xecore48",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore0", nullptr, nullptr, 3 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xfc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE49", "Dataport Byte Read Xecore49",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore1", nullptr, nullptr, 4 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1b0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE50", "Dataport Byte Read Xecore50",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore2", nullptr, nullptr, 5 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a8" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE51", "Dataport Byte Read Xecore51",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore3", nullptr, nullptr, 6 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xf0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x1a0" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE52", "Dataport Byte Read Xecore52",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore4", nullptr, nullptr, 7 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xec" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x198" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE53", "Dataport Byte Read Xecore53",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore5", nullptr, nullptr, 8 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x190" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE54", "Dataport Byte Read Xecore54",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore6", nullptr, nullptr, 9 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x188" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_READ_XECORE55", "Dataport Byte Read Xecore55",
            "Number of bytes read through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore7", nullptr, nullptr, 10 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xe0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x180" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 64 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE48", "Dataport Byte Write Xecore48",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore0", nullptr, nullptr, 11 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xdc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x178" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE49", "Dataport Byte Write Xecore49",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore1", nullptr, nullptr, 12 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x170" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE50", "Dataport Byte Write Xecore50",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore2", nullptr, nullptr, 13 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x168" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE51", "Dataport Byte Write Xecore51",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore3", nullptr, nullptr, 14 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xd0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x160" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE52", "Dataport Byte Write Xecore52",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore4", nullptr, nullptr, 15 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xcc" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x158" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE53", "Dataport Byte Write Xecore53",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore5", nullptr, nullptr, 16 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc8" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x150" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE54", "Dataport Byte Write Xecore54",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore6", nullptr, nullptr, 17 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc4" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x148" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        metric = AddMetric( "DATAPORT_BYTE_WRITE_XECORE55", "Dataport Byte Write Xecore55",
            "Number of bytes written through the Dataport",
            "Dataport", ( METRIC_GROUP_NAME_ID_GPU * 0x1000000 ), USAGE_FLAG_FRAME | USAGE_FLAG_BATCH | USAGE_FLAG_DRAW, API_TYPE_DX9 | API_TYPE_DX10 | API_TYPE_DX11 | API_TYPE_DX12 | API_TYPE_VULKAN | API_TYPE_OGL | API_TYPE_OGL4_X | API_TYPE_OCL | API_TYPE_IOSTREAM,
            METRIC_TYPE_THROUGHPUT, RESULT_UINT64, "bytes", 0, 0, HW_UNIT_GPU, "$GtSlice6XeCore7", nullptr, nullptr, 18 );
        MD_CHECK_PTR( metric );
        MD_CHECK_CC( metric->SetSnapshotReportReadEquation( "dw@0xc0" ) );
        MD_CHECK_CC( metric->SetDeltaReportReadEquation( "qw@0x140" ) );
        MD_CHECK_CC( metric->SetNormalizationEquation( "$Self 32 UMUL" ) );
        MD_CHECK_CC( metric->SetSnapshotReportDeltaFunction( "DELTA 32" ) );

        MD_CHECK_CC( AddStartRegisterSet( 0, 0, nullptr ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x0d04, 0x00000200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000003, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e037540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e0b7015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e0b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e137000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e1b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e1b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e237000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e2b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e2b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e337000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3303a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0e3b7000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1e3b03a0, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04030200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16030780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02030000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x040b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x160b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x080b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x000b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x020b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04130200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c130540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14130780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02130000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x041b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0c1b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x141b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x081b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x001b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x021b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04230200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a230540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12230780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02230000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x042b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x0a2b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x122b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x082b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x002b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x022b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x04330200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x08330540, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10330780, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02330000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x043b0200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x083b0015, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x103b001e, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x003b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x023b0000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c06000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c1f600, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c2ff60, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x00c336ca, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x02c314db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x22c336db, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30180, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec33000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30800, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30200, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9884, 0x00000000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30843, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30043, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30422, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1cc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1dc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ec30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1fc30183, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x14c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x15c30204, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x12c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x13c30840, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x10c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x11c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30040, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x16c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x17c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30420, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30400, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x19c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1ac30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x1bc30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_CC( AddStartConfigRegister( 0x9888, 0x18c30000, REGISTER_TYPE_NOA ) );
        MD_CHECK_C