/* Copyright (c) 2000, 2023, Oracle and/or its affiliates.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License, version 2.0,
   as published by the Free Software Foundation.

   This program is also distributed with certain software (including
   but not limited to OpenSSL) that is licensed under separate terms,
   as designated in a particular file or component or in included license
   documentation.  The authors of MySQL hereby grant you an additional
   permission to link the program and your derivative works with the
   separately licensed software that they have included with MySQL.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License, version 2.0, for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA */

#ifndef SQL_RANGE_OPTIMIZER_PARTITION_PRUNING_H_
#define SQL_RANGE_OPTIMIZER_PARTITION_PRUNING_H_

/*
  PartitionPruningModule
  A module that accepts a partitioned table, condition, and finds which
  partitions we will need to use in query execution. Search down for
  "PartitionPruningModule" for description.
  The module has single entry point - prune_partitions() function.
 */

class Item;
class Query_block;
class THD;
struct TABLE;

bool prune_partitions(THD *thd, TABLE *table, Query_block *query_block,
                      Item *pprune_cond);

#endif  // SQL_RANGE_OPTIMIZER_PARTITION_PRUNING_H_
