#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 855
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 127
#define ALIAS_COUNT 0
#define TOKEN_COUNT 66
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 4
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 12

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_COLON_COLON = 2,
  sym_unescaped_double_string_fragment = 3,
  sym_escape_sequence = 4,
  anon_sym_DQUOTE = 5,
  sym_comment = 6,
  anon_sym_DASH_GT = 7,
  anon_sym_LPAREN = 8,
  anon_sym_COMMA = 9,
  anon_sym_RPAREN = 10,
  anon_sym_EQ_GT = 11,
  anon_sym_LBRACK = 12,
  anon_sym_RBRACK = 13,
  anon_sym_PIPE = 14,
  anon_sym_LBRACE = 15,
  anon_sym_COLON = 16,
  anon_sym_RBRACE = 17,
  anon_sym_module = 18,
  anon_sym_const = 19,
  anon_sym_assume = 20,
  anon_sym_EQ = 21,
  anon_sym_var = 22,
  anon_sym_pure = 23,
  anon_sym_val = 24,
  anon_sym_def = 25,
  anon_sym_action = 26,
  anon_sym_temporal = 27,
  anon_sym_nondet = 28,
  anon_sym_run = 29,
  anon_sym_SEMI = 30,
  anon_sym_type = 31,
  anon_sym_import = 32,
  anon_sym_DOT = 33,
  anon_sym_as = 34,
  anon_sym_from = 35,
  anon_sym_STAR = 36,
  anon_sym_export = 37,
  anon_sym_Bool = 38,
  anon_sym_Int = 39,
  anon_sym_Nat = 40,
  anon_sym_true = 41,
  anon_sym_false = 42,
  sym_int_literal = 43,
  anon_sym_DASH = 44,
  anon_sym_CARET = 45,
  anon_sym_SLASH = 46,
  anon_sym_PERCENT = 47,
  anon_sym_PLUS = 48,
  anon_sym_LT = 49,
  anon_sym_GT = 50,
  anon_sym_GT_EQ = 51,
  anon_sym_LT_EQ = 52,
  anon_sym_EQ_EQ = 53,
  anon_sym_BANG_EQ = 54,
  anon_sym_SQUOTE = 55,
  anon_sym_and = 56,
  anon_sym_or = 57,
  anon_sym_iff = 58,
  anon_sym_implies = 59,
  anon_sym_all = 60,
  anon_sym_any = 61,
  anon_sym_if = 62,
  anon_sym_else = 63,
  anon_sym_DOT_DOT_DOT = 64,
  anon_sym_match = 65,
  sym_source_file = 66,
  sym_qualified_identifier = 67,
  sym_string = 68,
  sym_type = 69,
  sym_function_type = 70,
  sym_operator_type = 71,
  sym_polymorphic_type = 72,
  sym_variant_constructor = 73,
  sym_sum_type = 74,
  sym_record_type = 75,
  sym_tuple_type = 76,
  sym_module_definition = 77,
  sym_constant_declaration = 78,
  sym_assumption = 79,
  sym_variable_definition = 80,
  sym_typed_argument_list = 81,
  sym_operator_definition = 82,
  sym_type_alias = 83,
  sym_import = 84,
  sym_import_segment_arguments = 85,
  sym_import_segment = 86,
  sym_export = 87,
  sym_expr = 88,
  sym_well_known_set = 89,
  sym_bool_literal = 90,
  sym_lambda_expr = 91,
  sym_operator_application = 92,
  sym_list_access = 93,
  sym_unary_expr = 94,
  sym_ufcs_right_hand_side = 95,
  sym_binary_expr = 96,
  sym_infix_and = 97,
  sym_infix_or = 98,
  sym_infix_iff = 99,
  sym_infix_implies = 100,
  sym_braced_and = 101,
  sym_braced_or = 102,
  sym_braced_all = 103,
  sym_braced_any = 104,
  sym_if_else_condition = 105,
  sym_local_operator_definition = 106,
  sym_record_literal = 107,
  sym_tuple_literal = 108,
  sym_match_case = 109,
  sym_match_expr = 110,
  sym_list_literal = 111,
  aux_sym_source_file_repeat1 = 112,
  aux_sym_qualified_identifier_repeat1 = 113,
  aux_sym_string_repeat1 = 114,
  aux_sym_operator_type_repeat1 = 115,
  aux_sym_sum_type_repeat1 = 116,
  aux_sym_record_type_repeat1 = 117,
  aux_sym_module_definition_repeat1 = 118,
  aux_sym_typed_argument_list_repeat1 = 119,
  aux_sym_type_alias_repeat1 = 120,
  aux_sym_import_repeat1 = 121,
  aux_sym_import_segment_arguments_repeat1 = 122,
  aux_sym_export_repeat1 = 123,
  aux_sym_lambda_expr_repeat1 = 124,
  aux_sym_record_literal_repeat1 = 125,
  aux_sym_match_expr_repeat1 = 126,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_COLON_COLON] = "::",
  [sym_unescaped_double_string_fragment] = "string_fragment",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_DQUOTE] = "\"",
  [sym_comment] = "comment",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_PIPE] = "|",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COLON] = ":",
  [anon_sym_RBRACE] = "}",
  [anon_sym_module] = "module",
  [anon_sym_const] = "const",
  [anon_sym_assume] = "assume",
  [anon_sym_EQ] = "=",
  [anon_sym_var] = "var",
  [anon_sym_pure] = "pure",
  [anon_sym_val] = "val",
  [anon_sym_def] = "def",
  [anon_sym_action] = "action",
  [anon_sym_temporal] = "temporal",
  [anon_sym_nondet] = "nondet",
  [anon_sym_run] = "run",
  [anon_sym_SEMI] = ";",
  [anon_sym_type] = "type",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_as] = "as",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_export] = "export",
  [anon_sym_Bool] = "Bool",
  [anon_sym_Int] = "Int",
  [anon_sym_Nat] = "Nat",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_int_literal] = "int_literal",
  [anon_sym_DASH] = "-",
  [anon_sym_CARET] = "^",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_iff] = "iff",
  [anon_sym_implies] = "implies",
  [anon_sym_all] = "all",
  [anon_sym_any] = "any",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_match] = "match",
  [sym_source_file] = "source_file",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_string] = "string",
  [sym_type] = "type",
  [sym_function_type] = "function_type",
  [sym_operator_type] = "operator_type",
  [sym_polymorphic_type] = "polymorphic_type",
  [sym_variant_constructor] = "variant_constructor",
  [sym_sum_type] = "sum_type",
  [sym_record_type] = "record_type",
  [sym_tuple_type] = "tuple_type",
  [sym_module_definition] = "module_definition",
  [sym_constant_declaration] = "constant_declaration",
  [sym_assumption] = "assumption",
  [sym_variable_definition] = "variable_definition",
  [sym_typed_argument_list] = "typed_argument_list",
  [sym_operator_definition] = "operator_definition",
  [sym_type_alias] = "type_alias",
  [sym_import] = "import",
  [sym_import_segment_arguments] = "import_segment_arguments",
  [sym_import_segment] = "import_segment",
  [sym_export] = "export",
  [sym_expr] = "expr",
  [sym_well_known_set] = "well_known_set",
  [sym_bool_literal] = "bool_literal",
  [sym_lambda_expr] = "lambda_expr",
  [sym_operator_application] = "operator_application",
  [sym_list_access] = "list_access",
  [sym_unary_expr] = "unary_expr",
  [sym_ufcs_right_hand_side] = "ufcs_right_hand_side",
  [sym_binary_expr] = "binary_expr",
  [sym_infix_and] = "infix_and",
  [sym_infix_or] = "infix_or",
  [sym_infix_iff] = "infix_iff",
  [sym_infix_implies] = "infix_implies",
  [sym_braced_and] = "braced_and",
  [sym_braced_or] = "braced_or",
  [sym_braced_all] = "braced_all",
  [sym_braced_any] = "braced_any",
  [sym_if_else_condition] = "if_else_condition",
  [sym_local_operator_definition] = "local_operator_definition",
  [sym_record_literal] = "record_literal",
  [sym_tuple_literal] = "tuple_literal",
  [sym_match_case] = "match_case",
  [sym_match_expr] = "match_expr",
  [sym_list_literal] = "list_literal",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_qualified_identifier_repeat1] = "qualified_identifier_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_operator_type_repeat1] = "operator_type_repeat1",
  [aux_sym_sum_type_repeat1] = "sum_type_repeat1",
  [aux_sym_record_type_repeat1] = "record_type_repeat1",
  [aux_sym_module_definition_repeat1] = "module_definition_repeat1",
  [aux_sym_typed_argument_list_repeat1] = "typed_argument_list_repeat1",
  [aux_sym_type_alias_repeat1] = "type_alias_repeat1",
  [aux_sym_import_repeat1] = "import_repeat1",
  [aux_sym_import_segment_arguments_repeat1] = "import_segment_arguments_repeat1",
  [aux_sym_export_repeat1] = "export_repeat1",
  [aux_sym_lambda_expr_repeat1] = "lambda_expr_repeat1",
  [aux_sym_record_literal_repeat1] = "record_literal_repeat1",
  [aux_sym_match_expr_repeat1] = "match_expr_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [sym_unescaped_double_string_fragment] = sym_unescaped_double_string_fragment,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [sym_comment] = sym_comment,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_assume] = anon_sym_assume,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_val] = anon_sym_val,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_action] = anon_sym_action,
  [anon_sym_temporal] = anon_sym_temporal,
  [anon_sym_nondet] = anon_sym_nondet,
  [anon_sym_run] = anon_sym_run,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_Bool] = anon_sym_Bool,
  [anon_sym_Int] = anon_sym_Int,
  [anon_sym_Nat] = anon_sym_Nat,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_int_literal] = sym_int_literal,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_iff] = anon_sym_iff,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_all] = anon_sym_all,
  [anon_sym_any] = anon_sym_any,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_match] = anon_sym_match,
  [sym_source_file] = sym_source_file,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_string] = sym_string,
  [sym_type] = sym_type,
  [sym_function_type] = sym_function_type,
  [sym_operator_type] = sym_operator_type,
  [sym_polymorphic_type] = sym_polymorphic_type,
  [sym_variant_constructor] = sym_variant_constructor,
  [sym_sum_type] = sym_sum_type,
  [sym_record_type] = sym_record_type,
  [sym_tuple_type] = sym_tuple_type,
  [sym_module_definition] = sym_module_definition,
  [sym_constant_declaration] = sym_constant_declaration,
  [sym_assumption] = sym_assumption,
  [sym_variable_definition] = sym_variable_definition,
  [sym_typed_argument_list] = sym_typed_argument_list,
  [sym_operator_definition] = sym_operator_definition,
  [sym_type_alias] = sym_type_alias,
  [sym_import] = sym_import,
  [sym_import_segment_arguments] = sym_import_segment_arguments,
  [sym_import_segment] = sym_import_segment,
  [sym_export] = sym_export,
  [sym_expr] = sym_expr,
  [sym_well_known_set] = sym_well_known_set,
  [sym_bool_literal] = sym_bool_literal,
  [sym_lambda_expr] = sym_lambda_expr,
  [sym_operator_application] = sym_operator_application,
  [sym_list_access] = sym_list_access,
  [sym_unary_expr] = sym_unary_expr,
  [sym_ufcs_right_hand_side] = sym_ufcs_right_hand_side,
  [sym_binary_expr] = sym_binary_expr,
  [sym_infix_and] = sym_infix_and,
  [sym_infix_or] = sym_infix_or,
  [sym_infix_iff] = sym_infix_iff,
  [sym_infix_implies] = sym_infix_implies,
  [sym_braced_and] = sym_braced_and,
  [sym_braced_or] = sym_braced_or,
  [sym_braced_all] = sym_braced_all,
  [sym_braced_any] = sym_braced_any,
  [sym_if_else_condition] = sym_if_else_condition,
  [sym_local_operator_definition] = sym_local_operator_definition,
  [sym_record_literal] = sym_record_literal,
  [sym_tuple_literal] = sym_tuple_literal,
  [sym_match_case] = sym_match_case,
  [sym_match_expr] = sym_match_expr,
  [sym_list_literal] = sym_list_literal,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_qualified_identifier_repeat1] = aux_sym_qualified_identifier_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_operator_type_repeat1] = aux_sym_operator_type_repeat1,
  [aux_sym_sum_type_repeat1] = aux_sym_sum_type_repeat1,
  [aux_sym_record_type_repeat1] = aux_sym_record_type_repeat1,
  [aux_sym_module_definition_repeat1] = aux_sym_module_definition_repeat1,
  [aux_sym_typed_argument_list_repeat1] = aux_sym_typed_argument_list_repeat1,
  [aux_sym_type_alias_repeat1] = aux_sym_type_alias_repeat1,
  [aux_sym_import_repeat1] = aux_sym_import_repeat1,
  [aux_sym_import_segment_arguments_repeat1] = aux_sym_import_segment_arguments_repeat1,
  [aux_sym_export_repeat1] = aux_sym_export_repeat1,
  [aux_sym_lambda_expr_repeat1] = aux_sym_lambda_expr_repeat1,
  [aux_sym_record_literal_repeat1] = aux_sym_record_literal_repeat1,
  [aux_sym_match_expr_repeat1] = aux_sym_match_expr_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_unescaped_double_string_fragment] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assume] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_val] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_action] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_temporal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nondet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_run] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nat] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_all] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_any] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_function_type] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_type] = {
    .visible = true,
    .named = true,
  },
  [sym_polymorphic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_variant_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_sum_type] = {
    .visible = true,
    .named = true,
  },
  [sym_record_type] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_module_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_assumption] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_segment_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_import_segment] = {
    .visible = true,
    .named = true,
  },
  [sym_export] = {
    .visible = true,
    .named = true,
  },
  [sym_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_well_known_set] = {
    .visible = true,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_operator_application] = {
    .visible = true,
    .named = true,
  },
  [sym_list_access] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_ufcs_right_hand_side] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_and] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_or] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_iff] = {
    .visible = true,
    .named = true,
  },
  [sym_infix_implies] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_and] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_or] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_all] = {
    .visible = true,
    .named = true,
  },
  [sym_braced_any] = {
    .visible = true,
    .named = true,
  },
  [sym_if_else_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_local_operator_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_record_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_match_case] = {
    .visible = true,
    .named = true,
  },
  [sym_match_expr] = {
    .visible = true,
    .named = true,
  },
  [sym_list_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_qualified_identifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_operator_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sum_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_typed_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_alias_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_segment_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_export_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_lambda_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_record_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_expr_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_arguments = 1,
  field_name = 2,
  field_operator = 3,
  field_rhs = 4,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_arguments] = "arguments",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_rhs] = "rhs",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 2},
  [3] = {.index = 4, .length = 3},
  [4] = {.index = 7, .length = 3},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 2},
  [7] = {.index = 15, .length = 4},
  [8] = {.index = 19, .length = 2},
  [9] = {.index = 21, .length = 3},
  [10] = {.index = 24, .length = 5},
  [11] = {.index = 29, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 1},
    {field_rhs, 3},
  [2] =
    {field_name, 2},
    {field_rhs, 4},
  [4] =
    {field_arguments, 2},
    {field_name, 1},
    {field_rhs, 4},
  [7] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_operator, 0},
  [10] =
    {field_arguments, 3},
    {field_name, 2},
    {field_rhs, 5},
  [13] =
    {field_name, 1},
    {field_rhs, 5},
  [15] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
    {field_operator, 0},
  [19] =
    {field_name, 2},
    {field_rhs, 6},
  [21] =
    {field_arguments, 2},
    {field_name, 1},
    {field_rhs, 6},
  [24] =
    {field_arguments, 1},
    {field_arguments, 2},
    {field_arguments, 3},
    {field_arguments, 4},
    {field_operator, 0},
  [29] =
    {field_arguments, 3},
    {field_name, 2},
    {field_rhs, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 2,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 2,
  [15] = 8,
  [16] = 16,
  [17] = 10,
  [18] = 18,
  [19] = 11,
  [20] = 16,
  [21] = 13,
  [22] = 12,
  [23] = 23,
  [24] = 3,
  [25] = 4,
  [26] = 5,
  [27] = 6,
  [28] = 7,
  [29] = 29,
  [30] = 30,
  [31] = 18,
  [32] = 8,
  [33] = 10,
  [34] = 30,
  [35] = 18,
  [36] = 11,
  [37] = 23,
  [38] = 16,
  [39] = 13,
  [40] = 12,
  [41] = 23,
  [42] = 29,
  [43] = 3,
  [44] = 4,
  [45] = 5,
  [46] = 6,
  [47] = 7,
  [48] = 29,
  [49] = 30,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 56,
  [60] = 56,
  [61] = 58,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 50,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 63,
  [74] = 74,
  [75] = 66,
  [76] = 76,
  [77] = 77,
  [78] = 55,
  [79] = 79,
  [80] = 53,
  [81] = 81,
  [82] = 82,
  [83] = 57,
  [84] = 51,
  [85] = 85,
  [86] = 70,
  [87] = 55,
  [88] = 57,
  [89] = 81,
  [90] = 81,
  [91] = 82,
  [92] = 54,
  [93] = 93,
  [94] = 93,
  [95] = 62,
  [96] = 96,
  [97] = 67,
  [98] = 98,
  [99] = 99,
  [100] = 74,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 64,
  [106] = 106,
  [107] = 107,
  [108] = 85,
  [109] = 109,
  [110] = 52,
  [111] = 51,
  [112] = 74,
  [113] = 67,
  [114] = 62,
  [115] = 115,
  [116] = 109,
  [117] = 50,
  [118] = 82,
  [119] = 66,
  [120] = 63,
  [121] = 96,
  [122] = 98,
  [123] = 109,
  [124] = 99,
  [125] = 107,
  [126] = 85,
  [127] = 52,
  [128] = 64,
  [129] = 76,
  [130] = 76,
  [131] = 68,
  [132] = 107,
  [133] = 68,
  [134] = 70,
  [135] = 93,
  [136] = 54,
  [137] = 106,
  [138] = 96,
  [139] = 98,
  [140] = 99,
  [141] = 101,
  [142] = 104,
  [143] = 102,
  [144] = 103,
  [145] = 104,
  [146] = 106,
  [147] = 103,
  [148] = 102,
  [149] = 101,
  [150] = 150,
  [151] = 151,
  [152] = 150,
  [153] = 151,
  [154] = 154,
  [155] = 154,
  [156] = 150,
  [157] = 157,
  [158] = 151,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 159,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 186,
  [188] = 188,
  [189] = 157,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 160,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 166,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 165,
  [234] = 188,
  [235] = 202,
  [236] = 219,
  [237] = 205,
  [238] = 201,
  [239] = 206,
  [240] = 207,
  [241] = 209,
  [242] = 210,
  [243] = 211,
  [244] = 212,
  [245] = 169,
  [246] = 213,
  [247] = 170,
  [248] = 171,
  [249] = 218,
  [250] = 217,
  [251] = 174,
  [252] = 176,
  [253] = 164,
  [254] = 168,
  [255] = 232,
  [256] = 231,
  [257] = 230,
  [258] = 229,
  [259] = 161,
  [260] = 175,
  [261] = 216,
  [262] = 198,
  [263] = 167,
  [264] = 197,
  [265] = 196,
  [266] = 163,
  [267] = 195,
  [268] = 194,
  [269] = 193,
  [270] = 228,
  [271] = 192,
  [272] = 191,
  [273] = 227,
  [274] = 223,
  [275] = 177,
  [276] = 221,
  [277] = 204,
  [278] = 190,
  [279] = 220,
  [280] = 226,
  [281] = 222,
  [282] = 185,
  [283] = 184,
  [284] = 225,
  [285] = 183,
  [286] = 182,
  [287] = 181,
  [288] = 179,
  [289] = 178,
  [290] = 154,
  [291] = 166,
  [292] = 186,
  [293] = 159,
  [294] = 160,
  [295] = 157,
  [296] = 219,
  [297] = 231,
  [298] = 214,
  [299] = 178,
  [300] = 174,
  [301] = 215,
  [302] = 179,
  [303] = 216,
  [304] = 217,
  [305] = 192,
  [306] = 193,
  [307] = 218,
  [308] = 194,
  [309] = 176,
  [310] = 200,
  [311] = 220,
  [312] = 181,
  [313] = 221,
  [314] = 201,
  [315] = 195,
  [316] = 182,
  [317] = 183,
  [318] = 165,
  [319] = 167,
  [320] = 222,
  [321] = 171,
  [322] = 223,
  [323] = 196,
  [324] = 224,
  [325] = 170,
  [326] = 169,
  [327] = 212,
  [328] = 202,
  [329] = 197,
  [330] = 164,
  [331] = 184,
  [332] = 175,
  [333] = 211,
  [334] = 185,
  [335] = 198,
  [336] = 210,
  [337] = 162,
  [338] = 225,
  [339] = 209,
  [340] = 199,
  [341] = 226,
  [342] = 207,
  [343] = 188,
  [344] = 227,
  [345] = 228,
  [346] = 161,
  [347] = 229,
  [348] = 206,
  [349] = 230,
  [350] = 204,
  [351] = 163,
  [352] = 191,
  [353] = 205,
  [354] = 177,
  [355] = 168,
  [356] = 232,
  [357] = 173,
  [358] = 172,
  [359] = 190,
  [360] = 213,
  [361] = 361,
  [362] = 215,
  [363] = 224,
  [364] = 200,
  [365] = 199,
  [366] = 162,
  [367] = 173,
  [368] = 172,
  [369] = 214,
  [370] = 361,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 386,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 384,
  [396] = 386,
  [397] = 394,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 388,
  [404] = 400,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 406,
  [409] = 392,
  [410] = 401,
  [411] = 394,
  [412] = 412,
  [413] = 385,
  [414] = 401,
  [415] = 388,
  [416] = 407,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 400,
  [422] = 406,
  [423] = 423,
  [424] = 407,
  [425] = 384,
  [426] = 392,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 436,
  [438] = 436,
  [439] = 439,
  [440] = 439,
  [441] = 434,
  [442] = 442,
  [443] = 443,
  [444] = 443,
  [445] = 445,
  [446] = 439,
  [447] = 443,
  [448] = 448,
  [449] = 448,
  [450] = 434,
  [451] = 448,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 442,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 445,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 452,
  [473] = 453,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 454,
  [481] = 481,
  [482] = 455,
  [483] = 457,
  [484] = 484,
  [485] = 464,
  [486] = 486,
  [487] = 459,
  [488] = 463,
  [489] = 458,
  [490] = 462,
  [491] = 382,
  [492] = 460,
  [493] = 465,
  [494] = 494,
  [495] = 470,
  [496] = 379,
  [497] = 380,
  [498] = 393,
  [499] = 391,
  [500] = 500,
  [501] = 387,
  [502] = 378,
  [503] = 468,
  [504] = 376,
  [505] = 476,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 471,
  [510] = 510,
  [511] = 398,
  [512] = 477,
  [513] = 513,
  [514] = 514,
  [515] = 417,
  [516] = 466,
  [517] = 423,
  [518] = 383,
  [519] = 374,
  [520] = 377,
  [521] = 418,
  [522] = 419,
  [523] = 412,
  [524] = 375,
  [525] = 479,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 467,
  [530] = 478,
  [531] = 469,
  [532] = 532,
  [533] = 373,
  [534] = 402,
  [535] = 420,
  [536] = 474,
  [537] = 475,
  [538] = 389,
  [539] = 405,
  [540] = 399,
  [541] = 484,
  [542] = 481,
  [543] = 486,
  [544] = 494,
  [545] = 545,
  [546] = 378,
  [547] = 545,
  [548] = 375,
  [549] = 549,
  [550] = 507,
  [551] = 514,
  [552] = 552,
  [553] = 513,
  [554] = 374,
  [555] = 380,
  [556] = 379,
  [557] = 377,
  [558] = 510,
  [559] = 527,
  [560] = 506,
  [561] = 549,
  [562] = 373,
  [563] = 500,
  [564] = 526,
  [565] = 552,
  [566] = 376,
  [567] = 528,
  [568] = 568,
  [569] = 568,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 572,
  [579] = 577,
  [580] = 580,
  [581] = 581,
  [582] = 576,
  [583] = 583,
  [584] = 570,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 581,
  [590] = 587,
  [591] = 571,
  [592] = 583,
  [593] = 580,
  [594] = 577,
  [595] = 583,
  [596] = 596,
  [597] = 597,
  [598] = 588,
  [599] = 599,
  [600] = 585,
  [601] = 596,
  [602] = 573,
  [603] = 575,
  [604] = 580,
  [605] = 596,
  [606] = 606,
  [607] = 606,
  [608] = 606,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 611,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 614,
  [622] = 616,
  [623] = 617,
  [624] = 618,
  [625] = 620,
  [626] = 615,
  [627] = 619,
  [628] = 613,
  [629] = 629,
  [630] = 620,
  [631] = 616,
  [632] = 611,
  [633] = 613,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 635,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 644,
  [646] = 646,
  [647] = 647,
  [648] = 636,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 638,
  [654] = 644,
  [655] = 638,
  [656] = 642,
  [657] = 639,
  [658] = 646,
  [659] = 635,
  [660] = 637,
  [661] = 661,
  [662] = 662,
  [663] = 651,
  [664] = 650,
  [665] = 665,
  [666] = 666,
  [667] = 662,
  [668] = 646,
  [669] = 649,
  [670] = 647,
  [671] = 650,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 682,
  [683] = 683,
  [684] = 684,
  [685] = 685,
  [686] = 681,
  [687] = 687,
  [688] = 680,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 681,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 697,
  [700] = 684,
  [701] = 701,
  [702] = 679,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 696,
  [712] = 712,
  [713] = 713,
  [714] = 712,
  [715] = 715,
  [716] = 716,
  [717] = 709,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 706,
  [723] = 695,
  [724] = 705,
  [725] = 725,
  [726] = 683,
  [727] = 678,
  [728] = 698,
  [729] = 687,
  [730] = 698,
  [731] = 673,
  [732] = 674,
  [733] = 725,
  [734] = 682,
  [735] = 735,
  [736] = 736,
  [737] = 690,
  [738] = 738,
  [739] = 708,
  [740] = 694,
  [741] = 685,
  [742] = 676,
  [743] = 743,
  [744] = 744,
  [745] = 736,
  [746] = 689,
  [747] = 747,
  [748] = 701,
  [749] = 725,
  [750] = 689,
  [751] = 721,
  [752] = 720,
  [753] = 674,
  [754] = 713,
  [755] = 683,
  [756] = 696,
  [757] = 697,
  [758] = 701,
  [759] = 679,
  [760] = 703,
  [761] = 721,
  [762] = 719,
  [763] = 763,
  [764] = 718,
  [765] = 703,
  [766] = 716,
  [767] = 707,
  [768] = 707,
  [769] = 736,
  [770] = 713,
  [771] = 715,
  [772] = 720,
  [773] = 715,
  [774] = 719,
  [775] = 716,
  [776] = 708,
  [777] = 718,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 780,
  [786] = 783,
  [787] = 778,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 778,
  [794] = 794,
  [795] = 794,
  [796] = 784,
  [797] = 783,
  [798] = 792,
  [799] = 799,
  [800] = 799,
  [801] = 784,
  [802] = 802,
  [803] = 802,
  [804] = 804,
  [805] = 805,
  [806] = 782,
  [807] = 807,
  [808] = 792,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 818,
  [821] = 821,
  [822] = 822,
  [823] = 822,
  [824] = 815,
  [825] = 814,
  [826] = 826,
  [827] = 822,
  [828] = 828,
  [829] = 829,
  [830] = 829,
  [831] = 816,
  [832] = 826,
  [833] = 826,
  [834] = 834,
  [835] = 814,
  [836] = 815,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 812,
  [841] = 841,
  [842] = 842,
  [843] = 813,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 839,
  [848] = 846,
  [849] = 811,
  [850] = 816,
  [851] = 842,
  [852] = 852,
  [853] = 837,
  [854] = 837,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(117);
      ADVANCE_MAP(
        '!', 12,
        '"', 183,
        '%', 243,
        '\'', 251,
        '(', 187,
        ')', 189,
        '*', 225,
        '+', 244,
        ',', 188,
        '-', 240,
        '.', 222,
        '/', 242,
        '0', 239,
        ':', 196,
        ';', 218,
        '<', 245,
        '=', 201,
        '>', 246,
        'B', 67,
        'I', 59,
        'N', 16,
        '[', 191,
        '\\', 98,
        ']', 192,
        '^', 241,
        'a', 21,
        'c', 65,
        'd', 28,
        'e', 47,
        'f', 17,
        'i', 40,
        'm', 18,
        'n', 68,
        'o', 79,
        'p', 99,
        'r', 101,
        't', 29,
        'v', 15,
        '{', 194,
        '|', 193,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(113);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 12,
        '"', 183,
        '%', 243,
        '\'', 251,
        '(', 187,
        '*', 225,
        '+', 244,
        '-', 240,
        '.', 221,
        '/', 242,
        '0', 239,
        ':', 11,
        ';', 218,
        '<', 245,
        '=', 13,
        '>', 246,
        'B', 152,
        'I', 147,
        'N', 118,
        '[', 191,
        '^', 241,
        'a', 124,
        'd', 131,
        'f', 119,
        'i', 136,
        'm', 121,
        'n', 151,
        'o', 158,
        'p', 168,
        'r', 169,
        't', 127,
        'v', 120,
        '{', 194,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(1);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(238);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 183,
        '(', 187,
        ')', 189,
        '-', 240,
        '.', 9,
        '/', 6,
        '0', 239,
        ':', 195,
        '=', 202,
        'B', 152,
        'I', 147,
        'N', 118,
        '[', 191,
        ']', 192,
        'a', 124,
        'd', 131,
        'f', 119,
        'i', 134,
        'm', 121,
        'n', 151,
        'o', 158,
        'p', 168,
        'r', 169,
        't', 127,
        'v', 120,
        '{', 194,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(238);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(183);
      if (lookahead == '/') ADVANCE(6);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(183);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\\') ADVANCE(98);
      if (lookahead == '\n' ||
          lookahead == '\r') SKIP(3);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ') ADVANCE(176);
      if (lookahead != 0) ADVANCE(178);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '(', 187,
        ')', 189,
        '*', 225,
        '.', 9,
        '/', 6,
        '{', 194,
        '|', 193,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 6:
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(185);
      END_STATE();
    case 7:
      if (lookahead == '*') ADVANCE(7);
      if (lookahead == '/') ADVANCE(184);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 8:
      if (lookahead == '*') ADVANCE(7);
      if (lookahead != 0) ADVANCE(8);
      END_STATE();
    case 9:
      if (lookahead == '.') ADVANCE(10);
      END_STATE();
    case 10:
      if (lookahead == '.') ADVANCE(268);
      END_STATE();
    case 11:
      if (lookahead == ':') ADVANCE(172);
      END_STATE();
    case 12:
      if (lookahead == '=') ADVANCE(250);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(249);
      if (lookahead == '>') ADVANCE(190);
      END_STATE();
    case 14:
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(49);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(91);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(93);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(51);
      END_STATE();
    case 20:
      if (lookahead == 'c') ADVANCE(44);
      END_STATE();
    case 21:
      if (lookahead == 'c') ADVANCE(92);
      if (lookahead == 'l') ADVANCE(48);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 22:
      if (lookahead == 'c') ADVANCE(92);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 's') ADVANCE(223);
      END_STATE();
    case 23:
      if (lookahead == 'c') ADVANCE(92);
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 24:
      if (lookahead == 'd') ADVANCE(252);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(252);
      if (lookahead == 'y') ADVANCE(262);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(103);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(39);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(41);
      END_STATE();
    case 29:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'r') ADVANCE(102);
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'y') ADVANCE(76);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(267);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(204);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 34:
      if (lookahead == 'e') ADVANCE(219);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(200);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(97);
      END_STATE();
    case 40:
      if (lookahead == 'f') ADVANCE(264);
      if (lookahead == 'm') ADVANCE(74);
      END_STATE();
    case 41:
      if (lookahead == 'f') ADVANCE(208);
      END_STATE();
    case 42:
      if (lookahead == 'f') ADVANCE(256);
      END_STATE();
    case 43:
      if (lookahead == 'f') ADVANCE(42);
      if (lookahead == 'm') ADVANCE(74);
      END_STATE();
    case 44:
      if (lookahead == 'h') ADVANCE(269);
      END_STATE();
    case 45:
      if (lookahead == 'i') ADVANCE(38);
      END_STATE();
    case 46:
      if (lookahead == 'i') ADVANCE(72);
      END_STATE();
    case 47:
      if (lookahead == 'l') ADVANCE(86);
      if (lookahead == 'x') ADVANCE(75);
      END_STATE();
    case 48:
      if (lookahead == 'l') ADVANCE(260);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(206);
      if (lookahead == 'r') ADVANCE(203);
      END_STATE();
    case 50:
      if (lookahead == 'l') ADVANCE(227);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(212);
      END_STATE();
    case 52:
      if (lookahead == 'l') ADVANCE(45);
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 53:
      if (lookahead == 'l') ADVANCE(37);
      END_STATE();
    case 54:
      if (lookahead == 'l') ADVANCE(89);
      END_STATE();
    case 55:
      if (lookahead == 'm') ADVANCE(224);
      END_STATE();
    case 56:
      if (lookahead == 'm') ADVANCE(36);
      END_STATE();
    case 57:
      if (lookahead == 'm') ADVANCE(77);
      END_STATE();
    case 58:
      if (lookahead == 'm') ADVANCE(78);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(90);
      END_STATE();
    case 60:
      if (lookahead == 'n') ADVANCE(216);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(210);
      END_STATE();
    case 62:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 63:
      if (lookahead == 'n') ADVANCE(27);
      END_STATE();
    case 64:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 65:
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 66:
      if (lookahead == 'o') ADVANCE(55);
      END_STATE();
    case 67:
      if (lookahead == 'o') ADVANCE(70);
      END_STATE();
    case 68:
      if (lookahead == 'o') ADVANCE(63);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(83);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(50);
      END_STATE();
    case 71:
      if (lookahead == 'o') ADVANCE(80);
      END_STATE();
    case 72:
      if (lookahead == 'o') ADVANCE(61);
      END_STATE();
    case 73:
      if (lookahead == 'o') ADVANCE(84);
      END_STATE();
    case 74:
      if (lookahead == 'p') ADVANCE(52);
      END_STATE();
    case 75:
      if (lookahead == 'p') ADVANCE(69);
      END_STATE();
    case 76:
      if (lookahead == 'p') ADVANCE(34);
      END_STATE();
    case 77:
      if (lookahead == 'p') ADVANCE(71);
      END_STATE();
    case 78:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 79:
      if (lookahead == 'r') ADVANCE(254);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(19);
      END_STATE();
    case 81:
      if (lookahead == 'r') ADVANCE(32);
      END_STATE();
    case 82:
      if (lookahead == 'r') ADVANCE(66);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 84:
      if (lookahead == 'r') ADVANCE(96);
      END_STATE();
    case 85:
      if (lookahead == 's') ADVANCE(258);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(31);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 88:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 89:
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 91:
      if (lookahead == 't') ADVANCE(231);
      END_STATE();
    case 92:
      if (lookahead == 't') ADVANCE(46);
      END_STATE();
    case 93:
      if (lookahead == 't') ADVANCE(20);
      END_STATE();
    case 94:
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(226);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(220);
      END_STATE();
    case 97:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 98:
      if (lookahead == 'u') ADVANCE(105);
      if (lookahead == 'x') ADVANCE(112);
      if (lookahead == '\r' ||
          lookahead == '?') ADVANCE(180);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(182);
      if (lookahead != 0) ADVANCE(179);
      END_STATE();
    case 99:
      if (lookahead == 'u') ADVANCE(81);
      END_STATE();
    case 100:
      if (lookahead == 'u') ADVANCE(56);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 102:
      if (lookahead == 'u') ADVANCE(33);
      END_STATE();
    case 103:
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 104:
      if (lookahead == 'x') ADVANCE(75);
      END_STATE();
    case 105:
      if (lookahead == '{') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(111);
      END_STATE();
    case 106:
      if (lookahead == '}') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 107:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 108:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      END_STATE();
    case 109:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(237);
      END_STATE();
    case 110:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(106);
      END_STATE();
    case 111:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(112);
      END_STATE();
    case 112:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(108);
      END_STATE();
    case 113:
      if (eof) ADVANCE(117);
      ADVANCE_MAP(
        '!', 12,
        '"', 183,
        '%', 243,
        '\'', 251,
        '(', 187,
        ')', 189,
        '*', 225,
        '+', 244,
        ',', 188,
        '-', 240,
        '.', 222,
        '/', 242,
        '0', 239,
        ':', 196,
        ';', 218,
        '<', 245,
        '=', 201,
        '>', 246,
        'B', 67,
        'I', 59,
        'N', 16,
        '[', 191,
        ']', 192,
        '^', 241,
        'a', 21,
        'c', 65,
        'd', 28,
        'e', 47,
        'f', 17,
        'i', 40,
        'm', 18,
        'n', 68,
        'o', 79,
        'p', 99,
        'r', 101,
        't', 29,
        'v', 15,
        '{', 194,
        '|', 193,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(113);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 114:
      if (eof) ADVANCE(117);
      ADVANCE_MAP(
        '!', 12,
        '"', 183,
        '%', 243,
        '\'', 251,
        '(', 187,
        ')', 189,
        '*', 225,
        '+', 244,
        ',', 188,
        '-', 240,
        '.', 221,
        '/', 242,
        ':', 196,
        ';', 218,
        '<', 245,
        '=', 201,
        '>', 246,
        '[', 191,
        ']', 192,
        '^', 241,
        'a', 22,
        'c', 65,
        'd', 28,
        'e', 104,
        'f', 82,
        'i', 43,
        'm', 64,
        'n', 68,
        'o', 79,
        'p', 99,
        'r', 101,
        't', 30,
        'v', 15,
        '{', 194,
        '|', 193,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(114);
      END_STATE();
    case 115:
      if (eof) ADVANCE(117);
      ADVANCE_MAP(
        '!', 12,
        '"', 183,
        '%', 243,
        '\'', 251,
        '(', 187,
        ')', 189,
        '*', 225,
        '+', 244,
        ',', 188,
        '-', 240,
        '.', 221,
        '/', 242,
        ':', 196,
        ';', 218,
        '<', 245,
        '=', 13,
        '>', 246,
        '[', 191,
        ']', 192,
        '^', 241,
        'a', 22,
        'c', 65,
        'd', 28,
        'e', 47,
        'f', 82,
        'i', 43,
        'm', 64,
        'n', 68,
        'o', 79,
        'p', 99,
        'r', 101,
        't', 30,
        'v', 15,
        '{', 194,
        '|', 193,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(115);
      END_STATE();
    case 116:
      if (eof) ADVANCE(117);
      ADVANCE_MAP(
        '"', 183,
        ')', 189,
        ',', 188,
        '-', 14,
        '/', 6,
        '=', 202,
        '[', 191,
        ']', 192,
        'a', 23,
        'c', 65,
        'd', 28,
        'e', 104,
        'i', 58,
        'm', 64,
        'n', 68,
        'p', 99,
        'r', 101,
        't', 30,
        'v', 15,
        '}', 197,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(116);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(164);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(166);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(165);
      if (lookahead == 'l') ADVANCE(140);
      if (lookahead == 'n') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(253);
      if (lookahead == 'y') ADVANCE(263);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'd') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(146);
      if (lookahead == 'r') ADVANCE(170);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(205);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(234);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(236);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(161);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(167);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(266);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(209);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'f') ADVANCE(265);
      if (lookahead == 'm') ADVANCE(157);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'h') ADVANCE(270);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(154);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(261);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(162);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(207);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(228);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(213);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'm') ADVANCE(156);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(163);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(217);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(211);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(155);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(160);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(150);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(153);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'p') ADVANCE(145);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(255);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(259);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(230);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(232);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(215);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(159);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(175);
      if (lookahead == '/') ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead == '/') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '*') ADVANCE(174);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(175);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == '/') ADVANCE(173);
      if (lookahead == '\t' ||
          lookahead == 0x0b ||
          lookahead == '\f' ||
          lookahead == ' ') ADVANCE(176);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(177);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_unescaped_double_string_fragment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(178);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n' ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(179);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(179);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(181);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r' &&
          lookahead != 0x2028 &&
          lookahead != 0x2029) ADVANCE(185);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(172);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_assume);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(249);
      if (lookahead == '>') ADVANCE(190);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '>') ADVANCE(190);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_pure);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_val);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_val);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_def);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_action);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_action);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_temporal);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_temporal);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_nondet);
      END_STATE();
    case 215:
      ACCEPT_TOKEN(anon_sym_nondet);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 216:
      ACCEPT_TOKEN(anon_sym_run);
      END_STATE();
    case 217:
      ACCEPT_TOKEN(anon_sym_run);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 218:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 219:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 220:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 222:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(10);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 224:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 226:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_Bool);
      END_STATE();
    case 228:
      ACCEPT_TOKEN(anon_sym_Bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 229:
      ACCEPT_TOKEN(anon_sym_Int);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_Int);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 231:
      ACCEPT_TOKEN(anon_sym_Nat);
      END_STATE();
    case 232:
      ACCEPT_TOKEN(anon_sym_Nat);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_true);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 235:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 236:
      ACCEPT_TOKEN(anon_sym_false);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 237:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(237);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == '_') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 239:
      ACCEPT_TOKEN(sym_int_literal);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(109);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(238);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(186);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(8);
      if (lookahead == '/') ADVANCE(185);
      END_STATE();
    case 243:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 245:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(248);
      END_STATE();
    case 246:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(247);
      END_STATE();
    case 247:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 248:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 251:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 252:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_and);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_or);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 256:
      ACCEPT_TOKEN(anon_sym_iff);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_iff);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 258:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_implies);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 260:
      ACCEPT_TOKEN(anon_sym_all);
      END_STATE();
    case 261:
      ACCEPT_TOKEN(anon_sym_all);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_any);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_any);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == 'f') ADVANCE(256);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_if);
      if (lookahead == 'f') ADVANCE(257);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 266:
      ACCEPT_TOKEN(anon_sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    case 267:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 270:
      ACCEPT_TOKEN(anon_sym_match);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(171);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 0},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 2},
  [4] = {.lex_state = 2},
  [5] = {.lex_state = 2},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 2},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 2},
  [13] = {.lex_state = 2},
  [14] = {.lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 2},
  [28] = {.lex_state = 2},
  [29] = {.lex_state = 2},
  [30] = {.lex_state = 2},
  [31] = {.lex_state = 2},
  [32] = {.lex_state = 2},
  [33] = {.lex_state = 2},
  [34] = {.lex_state = 2},
  [35] = {.lex_state = 2},
  [36] = {.lex_state = 2},
  [37] = {.lex_state = 2},
  [38] = {.lex_state = 2},
  [39] = {.lex_state = 2},
  [40] = {.lex_state = 2},
  [41] = {.lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 2},
  [44] = {.lex_state = 2},
  [45] = {.lex_state = 2},
  [46] = {.lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 2},
  [49] = {.lex_state = 2},
  [50] = {.lex_state = 2},
  [51] = {.lex_state = 2},
  [52] = {.lex_state = 2},
  [53] = {.lex_state = 2},
  [54] = {.lex_state = 2},
  [55] = {.lex_state = 2},
  [56] = {.lex_state = 2},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 2},
  [59] = {.lex_state = 2},
  [60] = {.lex_state = 2},
  [61] = {.lex_state = 2},
  [62] = {.lex_state = 2},
  [63] = {.lex_state = 2},
  [64] = {.lex_state = 2},
  [65] = {.lex_state = 2},
  [66] = {.lex_state = 2},
  [67] = {.lex_state = 2},
  [68] = {.lex_state = 2},
  [69] = {.lex_state = 2},
  [70] = {.lex_state = 2},
  [71] = {.lex_state = 2},
  [72] = {.lex_state = 2},
  [73] = {.lex_state = 2},
  [74] = {.lex_state = 2},
  [75] = {.lex_state = 2},
  [76] = {.lex_state = 2},
  [77] = {.lex_state = 2},
  [78] = {.lex_state = 2},
  [79] = {.lex_state = 2},
  [80] = {.lex_state = 2},
  [81] = {.lex_state = 2},
  [82] = {.lex_state = 2},
  [83] = {.lex_state = 2},
  [84] = {.lex_state = 2},
  [85] = {.lex_state = 2},
  [86] = {.lex_state = 2},
  [87] = {.lex_state = 2},
  [88] = {.lex_state = 2},
  [89] = {.lex_state = 2},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 2},
  [108] = {.lex_state = 2},
  [109] = {.lex_state = 2},
  [110] = {.lex_state = 2},
  [111] = {.lex_state = 2},
  [112] = {.lex_state = 2},
  [113] = {.lex_state = 2},
  [114] = {.lex_state = 2},
  [115] = {.lex_state = 2},
  [116] = {.lex_state = 2},
  [117] = {.lex_state = 2},
  [118] = {.lex_state = 2},
  [119] = {.lex_state = 2},
  [120] = {.lex_state = 2},
  [121] = {.lex_state = 2},
  [122] = {.lex_state = 2},
  [123] = {.lex_state = 2},
  [124] = {.lex_state = 2},
  [125] = {.lex_state = 2},
  [126] = {.lex_state = 2},
  [127] = {.lex_state = 2},
  [128] = {.lex_state = 2},
  [129] = {.lex_state = 2},
  [130] = {.lex_state = 2},
  [131] = {.lex_state = 2},
  [132] = {.lex_state = 2},
  [133] = {.lex_state = 2},
  [134] = {.lex_state = 2},
  [135] = {.lex_state = 2},
  [136] = {.lex_state = 2},
  [137] = {.lex_state = 2},
  [138] = {.lex_state = 2},
  [139] = {.lex_state = 2},
  [140] = {.lex_state = 2},
  [141] = {.lex_state = 2},
  [142] = {.lex_state = 2},
  [143] = {.lex_state = 2},
  [144] = {.lex_state = 2},
  [145] = {.lex_state = 2},
  [146] = {.lex_state = 2},
  [147] = {.lex_state = 2},
  [148] = {.lex_state = 2},
  [149] = {.lex_state = 2},
  [150] = {.lex_state = 114},
  [151] = {.lex_state = 114},
  [152] = {.lex_state = 115},
  [153] = {.lex_state = 115},
  [154] = {.lex_state = 115},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 1},
  [158] = {.lex_state = 1},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 1},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 1},
  [164] = {.lex_state = 1},
  [165] = {.lex_state = 1},
  [166] = {.lex_state = 1},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 1},
  [169] = {.lex_state = 1},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 1},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 1},
  [174] = {.lex_state = 1},
  [175] = {.lex_state = 1},
  [176] = {.lex_state = 1},
  [177] = {.lex_state = 1},
  [178] = {.lex_state = 1},
  [179] = {.lex_state = 1},
  [180] = {.lex_state = 115},
  [181] = {.lex_state = 1},
  [182] = {.lex_state = 1},
  [183] = {.lex_state = 1},
  [184] = {.lex_state = 1},
  [185] = {.lex_state = 1},
  [186] = {.lex_state = 1},
  [187] = {.lex_state = 115},
  [188] = {.lex_state = 1},
  [189] = {.lex_state = 115},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 1},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 1},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 1},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 1},
  [200] = {.lex_state = 1},
  [201] = {.lex_state = 1},
  [202] = {.lex_state = 1},
  [203] = {.lex_state = 115},
  [204] = {.lex_state = 1},
  [205] = {.lex_state = 1},
  [206] = {.lex_state = 1},
  [207] = {.lex_state = 1},
  [208] = {.lex_state = 115},
  [209] = {.lex_state = 1},
  [210] = {.lex_state = 1},
  [211] = {.lex_state = 1},
  [212] = {.lex_state = 1},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 1},
  [215] = {.lex_state = 1},
  [216] = {.lex_state = 1},
  [217] = {.lex_state = 1},
  [218] = {.lex_state = 1},
  [219] = {.lex_state = 1},
  [220] = {.lex_state = 1},
  [221] = {.lex_state = 1},
  [222] = {.lex_state = 1},
  [223] = {.lex_state = 1},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 1},
  [226] = {.lex_state = 1},
  [227] = {.lex_state = 1},
  [228] = {.lex_state = 1},
  [229] = {.lex_state = 1},
  [230] = {.lex_state = 1},
  [231] = {.lex_state = 1},
  [232] = {.lex_state = 1},
  [233] = {.lex_state = 115},
  [234] = {.lex_state = 115},
  [235] = {.lex_state = 115},
  [236] = {.lex_state = 115},
  [237] = {.lex_state = 115},
  [238] = {.lex_state = 115},
  [239] = {.lex_state = 115},
  [240] = {.lex_state = 115},
  [241] = {.lex_state = 115},
  [242] = {.lex_state = 115},
  [243] = {.lex_state = 115},
  [244] = {.lex_state = 115},
  [245] = {.lex_state = 115},
  [246] = {.lex_state = 115},
  [247] = {.lex_state = 115},
  [248] = {.lex_state = 115},
  [249] = {.lex_state = 115},
  [250] = {.lex_state = 115},
  [251] = {.lex_state = 115},
  [252] = {.lex_state = 115},
  [253] = {.lex_state = 115},
  [254] = {.lex_state = 115},
  [255] = {.lex_state = 115},
  [256] = {.lex_state = 115},
  [257] = {.lex_state = 115},
  [258] = {.lex_state = 115},
  [259] = {.lex_state = 115},
  [260] = {.lex_state = 115},
  [261] = {.lex_state = 115},
  [262] = {.lex_state = 115},
  [263] = {.lex_state = 115},
  [264] = {.lex_state = 115},
  [265] = {.lex_state = 115},
  [266] = {.lex_state = 115},
  [267] = {.lex_state = 115},
  [268] = {.lex_state = 115},
  [269] = {.lex_state = 115},
  [270] = {.lex_state = 115},
  [271] = {.lex_state = 115},
  [272] = {.lex_state = 115},
  [273] = {.lex_state = 115},
  [274] = {.lex_state = 115},
  [275] = {.lex_state = 115},
  [276] = {.lex_state = 115},
  [277] = {.lex_state = 115},
  [278] = {.lex_state = 115},
  [279] = {.lex_state = 115},
  [280] = {.lex_state = 115},
  [281] = {.lex_state = 115},
  [282] = {.lex_state = 115},
  [283] = {.lex_state = 115},
  [284] = {.lex_state = 115},
  [285] = {.lex_state = 115},
  [286] = {.lex_state = 115},
  [287] = {.lex_state = 115},
  [288] = {.lex_state = 115},
  [289] = {.lex_state = 115},
  [290] = {.lex_state = 115},
  [291] = {.lex_state = 115},
  [292] = {.lex_state = 115},
  [293] = {.lex_state = 115},
  [294] = {.lex_state = 115},
  [295] = {.lex_state = 115},
  [296] = {.lex_state = 115},
  [297] = {.lex_state = 115},
  [298] = {.lex_state = 115},
  [299] = {.lex_state = 115},
  [300] = {.lex_state = 115},
  [301] = {.lex_state = 115},
  [302] = {.lex_state = 115},
  [303] = {.lex_state = 115},
  [304] = {.lex_state = 115},
  [305] = {.lex_state = 115},
  [306] = {.lex_state = 115},
  [307] = {.lex_state = 115},
  [308] = {.lex_state = 115},
  [309] = {.lex_state = 115},
  [310] = {.lex_state = 115},
  [311] = {.lex_state = 115},
  [312] = {.lex_state = 115},
  [313] = {.lex_state = 115},
  [314] = {.lex_state = 115},
  [315] = {.lex_state = 115},
  [316] = {.lex_state = 115},
  [317] = {.lex_state = 115},
  [318] = {.lex_state = 115},
  [319] = {.lex_state = 115},
  [320] = {.lex_state = 115},
  [321] = {.lex_state = 115},
  [322] = {.lex_state = 115},
  [323] = {.lex_state = 115},
  [324] = {.lex_state = 115},
  [325] = {.lex_state = 115},
  [326] = {.lex_state = 115},
  [327] = {.lex_state = 115},
  [328] = {.lex_state = 115},
  [329] = {.lex_state = 115},
  [330] = {.lex_state = 115},
  [331] = {.lex_state = 115},
  [332] = {.lex_state = 115},
  [333] = {.lex_state = 115},
  [334] = {.lex_state = 115},
  [335] = {.lex_state = 115},
  [336] = {.lex_state = 115},
  [337] = {.lex_state = 115},
  [338] = {.lex_state = 115},
  [339] = {.lex_state = 115},
  [340] = {.lex_state = 115},
  [341] = {.lex_state = 115},
  [342] = {.lex_state = 115},
  [343] = {.lex_state = 115},
  [344] = {.lex_state = 115},
  [345] = {.lex_state = 115},
  [346] = {.lex_state = 115},
  [347] = {.lex_state = 115},
  [348] = {.lex_state = 115},
  [349] = {.lex_state = 115},
  [350] = {.lex_state = 115},
  [351] = {.lex_state = 115},
  [352] = {.lex_state = 115},
  [353] = {.lex_state = 115},
  [354] = {.lex_state = 115},
  [355] = {.lex_state = 115},
  [356] = {.lex_state = 115},
  [357] = {.lex_state = 115},
  [358] = {.lex_state = 115},
  [359] = {.lex_state = 115},
  [360] = {.lex_state = 115},
  [361] = {.lex_state = 115},
  [362] = {.lex_state = 115},
  [363] = {.lex_state = 115},
  [364] = {.lex_state = 115},
  [365] = {.lex_state = 115},
  [366] = {.lex_state = 115},
  [367] = {.lex_state = 115},
  [368] = {.lex_state = 115},
  [369] = {.lex_state = 115},
  [370] = {.lex_state = 115},
  [371] = {.lex_state = 0},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 2},
  [374] = {.lex_state = 2},
  [375] = {.lex_state = 2},
  [376] = {.lex_state = 2},
  [377] = {.lex_state = 2},
  [378] = {.lex_state = 2},
  [379] = {.lex_state = 2},
  [380] = {.lex_state = 2},
  [381] = {.lex_state = 115},
  [382] = {.lex_state = 116},
  [383] = {.lex_state = 116},
  [384] = {.lex_state = 115},
  [385] = {.lex_state = 115},
  [386] = {.lex_state = 115},
  [387] = {.lex_state = 116},
  [388] = {.lex_state = 115},
  [389] = {.lex_state = 116},
  [390] = {.lex_state = 115},
  [391] = {.lex_state = 116},
  [392] = {.lex_state = 115},
  [393] = {.lex_state = 116},
  [394] = {.lex_state = 115},
  [395] = {.lex_state = 115},
  [396] = {.lex_state = 115},
  [397] = {.lex_state = 115},
  [398] = {.lex_state = 116},
  [399] = {.lex_state = 116},
  [400] = {.lex_state = 115},
  [401] = {.lex_state = 115},
  [402] = {.lex_state = 116},
  [403] = {.lex_state = 115},
  [404] = {.lex_state = 115},
  [405] = {.lex_state = 116},
  [406] = {.lex_state = 115},
  [407] = {.lex_state = 115},
  [408] = {.lex_state = 115},
  [409] = {.lex_state = 115},
  [410] = {.lex_state = 115},
  [411] = {.lex_state = 115},
  [412] = {.lex_state = 116},
  [413] = {.lex_state = 115},
  [414] = {.lex_state = 115},
  [415] = {.lex_state = 115},
  [416] = {.lex_state = 115},
  [417] = {.lex_state = 116},
  [418] = {.lex_state = 116},
  [419] = {.lex_state = 116},
  [420] = {.lex_state = 116},
  [421] = {.lex_state = 115},
  [422] = {.lex_state = 115},
  [423] = {.lex_state = 116},
  [424] = {.lex_state = 115},
  [425] = {.lex_state = 115},
  [426] = {.lex_state = 115},
  [427] = {.lex_state = 0},
  [428] = {.lex_state = 115},
  [429] = {.lex_state = 0},
  [430] = {.lex_state = 115},
  [431] = {.lex_state = 115},
  [432] = {.lex_state = 0},
  [433] = {.lex_state = 115},
  [434] = {.lex_state = 115},
  [435] = {.lex_state = 115},
  [436] = {.lex_state = 115},
  [437] = {.lex_state = 115},
  [438] = {.lex_state = 115},
  [439] = {.lex_state = 115},
  [440] = {.lex_state = 115},
  [441] = {.lex_state = 115},
  [442] = {.lex_state = 114},
  [443] = {.lex_state = 115},
  [444] = {.lex_state = 115},
  [445] = {.lex_state = 0},
  [446] = {.lex_state = 115},
  [447] = {.lex_state = 115},
  [448] = {.lex_state = 115},
  [449] = {.lex_state = 115},
  [450] = {.lex_state = 115},
  [451] = {.lex_state = 115},
  [452] = {.lex_state = 114},
  [453] = {.lex_state = 114},
  [454] = {.lex_state = 114},
  [455] = {.lex_state = 114},
  [456] = {.lex_state = 114},
  [457] = {.lex_state = 114},
  [458] = {.lex_state = 114},
  [459] = {.lex_state = 114},
  [460] = {.lex_state = 114},
  [461] = {.lex_state = 0},
  [462] = {.lex_state = 114},
  [463] = {.lex_state = 114},
  [464] = {.lex_state = 114},
  [465] = {.lex_state = 114},
  [466] = {.lex_state = 0},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 0},
  [469] = {.lex_state = 0},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 0},
  [472] = {.lex_state = 114},
  [473] = {.lex_state = 114},
  [474] = {.lex_state = 0},
  [475] = {.lex_state = 0},
  [476] = {.lex_state = 0},
  [477] = {.lex_state = 0},
  [478] = {.lex_state = 114},
  [479] = {.lex_state = 0},
  [480] = {.lex_state = 114},
  [481] = {.lex_state = 0},
  [482] = {.lex_state = 114},
  [483] = {.lex_state = 114},
  [484] = {.lex_state = 0},
  [485] = {.lex_state = 114},
  [486] = {.lex_state = 0},
  [487] = {.lex_state = 114},
  [488] = {.lex_state = 114},
  [489] = {.lex_state = 114},
  [490] = {.lex_state = 114},
  [491] = {.lex_state = 0},
  [492] = {.lex_state = 114},
  [493] = {.lex_state = 114},
  [494] = {.lex_state = 0},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 0},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 0},
  [499] = {.lex_state = 0},
  [500] = {.lex_state = 0},
  [501] = {.lex_state = 0},
  [502] = {.lex_state = 0},
  [503] = {.lex_state = 0},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 0},
  [506] = {.lex_state = 0},
  [507] = {.lex_state = 0},
  [508] = {.lex_state = 0},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 0},
  [511] = {.lex_state = 0},
  [512] = {.lex_state = 0},
  [513] = {.lex_state = 0},
  [514] = {.lex_state = 0},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 0},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 0},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 0},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 0},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 0},
  [528] = {.lex_state = 0},
  [529] = {.lex_state = 0},
  [530] = {.lex_state = 114},
  [531] = {.lex_state = 0},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 0},
  [538] = {.lex_state = 0},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 0},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 5},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 5},
  [548] = {.lex_state = 0},
  [549] = {.lex_state = 5},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 5},
  [553] = {.lex_state = 0},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 0},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 0},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 5},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 5},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 0},
  [568] = {.lex_state = 5},
  [569] = {.lex_state = 5},
  [570] = {.lex_state = 5},
  [571] = {.lex_state = 5},
  [572] = {.lex_state = 5},
  [573] = {.lex_state = 5},
  [574] = {.lex_state = 5},
  [575] = {.lex_state = 5},
  [576] = {.lex_state = 5},
  [577] = {.lex_state = 5},
  [578] = {.lex_state = 5},
  [579] = {.lex_state = 5},
  [580] = {.lex_state = 5},
  [581] = {.lex_state = 5},
  [582] = {.lex_state = 5},
  [583] = {.lex_state = 5},
  [584] = {.lex_state = 5},
  [585] = {.lex_state = 5},
  [586] = {.lex_state = 5},
  [587] = {.lex_state = 5},
  [588] = {.lex_state = 5},
  [589] = {.lex_state = 5},
  [590] = {.lex_state = 5},
  [591] = {.lex_state = 5},
  [592] = {.lex_state = 5},
  [593] = {.lex_state = 5},
  [594] = {.lex_state = 5},
  [595] = {.lex_state = 5},
  [596] = {.lex_state = 5},
  [597] = {.lex_state = 5},
  [598] = {.lex_state = 5},
  [599] = {.lex_state = 5},
  [600] = {.lex_state = 5},
  [601] = {.lex_state = 5},
  [602] = {.lex_state = 5},
  [603] = {.lex_state = 5},
  [604] = {.lex_state = 5},
  [605] = {.lex_state = 5},
  [606] = {.lex_state = 5},
  [607] = {.lex_state = 5},
  [608] = {.lex_state = 5},
  [609] = {.lex_state = 0},
  [610] = {.lex_state = 0},
  [611] = {.lex_state = 5},
  [612] = {.lex_state = 5},
  [613] = {.lex_state = 5},
  [614] = {.lex_state = 0},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 5},
  [617] = {.lex_state = 5},
  [618] = {.lex_state = 0},
  [619] = {.lex_state = 5},
  [620] = {.lex_state = 5},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 5},
  [623] = {.lex_state = 5},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 5},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 5},
  [628] = {.lex_state = 5},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 5},
  [631] = {.lex_state = 5},
  [632] = {.lex_state = 5},
  [633] = {.lex_state = 5},
  [634] = {.lex_state = 4},
  [635] = {.lex_state = 5},
  [636] = {.lex_state = 5},
  [637] = {.lex_state = 5},
  [638] = {.lex_state = 4},
  [639] = {.lex_state = 5},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 5},
  [642] = {.lex_state = 5},
  [643] = {.lex_state = 5},
  [644] = {.lex_state = 2},
  [645] = {.lex_state = 2},
  [646] = {.lex_state = 4},
  [647] = {.lex_state = 5},
  [648] = {.lex_state = 5},
  [649] = {.lex_state = 5},
  [650] = {.lex_state = 2},
  [651] = {.lex_state = 5},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 4},
  [654] = {.lex_state = 2},
  [655] = {.lex_state = 4},
  [656] = {.lex_state = 5},
  [657] = {.lex_state = 5},
  [658] = {.lex_state = 4},
  [659] = {.lex_state = 5},
  [660] = {.lex_state = 5},
  [661] = {.lex_state = 5},
  [662] = {.lex_state = 5},
  [663] = {.lex_state = 5},
  [664] = {.lex_state = 2},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 5},
  [668] = {.lex_state = 4},
  [669] = {.lex_state = 5},
  [670] = {.lex_state = 5},
  [671] = {.lex_state = 2},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 5},
  [676] = {.lex_state = 5},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 5},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 5},
  [681] = {.lex_state = 5},
  [682] = {.lex_state = 5},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 5},
  [686] = {.lex_state = 5},
  [687] = {.lex_state = 5},
  [688] = {.lex_state = 5},
  [689] = {.lex_state = 2},
  [690] = {.lex_state = 5},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 5},
  [693] = {.lex_state = 5},
  [694] = {.lex_state = 5},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 2},
  [697] = {.lex_state = 2},
  [698] = {.lex_state = 5},
  [699] = {.lex_state = 2},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 2},
  [708] = {.lex_state = 5},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 5},
  [711] = {.lex_state = 2},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 5},
  [728] = {.lex_state = 5},
  [729] = {.lex_state = 5},
  [730] = {.lex_state = 5},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 5},
  [735] = {.lex_state = 5},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 5},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 5},
  [740] = {.lex_state = 5},
  [741] = {.lex_state = 5},
  [742] = {.lex_state = 5},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 2},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 0},
  [750] = {.lex_state = 2},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 2},
  [757] = {.lex_state = 2},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 2},
  [768] = {.lex_state = 2},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 5},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 2},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 2},
  [781] = {.lex_state = 2},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 5},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 2},
  [786] = {.lex_state = 5},
  [787] = {.lex_state = 2},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 2},
  [791] = {.lex_state = 2},
  [792] = {.lex_state = 2},
  [793] = {.lex_state = 2},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 5},
  [798] = {.lex_state = 2},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 2},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 2},
  [808] = {.lex_state = 2},
  [809] = {.lex_state = 5},
  [810] = {.lex_state = 5},
  [811] = {.lex_state = 2},
  [812] = {.lex_state = 5},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 2},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 2},
  [819] = {.lex_state = 5},
  [820] = {.lex_state = 2},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 0},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 5},
  [829] = {.lex_state = 2},
  [830] = {.lex_state = 2},
  [831] = {.lex_state = 2},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 2},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 5},
  [841] = {.lex_state = 0},
  [842] = {.lex_state = 2},
  [843] = {.lex_state = 0},
  [844] = {.lex_state = 5},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 0},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 2},
  [850] = {.lex_state = 2},
  [851] = {.lex_state = 2},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [sym_escape_sequence] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_assume] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_val] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_action] = ACTIONS(1),
    [anon_sym_temporal] = ACTIONS(1),
    [anon_sym_nondet] = ACTIONS(1),
    [anon_sym_run] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_Bool] = ACTIONS(1),
    [anon_sym_Int] = ACTIONS(1),
    [anon_sym_Nat] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_int_literal] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_iff] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_all] = ACTIONS(1),
    [anon_sym_any] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(817),
    [sym_string] = STATE(371),
    [sym_module_definition] = STATE(371),
    [sym_constant_declaration] = STATE(371),
    [sym_assumption] = STATE(371),
    [sym_variable_definition] = STATE(371),
    [sym_operator_definition] = STATE(371),
    [sym_type_alias] = STATE(371),
    [sym_import] = STATE(371),
    [sym_export] = STATE(371),
    [aux_sym_source_file_repeat1] = STATE(371),
    [ts_builtin_sym_end] = ACTIONS(5),
    [anon_sym_DQUOTE] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [anon_sym_module] = ACTIONS(9),
    [anon_sym_const] = ACTIONS(11),
    [anon_sym_assume] = ACTIONS(13),
    [anon_sym_var] = ACTIONS(15),
    [anon_sym_pure] = ACTIONS(17),
    [anon_sym_val] = ACTIONS(19),
    [anon_sym_def] = ACTIONS(19),
    [anon_sym_action] = ACTIONS(19),
    [anon_sym_temporal] = ACTIONS(19),
    [anon_sym_nondet] = ACTIONS(19),
    [anon_sym_run] = ACTIONS(19),
    [anon_sym_type] = ACTIONS(21),
    [anon_sym_import] = ACTIONS(23),
    [anon_sym_export] = ACTIONS(25),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(59), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(396), 1,
      sym_qualified_identifier,
    STATE(439), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [104] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(63), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(410), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [208] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(65), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(388), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [312] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(67), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(400), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [416] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(69), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(408), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [520] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(71), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(416), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [624] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(73), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [728] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(75), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(87), 1,
      sym_operator_definition,
    STATE(386), 1,
      sym_qualified_identifier,
    STATE(440), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [832] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(77), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [936] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(79), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1040] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1144] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(83), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1248] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(85), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(87), 1,
      sym_operator_definition,
    STATE(390), 1,
      sym_qualified_identifier,
    STATE(446), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1352] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(87), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1456] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1560] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(91), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1664] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(93), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1768] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(95), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1872] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(97), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [1976] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2080] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2184] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2288] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(401), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2392] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(107), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(403), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2496] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(109), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(404), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2600] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(111), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(406), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2704] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(407), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2808] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(115), 1,
      anon_sym_RBRACK,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(384), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [2912] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(409), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3016] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(119), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3120] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(121), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3224] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(123), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3328] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(392), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3432] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(127), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3536] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(129), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3640] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(131), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3744] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(133), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3848] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [3952] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4056] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4160] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(141), 1,
      anon_sym_RBRACK,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(395), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4264] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(414), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4368] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(145), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(415), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4472] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(147), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(421), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4576] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(149), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(422), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4680] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(151), 1,
      anon_sym_RBRACE,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(424), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4784] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(153), 1,
      anon_sym_RBRACK,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(425), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4888] = 25,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(426), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [4992] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(224), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5093] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(213), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5194] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(411), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5295] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(413), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5396] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(449), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5497] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(163), 1,
      sym_expr,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5598] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(162), 1,
      sym_expr,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5699] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(172), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5800] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(361), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [5901] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(337), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6002] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(366), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6103] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(370), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6204] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(303), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6305] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(232), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6406] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(434), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6507] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(324), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6608] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(338), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6709] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(301), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6810] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(437), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [6911] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(435), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7012] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(318), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7113] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(428), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7214] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(430), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7315] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(356), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7416] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(298), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7517] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(225), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7618] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(447), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7719] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(431), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7820] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(351), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [7921] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(433), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8022] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(385), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8123] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(173), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8224] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(175), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8325] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(358), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8426] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(360), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8527] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(310), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8628] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(233), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8729] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(266), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8830] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(368), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [8931] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(367), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9032] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(357), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9133] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(260), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9234] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(451), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9335] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(282), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9436] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(185), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9537] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(216), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9638] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(272), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9739] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(215), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9840] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(271), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [9941] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(269), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10042] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(214), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10143] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(268), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10244] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(267), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10345] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(265), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10446] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(264), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10547] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(441), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10648] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(262), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10749] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(365), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10850] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(364), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [10951] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(238), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11052] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(397), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11153] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(246), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11254] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(369), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11355] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(362), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11456] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(261), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11557] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11658] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(314), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11759] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(363), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11860] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(332), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [11961] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(284), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12062] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(255), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12163] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(191), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12264] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(192), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12365] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(201), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12466] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(193), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12567] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(340), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12668] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(200), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12769] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(394), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12870] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(450), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [12971] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(444), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13072] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(443), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13173] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(436), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13274] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(199), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13375] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(438), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13476] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(165), 1,
      sym_expr,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13577] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(334), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13678] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(27), 1,
      sym_identifier,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    ACTIONS(31), 1,
      anon_sym_LPAREN,
    ACTIONS(33), 1,
      anon_sym_LBRACK,
    ACTIONS(35), 1,
      anon_sym_LBRACE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(45), 1,
      sym_int_literal,
    ACTIONS(47), 1,
      anon_sym_DASH,
    ACTIONS(49), 1,
      anon_sym_and,
    ACTIONS(51), 1,
      anon_sym_or,
    ACTIONS(53), 1,
      anon_sym_all,
    ACTIONS(55), 1,
      anon_sym_any,
    ACTIONS(57), 1,
      anon_sym_if,
    ACTIONS(61), 1,
      anon_sym_match,
    STATE(87), 1,
      sym_operator_definition,
    STATE(208), 1,
      sym_qualified_identifier,
    STATE(448), 1,
      sym_expr,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(43), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(41), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(253), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(245), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13779] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(198), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13880] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(352), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [13981] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(305), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14082] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(306), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14183] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(308), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14284] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(197), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14385] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(315), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14486] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(323), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14587] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(329), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14688] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(187), 1,
      sym_identifier,
    ACTIONS(189), 1,
      anon_sym_LPAREN,
    ACTIONS(191), 1,
      anon_sym_LBRACK,
    ACTIONS(193), 1,
      anon_sym_LBRACE,
    ACTIONS(199), 1,
      sym_int_literal,
    ACTIONS(201), 1,
      anon_sym_DASH,
    ACTIONS(203), 1,
      anon_sym_and,
    ACTIONS(205), 1,
      anon_sym_or,
    ACTIONS(207), 1,
      anon_sym_all,
    ACTIONS(209), 1,
      anon_sym_any,
    ACTIONS(211), 1,
      anon_sym_if,
    ACTIONS(213), 1,
      anon_sym_match,
    STATE(78), 1,
      sym_operator_definition,
    STATE(291), 1,
      sym_qualified_identifier,
    STATE(335), 1,
      sym_expr,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(197), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(195), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(330), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(326), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14789] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(196), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14890] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(195), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [14991] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(37), 1,
      anon_sym_pure,
    ACTIONS(157), 1,
      sym_identifier,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_LPAREN,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_LBRACE,
    ACTIONS(171), 1,
      sym_int_literal,
    ACTIONS(173), 1,
      anon_sym_DASH,
    ACTIONS(175), 1,
      anon_sym_and,
    ACTIONS(177), 1,
      anon_sym_or,
    ACTIONS(179), 1,
      anon_sym_all,
    ACTIONS(181), 1,
      anon_sym_any,
    ACTIONS(183), 1,
      anon_sym_if,
    ACTIONS(185), 1,
      anon_sym_match,
    STATE(55), 1,
      sym_operator_definition,
    STATE(166), 1,
      sym_qualified_identifier,
    STATE(194), 1,
      sym_expr,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
    ACTIONS(169), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(167), 3,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
    STATE(164), 4,
      sym_infix_and,
      sym_infix_or,
      sym_infix_iff,
      sym_infix_implies,
    ACTIONS(39), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(169), 18,
      sym_string,
      sym_well_known_set,
      sym_bool_literal,
      sym_lambda_expr,
      sym_operator_application,
      sym_list_access,
      sym_unary_expr,
      sym_binary_expr,
      sym_braced_and,
      sym_braced_or,
      sym_braced_all,
      sym_braced_any,
      sym_if_else_condition,
      sym_local_operator_definition,
      sym_record_literal,
      sym_tuple_literal,
      sym_match_expr,
      sym_list_literal,
  [15092] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(219), 7,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(215), 42,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15152] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(223), 7,
      anon_sym_COLON,
      anon_sym_EQ,
      anon_sym_as,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(221), 42,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [15212] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(219), 6,
      anon_sym_COLON,
      anon_sym_as,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(215), 40,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [15269] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(223), 5,
      anon_sym_as,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(221), 40,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [15325] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(225), 1,
      anon_sym_EQ_GT,
    ACTIONS(223), 5,
      anon_sym_COLON,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(221), 38,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [15382] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(227), 1,
      anon_sym_EQ_GT,
    ACTIONS(221), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(223), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15438] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(215), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(219), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15491] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(233), 1,
      anon_sym_EQ_GT,
    ACTIONS(231), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(229), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15544] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(221), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(223), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15597] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(239), 1,
      anon_sym_EQ_GT,
    ACTIONS(237), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(235), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15650] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(245), 1,
      anon_sym_EQ_GT,
    ACTIONS(243), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(241), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15703] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(249), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(247), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15753] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(257), 1,
      anon_sym_LBRACK,
    ACTIONS(260), 1,
      anon_sym_SEMI,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(266), 1,
      anon_sym_DASH,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(281), 1,
      anon_sym_and,
    ACTIONS(284), 1,
      anon_sym_or,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(253), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(251), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15835] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(293), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(291), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(305), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(303), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [15965] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 15,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(307), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16019] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(315), 1,
      anon_sym_LPAREN,
    ACTIONS(313), 16,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(311), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16071] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(320), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(318), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16121] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(324), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(322), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(313), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(311), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16221] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(328), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(326), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16271] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(332), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(330), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16321] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(338), 1,
      anon_sym_LBRACK,
    ACTIONS(341), 1,
      anon_sym_SEMI,
    ACTIONS(343), 1,
      anon_sym_DASH,
    ACTIONS(346), 1,
      anon_sym_and,
    ACTIONS(349), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(336), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(334), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16403] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(356), 1,
      anon_sym_LBRACK,
    ACTIONS(359), 1,
      anon_sym_SEMI,
    ACTIONS(361), 1,
      anon_sym_DASH,
    ACTIONS(364), 1,
      anon_sym_and,
    ACTIONS(367), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(354), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(352), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(372), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(370), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16535] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(376), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(374), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(378), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(384), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(382), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16715] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(231), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(229), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16765] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(388), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(386), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16815] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(390), 1,
      anon_sym_EQ_GT,
    ACTIONS(235), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(237), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [16867] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(392), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16917] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(396), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [16967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(400), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17017] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(404), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17067] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(410), 6,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(408), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17145] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 1,
      anon_sym_LPAREN,
    ACTIONS(414), 16,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(412), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17197] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_LPAREN,
    ACTIONS(412), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(414), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [17249] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(412), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17299] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(421), 1,
      anon_sym_EQ_GT,
    ACTIONS(229), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(231), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [17351] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(408), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17401] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(410), 14,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(408), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17457] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(410), 12,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(408), 24,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17517] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(410), 14,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(408), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17573] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(410), 11,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(408), 23,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17637] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(425), 6,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(423), 21,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17707] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(429), 6,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(427), 20,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17779] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(433), 6,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(431), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17853] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(437), 6,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(435), 18,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [17929] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(443), 1,
      anon_sym_LBRACK,
    ACTIONS(446), 1,
      anon_sym_SEMI,
    ACTIONS(448), 1,
      anon_sym_DASH,
    ACTIONS(451), 1,
      anon_sym_and,
    ACTIONS(454), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(441), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(439), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18011] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(461), 1,
      anon_sym_LBRACK,
    ACTIONS(464), 1,
      anon_sym_SEMI,
    ACTIONS(466), 1,
      anon_sym_DASH,
    ACTIONS(469), 1,
      anon_sym_and,
    ACTIONS(472), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(459), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(457), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18093] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(477), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(475), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(481), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(479), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18223] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(483), 1,
      anon_sym_EQ_GT,
    ACTIONS(241), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(243), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [18275] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(487), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(485), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18325] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(491), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(489), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18375] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(495), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(493), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(499), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(497), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18475] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_LPAREN,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [18527] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(503), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(501), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18577] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(507), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(505), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18627] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(511), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(509), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18677] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(515), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(513), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18727] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 7,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
      anon_sym_SQUOTE,
    ACTIONS(517), 21,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18795] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(525), 1,
      anon_sym_LBRACK,
    ACTIONS(528), 1,
      anon_sym_SEMI,
    ACTIONS(530), 1,
      anon_sym_DASH,
    ACTIONS(533), 1,
      anon_sym_and,
    ACTIONS(536), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(521), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18877] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(543), 1,
      anon_sym_LBRACK,
    ACTIONS(546), 1,
      anon_sym_SEMI,
    ACTIONS(548), 1,
      anon_sym_DASH,
    ACTIONS(551), 1,
      anon_sym_and,
    ACTIONS(554), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(541), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(539), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [18959] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(559), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(557), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19039] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(563), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(561), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(567), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(565), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19139] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(571), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(569), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(575), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(573), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19239] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(579), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(577), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(581), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(587), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(585), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19389] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(596), 1,
      anon_sym_SEMI,
    ACTIONS(598), 1,
      anon_sym_DASH,
    ACTIONS(601), 1,
      anon_sym_and,
    ACTIONS(604), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(591), 4,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_int_literal,
    ACTIONS(589), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19471] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(607), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(613), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(611), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19601] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(617), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(615), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19651] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(621), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(619), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19701] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(625), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(623), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19751] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(629), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(627), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 17,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_STAR,
      sym_int_literal,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
    ACTIONS(631), 25,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19851] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(255), 1,
      anon_sym_DASH_GT,
    ACTIONS(262), 1,
      anon_sym_DOT,
    ACTIONS(269), 1,
      anon_sym_CARET,
    ACTIONS(271), 1,
      anon_sym_SLASH,
    ACTIONS(273), 1,
      anon_sym_PLUS,
    ACTIONS(279), 1,
      anon_sym_SQUOTE,
    ACTIONS(287), 1,
      anon_sym_iff,
    ACTIONS(289), 1,
      anon_sym_implies,
    ACTIONS(295), 1,
      anon_sym_LBRACK,
    ACTIONS(297), 1,
      anon_sym_DASH,
    ACTIONS(299), 1,
      anon_sym_and,
    ACTIONS(301), 1,
      anon_sym_or,
    ACTIONS(264), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(275), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(277), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(637), 5,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_SEMI,
      sym_int_literal,
    ACTIONS(635), 17,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [19931] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(307), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(309), 35,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [19984] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(414), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20033] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(571), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20180] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(477), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [20257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20306] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(499), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20355] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(503), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20404] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20453] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(511), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20502] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20600] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 27,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(328), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(332), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20763] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20812] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20861] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(372), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20910] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(380), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [20959] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(305), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21008] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(324), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21057] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(637), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [21134] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21183] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21281] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(249), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21330] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(376), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [21407] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(559), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [21484] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(437), 23,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_implies,
      anon_sym_else,
  [21557] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(320), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21606] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(433), 24,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21677] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(429), 25,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21746] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(293), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [21823] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(425), 26,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21890] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(408), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(410), 31,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [21953] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 34,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22008] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22057] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(408), 3,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 32,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22116] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 34,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22220] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22269] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(384), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(579), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22367] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(487), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22416] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22465] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22514] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22563] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(583), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22612] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(410), 22,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [22687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(406), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22736] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_else,
  [22813] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(402), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22862] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(398), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22911] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(394), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [22960] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(388), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [23009] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(231), 37,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_PIPE,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
      anon_sym_else,
  [23058] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
    ACTIONS(669), 1,
      anon_sym_EQ_GT,
    ACTIONS(223), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(221), 34,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23110] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_LPAREN,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23158] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(671), 1,
      anon_sym_LPAREN,
    ACTIONS(412), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(414), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23206] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_EQ_GT,
    ACTIONS(235), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(237), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23254] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(675), 1,
      anon_sym_EQ_GT,
    ACTIONS(241), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(243), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23302] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(677), 1,
      anon_sym_EQ_GT,
    ACTIONS(229), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(231), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23350] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(569), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(571), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23395] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(633), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23440] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(683), 1,
      anon_sym_SEMI,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [23515] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(229), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(231), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23560] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(372), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23605] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(711), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(541), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [23680] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(388), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23725] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(559), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [23798] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(561), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(563), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23843] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(408), 3,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 28,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23898] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23949] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(565), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(567), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [23994] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(408), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(410), 27,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(380), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24098] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(713), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(459), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [24173] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(573), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(575), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24218] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(394), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24263] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(577), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(579), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24308] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(477), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [24381] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(425), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24444] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(398), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24489] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(402), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24534] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(307), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(309), 31,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24583] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(318), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(320), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24628] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(581), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(583), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24673] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(330), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(332), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(585), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(587), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24763] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(429), 21,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24828] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(715), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(591), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [24903] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(326), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(328), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24948] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [24993] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(513), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(515), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25038] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(479), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(481), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25083] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(433), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_iff,
      anon_sym_implies,
  [25150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(303), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(305), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25195] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(406), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25240] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(376), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [25313] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(509), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(511), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25358] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(410), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [25429] = 15,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(437), 19,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_implies,
  [25498] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(505), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(507), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25543] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(717), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(253), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [25618] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(609), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [25691] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(501), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(503), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25736] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(719), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(441), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [25811] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(611), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(613), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25856] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(497), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(499), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25901] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(414), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25946] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(617), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [25991] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(619), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26036] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(247), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(249), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26081] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26126] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(493), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(495), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26171] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(629), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26216] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(485), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(487), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26261] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(293), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26334] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 30,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(489), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(491), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26430] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(382), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(384), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26475] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(322), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(324), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26520] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(637), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26593] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(721), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(354), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26668] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(723), 1,
      anon_sym_SEMI,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(336), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(410), 33,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_export,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26788] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(519), 23,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_SEMI,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [26849] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(679), 1,
      anon_sym_DASH_GT,
    ACTIONS(681), 1,
      anon_sym_LBRACK,
    ACTIONS(685), 1,
      anon_sym_DOT,
    ACTIONS(689), 1,
      anon_sym_DASH,
    ACTIONS(691), 1,
      anon_sym_CARET,
    ACTIONS(693), 1,
      anon_sym_SLASH,
    ACTIONS(695), 1,
      anon_sym_PLUS,
    ACTIONS(701), 1,
      anon_sym_SQUOTE,
    ACTIONS(703), 1,
      anon_sym_and,
    ACTIONS(705), 1,
      anon_sym_or,
    ACTIONS(707), 1,
      anon_sym_iff,
    ACTIONS(709), 1,
      anon_sym_implies,
    ACTIONS(687), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(697), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(725), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26921] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(727), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(541), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [26994] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(729), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(591), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27067] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(731), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(459), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27140] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(733), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(441), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27213] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(735), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(253), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27286] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(737), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(354), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27359] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(739), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(336), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27432] = 18,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(741), 1,
      anon_sym_SEMI,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(523), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27505] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(725), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [27575] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    ACTIONS(9), 1,
      anon_sym_module,
    ACTIONS(11), 1,
      anon_sym_const,
    ACTIONS(13), 1,
      anon_sym_assume,
    ACTIONS(15), 1,
      anon_sym_var,
    ACTIONS(17), 1,
      anon_sym_pure,
    ACTIONS(21), 1,
      anon_sym_type,
    ACTIONS(23), 1,
      anon_sym_import,
    ACTIONS(25), 1,
      anon_sym_export,
    ACTIONS(743), 1,
      ts_builtin_sym_end,
    ACTIONS(19), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(372), 10,
      sym_string,
      sym_module_definition,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      sym_import,
      sym_export,
      aux_sym_source_file_repeat1,
  [27629] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 1,
      ts_builtin_sym_end,
    ACTIONS(747), 1,
      anon_sym_DQUOTE,
    ACTIONS(750), 1,
      anon_sym_module,
    ACTIONS(753), 1,
      anon_sym_const,
    ACTIONS(756), 1,
      anon_sym_assume,
    ACTIONS(759), 1,
      anon_sym_var,
    ACTIONS(762), 1,
      anon_sym_pure,
    ACTIONS(768), 1,
      anon_sym_type,
    ACTIONS(771), 1,
      anon_sym_import,
    ACTIONS(774), 1,
      anon_sym_export,
    ACTIONS(765), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(372), 10,
      sym_string,
      sym_module_definition,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      sym_import,
      sym_export,
      aux_sym_source_file_repeat1,
  [27683] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(777), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27716] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(781), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27749] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(785), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27782] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(789), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27815] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(793), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27848] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(797), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(801), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 6,
      anon_sym_DQUOTE,
      anon_sym_LPAREN,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_int_literal,
      anon_sym_DASH,
    ACTIONS(805), 19,
      sym_identifier,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_Bool,
      anon_sym_Int,
      anon_sym_Nat,
      anon_sym_true,
      anon_sym_false,
      anon_sym_and,
      anon_sym_or,
      anon_sym_all,
      anon_sym_any,
      anon_sym_if,
      anon_sym_match,
  [27947] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(809), 4,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [28007] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      anon_sym_LBRACK,
    ACTIONS(815), 1,
      anon_sym_EQ,
    ACTIONS(811), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28041] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(819), 1,
      anon_sym_EQ,
    ACTIONS(817), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28072] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(823), 1,
      anon_sym_RBRACK,
    STATE(759), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28135] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    ACTIONS(827), 1,
      anon_sym_RPAREN,
    STATE(706), 1,
      aux_sym_import_segment_arguments_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28198] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_LPAREN,
    ACTIONS(829), 1,
      anon_sym_COLON,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [28233] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(837), 1,
      anon_sym_EQ,
    ACTIONS(831), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28268] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(839), 1,
      anon_sym_COMMA,
    ACTIONS(841), 1,
      anon_sym_RBRACE,
    STATE(762), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28331] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(845), 1,
      anon_sym_EQ_GT,
    ACTIONS(847), 1,
      anon_sym_EQ,
    ACTIONS(843), 21,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28364] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_LPAREN,
    ACTIONS(849), 1,
      anon_sym_COLON,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [28399] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(853), 1,
      anon_sym_EQ_GT,
    ACTIONS(855), 1,
      anon_sym_EQ,
    ACTIONS(851), 21,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28432] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(857), 1,
      anon_sym_RPAREN,
    STATE(748), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28495] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(861), 1,
      anon_sym_EQ,
    ACTIONS(859), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28526] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(863), 1,
      anon_sym_COMMA,
    ACTIONS(865), 1,
      anon_sym_RBRACE,
    STATE(755), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28589] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(867), 1,
      anon_sym_RBRACK,
    STATE(679), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28652] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(419), 1,
      anon_sym_LPAREN,
    ACTIONS(869), 1,
      anon_sym_COLON,
    ACTIONS(311), 4,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(313), 17,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACE,
      anon_sym_DOT,
      anon_sym_STAR,
      anon_sym_CARET,
      anon_sym_PERCENT,
      anon_sym_PLUS,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_SQUOTE,
      anon_sym_and,
      anon_sym_or,
      anon_sym_iff,
      anon_sym_implies,
  [28687] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(871), 1,
      anon_sym_COMMA,
    ACTIONS(873), 1,
      anon_sym_RBRACE,
    STATE(683), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28750] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(815), 1,
      anon_sym_EQ,
    ACTIONS(811), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28781] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(877), 1,
      anon_sym_EQ,
    ACTIONS(875), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28812] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(879), 1,
      anon_sym_COMMA,
    ACTIONS(881), 1,
      anon_sym_RBRACE,
    STATE(764), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28875] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(883), 1,
      anon_sym_RPAREN,
    STATE(761), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [28938] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(887), 1,
      anon_sym_EQ,
    ACTIONS(885), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [28973] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(889), 1,
      anon_sym_COMMA,
    ACTIONS(891), 1,
      anon_sym_RBRACE,
    STATE(774), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29036] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(893), 1,
      anon_sym_COMMA,
    ACTIONS(895), 1,
      anon_sym_RBRACE,
    STATE(777), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29099] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(899), 1,
      anon_sym_EQ,
    ACTIONS(897), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29130] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(901), 1,
      anon_sym_COMMA,
    ACTIONS(903), 1,
      anon_sym_RBRACE,
    STATE(775), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29193] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(905), 1,
      anon_sym_COMMA,
    ACTIONS(907), 1,
      anon_sym_RBRACE,
    STATE(773), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29256] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(909), 1,
      anon_sym_COMMA,
    ACTIONS(911), 1,
      anon_sym_RBRACE,
    STATE(766), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29319] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(913), 1,
      anon_sym_RPAREN,
    STATE(758), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29382] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(915), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29445] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_RBRACE,
    STATE(726), 1,
      aux_sym_record_literal_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29508] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(923), 1,
      anon_sym_EQ_GT,
    ACTIONS(925), 1,
      anon_sym_EQ,
    ACTIONS(921), 21,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29541] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    ACTIONS(927), 1,
      anon_sym_RPAREN,
    STATE(722), 1,
      aux_sym_import_segment_arguments_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29604] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(929), 1,
      anon_sym_RPAREN,
    STATE(721), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29667] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(931), 1,
      anon_sym_COMMA,
    ACTIONS(933), 1,
      anon_sym_RBRACE,
    STATE(719), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29730] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(935), 1,
      anon_sym_COMMA,
    ACTIONS(937), 1,
      anon_sym_RBRACE,
    STATE(771), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29793] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(941), 1,
      anon_sym_EQ,
    ACTIONS(939), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29828] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(945), 1,
      anon_sym_EQ,
    ACTIONS(943), 20,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29863] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(949), 1,
      anon_sym_EQ,
    ACTIONS(947), 21,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29896] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(953), 1,
      anon_sym_EQ,
    ACTIONS(951), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [29927] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(955), 1,
      anon_sym_COMMA,
    ACTIONS(957), 1,
      anon_sym_RBRACE,
    STATE(718), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [29990] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(959), 1,
      anon_sym_COMMA,
    ACTIONS(961), 1,
      anon_sym_RBRACE,
    STATE(716), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30053] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(965), 1,
      anon_sym_EQ,
    ACTIONS(963), 22,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_EQ_GT,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [30084] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(967), 1,
      anon_sym_COMMA,
    ACTIONS(969), 1,
      anon_sym_RBRACE,
    STATE(715), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30147] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(971), 1,
      anon_sym_RBRACK,
    STATE(702), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30210] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(973), 1,
      anon_sym_RPAREN,
    STATE(701), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30273] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(975), 1,
      anon_sym_RBRACE,
    ACTIONS(977), 1,
      anon_sym_const,
    ACTIONS(979), 1,
      anon_sym_assume,
    ACTIONS(981), 1,
      anon_sym_var,
    ACTIONS(983), 1,
      anon_sym_pure,
    ACTIONS(987), 1,
      anon_sym_type,
    ACTIONS(989), 1,
      anon_sym_import,
    ACTIONS(991), 1,
      anon_sym_export,
    ACTIONS(985), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(432), 8,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      sym_import,
      sym_export,
      aux_sym_module_definition_repeat1,
  [30319] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(993), 2,
      anon_sym_PIPE,
      anon_sym_RBRACE,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30377] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(977), 1,
      anon_sym_const,
    ACTIONS(979), 1,
      anon_sym_assume,
    ACTIONS(981), 1,
      anon_sym_var,
    ACTIONS(983), 1,
      anon_sym_pure,
    ACTIONS(987), 1,
      anon_sym_type,
    ACTIONS(989), 1,
      anon_sym_import,
    ACTIONS(991), 1,
      anon_sym_export,
    ACTIONS(995), 1,
      anon_sym_RBRACE,
    ACTIONS(985), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(427), 8,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      sym_import,
      sym_export,
      aux_sym_module_definition_repeat1,
  [30423] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(997), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30481] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(999), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30539] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1001), 1,
      anon_sym_RBRACE,
    ACTIONS(1003), 1,
      anon_sym_const,
    ACTIONS(1006), 1,
      anon_sym_assume,
    ACTIONS(1009), 1,
      anon_sym_var,
    ACTIONS(1012), 1,
      anon_sym_pure,
    ACTIONS(1018), 1,
      anon_sym_type,
    ACTIONS(1021), 1,
      anon_sym_import,
    ACTIONS(1024), 1,
      anon_sym_export,
    ACTIONS(1015), 6,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
    STATE(432), 8,
      sym_constant_declaration,
      sym_assumption,
      sym_variable_definition,
      sym_operator_definition,
      sym_type_alias,
      sym_import,
      sym_export,
      aux_sym_module_definition_repeat1,
  [30585] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1027), 2,
      anon_sym_PIPE,
      anon_sym_RBRACE,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30643] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1029), 1,
      anon_sym_else,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30700] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1031), 1,
      anon_sym_RPAREN,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30757] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1033), 1,
      anon_sym_RPAREN,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30814] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1035), 1,
      anon_sym_RPAREN,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30871] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1037), 1,
      anon_sym_RPAREN,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30928] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1039), 1,
      anon_sym_RBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [30985] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1041), 1,
      anon_sym_RBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31042] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1043), 1,
      anon_sym_else,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31099] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1047), 1,
      anon_sym_LPAREN,
    ACTIONS(1049), 1,
      anon_sym_as,
    STATE(464), 1,
      sym_import_segment_arguments,
    ACTIONS(1045), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31132] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1051), 1,
      anon_sym_LBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31189] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1053), 1,
      anon_sym_LBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31246] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(813), 1,
      anon_sym_LBRACK,
    ACTIONS(1057), 1,
      anon_sym_LPAREN,
    ACTIONS(811), 2,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
    ACTIONS(1055), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_PIPE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31279] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1059), 1,
      anon_sym_RBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31336] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1061), 1,
      anon_sym_LBRACE,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31393] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1063), 1,
      anon_sym_RBRACK,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31450] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1065), 1,
      anon_sym_RBRACK,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31507] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1067), 1,
      anon_sym_else,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31564] = 17,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(639), 1,
      anon_sym_LBRACK,
    ACTIONS(641), 1,
      anon_sym_DOT,
    ACTIONS(643), 1,
      anon_sym_DASH_GT,
    ACTIONS(647), 1,
      anon_sym_DASH,
    ACTIONS(649), 1,
      anon_sym_CARET,
    ACTIONS(651), 1,
      anon_sym_SLASH,
    ACTIONS(653), 1,
      anon_sym_PLUS,
    ACTIONS(659), 1,
      anon_sym_SQUOTE,
    ACTIONS(661), 1,
      anon_sym_and,
    ACTIONS(663), 1,
      anon_sym_or,
    ACTIONS(665), 1,
      anon_sym_iff,
    ACTIONS(667), 1,
      anon_sym_implies,
    ACTIONS(1069), 1,
      anon_sym_RBRACK,
    ACTIONS(645), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(655), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(657), 4,
      anon_sym_GT_EQ,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31621] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1073), 1,
      anon_sym_DOT,
    ACTIONS(1076), 1,
      anon_sym_as,
    STATE(452), 1,
      aux_sym_import_repeat1,
    ACTIONS(1071), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_from,
      anon_sym_export,
  [31653] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_DOT,
    ACTIONS(1082), 1,
      anon_sym_as,
    ACTIONS(1084), 1,
      anon_sym_from,
    STATE(454), 1,
      aux_sym_import_repeat1,
    ACTIONS(1078), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31687] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1080), 1,
      anon_sym_DOT,
    ACTIONS(1088), 1,
      anon_sym_as,
    ACTIONS(1090), 1,
      anon_sym_from,
    STATE(452), 1,
      aux_sym_import_repeat1,
    ACTIONS(1086), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31721] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_as,
    ACTIONS(1071), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31748] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_as,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(485), 1,
      sym_import_segment_arguments,
    ACTIONS(1045), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31779] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1096), 1,
      anon_sym_DOT,
    ACTIONS(1099), 1,
      anon_sym_as,
    STATE(457), 1,
      aux_sym_export_repeat1,
    ACTIONS(1094), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31810] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1105), 1,
      anon_sym_as,
    STATE(465), 1,
      aux_sym_export_repeat1,
    ACTIONS(1101), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1109), 1,
      anon_sym_as,
    ACTIONS(1107), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31868] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1113), 1,
      anon_sym_as,
    ACTIONS(1111), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31895] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_LPAREN,
    ACTIONS(1117), 1,
      anon_sym_LBRACK,
    ACTIONS(811), 2,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
    ACTIONS(1055), 15,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [31926] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_as,
    ACTIONS(1045), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31953] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_as,
    ACTIONS(1119), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [31980] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1125), 1,
      anon_sym_as,
    ACTIONS(1123), 18,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32007] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1103), 1,
      anon_sym_DOT,
    ACTIONS(1129), 1,
      anon_sym_as,
    STATE(457), 1,
      aux_sym_export_repeat1,
    ACTIONS(1127), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32038] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1131), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32066] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_PIPE,
    STATE(468), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1133), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32094] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1139), 1,
      anon_sym_PIPE,
    STATE(468), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1137), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32122] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1142), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32150] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1144), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32178] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1146), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32206] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_as,
    ACTIONS(1148), 1,
      anon_sym_DOT,
    STATE(472), 1,
      aux_sym_import_repeat1,
    ACTIONS(1071), 15,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_from,
      anon_sym_export,
  [32236] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1151), 1,
      anon_sym_DOT,
    ACTIONS(1153), 1,
      anon_sym_as,
    ACTIONS(1155), 1,
      anon_sym_from,
    STATE(480), 1,
      aux_sym_import_repeat1,
    ACTIONS(1078), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32268] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_PIPE,
    STATE(476), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1133), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32296] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1057), 1,
      anon_sym_LPAREN,
    ACTIONS(1055), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_PIPE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32322] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_PIPE,
    STATE(468), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1157), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32350] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1159), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      anon_sym_as,
    ACTIONS(1094), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_export,
  [32404] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1135), 1,
      anon_sym_PIPE,
    STATE(467), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1161), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32432] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1151), 1,
      anon_sym_DOT,
    ACTIONS(1163), 1,
      anon_sym_as,
    ACTIONS(1165), 1,
      anon_sym_from,
    STATE(472), 1,
      aux_sym_import_repeat1,
    ACTIONS(1086), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32464] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_PIPE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32487] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1076), 1,
      anon_sym_as,
    ACTIONS(1071), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32512] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      anon_sym_as,
    ACTIONS(1167), 1,
      anon_sym_DOT,
    STATE(483), 1,
      aux_sym_export_repeat1,
    ACTIONS(1094), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32541] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1172), 1,
      anon_sym_from,
    ACTIONS(1170), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32566] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1125), 1,
      anon_sym_as,
    ACTIONS(1123), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32591] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 17,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_PIPE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32614] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1109), 1,
      anon_sym_as,
    ACTIONS(1107), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32639] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1121), 1,
      anon_sym_as,
    ACTIONS(1119), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32664] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_DOT,
    ACTIONS(1178), 1,
      anon_sym_as,
    STATE(493), 1,
      aux_sym_export_repeat1,
    ACTIONS(1101), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32693] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1049), 1,
      anon_sym_as,
    ACTIONS(1045), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32718] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1117), 1,
      anon_sym_LBRACK,
    ACTIONS(811), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32743] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1113), 1,
      anon_sym_as,
    ACTIONS(1111), 16,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_from,
      anon_sym_export,
  [32768] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1176), 1,
      anon_sym_DOT,
    ACTIONS(1180), 1,
      anon_sym_as,
    STATE(483), 1,
      aux_sym_export_repeat1,
    ACTIONS(1127), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32797] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1184), 1,
      anon_sym_from,
    ACTIONS(1182), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32822] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(1144), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32848] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32870] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32892] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(859), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32914] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1190), 1,
      anon_sym_EQ_GT,
    ACTIONS(851), 15,
      anon_sym_DASH_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32938] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32960] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(831), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [32986] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33008] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1192), 1,
      anon_sym_PIPE,
    STATE(503), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1137), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33034] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33056] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_PIPE,
    STATE(503), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1157), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33082] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33104] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1197), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33126] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1199), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33148] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(1146), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33174] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33196] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33218] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(1159), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33244] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33266] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33288] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(939), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33314] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(1131), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33340] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(963), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33362] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(817), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33384] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33406] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33428] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(943), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33454] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(947), 15,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33478] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1203), 1,
      anon_sym_EQ_GT,
    ACTIONS(921), 15,
      anon_sym_DASH_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33502] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33524] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_PIPE,
    STATE(529), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1161), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33550] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1205), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33572] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33594] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33616] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_PIPE,
    STATE(503), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1133), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33642] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1099), 1,
      anon_sym_as,
    ACTIONS(1094), 15,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_export,
  [33666] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(1142), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33692] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1209), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33714] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 16,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_module,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33736] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1186), 1,
      anon_sym_DASH_GT,
    ACTIONS(1188), 1,
      anon_sym_EQ_GT,
    ACTIONS(885), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33762] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(951), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33784] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1195), 1,
      anon_sym_PIPE,
    STATE(505), 1,
      aux_sym_sum_type_repeat1,
    ACTIONS(1133), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33810] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1115), 1,
      anon_sym_LPAREN,
    ACTIONS(1055), 15,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33834] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1211), 1,
      anon_sym_EQ_GT,
    ACTIONS(843), 15,
      anon_sym_DASH_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33858] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(897), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33880] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(875), 16,
      anon_sym_DASH_GT,
      anon_sym_EQ_GT,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1213), 1,
      anon_sym_from,
    ACTIONS(1170), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33925] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1137), 15,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33946] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1174), 15,
      anon_sym_PIPE,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33967] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1215), 1,
      anon_sym_from,
    ACTIONS(1182), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [33990] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1221), 1,
      anon_sym_PIPE,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(461), 1,
      sym_qualified_identifier,
    STATE(509), 1,
      sym_type,
    STATE(525), 1,
      sym_variant_constructor,
    STATE(558), 1,
      sym_sum_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34028] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(799), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34048] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(445), 1,
      sym_qualified_identifier,
    STATE(471), 1,
      sym_type,
    STATE(479), 1,
      sym_variant_constructor,
    STATE(510), 1,
      sym_sum_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34086] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(787), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34106] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(445), 1,
      sym_qualified_identifier,
    STATE(469), 1,
      sym_type,
    STATE(479), 1,
      sym_variant_constructor,
    STATE(513), 1,
      sym_sum_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34144] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1197), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34164] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1201), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34184] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1229), 1,
      anon_sym_PIPE,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(445), 1,
      sym_qualified_identifier,
    STATE(466), 1,
      sym_type,
    STATE(479), 1,
      sym_variant_constructor,
    STATE(500), 1,
      sym_sum_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34222] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1142), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34242] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(783), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34262] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(807), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34282] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(803), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34302] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(795), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34322] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1146), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34342] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1182), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34362] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1170), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34382] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1221), 1,
      anon_sym_PIPE,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(461), 1,
      sym_qualified_identifier,
    STATE(525), 1,
      sym_variant_constructor,
    STATE(531), 1,
      sym_type,
    STATE(553), 1,
      sym_sum_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34420] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34440] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1131), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34460] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1205), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34480] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1221), 1,
      anon_sym_PIPE,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(461), 1,
      sym_qualified_identifier,
    STATE(516), 1,
      sym_type,
    STATE(525), 1,
      sym_variant_constructor,
    STATE(563), 1,
      sym_sum_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34518] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(791), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34538] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1207), 14,
      anon_sym_RBRACE,
      anon_sym_const,
      anon_sym_assume,
      anon_sym_var,
      anon_sym_pure,
      anon_sym_val,
      anon_sym_def,
      anon_sym_action,
      anon_sym_temporal,
      anon_sym_nondet,
      anon_sym_run,
      anon_sym_type,
      anon_sym_import,
      anon_sym_export,
  [34558] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1233), 1,
      anon_sym_RPAREN,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(615), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34590] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    ACTIONS(1235), 1,
      anon_sym_RPAREN,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(626), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34622] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(618), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34651] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(512), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34680] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(402), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34709] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(417), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34738] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(629), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34767] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(470), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34796] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(709), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34825] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(711), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34854] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(534), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34883] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(756), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34912] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(757), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34941] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(522), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34970] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(717), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [34999] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(707), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35028] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(624), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35057] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(614), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35086] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(640), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35115] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(418), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35144] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(501), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35173] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(419), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35202] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(521), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35231] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(477), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35260] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(767), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35289] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(697), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35318] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(696), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35347] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(768), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35376] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(689), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35405] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(666), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35434] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(387), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35463] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(610), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35492] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(621), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35521] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(746), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35550] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(515), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35579] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1219), 1,
      anon_sym_LPAREN,
    ACTIONS(1223), 1,
      anon_sym_LBRACE,
    STATE(491), 1,
      sym_qualified_identifier,
    STATE(495), 1,
      sym_type,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(511), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35608] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(699), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35637] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      anon_sym_LBRACE,
    STATE(382), 1,
      sym_qualified_identifier,
    STATE(750), 1,
      sym_type,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(398), 5,
      sym_function_type,
      sym_operator_type,
      sym_polymorphic_type,
      sym_record_type,
      sym_tuple_type,
  [35666] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1237), 1,
      anon_sym_PIPE,
    ACTIONS(1239), 1,
      anon_sym_RBRACE,
    STATE(772), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [35688] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1241), 1,
      anon_sym_PIPE,
    ACTIONS(1243), 1,
      anon_sym_RBRACE,
    STATE(720), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [35710] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1245), 1,
      anon_sym_PIPE,
    ACTIONS(1247), 1,
      anon_sym_RBRACE,
    STATE(752), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [35732] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1249), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
    ACTIONS(809), 3,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
      anon_sym_RBRACE,
  [35747] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1252), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [35762] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(919), 1,
      anon_sym_RBRACE,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [35781] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(865), 1,
      anon_sym_RBRACE,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [35800] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(187), 1,
      sym_qualified_identifier,
    STATE(234), 1,
      sym_operator_application,
    STATE(278), 1,
      sym_ufcs_right_hand_side,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [35819] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1256), 1,
      anon_sym_COMMA,
    ACTIONS(1258), 1,
      anon_sym_RBRACE,
    STATE(724), 1,
      aux_sym_record_type_repeat1,
  [35838] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1262), 1,
      anon_sym_RPAREN,
    STATE(684), 1,
      aux_sym_operator_type_repeat1,
  [35857] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1264), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [35876] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1266), 1,
      anon_sym_STAR,
    STATE(442), 1,
      sym_qualified_identifier,
    STATE(455), 1,
      sym_import_segment,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [35895] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1268), 1,
      anon_sym_RBRACK,
    STATE(714), 1,
      aux_sym_operator_type_repeat1,
  [35914] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1270), 1,
      anon_sym_STAR,
    STATE(456), 1,
      sym_qualified_identifier,
    STATE(473), 1,
      sym_import_segment,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [35933] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1272), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [35952] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1274), 1,
      anon_sym_COMMA,
    ACTIONS(1276), 1,
      anon_sym_RBRACE,
    STATE(705), 1,
      aux_sym_record_type_repeat1,
  [35971] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1278), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [35990] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1270), 1,
      anon_sym_STAR,
    STATE(456), 1,
      sym_qualified_identifier,
    STATE(482), 1,
      sym_import_segment,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36009] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1280), 1,
      anon_sym_RBRACK,
    STATE(712), 1,
      aux_sym_operator_type_repeat1,
  [36028] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1282), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [36047] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1284), 1,
      anon_sym_RPAREN,
    STATE(700), 1,
      aux_sym_operator_type_repeat1,
  [36066] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1266), 1,
      anon_sym_STAR,
    STATE(442), 1,
      sym_qualified_identifier,
    STATE(453), 1,
      sym_import_segment,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36085] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1286), 1,
      sym_identifier,
    STATE(186), 1,
      sym_qualified_identifier,
    STATE(188), 1,
      sym_operator_application,
    STATE(190), 1,
      sym_ufcs_right_hand_side,
    STATE(797), 1,
      aux_sym_qualified_identifier_repeat1,
  [36104] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1288), 1,
      anon_sym_COMMA,
    ACTIONS(1290), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      aux_sym_typed_argument_list_repeat1,
  [36123] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1292), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [36142] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1294), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [36161] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(873), 1,
      anon_sym_RBRACE,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [36180] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(292), 1,
      sym_qualified_identifier,
    STATE(343), 1,
      sym_operator_application,
    STATE(359), 1,
      sym_ufcs_right_hand_side,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36199] = 4,
    ACTIONS(1299), 1,
      anon_sym_DQUOTE,
    ACTIONS(1301), 1,
      sym_comment,
    STATE(634), 1,
      aux_sym_string_repeat1,
    ACTIONS(1296), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36213] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(753), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [36229] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1303), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(841), 1,
      sym_qualified_identifier,
  [36245] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(536), 1,
      sym_variant_constructor,
    STATE(537), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36261] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1307), 1,
      anon_sym_DQUOTE,
    STATE(668), 1,
      aux_sym_string_repeat1,
    ACTIONS(1305), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36275] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1309), 1,
      anon_sym_STAR,
    STATE(458), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36291] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1311), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [36305] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(732), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [36321] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1313), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(841), 1,
      sym_qualified_identifier,
  [36337] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(779), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [36353] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1317), 1,
      anon_sym_COLON,
    ACTIONS(1319), 1,
      anon_sym_EQ,
    STATE(793), 1,
      sym_typed_argument_list,
  [36369] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1321), 1,
      anon_sym_COLON,
    ACTIONS(1323), 1,
      anon_sym_EQ,
    STATE(778), 1,
      sym_typed_argument_list,
  [36385] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1327), 1,
      anon_sym_DQUOTE,
    STATE(634), 1,
      aux_sym_string_repeat1,
    ACTIONS(1325), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36399] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1329), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(813), 1,
      sym_qualified_identifier,
  [36415] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1331), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(841), 1,
      sym_qualified_identifier,
  [36431] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(475), 1,
      sym_qualified_identifier,
    STATE(481), 1,
      sym_variant_constructor,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36447] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1333), 1,
      anon_sym_COLON,
    ACTIONS(1335), 1,
      anon_sym_EQ,
    STATE(792), 1,
      sym_typed_argument_list,
  [36463] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1337), 1,
      anon_sym_STAR,
    STATE(530), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36479] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1288), 1,
      anon_sym_COMMA,
    ACTIONS(1339), 1,
      anon_sym_RPAREN,
    ACTIONS(1341), 1,
      anon_sym_COLON,
    STATE(704), 1,
      aux_sym_typed_argument_list_repeat1,
  [36495] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1345), 1,
      anon_sym_DQUOTE,
    STATE(646), 1,
      aux_sym_string_repeat1,
    ACTIONS(1343), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36509] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1347), 1,
      anon_sym_COLON,
    ACTIONS(1349), 1,
      anon_sym_EQ,
    STATE(787), 1,
      sym_typed_argument_list,
  [36525] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1353), 1,
      anon_sym_DQUOTE,
    STATE(658), 1,
      aux_sym_string_repeat1,
    ACTIONS(1351), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36539] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1355), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(841), 1,
      sym_qualified_identifier,
  [36555] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    ACTIONS(1357), 1,
      anon_sym_STAR,
    STATE(489), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36571] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1359), 1,
      anon_sym_DQUOTE,
    STATE(634), 1,
      aux_sym_string_repeat1,
    ACTIONS(1325), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36585] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(674), 1,
      sym_match_case,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(789), 1,
      sym_qualified_identifier,
  [36601] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(474), 1,
      sym_variant_constructor,
    STATE(475), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36617] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(834), 1,
      sym_qualified_identifier,
  [36633] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1361), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(851), 1,
      sym_qualified_identifier,
  [36649] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1363), 1,
      anon_sym_STAR,
    STATE(478), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36665] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1365), 1,
      anon_sym_COLON,
    ACTIONS(1367), 1,
      anon_sym_EQ,
    STATE(798), 1,
      sym_typed_argument_list,
  [36681] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1369), 1,
      anon_sym_COMMA,
    STATE(665), 1,
      aux_sym_operator_type_repeat1,
    ACTIONS(1252), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
  [36695] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1372), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [36709] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1374), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(842), 1,
      sym_qualified_identifier,
  [36725] = 4,
    ACTIONS(1301), 1,
      sym_comment,
    ACTIONS(1376), 1,
      anon_sym_DQUOTE,
    STATE(634), 1,
      aux_sym_string_repeat1,
    ACTIONS(1325), 2,
      sym_unescaped_double_string_fragment,
      sym_escape_sequence,
  [36739] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(537), 1,
      sym_qualified_identifier,
    STATE(542), 1,
      sym_variant_constructor,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36755] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1378), 1,
      anon_sym_RBRACE,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(843), 1,
      sym_qualified_identifier,
  [36771] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1315), 1,
      anon_sym_LPAREN,
    ACTIONS(1380), 1,
      anon_sym_COLON,
    ACTIONS(1382), 1,
      anon_sym_EQ,
    STATE(808), 1,
      sym_typed_argument_list,
  [36787] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1384), 1,
      anon_sym_COMMA,
    ACTIONS(1387), 1,
      anon_sym_RBRACK,
    STATE(672), 1,
      aux_sym_type_alias_repeat1,
  [36800] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_COMMA,
    ACTIONS(1391), 1,
      anon_sym_RBRACK,
    STATE(695), 1,
      aux_sym_type_alias_repeat1,
  [36813] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1395), 1,
      anon_sym_RBRACE,
    STATE(769), 1,
      aux_sym_match_expr_repeat1,
  [36826] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(845), 1,
      sym_qualified_identifier,
  [36839] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(846), 1,
      sym_qualified_identifier,
  [36852] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1397), 1,
      anon_sym_COMMA,
    ACTIONS(1400), 1,
      anon_sym_RPAREN,
    STATE(677), 1,
      aux_sym_typed_argument_list_repeat1,
  [36865] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(507), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36878] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1402), 1,
      anon_sym_RBRACK,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [36891] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(849), 1,
      sym_qualified_identifier,
  [36904] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(644), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36917] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(567), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [36930] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1272), 1,
      anon_sym_RBRACE,
    ACTIONS(1404), 1,
      anon_sym_COMMA,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [36943] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1406), 1,
      anon_sym_RPAREN,
    STATE(665), 1,
      aux_sym_operator_type_repeat1,
  [36956] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(839), 1,
      sym_qualified_identifier,
  [36969] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(654), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36982] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(484), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [36995] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(811), 1,
      sym_qualified_identifier,
  [37008] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1408), 1,
      anon_sym_EQ,
  [37021] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(544), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [37034] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1410), 1,
      anon_sym_COMMA,
    ACTIONS(1413), 1,
      anon_sym_RBRACE,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [37047] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(645), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37060] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(788), 1,
      sym_qualified_identifier,
  [37073] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(780), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37086] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_COMMA,
    ACTIONS(1415), 1,
      anon_sym_RBRACK,
    STATE(672), 1,
      aux_sym_type_alias_repeat1,
  [37099] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1417), 1,
      anon_sym_EQ,
  [37112] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1419), 1,
      anon_sym_EQ,
  [37125] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(760), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37138] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1421), 1,
      anon_sym_EQ,
  [37151] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1423), 1,
      anon_sym_RPAREN,
    STATE(665), 1,
      aux_sym_operator_type_repeat1,
  [37164] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1425), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37177] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1427), 1,
      anon_sym_RBRACK,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37190] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1429), 1,
      anon_sym_COMMA,
    ACTIONS(1431), 1,
      anon_sym_RBRACE,
    STATE(713), 1,
      aux_sym_record_literal_repeat1,
  [37203] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1288), 1,
      anon_sym_COMMA,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
    STATE(677), 1,
      aux_sym_typed_argument_list_repeat1,
  [37216] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1355), 1,
      anon_sym_RBRACE,
    ACTIONS(1435), 1,
      anon_sym_COMMA,
    STATE(743), 1,
      aux_sym_record_type_repeat1,
  [37229] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      aux_sym_import_segment_arguments_repeat1,
  [37242] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1439), 1,
      anon_sym_EQ,
  [37255] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(650), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37268] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
  [37281] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(838), 1,
      sym_qualified_identifier,
  [37294] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1443), 1,
      anon_sym_EQ,
  [37307] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1445), 1,
      anon_sym_RBRACK,
    STATE(665), 1,
      aux_sym_operator_type_repeat1,
  [37320] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(917), 1,
      anon_sym_COMMA,
    ACTIONS(919), 1,
      anon_sym_RBRACE,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [37333] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1260), 1,
      anon_sym_COMMA,
    ACTIONS(1447), 1,
      anon_sym_RBRACK,
    STATE(665), 1,
      aux_sym_operator_type_repeat1,
  [37346] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(139), 1,
      anon_sym_RBRACE,
    ACTIONS(1449), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37359] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(137), 1,
      anon_sym_RBRACE,
    ACTIONS(1451), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37372] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1453), 1,
      anon_sym_RPAREN,
  [37385] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(135), 1,
      anon_sym_RBRACE,
    ACTIONS(1455), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37398] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(133), 1,
      anon_sym_RBRACE,
    ACTIONS(1457), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37411] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1459), 1,
      anon_sym_RBRACE,
    STATE(733), 1,
      aux_sym_match_expr_repeat1,
  [37424] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1461), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37437] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(825), 1,
      anon_sym_COMMA,
    ACTIONS(1463), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      aux_sym_import_segment_arguments_repeat1,
  [37450] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_COMMA,
    ACTIONS(1465), 1,
      anon_sym_RBRACK,
    STATE(672), 1,
      aux_sym_type_alias_repeat1,
  [37463] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1313), 1,
      anon_sym_RBRACE,
    ACTIONS(1467), 1,
      anon_sym_COMMA,
    STATE(743), 1,
      aux_sym_record_type_repeat1,
  [37476] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1395), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37489] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1292), 1,
      anon_sym_RBRACE,
    ACTIONS(1469), 1,
      anon_sym_COMMA,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [37502] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(550), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [37515] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(765), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37528] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1217), 1,
      sym_identifier,
    STATE(541), 1,
      sym_qualified_identifier,
    STATE(783), 1,
      aux_sym_qualified_identifier_repeat1,
  [37541] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(703), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37554] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1389), 1,
      anon_sym_COMMA,
    ACTIONS(1471), 1,
      anon_sym_RBRACK,
    STATE(723), 1,
      aux_sym_type_alias_repeat1,
  [37567] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1473), 1,
      anon_sym_RBRACE,
    STATE(736), 1,
      aux_sym_match_expr_repeat1,
  [37580] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1473), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37593] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(528), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37606] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(841), 1,
      sym_qualified_identifier,
  [37619] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1475), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37632] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(494), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37645] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1477), 1,
      anon_sym_COMMA,
    ACTIONS(1480), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      aux_sym_import_segment_arguments_repeat1,
  [37658] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(664), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37671] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(785), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [37684] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(847), 1,
      sym_qualified_identifier,
  [37697] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
    STATE(848), 1,
      sym_qualified_identifier,
  [37710] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1482), 1,
      anon_sym_COMMA,
    ACTIONS(1485), 1,
      anon_sym_RBRACE,
    STATE(743), 1,
      aux_sym_record_type_repeat1,
  [37723] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1288), 1,
      anon_sym_COMMA,
    ACTIONS(1487), 1,
      anon_sym_RPAREN,
    STATE(677), 1,
      aux_sym_typed_argument_list_repeat1,
  [37736] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1489), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37749] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1491), 1,
      anon_sym_EQ,
  [37762] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1493), 1,
      anon_sym_PIPE,
    ACTIONS(1496), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37775] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1498), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37788] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1500), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [37801] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1502), 1,
      anon_sym_EQ,
  [37814] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1504), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37827] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1506), 1,
      anon_sym_RBRACE,
    STATE(725), 1,
      aux_sym_match_expr_repeat1,
  [37840] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1500), 1,
      anon_sym_RBRACE,
    STATE(745), 1,
      aux_sym_match_expr_repeat1,
  [37853] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(871), 1,
      anon_sym_COMMA,
    ACTIONS(873), 1,
      anon_sym_RBRACE,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [37866] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1282), 1,
      anon_sym_RBRACE,
    ACTIONS(1508), 1,
      anon_sym_COMMA,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [37879] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1510), 1,
      anon_sym_EQ,
  [37892] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1512), 1,
      anon_sym_EQ,
  [37905] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1514), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37918] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1516), 1,
      anon_sym_RBRACK,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37931] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1518), 1,
      anon_sym_COMMA,
    ACTIONS(1520), 1,
      anon_sym_RBRACE,
    STATE(770), 1,
      aux_sym_record_literal_repeat1,
  [37944] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(821), 1,
      anon_sym_COMMA,
    ACTIONS(1522), 1,
      anon_sym_RPAREN,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37957] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(89), 1,
      anon_sym_RBRACE,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37970] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1526), 1,
      anon_sym_COLON,
    ACTIONS(1400), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [37981] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(83), 1,
      anon_sym_RBRACE,
    ACTIONS(1528), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [37994] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1530), 1,
      anon_sym_COMMA,
    ACTIONS(1532), 1,
      anon_sym_RBRACE,
    STATE(754), 1,
      aux_sym_record_literal_repeat1,
  [38007] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(81), 1,
      anon_sym_RBRACE,
    ACTIONS(1534), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38020] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1536), 1,
      anon_sym_EQ,
  [38033] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(833), 1,
      anon_sym_DASH_GT,
    ACTIONS(835), 1,
      anon_sym_EQ_GT,
    ACTIONS(1538), 1,
      anon_sym_EQ,
  [38046] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1540), 1,
      anon_sym_RBRACE,
    STATE(747), 1,
      aux_sym_match_expr_repeat1,
  [38059] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(863), 1,
      anon_sym_COMMA,
    ACTIONS(865), 1,
      anon_sym_RBRACE,
    STATE(691), 1,
      aux_sym_record_literal_repeat1,
  [38072] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(131), 1,
      anon_sym_RBRACE,
    ACTIONS(1542), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38085] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1393), 1,
      anon_sym_PIPE,
    ACTIONS(1544), 1,
      anon_sym_RBRACE,
    STATE(749), 1,
      aux_sym_match_expr_repeat1,
  [38098] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(103), 1,
      anon_sym_RBRACE,
    ACTIONS(1546), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38111] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(97), 1,
      anon_sym_RBRACE,
    ACTIONS(1548), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38124] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(101), 1,
      anon_sym_RBRACE,
    ACTIONS(1550), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38137] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1225), 1,
      sym_identifier,
    STATE(671), 1,
      sym_qualified_identifier,
    STATE(786), 1,
      aux_sym_qualified_identifier_repeat1,
  [38150] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(99), 1,
      anon_sym_RBRACE,
    ACTIONS(1552), 1,
      anon_sym_COMMA,
    STATE(609), 1,
      aux_sym_lambda_expr_repeat1,
  [38163] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1554), 1,
      anon_sym_COLON,
    ACTIONS(1556), 1,
      anon_sym_EQ,
  [38173] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1496), 2,
      anon_sym_PIPE,
      anon_sym_RBRACE,
  [38181] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1558), 1,
      anon_sym_LBRACK,
    ACTIONS(1560), 1,
      anon_sym_EQ,
  [38191] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1562), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [38199] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    STATE(526), 1,
      sym_string,
  [38209] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1564), 1,
      sym_identifier,
    STATE(810), 1,
      aux_sym_qualified_identifier_repeat1,
  [38219] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1566), 2,
      anon_sym_val,
      anon_sym_def,
  [38227] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1568), 1,
      anon_sym_LBRACK,
    ACTIONS(1570), 1,
      anon_sym_EQ,
  [38237] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1572), 1,
      sym_identifier,
    STATE(810), 1,
      aux_sym_qualified_identifier_repeat1,
  [38247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1574), 1,
      anon_sym_COLON,
    ACTIONS(1576), 1,
      anon_sym_EQ,
  [38257] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1578), 2,
      anon_sym_COMMA,
      anon_sym_RBRACE,
  [38265] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1580), 1,
      anon_sym_LPAREN,
    ACTIONS(1582), 1,
      anon_sym_EQ_GT,
  [38275] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1584), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [38283] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1586), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [38291] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1588), 1,
      anon_sym_COLON,
    ACTIONS(1590), 1,
      anon_sym_EQ,
  [38301] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1592), 1,
      anon_sym_COLON,
    ACTIONS(1594), 1,
      anon_sym_EQ,
  [38311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    STATE(560), 1,
      sym_string,
  [38321] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    STATE(506), 1,
      sym_string,
  [38331] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1596), 2,
      anon_sym_val,
      anon_sym_def,
  [38339] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1598), 1,
      sym_identifier,
    STATE(810), 1,
      aux_sym_qualified_identifier_repeat1,
  [38349] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1600), 1,
      anon_sym_COLON,
    ACTIONS(1602), 1,
      anon_sym_EQ,
  [38359] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    STATE(527), 1,
      sym_string,
  [38369] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    STATE(559), 1,
      sym_string,
  [38379] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1604), 2,
      anon_sym_val,
      anon_sym_def,
  [38387] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      anon_sym_DQUOTE,
    STATE(514), 1,
      sym_string,
  [38397] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    STATE(551), 1,
      sym_string,
  [38407] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1387), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [38415] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1606), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [38423] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(29), 1,
      anon_sym_DQUOTE,
    STATE(564), 1,
      sym_string,
  [38433] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1608), 2,
      anon_sym_COLON,
      anon_sym_EQ,
  [38441] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1610), 1,
      anon_sym_COLON,
    ACTIONS(1612), 1,
      anon_sym_EQ,
  [38451] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1614), 1,
      sym_identifier,
    ACTIONS(1616), 1,
      anon_sym_RPAREN,
  [38461] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1618), 1,
      sym_identifier,
    STATE(810), 1,
      aux_sym_qualified_identifier_repeat1,
  [38471] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1621), 1,
      anon_sym_EQ,
  [38478] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1623), 1,
      sym_identifier,
  [38485] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1625), 1,
      anon_sym_COLON,
  [38492] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1627), 1,
      anon_sym_LBRACE,
  [38499] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1629), 1,
      anon_sym_LBRACE,
  [38506] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1631), 1,
      anon_sym_EQ,
  [38513] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1633), 1,
      ts_builtin_sym_end,
  [38520] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1635), 1,
      anon_sym_EQ,
  [38527] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1637), 1,
      sym_identifier,
  [38534] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1639), 1,
      anon_sym_EQ,
  [38541] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1641), 1,
      anon_sym_EQ_GT,
  [38548] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1643), 1,
      anon_sym_LBRACE,
  [38555] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1645), 1,
      anon_sym_LBRACE,
  [38562] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1647), 1,
      anon_sym_LBRACE,
  [38569] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1649), 1,
      anon_sym_LBRACE,
  [38576] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1651), 1,
      anon_sym_LBRACE,
  [38583] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1653), 1,
      anon_sym_LBRACE,
  [38590] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1655), 1,
      sym_identifier,
  [38597] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1657), 1,
      anon_sym_EQ,
  [38604] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1659), 1,
      anon_sym_EQ,
  [38611] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1661), 1,
      anon_sym_EQ,
  [38618] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1663), 1,
      anon_sym_LBRACE,
  [38625] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1665), 1,
      anon_sym_LBRACE,
  [38632] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1667), 1,
      anon_sym_COLON,
  [38639] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1669), 1,
      anon_sym_LBRACE,
  [38646] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1671), 1,
      anon_sym_LBRACE,
  [38653] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1673), 1,
      anon_sym_LPAREN,
  [38660] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1675), 1,
      anon_sym_EQ,
  [38667] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1677), 1,
      anon_sym_COLON,
  [38674] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1679), 1,
      sym_identifier,
  [38681] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1681), 1,
      anon_sym_COLON,
  [38688] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1683), 1,
      anon_sym_EQ,
  [38695] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1685), 1,
      anon_sym_COLON,
  [38702] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1687), 1,
      sym_identifier,
  [38709] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1689), 1,
      anon_sym_LBRACE,
  [38716] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1691), 1,
      anon_sym_COLON,
  [38723] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1693), 1,
      anon_sym_COLON,
  [38730] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1695), 1,
      anon_sym_COLON,
  [38737] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1697), 1,
      anon_sym_EQ,
  [38744] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1699), 1,
      anon_sym_EQ,
  [38751] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1701), 1,
      anon_sym_EQ,
  [38758] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(217), 1,
      anon_sym_COLON_COLON,
  [38765] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1703), 1,
      anon_sym_LPAREN,
  [38772] = 2,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(1705), 1,
      anon_sym_LPAREN,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 104,
  [SMALL_STATE(4)] = 208,
  [SMALL_STATE(5)] = 312,
  [SMALL_STATE(6)] = 416,
  [SMALL_STATE(7)] = 520,
  [SMALL_STATE(8)] = 624,
  [SMALL_STATE(9)] = 728,
  [SMALL_STATE(10)] = 832,
  [SMALL_STATE(11)] = 936,
  [SMALL_STATE(12)] = 1040,
  [SMALL_STATE(13)] = 1144,
  [SMALL_STATE(14)] = 1248,
  [SMALL_STATE(15)] = 1352,
  [SMALL_STATE(16)] = 1456,
  [SMALL_STATE(17)] = 1560,
  [SMALL_STATE(18)] = 1664,
  [SMALL_STATE(19)] = 1768,
  [SMALL_STATE(20)] = 1872,
  [SMALL_STATE(21)] = 1976,
  [SMALL_STATE(22)] = 2080,
  [SMALL_STATE(23)] = 2184,
  [SMALL_STATE(24)] = 2288,
  [SMALL_STATE(25)] = 2392,
  [SMALL_STATE(26)] = 2496,
  [SMALL_STATE(27)] = 2600,
  [SMALL_STATE(28)] = 2704,
  [SMALL_STATE(29)] = 2808,
  [SMALL_STATE(30)] = 2912,
  [SMALL_STATE(31)] = 3016,
  [SMALL_STATE(32)] = 3120,
  [SMALL_STATE(33)] = 3224,
  [SMALL_STATE(34)] = 3328,
  [SMALL_STATE(35)] = 3432,
  [SMALL_STATE(36)] = 3536,
  [SMALL_STATE(37)] = 3640,
  [SMALL_STATE(38)] = 3744,
  [SMALL_STATE(39)] = 3848,
  [SMALL_STATE(40)] = 3952,
  [SMALL_STATE(41)] = 4056,
  [SMALL_STATE(42)] = 4160,
  [SMALL_STATE(43)] = 4264,
  [SMALL_STATE(44)] = 4368,
  [SMALL_STATE(45)] = 4472,
  [SMALL_STATE(46)] = 4576,
  [SMALL_STATE(47)] = 4680,
  [SMALL_STATE(48)] = 4784,
  [SMALL_STATE(49)] = 4888,
  [SMALL_STATE(50)] = 4992,
  [SMALL_STATE(51)] = 5093,
  [SMALL_STATE(52)] = 5194,
  [SMALL_STATE(53)] = 5295,
  [SMALL_STATE(54)] = 5396,
  [SMALL_STATE(55)] = 5497,
  [SMALL_STATE(56)] = 5598,
  [SMALL_STATE(57)] = 5699,
  [SMALL_STATE(58)] = 5800,
  [SMALL_STATE(59)] = 5901,
  [SMALL_STATE(60)] = 6002,
  [SMALL_STATE(61)] = 6103,
  [SMALL_STATE(62)] = 6204,
  [SMALL_STATE(63)] = 6305,
  [SMALL_STATE(64)] = 6406,
  [SMALL_STATE(65)] = 6507,
  [SMALL_STATE(66)] = 6608,
  [SMALL_STATE(67)] = 6709,
  [SMALL_STATE(68)] = 6810,
  [SMALL_STATE(69)] = 6911,
  [SMALL_STATE(70)] = 7012,
  [SMALL_STATE(71)] = 7113,
  [SMALL_STATE(72)] = 7214,
  [SMALL_STATE(73)] = 7315,
  [SMALL_STATE(74)] = 7416,
  [SMALL_STATE(75)] = 7517,
  [SMALL_STATE(76)] = 7618,
  [SMALL_STATE(77)] = 7719,
  [SMALL_STATE(78)] = 7820,
  [SMALL_STATE(79)] = 7921,
  [SMALL_STATE(80)] = 8022,
  [SMALL_STATE(81)] = 8123,
  [SMALL_STATE(82)] = 8224,
  [SMALL_STATE(83)] = 8325,
  [SMALL_STATE(84)] = 8426,
  [SMALL_STATE(85)] = 8527,
  [SMALL_STATE(86)] = 8628,
  [SMALL_STATE(87)] = 8729,
  [SMALL_STATE(88)] = 8830,
  [SMALL_STATE(89)] = 8931,
  [SMALL_STATE(90)] = 9032,
  [SMALL_STATE(91)] = 9133,
  [SMALL_STATE(92)] = 9234,
  [SMALL_STATE(93)] = 9335,
  [SMALL_STATE(94)] = 9436,
  [SMALL_STATE(95)] = 9537,
  [SMALL_STATE(96)] = 9638,
  [SMALL_STATE(97)] = 9739,
  [SMALL_STATE(98)] = 9840,
  [SMALL_STATE(99)] = 9941,
  [SMALL_STATE(100)] = 10042,
  [SMALL_STATE(101)] = 10143,
  [SMALL_STATE(102)] = 10244,
  [SMALL_STATE(103)] = 10345,
  [SMALL_STATE(104)] = 10446,
  [SMALL_STATE(105)] = 10547,
  [SMALL_STATE(106)] = 10648,
  [SMALL_STATE(107)] = 10749,
  [SMALL_STATE(108)] = 10850,
  [SMALL_STATE(109)] = 10951,
  [SMALL_STATE(110)] = 11052,
  [SMALL_STATE(111)] = 11153,
  [SMALL_STATE(112)] = 11254,
  [SMALL_STATE(113)] = 11355,
  [SMALL_STATE(114)] = 11456,
  [SMALL_STATE(115)] = 11557,
  [SMALL_STATE(116)] = 11658,
  [SMALL_STATE(117)] = 11759,
  [SMALL_STATE(118)] = 11860,
  [SMALL_STATE(119)] = 11961,
  [SMALL_STATE(120)] = 12062,
  [SMALL_STATE(121)] = 12163,
  [SMALL_STATE(122)] = 12264,
  [SMALL_STATE(123)] = 12365,
  [SMALL_STATE(124)] = 12466,
  [SMALL_STATE(125)] = 12567,
  [SMALL_STATE(126)] = 12668,
  [SMALL_STATE(127)] = 12769,
  [SMALL_STATE(128)] = 12870,
  [SMALL_STATE(129)] = 12971,
  [SMALL_STATE(130)] = 13072,
  [SMALL_STATE(131)] = 13173,
  [SMALL_STATE(132)] = 13274,
  [SMALL_STATE(133)] = 13375,
  [SMALL_STATE(134)] = 13476,
  [SMALL_STATE(135)] = 13577,
  [SMALL_STATE(136)] = 13678,
  [SMALL_STATE(137)] = 13779,
  [SMALL_STATE(138)] = 13880,
  [SMALL_STATE(139)] = 13981,
  [SMALL_STATE(140)] = 14082,
  [SMALL_STATE(141)] = 14183,
  [SMALL_STATE(142)] = 14284,
  [SMALL_STATE(143)] = 14385,
  [SMALL_STATE(144)] = 14486,
  [SMALL_STATE(145)] = 14587,
  [SMALL_STATE(146)] = 14688,
  [SMALL_STATE(147)] = 14789,
  [SMALL_STATE(148)] = 14890,
  [SMALL_STATE(149)] = 14991,
  [SMALL_STATE(150)] = 15092,
  [SMALL_STATE(151)] = 15152,
  [SMALL_STATE(152)] = 15212,
  [SMALL_STATE(153)] = 15269,
  [SMALL_STATE(154)] = 15325,
  [SMALL_STATE(155)] = 15382,
  [SMALL_STATE(156)] = 15438,
  [SMALL_STATE(157)] = 15491,
  [SMALL_STATE(158)] = 15544,
  [SMALL_STATE(159)] = 15597,
  [SMALL_STATE(160)] = 15650,
  [SMALL_STATE(161)] = 15703,
  [SMALL_STATE(162)] = 15753,
  [SMALL_STATE(163)] = 15835,
  [SMALL_STATE(164)] = 15915,
  [SMALL_STATE(165)] = 15965,
  [SMALL_STATE(166)] = 16019,
  [SMALL_STATE(167)] = 16071,
  [SMALL_STATE(168)] = 16121,
  [SMALL_STATE(169)] = 16171,
  [SMALL_STATE(170)] = 16221,
  [SMALL_STATE(171)] = 16271,
  [SMALL_STATE(172)] = 16321,
  [SMALL_STATE(173)] = 16403,
  [SMALL_STATE(174)] = 16485,
  [SMALL_STATE(175)] = 16535,
  [SMALL_STATE(176)] = 16615,
  [SMALL_STATE(177)] = 16665,
  [SMALL_STATE(178)] = 16715,
  [SMALL_STATE(179)] = 16765,
  [SMALL_STATE(180)] = 16815,
  [SMALL_STATE(181)] = 16867,
  [SMALL_STATE(182)] = 16917,
  [SMALL_STATE(183)] = 16967,
  [SMALL_STATE(184)] = 17017,
  [SMALL_STATE(185)] = 17067,
  [SMALL_STATE(186)] = 17145,
  [SMALL_STATE(187)] = 17197,
  [SMALL_STATE(188)] = 17249,
  [SMALL_STATE(189)] = 17299,
  [SMALL_STATE(190)] = 17351,
  [SMALL_STATE(191)] = 17401,
  [SMALL_STATE(192)] = 17457,
  [SMALL_STATE(193)] = 17517,
  [SMALL_STATE(194)] = 17573,
  [SMALL_STATE(195)] = 17637,
  [SMALL_STATE(196)] = 17707,
  [SMALL_STATE(197)] = 17779,
  [SMALL_STATE(198)] = 17853,
  [SMALL_STATE(199)] = 17929,
  [SMALL_STATE(200)] = 18011,
  [SMALL_STATE(201)] = 18093,
  [SMALL_STATE(202)] = 18173,
  [SMALL_STATE(203)] = 18223,
  [SMALL_STATE(204)] = 18275,
  [SMALL_STATE(205)] = 18325,
  [SMALL_STATE(206)] = 18375,
  [SMALL_STATE(207)] = 18425,
  [SMALL_STATE(208)] = 18475,
  [SMALL_STATE(209)] = 18527,
  [SMALL_STATE(210)] = 18577,
  [SMALL_STATE(211)] = 18627,
  [SMALL_STATE(212)] = 18677,
  [SMALL_STATE(213)] = 18727,
  [SMALL_STATE(214)] = 18795,
  [SMALL_STATE(215)] = 18877,
  [SMALL_STATE(216)] = 18959,
  [SMALL_STATE(217)] = 19039,
  [SMALL_STATE(218)] = 19089,
  [SMALL_STATE(219)] = 19139,
  [SMALL_STATE(220)] = 19189,
  [SMALL_STATE(221)] = 19239,
  [SMALL_STATE(222)] = 19289,
  [SMALL_STATE(223)] = 19339,
  [SMALL_STATE(224)] = 19389,
  [SMALL_STATE(225)] = 19471,
  [SMALL_STATE(226)] = 19551,
  [SMALL_STATE(227)] = 19601,
  [SMALL_STATE(228)] = 19651,
  [SMALL_STATE(229)] = 19701,
  [SMALL_STATE(230)] = 19751,
  [SMALL_STATE(231)] = 19801,
  [SMALL_STATE(232)] = 19851,
  [SMALL_STATE(233)] = 19931,
  [SMALL_STATE(234)] = 19984,
  [SMALL_STATE(235)] = 20033,
  [SMALL_STATE(236)] = 20082,
  [SMALL_STATE(237)] = 20131,
  [SMALL_STATE(238)] = 20180,
  [SMALL_STATE(239)] = 20257,
  [SMALL_STATE(240)] = 20306,
  [SMALL_STATE(241)] = 20355,
  [SMALL_STATE(242)] = 20404,
  [SMALL_STATE(243)] = 20453,
  [SMALL_STATE(244)] = 20502,
  [SMALL_STATE(245)] = 20551,
  [SMALL_STATE(246)] = 20600,
  [SMALL_STATE(247)] = 20665,
  [SMALL_STATE(248)] = 20714,
  [SMALL_STATE(249)] = 20763,
  [SMALL_STATE(250)] = 20812,
  [SMALL_STATE(251)] = 20861,
  [SMALL_STATE(252)] = 20910,
  [SMALL_STATE(253)] = 20959,
  [SMALL_STATE(254)] = 21008,
  [SMALL_STATE(255)] = 21057,
  [SMALL_STATE(256)] = 21134,
  [SMALL_STATE(257)] = 21183,
  [SMALL_STATE(258)] = 21232,
  [SMALL_STATE(259)] = 21281,
  [SMALL_STATE(260)] = 21330,
  [SMALL_STATE(261)] = 21407,
  [SMALL_STATE(262)] = 21484,
  [SMALL_STATE(263)] = 21557,
  [SMALL_STATE(264)] = 21606,
  [SMALL_STATE(265)] = 21677,
  [SMALL_STATE(266)] = 21746,
  [SMALL_STATE(267)] = 21823,
  [SMALL_STATE(268)] = 21890,
  [SMALL_STATE(269)] = 21953,
  [SMALL_STATE(270)] = 22008,
  [SMALL_STATE(271)] = 22057,
  [SMALL_STATE(272)] = 22116,
  [SMALL_STATE(273)] = 22171,
  [SMALL_STATE(274)] = 22220,
  [SMALL_STATE(275)] = 22269,
  [SMALL_STATE(276)] = 22318,
  [SMALL_STATE(277)] = 22367,
  [SMALL_STATE(278)] = 22416,
  [SMALL_STATE(279)] = 22465,
  [SMALL_STATE(280)] = 22514,
  [SMALL_STATE(281)] = 22563,
  [SMALL_STATE(282)] = 22612,
  [SMALL_STATE(283)] = 22687,
  [SMALL_STATE(284)] = 22736,
  [SMALL_STATE(285)] = 22813,
  [SMALL_STATE(286)] = 22862,
  [SMALL_STATE(287)] = 22911,
  [SMALL_STATE(288)] = 22960,
  [SMALL_STATE(289)] = 23009,
  [SMALL_STATE(290)] = 23058,
  [SMALL_STATE(291)] = 23110,
  [SMALL_STATE(292)] = 23158,
  [SMALL_STATE(293)] = 23206,
  [SMALL_STATE(294)] = 23254,
  [SMALL_STATE(295)] = 23302,
  [SMALL_STATE(296)] = 23350,
  [SMALL_STATE(297)] = 23395,
  [SMALL_STATE(298)] = 23440,
  [SMALL_STATE(299)] = 23515,
  [SMALL_STATE(300)] = 23560,
  [SMALL_STATE(301)] = 23605,
  [SMALL_STATE(302)] = 23680,
  [SMALL_STATE(303)] = 23725,
  [SMALL_STATE(304)] = 23798,
  [SMALL_STATE(305)] = 23843,
  [SMALL_STATE(306)] = 23898,
  [SMALL_STATE(307)] = 23949,
  [SMALL_STATE(308)] = 23994,
  [SMALL_STATE(309)] = 24053,
  [SMALL_STATE(310)] = 24098,
  [SMALL_STATE(311)] = 24173,
  [SMALL_STATE(312)] = 24218,
  [SMALL_STATE(313)] = 24263,
  [SMALL_STATE(314)] = 24308,
  [SMALL_STATE(315)] = 24381,
  [SMALL_STATE(316)] = 24444,
  [SMALL_STATE(317)] = 24489,
  [SMALL_STATE(318)] = 24534,
  [SMALL_STATE(319)] = 24583,
  [SMALL_STATE(320)] = 24628,
  [SMALL_STATE(321)] = 24673,
  [SMALL_STATE(322)] = 24718,
  [SMALL_STATE(323)] = 24763,
  [SMALL_STATE(324)] = 24828,
  [SMALL_STATE(325)] = 24903,
  [SMALL_STATE(326)] = 24948,
  [SMALL_STATE(327)] = 24993,
  [SMALL_STATE(328)] = 25038,
  [SMALL_STATE(329)] = 25083,
  [SMALL_STATE(330)] = 25150,
  [SMALL_STATE(331)] = 25195,
  [SMALL_STATE(332)] = 25240,
  [SMALL_STATE(333)] = 25313,
  [SMALL_STATE(334)] = 25358,
  [SMALL_STATE(335)] = 25429,
  [SMALL_STATE(336)] = 25498,
  [SMALL_STATE(337)] = 25543,
  [SMALL_STATE(338)] = 25618,
  [SMALL_STATE(339)] = 25691,
  [SMALL_STATE(340)] = 25736,
  [SMALL_STATE(341)] = 25811,
  [SMALL_STATE(342)] = 25856,
  [SMALL_STATE(343)] = 25901,
  [SMALL_STATE(344)] = 25946,
  [SMALL_STATE(345)] = 25991,
  [SMALL_STATE(346)] = 26036,
  [SMALL_STATE(347)] = 26081,
  [SMALL_STATE(348)] = 26126,
  [SMALL_STATE(349)] = 26171,
  [SMALL_STATE(350)] = 26216,
  [SMALL_STATE(351)] = 26261,
  [SMALL_STATE(352)] = 26334,
  [SMALL_STATE(353)] = 26385,
  [SMALL_STATE(354)] = 26430,
  [SMALL_STATE(355)] = 26475,
  [SMALL_STATE(356)] = 26520,
  [SMALL_STATE(357)] = 26593,
  [SMALL_STATE(358)] = 26668,
  [SMALL_STATE(359)] = 26743,
  [SMALL_STATE(360)] = 26788,
  [SMALL_STATE(361)] = 26849,
  [SMALL_STATE(362)] = 26921,
  [SMALL_STATE(363)] = 26994,
  [SMALL_STATE(364)] = 27067,
  [SMALL_STATE(365)] = 27140,
  [SMALL_STATE(366)] = 27213,
  [SMALL_STATE(367)] = 27286,
  [SMALL_STATE(368)] = 27359,
  [SMALL_STATE(369)] = 27432,
  [SMALL_STATE(370)] = 27505,
  [SMALL_STATE(371)] = 27575,
  [SMALL_STATE(372)] = 27629,
  [SMALL_STATE(373)] = 27683,
  [SMALL_STATE(374)] = 27716,
  [SMALL_STATE(375)] = 27749,
  [SMALL_STATE(376)] = 27782,
  [SMALL_STATE(377)] = 27815,
  [SMALL_STATE(378)] = 27848,
  [SMALL_STATE(379)] = 27881,
  [SMALL_STATE(380)] = 27914,
  [SMALL_STATE(381)] = 27947,
  [SMALL_STATE(382)] = 28007,
  [SMALL_STATE(383)] = 28041,
  [SMALL_STATE(384)] = 28072,
  [SMALL_STATE(385)] = 28135,
  [SMALL_STATE(386)] = 28198,
  [SMALL_STATE(387)] = 28233,
  [SMALL_STATE(388)] = 28268,
  [SMALL_STATE(389)] = 28331,
  [SMALL_STATE(390)] = 28364,
  [SMALL_STATE(391)] = 28399,
  [SMALL_STATE(392)] = 28432,
  [SMALL_STATE(393)] = 28495,
  [SMALL_STATE(394)] = 28526,
  [SMALL_STATE(395)] = 28589,
  [SMALL_STATE(396)] = 28652,
  [SMALL_STATE(397)] = 28687,
  [SMALL_STATE(398)] = 28750,
  [SMALL_STATE(399)] = 28781,
  [SMALL_STATE(400)] = 28812,
  [SMALL_STATE(401)] = 28875,
  [SMALL_STATE(402)] = 28938,
  [SMALL_STATE(403)] = 28973,
  [SMALL_STATE(404)] = 29036,
  [SMALL_STATE(405)] = 29099,
  [SMALL_STATE(406)] = 29130,
  [SMALL_STATE(407)] = 29193,
  [SMALL_STATE(408)] = 29256,
  [SMALL_STATE(409)] = 29319,
  [SMALL_STATE(410)] = 29382,
  [SMALL_STATE(411)] = 29445,
  [SMALL_STATE(412)] = 29508,
  [SMALL_STATE(413)] = 29541,
  [SMALL_STATE(414)] = 29604,
  [SMALL_STATE(415)] = 29667,
  [SMALL_STATE(416)] = 29730,
  [SMALL_STATE(417)] = 29793,
  [SMALL_STATE(418)] = 29828,
  [SMALL_STATE(419)] = 29863,
  [SMALL_STATE(420)] = 29896,
  [SMALL_STATE(421)] = 29927,
  [SMALL_STATE(422)] = 29990,
  [SMALL_STATE(423)] = 30053,
  [SMALL_STATE(424)] = 30084,
  [SMALL_STATE(425)] = 30147,
  [SMALL_STATE(426)] = 30210,
  [SMALL_STATE(427)] = 30273,
  [SMALL_STATE(428)] = 30319,
  [SMALL_STATE(429)] = 30377,
  [SMALL_STATE(430)] = 30423,
  [SMALL_STATE(431)] = 30481,
  [SMALL_STATE(432)] = 30539,
  [SMALL_STATE(433)] = 30585,
  [SMALL_STATE(434)] = 30643,
  [SMALL_STATE(435)] = 30700,
  [SMALL_STATE(436)] = 30757,
  [SMALL_STATE(437)] = 30814,
  [SMALL_STATE(438)] = 30871,
  [SMALL_STATE(439)] = 30928,
  [SMALL_STATE(440)] = 30985,
  [SMALL_STATE(441)] = 31042,
  [SMALL_STATE(442)] = 31099,
  [SMALL_STATE(443)] = 31132,
  [SMALL_STATE(444)] = 31189,
  [SMALL_STATE(445)] = 31246,
  [SMALL_STATE(446)] = 31279,
  [SMALL_STATE(447)] = 31336,
  [SMALL_STATE(448)] = 31393,
  [SMALL_STATE(449)] = 31450,
  [SMALL_STATE(450)] = 31507,
  [SMALL_STATE(451)] = 31564,
  [SMALL_STATE(452)] = 31621,
  [SMALL_STATE(453)] = 31653,
  [SMALL_STATE(454)] = 31687,
  [SMALL_STATE(455)] = 31721,
  [SMALL_STATE(456)] = 31748,
  [SMALL_STATE(457)] = 31779,
  [SMALL_STATE(458)] = 31810,
  [SMALL_STATE(459)] = 31841,
  [SMALL_STATE(460)] = 31868,
  [SMALL_STATE(461)] = 31895,
  [SMALL_STATE(462)] = 31926,
  [SMALL_STATE(463)] = 31953,
  [SMALL_STATE(464)] = 31980,
  [SMALL_STATE(465)] = 32007,
  [SMALL_STATE(466)] = 32038,
  [SMALL_STATE(467)] = 32066,
  [SMALL_STATE(468)] = 32094,
  [SMALL_STATE(469)] = 32122,
  [SMALL_STATE(470)] = 32150,
  [SMALL_STATE(471)] = 32178,
  [SMALL_STATE(472)] = 32206,
  [SMALL_STATE(473)] = 32236,
  [SMALL_STATE(474)] = 32268,
  [SMALL_STATE(475)] = 32296,
  [SMALL_STATE(476)] = 32322,
  [SMALL_STATE(477)] = 32350,
  [SMALL_STATE(478)] = 32378,
  [SMALL_STATE(479)] = 32404,
  [SMALL_STATE(480)] = 32432,
  [SMALL_STATE(481)] = 32464,
  [SMALL_STATE(482)] = 32487,
  [SMALL_STATE(483)] = 32512,
  [SMALL_STATE(484)] = 32541,
  [SMALL_STATE(485)] = 32566,
  [SMALL_STATE(486)] = 32591,
  [SMALL_STATE(487)] = 32614,
  [SMALL_STATE(488)] = 32639,
  [SMALL_STATE(489)] = 32664,
  [SMALL_STATE(490)] = 32693,
  [SMALL_STATE(491)] = 32718,
  [SMALL_STATE(492)] = 32743,
  [SMALL_STATE(493)] = 32768,
  [SMALL_STATE(494)] = 32797,
  [SMALL_STATE(495)] = 32822,
  [SMALL_STATE(496)] = 32848,
  [SMALL_STATE(497)] = 32870,
  [SMALL_STATE(498)] = 32892,
  [SMALL_STATE(499)] = 32914,
  [SMALL_STATE(500)] = 32938,
  [SMALL_STATE(501)] = 32960,
  [SMALL_STATE(502)] = 32986,
  [SMALL_STATE(503)] = 33008,
  [SMALL_STATE(504)] = 33034,
  [SMALL_STATE(505)] = 33056,
  [SMALL_STATE(506)] = 33082,
  [SMALL_STATE(507)] = 33104,
  [SMALL_STATE(508)] = 33126,
  [SMALL_STATE(509)] = 33148,
  [SMALL_STATE(510)] = 33174,
  [SMALL_STATE(511)] = 33196,
  [SMALL_STATE(512)] = 33218,
  [SMALL_STATE(513)] = 33244,
  [SMALL_STATE(514)] = 33266,
  [SMALL_STATE(515)] = 33288,
  [SMALL_STATE(516)] = 33314,
  [SMALL_STATE(517)] = 33340,
  [SMALL_STATE(518)] = 33362,
  [SMALL_STATE(519)] = 33384,
  [SMALL_STATE(520)] = 33406,
  [SMALL_STATE(521)] = 33428,
  [SMALL_STATE(522)] = 33454,
  [SMALL_STATE(523)] = 33478,
  [SMALL_STATE(524)] = 33502,
  [SMALL_STATE(525)] = 33524,
  [SMALL_STATE(526)] = 33550,
  [SMALL_STATE(527)] = 33572,
  [SMALL_STATE(528)] = 33594,
  [SMALL_STATE(529)] = 33616,
  [SMALL_STATE(530)] = 33642,
  [SMALL_STATE(531)] = 33666,
  [SMALL_STATE(532)] = 33692,
  [SMALL_STATE(533)] = 33714,
  [SMALL_STATE(534)] = 33736,
  [SMALL_STATE(535)] = 33762,
  [SMALL_STATE(536)] = 33784,
  [SMALL_STATE(537)] = 33810,
  [SMALL_STATE(538)] = 33834,
  [SMALL_STATE(539)] = 33858,
  [SMALL_STATE(540)] = 33880,
  [SMALL_STATE(541)] = 33902,
  [SMALL_STATE(542)] = 33925,
  [SMALL_STATE(543)] = 33946,
  [SMALL_STATE(544)] = 33967,
  [SMALL_STATE(545)] = 33990,
  [SMALL_STATE(546)] = 34028,
  [SMALL_STATE(547)] = 34048,
  [SMALL_STATE(548)] = 34086,
  [SMALL_STATE(549)] = 34106,
  [SMALL_STATE(550)] = 34144,
  [SMALL_STATE(551)] = 34164,
  [SMALL_STATE(552)] = 34184,
  [SMALL_STATE(553)] = 34222,
  [SMALL_STATE(554)] = 34242,
  [SMALL_STATE(555)] = 34262,
  [SMALL_STATE(556)] = 34282,
  [SMALL_STATE(557)] = 34302,
  [SMALL_STATE(558)] = 34322,
  [SMALL_STATE(559)] = 34342,
  [SMALL_STATE(560)] = 34362,
  [SMALL_STATE(561)] = 34382,
  [SMALL_STATE(562)] = 34420,
  [SMALL_STATE(563)] = 34440,
  [SMALL_STATE(564)] = 34460,
  [SMALL_STATE(565)] = 34480,
  [SMALL_STATE(566)] = 34518,
  [SMALL_STATE(567)] = 34538,
  [SMALL_STATE(568)] = 34558,
  [SMALL_STATE(569)] = 34590,
  [SMALL_STATE(570)] = 34622,
  [SMALL_STATE(571)] = 34651,
  [SMALL_STATE(572)] = 34680,
  [SMALL_STATE(573)] = 34709,
  [SMALL_STATE(574)] = 34738,
  [SMALL_STATE(575)] = 34767,
  [SMALL_STATE(576)] = 34796,
  [SMALL_STATE(577)] = 34825,
  [SMALL_STATE(578)] = 34854,
  [SMALL_STATE(579)] = 34883,
  [SMALL_STATE(580)] = 34912,
  [SMALL_STATE(581)] = 34941,
  [SMALL_STATE(582)] = 34970,
  [SMALL_STATE(583)] = 34999,
  [SMALL_STATE(584)] = 35028,
  [SMALL_STATE(585)] = 35057,
  [SMALL_STATE(586)] = 35086,
  [SMALL_STATE(587)] = 35115,
  [SMALL_STATE(588)] = 35144,
  [SMALL_STATE(589)] = 35173,
  [SMALL_STATE(590)] = 35202,
  [SMALL_STATE(591)] = 35231,
  [SMALL_STATE(592)] = 35260,
  [SMALL_STATE(593)] = 35289,
  [SMALL_STATE(594)] = 35318,
  [SMALL_STATE(595)] = 35347,
  [SMALL_STATE(596)] = 35376,
  [SMALL_STATE(597)] = 35405,
  [SMALL_STATE(598)] = 35434,
  [SMALL_STATE(599)] = 35463,
  [SMALL_STATE(600)] = 35492,
  [SMALL_STATE(601)] = 35521,
  [SMALL_STATE(602)] = 35550,
  [SMALL_STATE(603)] = 35579,
  [SMALL_STATE(604)] = 35608,
  [SMALL_STATE(605)] = 35637,
  [SMALL_STATE(606)] = 35666,
  [SMALL_STATE(607)] = 35688,
  [SMALL_STATE(608)] = 35710,
  [SMALL_STATE(609)] = 35732,
  [SMALL_STATE(610)] = 35747,
  [SMALL_STATE(611)] = 35762,
  [SMALL_STATE(612)] = 35781,
  [SMALL_STATE(613)] = 35800,
  [SMALL_STATE(614)] = 35819,
  [SMALL_STATE(615)] = 35838,
  [SMALL_STATE(616)] = 35857,
  [SMALL_STATE(617)] = 35876,
  [SMALL_STATE(618)] = 35895,
  [SMALL_STATE(619)] = 35914,
  [SMALL_STATE(620)] = 35933,
  [SMALL_STATE(621)] = 35952,
  [SMALL_STATE(622)] = 35971,
  [SMALL_STATE(623)] = 35990,
  [SMALL_STATE(624)] = 36009,
  [SMALL_STATE(625)] = 36028,
  [SMALL_STATE(626)] = 36047,
  [SMALL_STATE(627)] = 36066,
  [SMALL_STATE(628)] = 36085,
  [SMALL_STATE(629)] = 36104,
  [SMALL_STATE(630)] = 36123,
  [SMALL_STATE(631)] = 36142,
  [SMALL_STATE(632)] = 36161,
  [SMALL_STATE(633)] = 36180,
  [SMALL_STATE(634)] = 36199,
  [SMALL_STATE(635)] = 36213,
  [SMALL_STATE(636)] = 36229,
  [SMALL_STATE(637)] = 36245,
  [SMALL_STATE(638)] = 36261,
  [SMALL_STATE(639)] = 36275,
  [SMALL_STATE(640)] = 36291,
  [SMALL_STATE(641)] = 36305,
  [SMALL_STATE(642)] = 36321,
  [SMALL_STATE(643)] = 36337,
  [SMALL_STATE(644)] = 36353,
  [SMALL_STATE(645)] = 36369,
  [SMALL_STATE(646)] = 36385,
  [SMALL_STATE(647)] = 36399,
  [SMALL_STATE(648)] = 36415,
  [SMALL_STATE(649)] = 36431,
  [SMALL_STATE(650)] = 36447,
  [SMALL_STATE(651)] = 36463,
  [SMALL_STATE(652)] = 36479,
  [SMALL_STATE(653)] = 36495,
  [SMALL_STATE(654)] = 36509,
  [SMALL_STATE(655)] = 36525,
  [SMALL_STATE(656)] = 36539,
  [SMALL_STATE(657)] = 36555,
  [SMALL_STATE(658)] = 36571,
  [SMALL_STATE(659)] = 36585,
  [SMALL_STATE(660)] = 36601,
  [SMALL_STATE(661)] = 36617,
  [SMALL_STATE(662)] = 36633,
  [SMALL_STATE(663)] = 36649,
  [SMALL_STATE(664)] = 36665,
  [SMALL_STATE(665)] = 36681,
  [SMALL_STATE(666)] = 36695,
  [SMALL_STATE(667)] = 36709,
  [SMALL_STATE(668)] = 36725,
  [SMALL_STATE(669)] = 36739,
  [SMALL_STATE(670)] = 36755,
  [SMALL_STATE(671)] = 36771,
  [SMALL_STATE(672)] = 36787,
  [SMALL_STATE(673)] = 36800,
  [SMALL_STATE(674)] = 36813,
  [SMALL_STATE(675)] = 36826,
  [SMALL_STATE(676)] = 36839,
  [SMALL_STATE(677)] = 36852,
  [SMALL_STATE(678)] = 36865,
  [SMALL_STATE(679)] = 36878,
  [SMALL_STATE(680)] = 36891,
  [SMALL_STATE(681)] = 36904,
  [SMALL_STATE(682)] = 36917,
  [SMALL_STATE(683)] = 36930,
  [SMALL_STATE(684)] = 36943,
  [SMALL_STATE(685)] = 36956,
  [SMALL_STATE(686)] = 36969,
  [SMALL_STATE(687)] = 36982,
  [SMALL_STATE(688)] = 36995,
  [SMALL_STATE(689)] = 37008,
  [SMALL_STATE(690)] = 37021,
  [SMALL_STATE(691)] = 37034,
  [SMALL_STATE(692)] = 37047,
  [SMALL_STATE(693)] = 37060,
  [SMALL_STATE(694)] = 37073,
  [SMALL_STATE(695)] = 37086,
  [SMALL_STATE(696)] = 37099,
  [SMALL_STATE(697)] = 37112,
  [SMALL_STATE(698)] = 37125,
  [SMALL_STATE(699)] = 37138,
  [SMALL_STATE(700)] = 37151,
  [SMALL_STATE(701)] = 37164,
  [SMALL_STATE(702)] = 37177,
  [SMALL_STATE(703)] = 37190,
  [SMALL_STATE(704)] = 37203,
  [SMALL_STATE(705)] = 37216,
  [SMALL_STATE(706)] = 37229,
  [SMALL_STATE(707)] = 37242,
  [SMALL_STATE(708)] = 37255,
  [SMALL_STATE(709)] = 37268,
  [SMALL_STATE(710)] = 37281,
  [SMALL_STATE(711)] = 37294,
  [SMALL_STATE(712)] = 37307,
  [SMALL_STATE(713)] = 37320,
  [SMALL_STATE(714)] = 37333,
  [SMALL_STATE(715)] = 37346,
  [SMALL_STATE(716)] = 37359,
  [SMALL_STATE(717)] = 37372,
  [SMALL_STATE(718)] = 37385,
  [SMALL_STATE(719)] = 37398,
  [SMALL_STATE(720)] = 37411,
  [SMALL_STATE(721)] = 37424,
  [SMALL_STATE(722)] = 37437,
  [SMALL_STATE(723)] = 37450,
  [SMALL_STATE(724)] = 37463,
  [SMALL_STATE(725)] = 37476,
  [SMALL_STATE(726)] = 37489,
  [SMALL_STATE(727)] = 37502,
  [SMALL_STATE(728)] = 37515,
  [SMALL_STATE(729)] = 37528,
  [SMALL_STATE(730)] = 37541,
  [SMALL_STATE(731)] = 37554,
  [SMALL_STATE(732)] = 37567,
  [SMALL_STATE(733)] = 37580,
  [SMALL_STATE(734)] = 37593,
  [SMALL_STATE(735)] = 37606,
  [SMALL_STATE(736)] = 37619,
  [SMALL_STATE(737)] = 37632,
  [SMALL_STATE(738)] = 37645,
  [SMALL_STATE(739)] = 37658,
  [SMALL_STATE(740)] = 37671,
  [SMALL_STATE(741)] = 37684,
  [SMALL_STATE(742)] = 37697,
  [SMALL_STATE(743)] = 37710,
  [SMALL_STATE(744)] = 37723,
  [SMALL_STATE(745)] = 37736,
  [SMALL_STATE(746)] = 37749,
  [SMALL_STATE(747)] = 37762,
  [SMALL_STATE(748)] = 37775,
  [SMALL_STATE(749)] = 37788,
  [SMALL_STATE(750)] = 37801,
  [SMALL_STATE(751)] = 37814,
  [SMALL_STATE(752)] = 37827,
  [SMALL_STATE(753)] = 37840,
  [SMALL_STATE(754)] = 37853,
  [SMALL_STATE(755)] = 37866,
  [SMALL_STATE(756)] = 37879,
  [SMALL_STATE(757)] = 37892,
  [SMALL_STATE(758)] = 37905,
  [SMALL_STATE(759)] = 37918,
  [SMALL_STATE(760)] = 37931,
  [SMALL_STATE(761)] = 37944,
  [SMALL_STATE(762)] = 37957,
  [SMALL_STATE(763)] = 37970,
  [SMALL_STATE(764)] = 37981,
  [SMALL_STATE(765)] = 37994,
  [SMALL_STATE(766)] = 38007,
  [SMALL_STATE(767)] = 38020,
  [SMALL_STATE(768)] = 38033,
  [SMALL_STATE(769)] = 38046,
  [SMALL_STATE(770)] = 38059,
  [SMALL_STATE(771)] = 38072,
  [SMALL_STATE(772)] = 38085,
  [SMALL_STATE(773)] = 38098,
  [SMALL_STATE(774)] = 38111,
  [SMALL_STATE(775)] = 38124,
  [SMALL_STATE(776)] = 38137,
  [SMALL_STATE(777)] = 38150,
  [SMALL_STATE(778)] = 38163,
  [SMALL_STATE(779)] = 38173,
  [SMALL_STATE(780)] = 38181,
  [SMALL_STATE(781)] = 38191,
  [SMALL_STATE(782)] = 38199,
  [SMALL_STATE(783)] = 38209,
  [SMALL_STATE(784)] = 38219,
  [SMALL_STATE(785)] = 38227,
  [SMALL_STATE(786)] = 38237,
  [SMALL_STATE(787)] = 38247,
  [SMALL_STATE(788)] = 38257,
  [SMALL_STATE(789)] = 38265,
  [SMALL_STATE(790)] = 38275,
  [SMALL_STATE(791)] = 38283,
  [SMALL_STATE(792)] = 38291,
  [SMALL_STATE(793)] = 38301,
  [SMALL_STATE(794)] = 38311,
  [SMALL_STATE(795)] = 38321,
  [SMALL_STATE(796)] = 38331,
  [SMALL_STATE(797)] = 38339,
  [SMALL_STATE(798)] = 38349,
  [SMALL_STATE(799)] = 38359,
  [SMALL_STATE(800)] = 38369,
  [SMALL_STATE(801)] = 38379,
  [SMALL_STATE(802)] = 38387,
  [SMALL_STATE(803)] = 38397,
  [SMALL_STATE(804)] = 38407,
  [SMALL_STATE(805)] = 38415,
  [SMALL_STATE(806)] = 38423,
  [SMALL_STATE(807)] = 38433,
  [SMALL_STATE(808)] = 38441,
  [SMALL_STATE(809)] = 38451,
  [SMALL_STATE(810)] = 38461,
  [SMALL_STATE(811)] = 38471,
  [SMALL_STATE(812)] = 38478,
  [SMALL_STATE(813)] = 38485,
  [SMALL_STATE(814)] = 38492,
  [SMALL_STATE(815)] = 38499,
  [SMALL_STATE(816)] = 38506,
  [SMALL_STATE(817)] = 38513,
  [SMALL_STATE(818)] = 38520,
  [SMALL_STATE(819)] = 38527,
  [SMALL_STATE(820)] = 38534,
  [SMALL_STATE(821)] = 38541,
  [SMALL_STATE(822)] = 38548,
  [SMALL_STATE(823)] = 38555,
  [SMALL_STATE(824)] = 38562,
  [SMALL_STATE(825)] = 38569,
  [SMALL_STATE(826)] = 38576,
  [SMALL_STATE(827)] = 38583,
  [SMALL_STATE(828)] = 38590,
  [SMALL_STATE(829)] = 38597,
  [SMALL_STATE(830)] = 38604,
  [SMALL_STATE(831)] = 38611,
  [SMALL_STATE(832)] = 38618,
  [SMALL_STATE(833)] = 38625,
  [SMALL_STATE(834)] = 38632,
  [SMALL_STATE(835)] = 38639,
  [SMALL_STATE(836)] = 38646,
  [SMALL_STATE(837)] = 38653,
  [SMALL_STATE(838)] = 38660,
  [SMALL_STATE(839)] = 38667,
  [SMALL_STATE(840)] = 38674,
  [SMALL_STATE(841)] = 38681,
  [SMALL_STATE(842)] = 38688,
  [SMALL_STATE(843)] = 38695,
  [SMALL_STATE(844)] = 38702,
  [SMALL_STATE(845)] = 38709,
  [SMALL_STATE(846)] = 38716,
  [SMALL_STATE(847)] = 38723,
  [SMALL_STATE(848)] = 38730,
  [SMALL_STATE(849)] = 38737,
  [SMALL_STATE(850)] = 38744,
  [SMALL_STATE(851)] = 38751,
  [SMALL_STATE(852)] = 38758,
  [SMALL_STATE(853)] = 38765,
  [SMALL_STATE(854)] = 38772,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [9] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(685),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(801),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(692),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(694),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(154),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(655),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(784),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(681),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(248),
  [43] = {.entry = {.count = 1, .reusable = false}}, SHIFT(247),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(836),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(835),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(833),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(823),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(853),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(728),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(698),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(730),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [157] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(653),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [167] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [169] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [175] = {.entry = {.count = 1, .reusable = false}}, SHIFT(824),
  [177] = {.entry = {.count = 1, .reusable = false}}, SHIFT(825),
  [179] = {.entry = {.count = 1, .reusable = false}}, SHIFT(826),
  [181] = {.entry = {.count = 1, .reusable = false}}, SHIFT(827),
  [183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(854),
  [185] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [187] = {.entry = {.count = 1, .reusable = false}}, SHIFT(290),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [195] = {.entry = {.count = 1, .reusable = false}}, SHIFT(321),
  [197] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [203] = {.entry = {.count = 1, .reusable = false}}, SHIFT(815),
  [205] = {.entry = {.count = 1, .reusable = false}}, SHIFT(814),
  [207] = {.entry = {.count = 1, .reusable = false}}, SHIFT(832),
  [209] = {.entry = {.count = 1, .reusable = false}}, SHIFT(822),
  [211] = {.entry = {.count = 1, .reusable = false}}, SHIFT(837),
  [213] = {.entry = {.count = 1, .reusable = false}}, SHIFT(76),
  [215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 2, 0, 0),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(844),
  [219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 2, 0, 0),
  [221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 1, 0, 0),
  [223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 1, 0, 0),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [229] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 3, 0, 0),
  [231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 3, 0, 0),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [235] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 4, 0, 0),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [241] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_literal, 2, 0, 0),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_literal, 2, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 6, 0, 0),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 6, 0, 0),
  [251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 4, 0, 1),
  [253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 4, 0, 1),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 4, 0, 1), SHIFT(92),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [266] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 4, 0, 1), SHIFT(122),
  [269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [271] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [275] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(850),
  [281] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 4, 0, 1), SHIFT(148),
  [284] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 4, 0, 1), SHIFT(147),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(142),
  [289] = {.entry = {.count = 1, .reusable = false}}, SHIFT(137),
  [291] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_operator_definition, 2, 0, 0),
  [293] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_operator_definition, 2, 0, 0),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [297] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [299] = {.entry = {.count = 1, .reusable = false}}, SHIFT(148),
  [301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(147),
  [303] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expr, 1, 0, 0),
  [305] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expr, 1, 0, 0),
  [307] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expr, 2, 0, 0),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expr, 2, 0, 0),
  [311] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expr, 1, 0, 0),
  [313] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expr, 1, 0, 0),
  [315] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_expr, 1, 0, 0), SHIFT(24),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 2, 0, 0),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 2, 0, 0),
  [322] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_expr, 7, 0, 0),
  [324] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_expr, 7, 0, 0),
  [326] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [328] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [330] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_well_known_set, 1, 0, 0),
  [332] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_well_known_set, 1, 0, 0),
  [334] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 2),
  [336] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 2),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 2), SHIFT(92),
  [341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [343] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 2), SHIFT(122),
  [346] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 2), SHIFT(148),
  [349] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 2), SHIFT(147),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 3),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 3),
  [356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 3), SHIFT(92),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [361] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 3), SHIFT(122),
  [364] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 3), SHIFT(148),
  [367] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 3), SHIFT(147),
  [370] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [374] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 3, 0, 0),
  [376] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 3, 0, 0),
  [378] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [380] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 3, 0, 0),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 3, 0, 0),
  [386] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 3, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 3, 0, 0),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [392] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 3, 0, 0),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 3, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 3, 0, 0),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 3, 0, 0),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 3, 0, 0),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 3, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 3, 0, 4),
  [406] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 3, 0, 4),
  [408] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expr, 3, 0, 0),
  [410] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expr, 3, 0, 0),
  [412] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_ufcs_right_hand_side, 1, 0, 0),
  [414] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ufcs_right_hand_side, 1, 0, 0),
  [416] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_ufcs_right_hand_side, 1, 0, 0), SHIFT(24),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_and, 3, 0, 0),
  [425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_and, 3, 0, 0),
  [427] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_or, 3, 0, 0),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_or, 3, 0, 0),
  [431] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_iff, 3, 0, 0),
  [433] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_iff, 3, 0, 0),
  [435] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_infix_implies, 3, 0, 0),
  [437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_infix_implies, 3, 0, 0),
  [439] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 5),
  [441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 5),
  [443] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 5), SHIFT(92),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [448] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 5), SHIFT(122),
  [451] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 5), SHIFT(148),
  [454] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 5), SHIFT(147),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 6),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 6),
  [461] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 6), SHIFT(92),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [466] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 6), SHIFT(122),
  [469] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 6), SHIFT(148),
  [472] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 6), SHIFT(147),
  [475] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 4, 0, 0),
  [477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 4, 0, 0),
  [479] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_literal, 4, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_literal, 4, 0, 0),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 4, 0, 0),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 4, 0, 0),
  [489] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 4, 0, 0),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 4, 0, 0),
  [493] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 4, 0, 0),
  [495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 4, 0, 0),
  [497] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 4, 0, 0),
  [499] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 4, 0, 0),
  [501] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 4, 0, 0),
  [503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 4, 0, 0),
  [505] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_expr, 4, 0, 0),
  [507] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_expr, 4, 0, 0),
  [509] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 4, 0, 7),
  [511] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 4, 0, 7),
  [513] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_list_access, 4, 0, 0),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_list_access, 4, 0, 0),
  [517] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expr, 4, 0, 0),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expr, 4, 0, 0),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 8),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 8),
  [525] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 8), SHIFT(92),
  [528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [530] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 8), SHIFT(122),
  [533] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 8), SHIFT(148),
  [536] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 8), SHIFT(147),
  [539] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 9),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 9),
  [543] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 9), SHIFT(92),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [548] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 9), SHIFT(122),
  [551] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 9), SHIFT(148),
  [554] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 9), SHIFT(147),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 5, 0, 0),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 5, 0, 0),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 5, 0, 0),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 5, 0, 0),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 5, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 5, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 5, 0, 0),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 5, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_all, 5, 0, 0),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_all, 5, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 5, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 5, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_expr, 5, 0, 0),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_expr, 5, 0, 0),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_application, 5, 0, 10),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_application, 5, 0, 10),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 11),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 11),
  [593] = {.entry = {.count = 2, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 11), SHIFT(92),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [598] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 11), SHIFT(122),
  [601] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 11), SHIFT(148),
  [604] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 11), SHIFT(147),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_lambda_expr, 6, 0, 0),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_lambda_expr, 6, 0, 0),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 6, 0, 0),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 6, 0, 0),
  [615] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_and, 6, 0, 0),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_and, 6, 0, 0),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_or, 6, 0, 0),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_or, 6, 0, 0),
  [623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_braced_any, 6, 0, 0),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_braced_any, 6, 0, 0),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_match_expr, 6, 0, 0),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_expr, 6, 0, 0),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_literal, 7, 0, 0),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_literal, 7, 0, 0),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_else_condition, 7, 0, 0),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_else_condition, 7, 0, 0),
  [639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [647] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [651] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [655] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(831),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [689] = {.entry = {.count = 1, .reusable = false}}, SHIFT(139),
  [691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [693] = {.entry = {.count = 1, .reusable = false}}, SHIFT(138),
  [695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [697] = {.entry = {.count = 1, .reusable = false}}, SHIFT(141),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(816),
  [703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assumption, 4, 0, 0),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [747] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(638),
  [750] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(675),
  [753] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(676),
  [756] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(680),
  [759] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(685),
  [762] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(801),
  [765] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(692),
  [768] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(694),
  [771] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(627),
  [774] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(639),
  [777] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 3),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 3),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 9),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 9),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 5, 0, 1),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 5, 0, 1),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 6, 0, 2),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 6, 0, 2),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 8, 0, 8),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 8, 0, 8),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 9, 0, 11),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 9, 0, 11),
  [801] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 6),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 6),
  [805] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_definition, 7, 0, 5),
  [807] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_definition, 7, 0, 5),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_lambda_expr_repeat1, 2, 0, 0),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type, 1, 0, 0),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [815] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type, 1, 0, 0),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_polymorphic_type, 5, 0, 0),
  [819] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_polymorphic_type, 5, 0, 0),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(710),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_type, 4, 0, 0),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [837] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_type, 4, 0, 0),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 2, 0, 0),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [847] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_type, 2, 0, 0),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 4, 0, 0),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [855] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_type, 4, 0, 0),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_polymorphic_type, 4, 0, 0),
  [861] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_polymorphic_type, 4, 0, 0),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 2, 0, 0),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_type, 2, 0, 0),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_type, 6, 0, 0),
  [887] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_type, 6, 0, 0),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 7, 0, 0),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_type, 7, 0, 0),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tuple_type, 3, 0, 0),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [925] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_tuple_type, 3, 0, 0),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [935] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_type, 5, 0, 0),
  [941] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_type, 5, 0, 0),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_operator_type, 3, 0, 0),
  [945] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_operator_type, 3, 0, 0),
  [947] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type, 3, 0, 0),
  [949] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type, 3, 0, 0),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 6, 0, 0),
  [953] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_type, 6, 0, 0),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_record_type, 5, 0, 0),
  [965] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_record_type, 5, 0, 0),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(688),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(796),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(686),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(740),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(657),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_case, 3, 0, 0),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 4, 0, 0),
  [999] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_segment_arguments_repeat1, 4, 0, 0),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0),
  [1003] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(742),
  [1006] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(688),
  [1009] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(741),
  [1012] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(796),
  [1015] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(686),
  [1018] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(740),
  [1021] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(619),
  [1024] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_definition_repeat1, 2, 0, 0), SHIFT_REPEAT(657),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_match_case, 6, 0, 0),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(821),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_segment, 1, 0, 0),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(662),
  [1049] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_segment, 1, 0, 0),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_constructor, 1, 0, 0),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1071] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0),
  [1073] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0), SHIFT_REPEAT(617),
  [1076] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0),
  [1078] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 2, 0, 0),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1082] = {.entry = {.count = 1, .reusable = false}}, SHIFT(687),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(795),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3, 0, 0),
  [1088] = {.entry = {.count = 1, .reusable = false}}, SHIFT(737),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(799),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [1094] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_export_repeat1, 2, 0, 0),
  [1096] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_export_repeat1, 2, 0, 0), SHIFT_REPEAT(663),
  [1099] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_export_repeat1, 2, 0, 0),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export, 2, 0, 0),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(663),
  [1105] = {.entry = {.count = 1, .reusable = false}}, SHIFT(678),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_segment_arguments, 5, 0, 0),
  [1109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_segment_arguments, 5, 0, 0),
  [1111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_segment_arguments, 2, 0, 0),
  [1113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_segment_arguments, 2, 0, 0),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_segment_arguments, 6, 0, 0),
  [1121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_segment_arguments, 6, 0, 0),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_segment, 2, 0, 0),
  [1125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_segment, 2, 0, 0),
  [1127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export, 3, 0, 0),
  [1129] = {.entry = {.count = 1, .reusable = false}}, SHIFT(734),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 4, 0, 0),
  [1133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sum_type, 2, 0, 0),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(649),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0),
  [1139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0), SHIFT_REPEAT(649),
  [1142] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 8, 0, 0),
  [1144] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constant_declaration, 4, 0, 0),
  [1146] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias, 7, 0, 0),
  [1148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0), SHIFT_REPEAT(623),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [1153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(729),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(794),
  [1157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sum_type, 3, 0, 0),
  [1159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition, 4, 0, 0),
  [1161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sum_type, 1, 0, 0),
  [1163] = {.entry = {.count = 1, .reusable = false}}, SHIFT(690),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(800),
  [1167] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_export_repeat1, 2, 0, 0), SHIFT_REPEAT(651),
  [1170] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 4, 0, 0),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(802),
  [1174] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variant_constructor, 4, 0, 0),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(651),
  [1178] = {.entry = {.count = 1, .reusable = false}}, SHIFT(727),
  [1180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 5, 0, 0),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(782),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1192] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sum_type_repeat1, 2, 0, 0), SHIFT_REPEAT(669),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1197] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export, 4, 0, 0),
  [1199] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_definition, 5, 0, 0),
  [1201] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 6, 0, 0),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 7, 0, 0),
  [1207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_export, 5, 0, 0),
  [1209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_definition, 4, 0, 0),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(803),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(806),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(670),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(659),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_lambda_expr_repeat1, 2, 0, 0), SHIFT_REPEAT(115),
  [1252] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_operator_type_repeat1, 2, 0, 0),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(693),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1268] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(819),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [1296] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(634),
  [1299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(668),
  [1307] = {.entry = {.count = 1, .reusable = false}}, SHIFT(309),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1311] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 4, 0, 0),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(809),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(634),
  [1327] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(805),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(658),
  [1353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(252),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1369] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_operator_type_repeat1, 2, 0, 0), SHIFT_REPEAT(599),
  [1372] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 4, 0, 0),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(300),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1384] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_alias_repeat1, 2, 0, 0), SHIFT_REPEAT(828),
  [1387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_alias_repeat1, 2, 0, 0),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(828),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(829),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(643),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1397] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(819),
  [1400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_typed_argument_list_repeat1, 2, 0, 0),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [1410] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 2, 0, 0), SHIFT_REPEAT(661),
  [1413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 2, 0, 0),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(818),
  [1417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [1419] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [1421] = {.entry = {.count = 1, .reusable = false}}, SHIFT(67),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(463),
  [1439] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(820),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(636),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(830),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1477] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_segment_arguments_repeat1, 2, 0, 0), SHIFT_REPEAT(710),
  [1480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_segment_arguments_repeat1, 2, 0, 0),
  [1482] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 2, 0, 0), SHIFT_REPEAT(735),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_type_repeat1, 2, 0, 0),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(807),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1491] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [1493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_match_expr_repeat1, 2, 0, 0), SHIFT_REPEAT(643),
  [1496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_match_expr_repeat1, 2, 0, 0),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1500] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1502] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [1504] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1506] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1508] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1510] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [1512] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [1514] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1518] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [1520] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1522] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1524] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1526] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1528] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1530] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [1532] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1534] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1536] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [1538] = {.entry = {.count = 1, .reusable = false}}, SHIFT(50),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [1550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1552] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(812),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1562] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 4, 0, 0),
  [1564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(708),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(840),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_record_literal_repeat1, 3, 0, 0),
  [1580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 2, 0, 0),
  [1586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 5, 0, 0),
  [1588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1594] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(739),
  [1598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(776),
  [1606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 3, 0, 0),
  [1608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_typed_argument_list, 6, 0, 0),
  [1610] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1612] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1614] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [1616] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [1618] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_qualified_identifier_repeat1, 2, 0, 0), SHIFT_REPEAT(852),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1633] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(763),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(804),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(731),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1683] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_qualified_identifier_repeat1, 2, 0, 0),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(603),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1703] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_quint(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
