#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 647
#define LARGE_STATE_COUNT 13
#define SYMBOL_COUNT 234
#define ALIAS_COUNT 0
#define TOKEN_COUNT 107
#define EXTERNAL_TOKEN_COUNT 13
#define FIELD_COUNT 22
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 47

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_SEMI = 3,
  anon_sym_COLON_COLON = 4,
  anon_sym_as = 5,
  anon_sym_LBRACE = 6,
  anon_sym_RBRACE = 7,
  anon_sym_true = 8,
  anon_sym_false = 9,
  aux_sym_decimal_int_literal_token1 = 10,
  aux_sym_decimal_int_literal_token2 = 11,
  sym_hex_int_literal = 12,
  aux_sym__decimal_float_literal_token1 = 13,
  aux_sym__decimal_float_literal_token2 = 14,
  aux_sym__decimal_float_literal_token3 = 15,
  aux_sym__decimal_float_literal_token4 = 16,
  aux_sym__decimal_float_literal_token5 = 17,
  aux_sym__hex_float_literal_token1 = 18,
  aux_sym__hex_float_literal_token2 = 19,
  aux_sym__hex_float_literal_token3 = 20,
  anon_sym_COMMA = 21,
  anon_sym_diagnostic = 22,
  anon_sym_LPAREN = 23,
  anon_sym_RPAREN = 24,
  anon_sym_DOT = 25,
  anon_sym_enable = 26,
  anon_sym_requires = 27,
  anon_sym_AT = 28,
  anon_sym_struct = 29,
  anon_sym_COLON = 30,
  anon_sym_alias = 31,
  anon_sym_EQ = 32,
  anon_sym_const = 33,
  anon_sym_override = 34,
  anon_sym_var = 35,
  anon_sym_PIPE_PIPE = 36,
  anon_sym_AMP_AMP = 37,
  anon_sym_PIPE = 38,
  anon_sym_CARET = 39,
  anon_sym_AMP = 40,
  anon_sym_EQ_EQ = 41,
  anon_sym_BANG_EQ = 42,
  anon_sym_PLUS = 43,
  anon_sym_DASH = 44,
  anon_sym_STAR = 45,
  anon_sym_SLASH = 46,
  anon_sym_PERCENT = 47,
  anon_sym_BANG = 48,
  anon_sym_TILDE = 49,
  anon_sym_LBRACK = 50,
  anon_sym_RBRACK = 51,
  aux_sym_swizzle_name_token1 = 52,
  aux_sym_swizzle_name_token2 = 53,
  aux_sym_swizzle_name_token3 = 54,
  aux_sym_swizzle_name_token4 = 55,
  aux_sym_swizzle_name_token5 = 56,
  aux_sym_swizzle_name_token6 = 57,
  aux_sym_swizzle_name_token7 = 58,
  aux_sym_swizzle_name_token8 = 59,
  anon_sym__ = 60,
  anon_sym_PLUS_EQ = 61,
  anon_sym_DASH_EQ = 62,
  anon_sym_STAR_EQ = 63,
  anon_sym_SLASH_EQ = 64,
  anon_sym_PERCENT_EQ = 65,
  anon_sym_AMP_EQ = 66,
  anon_sym_PIPE_EQ = 67,
  anon_sym_CARET_EQ = 68,
  anon_sym_PLUS_PLUS = 69,
  anon_sym_DASH_DASH = 70,
  anon_sym_return = 71,
  anon_sym_const_assert = 72,
  anon_sym_let = 73,
  anon_sym_if = 74,
  anon_sym_else = 75,
  anon_sym_switch = 76,
  anon_sym_case = 77,
  anon_sym_default = 78,
  anon_sym_for = 79,
  anon_sym_loop = 80,
  anon_sym_while = 81,
  anon_sym_break = 82,
  anon_sym_continue = 83,
  anon_sym_continuing = 84,
  anon_sym_discard = 85,
  anon_sym_virtual = 86,
  anon_sym_fn = 87,
  anon_sym_DASH_GT = 88,
  aux_sym_preproc_custom_token1 = 89,
  sym_preproc_directive = 90,
  anon_sym_POUNDimport = 91,
  sym_line_comment = 92,
  sym__blankspace = 93,
  sym_block_comment = 94,
  sym__disambiguate_template = 95,
  sym_template_args_start = 96,
  sym_template_args_end = 97,
  sym_less_than = 98,
  sym_less_than_equal = 99,
  sym_shift_left = 100,
  sym_shift_left_assign = 101,
  sym_greater_than = 102,
  sym_greater_than_equal = 103,
  sym_shift_right = 104,
  sym_shift_right_assign = 105,
  sym__error_sentinel = 106,
  sym_translation_unit = 107,
  sym_import = 108,
  sym_import_path = 109,
  sym_import_content = 110,
  sym_import_item = 111,
  sym_import_collection = 112,
  sym__literal = 113,
  sym_bool_literal = 114,
  sym_int_literal = 115,
  sym_decimal_int_literal = 116,
  sym_float_literal = 117,
  sym__decimal_float_literal = 118,
  sym__hex_float_literal = 119,
  sym__ident = 120,
  sym__member_ident = 121,
  sym__template_elaborated_ident = 122,
  sym_ident_path = 123,
  sym__ident_pattern_token = 124,
  sym_type_specifier = 125,
  sym_template_list = 126,
  sym__template_arg_comma_list = 127,
  sym__template_arg_expression = 128,
  sym__decorated_global_directive = 129,
  sym_global_directive = 130,
  sym_diagnostic_directive = 131,
  sym__diagnostic_control = 132,
  sym__diagnostic_rule_name = 133,
  sym__diagnostic_name_token = 134,
  sym__severity_control_name = 135,
  sym_enable_directive = 136,
  sym__enable_extension_list = 137,
  sym__enable_extension_name = 138,
  sym_requires_directive = 139,
  sym__software_extension_list = 140,
  sym__software_extension_name = 141,
  sym_attribute = 142,
  sym__decorated_global_decl = 143,
  sym_global_decl = 144,
  sym_struct_decl = 145,
  sym_struct_body = 146,
  sym_struct_member = 147,
  sym_type_alias_decl = 148,
  sym_global_variable_decl = 149,
  sym_global_value_decl = 150,
  sym_variable_decl = 151,
  sym__optionally_typed_ident = 152,
  sym__call_phrase = 153,
  sym__argument_expression_list = 154,
  sym_argument_list = 155,
  sym__short_circuit_or_expression = 156,
  sym__short_circuit_and_expression = 157,
  sym__binary_or_expression = 158,
  sym__binary_xor_expression = 159,
  sym__binary_and_expression = 160,
  sym__relational_expression = 161,
  sym__relational_operator = 162,
  sym__shift_expression = 163,
  sym__additive_expression = 164,
  sym__additive_operator = 165,
  sym__multiplicative_expression = 166,
  sym__multiplicative_operator = 167,
  sym_unary_expression = 168,
  sym__unary_operator = 169,
  sym__primary_expression = 170,
  sym_call_expression = 171,
  sym_indexing_expression = 172,
  sym_named_component_expression = 173,
  sym_swizzle_name = 174,
  sym_paren_expression = 175,
  sym_binary_expression = 176,
  sym__expression = 177,
  sym__decorated_statement = 178,
  sym__statement = 179,
  sym_compound_statement = 180,
  sym_assignment_statement = 181,
  sym__compound_assignment_operator = 182,
  sym_increment_statement = 183,
  sym_decrement_statement = 184,
  sym_return_statement = 185,
  sym_func_call_statement = 186,
  sym_const_assert_statement = 187,
  sym__variable_updating_statement = 188,
  sym_variable_or_value_statement = 189,
  sym_if_statement = 190,
  sym_if_clause = 191,
  sym_else_if_clause = 192,
  sym_else_clause = 193,
  sym_switch_statement = 194,
  sym_switch_body = 195,
  sym_switch_clause = 196,
  sym_case_clause = 197,
  sym_default_alone_clause = 198,
  sym__case_selectors = 199,
  sym_case_selector = 200,
  sym_for_statement = 201,
  sym_for_header = 202,
  sym__for_init = 203,
  sym__for_update = 204,
  sym_loop_statement = 205,
  sym_while_statement = 206,
  sym_break_statement = 207,
  sym_break_if_statement = 208,
  sym_continue_statement = 209,
  sym_continuing_statement = 210,
  sym_discard_statement = 211,
  sym_function_decl = 212,
  sym_function_header = 213,
  sym_param_list = 214,
  sym_param = 215,
  sym_preproc_custom = 216,
  sym_preproc_bevy_import = 217,
  aux_sym_translation_unit_repeat1 = 218,
  aux_sym_translation_unit_repeat2 = 219,
  aux_sym_translation_unit_repeat3 = 220,
  aux_sym_import_repeat1 = 221,
  aux_sym_import_collection_repeat1 = 222,
  aux_sym__template_arg_comma_list_repeat1 = 223,
  aux_sym__enable_extension_list_repeat1 = 224,
  aux_sym__software_extension_list_repeat1 = 225,
  aux_sym_struct_body_repeat1 = 226,
  aux_sym_argument_list_repeat1 = 227,
  aux_sym_compound_statement_repeat1 = 228,
  aux_sym_if_statement_repeat1 = 229,
  aux_sym_switch_body_repeat1 = 230,
  aux_sym__case_selectors_repeat1 = 231,
  aux_sym_param_list_repeat1 = 232,
  aux_sym_preproc_custom_repeat1 = 233,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_SEMI] = ";",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_as] = "as",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [aux_sym_decimal_int_literal_token1] = "decimal_int_literal_token1",
  [aux_sym_decimal_int_literal_token2] = "decimal_int_literal_token2",
  [sym_hex_int_literal] = "hex_int_literal",
  [aux_sym__decimal_float_literal_token1] = "_decimal_float_literal_token1",
  [aux_sym__decimal_float_literal_token2] = "_decimal_float_literal_token2",
  [aux_sym__decimal_float_literal_token3] = "_decimal_float_literal_token3",
  [aux_sym__decimal_float_literal_token4] = "_decimal_float_literal_token4",
  [aux_sym__decimal_float_literal_token5] = "_decimal_float_literal_token5",
  [aux_sym__hex_float_literal_token1] = "_hex_float_literal_token1",
  [aux_sym__hex_float_literal_token2] = "_hex_float_literal_token2",
  [aux_sym__hex_float_literal_token3] = "_hex_float_literal_token3",
  [anon_sym_COMMA] = ",",
  [anon_sym_diagnostic] = "diagnostic",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT] = ".",
  [anon_sym_enable] = "enable",
  [anon_sym_requires] = "requires",
  [anon_sym_AT] = "@",
  [anon_sym_struct] = "struct",
  [anon_sym_COLON] = ":",
  [anon_sym_alias] = "alias",
  [anon_sym_EQ] = "=",
  [anon_sym_const] = "const",
  [anon_sym_override] = "override",
  [anon_sym_var] = "var",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [aux_sym_swizzle_name_token1] = "swizzle_name_token1",
  [aux_sym_swizzle_name_token2] = "swizzle_name_token2",
  [aux_sym_swizzle_name_token3] = "swizzle_name_token3",
  [aux_sym_swizzle_name_token4] = "swizzle_name_token4",
  [aux_sym_swizzle_name_token5] = "swizzle_name_token5",
  [aux_sym_swizzle_name_token6] = "swizzle_name_token6",
  [aux_sym_swizzle_name_token7] = "swizzle_name_token7",
  [aux_sym_swizzle_name_token8] = "swizzle_name_token8",
  [anon_sym__] = "_",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_return] = "return",
  [anon_sym_const_assert] = "const_assert",
  [anon_sym_let] = "let",
  [anon_sym_if] = "if",
  [anon_sym_else] = "else",
  [anon_sym_switch] = "switch",
  [anon_sym_case] = "case",
  [anon_sym_default] = "default",
  [anon_sym_for] = "for",
  [anon_sym_loop] = "loop",
  [anon_sym_while] = "while",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_continuing] = "continuing",
  [anon_sym_discard] = "discard",
  [anon_sym_virtual] = "virtual",
  [anon_sym_fn] = "fn",
  [anon_sym_DASH_GT] = "->",
  [aux_sym_preproc_custom_token1] = "preproc_custom_token1",
  [sym_preproc_directive] = "preproc_directive",
  [anon_sym_POUNDimport] = "#import",
  [sym_line_comment] = "line_comment",
  [sym__blankspace] = "_blankspace",
  [sym_block_comment] = "block_comment",
  [sym__disambiguate_template] = "_disambiguate_template",
  [sym_template_args_start] = "template_args_start",
  [sym_template_args_end] = "template_args_end",
  [sym_less_than] = "less_than",
  [sym_less_than_equal] = "less_than_equal",
  [sym_shift_left] = "shift_left",
  [sym_shift_left_assign] = "shift_left_assign",
  [sym_greater_than] = "greater_than",
  [sym_greater_than_equal] = "greater_than_equal",
  [sym_shift_right] = "shift_right",
  [sym_shift_right_assign] = "shift_right_assign",
  [sym__error_sentinel] = "_error_sentinel",
  [sym_translation_unit] = "translation_unit",
  [sym_import] = "import",
  [sym_import_path] = "import_path",
  [sym_import_content] = "import_content",
  [sym_import_item] = "import_item",
  [sym_import_collection] = "import_collection",
  [sym__literal] = "_literal",
  [sym_bool_literal] = "bool_literal",
  [sym_int_literal] = "int_literal",
  [sym_decimal_int_literal] = "decimal_int_literal",
  [sym_float_literal] = "float_literal",
  [sym__decimal_float_literal] = "_decimal_float_literal",
  [sym__hex_float_literal] = "_hex_float_literal",
  [sym__ident] = "_ident",
  [sym__member_ident] = "_member_ident",
  [sym__template_elaborated_ident] = "_template_elaborated_ident",
  [sym_ident_path] = "ident_path",
  [sym__ident_pattern_token] = "_ident_pattern_token",
  [sym_type_specifier] = "type_specifier",
  [sym_template_list] = "template_list",
  [sym__template_arg_comma_list] = "_template_arg_comma_list",
  [sym__template_arg_expression] = "_template_arg_expression",
  [sym__decorated_global_directive] = "_decorated_global_directive",
  [sym_global_directive] = "global_directive",
  [sym_diagnostic_directive] = "diagnostic_directive",
  [sym__diagnostic_control] = "_diagnostic_control",
  [sym__diagnostic_rule_name] = "_diagnostic_rule_name",
  [sym__diagnostic_name_token] = "_diagnostic_name_token",
  [sym__severity_control_name] = "_severity_control_name",
  [sym_enable_directive] = "enable_directive",
  [sym__enable_extension_list] = "_enable_extension_list",
  [sym__enable_extension_name] = "_enable_extension_name",
  [sym_requires_directive] = "requires_directive",
  [sym__software_extension_list] = "_software_extension_list",
  [sym__software_extension_name] = "_software_extension_name",
  [sym_attribute] = "attribute",
  [sym__decorated_global_decl] = "_decorated_global_decl",
  [sym_global_decl] = "global_decl",
  [sym_struct_decl] = "struct_decl",
  [sym_struct_body] = "struct_body",
  [sym_struct_member] = "struct_member",
  [sym_type_alias_decl] = "type_alias_decl",
  [sym_global_variable_decl] = "global_variable_decl",
  [sym_global_value_decl] = "global_value_decl",
  [sym_variable_decl] = "variable_decl",
  [sym__optionally_typed_ident] = "_optionally_typed_ident",
  [sym__call_phrase] = "_call_phrase",
  [sym__argument_expression_list] = "_argument_expression_list",
  [sym_argument_list] = "argument_list",
  [sym__short_circuit_or_expression] = "_short_circuit_or_expression",
  [sym__short_circuit_and_expression] = "_short_circuit_and_expression",
  [sym__binary_or_expression] = "_binary_or_expression",
  [sym__binary_xor_expression] = "_binary_xor_expression",
  [sym__binary_and_expression] = "_binary_and_expression",
  [sym__relational_expression] = "_relational_expression",
  [sym__relational_operator] = "_relational_operator",
  [sym__shift_expression] = "_shift_expression",
  [sym__additive_expression] = "_additive_expression",
  [sym__additive_operator] = "_additive_operator",
  [sym__multiplicative_expression] = "_multiplicative_expression",
  [sym__multiplicative_operator] = "_multiplicative_operator",
  [sym_unary_expression] = "unary_expression",
  [sym__unary_operator] = "_unary_operator",
  [sym__primary_expression] = "_primary_expression",
  [sym_call_expression] = "call_expression",
  [sym_indexing_expression] = "indexing_expression",
  [sym_named_component_expression] = "named_component_expression",
  [sym_swizzle_name] = "swizzle_name",
  [sym_paren_expression] = "paren_expression",
  [sym_binary_expression] = "binary_expression",
  [sym__expression] = "_expression",
  [sym__decorated_statement] = "_decorated_statement",
  [sym__statement] = "_statement",
  [sym_compound_statement] = "compound_statement",
  [sym_assignment_statement] = "assignment_statement",
  [sym__compound_assignment_operator] = "_compound_assignment_operator",
  [sym_increment_statement] = "increment_statement",
  [sym_decrement_statement] = "decrement_statement",
  [sym_return_statement] = "return_statement",
  [sym_func_call_statement] = "func_call_statement",
  [sym_const_assert_statement] = "const_assert_statement",
  [sym__variable_updating_statement] = "_variable_updating_statement",
  [sym_variable_or_value_statement] = "variable_or_value_statement",
  [sym_if_statement] = "if_statement",
  [sym_if_clause] = "if_clause",
  [sym_else_if_clause] = "else_if_clause",
  [sym_else_clause] = "else_clause",
  [sym_switch_statement] = "switch_statement",
  [sym_switch_body] = "switch_body",
  [sym_switch_clause] = "switch_clause",
  [sym_case_clause] = "case_clause",
  [sym_default_alone_clause] = "default_alone_clause",
  [sym__case_selectors] = "_case_selectors",
  [sym_case_selector] = "case_selector",
  [sym_for_statement] = "for_statement",
  [sym_for_header] = "for_header",
  [sym__for_init] = "_for_init",
  [sym__for_update] = "_for_update",
  [sym_loop_statement] = "loop_statement",
  [sym_while_statement] = "while_statement",
  [sym_break_statement] = "break_statement",
  [sym_break_if_statement] = "break_if_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_continuing_statement] = "continuing_statement",
  [sym_discard_statement] = "discard_statement",
  [sym_function_decl] = "function_decl",
  [sym_function_header] = "function_header",
  [sym_param_list] = "param_list",
  [sym_param] = "param",
  [sym_preproc_custom] = "preproc_custom",
  [sym_preproc_bevy_import] = "preproc_bevy_import",
  [aux_sym_translation_unit_repeat1] = "translation_unit_repeat1",
  [aux_sym_translation_unit_repeat2] = "translation_unit_repeat2",
  [aux_sym_translation_unit_repeat3] = "translation_unit_repeat3",
  [aux_sym_import_repeat1] = "import_repeat1",
  [aux_sym_import_collection_repeat1] = "import_collection_repeat1",
  [aux_sym__template_arg_comma_list_repeat1] = "_template_arg_comma_list_repeat1",
  [aux_sym__enable_extension_list_repeat1] = "_enable_extension_list_repeat1",
  [aux_sym__software_extension_list_repeat1] = "_software_extension_list_repeat1",
  [aux_sym_struct_body_repeat1] = "struct_body_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_compound_statement_repeat1] = "compound_statement_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_switch_body_repeat1] = "switch_body_repeat1",
  [aux_sym__case_selectors_repeat1] = "_case_selectors_repeat1",
  [aux_sym_param_list_repeat1] = "param_list_repeat1",
  [aux_sym_preproc_custom_repeat1] = "preproc_custom_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [aux_sym_decimal_int_literal_token1] = aux_sym_decimal_int_literal_token1,
  [aux_sym_decimal_int_literal_token2] = aux_sym_decimal_int_literal_token2,
  [sym_hex_int_literal] = sym_hex_int_literal,
  [aux_sym__decimal_float_literal_token1] = aux_sym__decimal_float_literal_token1,
  [aux_sym__decimal_float_literal_token2] = aux_sym__decimal_float_literal_token2,
  [aux_sym__decimal_float_literal_token3] = aux_sym__decimal_float_literal_token3,
  [aux_sym__decimal_float_literal_token4] = aux_sym__decimal_float_literal_token4,
  [aux_sym__decimal_float_literal_token5] = aux_sym__decimal_float_literal_token5,
  [aux_sym__hex_float_literal_token1] = aux_sym__hex_float_literal_token1,
  [aux_sym__hex_float_literal_token2] = aux_sym__hex_float_literal_token2,
  [aux_sym__hex_float_literal_token3] = aux_sym__hex_float_literal_token3,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_diagnostic] = anon_sym_diagnostic,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_enable] = anon_sym_enable,
  [anon_sym_requires] = anon_sym_requires,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_alias] = anon_sym_alias,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [aux_sym_swizzle_name_token1] = aux_sym_swizzle_name_token1,
  [aux_sym_swizzle_name_token2] = aux_sym_swizzle_name_token2,
  [aux_sym_swizzle_name_token3] = aux_sym_swizzle_name_token3,
  [aux_sym_swizzle_name_token4] = aux_sym_swizzle_name_token4,
  [aux_sym_swizzle_name_token5] = aux_sym_swizzle_name_token5,
  [aux_sym_swizzle_name_token6] = aux_sym_swizzle_name_token6,
  [aux_sym_swizzle_name_token7] = aux_sym_swizzle_name_token7,
  [aux_sym_swizzle_name_token8] = aux_sym_swizzle_name_token8,
  [anon_sym__] = anon_sym__,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_const_assert] = anon_sym_const_assert,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_continuing] = anon_sym_continuing,
  [anon_sym_discard] = anon_sym_discard,
  [anon_sym_virtual] = anon_sym_virtual,
  [anon_sym_fn] = anon_sym_fn,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [aux_sym_preproc_custom_token1] = aux_sym_preproc_custom_token1,
  [sym_preproc_directive] = sym_preproc_directive,
  [anon_sym_POUNDimport] = anon_sym_POUNDimport,
  [sym_line_comment] = sym_line_comment,
  [sym__blankspace] = sym__blankspace,
  [sym_block_comment] = sym_block_comment,
  [sym__disambiguate_template] = sym__disambiguate_template,
  [sym_template_args_start] = sym_template_args_start,
  [sym_template_args_end] = sym_template_args_end,
  [sym_less_than] = sym_less_than,
  [sym_less_than_equal] = sym_less_than_equal,
  [sym_shift_left] = sym_shift_left,
  [sym_shift_left_assign] = sym_shift_left_assign,
  [sym_greater_than] = sym_greater_than,
  [sym_greater_than_equal] = sym_greater_than_equal,
  [sym_shift_right] = sym_shift_right,
  [sym_shift_right_assign] = sym_shift_right_assign,
  [sym__error_sentinel] = sym__error_sentinel,
  [sym_translation_unit] = sym_translation_unit,
  [sym_import] = sym_import,
  [sym_import_path] = sym_import_path,
  [sym_import_content] = sym_import_content,
  [sym_import_item] = sym_import_item,
  [sym_import_collection] = sym_import_collection,
  [sym__literal] = sym__literal,
  [sym_bool_literal] = sym_bool_literal,
  [sym_int_literal] = sym_int_literal,
  [sym_decimal_int_literal] = sym_decimal_int_literal,
  [sym_float_literal] = sym_float_literal,
  [sym__decimal_float_literal] = sym__decimal_float_literal,
  [sym__hex_float_literal] = sym__hex_float_literal,
  [sym__ident] = sym__ident,
  [sym__member_ident] = sym__member_ident,
  [sym__template_elaborated_ident] = sym__template_elaborated_ident,
  [sym_ident_path] = sym_ident_path,
  [sym__ident_pattern_token] = sym__ident_pattern_token,
  [sym_type_specifier] = sym_type_specifier,
  [sym_template_list] = sym_template_list,
  [sym__template_arg_comma_list] = sym__template_arg_comma_list,
  [sym__template_arg_expression] = sym__template_arg_expression,
  [sym__decorated_global_directive] = sym__decorated_global_directive,
  [sym_global_directive] = sym_global_directive,
  [sym_diagnostic_directive] = sym_diagnostic_directive,
  [sym__diagnostic_control] = sym__diagnostic_control,
  [sym__diagnostic_rule_name] = sym__diagnostic_rule_name,
  [sym__diagnostic_name_token] = sym__diagnostic_name_token,
  [sym__severity_control_name] = sym__severity_control_name,
  [sym_enable_directive] = sym_enable_directive,
  [sym__enable_extension_list] = sym__enable_extension_list,
  [sym__enable_extension_name] = sym__enable_extension_name,
  [sym_requires_directive] = sym_requires_directive,
  [sym__software_extension_list] = sym__software_extension_list,
  [sym__software_extension_name] = sym__software_extension_name,
  [sym_attribute] = sym_attribute,
  [sym__decorated_global_decl] = sym__decorated_global_decl,
  [sym_global_decl] = sym_global_decl,
  [sym_struct_decl] = sym_struct_decl,
  [sym_struct_body] = sym_struct_body,
  [sym_struct_member] = sym_struct_member,
  [sym_type_alias_decl] = sym_type_alias_decl,
  [sym_global_variable_decl] = sym_global_variable_decl,
  [sym_global_value_decl] = sym_global_value_decl,
  [sym_variable_decl] = sym_variable_decl,
  [sym__optionally_typed_ident] = sym__optionally_typed_ident,
  [sym__call_phrase] = sym__call_phrase,
  [sym__argument_expression_list] = sym__argument_expression_list,
  [sym_argument_list] = sym_argument_list,
  [sym__short_circuit_or_expression] = sym__short_circuit_or_expression,
  [sym__short_circuit_and_expression] = sym__short_circuit_and_expression,
  [sym__binary_or_expression] = sym__binary_or_expression,
  [sym__binary_xor_expression] = sym__binary_xor_expression,
  [sym__binary_and_expression] = sym__binary_and_expression,
  [sym__relational_expression] = sym__relational_expression,
  [sym__relational_operator] = sym__relational_operator,
  [sym__shift_expression] = sym__shift_expression,
  [sym__additive_expression] = sym__additive_expression,
  [sym__additive_operator] = sym__additive_operator,
  [sym__multiplicative_expression] = sym__multiplicative_expression,
  [sym__multiplicative_operator] = sym__multiplicative_operator,
  [sym_unary_expression] = sym_unary_expression,
  [sym__unary_operator] = sym__unary_operator,
  [sym__primary_expression] = sym__primary_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_indexing_expression] = sym_indexing_expression,
  [sym_named_component_expression] = sym_named_component_expression,
  [sym_swizzle_name] = sym_swizzle_name,
  [sym_paren_expression] = sym_paren_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym__expression] = sym__expression,
  [sym__decorated_statement] = sym__decorated_statement,
  [sym__statement] = sym__statement,
  [sym_compound_statement] = sym_compound_statement,
  [sym_assignment_statement] = sym_assignment_statement,
  [sym__compound_assignment_operator] = sym__compound_assignment_operator,
  [sym_increment_statement] = sym_increment_statement,
  [sym_decrement_statement] = sym_decrement_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_func_call_statement] = sym_func_call_statement,
  [sym_const_assert_statement] = sym_const_assert_statement,
  [sym__variable_updating_statement] = sym__variable_updating_statement,
  [sym_variable_or_value_statement] = sym_variable_or_value_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_if_clause] = sym_if_clause,
  [sym_else_if_clause] = sym_else_if_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_switch_statement] = sym_switch_statement,
  [sym_switch_body] = sym_switch_body,
  [sym_switch_clause] = sym_switch_clause,
  [sym_case_clause] = sym_case_clause,
  [sym_default_alone_clause] = sym_default_alone_clause,
  [sym__case_selectors] = sym__case_selectors,
  [sym_case_selector] = sym_case_selector,
  [sym_for_statement] = sym_for_statement,
  [sym_for_header] = sym_for_header,
  [sym__for_init] = sym__for_init,
  [sym__for_update] = sym__for_update,
  [sym_loop_statement] = sym_loop_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_break_if_statement] = sym_break_if_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_continuing_statement] = sym_continuing_statement,
  [sym_discard_statement] = sym_discard_statement,
  [sym_function_decl] = sym_function_decl,
  [sym_function_header] = sym_function_header,
  [sym_param_list] = sym_param_list,
  [sym_param] = sym_param,
  [sym_preproc_custom] = sym_preproc_custom,
  [sym_preproc_bevy_import] = sym_preproc_bevy_import,
  [aux_sym_translation_unit_repeat1] = aux_sym_translation_unit_repeat1,
  [aux_sym_translation_unit_repeat2] = aux_sym_translation_unit_repeat2,
  [aux_sym_translation_unit_repeat3] = aux_sym_translation_unit_repeat3,
  [aux_sym_import_repeat1] = aux_sym_import_repeat1,
  [aux_sym_import_collection_repeat1] = aux_sym_import_collection_repeat1,
  [aux_sym__template_arg_comma_list_repeat1] = aux_sym__template_arg_comma_list_repeat1,
  [aux_sym__enable_extension_list_repeat1] = aux_sym__enable_extension_list_repeat1,
  [aux_sym__software_extension_list_repeat1] = aux_sym__software_extension_list_repeat1,
  [aux_sym_struct_body_repeat1] = aux_sym_struct_body_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_compound_statement_repeat1] = aux_sym_compound_statement_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_switch_body_repeat1] = aux_sym_switch_body_repeat1,
  [aux_sym__case_selectors_repeat1] = aux_sym__case_selectors_repeat1,
  [aux_sym_param_list_repeat1] = aux_sym_param_list_repeat1,
  [aux_sym_preproc_custom_repeat1] = aux_sym_preproc_custom_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_decimal_int_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_decimal_int_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_hex_int_literal] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__decimal_float_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_float_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_float_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_float_literal_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_float_literal_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_float_literal_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_float_literal_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_float_literal_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_diagnostic] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_requires] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_alias] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_swizzle_name_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token4] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token5] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token6] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token7] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_swizzle_name_token8] = {
    .visible = false,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const_assert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continuing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_discard] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_virtual] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_preproc_custom_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_preproc_directive] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUNDimport] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__blankspace] = {
    .visible = false,
    .named = true,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym__disambiguate_template] = {
    .visible = false,
    .named = true,
  },
  [sym_template_args_start] = {
    .visible = true,
    .named = true,
  },
  [sym_template_args_end] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_less_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_left_assign] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than] = {
    .visible = true,
    .named = true,
  },
  [sym_greater_than_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right] = {
    .visible = true,
    .named = true,
  },
  [sym_shift_right_assign] = {
    .visible = true,
    .named = true,
  },
  [sym__error_sentinel] = {
    .visible = false,
    .named = true,
  },
  [sym_translation_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_import_path] = {
    .visible = true,
    .named = true,
  },
  [sym_import_content] = {
    .visible = true,
    .named = true,
  },
  [sym_import_item] = {
    .visible = true,
    .named = true,
  },
  [sym_import_collection] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_bool_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal_int_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_float_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__decimal_float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_float_literal] = {
    .visible = false,
    .named = true,
  },
  [sym__ident] = {
    .visible = false,
    .named = true,
  },
  [sym__member_ident] = {
    .visible = false,
    .named = true,
  },
  [sym__template_elaborated_ident] = {
    .visible = false,
    .named = true,
  },
  [sym_ident_path] = {
    .visible = true,
    .named = true,
  },
  [sym__ident_pattern_token] = {
    .visible = false,
    .named = true,
  },
  [sym_type_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_template_list] = {
    .visible = true,
    .named = true,
  },
  [sym__template_arg_comma_list] = {
    .visible = false,
    .named = true,
  },
  [sym__template_arg_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__decorated_global_directive] = {
    .visible = false,
    .named = true,
  },
  [sym_global_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_diagnostic_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__diagnostic_control] = {
    .visible = false,
    .named = true,
  },
  [sym__diagnostic_rule_name] = {
    .visible = false,
    .named = true,
  },
  [sym__diagnostic_name_token] = {
    .visible = false,
    .named = true,
  },
  [sym__severity_control_name] = {
    .visible = false,
    .named = true,
  },
  [sym_enable_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__enable_extension_list] = {
    .visible = false,
    .named = true,
  },
  [sym__enable_extension_name] = {
    .visible = false,
    .named = true,
  },
  [sym_requires_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__software_extension_list] = {
    .visible = false,
    .named = true,
  },
  [sym__software_extension_name] = {
    .visible = false,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym__decorated_global_decl] = {
    .visible = false,
    .named = true,
  },
  [sym_global_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_type_alias_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_global_value_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_decl] = {
    .visible = true,
    .named = true,
  },
  [sym__optionally_typed_ident] = {
    .visible = false,
    .named = true,
  },
  [sym__call_phrase] = {
    .visible = false,
    .named = true,
  },
  [sym__argument_expression_list] = {
    .visible = false,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym__short_circuit_or_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__short_circuit_and_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_or_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_xor_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__binary_and_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__relational_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__relational_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__shift_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__additive_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__additive_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__multiplicative_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__multiplicative_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__unary_operator] = {
    .visible = false,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_indexing_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_named_component_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_swizzle_name] = {
    .visible = true,
    .named = true,
  },
  [sym_paren_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__decorated_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_compound_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__compound_assignment_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_increment_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_decrement_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_func_call_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_const_assert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_updating_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_or_value_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_body] = {
    .visible = true,
    .named = true,
  },
  [sym_switch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_case_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_default_alone_clause] = {
    .visible = true,
    .named = true,
  },
  [sym__case_selectors] = {
    .visible = false,
    .named = true,
  },
  [sym_case_selector] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_header] = {
    .visible = true,
    .named = true,
  },
  [sym__for_init] = {
    .visible = false,
    .named = true,
  },
  [sym__for_update] = {
    .visible = false,
    .named = true,
  },
  [sym_loop_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continuing_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_discard_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_decl] = {
    .visible = true,
    .named = true,
  },
  [sym_function_header] = {
    .visible = true,
    .named = true,
  },
  [sym_param_list] = {
    .visible = true,
    .named = true,
  },
  [sym_param] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_custom] = {
    .visible = true,
    .named = true,
  },
  [sym_preproc_bevy_import] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_translation_unit_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_translation_unit_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_translation_unit_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_collection_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__template_arg_comma_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__enable_extension_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__software_extension_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_compound_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__case_selectors_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_param_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_preproc_custom_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_arguments = 2,
  field_body = 3,
  field_component = 4,
  field_condition = 5,
  field_directive = 6,
  field_index = 7,
  field_init = 8,
  field_initializer = 9,
  field_left = 10,
  field_name = 11,
  field_operand = 12,
  field_operator = 13,
  field_parameters = 14,
  field_rename = 15,
  field_return_type = 16,
  field_right = 17,
  field_rule = 18,
  field_severity = 19,
  field_type = 20,
  field_update = 21,
  field_value = 22,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_component] = "component",
  [field_condition] = "condition",
  [field_directive] = "directive",
  [field_index] = "index",
  [field_init] = "init",
  [field_initializer] = "initializer",
  [field_left] = "left",
  [field_name] = "name",
  [field_operand] = "operand",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_rename] = "rename",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_rule] = "rule",
  [field_severity] = "severity",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 3},
  [3] = {.index = 4, .length = 1},
  [4] = {.index = 5, .length = 1},
  [5] = {.index = 6, .length = 1},
  [6] = {.index = 7, .length = 2},
  [7] = {.index = 9, .length = 2},
  [8] = {.index = 11, .length = 2},
  [9] = {.index = 13, .length = 2},
  [10] = {.index = 15, .length = 2},
  [11] = {.index = 17, .length = 2},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 3},
  [14] = {.index = 24, .length = 2},
  [15] = {.index = 26, .length = 2},
  [16] = {.index = 28, .length = 2},
  [17] = {.index = 30, .length = 2},
  [18] = {.index = 32, .length = 1},
  [19] = {.index = 33, .length = 2},
  [20] = {.index = 35, .length = 2},
  [21] = {.index = 37, .length = 3},
  [22] = {.index = 40, .length = 1},
  [23] = {.index = 41, .length = 2},
  [24] = {.index = 43, .length = 2},
  [25] = {.index = 45, .length = 2},
  [26] = {.index = 47, .length = 2},
  [27] = {.index = 49, .length = 2},
  [28] = {.index = 51, .length = 2},
  [29] = {.index = 53, .length = 2},
  [30] = {.index = 55, .length = 2},
  [31] = {.index = 57, .length = 3},
  [32] = {.index = 60, .length = 1},
  [33] = {.index = 61, .length = 1},
  [34] = {.index = 62, .length = 1},
  [35] = {.index = 63, .length = 1},
  [36] = {.index = 64, .length = 2},
  [37] = {.index = 66, .length = 2},
  [38] = {.index = 68, .length = 3},
  [39] = {.index = 71, .length = 3},
  [40] = {.index = 74, .length = 1},
  [41] = {.index = 75, .length = 2},
  [42] = {.index = 77, .length = 2},
  [43] = {.index = 79, .length = 2},
  [44] = {.index = 81, .length = 3},
  [45] = {.index = 84, .length = 1},
  [46] = {.index = 85, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_directive, 0},
  [1] =
    {field_left, 0, .inherited = true},
    {field_operator, 0, .inherited = true},
    {field_right, 0, .inherited = true},
  [4] =
    {field_name, 0},
  [5] =
    {field_name, 1},
  [6] =
    {field_body, 1},
  [7] =
    {field_operand, 1},
    {field_operator, 0},
  [9] =
    {field_argument, 1},
    {field_directive, 0},
  [11] =
    {field_rule, 1, .inherited = true},
    {field_severity, 1, .inherited = true},
  [13] =
    {field_arguments, 2},
    {field_name, 1},
  [15] =
    {field_body, 2},
    {field_name, 1},
  [17] =
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [19] =
    {field_name, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [21] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [24] =
    {field_component, 2},
    {field_value, 0},
  [26] =
    {field_name, 0},
    {field_rename, 2},
  [28] =
    {field_name, 0},
    {field_type, 2},
  [30] =
    {field_name, 3, .inherited = true},
    {field_type, 3, .inherited = true},
  [32] =
    {field_initializer, 2},
  [33] =
    {field_index, 2},
    {field_value, 0},
  [35] =
    {field_name, 1},
    {field_type, 3},
  [37] =
    {field_initializer, 3},
    {field_name, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [40] =
    {field_name, 2},
  [41] =
    {field_name, 1},
    {field_parameters, 3},
  [43] =
    {field_body, 2},
    {field_condition, 1},
  [45] =
    {field_body, 2},
    {field_value, 1},
  [47] =
    {field_rule, 3},
    {field_severity, 1},
  [49] =
    {field_name, 2},
    {field_parameters, 4},
  [51] =
    {field_name, 1},
    {field_return_type, 5},
  [53] =
    {field_name, 2},
    {field_return_type, 6},
  [55] =
    {field_name, 1},
    {field_return_type, 6},
  [57] =
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 6},
  [60] =
    {field_update, 2},
  [61] =
    {field_condition, 1},
  [62] =
    {field_body, 4},
  [63] =
    {field_init, 0},
  [64] =
    {field_body, 3},
    {field_condition, 2},
  [66] =
    {field_name, 2},
    {field_return_type, 7},
  [68] =
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 7},
  [71] =
    {field_name, 1},
    {field_parameters, 3},
    {field_return_type, 7},
  [74] =
    {field_body, 2},
  [75] =
    {field_condition, 1},
    {field_update, 3},
  [77] =
    {field_init, 0},
    {field_update, 3},
  [79] =
    {field_condition, 2},
    {field_init, 0},
  [81] =
    {field_name, 2},
    {field_parameters, 4},
    {field_return_type, 8},
  [84] =
    {field_body, 3},
  [85] =
    {field_condition, 2},
    {field_init, 0},
    {field_update, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 2,
  [8] = 3,
  [9] = 5,
  [10] = 4,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 21,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 27,
  [29] = 21,
  [30] = 30,
  [31] = 31,
  [32] = 27,
  [33] = 27,
  [34] = 21,
  [35] = 21,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 42,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 42,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 61,
  [65] = 50,
  [66] = 51,
  [67] = 67,
  [68] = 53,
  [69] = 54,
  [70] = 55,
  [71] = 58,
  [72] = 59,
  [73] = 60,
  [74] = 61,
  [75] = 50,
  [76] = 51,
  [77] = 52,
  [78] = 53,
  [79] = 54,
  [80] = 55,
  [81] = 58,
  [82] = 59,
  [83] = 60,
  [84] = 61,
  [85] = 50,
  [86] = 51,
  [87] = 52,
  [88] = 53,
  [89] = 54,
  [90] = 55,
  [91] = 58,
  [92] = 59,
  [93] = 60,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 67,
  [99] = 45,
  [100] = 42,
  [101] = 45,
  [102] = 45,
  [103] = 52,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 108,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 19,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 109,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 115,
  [196] = 114,
  [197] = 197,
  [198] = 122,
  [199] = 121,
  [200] = 123,
  [201] = 125,
  [202] = 113,
  [203] = 116,
  [204] = 119,
  [205] = 124,
  [206] = 120,
  [207] = 126,
  [208] = 118,
  [209] = 157,
  [210] = 166,
  [211] = 211,
  [212] = 109,
  [213] = 167,
  [214] = 108,
  [215] = 164,
  [216] = 192,
  [217] = 191,
  [218] = 19,
  [219] = 171,
  [220] = 176,
  [221] = 177,
  [222] = 183,
  [223] = 184,
  [224] = 165,
  [225] = 168,
  [226] = 169,
  [227] = 227,
  [228] = 173,
  [229] = 174,
  [230] = 175,
  [231] = 179,
  [232] = 180,
  [233] = 181,
  [234] = 182,
  [235] = 185,
  [236] = 187,
  [237] = 188,
  [238] = 238,
  [239] = 193,
  [240] = 189,
  [241] = 194,
  [242] = 172,
  [243] = 163,
  [244] = 115,
  [245] = 114,
  [246] = 120,
  [247] = 121,
  [248] = 116,
  [249] = 126,
  [250] = 125,
  [251] = 113,
  [252] = 119,
  [253] = 124,
  [254] = 123,
  [255] = 122,
  [256] = 118,
  [257] = 157,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 167,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 164,
  [266] = 192,
  [267] = 191,
  [268] = 194,
  [269] = 174,
  [270] = 175,
  [271] = 179,
  [272] = 180,
  [273] = 181,
  [274] = 182,
  [275] = 185,
  [276] = 187,
  [277] = 183,
  [278] = 108,
  [279] = 184,
  [280] = 188,
  [281] = 165,
  [282] = 168,
  [283] = 166,
  [284] = 177,
  [285] = 163,
  [286] = 171,
  [287] = 287,
  [288] = 109,
  [289] = 189,
  [290] = 19,
  [291] = 172,
  [292] = 173,
  [293] = 176,
  [294] = 193,
  [295] = 169,
  [296] = 296,
  [297] = 115,
  [298] = 114,
  [299] = 123,
  [300] = 125,
  [301] = 116,
  [302] = 119,
  [303] = 124,
  [304] = 113,
  [305] = 305,
  [306] = 306,
  [307] = 126,
  [308] = 120,
  [309] = 121,
  [310] = 118,
  [311] = 122,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 157,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 317,
  [328] = 328,
  [329] = 317,
  [330] = 330,
  [331] = 312,
  [332] = 317,
  [333] = 313,
  [334] = 313,
  [335] = 313,
  [336] = 336,
  [337] = 164,
  [338] = 192,
  [339] = 167,
  [340] = 180,
  [341] = 171,
  [342] = 176,
  [343] = 177,
  [344] = 183,
  [345] = 184,
  [346] = 165,
  [347] = 168,
  [348] = 169,
  [349] = 173,
  [350] = 174,
  [351] = 175,
  [352] = 179,
  [353] = 181,
  [354] = 182,
  [355] = 187,
  [356] = 188,
  [357] = 166,
  [358] = 358,
  [359] = 189,
  [360] = 172,
  [361] = 193,
  [362] = 194,
  [363] = 163,
  [364] = 109,
  [365] = 191,
  [366] = 108,
  [367] = 19,
  [368] = 185,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 19,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 128,
  [392] = 392,
  [393] = 129,
  [394] = 134,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 398,
  [400] = 398,
  [401] = 398,
  [402] = 402,
  [403] = 158,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 115,
  [420] = 114,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 126,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 167,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 164,
  [438] = 192,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 465,
  [466] = 377,
  [467] = 467,
  [468] = 465,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 475,
  [476] = 476,
  [477] = 477,
  [478] = 126,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 486,
  [498] = 480,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 380,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 381,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 378,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 385,
  [525] = 525,
  [526] = 526,
  [527] = 514,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 514,
  [536] = 536,
  [537] = 537,
  [538] = 514,
  [539] = 539,
  [540] = 540,
  [541] = 514,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 561,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 583,
  [596] = 596,
  [597] = 583,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 583,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 604,
  [615] = 605,
  [616] = 616,
  [617] = 617,
  [618] = 583,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 604,
  [623] = 605,
  [624] = 624,
  [625] = 625,
  [626] = 583,
  [627] = 627,
  [628] = 604,
  [629] = 605,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 604,
  [635] = 635,
  [636] = 636,
  [637] = 191,
  [638] = 638,
  [639] = 639,
  [640] = 605,
  [641] = 641,
  [642] = 19,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xba, 0xba}, {0xc0, 0xd6}, {0xd8, 0xf6},
  {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x370, 0x374}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x620, 0x64a}, {0x66e, 0x66f}, {0x671, 0x6d3},
  {0x6d5, 0x6d5}, {0x6e5, 0x6e6}, {0x6ee, 0x6ef}, {0x6fa, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x710}, {0x712, 0x72f}, {0x74d, 0x7a5},
  {0x7b1, 0x7b1}, {0x7ca, 0x7ea}, {0x7f4, 0x7f5}, {0x7fa, 0x7fa}, {0x800, 0x815}, {0x81a, 0x81a}, {0x824, 0x824}, {0x828, 0x828},
  {0x840, 0x858}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x8a0, 0x8c9}, {0x904, 0x939}, {0x93d, 0x93d}, {0x950, 0x950},
  {0x958, 0x961}, {0x971, 0x980}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9},
  {0x9bd, 0x9bd}, {0x9ce, 0x9ce}, {0x9dc, 0x9dd}, {0x9df, 0x9e1}, {0x9f0, 0x9f1}, {0x9fc, 0x9fc}, {0xa05, 0xa0a}, {0xa0f, 0xa10},
  {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa72, 0xa74},
  {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabd, 0xabd}, {0xad0, 0xad0},
  {0xae0, 0xae1}, {0xaf9, 0xaf9}, {0xb05, 0xb0c}, {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39},
  {0xb3d, 0xb3d}, {0xb5c, 0xb5d}, {0xb5f, 0xb61}, {0xb71, 0xb71}, {0xb83, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90}, {0xb92, 0xb95},
  {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbd0, 0xbd0}, {0xc05, 0xc0c},
  {0xc0e, 0xc10}, {0xc12, 0xc28}, {0xc2a, 0xc39}, {0xc3d, 0xc3d}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc61}, {0xc80, 0xc80},
  {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbd, 0xcbd}, {0xcdd, 0xcde}, {0xce0, 0xce1},
  {0xcf1, 0xcf2}, {0xd04, 0xd0c}, {0xd0e, 0xd10}, {0xd12, 0xd3a}, {0xd3d, 0xd3d}, {0xd4e, 0xd4e}, {0xd54, 0xd56}, {0xd5f, 0xd61},
  {0xd7a, 0xd7f}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xe01, 0xe30}, {0xe32, 0xe32},
  {0xe40, 0xe46}, {0xe81, 0xe82}, {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xeb0}, {0xeb2, 0xeb2},
  {0xebd, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf40, 0xf47}, {0xf49, 0xf6c}, {0xf88, 0xf8c},
  {0x1000, 0x102a}, {0x103f, 0x103f}, {0x1050, 0x1055}, {0x105a, 0x105d}, {0x1061, 0x1061}, {0x1065, 0x1066}, {0x106e, 0x1070}, {0x1075, 0x1081},
  {0x108e, 0x108e}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256},
  {0x1258, 0x1258}, {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0},
  {0x12c2, 0x12c5}, {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x1380, 0x138f}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd},
  {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1711}, {0x171f, 0x1731}, {0x1740, 0x1751},
  {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1780, 0x17b3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dc}, {0x1820, 0x1878}, {0x1880, 0x18a8}, {0x18aa, 0x18aa},
  {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1950, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x1a00, 0x1a16}, {0x1a20, 0x1a54},
  {0x1aa7, 0x1aa7}, {0x1b05, 0x1b33}, {0x1b45, 0x1b4c}, {0x1b83, 0x1ba0}, {0x1bae, 0x1baf}, {0x1bba, 0x1be5}, {0x1c00, 0x1c23}, {0x1c4d, 0x1c4f},
  {0x1c5a, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1ce9, 0x1cec}, {0x1cee, 0x1cf3}, {0x1cf5, 0x1cf6}, {0x1cfa, 0x1cfa},
  {0x1d00, 0x1dbf}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x2071, 0x2071}, {0x207f, 0x207f}, {0x2090, 0x209c}, {0x2102, 0x2102},
  {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25},
  {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67}, {0x2d6f, 0x2d6f}, {0x2d80, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6},
  {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce}, {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x3005, 0x3007}, {0x3021, 0x3029}, {0x3031, 0x3035},
  {0x3038, 0x303c}, {0x3041, 0x3096}, {0x309d, 0x309f}, {0x30a1, 0x30fa}, {0x30fc, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf},
  {0x31f0, 0x31ff}, {0x3400, 0x4dbf}, {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa61f}, {0xa62a, 0xa62b}, {0xa640, 0xa66e},
  {0xa67f, 0xa69d}, {0xa6a0, 0xa6ef}, {0xa717, 0xa71f}, {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9},
  {0xa7f2, 0xa801}, {0xa803, 0xa805}, {0xa807, 0xa80a}, {0xa80c, 0xa822}, {0xa840, 0xa873}, {0xa882, 0xa8b3}, {0xa8f2, 0xa8f7}, {0xa8fb, 0xa8fb},
  {0xa8fd, 0xa8fe}, {0xa90a, 0xa925}, {0xa930, 0xa946}, {0xa960, 0xa97c}, {0xa984, 0xa9b2}, {0xa9cf, 0xa9cf}, {0xa9e0, 0xa9e4}, {0xa9e6, 0xa9ef},
  {0xa9fa, 0xa9fe}, {0xaa00, 0xaa28}, {0xaa40, 0xaa42}, {0xaa44, 0xaa4b}, {0xaa60, 0xaa76}, {0xaa7a, 0xaa7a}, {0xaa7e, 0xaaaf}, {0xaab1, 0xaab1},
  {0xaab5, 0xaab6}, {0xaab9, 0xaabd}, {0xaac0, 0xaac0}, {0xaac2, 0xaac2}, {0xaadb, 0xaadd}, {0xaae0, 0xaaea}, {0xaaf2, 0xaaf4}, {0xab01, 0xab06},
  {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a}, {0xab5c, 0xab69}, {0xab70, 0xabe2}, {0xac00, 0xd7a3},
  {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d}, {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb1d}, {0xfb1f, 0xfb28},
  {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41}, {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d},
  {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0xff66, 0xff9d}, {0xffa0, 0xffbe}, {0xffc2, 0xffc7}, {0xffca, 0xffcf},
  {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d}, {0x10050, 0x1005d},
  {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x10300, 0x1031f}, {0x1032d, 0x1034a}, {0x10350, 0x10375}, {0x10380, 0x1039d},
  {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
  {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785}, {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808},
  {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855}, {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5},
  {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf}, {0x10a00, 0x10a00}, {0x10a10, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35},
  {0x10a60, 0x10a7c}, {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae4}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91},
  {0x10c00, 0x10c48}, {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d23}, {0x10e80, 0x10ea9}, {0x10eb0, 0x10eb1}, {0x10f00, 0x10f1c}, {0x10f27, 0x10f27},
  {0x10f30, 0x10f45}, {0x10f70, 0x10f81}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11003, 0x11037}, {0x11071, 0x11072}, {0x11075, 0x11075}, {0x11083, 0x110af},
  {0x110d0, 0x110e8}, {0x11103, 0x11126}, {0x11144, 0x11144}, {0x11147, 0x11147}, {0x11150, 0x11172}, {0x11176, 0x11176}, {0x11183, 0x111b2}, {0x111c1, 0x111c4},
  {0x111da, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x1122b}, {0x1123f, 0x11240}, {0x11280, 0x11286}, {0x11288, 0x11288}, {0x1128a, 0x1128d},
  {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112de}, {0x11305, 0x1130c}, {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333},
  {0x11335, 0x11339}, {0x1133d, 0x1133d}, {0x11350, 0x11350}, {0x1135d, 0x11361}, {0x11400, 0x11434}, {0x11447, 0x1144a}, {0x1145f, 0x11461}, {0x11480, 0x114af},
  {0x114c4, 0x114c5}, {0x114c7, 0x114c7}, {0x11580, 0x115ae}, {0x115d8, 0x115db}, {0x11600, 0x1162f}, {0x11644, 0x11644}, {0x11680, 0x116aa}, {0x116b8, 0x116b8},
  {0x11700, 0x1171a}, {0x11740, 0x11746}, {0x11800, 0x1182b}, {0x118a0, 0x118df}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916},
  {0x11918, 0x1192f}, {0x1193f, 0x1193f}, {0x11941, 0x11941}, {0x119a0, 0x119a7}, {0x119aa, 0x119d0}, {0x119e1, 0x119e1}, {0x119e3, 0x119e3}, {0x11a00, 0x11a00},
  {0x11a0b, 0x11a32}, {0x11a3a, 0x11a3a}, {0x11a50, 0x11a50}, {0x11a5c, 0x11a89}, {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c2e},
  {0x11c40, 0x11c40}, {0x11c72, 0x11c8f}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d30}, {0x11d46, 0x11d46}, {0x11d60, 0x11d65}, {0x11d67, 0x11d68},
  {0x11d6a, 0x11d89}, {0x11d98, 0x11d98}, {0x11ee0, 0x11ef2}, {0x11f02, 0x11f02}, {0x11f04, 0x11f10}, {0x11f12, 0x11f33}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399},
  {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0}, {0x13000, 0x1342f}, {0x13441, 0x13446}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e},
  {0x16a70, 0x16abe}, {0x16ad0, 0x16aed}, {0x16b00, 0x16b2f}, {0x16b40, 0x16b43}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f}, {0x16f00, 0x16f4a},
  {0x16f50, 0x16f50}, {0x16f93, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe3}, {0x17000, 0x187f7}, {0x18800, 0x18cd5}, {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3},
  {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155}, {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb},
  {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1d400, 0x1d454}, {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2},
  {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3}, {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514},
  {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546}, {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0},
  {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e}, {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8},
  {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e030, 0x1e06d}, {0x1e100, 0x1e12c}, {0x1e137, 0x1e13d}, {0x1e14e, 0x1e14e},
  {0x1e290, 0x1e2ad}, {0x1e2c0, 0x1e2eb}, {0x1e4d0, 0x1e4eb}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe}, {0x1e800, 0x1e8c4},
  {0x1e900, 0x1e943}, {0x1e94b, 0x1e94b}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24}, {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32},
  {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49}, {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f},
  {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d}, {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62},
  {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e}, {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b},
  {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739}, {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0},
  {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xaa, 0xaa}, {0xb5, 0xb5}, {0xb7, 0xb7}, {0xba, 0xba},
  {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x2c1}, {0x2c6, 0x2d1}, {0x2e0, 0x2e4}, {0x2ec, 0x2ec}, {0x2ee, 0x2ee}, {0x300, 0x374},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481},
  {0x483, 0x487}, {0x48a, 0x52f}, {0x531, 0x556}, {0x559, 0x559}, {0x560, 0x588}, {0x591, 0x5bd}, {0x5bf, 0x5bf}, {0x5c1, 0x5c2},
  {0x5c4, 0x5c5}, {0x5c7, 0x5c7}, {0x5d0, 0x5ea}, {0x5ef, 0x5f2}, {0x610, 0x61a}, {0x620, 0x669}, {0x66e, 0x6d3}, {0x6d5, 0x6dc},
  {0x6df, 0x6e8}, {0x6ea, 0x6fc}, {0x6ff, 0x6ff}, {0x710, 0x74a}, {0x74d, 0x7b1}, {0x7c0, 0x7f5}, {0x7fa, 0x7fa}, {0x7fd, 0x7fd},
  {0x800, 0x82d}, {0x840, 0x85b}, {0x860, 0x86a}, {0x870, 0x887}, {0x889, 0x88e}, {0x898, 0x8e1}, {0x8e3, 0x963}, {0x966, 0x96f},
  {0x971, 0x983}, {0x985, 0x98c}, {0x98f, 0x990}, {0x993, 0x9a8}, {0x9aa, 0x9b0}, {0x9b2, 0x9b2}, {0x9b6, 0x9b9}, {0x9bc, 0x9c4},
  {0x9c7, 0x9c8}, {0x9cb, 0x9ce}, {0x9d7, 0x9d7}, {0x9dc, 0x9dd}, {0x9df, 0x9e3}, {0x9e6, 0x9f1}, {0x9fc, 0x9fc}, {0x9fe, 0x9fe},
  {0xa01, 0xa03}, {0xa05, 0xa0a}, {0xa0f, 0xa10}, {0xa13, 0xa28}, {0xa2a, 0xa30}, {0xa32, 0xa33}, {0xa35, 0xa36}, {0xa38, 0xa39},
  {0xa3c, 0xa3c}, {0xa3e, 0xa42}, {0xa47, 0xa48}, {0xa4b, 0xa4d}, {0xa51, 0xa51}, {0xa59, 0xa5c}, {0xa5e, 0xa5e}, {0xa66, 0xa75},
  {0xa81, 0xa83}, {0xa85, 0xa8d}, {0xa8f, 0xa91}, {0xa93, 0xaa8}, {0xaaa, 0xab0}, {0xab2, 0xab3}, {0xab5, 0xab9}, {0xabc, 0xac5},
  {0xac7, 0xac9}, {0xacb, 0xacd}, {0xad0, 0xad0}, {0xae0, 0xae3}, {0xae6, 0xaef}, {0xaf9, 0xaff}, {0xb01, 0xb03}, {0xb05, 0xb0c},
  {0xb0f, 0xb10}, {0xb13, 0xb28}, {0xb2a, 0xb30}, {0xb32, 0xb33}, {0xb35, 0xb39}, {0xb3c, 0xb44}, {0xb47, 0xb48}, {0xb4b, 0xb4d},
  {0xb55, 0xb57}, {0xb5c, 0xb5d}, {0xb5f, 0xb63}, {0xb66, 0xb6f}, {0xb71, 0xb71}, {0xb82, 0xb83}, {0xb85, 0xb8a}, {0xb8e, 0xb90},
  {0xb92, 0xb95}, {0xb99, 0xb9a}, {0xb9c, 0xb9c}, {0xb9e, 0xb9f}, {0xba3, 0xba4}, {0xba8, 0xbaa}, {0xbae, 0xbb9}, {0xbbe, 0xbc2},
  {0xbc6, 0xbc8}, {0xbca, 0xbcd}, {0xbd0, 0xbd0}, {0xbd7, 0xbd7}, {0xbe6, 0xbef}, {0xc00, 0xc0c}, {0xc0e, 0xc10}, {0xc12, 0xc28},
  {0xc2a, 0xc39}, {0xc3c, 0xc44}, {0xc46, 0xc48}, {0xc4a, 0xc4d}, {0xc55, 0xc56}, {0xc58, 0xc5a}, {0xc5d, 0xc5d}, {0xc60, 0xc63},
  {0xc66, 0xc6f}, {0xc80, 0xc83}, {0xc85, 0xc8c}, {0xc8e, 0xc90}, {0xc92, 0xca8}, {0xcaa, 0xcb3}, {0xcb5, 0xcb9}, {0xcbc, 0xcc4},
  {0xcc6, 0xcc8}, {0xcca, 0xccd}, {0xcd5, 0xcd6}, {0xcdd, 0xcde}, {0xce0, 0xce3}, {0xce6, 0xcef}, {0xcf1, 0xcf3}, {0xd00, 0xd0c},
  {0xd0e, 0xd10}, {0xd12, 0xd44}, {0xd46, 0xd48}, {0xd4a, 0xd4e}, {0xd54, 0xd57}, {0xd5f, 0xd63}, {0xd66, 0xd6f}, {0xd7a, 0xd7f},
  {0xd81, 0xd83}, {0xd85, 0xd96}, {0xd9a, 0xdb1}, {0xdb3, 0xdbb}, {0xdbd, 0xdbd}, {0xdc0, 0xdc6}, {0xdca, 0xdca}, {0xdcf, 0xdd4},
  {0xdd6, 0xdd6}, {0xdd8, 0xddf}, {0xde6, 0xdef}, {0xdf2, 0xdf3}, {0xe01, 0xe3a}, {0xe40, 0xe4e}, {0xe50, 0xe59}, {0xe81, 0xe82},
  {0xe84, 0xe84}, {0xe86, 0xe8a}, {0xe8c, 0xea3}, {0xea5, 0xea5}, {0xea7, 0xebd}, {0xec0, 0xec4}, {0xec6, 0xec6}, {0xec8, 0xece},
  {0xed0, 0xed9}, {0xedc, 0xedf}, {0xf00, 0xf00}, {0xf18, 0xf19}, {0xf20, 0xf29}, {0xf35, 0xf35}, {0xf37, 0xf37}, {0xf39, 0xf39},
  {0xf3e, 0xf47}, {0xf49, 0xf6c}, {0xf71, 0xf84}, {0xf86, 0xf97}, {0xf99, 0xfbc}, {0xfc6, 0xfc6}, {0x1000, 0x1049}, {0x1050, 0x109d},
  {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fc, 0x1248}, {0x124a, 0x124d}, {0x1250, 0x1256}, {0x1258, 0x1258},
  {0x125a, 0x125d}, {0x1260, 0x1288}, {0x128a, 0x128d}, {0x1290, 0x12b0}, {0x12b2, 0x12b5}, {0x12b8, 0x12be}, {0x12c0, 0x12c0}, {0x12c2, 0x12c5},
  {0x12c8, 0x12d6}, {0x12d8, 0x1310}, {0x1312, 0x1315}, {0x1318, 0x135a}, {0x135d, 0x135f}, {0x1369, 0x1371}, {0x1380, 0x138f}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1401, 0x166c}, {0x166f, 0x167f}, {0x1681, 0x169a}, {0x16a0, 0x16ea}, {0x16ee, 0x16f8}, {0x1700, 0x1715}, {0x171f, 0x1734},
  {0x1740, 0x1753}, {0x1760, 0x176c}, {0x176e, 0x1770}, {0x1772, 0x1773}, {0x1780, 0x17d3}, {0x17d7, 0x17d7}, {0x17dc, 0x17dd}, {0x17e0, 0x17e9},
  {0x180b, 0x180d}, {0x180f, 0x1819}, {0x1820, 0x1878}, {0x1880, 0x18aa}, {0x18b0, 0x18f5}, {0x1900, 0x191e}, {0x1920, 0x192b}, {0x1930, 0x193b},
  {0x1946, 0x196d}, {0x1970, 0x1974}, {0x1980, 0x19ab}, {0x19b0, 0x19c9}, {0x19d0, 0x19da}, {0x1a00, 0x1a1b}, {0x1a20, 0x1a5e}, {0x1a60, 0x1a7c},
  {0x1a7f, 0x1a89}, {0x1a90, 0x1a99}, {0x1aa7, 0x1aa7}, {0x1ab0, 0x1abd}, {0x1abf, 0x1ace}, {0x1b00, 0x1b4c}, {0x1b50, 0x1b59}, {0x1b6b, 0x1b73},
  {0x1b80, 0x1bf3}, {0x1c00, 0x1c37}, {0x1c40, 0x1c49}, {0x1c4d, 0x1c7d}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1cd0, 0x1cd2},
  {0x1cd4, 0x1cfa}, {0x1d00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b},
  {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1fb4}, {0x1fb6, 0x1fbc}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcc}, {0x1fd0, 0x1fd3},
  {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffc}, {0x200c, 0x200d}, {0x203f, 0x2040}, {0x2054, 0x2054}, {0x2071, 0x2071},
  {0x207f, 0x207f}, {0x2090, 0x209c}, {0x20d0, 0x20dc}, {0x20e1, 0x20e1}, {0x20e5, 0x20f0}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2118, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2160, 0x2188}, {0x2c00, 0x2ce4}, {0x2ceb, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0x2d30, 0x2d67},
  {0x2d6f, 0x2d6f}, {0x2d7f, 0x2d96}, {0x2da0, 0x2da6}, {0x2da8, 0x2dae}, {0x2db0, 0x2db6}, {0x2db8, 0x2dbe}, {0x2dc0, 0x2dc6}, {0x2dc8, 0x2dce},
  {0x2dd0, 0x2dd6}, {0x2dd8, 0x2dde}, {0x2de0, 0x2dff}, {0x3005, 0x3007}, {0x3021, 0x302f}, {0x3031, 0x3035}, {0x3038, 0x303c}, {0x3041, 0x3096},
  {0x3099, 0x309a}, {0x309d, 0x309f}, {0x30a1, 0x30ff}, {0x3105, 0x312f}, {0x3131, 0x318e}, {0x31a0, 0x31bf}, {0x31f0, 0x31ff}, {0x3400, 0x4dbf},
  {0x4e00, 0xa48c}, {0xa4d0, 0xa4fd}, {0xa500, 0xa60c}, {0xa610, 0xa62b}, {0xa640, 0xa66f}, {0xa674, 0xa67d}, {0xa67f, 0xa6f1}, {0xa717, 0xa71f},
  {0xa722, 0xa788}, {0xa78b, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f2, 0xa827}, {0xa82c, 0xa82c}, {0xa840, 0xa873},
  {0xa880, 0xa8c5}, {0xa8d0, 0xa8d9}, {0xa8e0, 0xa8f7}, {0xa8fb, 0xa8fb}, {0xa8fd, 0xa92d}, {0xa930, 0xa953}, {0xa960, 0xa97c}, {0xa980, 0xa9c0},
  {0xa9cf, 0xa9d9}, {0xa9e0, 0xa9fe}, {0xaa00, 0xaa36}, {0xaa40, 0xaa4d}, {0xaa50, 0xaa59}, {0xaa60, 0xaa76}, {0xaa7a, 0xaac2}, {0xaadb, 0xaadd},
  {0xaae0, 0xaaef}, {0xaaf2, 0xaaf6}, {0xab01, 0xab06}, {0xab09, 0xab0e}, {0xab11, 0xab16}, {0xab20, 0xab26}, {0xab28, 0xab2e}, {0xab30, 0xab5a},
  {0xab5c, 0xab69}, {0xab70, 0xabea}, {0xabec, 0xabed}, {0xabf0, 0xabf9}, {0xac00, 0xd7a3}, {0xd7b0, 0xd7c6}, {0xd7cb, 0xd7fb}, {0xf900, 0xfa6d},
  {0xfa70, 0xfad9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xfb1d, 0xfb28}, {0xfb2a, 0xfb36}, {0xfb38, 0xfb3c}, {0xfb3e, 0xfb3e}, {0xfb40, 0xfb41},
  {0xfb43, 0xfb44}, {0xfb46, 0xfbb1}, {0xfbd3, 0xfc5d}, {0xfc64, 0xfd3d}, {0xfd50, 0xfd8f}, {0xfd92, 0xfdc7}, {0xfdf0, 0xfdf9}, {0xfe00, 0xfe0f},
  {0xfe20, 0xfe2f}, {0xfe33, 0xfe34}, {0xfe4d, 0xfe4f}, {0xfe71, 0xfe71}, {0xfe73, 0xfe73}, {0xfe77, 0xfe77}, {0xfe79, 0xfe79}, {0xfe7b, 0xfe7b},
  {0xfe7d, 0xfe7d}, {0xfe7f, 0xfefc}, {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff3f, 0xff3f}, {0xff41, 0xff5a}, {0xff65, 0xffbe}, {0xffc2, 0xffc7},
  {0xffca, 0xffcf}, {0xffd2, 0xffd7}, {0xffda, 0xffdc}, {0x10000, 0x1000b}, {0x1000d, 0x10026}, {0x10028, 0x1003a}, {0x1003c, 0x1003d}, {0x1003f, 0x1004d},
  {0x10050, 0x1005d}, {0x10080, 0x100fa}, {0x10140, 0x10174}, {0x101fd, 0x101fd}, {0x10280, 0x1029c}, {0x102a0, 0x102d0}, {0x102e0, 0x102e0}, {0x10300, 0x1031f},
  {0x1032d, 0x1034a}, {0x10350, 0x1037a}, {0x10380, 0x1039d}, {0x103a0, 0x103c3}, {0x103c8, 0x103cf}, {0x103d1, 0x103d5}, {0x10400, 0x1049d}, {0x104a0, 0x104a9},
  {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10500, 0x10527}, {0x10530, 0x10563}, {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595},
  {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc}, {0x10600, 0x10736}, {0x10740, 0x10755}, {0x10760, 0x10767}, {0x10780, 0x10785},
  {0x10787, 0x107b0}, {0x107b2, 0x107ba}, {0x10800, 0x10805}, {0x10808, 0x10808}, {0x1080a, 0x10835}, {0x10837, 0x10838}, {0x1083c, 0x1083c}, {0x1083f, 0x10855},
  {0x10860, 0x10876}, {0x10880, 0x1089e}, {0x108e0, 0x108f2}, {0x108f4, 0x108f5}, {0x10900, 0x10915}, {0x10920, 0x10939}, {0x10980, 0x109b7}, {0x109be, 0x109bf},
  {0x10a00, 0x10a03}, {0x10a05, 0x10a06}, {0x10a0c, 0x10a13}, {0x10a15, 0x10a17}, {0x10a19, 0x10a35}, {0x10a38, 0x10a3a}, {0x10a3f, 0x10a3f}, {0x10a60, 0x10a7c},
  {0x10a80, 0x10a9c}, {0x10ac0, 0x10ac7}, {0x10ac9, 0x10ae6}, {0x10b00, 0x10b35}, {0x10b40, 0x10b55}, {0x10b60, 0x10b72}, {0x10b80, 0x10b91}, {0x10c00, 0x10c48},
  {0x10c80, 0x10cb2}, {0x10cc0, 0x10cf2}, {0x10d00, 0x10d27}, {0x10d30, 0x10d39}, {0x10e80, 0x10ea9}, {0x10eab, 0x10eac}, {0x10eb0, 0x10eb1}, {0x10efd, 0x10f1c},
  {0x10f27, 0x10f27}, {0x10f30, 0x10f50}, {0x10f70, 0x10f85}, {0x10fb0, 0x10fc4}, {0x10fe0, 0x10ff6}, {0x11000, 0x11046}, {0x11066, 0x11075}, {0x1107f, 0x110ba},
  {0x110c2, 0x110c2}, {0x110d0, 0x110e8}, {0x110f0, 0x110f9}, {0x11100, 0x11134}, {0x11136, 0x1113f}, {0x11144, 0x11147}, {0x11150, 0x11173}, {0x11176, 0x11176},
  {0x11180, 0x111c4}, {0x111c9, 0x111cc}, {0x111ce, 0x111da}, {0x111dc, 0x111dc}, {0x11200, 0x11211}, {0x11213, 0x11237}, {0x1123e, 0x11241}, {0x11280, 0x11286},
  {0x11288, 0x11288}, {0x1128a, 0x1128d}, {0x1128f, 0x1129d}, {0x1129f, 0x112a8}, {0x112b0, 0x112ea}, {0x112f0, 0x112f9}, {0x11300, 0x11303}, {0x11305, 0x1130c},
  {0x1130f, 0x11310}, {0x11313, 0x11328}, {0x1132a, 0x11330}, {0x11332, 0x11333}, {0x11335, 0x11339}, {0x1133b, 0x11344}, {0x11347, 0x11348}, {0x1134b, 0x1134d},
  {0x11350, 0x11350}, {0x11357, 0x11357}, {0x1135d, 0x11363}, {0x11366, 0x1136c}, {0x11370, 0x11374}, {0x11400, 0x1144a}, {0x11450, 0x11459}, {0x1145e, 0x11461},
  {0x11480, 0x114c5}, {0x114c7, 0x114c7}, {0x114d0, 0x114d9}, {0x11580, 0x115b5}, {0x115b8, 0x115c0}, {0x115d8, 0x115dd}, {0x11600, 0x11640}, {0x11644, 0x11644},
  {0x11650, 0x11659}, {0x11680, 0x116b8}, {0x116c0, 0x116c9}, {0x11700, 0x1171a}, {0x1171d, 0x1172b}, {0x11730, 0x11739}, {0x11740, 0x11746}, {0x11800, 0x1183a},
  {0x118a0, 0x118e9}, {0x118ff, 0x11906}, {0x11909, 0x11909}, {0x1190c, 0x11913}, {0x11915, 0x11916}, {0x11918, 0x11935}, {0x11937, 0x11938}, {0x1193b, 0x11943},
  {0x11950, 0x11959}, {0x119a0, 0x119a7}, {0x119aa, 0x119d7}, {0x119da, 0x119e1}, {0x119e3, 0x119e4}, {0x11a00, 0x11a3e}, {0x11a47, 0x11a47}, {0x11a50, 0x11a99},
  {0x11a9d, 0x11a9d}, {0x11ab0, 0x11af8}, {0x11c00, 0x11c08}, {0x11c0a, 0x11c36}, {0x11c38, 0x11c40}, {0x11c50, 0x11c59}, {0x11c72, 0x11c8f}, {0x11c92, 0x11ca7},
  {0x11ca9, 0x11cb6}, {0x11d00, 0x11d06}, {0x11d08, 0x11d09}, {0x11d0b, 0x11d36}, {0x11d3a, 0x11d3a}, {0x11d3c, 0x11d3d}, {0x11d3f, 0x11d47}, {0x11d50, 0x11d59},
  {0x11d60, 0x11d65}, {0x11d67, 0x11d68}, {0x11d6a, 0x11d8e}, {0x11d90, 0x11d91}, {0x11d93, 0x11d98}, {0x11da0, 0x11da9}, {0x11ee0, 0x11ef6}, {0x11f00, 0x11f10},
  {0x11f12, 0x11f3a}, {0x11f3e, 0x11f42}, {0x11f50, 0x11f59}, {0x11fb0, 0x11fb0}, {0x12000, 0x12399}, {0x12400, 0x1246e}, {0x12480, 0x12543}, {0x12f90, 0x12ff0},
  {0x13000, 0x1342f}, {0x13440, 0x13455}, {0x14400, 0x14646}, {0x16800, 0x16a38}, {0x16a40, 0x16a5e}, {0x16a60, 0x16a69}, {0x16a70, 0x16abe}, {0x16ac0, 0x16ac9},
  {0x16ad0, 0x16aed}, {0x16af0, 0x16af4}, {0x16b00, 0x16b36}, {0x16b40, 0x16b43}, {0x16b50, 0x16b59}, {0x16b63, 0x16b77}, {0x16b7d, 0x16b8f}, {0x16e40, 0x16e7f},
  {0x16f00, 0x16f4a}, {0x16f4f, 0x16f87}, {0x16f8f, 0x16f9f}, {0x16fe0, 0x16fe1}, {0x16fe3, 0x16fe4}, {0x16ff0, 0x16ff1}, {0x17000, 0x187f7}, {0x18800, 0x18cd5},
  {0x18d00, 0x18d08}, {0x1aff0, 0x1aff3}, {0x1aff5, 0x1affb}, {0x1affd, 0x1affe}, {0x1b000, 0x1b122}, {0x1b132, 0x1b132}, {0x1b150, 0x1b152}, {0x1b155, 0x1b155},
  {0x1b164, 0x1b167}, {0x1b170, 0x1b2fb}, {0x1bc00, 0x1bc6a}, {0x1bc70, 0x1bc7c}, {0x1bc80, 0x1bc88}, {0x1bc90, 0x1bc99}, {0x1bc9d, 0x1bc9e}, {0x1cf00, 0x1cf2d},
  {0x1cf30, 0x1cf46}, {0x1d165, 0x1d169}, {0x1d16d, 0x1d172}, {0x1d17b, 0x1d182}, {0x1d185, 0x1d18b}, {0x1d1aa, 0x1d1ad}, {0x1d242, 0x1d244}, {0x1d400, 0x1d454},
  {0x1d456, 0x1d49c}, {0x1d49e, 0x1d49f}, {0x1d4a2, 0x1d4a2}, {0x1d4a5, 0x1d4a6}, {0x1d4a9, 0x1d4ac}, {0x1d4ae, 0x1d4b9}, {0x1d4bb, 0x1d4bb}, {0x1d4bd, 0x1d4c3},
  {0x1d4c5, 0x1d505}, {0x1d507, 0x1d50a}, {0x1d50d, 0x1d514}, {0x1d516, 0x1d51c}, {0x1d51e, 0x1d539}, {0x1d53b, 0x1d53e}, {0x1d540, 0x1d544}, {0x1d546, 0x1d546},
  {0x1d54a, 0x1d550}, {0x1d552, 0x1d6a5}, {0x1d6a8, 0x1d6c0}, {0x1d6c2, 0x1d6da}, {0x1d6dc, 0x1d6fa}, {0x1d6fc, 0x1d714}, {0x1d716, 0x1d734}, {0x1d736, 0x1d74e},
  {0x1d750, 0x1d76e}, {0x1d770, 0x1d788}, {0x1d78a, 0x1d7a8}, {0x1d7aa, 0x1d7c2}, {0x1d7c4, 0x1d7cb}, {0x1d7ce, 0x1d7ff}, {0x1da00, 0x1da36}, {0x1da3b, 0x1da6c},
  {0x1da75, 0x1da75}, {0x1da84, 0x1da84}, {0x1da9b, 0x1da9f}, {0x1daa1, 0x1daaf}, {0x1df00, 0x1df1e}, {0x1df25, 0x1df2a}, {0x1e000, 0x1e006}, {0x1e008, 0x1e018},
  {0x1e01b, 0x1e021}, {0x1e023, 0x1e024}, {0x1e026, 0x1e02a}, {0x1e030, 0x1e06d}, {0x1e08f, 0x1e08f}, {0x1e100, 0x1e12c}, {0x1e130, 0x1e13d}, {0x1e140, 0x1e149},
  {0x1e14e, 0x1e14e}, {0x1e290, 0x1e2ae}, {0x1e2c0, 0x1e2f9}, {0x1e4d0, 0x1e4f9}, {0x1e7e0, 0x1e7e6}, {0x1e7e8, 0x1e7eb}, {0x1e7ed, 0x1e7ee}, {0x1e7f0, 0x1e7fe},
  {0x1e800, 0x1e8c4}, {0x1e8d0, 0x1e8d6}, {0x1e900, 0x1e94b}, {0x1e950, 0x1e959}, {0x1ee00, 0x1ee03}, {0x1ee05, 0x1ee1f}, {0x1ee21, 0x1ee22}, {0x1ee24, 0x1ee24},
  {0x1ee27, 0x1ee27}, {0x1ee29, 0x1ee32}, {0x1ee34, 0x1ee37}, {0x1ee39, 0x1ee39}, {0x1ee3b, 0x1ee3b}, {0x1ee42, 0x1ee42}, {0x1ee47, 0x1ee47}, {0x1ee49, 0x1ee49},
  {0x1ee4b, 0x1ee4b}, {0x1ee4d, 0x1ee4f}, {0x1ee51, 0x1ee52}, {0x1ee54, 0x1ee54}, {0x1ee57, 0x1ee57}, {0x1ee59, 0x1ee59}, {0x1ee5b, 0x1ee5b}, {0x1ee5d, 0x1ee5d},
  {0x1ee5f, 0x1ee5f}, {0x1ee61, 0x1ee62}, {0x1ee64, 0x1ee64}, {0x1ee67, 0x1ee6a}, {0x1ee6c, 0x1ee72}, {0x1ee74, 0x1ee77}, {0x1ee79, 0x1ee7c}, {0x1ee7e, 0x1ee7e},
  {0x1ee80, 0x1ee89}, {0x1ee8b, 0x1ee9b}, {0x1eea1, 0x1eea3}, {0x1eea5, 0x1eea9}, {0x1eeab, 0x1eebb}, {0x1fbf0, 0x1fbf9}, {0x20000, 0x2a6df}, {0x2a700, 0x2b739},
  {0x2b740, 0x2b81d}, {0x2b820, 0x2cea1}, {0x2ceb0, 0x2ebe0}, {0x2ebf0, 0x2ee5d}, {0x2f800, 0x2fa1d}, {0x30000, 0x3134a}, {0x31350, 0x323af}, {0xe0100, 0xe01ef},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(32);
      ADVANCE_MAP(
        '\n', 116,
        '\r', 126,
        '!', 100,
        '#', 13,
        '%', 98,
        '&', 85,
        '(', 69,
        ')', 70,
        '*', 94,
        '+', 89,
        ',', 68,
        '-', 92,
        '.', 72,
        '/', 96,
        '0', 38,
        ':', 74,
        ';', 33,
        '=', 76,
        '@', 73,
        '[', 102,
        ']', 103,
        '^', 82,
        '_', 104,
        '{', 35,
        '|', 79,
        '}', 36,
        '~', 101,
        'a', 63,
        'b', 63,
        'g', 63,
        'r', 63,
      );
      if (('w' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (('\t' <= lookahead && lookahead <= '\f') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(67);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '\n', 116,
        '\r', 126,
        '!', 100,
        '#', 14,
        '%', 97,
        '&', 84,
        '(', 69,
        '*', 93,
        '+', 88,
        '-', 90,
        '.', 72,
        '/', 95,
        '0', 38,
        ':', 9,
        '=', 11,
        '[', 102,
        '^', 81,
        '_', 29,
        '|', 80,
        '~', 101,
        '\t', 125,
        0x0b, 125,
        '\f', 125,
        ' ', 125,
        0x85, 125,
        0x200e, 125,
        0x200f, 125,
        0x2028, 125,
        0x2029, 125,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(67);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '\n', 116,
        '\r', 126,
        '!', 99,
        '#', 14,
        '&', 83,
        '(', 69,
        '*', 93,
        '-', 90,
        '.', 21,
        '/', 8,
        '0', 38,
        '_', 29,
        '~', 101,
        '\t', 125,
        0x0b, 125,
        '\f', 125,
        ' ', 125,
        0x85, 125,
        0x200e, 125,
        0x200f, 125,
        0x2028, 125,
        0x2029, 125,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(67);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 10,
        '#', 14,
        '%', 98,
        '&', 85,
        '(', 69,
        '*', 94,
        '+', 89,
        '-', 91,
        '.', 71,
        '/', 96,
        ':', 9,
        ';', 33,
        '=', 76,
        '[', 102,
        '^', 82,
        '|', 79,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 10,
        '#', 14,
        '%', 97,
        '&', 84,
        '(', 69,
        ')', 70,
        '*', 93,
        '+', 88,
        ',', 68,
        '-', 90,
        '.', 71,
        '/', 95,
        ':', 74,
        ';', 33,
        '=', 11,
        '@', 73,
        '[', 102,
        ']', 103,
        '^', 81,
        '{', 35,
        '|', 80,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      END_STATE();
    case 5:
      if (lookahead == '#') ADVANCE(14);
      if (lookahead == '-') ADVANCE(12);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == '{') ADVANCE(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      END_STATE();
    case 6:
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(15);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(6);
      END_STATE();
    case 7:
      if (lookahead == '.') ADVANCE(28);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 8:
      if (lookahead == '/') ADVANCE(124);
      END_STATE();
    case 9:
      if (lookahead == ':') ADVANCE(34);
      END_STATE();
    case 10:
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 11:
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 12:
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 13:
      if (lookahead == 'i') ADVANCE(117);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 14:
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(14);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 15:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 16:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(23);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 17:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(24);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 18:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(25);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 19:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(26);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 20:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(27);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 21:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 22:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 23:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 24:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 25:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 26:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 27:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 28:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 29:
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 30:
      if (eof) ADVANCE(32);
      ADVANCE_MAP(
        '!', 99,
        '#', 14,
        '&', 83,
        '(', 69,
        ')', 70,
        '*', 93,
        ',', 68,
        '-', 90,
        '.', 72,
        '/', 8,
        '0', 38,
        ':', 74,
        ';', 33,
        '=', 75,
        '@', 73,
        '_', 104,
        '{', 35,
        '}', 36,
        '~', 101,
        'a', 63,
        'b', 63,
        'g', 63,
        'r', 63,
      );
      if (('w' <= lookahead && lookahead <= 'z')) ADVANCE(66);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(40);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(67);
      END_STATE();
    case 31:
      if (eof) ADVANCE(32);
      if (lookahead == '#') ADVANCE(13);
      if (lookahead == '/') ADVANCE(8);
      if (lookahead == ':') ADVANCE(9);
      if (lookahead == ';') ADVANCE(33);
      if (lookahead == '@') ADVANCE(73);
      if (lookahead == '_') ADVANCE(29);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0x85 ||
          lookahead == 0x200e ||
          lookahead == 0x200f ||
          lookahead == 0x2028 ||
          lookahead == 0x2029) ADVANCE(125);
      if (set_contains(sym_identifier_character_set_1, 668, lookahead)) ADVANCE(67);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(aux_sym_decimal_int_literal_token1);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym_decimal_int_literal_token1);
      ADVANCE_MAP(
        '.', 49,
        'E', 15,
        'e', 15,
        'X', 7,
        'x', 7,
        'f', 43,
        'h', 43,
        'i', 37,
        'u', 37,
      );
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(6);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym_decimal_int_literal_token2);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym_decimal_int_literal_token2);
      if (lookahead == '.') ADVANCE(49);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(15);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(44);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(sym_hex_int_literal);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(sym_hex_int_literal);
      if (lookahead == '.') ADVANCE(57);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(18);
      if (lookahead == 'i' ||
          lookahead == 'u') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token1);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token2);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token3);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token3);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(16);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token3);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(45);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(47);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token4);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token4);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(17);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token4);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(50);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token5);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym__decimal_float_literal_token5);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token1);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token1);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(19);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token1);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token2);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token2);
      if (lookahead == 'P' ||
          lookahead == 'p') ADVANCE(20);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token2);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token3);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym__hex_float_literal_token3);
      if (lookahead == 'f' ||
          lookahead == 'h') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'g' ||
          lookahead == 'r') ADVANCE(67);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'g' ||
          lookahead == 'r') ADVANCE(61);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a' ||
          lookahead == 'b' ||
          lookahead == 'g' ||
          lookahead == 'r') ADVANCE(62);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (('w' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (('w' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (('w' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(34);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(86);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(111);
      if (lookahead == '|') ADVANCE(77);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(77);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(78);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(78);
      if (lookahead == '=') ADVANCE(110);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(113);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(114);
      if (lookahead == '=') ADVANCE(106);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(114);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(107);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(124);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(124);
      if (lookahead == '=') ADVANCE(108);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(109);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(87);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym__);
      if (set_contains(sym_identifier_character_set_2, 776, lookahead)) ADVANCE(67);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(aux_sym_preproc_custom_token1);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'm') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'o') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'p') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 'r') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (lookahead == 't') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_preproc_directive);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_POUNDimport);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(122);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(124);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym__blankspace);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym__blankspace);
      if (lookahead == '\n') ADVANCE(116);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'l', 8,
        'o', 9,
        'r', 10,
        's', 11,
        't', 12,
        'v', 13,
        'w', 14,
      );
      END_STATE();
    case 1:
      if (lookahead == 'l') ADVANCE(15);
      if (lookahead == 's') ADVANCE(16);
      END_STATE();
    case 2:
      if (lookahead == 'r') ADVANCE(17);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(18);
      if (lookahead == 'o') ADVANCE(19);
      END_STATE();
    case 4:
      if (lookahead == 'e') ADVANCE(20);
      if (lookahead == 'i') ADVANCE(21);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(22);
      if (lookahead == 'n') ADVANCE(23);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(24);
      if (lookahead == 'n') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(27);
      if (lookahead == 'm') ADVANCE(28);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      END_STATE();
    case 9:
      if (lookahead == 'v') ADVANCE(31);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 't') ADVANCE(33);
      if (lookahead == 'w') ADVANCE(34);
      END_STATE();
    case 12:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(36);
      if (lookahead == 'i') ADVANCE(37);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(38);
      END_STATE();
    case 15:
      if (lookahead == 'i') ADVANCE(39);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 17:
      if (lookahead == 'e') ADVANCE(40);
      END_STATE();
    case 18:
      if (lookahead == 's') ADVANCE(41);
      END_STATE();
    case 19:
      if (lookahead == 'n') ADVANCE(42);
      END_STATE();
    case 20:
      if (lookahead == 'f') ADVANCE(43);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(44);
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 22:
      if (lookahead == 's') ADVANCE(46);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(47);
      END_STATE();
    case 24:
      if (lookahead == 'l') ADVANCE(48);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 26:
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 28:
      if (lookahead == 'p') ADVANCE(50);
      END_STATE();
    case 29:
      if (lookahead == 't') ADVANCE(51);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(52);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(53);
      END_STATE();
    case 32:
      if (lookahead == 'q') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      END_STATE();
    case 33:
      if (lookahead == 'r') ADVANCE(56);
      END_STATE();
    case 34:
      if (lookahead == 'i') ADVANCE(57);
      END_STATE();
    case 35:
      if (lookahead == 'u') ADVANCE(58);
      END_STATE();
    case 36:
      if (lookahead == 'r') ADVANCE(59);
      END_STATE();
    case 37:
      if (lookahead == 'r') ADVANCE(60);
      END_STATE();
    case 38:
      if (lookahead == 'i') ADVANCE(61);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 40:
      if (lookahead == 'a') ADVANCE(63);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(64);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(65);
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 44:
      if (lookahead == 'g') ADVANCE(68);
      END_STATE();
    case 45:
      if (lookahead == 'c') ADVANCE(69);
      END_STATE();
    case 46:
      if (lookahead == 'e') ADVANCE(70);
      END_STATE();
    case 47:
      if (lookahead == 'b') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 50:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 52:
      if (lookahead == 'p') ADVANCE(74);
      END_STATE();
    case 53:
      if (lookahead == 'r') ADVANCE(75);
      END_STATE();
    case 54:
      if (lookahead == 'u') ADVANCE(76);
      END_STATE();
    case 55:
      if (lookahead == 'u') ADVANCE(77);
      END_STATE();
    case 56:
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 57:
      if (lookahead == 't') ADVANCE(79);
      END_STATE();
    case 58:
      if (lookahead == 'e') ADVANCE(80);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 60:
      if (lookahead == 't') ADVANCE(81);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(82);
      END_STATE();
    case 62:
      if (lookahead == 's') ADVANCE(83);
      END_STATE();
    case 63:
      if (lookahead == 'k') ADVANCE(84);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 65:
      if (lookahead == 't') ADVANCE(85);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(86);
      END_STATE();
    case 67:
      if (lookahead == 'u') ADVANCE(87);
      END_STATE();
    case 68:
      if (lookahead == 'n') ADVANCE(88);
      END_STATE();
    case 69:
      if (lookahead == 'a') ADVANCE(89);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 71:
      if (lookahead == 'l') ADVANCE(90);
      END_STATE();
    case 72:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 73:
      if (lookahead == 'r') ADVANCE(92);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 76:
      if (lookahead == 'i') ADVANCE(94);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(95);
      END_STATE();
    case 78:
      if (lookahead == 'c') ADVANCE(96);
      END_STATE();
    case 79:
      if (lookahead == 'c') ADVANCE(97);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 81:
      if (lookahead == 'u') ADVANCE(98);
      END_STATE();
    case 82:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_alias);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_const);
      if (lookahead == '_') ADVANCE(100);
      END_STATE();
    case 86:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 87:
      if (lookahead == 'l') ADVANCE(102);
      END_STATE();
    case 88:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(104);
      END_STATE();
    case 90:
      if (lookahead == 'e') ADVANCE(105);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 92:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 93:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(108);
      END_STATE();
    case 95:
      if (lookahead == 'n') ADVANCE(109);
      END_STATE();
    case 96:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 97:
      if (lookahead == 'h') ADVANCE(111);
      END_STATE();
    case 98:
      if (lookahead == 'a') ADVANCE(112);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 101:
      if (lookahead == 'u') ADVANCE(114);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(115);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(116);
      END_STATE();
    case 104:
      if (lookahead == 'd') ADVANCE(117);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_enable);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 107:
      if (lookahead == 'd') ADVANCE(118);
      END_STATE();
    case 108:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 112:
      if (lookahead == 'l') ADVANCE(120);
      END_STATE();
    case 113:
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 114:
      if (lookahead == 'e') ADVANCE(122);
      if (lookahead == 'i') ADVANCE(123);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(124);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_discard);
      END_STATE();
    case 118:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 119:
      if (lookahead == 's') ADVANCE(126);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_virtual);
      END_STATE();
    case 121:
      if (lookahead == 's') ADVANCE(127);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 123:
      if (lookahead == 'n') ADVANCE(128);
      END_STATE();
    case 124:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_requires);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 128:
      if (lookahead == 'g') ADVANCE(131);
      END_STATE();
    case 129:
      if (lookahead == 'c') ADVANCE(132);
      END_STATE();
    case 130:
      if (lookahead == 'r') ADVANCE(133);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_continuing);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_diagnostic);
      END_STATE();
    case 133:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_const_assert);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 31, .external_lex_state = 2},
  [2] = {.lex_state = 30, .external_lex_state = 2},
  [3] = {.lex_state = 30, .external_lex_state = 2},
  [4] = {.lex_state = 30, .external_lex_state = 2},
  [5] = {.lex_state = 30, .external_lex_state = 2},
  [6] = {.lex_state = 30, .external_lex_state = 2},
  [7] = {.lex_state = 30, .external_lex_state = 2},
  [8] = {.lex_state = 30, .external_lex_state = 2},
  [9] = {.lex_state = 30, .external_lex_state = 2},
  [10] = {.lex_state = 30, .external_lex_state = 2},
  [11] = {.lex_state = 30, .external_lex_state = 2},
  [12] = {.lex_state = 30, .external_lex_state = 2},
  [13] = {.lex_state = 30, .external_lex_state = 2},
  [14] = {.lex_state = 30, .external_lex_state = 2},
  [15] = {.lex_state = 30, .external_lex_state = 2},
  [16] = {.lex_state = 30, .external_lex_state = 2},
  [17] = {.lex_state = 30, .external_lex_state = 2},
  [18] = {.lex_state = 30, .external_lex_state = 2},
  [19] = {.lex_state = 30, .external_lex_state = 2},
  [20] = {.lex_state = 30, .external_lex_state = 2},
  [21] = {.lex_state = 30, .external_lex_state = 2},
  [22] = {.lex_state = 2, .external_lex_state = 2},
  [23] = {.lex_state = 2, .external_lex_state = 2},
  [24] = {.lex_state = 30, .external_lex_state = 2},
  [25] = {.lex_state = 30, .external_lex_state = 3},
  [26] = {.lex_state = 30, .external_lex_state = 2},
  [27] = {.lex_state = 30, .external_lex_state = 2},
  [28] = {.lex_state = 30, .external_lex_state = 2},
  [29] = {.lex_state = 30, .external_lex_state = 2},
  [30] = {.lex_state = 30, .external_lex_state = 3},
  [31] = {.lex_state = 2, .external_lex_state = 2},
  [32] = {.lex_state = 30, .external_lex_state = 2},
  [33] = {.lex_state = 30, .external_lex_state = 2},
  [34] = {.lex_state = 30, .external_lex_state = 2},
  [35] = {.lex_state = 30, .external_lex_state = 2},
  [36] = {.lex_state = 30, .external_lex_state = 2},
  [37] = {.lex_state = 30, .external_lex_state = 2},
  [38] = {.lex_state = 30, .external_lex_state = 2},
  [39] = {.lex_state = 30, .external_lex_state = 2},
  [40] = {.lex_state = 30, .external_lex_state = 2},
  [41] = {.lex_state = 30, .external_lex_state = 2},
  [42] = {.lex_state = 30, .external_lex_state = 2},
  [43] = {.lex_state = 30, .external_lex_state = 2},
  [44] = {.lex_state = 30, .external_lex_state = 2},
  [45] = {.lex_state = 30, .external_lex_state = 2},
  [46] = {.lex_state = 30, .external_lex_state = 2},
  [47] = {.lex_state = 30, .external_lex_state = 2},
  [48] = {.lex_state = 30, .external_lex_state = 2},
  [49] = {.lex_state = 30, .external_lex_state = 2},
  [50] = {.lex_state = 30, .external_lex_state = 2},
  [51] = {.lex_state = 30, .external_lex_state = 2},
  [52] = {.lex_state = 30, .external_lex_state = 2},
  [53] = {.lex_state = 30, .external_lex_state = 2},
  [54] = {.lex_state = 30, .external_lex_state = 2},
  [55] = {.lex_state = 30, .external_lex_state = 2},
  [56] = {.lex_state = 30, .external_lex_state = 2},
  [57] = {.lex_state = 30, .external_lex_state = 2},
  [58] = {.lex_state = 30, .external_lex_state = 2},
  [59] = {.lex_state = 30, .external_lex_state = 2},
  [60] = {.lex_state = 30, .external_lex_state = 2},
  [61] = {.lex_state = 30, .external_lex_state = 2},
  [62] = {.lex_state = 30, .external_lex_state = 2},
  [63] = {.lex_state = 30, .external_lex_state = 2},
  [64] = {.lex_state = 30, .external_lex_state = 2},
  [65] = {.lex_state = 30, .external_lex_state = 2},
  [66] = {.lex_state = 30, .external_lex_state = 2},
  [67] = {.lex_state = 30, .external_lex_state = 2},
  [68] = {.lex_state = 30, .external_lex_state = 2},
  [69] = {.lex_state = 30, .external_lex_state = 2},
  [70] = {.lex_state = 30, .external_lex_state = 2},
  [71] = {.lex_state = 30, .external_lex_state = 2},
  [72] = {.lex_state = 30, .external_lex_state = 2},
  [73] = {.lex_state = 30, .external_lex_state = 2},
  [74] = {.lex_state = 30, .external_lex_state = 2},
  [75] = {.lex_state = 30, .external_lex_state = 2},
  [76] = {.lex_state = 30, .external_lex_state = 2},
  [77] = {.lex_state = 30, .external_lex_state = 2},
  [78] = {.lex_state = 30, .external_lex_state = 2},
  [79] = {.lex_state = 30, .external_lex_state = 2},
  [80] = {.lex_state = 30, .external_lex_state = 2},
  [81] = {.lex_state = 30, .external_lex_state = 2},
  [82] = {.lex_state = 30, .external_lex_state = 2},
  [83] = {.lex_state = 30, .external_lex_state = 2},
  [84] = {.lex_state = 30, .external_lex_state = 2},
  [85] = {.lex_state = 30, .external_lex_state = 2},
  [86] = {.lex_state = 30, .external_lex_state = 2},
  [87] = {.lex_state = 30, .external_lex_state = 2},
  [88] = {.lex_state = 30, .external_lex_state = 2},
  [89] = {.lex_state = 30, .external_lex_state = 2},
  [90] = {.lex_state = 30, .external_lex_state = 2},
  [91] = {.lex_state = 30, .external_lex_state = 2},
  [92] = {.lex_state = 30, .external_lex_state = 2},
  [93] = {.lex_state = 30, .external_lex_state = 2},
  [94] = {.lex_state = 30, .external_lex_state = 2},
  [95] = {.lex_state = 30, .external_lex_state = 2},
  [96] = {.lex_state = 30, .external_lex_state = 2},
  [97] = {.lex_state = 30, .external_lex_state = 2},
  [98] = {.lex_state = 30, .external_lex_state = 2},
  [99] = {.lex_state = 30, .external_lex_state = 2},
  [100] = {.lex_state = 30, .external_lex_state = 2},
  [101] = {.lex_state = 30, .external_lex_state = 2},
  [102] = {.lex_state = 30, .external_lex_state = 2},
  [103] = {.lex_state = 30, .external_lex_state = 2},
  [104] = {.lex_state = 30, .external_lex_state = 2},
  [105] = {.lex_state = 30, .external_lex_state = 2},
  [106] = {.lex_state = 30, .external_lex_state = 2},
  [107] = {.lex_state = 30, .external_lex_state = 2},
  [108] = {.lex_state = 30, .external_lex_state = 2},
  [109] = {.lex_state = 30, .external_lex_state = 2},
  [110] = {.lex_state = 30, .external_lex_state = 2},
  [111] = {.lex_state = 30, .external_lex_state = 2},
  [112] = {.lex_state = 30, .external_lex_state = 2},
  [113] = {.lex_state = 1, .external_lex_state = 4},
  [114] = {.lex_state = 1, .external_lex_state = 5},
  [115] = {.lex_state = 1, .external_lex_state = 5},
  [116] = {.lex_state = 1, .external_lex_state = 4},
  [117] = {.lex_state = 1, .external_lex_state = 4},
  [118] = {.lex_state = 1, .external_lex_state = 4},
  [119] = {.lex_state = 1, .external_lex_state = 4},
  [120] = {.lex_state = 1, .external_lex_state = 4},
  [121] = {.lex_state = 1, .external_lex_state = 4},
  [122] = {.lex_state = 1, .external_lex_state = 4},
  [123] = {.lex_state = 1, .external_lex_state = 4},
  [124] = {.lex_state = 1, .external_lex_state = 4},
  [125] = {.lex_state = 1, .external_lex_state = 4},
  [126] = {.lex_state = 1, .external_lex_state = 5},
  [127] = {.lex_state = 30, .external_lex_state = 2},
  [128] = {.lex_state = 30, .external_lex_state = 2},
  [129] = {.lex_state = 30, .external_lex_state = 2},
  [130] = {.lex_state = 30, .external_lex_state = 2},
  [131] = {.lex_state = 30, .external_lex_state = 2},
  [132] = {.lex_state = 30, .external_lex_state = 2},
  [133] = {.lex_state = 30, .external_lex_state = 2},
  [134] = {.lex_state = 30, .external_lex_state = 2},
  [135] = {.lex_state = 30, .external_lex_state = 2},
  [136] = {.lex_state = 30, .external_lex_state = 2},
  [137] = {.lex_state = 30, .external_lex_state = 2},
  [138] = {.lex_state = 30, .external_lex_state = 2},
  [139] = {.lex_state = 30, .external_lex_state = 2},
  [140] = {.lex_state = 30, .external_lex_state = 2},
  [141] = {.lex_state = 30, .external_lex_state = 2},
  [142] = {.lex_state = 30, .external_lex_state = 2},
  [143] = {.lex_state = 30, .external_lex_state = 2},
  [144] = {.lex_state = 30, .external_lex_state = 2},
  [145] = {.lex_state = 30, .external_lex_state = 2},
  [146] = {.lex_state = 30, .external_lex_state = 2},
  [147] = {.lex_state = 30, .external_lex_state = 2},
  [148] = {.lex_state = 30, .external_lex_state = 2},
  [149] = {.lex_state = 30, .external_lex_state = 2},
  [150] = {.lex_state = 30, .external_lex_state = 2},
  [151] = {.lex_state = 30, .external_lex_state = 2},
  [152] = {.lex_state = 30, .external_lex_state = 2},
  [153] = {.lex_state = 30, .external_lex_state = 2},
  [154] = {.lex_state = 30, .external_lex_state = 2},
  [155] = {.lex_state = 30, .external_lex_state = 2},
  [156] = {.lex_state = 30, .external_lex_state = 2},
  [157] = {.lex_state = 1, .external_lex_state = 4},
  [158] = {.lex_state = 30, .external_lex_state = 2},
  [159] = {.lex_state = 30, .external_lex_state = 2},
  [160] = {.lex_state = 30, .external_lex_state = 2},
  [161] = {.lex_state = 30, .external_lex_state = 2},
  [162] = {.lex_state = 30, .external_lex_state = 2},
  [163] = {.lex_state = 1, .external_lex_state = 4},
  [164] = {.lex_state = 1, .external_lex_state = 4},
  [165] = {.lex_state = 1, .external_lex_state = 4},
  [166] = {.lex_state = 1, .external_lex_state = 4},
  [167] = {.lex_state = 1, .external_lex_state = 4},
  [168] = {.lex_state = 1, .external_lex_state = 4},
  [169] = {.lex_state = 1, .external_lex_state = 4},
  [170] = {.lex_state = 1, .external_lex_state = 4},
  [171] = {.lex_state = 1, .external_lex_state = 4},
  [172] = {.lex_state = 1, .external_lex_state = 4},
  [173] = {.lex_state = 1, .external_lex_state = 4},
  [174] = {.lex_state = 1, .external_lex_state = 4},
  [175] = {.lex_state = 1, .external_lex_state = 4},
  [176] = {.lex_state = 1, .external_lex_state = 4},
  [177] = {.lex_state = 1, .external_lex_state = 4},
  [178] = {.lex_state = 31, .external_lex_state = 2},
  [179] = {.lex_state = 1, .external_lex_state = 4},
  [180] = {.lex_state = 1, .external_lex_state = 4},
  [181] = {.lex_state = 1, .external_lex_state = 4},
  [182] = {.lex_state = 1, .external_lex_state = 4},
  [183] = {.lex_state = 1, .external_lex_state = 4},
  [184] = {.lex_state = 1, .external_lex_state = 4},
  [185] = {.lex_state = 1, .external_lex_state = 4},
  [186] = {.lex_state = 1, .external_lex_state = 4},
  [187] = {.lex_state = 1, .external_lex_state = 4},
  [188] = {.lex_state = 1, .external_lex_state = 4},
  [189] = {.lex_state = 1, .external_lex_state = 4},
  [190] = {.lex_state = 1, .external_lex_state = 4},
  [191] = {.lex_state = 1, .external_lex_state = 4},
  [192] = {.lex_state = 1, .external_lex_state = 4},
  [193] = {.lex_state = 1, .external_lex_state = 4},
  [194] = {.lex_state = 1, .external_lex_state = 4},
  [195] = {.lex_state = 3, .external_lex_state = 6},
  [196] = {.lex_state = 3, .external_lex_state = 6},
  [197] = {.lex_state = 3, .external_lex_state = 7},
  [198] = {.lex_state = 3, .external_lex_state = 7},
  [199] = {.lex_state = 3, .external_lex_state = 7},
  [200] = {.lex_state = 3, .external_lex_state = 7},
  [201] = {.lex_state = 3, .external_lex_state = 7},
  [202] = {.lex_state = 3, .external_lex_state = 7},
  [203] = {.lex_state = 3, .external_lex_state = 7},
  [204] = {.lex_state = 3, .external_lex_state = 7},
  [205] = {.lex_state = 3, .external_lex_state = 7},
  [206] = {.lex_state = 3, .external_lex_state = 7},
  [207] = {.lex_state = 3, .external_lex_state = 6},
  [208] = {.lex_state = 3, .external_lex_state = 7},
  [209] = {.lex_state = 3, .external_lex_state = 7},
  [210] = {.lex_state = 3, .external_lex_state = 7},
  [211] = {.lex_state = 3, .external_lex_state = 7},
  [212] = {.lex_state = 3, .external_lex_state = 7},
  [213] = {.lex_state = 3, .external_lex_state = 7},
  [214] = {.lex_state = 3, .external_lex_state = 7},
  [215] = {.lex_state = 3, .external_lex_state = 7},
  [216] = {.lex_state = 3, .external_lex_state = 7},
  [217] = {.lex_state = 3, .external_lex_state = 7},
  [218] = {.lex_state = 3, .external_lex_state = 7},
  [219] = {.lex_state = 3, .external_lex_state = 7},
  [220] = {.lex_state = 3, .external_lex_state = 7},
  [221] = {.lex_state = 3, .external_lex_state = 7},
  [222] = {.lex_state = 3, .external_lex_state = 7},
  [223] = {.lex_state = 3, .external_lex_state = 7},
  [224] = {.lex_state = 3, .external_lex_state = 7},
  [225] = {.lex_state = 3, .external_lex_state = 7},
  [226] = {.lex_state = 3, .external_lex_state = 7},
  [227] = {.lex_state = 30, .external_lex_state = 2},
  [228] = {.lex_state = 3, .external_lex_state = 7},
  [229] = {.lex_state = 3, .external_lex_state = 7},
  [230] = {.lex_state = 3, .external_lex_state = 7},
  [231] = {.lex_state = 3, .external_lex_state = 7},
  [232] = {.lex_state = 3, .external_lex_state = 7},
  [233] = {.lex_state = 3, .external_lex_state = 7},
  [234] = {.lex_state = 3, .external_lex_state = 7},
  [235] = {.lex_state = 3, .external_lex_state = 7},
  [236] = {.lex_state = 3, .external_lex_state = 7},
  [237] = {.lex_state = 3, .external_lex_state = 7},
  [238] = {.lex_state = 30, .external_lex_state = 2},
  [239] = {.lex_state = 3, .external_lex_state = 7},
  [240] = {.lex_state = 3, .external_lex_state = 7},
  [241] = {.lex_state = 3, .external_lex_state = 7},
  [242] = {.lex_state = 3, .external_lex_state = 7},
  [243] = {.lex_state = 3, .external_lex_state = 7},
  [244] = {.lex_state = 4, .external_lex_state = 5},
  [245] = {.lex_state = 4, .external_lex_state = 5},
  [246] = {.lex_state = 4, .external_lex_state = 4},
  [247] = {.lex_state = 4, .external_lex_state = 4},
  [248] = {.lex_state = 4, .external_lex_state = 4},
  [249] = {.lex_state = 4, .external_lex_state = 5},
  [250] = {.lex_state = 4, .external_lex_state = 4},
  [251] = {.lex_state = 4, .external_lex_state = 4},
  [252] = {.lex_state = 4, .external_lex_state = 4},
  [253] = {.lex_state = 4, .external_lex_state = 4},
  [254] = {.lex_state = 4, .external_lex_state = 4},
  [255] = {.lex_state = 4, .external_lex_state = 4},
  [256] = {.lex_state = 4, .external_lex_state = 4},
  [257] = {.lex_state = 4, .external_lex_state = 4},
  [258] = {.lex_state = 30, .external_lex_state = 2},
  [259] = {.lex_state = 4, .external_lex_state = 4},
  [260] = {.lex_state = 30, .external_lex_state = 2},
  [261] = {.lex_state = 4, .external_lex_state = 4},
  [262] = {.lex_state = 4, .external_lex_state = 4},
  [263] = {.lex_state = 4, .external_lex_state = 4},
  [264] = {.lex_state = 4, .external_lex_state = 4},
  [265] = {.lex_state = 4, .external_lex_state = 4},
  [266] = {.lex_state = 4, .external_lex_state = 4},
  [267] = {.lex_state = 4, .external_lex_state = 4},
  [268] = {.lex_state = 4, .external_lex_state = 4},
  [269] = {.lex_state = 4, .external_lex_state = 4},
  [270] = {.lex_state = 4, .external_lex_state = 4},
  [271] = {.lex_state = 4, .external_lex_state = 4},
  [272] = {.lex_state = 4, .external_lex_state = 4},
  [273] = {.lex_state = 4, .external_lex_state = 4},
  [274] = {.lex_state = 4, .external_lex_state = 4},
  [275] = {.lex_state = 4, .external_lex_state = 4},
  [276] = {.lex_state = 4, .external_lex_state = 4},
  [277] = {.lex_state = 4, .external_lex_state = 4},
  [278] = {.lex_state = 4, .external_lex_state = 4},
  [279] = {.lex_state = 4, .external_lex_state = 4},
  [280] = {.lex_state = 4, .external_lex_state = 4},
  [281] = {.lex_state = 4, .external_lex_state = 4},
  [282] = {.lex_state = 4, .external_lex_state = 4},
  [283] = {.lex_state = 4, .external_lex_state = 4},
  [284] = {.lex_state = 4, .external_lex_state = 4},
  [285] = {.lex_state = 4, .external_lex_state = 4},
  [286] = {.lex_state = 4, .external_lex_state = 4},
  [287] = {.lex_state = 4, .external_lex_state = 4},
  [288] = {.lex_state = 4, .external_lex_state = 4},
  [289] = {.lex_state = 4, .external_lex_state = 4},
  [290] = {.lex_state = 4, .external_lex_state = 4},
  [291] = {.lex_state = 4, .external_lex_state = 4},
  [292] = {.lex_state = 4, .external_lex_state = 4},
  [293] = {.lex_state = 4, .external_lex_state = 4},
  [294] = {.lex_state = 4, .external_lex_state = 4},
  [295] = {.lex_state = 4, .external_lex_state = 4},
  [296] = {.lex_state = 4, .external_lex_state = 4},
  [297] = {.lex_state = 4, .external_lex_state = 8},
  [298] = {.lex_state = 4, .external_lex_state = 8},
  [299] = {.lex_state = 4, .external_lex_state = 9},
  [300] = {.lex_state = 4, .external_lex_state = 9},
  [301] = {.lex_state = 4, .external_lex_state = 9},
  [302] = {.lex_state = 4, .external_lex_state = 9},
  [303] = {.lex_state = 4, .external_lex_state = 9},
  [304] = {.lex_state = 4, .external_lex_state = 9},
  [305] = {.lex_state = 4, .external_lex_state = 9},
  [306] = {.lex_state = 4, .external_lex_state = 4},
  [307] = {.lex_state = 4, .external_lex_state = 8},
  [308] = {.lex_state = 4, .external_lex_state = 9},
  [309] = {.lex_state = 4, .external_lex_state = 9},
  [310] = {.lex_state = 4, .external_lex_state = 9},
  [311] = {.lex_state = 4, .external_lex_state = 9},
  [312] = {.lex_state = 4, .external_lex_state = 4},
  [313] = {.lex_state = 4, .external_lex_state = 4},
  [314] = {.lex_state = 4, .external_lex_state = 4},
  [315] = {.lex_state = 30, .external_lex_state = 2},
  [316] = {.lex_state = 4, .external_lex_state = 4},
  [317] = {.lex_state = 4, .external_lex_state = 4},
  [318] = {.lex_state = 30, .external_lex_state = 2},
  [319] = {.lex_state = 4, .external_lex_state = 4},
  [320] = {.lex_state = 4, .external_lex_state = 4},
  [321] = {.lex_state = 4, .external_lex_state = 4},
  [322] = {.lex_state = 30, .external_lex_state = 2},
  [323] = {.lex_state = 4, .external_lex_state = 9},
  [324] = {.lex_state = 4, .external_lex_state = 4},
  [325] = {.lex_state = 4, .external_lex_state = 4},
  [326] = {.lex_state = 30, .external_lex_state = 2},
  [327] = {.lex_state = 4, .external_lex_state = 4},
  [328] = {.lex_state = 4, .external_lex_state = 4},
  [329] = {.lex_state = 4, .external_lex_state = 4},
  [330] = {.lex_state = 4, .external_lex_state = 4},
  [331] = {.lex_state = 4, .external_lex_state = 4},
  [332] = {.lex_state = 4, .external_lex_state = 4},
  [333] = {.lex_state = 4, .external_lex_state = 4},
  [334] = {.lex_state = 4, .external_lex_state = 4},
  [335] = {.lex_state = 4, .external_lex_state = 4},
  [336] = {.lex_state = 4, .external_lex_state = 4},
  [337] = {.lex_state = 4, .external_lex_state = 9},
  [338] = {.lex_state = 4, .external_lex_state = 9},
  [339] = {.lex_state = 4, .external_lex_state = 9},
  [340] = {.lex_state = 4, .external_lex_state = 9},
  [341] = {.lex_state = 4, .external_lex_state = 9},
  [342] = {.lex_state = 4, .external_lex_state = 9},
  [343] = {.lex_state = 4, .external_lex_state = 9},
  [344] = {.lex_state = 4, .external_lex_state = 9},
  [345] = {.lex_state = 4, .external_lex_state = 9},
  [346] = {.lex_state = 4, .external_lex_state = 9},
  [347] = {.lex_state = 4, .external_lex_state = 9},
  [348] = {.lex_state = 4, .external_lex_state = 9},
  [349] = {.lex_state = 4, .external_lex_state = 9},
  [350] = {.lex_state = 4, .external_lex_state = 9},
  [351] = {.lex_state = 4, .external_lex_state = 9},
  [352] = {.lex_state = 4, .external_lex_state = 9},
  [353] = {.lex_state = 4, .external_lex_state = 9},
  [354] = {.lex_state = 4, .external_lex_state = 9},
  [355] = {.lex_state = 4, .external_lex_state = 9},
  [356] = {.lex_state = 4, .external_lex_state = 9},
  [357] = {.lex_state = 4, .external_lex_state = 9},
  [358] = {.lex_state = 30, .external_lex_state = 2},
  [359] = {.lex_state = 4, .external_lex_state = 9},
  [360] = {.lex_state = 4, .external_lex_state = 9},
  [361] = {.lex_state = 4, .external_lex_state = 9},
  [362] = {.lex_state = 4, .external_lex_state = 9},
  [363] = {.lex_state = 4, .external_lex_state = 9},
  [364] = {.lex_state = 4, .external_lex_state = 9},
  [365] = {.lex_state = 4, .external_lex_state = 9},
  [366] = {.lex_state = 4, .external_lex_state = 9},
  [367] = {.lex_state = 4, .external_lex_state = 9},
  [368] = {.lex_state = 4, .external_lex_state = 9},
  [369] = {.lex_state = 31, .external_lex_state = 2},
  [370] = {.lex_state = 30, .external_lex_state = 2},
  [371] = {.lex_state = 30, .external_lex_state = 2},
  [372] = {.lex_state = 30, .external_lex_state = 2},
  [373] = {.lex_state = 30, .external_lex_state = 2},
  [374] = {.lex_state = 30, .external_lex_state = 2},
  [375] = {.lex_state = 30, .external_lex_state = 2},
  [376] = {.lex_state = 31, .external_lex_state = 2},
  [377] = {.lex_state = 31, .external_lex_state = 2},
  [378] = {.lex_state = 31, .external_lex_state = 2},
  [379] = {.lex_state = 31, .external_lex_state = 2},
  [380] = {.lex_state = 31, .external_lex_state = 2},
  [381] = {.lex_state = 31, .external_lex_state = 2},
  [382] = {.lex_state = 31, .external_lex_state = 2},
  [383] = {.lex_state = 31, .external_lex_state = 2},
  [384] = {.lex_state = 31, .external_lex_state = 2},
  [385] = {.lex_state = 31, .external_lex_state = 2},
  [386] = {.lex_state = 31, .external_lex_state = 2},
  [387] = {.lex_state = 31, .external_lex_state = 2},
  [388] = {.lex_state = 30, .external_lex_state = 2},
  [389] = {.lex_state = 30, .external_lex_state = 2},
  [390] = {.lex_state = 30, .external_lex_state = 2},
  [391] = {.lex_state = 30, .external_lex_state = 2},
  [392] = {.lex_state = 30, .external_lex_state = 2},
  [393] = {.lex_state = 30, .external_lex_state = 2},
  [394] = {.lex_state = 30, .external_lex_state = 2},
  [395] = {.lex_state = 30, .external_lex_state = 2},
  [396] = {.lex_state = 30, .external_lex_state = 2},
  [397] = {.lex_state = 30, .external_lex_state = 2},
  [398] = {.lex_state = 30, .external_lex_state = 2},
  [399] = {.lex_state = 30, .external_lex_state = 2},
  [400] = {.lex_state = 30, .external_lex_state = 2},
  [401] = {.lex_state = 30, .external_lex_state = 2},
  [402] = {.lex_state = 30, .external_lex_state = 2},
  [403] = {.lex_state = 30, .external_lex_state = 2},
  [404] = {.lex_state = 30, .external_lex_state = 2},
  [405] = {.lex_state = 30, .external_lex_state = 2},
  [406] = {.lex_state = 30, .external_lex_state = 2},
  [407] = {.lex_state = 30, .external_lex_state = 2},
  [408] = {.lex_state = 30, .external_lex_state = 2},
  [409] = {.lex_state = 30, .external_lex_state = 2},
  [410] = {.lex_state = 30, .external_lex_state = 2},
  [411] = {.lex_state = 30, .external_lex_state = 2},
  [412] = {.lex_state = 30, .external_lex_state = 2},
  [413] = {.lex_state = 30, .external_lex_state = 2},
  [414] = {.lex_state = 30, .external_lex_state = 2},
  [415] = {.lex_state = 30, .external_lex_state = 2},
  [416] = {.lex_state = 30, .external_lex_state = 2},
  [417] = {.lex_state = 30, .external_lex_state = 2},
  [418] = {.lex_state = 30, .external_lex_state = 2},
  [419] = {.lex_state = 30, .external_lex_state = 10},
  [420] = {.lex_state = 30, .external_lex_state = 10},
  [421] = {.lex_state = 30, .external_lex_state = 2},
  [422] = {.lex_state = 30, .external_lex_state = 2},
  [423] = {.lex_state = 30, .external_lex_state = 2},
  [424] = {.lex_state = 30, .external_lex_state = 2},
  [425] = {.lex_state = 30, .external_lex_state = 10},
  [426] = {.lex_state = 30, .external_lex_state = 2},
  [427] = {.lex_state = 30, .external_lex_state = 2},
  [428] = {.lex_state = 30, .external_lex_state = 2},
  [429] = {.lex_state = 30, .external_lex_state = 2},
  [430] = {.lex_state = 30, .external_lex_state = 2},
  [431] = {.lex_state = 30, .external_lex_state = 2},
  [432] = {.lex_state = 30, .external_lex_state = 2},
  [433] = {.lex_state = 30, .external_lex_state = 2},
  [434] = {.lex_state = 30, .external_lex_state = 2},
  [435] = {.lex_state = 30, .external_lex_state = 2},
  [436] = {.lex_state = 30, .external_lex_state = 2},
  [437] = {.lex_state = 30, .external_lex_state = 2},
  [438] = {.lex_state = 30, .external_lex_state = 2},
  [439] = {.lex_state = 30, .external_lex_state = 2},
  [440] = {.lex_state = 30, .external_lex_state = 2},
  [441] = {.lex_state = 30, .external_lex_state = 2},
  [442] = {.lex_state = 30, .external_lex_state = 2},
  [443] = {.lex_state = 30, .external_lex_state = 2},
  [444] = {.lex_state = 30, .external_lex_state = 2},
  [445] = {.lex_state = 30, .external_lex_state = 2},
  [446] = {.lex_state = 30, .external_lex_state = 2},
  [447] = {.lex_state = 30, .external_lex_state = 2},
  [448] = {.lex_state = 30, .external_lex_state = 2},
  [449] = {.lex_state = 30, .external_lex_state = 2},
  [450] = {.lex_state = 30, .external_lex_state = 2},
  [451] = {.lex_state = 30, .external_lex_state = 2},
  [452] = {.lex_state = 30, .external_lex_state = 2},
  [453] = {.lex_state = 30, .external_lex_state = 10},
  [454] = {.lex_state = 30, .external_lex_state = 2},
  [455] = {.lex_state = 30, .external_lex_state = 2},
  [456] = {.lex_state = 30, .external_lex_state = 2},
  [457] = {.lex_state = 30, .external_lex_state = 2},
  [458] = {.lex_state = 30, .external_lex_state = 2},
  [459] = {.lex_state = 30, .external_lex_state = 2},
  [460] = {.lex_state = 30, .external_lex_state = 2},
  [461] = {.lex_state = 30, .external_lex_state = 2},
  [462] = {.lex_state = 30, .external_lex_state = 2},
  [463] = {.lex_state = 30, .external_lex_state = 2},
  [464] = {.lex_state = 30, .external_lex_state = 2},
  [465] = {.lex_state = 30, .external_lex_state = 2},
  [466] = {.lex_state = 30, .external_lex_state = 2},
  [467] = {.lex_state = 30, .external_lex_state = 2},
  [468] = {.lex_state = 30, .external_lex_state = 2},
  [469] = {.lex_state = 30, .external_lex_state = 2},
  [470] = {.lex_state = 30, .external_lex_state = 2},
  [471] = {.lex_state = 30, .external_lex_state = 2},
  [472] = {.lex_state = 30, .external_lex_state = 2},
  [473] = {.lex_state = 30, .external_lex_state = 2},
  [474] = {.lex_state = 30, .external_lex_state = 2},
  [475] = {.lex_state = 30, .external_lex_state = 2},
  [476] = {.lex_state = 30, .external_lex_state = 2},
  [477] = {.lex_state = 30, .external_lex_state = 2},
  [478] = {.lex_state = 30, .external_lex_state = 2},
  [479] = {.lex_state = 30, .external_lex_state = 2},
  [480] = {.lex_state = 30, .external_lex_state = 2},
  [481] = {.lex_state = 30, .external_lex_state = 2},
  [482] = {.lex_state = 30, .external_lex_state = 2},
  [483] = {.lex_state = 30, .external_lex_state = 2},
  [484] = {.lex_state = 30, .external_lex_state = 2},
  [485] = {.lex_state = 30, .external_lex_state = 2},
  [486] = {.lex_state = 30, .external_lex_state = 2},
  [487] = {.lex_state = 30, .external_lex_state = 2},
  [488] = {.lex_state = 30, .external_lex_state = 2},
  [489] = {.lex_state = 30, .external_lex_state = 2},
  [490] = {.lex_state = 30, .external_lex_state = 2},
  [491] = {.lex_state = 30, .external_lex_state = 2},
  [492] = {.lex_state = 30, .external_lex_state = 2},
  [493] = {.lex_state = 30, .external_lex_state = 2},
  [494] = {.lex_state = 30, .external_lex_state = 2},
  [495] = {.lex_state = 30, .external_lex_state = 2},
  [496] = {.lex_state = 30, .external_lex_state = 2},
  [497] = {.lex_state = 30, .external_lex_state = 2},
  [498] = {.lex_state = 30, .external_lex_state = 2},
  [499] = {.lex_state = 30, .external_lex_state = 2},
  [500] = {.lex_state = 30, .external_lex_state = 2},
  [501] = {.lex_state = 30, .external_lex_state = 2},
  [502] = {.lex_state = 5, .external_lex_state = 2},
  [503] = {.lex_state = 30, .external_lex_state = 2},
  [504] = {.lex_state = 30, .external_lex_state = 2},
  [505] = {.lex_state = 30, .external_lex_state = 2},
  [506] = {.lex_state = 30, .external_lex_state = 2},
  [507] = {.lex_state = 30, .external_lex_state = 2},
  [508] = {.lex_state = 5, .external_lex_state = 2},
  [509] = {.lex_state = 30, .external_lex_state = 3},
  [510] = {.lex_state = 30, .external_lex_state = 2},
  [511] = {.lex_state = 30, .external_lex_state = 2},
  [512] = {.lex_state = 30, .external_lex_state = 2},
  [513] = {.lex_state = 30, .external_lex_state = 2},
  [514] = {.lex_state = 30, .external_lex_state = 2},
  [515] = {.lex_state = 30, .external_lex_state = 2},
  [516] = {.lex_state = 30, .external_lex_state = 2},
  [517] = {.lex_state = 30, .external_lex_state = 2},
  [518] = {.lex_state = 30, .external_lex_state = 2},
  [519] = {.lex_state = 30, .external_lex_state = 2},
  [520] = {.lex_state = 30, .external_lex_state = 2},
  [521] = {.lex_state = 30, .external_lex_state = 3},
  [522] = {.lex_state = 30, .external_lex_state = 2},
  [523] = {.lex_state = 30, .external_lex_state = 2},
  [524] = {.lex_state = 30, .external_lex_state = 2},
  [525] = {.lex_state = 30, .external_lex_state = 2},
  [526] = {.lex_state = 30, .external_lex_state = 2},
  [527] = {.lex_state = 30, .external_lex_state = 2},
  [528] = {.lex_state = 30, .external_lex_state = 2},
  [529] = {.lex_state = 30, .external_lex_state = 2},
  [530] = {.lex_state = 30, .external_lex_state = 2},
  [531] = {.lex_state = 30, .external_lex_state = 2},
  [532] = {.lex_state = 30, .external_lex_state = 2},
  [533] = {.lex_state = 30, .external_lex_state = 2},
  [534] = {.lex_state = 30, .external_lex_state = 2},
  [535] = {.lex_state = 30, .external_lex_state = 2},
  [536] = {.lex_state = 5, .external_lex_state = 2},
  [537] = {.lex_state = 30, .external_lex_state = 2},
  [538] = {.lex_state = 30, .external_lex_state = 2},
  [539] = {.lex_state = 30, .external_lex_state = 2},
  [540] = {.lex_state = 5, .external_lex_state = 2},
  [541] = {.lex_state = 30, .external_lex_state = 2},
  [542] = {.lex_state = 30, .external_lex_state = 2},
  [543] = {.lex_state = 30, .external_lex_state = 2},
  [544] = {.lex_state = 30, .external_lex_state = 2},
  [545] = {.lex_state = 30, .external_lex_state = 3},
  [546] = {.lex_state = 30, .external_lex_state = 2},
  [547] = {.lex_state = 30, .external_lex_state = 2},
  [548] = {.lex_state = 30, .external_lex_state = 2},
  [549] = {.lex_state = 30, .external_lex_state = 2},
  [550] = {.lex_state = 30, .external_lex_state = 2},
  [551] = {.lex_state = 30, .external_lex_state = 2},
  [552] = {.lex_state = 30, .external_lex_state = 2},
  [553] = {.lex_state = 30, .external_lex_state = 2},
  [554] = {.lex_state = 30, .external_lex_state = 2},
  [555] = {.lex_state = 30, .external_lex_state = 2},
  [556] = {.lex_state = 30, .external_lex_state = 2},
  [557] = {.lex_state = 30, .external_lex_state = 2},
  [558] = {.lex_state = 30, .external_lex_state = 2},
  [559] = {.lex_state = 30, .external_lex_state = 2},
  [560] = {.lex_state = 30, .external_lex_state = 2},
  [561] = {.lex_state = 30, .external_lex_state = 2},
  [562] = {.lex_state = 30, .external_lex_state = 2},
  [563] = {.lex_state = 30, .external_lex_state = 2},
  [564] = {.lex_state = 30, .external_lex_state = 2},
  [565] = {.lex_state = 30, .external_lex_state = 2},
  [566] = {.lex_state = 30, .external_lex_state = 2},
  [567] = {.lex_state = 30, .external_lex_state = 2},
  [568] = {.lex_state = 30, .external_lex_state = 2},
  [569] = {.lex_state = 30, .external_lex_state = 2},
  [570] = {.lex_state = 30, .external_lex_state = 3},
  [571] = {.lex_state = 30, .external_lex_state = 2},
  [572] = {.lex_state = 30, .external_lex_state = 2},
  [573] = {.lex_state = 30, .external_lex_state = 2},
  [574] = {.lex_state = 30, .external_lex_state = 2},
  [575] = {.lex_state = 30, .external_lex_state = 2},
  [576] = {.lex_state = 30, .external_lex_state = 2},
  [577] = {.lex_state = 30, .external_lex_state = 2},
  [578] = {.lex_state = 30, .external_lex_state = 2},
  [579] = {.lex_state = 30, .external_lex_state = 2},
  [580] = {.lex_state = 30, .external_lex_state = 2},
  [581] = {.lex_state = 30, .external_lex_state = 2},
  [582] = {.lex_state = 30, .external_lex_state = 2},
  [583] = {.lex_state = 30, .external_lex_state = 11},
  [584] = {.lex_state = 30, .external_lex_state = 2},
  [585] = {.lex_state = 30, .external_lex_state = 2},
  [586] = {.lex_state = 30, .external_lex_state = 2},
  [587] = {.lex_state = 30, .external_lex_state = 11},
  [588] = {.lex_state = 30, .external_lex_state = 2},
  [589] = {.lex_state = 30, .external_lex_state = 2},
  [590] = {.lex_state = 30, .external_lex_state = 2},
  [591] = {.lex_state = 30, .external_lex_state = 2},
  [592] = {.lex_state = 30, .external_lex_state = 2},
  [593] = {.lex_state = 30, .external_lex_state = 2},
  [594] = {.lex_state = 30, .external_lex_state = 2},
  [595] = {.lex_state = 30, .external_lex_state = 11},
  [596] = {.lex_state = 30, .external_lex_state = 2},
  [597] = {.lex_state = 30, .external_lex_state = 11},
  [598] = {.lex_state = 30, .external_lex_state = 2},
  [599] = {.lex_state = 30, .external_lex_state = 2},
  [600] = {.lex_state = 30, .external_lex_state = 2},
  [601] = {.lex_state = 30, .external_lex_state = 2},
  [602] = {.lex_state = 30, .external_lex_state = 2},
  [603] = {.lex_state = 30, .external_lex_state = 2},
  [604] = {.lex_state = 30, .external_lex_state = 3},
  [605] = {.lex_state = 30, .external_lex_state = 2},
  [606] = {.lex_state = 30, .external_lex_state = 2},
  [607] = {.lex_state = 30, .external_lex_state = 2},
  [608] = {.lex_state = 30, .external_lex_state = 2},
  [609] = {.lex_state = 30, .external_lex_state = 2},
  [610] = {.lex_state = 30, .external_lex_state = 11},
  [611] = {.lex_state = 30, .external_lex_state = 2},
  [612] = {.lex_state = 30, .external_lex_state = 2},
  [613] = {.lex_state = 30, .external_lex_state = 2},
  [614] = {.lex_state = 30, .external_lex_state = 3},
  [615] = {.lex_state = 30, .external_lex_state = 2},
  [616] = {.lex_state = 30, .external_lex_state = 2},
  [617] = {.lex_state = 30, .external_lex_state = 2},
  [618] = {.lex_state = 30, .external_lex_state = 11},
  [619] = {.lex_state = 30, .external_lex_state = 2},
  [620] = {.lex_state = 30, .external_lex_state = 2},
  [621] = {.lex_state = 30, .external_lex_state = 2},
  [622] = {.lex_state = 30, .external_lex_state = 3},
  [623] = {.lex_state = 30, .external_lex_state = 2},
  [624] = {.lex_state = 30, .external_lex_state = 2},
  [625] = {.lex_state = 30, .external_lex_state = 2},
  [626] = {.lex_state = 30, .external_lex_state = 11},
  [627] = {.lex_state = 30, .external_lex_state = 2},
  [628] = {.lex_state = 30, .external_lex_state = 3},
  [629] = {.lex_state = 30, .external_lex_state = 2},
  [630] = {.lex_state = 30, .external_lex_state = 2},
  [631] = {.lex_state = 30, .external_lex_state = 2},
  [632] = {.lex_state = 30, .external_lex_state = 2},
  [633] = {.lex_state = 30, .external_lex_state = 2},
  [634] = {.lex_state = 30, .external_lex_state = 3},
  [635] = {.lex_state = 30, .external_lex_state = 2},
  [636] = {.lex_state = 30, .external_lex_state = 2},
  [637] = {.lex_state = 30, .external_lex_state = 2},
  [638] = {.lex_state = 30, .external_lex_state = 2},
  [639] = {.lex_state = 30, .external_lex_state = 2},
  [640] = {.lex_state = 30, .external_lex_state = 2},
  [641] = {.lex_state = 30, .external_lex_state = 2},
  [642] = {.lex_state = 30, .external_lex_state = 11},
  [643] = {.lex_state = 30, .external_lex_state = 2},
  [644] = {.lex_state = 30, .external_lex_state = 2},
  [645] = {(TSStateId)(-1)},
  [646] = {(TSStateId)(-1)},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_preproc_custom] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(1),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(1),
    [sym_hex_int_literal] = ACTIONS(1),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(1),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(1),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(1),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(1),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(1),
    [aux_sym__hex_float_literal_token1] = ACTIONS(1),
    [aux_sym__hex_float_literal_token2] = ACTIONS(1),
    [aux_sym__hex_float_literal_token3] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_diagnostic] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_enable] = ACTIONS(1),
    [anon_sym_requires] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_alias] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [aux_sym_swizzle_name_token1] = ACTIONS(1),
    [aux_sym_swizzle_name_token2] = ACTIONS(1),
    [aux_sym_swizzle_name_token3] = ACTIONS(1),
    [aux_sym_swizzle_name_token4] = ACTIONS(1),
    [aux_sym_swizzle_name_token5] = ACTIONS(1),
    [aux_sym_swizzle_name_token6] = ACTIONS(1),
    [aux_sym_swizzle_name_token7] = ACTIONS(1),
    [aux_sym_swizzle_name_token8] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_const_assert] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_continuing] = ACTIONS(1),
    [anon_sym_discard] = ACTIONS(1),
    [anon_sym_virtual] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [aux_sym_preproc_custom_token1] = ACTIONS(1),
    [sym_preproc_directive] = ACTIONS(3),
    [anon_sym_POUNDimport] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(7),
    [sym_block_comment] = ACTIONS(5),
    [sym__disambiguate_template] = ACTIONS(1),
    [sym_template_args_start] = ACTIONS(1),
    [sym_template_args_end] = ACTIONS(1),
    [sym_less_than] = ACTIONS(1),
    [sym_less_than_equal] = ACTIONS(1),
    [sym_shift_left] = ACTIONS(1),
    [sym_shift_left_assign] = ACTIONS(1),
    [sym_greater_than] = ACTIONS(1),
    [sym_greater_than_equal] = ACTIONS(1),
    [sym_shift_right] = ACTIONS(1),
    [sym_shift_right_assign] = ACTIONS(1),
    [sym__error_sentinel] = ACTIONS(1),
  },
  [1] = {
    [sym_translation_unit] = STATE(644),
    [sym_import] = STATE(383),
    [sym__decorated_global_directive] = STATE(390),
    [sym_global_directive] = STATE(396),
    [sym_diagnostic_directive] = STATE(389),
    [sym_enable_directive] = STATE(389),
    [sym_requires_directive] = STATE(389),
    [sym_attribute] = STATE(106),
    [sym__decorated_global_decl] = STATE(415),
    [sym_global_decl] = STATE(417),
    [sym_struct_decl] = STATE(414),
    [sym_type_alias_decl] = STATE(414),
    [sym_global_variable_decl] = STATE(414),
    [sym_global_value_decl] = STATE(414),
    [sym_variable_decl] = STATE(580),
    [sym_const_assert_statement] = STATE(414),
    [sym_function_decl] = STATE(414),
    [sym_function_header] = STATE(472),
    [sym_preproc_custom] = STATE(1),
    [sym_preproc_bevy_import] = STATE(383),
    [aux_sym_translation_unit_repeat1] = STATE(178),
    [aux_sym_translation_unit_repeat2] = STATE(238),
    [aux_sym_translation_unit_repeat3] = STATE(318),
    [aux_sym_import_repeat1] = STATE(258),
    [ts_builtin_sym_end] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_SEMI] = ACTIONS(13),
    [anon_sym_diagnostic] = ACTIONS(15),
    [anon_sym_enable] = ACTIONS(17),
    [anon_sym_requires] = ACTIONS(19),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_struct] = ACTIONS(23),
    [anon_sym_alias] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_override] = ACTIONS(29),
    [anon_sym_var] = ACTIONS(31),
    [anon_sym_const_assert] = ACTIONS(33),
    [anon_sym_virtual] = ACTIONS(35),
    [anon_sym_fn] = ACTIONS(37),
    [sym_preproc_directive] = ACTIONS(3),
    [anon_sym_POUNDimport] = ACTIONS(39),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [2] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(2),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [3] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(3),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(5),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(97),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [4] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(4),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(7),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [5] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(5),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(99),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [6] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(6),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(101),
    [anon_sym_SEMI] = ACTIONS(104),
    [anon_sym_LBRACE] = ACTIONS(107),
    [anon_sym_RBRACE] = ACTIONS(110),
    [anon_sym_true] = ACTIONS(112),
    [anon_sym_false] = ACTIONS(112),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(115),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(115),
    [sym_hex_int_literal] = ACTIONS(118),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(121),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(121),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(121),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(124),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(121),
    [aux_sym__hex_float_literal_token1] = ACTIONS(127),
    [aux_sym__hex_float_literal_token2] = ACTIONS(130),
    [aux_sym__hex_float_literal_token3] = ACTIONS(127),
    [anon_sym_LPAREN] = ACTIONS(133),
    [anon_sym_AT] = ACTIONS(136),
    [anon_sym_const] = ACTIONS(139),
    [anon_sym_var] = ACTIONS(142),
    [anon_sym_AMP] = ACTIONS(145),
    [anon_sym_DASH] = ACTIONS(145),
    [anon_sym_STAR] = ACTIONS(145),
    [anon_sym_BANG] = ACTIONS(145),
    [anon_sym_TILDE] = ACTIONS(145),
    [anon_sym__] = ACTIONS(148),
    [anon_sym_return] = ACTIONS(151),
    [anon_sym_const_assert] = ACTIONS(154),
    [anon_sym_let] = ACTIONS(139),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_switch] = ACTIONS(160),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_loop] = ACTIONS(166),
    [anon_sym_while] = ACTIONS(169),
    [anon_sym_break] = ACTIONS(172),
    [anon_sym_continue] = ACTIONS(175),
    [anon_sym_continuing] = ACTIONS(178),
    [anon_sym_discard] = ACTIONS(181),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [7] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(7),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(184),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [8] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(8),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(9),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(186),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [9] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(9),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(6),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [10] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__decorated_statement] = STATE(160),
    [sym__statement] = STATE(161),
    [sym_compound_statement] = STATE(161),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(10),
    [aux_sym_import_repeat1] = STATE(11),
    [aux_sym_compound_statement_repeat1] = STATE(2),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(188),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [11] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_attribute] = STATE(106),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym__statement] = STATE(146),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_return_statement] = STATE(159),
    [sym_func_call_statement] = STATE(159),
    [sym_const_assert_statement] = STATE(159),
    [sym__variable_updating_statement] = STATE(159),
    [sym_variable_or_value_statement] = STATE(159),
    [sym_if_statement] = STATE(159),
    [sym_if_clause] = STATE(110),
    [sym_switch_statement] = STATE(159),
    [sym_for_statement] = STATE(159),
    [sym_loop_statement] = STATE(159),
    [sym_while_statement] = STATE(159),
    [sym_break_statement] = STATE(159),
    [sym_break_if_statement] = STATE(159),
    [sym_continue_statement] = STATE(159),
    [sym_continuing_statement] = STATE(159),
    [sym_discard_statement] = STATE(159),
    [sym_preproc_custom] = STATE(11),
    [aux_sym_import_repeat1] = STATE(104),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(190),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_AT] = ACTIONS(21),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_return] = ACTIONS(73),
    [anon_sym_const_assert] = ACTIONS(75),
    [anon_sym_let] = ACTIONS(65),
    [anon_sym_if] = ACTIONS(77),
    [anon_sym_switch] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_loop] = ACTIONS(83),
    [anon_sym_while] = ACTIONS(85),
    [anon_sym_break] = ACTIONS(87),
    [anon_sym_continue] = ACTIONS(89),
    [anon_sym_continuing] = ACTIONS(91),
    [anon_sym_discard] = ACTIONS(93),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
  [12] = {
    [sym__literal] = STATE(224),
    [sym_bool_literal] = STATE(225),
    [sym_int_literal] = STATE(225),
    [sym_decimal_int_literal] = STATE(221),
    [sym_float_literal] = STATE(225),
    [sym__decimal_float_literal] = STATE(226),
    [sym__hex_float_literal] = STATE(226),
    [sym__ident] = STATE(195),
    [sym__template_elaborated_ident] = STATE(209),
    [sym_ident_path] = STATE(535),
    [sym__ident_pattern_token] = STATE(618),
    [sym_variable_decl] = STATE(576),
    [sym__call_phrase] = STATE(211),
    [sym__short_circuit_or_expression] = STATE(228),
    [sym__short_circuit_and_expression] = STATE(229),
    [sym__binary_or_expression] = STATE(230),
    [sym__binary_xor_expression] = STATE(231),
    [sym__binary_and_expression] = STATE(232),
    [sym__relational_expression] = STATE(233),
    [sym__shift_expression] = STATE(234),
    [sym__additive_expression] = STATE(235),
    [sym__multiplicative_expression] = STATE(236),
    [sym_unary_expression] = STATE(237),
    [sym__unary_operator] = STATE(74),
    [sym__primary_expression] = STATE(237),
    [sym_call_expression] = STATE(224),
    [sym_indexing_expression] = STATE(224),
    [sym_named_component_expression] = STATE(224),
    [sym_paren_expression] = STATE(237),
    [sym_binary_expression] = STATE(237),
    [sym__expression] = STATE(197),
    [sym_assignment_statement] = STATE(131),
    [sym_increment_statement] = STATE(131),
    [sym_decrement_statement] = STATE(131),
    [sym_func_call_statement] = STATE(643),
    [sym__variable_updating_statement] = STATE(643),
    [sym_variable_or_value_statement] = STATE(643),
    [sym_for_header] = STATE(630),
    [sym__for_init] = STATE(609),
    [sym_preproc_custom] = STATE(12),
    [sym_identifier] = ACTIONS(41),
    [anon_sym_SEMI] = ACTIONS(192),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(49),
    [aux_sym_decimal_int_literal_token1] = ACTIONS(51),
    [aux_sym_decimal_int_literal_token2] = ACTIONS(51),
    [sym_hex_int_literal] = ACTIONS(53),
    [aux_sym__decimal_float_literal_token1] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token2] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token3] = ACTIONS(55),
    [aux_sym__decimal_float_literal_token4] = ACTIONS(57),
    [aux_sym__decimal_float_literal_token5] = ACTIONS(55),
    [aux_sym__hex_float_literal_token1] = ACTIONS(59),
    [aux_sym__hex_float_literal_token2] = ACTIONS(61),
    [aux_sym__hex_float_literal_token3] = ACTIONS(59),
    [anon_sym_LPAREN] = ACTIONS(63),
    [anon_sym_const] = ACTIONS(65),
    [anon_sym_var] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(69),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_BANG] = ACTIONS(69),
    [anon_sym_TILDE] = ACTIONS(69),
    [anon_sym__] = ACTIONS(71),
    [anon_sym_let] = ACTIONS(65),
    [sym_preproc_directive] = ACTIONS(95),
    [sym_line_comment] = ACTIONS(5),
    [sym__blankspace] = ACTIONS(5),
    [sym_block_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 39,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(194), 1,
      anon_sym_RPAREN,
    STATE(13), 1,
      sym_preproc_custom,
    STATE(74), 1,
      sym__unary_operator,
    STATE(195), 1,
      sym__ident,
    STATE(197), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(211), 1,
      sym__call_phrase,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    STATE(635), 1,
      sym__for_update,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(633), 2,
      sym_func_call_statement,
      sym__variable_updating_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(131), 3,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [142] = 39,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(196), 1,
      anon_sym_RPAREN,
    STATE(14), 1,
      sym_preproc_custom,
    STATE(74), 1,
      sym__unary_operator,
    STATE(195), 1,
      sym__ident,
    STATE(197), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(211), 1,
      sym__call_phrase,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(535), 1,
      sym_ident_path,
    STATE(598), 1,
      sym__for_update,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(633), 2,
      sym_func_call_statement,
      sym__variable_updating_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(131), 3,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [284] = 39,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(198), 1,
      anon_sym_RPAREN,
    STATE(15), 1,
      sym_preproc_custom,
    STATE(74), 1,
      sym__unary_operator,
    STATE(195), 1,
      sym__ident,
    STATE(197), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(211), 1,
      sym__call_phrase,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(535), 1,
      sym_ident_path,
    STATE(599), 1,
      sym__for_update,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(633), 2,
      sym_func_call_statement,
      sym__variable_updating_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(131), 3,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [426] = 39,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(71), 1,
      anon_sym__,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(200), 1,
      anon_sym_RPAREN,
    STATE(16), 1,
      sym_preproc_custom,
    STATE(74), 1,
      sym__unary_operator,
    STATE(195), 1,
      sym__ident,
    STATE(197), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(211), 1,
      sym__call_phrase,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(535), 1,
      sym_ident_path,
    STATE(611), 1,
      sym__for_update,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(633), 2,
      sym_func_call_statement,
      sym__variable_updating_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(131), 3,
      sym_assignment_statement,
      sym_increment_statement,
      sym_decrement_statement,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [568] = 37,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(220), 1,
      anon_sym_default,
    STATE(17), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(287), 1,
      sym__expression,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(492), 1,
      sym_case_selector,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(202), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_COLON,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [703] = 37,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(220), 1,
      anon_sym_default,
    STATE(18), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(287), 1,
      sym__expression,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(492), 1,
      sym_case_selector,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(222), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_COLON,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [838] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(19), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(226), 19,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(224), 35,
      anon_sym_import,
      anon_sym_as,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_DOT,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_COLON,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [908] = 37,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(220), 1,
      anon_sym_default,
    STATE(20), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(287), 1,
      sym__expression,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(450), 1,
      sym__case_selectors,
    STATE(470), 1,
      sym_case_selector,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1041] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(21), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(545), 1,
      sym__template_arg_expression,
    STATE(626), 1,
      sym__ident_pattern_token,
    STATE(628), 1,
      sym__template_arg_comma_list,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1171] = 37,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(260), 1,
      aux_sym_preproc_custom_token1,
    STATE(22), 1,
      sym_preproc_custom,
    STATE(23), 1,
      aux_sym_preproc_custom_repeat1,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(117), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1303] = 36,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(262), 1,
      sym_identifier,
    ACTIONS(271), 1,
      sym_hex_int_literal,
    ACTIONS(277), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(283), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(286), 1,
      anon_sym_LPAREN,
    ACTIONS(292), 1,
      aux_sym_preproc_custom_token1,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(117), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(265), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(268), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(280), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(23), 2,
      sym_preproc_custom,
      aux_sym_preproc_custom_repeat1,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(274), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(289), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1433] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(24), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(545), 1,
      sym__template_arg_expression,
    STATE(626), 1,
      sym__ident_pattern_token,
    STATE(634), 1,
      sym__template_arg_comma_list,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1563] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    ACTIONS(294), 1,
      sym_template_args_end,
    STATE(25), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(570), 1,
      sym__template_arg_expression,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1693] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(220), 1,
      anon_sym_default,
    STATE(26), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(287), 1,
      sym__expression,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(492), 1,
      sym_case_selector,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1823] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(296), 1,
      anon_sym_RPAREN,
    STATE(27), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(296), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(605), 1,
      sym_argument_list,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [1953] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(298), 1,
      anon_sym_RPAREN,
    STATE(28), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(296), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    STATE(615), 1,
      sym_argument_list,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2083] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(29), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(545), 1,
      sym__template_arg_expression,
    STATE(614), 1,
      sym__template_arg_comma_list,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2213] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    ACTIONS(300), 1,
      sym_template_args_end,
    STATE(30), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(570), 1,
      sym__template_arg_expression,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2343] = 37,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    ACTIONS(302), 1,
      aux_sym_preproc_custom_token1,
    STATE(22), 1,
      aux_sym_preproc_custom_repeat1,
    STATE(31), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(117), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2475] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(304), 1,
      anon_sym_RPAREN,
    STATE(32), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(296), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    STATE(623), 1,
      sym_argument_list,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2605] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(306), 1,
      anon_sym_RPAREN,
    STATE(33), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(296), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    STATE(629), 1,
      sym_argument_list,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2735] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(34), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(545), 1,
      sym__template_arg_expression,
    STATE(604), 1,
      sym__template_arg_comma_list,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2865] = 36,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(35), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(545), 1,
      sym__template_arg_expression,
    STATE(622), 1,
      sym__template_arg_comma_list,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [2995] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(308), 1,
      anon_sym_RPAREN,
    STATE(36), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(306), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3122] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(310), 1,
      anon_sym_SEMI,
    STATE(37), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(328), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3249] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(312), 1,
      anon_sym_RPAREN,
    STATE(38), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(306), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3376] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(314), 1,
      anon_sym_SEMI,
    STATE(39), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(314), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3503] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    ACTIONS(316), 1,
      anon_sym_SEMI,
    STATE(40), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(325), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3630] = 35,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(41), 1,
      sym_preproc_custom,
    STATE(84), 1,
      sym__unary_operator,
    STATE(297), 1,
      sym__ident,
    STATE(305), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(570), 1,
      sym__template_arg_expression,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3757] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(42), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(334), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [3881] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(43), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(335), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4005] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(44), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(316), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4129] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(45), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(317), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4253] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(46), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(319), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4377] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(47), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(320), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4501] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(48), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(324), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4625] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(49), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(262), 1,
      sym__expression,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4749] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(50), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(118), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4873] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(51), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(122), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [4997] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(52), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(121), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5121] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(53), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(123), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5245] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(54), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(125), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5369] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(55), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(113), 1,
      sym__expression,
    STATE(115), 1,
      sym__ident,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5493] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(56), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(306), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5617] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(57), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(313), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5741] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(58), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(116), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5865] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(59), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(119), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [5989] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(60), 1,
      sym_preproc_custom,
    STATE(61), 1,
      sym__unary_operator,
    STATE(115), 1,
      sym__ident,
    STATE(124), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6113] = 33,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(248), 1,
      sym_hex_int_literal,
    ACTIONS(252), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(256), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(258), 1,
      anon_sym_LPAREN,
    STATE(115), 1,
      sym__ident,
    STATE(120), 1,
      sym__expression,
    STATE(157), 1,
      sym__template_elaborated_ident,
    STATE(172), 1,
      sym__call_phrase,
    STATE(173), 1,
      sym__short_circuit_or_expression,
    STATE(174), 1,
      sym__short_circuit_and_expression,
    STATE(175), 1,
      sym__binary_or_expression,
    STATE(177), 1,
      sym_decimal_int_literal,
    STATE(179), 1,
      sym__binary_xor_expression,
    STATE(180), 1,
      sym__binary_and_expression,
    STATE(181), 1,
      sym__relational_expression,
    STATE(182), 1,
      sym__shift_expression,
    STATE(185), 1,
      sym__additive_expression,
    STATE(187), 1,
      sym__multiplicative_expression,
    STATE(514), 1,
      sym_ident_path,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(244), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(246), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(254), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(61), 2,
      sym__unary_operator,
      sym_preproc_custom,
    STATE(169), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(168), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(250), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(165), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(188), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6235] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(62), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(336), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6359] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(63), 1,
      sym_preproc_custom,
    STATE(64), 1,
      sym__unary_operator,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(321), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6483] = 33,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(244), 1,
      sym__ident,
    STATE(246), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(64), 2,
      sym__unary_operator,
      sym_preproc_custom,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6605] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(65), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(256), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6729] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(66), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(255), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6853] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(67), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(312), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [6977] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(68), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(254), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7101] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(69), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(250), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7225] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(70), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(251), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7349] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(71), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(248), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7473] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(72), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(252), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7597] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(73), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(253), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7721] = 33,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(195), 1,
      sym__ident,
    STATE(206), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(74), 2,
      sym__unary_operator,
      sym_preproc_custom,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7843] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(75), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(208), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [7967] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(76), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(198), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8091] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(77), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(199), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8215] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(78), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(200), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8339] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(79), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(201), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8463] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(80), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(202), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8587] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(81), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(203), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8711] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(82), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(204), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8835] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(53), 1,
      sym_hex_int_literal,
    ACTIONS(57), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(61), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(63), 1,
      anon_sym_LPAREN,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(74), 1,
      sym__unary_operator,
    STATE(83), 1,
      sym_preproc_custom,
    STATE(195), 1,
      sym__ident,
    STATE(205), 1,
      sym__expression,
    STATE(209), 1,
      sym__template_elaborated_ident,
    STATE(221), 1,
      sym_decimal_int_literal,
    STATE(228), 1,
      sym__short_circuit_or_expression,
    STATE(229), 1,
      sym__short_circuit_and_expression,
    STATE(230), 1,
      sym__binary_or_expression,
    STATE(231), 1,
      sym__binary_xor_expression,
    STATE(232), 1,
      sym__binary_and_expression,
    STATE(233), 1,
      sym__relational_expression,
    STATE(234), 1,
      sym__shift_expression,
    STATE(235), 1,
      sym__additive_expression,
    STATE(236), 1,
      sym__multiplicative_expression,
    STATE(242), 1,
      sym__call_phrase,
    STATE(535), 1,
      sym_ident_path,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(49), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(51), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(59), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(226), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(225), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(55), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(224), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(237), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [8959] = 33,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(297), 1,
      sym__ident,
    STATE(308), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(84), 2,
      sym__unary_operator,
      sym_preproc_custom,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9081] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(85), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(310), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9205] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(86), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(311), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9329] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(87), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(309), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9453] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(88), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(299), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9577] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(89), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(300), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9701] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(90), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(304), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9825] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(91), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(301), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [9949] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(92), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(302), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10073] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(232), 1,
      sym_hex_int_literal,
    ACTIONS(236), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(240), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    STATE(84), 1,
      sym__unary_operator,
    STATE(93), 1,
      sym_preproc_custom,
    STATE(297), 1,
      sym__ident,
    STATE(303), 1,
      sym__expression,
    STATE(323), 1,
      sym__template_elaborated_ident,
    STATE(340), 1,
      sym__binary_and_expression,
    STATE(343), 1,
      sym_decimal_int_literal,
    STATE(349), 1,
      sym__short_circuit_or_expression,
    STATE(350), 1,
      sym__short_circuit_and_expression,
    STATE(351), 1,
      sym__binary_or_expression,
    STATE(352), 1,
      sym__binary_xor_expression,
    STATE(353), 1,
      sym__relational_expression,
    STATE(354), 1,
      sym__shift_expression,
    STATE(355), 1,
      sym__multiplicative_expression,
    STATE(360), 1,
      sym__call_phrase,
    STATE(368), 1,
      sym__additive_expression,
    STATE(538), 1,
      sym_ident_path,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(228), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(230), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(238), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(348), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(347), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(234), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(346), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    STATE(356), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10197] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(94), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(264), 1,
      sym__expression,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10321] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(95), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(263), 1,
      sym__expression,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10445] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(96), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(259), 1,
      sym__expression,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10569] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(97), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(330), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10693] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(98), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(331), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10817] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(99), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(332), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [10941] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(100), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(333), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [11065] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(101), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(327), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [11189] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(102), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(329), 1,
      sym__expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [11313] = 34,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(208), 1,
      sym_hex_int_literal,
    ACTIONS(212), 1,
      aux_sym__decimal_float_literal_token4,
    ACTIONS(216), 1,
      aux_sym__hex_float_literal_token2,
    ACTIONS(218), 1,
      anon_sym_LPAREN,
    STATE(64), 1,
      sym__unary_operator,
    STATE(103), 1,
      sym_preproc_custom,
    STATE(244), 1,
      sym__ident,
    STATE(247), 1,
      sym__expression,
    STATE(257), 1,
      sym__template_elaborated_ident,
    STATE(269), 1,
      sym__short_circuit_and_expression,
    STATE(270), 1,
      sym__binary_or_expression,
    STATE(271), 1,
      sym__binary_xor_expression,
    STATE(272), 1,
      sym__binary_and_expression,
    STATE(273), 1,
      sym__relational_expression,
    STATE(274), 1,
      sym__shift_expression,
    STATE(275), 1,
      sym__additive_expression,
    STATE(276), 1,
      sym__multiplicative_expression,
    STATE(284), 1,
      sym_decimal_int_literal,
    STATE(291), 1,
      sym__call_phrase,
    STATE(292), 1,
      sym__short_circuit_or_expression,
    STATE(527), 1,
      sym_ident_path,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(204), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(206), 2,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
    ACTIONS(214), 2,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
    STATE(295), 2,
      sym__decimal_float_literal,
      sym__hex_float_literal,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(282), 3,
      sym_bool_literal,
      sym_int_literal,
      sym_float_literal,
    ACTIONS(210), 4,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
    STATE(280), 4,
      sym_unary_expression,
      sym__primary_expression,
      sym_paren_expression,
      sym_binary_expression,
    STATE(281), 4,
      sym__literal,
      sym_call_expression,
      sym_indexing_expression,
      sym_named_component_expression,
    ACTIONS(69), 5,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [11437] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(322), 1,
      anon_sym_AT,
    STATE(106), 1,
      sym_attribute,
    STATE(104), 2,
      sym_preproc_custom,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(320), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(318), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11506] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(329), 1,
      anon_sym_LPAREN,
    STATE(105), 1,
      sym_preproc_custom,
    STATE(107), 1,
      sym__argument_expression_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(327), 14,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(325), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11574] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(106), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(333), 15,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(331), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11637] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(107), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(337), 15,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(335), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11700] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(108), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(341), 15,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(339), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11763] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(109), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(345), 15,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(343), 32,
      anon_sym_import,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_const,
      anon_sym_override,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
      anon_sym_virtual,
      anon_sym_fn,
  [11826] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(351), 1,
      anon_sym_else,
    STATE(110), 1,
      sym_preproc_custom,
    STATE(111), 1,
      aux_sym_if_statement_repeat1,
    STATE(133), 1,
      sym_else_if_clause,
    STATE(145), 1,
      sym_else_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(349), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(347), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [11893] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(351), 1,
      anon_sym_else,
    STATE(111), 1,
      sym_preproc_custom,
    STATE(112), 1,
      aux_sym_if_statement_repeat1,
    STATE(133), 1,
      sym_else_if_clause,
    STATE(151), 1,
      sym_else_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(355), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(353), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [11960] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(361), 1,
      anon_sym_else,
    STATE(133), 1,
      sym_else_if_clause,
    STATE(112), 2,
      sym_preproc_custom,
      aux_sym_if_statement_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(359), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(357), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [12022] = 16,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(113), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(364), 11,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_BANG,
    ACTIONS(366), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12101] = 9,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(384), 1,
      anon_sym_COLON_COLON,
    ACTIONS(388), 1,
      sym_template_args_start,
    STATE(114), 1,
      sym_preproc_custom,
    STATE(192), 1,
      sym_template_list,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(382), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(386), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [12166] = 9,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(388), 1,
      sym_template_args_start,
    ACTIONS(392), 1,
      anon_sym_COLON_COLON,
    STATE(115), 1,
      sym_preproc_custom,
    STATE(164), 1,
      sym_template_list,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(390), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(394), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [12231] = 15,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(116), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(396), 11,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_BANG,
    ACTIONS(398), 18,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12308] = 21,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    ACTIONS(404), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(406), 1,
      anon_sym_AMP_AMP,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(410), 1,
      anon_sym_CARET,
    ACTIONS(412), 1,
      anon_sym_AMP,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(117), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(400), 9,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_BANG,
    ACTIONS(402), 9,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12397] = 14,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(118), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(414), 11,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_BANG,
    ACTIONS(416), 20,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12472] = 13,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(119), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 11,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_BANG,
    ACTIONS(420), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12545] = 11,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(120), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(422), 12,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(424), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12614] = 19,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(410), 1,
      anon_sym_CARET,
    ACTIONS(412), 1,
      anon_sym_AMP,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(121), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(426), 9,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_BANG,
    ACTIONS(428), 11,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12699] = 20,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    ACTIONS(406), 1,
      anon_sym_AMP_AMP,
    ACTIONS(408), 1,
      anon_sym_PIPE,
    ACTIONS(410), 1,
      anon_sym_CARET,
    ACTIONS(412), 1,
      anon_sym_AMP,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(122), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(430), 9,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_BANG,
    ACTIONS(432), 10,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12786] = 18,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    ACTIONS(410), 1,
      anon_sym_CARET,
    ACTIONS(412), 1,
      anon_sym_AMP,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(123), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(434), 10,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_BANG,
    ACTIONS(436), 11,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12869] = 11,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(124), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(438), 12,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(440), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [12938] = 17,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(368), 1,
      anon_sym_DOT,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(378), 1,
      anon_sym_LBRACK,
    ACTIONS(412), 1,
      anon_sym_AMP,
    STATE(58), 1,
      sym__relational_operator,
    STATE(59), 1,
      sym__additive_operator,
    STATE(60), 1,
      sym__multiplicative_operator,
    STATE(125), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(380), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(442), 10,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_PIPE,
      anon_sym_BANG,
    ACTIONS(444), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_TILDE,
      aux_sym_preproc_custom_token1,
  [13019] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(126), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(446), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(448), 27,
      sym_template_args_start,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COLON_COLON,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [13077] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(127), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(452), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(450), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13133] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(128), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(456), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(454), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13189] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(129), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(460), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(458), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13245] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(130), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(464), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(462), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13301] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(131), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(468), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(466), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13357] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(132), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(472), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(470), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13413] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(133), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(476), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(474), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13469] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(134), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(480), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(478), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13525] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(135), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(484), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(482), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13581] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(136), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(488), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(486), 24,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_else,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13637] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(137), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(492), 17,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(490), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13693] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(138), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(496), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(494), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13748] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(139), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(500), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(498), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13803] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(140), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(504), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(502), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13858] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(141), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(508), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(506), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13913] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(142), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(512), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(510), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [13968] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(143), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(516), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(514), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14023] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(144), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(520), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(518), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14078] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(145), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(355), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(353), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14133] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(146), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(524), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(522), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14188] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(147), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(528), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(526), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14243] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(148), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(532), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(530), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14298] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(149), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(536), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(534), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14353] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(150), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(540), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(538), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14408] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(151), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(544), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(542), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14463] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(152), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(548), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(546), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14518] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(153), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(552), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(550), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14573] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(154), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(556), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(554), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14628] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(155), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(560), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(558), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14683] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(156), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(564), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(562), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14738] = 7,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(157), 1,
      sym_preproc_custom,
    STATE(166), 1,
      sym__argument_expression_list,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(566), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(568), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [14797] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(158), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(572), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(570), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14852] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(159), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(576), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(574), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14907] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(160), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(580), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(578), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [14962] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(161), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(584), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(582), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [15017] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(162), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(588), 16,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AT,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
    ACTIONS(586), 23,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_const,
      anon_sym_var,
      anon_sym__,
      anon_sym_return,
      anon_sym_const_assert,
      anon_sym_let,
      anon_sym_if,
      anon_sym_switch,
      anon_sym_for,
      anon_sym_loop,
      anon_sym_while,
      anon_sym_break,
      anon_sym_continue,
      anon_sym_continuing,
      anon_sym_discard,
  [15072] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(163), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(590), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(592), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15128] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(164), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(382), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(386), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15184] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(165), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(566), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(568), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15240] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(166), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(594), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(596), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15296] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(167), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(598), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(600), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15352] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(168), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(602), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(604), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15408] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(169), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(606), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(608), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15464] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(170), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(339), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(341), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15520] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(171), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(610), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(612), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15576] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(172), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(614), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(616), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15632] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(173), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15688] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(174), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15744] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(175), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15800] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(176), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(622), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(624), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15856] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(177), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(626), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(628), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [15912] = 33,
    ACTIONS(3), 1,
      sym_preproc_directive,
    ACTIONS(11), 1,
      anon_sym_import,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(39), 1,
      anon_sym_POUNDimport,
    ACTIONS(630), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(178), 1,
      sym_preproc_custom,
    STATE(227), 1,
      aux_sym_translation_unit_repeat2,
    STATE(258), 1,
      aux_sym_import_repeat1,
    STATE(315), 1,
      aux_sym_translation_unit_repeat3,
    STATE(369), 1,
      aux_sym_translation_unit_repeat1,
    STATE(390), 1,
      sym__decorated_global_directive,
    STATE(396), 1,
      sym_global_directive,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    STATE(383), 2,
      sym_import,
      sym_preproc_bevy_import,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [16022] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(179), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16078] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(180), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16134] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(181), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16190] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(182), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16246] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(183), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(632), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(634), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16302] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(184), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(636), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(638), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16358] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(185), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16414] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(186), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(224), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(226), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16470] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(187), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(618), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(620), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16526] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(188), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(640), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(642), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16582] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(189), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(644), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(646), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16638] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(190), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(343), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(345), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16694] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(191), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(648), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(650), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16750] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(192), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(652), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(654), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16806] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(193), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(656), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(658), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16862] = 6,
    ACTIONS(7), 1,
      sym__blankspace,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(194), 1,
      sym_preproc_custom,
    ACTIONS(5), 2,
      sym_block_comment,
      sym_line_comment,
    ACTIONS(660), 13,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
      anon_sym_BANG,
    ACTIONS(662), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_TILDE,
      anon_sym_LBRACK,
      aux_sym_preproc_custom_token1,
  [16918] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(392), 1,
      anon_sym_COLON_COLON,
    ACTIONS(664), 1,
      sym_template_args_start,
    STATE(195), 1,
      sym_preproc_custom,
    STATE(215), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(390), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(394), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [16977] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(384), 1,
      anon_sym_COLON_COLON,
    ACTIONS(664), 1,
      sym_template_args_start,
    STATE(196), 1,
      sym_preproc_custom,
    STATE(216), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(386), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17036] = 22,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(668), 1,
      anon_sym_EQ,
    ACTIONS(670), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(672), 1,
      anon_sym_AMP_AMP,
    ACTIONS(674), 1,
      anon_sym_PIPE,
    ACTIONS(676), 1,
      anon_sym_CARET,
    ACTIONS(678), 1,
      anon_sym_AMP,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    ACTIONS(686), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(688), 1,
      anon_sym_DASH_DASH,
    STATE(44), 1,
      sym__compound_assignment_operator,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(197), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(684), 10,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
  [17123] = 18,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(430), 1,
      anon_sym_EQ,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(672), 1,
      anon_sym_AMP_AMP,
    ACTIONS(674), 1,
      anon_sym_PIPE,
    ACTIONS(676), 1,
      anon_sym_CARET,
    ACTIONS(678), 1,
      anon_sym_AMP,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(198), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 13,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17201] = 17,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(426), 1,
      anon_sym_EQ,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(674), 1,
      anon_sym_PIPE,
    ACTIONS(676), 1,
      anon_sym_CARET,
    ACTIONS(678), 1,
      anon_sym_AMP,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(199), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(428), 14,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17277] = 16,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(676), 1,
      anon_sym_CARET,
    ACTIONS(678), 1,
      anon_sym_AMP,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(200), 1,
      sym_preproc_custom,
    ACTIONS(434), 2,
      anon_sym_EQ,
      anon_sym_PIPE,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(436), 14,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17351] = 15,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(678), 1,
      anon_sym_AMP,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(201), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(442), 3,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(444), 14,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17423] = 14,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(202), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(364), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 14,
      sym_shift_left_assign,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17493] = 13,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(203), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(690), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(396), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(398), 20,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17561] = 11,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(204), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(418), 6,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(420), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17625] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(205), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(438), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(440), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17687] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(206), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(422), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(424), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17749] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(207), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(446), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(448), 27,
      sym_template_args_start,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_COLON_COLON,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17801] = 12,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(666), 1,
      anon_sym_DOT,
    ACTIONS(682), 1,
      anon_sym_LBRACK,
    STATE(81), 1,
      sym__relational_operator,
    STATE(82), 1,
      sym__additive_operator,
    STATE(83), 1,
      sym__multiplicative_operator,
    STATE(208), 1,
      sym_preproc_custom,
    ACTIONS(680), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(376), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(414), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
    ACTIONS(416), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17867] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(692), 1,
      anon_sym_LPAREN,
    STATE(209), 1,
      sym_preproc_custom,
    STATE(210), 1,
      sym__argument_expression_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(568), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17922] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(210), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(594), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(596), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [17972] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(694), 1,
      anon_sym_SEMI,
    STATE(211), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(614), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(616), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18024] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(212), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(343), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(345), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18074] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(213), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(598), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(600), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18124] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(214), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(339), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(341), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_SEMI,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18174] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(215), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(386), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18224] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(216), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(652), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(654), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18274] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(217), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(648), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(650), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18323] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(218), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(224), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(226), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18372] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(219), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(610), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(612), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18421] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(220), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(622), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(624), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18470] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(221), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(626), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(628), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18519] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(222), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(632), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(634), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18568] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(223), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(636), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(638), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18617] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(224), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(568), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18666] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(225), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(602), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(604), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18715] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(226), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(606), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(608), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18764] = 29,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(696), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(227), 1,
      sym_preproc_custom,
    STATE(260), 1,
      aux_sym_import_repeat1,
    STATE(326), 1,
      aux_sym_translation_unit_repeat3,
    STATE(358), 1,
      aux_sym_translation_unit_repeat2,
    STATE(390), 1,
      sym__decorated_global_directive,
    STATE(396), 1,
      sym_global_directive,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [18861] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(228), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18910] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(229), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [18959] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(230), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19008] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(231), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19057] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(232), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19106] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(233), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19155] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(234), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19204] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(235), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19253] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(236), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19302] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(237), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(640), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(642), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19351] = 29,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(630), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(238), 1,
      sym_preproc_custom,
    STATE(260), 1,
      aux_sym_import_repeat1,
    STATE(315), 1,
      aux_sym_translation_unit_repeat3,
    STATE(358), 1,
      aux_sym_translation_unit_repeat2,
    STATE(390), 1,
      sym__decorated_global_directive,
    STATE(396), 1,
      sym_global_directive,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [19448] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(239), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(656), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(658), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19497] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(240), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(644), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(646), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19546] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(241), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(660), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(662), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19595] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(242), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(614), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(616), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19644] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(243), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(590), 9,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_AMP,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(592), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_shift_left_assign,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      sym_shift_right_assign,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PLUS_PLUS,
      anon_sym_DASH_DASH,
  [19693] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(392), 1,
      anon_sym_COLON_COLON,
    ACTIONS(698), 1,
      sym_template_args_start,
    STATE(244), 1,
      sym_preproc_custom,
    STATE(265), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(390), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(394), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [19746] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(384), 1,
      anon_sym_COLON_COLON,
    ACTIONS(698), 1,
      sym_template_args_start,
    STATE(245), 1,
      sym_preproc_custom,
    STATE(266), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(386), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [19799] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(246), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(422), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(424), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
  [19855] = 17,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(247), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(428), 9,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_RBRACK,
  [19925] = 14,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(248), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(396), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(398), 16,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
  [19989] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(249), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(446), 4,
      anon_sym_COLON,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(448), 26,
      sym_template_args_start,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [20035] = 16,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(442), 1,
      anon_sym_PIPE,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(708), 1,
      anon_sym_AMP,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(250), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(444), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_RBRACK,
  [20103] = 15,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(251), 1,
      sym_preproc_custom,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(366), 10,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_RBRACK,
  [20169] = 12,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(252), 1,
      sym_preproc_custom,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(420), 20,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_RBRACK,
  [20229] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(253), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(438), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(440), 22,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_RBRACK,
  [20285] = 17,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PIPE,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(254), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(436), 9,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_RBRACK,
  [20355] = 18,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(255), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(432), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_RBRACK,
  [20427] = 13,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(256), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(414), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(416), 18,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
  [20489] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(714), 1,
      anon_sym_LPAREN,
    STATE(257), 1,
      sym_preproc_custom,
    STATE(283), 1,
      sym__argument_expression_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(568), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [20538] = 25,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(716), 1,
      anon_sym_import,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(258), 1,
      sym_preproc_custom,
    STATE(395), 1,
      sym_global_directive,
    STATE(402), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [20623] = 23,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(106), 1,
      sym_attribute,
    STATE(149), 1,
      sym_compound_statement,
    STATE(259), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20703] = 24,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(260), 1,
      sym_preproc_custom,
    STATE(395), 1,
      sym_global_directive,
    STATE(402), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [20785] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(261), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(598), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(600), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [20829] = 23,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(106), 1,
      sym_attribute,
    STATE(136), 1,
      sym_compound_statement,
    STATE(262), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20909] = 23,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(720), 1,
      anon_sym_LBRACE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(106), 1,
      sym_attribute,
    STATE(148), 1,
      sym_switch_body,
    STATE(263), 1,
      sym_preproc_custom,
    STATE(499), 1,
      aux_sym_import_repeat1,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [20989] = 23,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(106), 1,
      sym_attribute,
    STATE(135), 1,
      sym_compound_statement,
    STATE(264), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [21069] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(265), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(386), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21113] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(266), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(652), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(654), 25,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21157] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(267), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(648), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(650), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21200] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(268), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(660), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(662), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21243] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(269), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21286] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(270), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21329] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(271), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21372] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(272), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21415] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(273), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21458] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(274), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21501] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(275), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21544] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(276), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21587] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(277), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(632), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(634), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21630] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(278), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(339), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(341), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21673] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(279), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(636), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(638), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21716] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(280), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(640), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(642), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21759] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(281), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(568), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21802] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(282), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(602), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(604), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21845] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(283), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(594), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(596), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21888] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(284), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(626), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(628), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21931] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(285), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(590), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(592), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [21974] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(286), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(610), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(612), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22017] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(287), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(722), 4,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_COLON,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22088] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(288), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(343), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(345), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22131] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(289), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(644), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(646), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22174] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(290), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(224), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(226), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22217] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(291), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(614), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(616), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22260] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(292), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22303] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(293), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(622), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(624), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22346] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(294), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(656), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(658), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22389] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(295), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(606), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(608), 24,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
  [22432] = 21,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(724), 1,
      anon_sym_COMMA,
    ACTIONS(726), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(296), 1,
      sym_preproc_custom,
    STATE(522), 1,
      aux_sym_argument_list_repeat1,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22506] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(392), 1,
      anon_sym_COLON_COLON,
    ACTIONS(728), 1,
      sym_template_args_start,
    STATE(297), 1,
      sym_preproc_custom,
    STATE(337), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(390), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(394), 20,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [22554] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(384), 1,
      anon_sym_COLON_COLON,
    ACTIONS(728), 1,
      sym_template_args_start,
    STATE(298), 1,
      sym_preproc_custom,
    STATE(338), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(386), 20,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [22602] = 17,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(434), 1,
      anon_sym_PIPE,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(732), 1,
      anon_sym_CARET,
    ACTIONS(734), 1,
      anon_sym_AMP,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(299), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(436), 4,
      sym_template_args_end,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22667] = 16,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(442), 1,
      anon_sym_PIPE,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(734), 1,
      anon_sym_AMP,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(300), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(444), 5,
      sym_template_args_end,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22730] = 14,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(301), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(396), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(398), 11,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22789] = 12,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(302), 1,
      sym_preproc_custom,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(418), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(420), 15,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
  [22844] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(303), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(438), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(440), 17,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [22895] = 15,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(304), 1,
      sym_preproc_custom,
    ACTIONS(364), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(366), 5,
      sym_template_args_end,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [22956] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(732), 1,
      anon_sym_CARET,
    ACTIONS(734), 1,
      anon_sym_AMP,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    ACTIONS(742), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(744), 1,
      anon_sym_AMP_AMP,
    ACTIONS(746), 1,
      anon_sym_PIPE,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(305), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(740), 2,
      sym_template_args_end,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23025] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(306), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(748), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23094] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(307), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(446), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(448), 22,
      sym_template_args_start,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COLON_COLON,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [23135] = 10,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(308), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(422), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(424), 17,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
  [23186] = 17,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(732), 1,
      anon_sym_CARET,
    ACTIONS(734), 1,
      anon_sym_AMP,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    ACTIONS(746), 1,
      anon_sym_PIPE,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(309), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(428), 4,
      sym_template_args_end,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23251] = 13,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(310), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(414), 2,
      anon_sym_PIPE,
      anon_sym_AMP,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(416), 13,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23308] = 18,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(730), 1,
      anon_sym_DOT,
    ACTIONS(732), 1,
      anon_sym_CARET,
    ACTIONS(734), 1,
      anon_sym_AMP,
    ACTIONS(736), 1,
      anon_sym_LBRACK,
    ACTIONS(744), 1,
      anon_sym_AMP_AMP,
    ACTIONS(746), 1,
      anon_sym_PIPE,
    STATE(91), 1,
      sym__relational_operator,
    STATE(92), 1,
      sym__additive_operator,
    STATE(93), 1,
      sym__multiplicative_operator,
    STATE(311), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(738), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(432), 3,
      sym_template_args_end,
      anon_sym_COMMA,
      anon_sym_PIPE_PIPE,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23375] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(750), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(312), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23443] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(752), 1,
      anon_sym_RBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(313), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23511] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(754), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(314), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23579] = 22,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(696), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(315), 1,
      sym_preproc_custom,
    STATE(322), 1,
      aux_sym_translation_unit_repeat3,
    STATE(370), 1,
      aux_sym_import_repeat1,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [23653] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(756), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(316), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23721] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(758), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(317), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23789] = 22,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(630), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(318), 1,
      sym_preproc_custom,
    STATE(322), 1,
      aux_sym_translation_unit_repeat3,
    STATE(370), 1,
      aux_sym_import_repeat1,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [23863] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(760), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(319), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23931] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(762), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(320), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [23999] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(764), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(321), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24067] = 21,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(766), 1,
      ts_builtin_sym_end,
    ACTIONS(768), 1,
      anon_sym_SEMI,
    ACTIONS(771), 1,
      anon_sym_AT,
    ACTIONS(774), 1,
      anon_sym_struct,
    ACTIONS(777), 1,
      anon_sym_alias,
    ACTIONS(780), 1,
      anon_sym_const,
    ACTIONS(783), 1,
      anon_sym_override,
    ACTIONS(786), 1,
      anon_sym_var,
    ACTIONS(789), 1,
      anon_sym_const_assert,
    ACTIONS(792), 1,
      anon_sym_virtual,
    ACTIONS(795), 1,
      anon_sym_fn,
    STATE(106), 1,
      sym_attribute,
    STATE(370), 1,
      aux_sym_import_repeat1,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    STATE(322), 2,
      sym_preproc_custom,
      aux_sym_translation_unit_repeat3,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [24139] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(798), 1,
      anon_sym_LPAREN,
    STATE(323), 1,
      sym_preproc_custom,
    STATE(357), 1,
      sym__argument_expression_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(568), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [24183] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(800), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(324), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24251] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(802), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(325), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24319] = 22,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(804), 1,
      ts_builtin_sym_end,
    STATE(106), 1,
      sym_attribute,
    STATE(322), 1,
      aux_sym_translation_unit_repeat3,
    STATE(326), 1,
      sym_preproc_custom,
    STATE(370), 1,
      aux_sym_import_repeat1,
    STATE(415), 1,
      sym__decorated_global_decl,
    STATE(417), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [24393] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(806), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(327), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24461] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(808), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(328), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24529] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(810), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(329), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24597] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(812), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(330), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24665] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(814), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(331), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24733] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(816), 1,
      anon_sym_RPAREN,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(332), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24801] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(818), 1,
      anon_sym_RBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(333), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24869] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(820), 1,
      anon_sym_RBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(334), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [24937] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(822), 1,
      anon_sym_RBRACK,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(335), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [25005] = 19,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(376), 1,
      anon_sym_SLASH,
    ACTIONS(700), 1,
      anon_sym_DOT,
    ACTIONS(702), 1,
      anon_sym_LBRACK,
    ACTIONS(704), 1,
      anon_sym_PIPE,
    ACTIONS(706), 1,
      anon_sym_CARET,
    ACTIONS(708), 1,
      anon_sym_AMP,
    ACTIONS(712), 1,
      anon_sym_AMP_AMP,
    ACTIONS(718), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(824), 1,
      anon_sym_SEMI,
    STATE(71), 1,
      sym__relational_operator,
    STATE(72), 1,
      sym__additive_operator,
    STATE(73), 1,
      sym__multiplicative_operator,
    STATE(336), 1,
      sym_preproc_custom,
    ACTIONS(372), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(374), 2,
      anon_sym_STAR,
      anon_sym_PERCENT,
    ACTIONS(710), 2,
      sym_shift_left,
      sym_shift_right,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(370), 6,
      sym_less_than,
      sym_less_than_equal,
      sym_greater_than,
      sym_greater_than_equal,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [25073] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(337), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(382), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(386), 20,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25112] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(338), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(652), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(654), 20,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25151] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(339), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(598), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(600), 20,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_LPAREN,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25190] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(340), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25228] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(341), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(610), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(612), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25266] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(342), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(622), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(624), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25304] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(343), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(626), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(628), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25342] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(344), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(632), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(634), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25380] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(345), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(636), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(638), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25418] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(346), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(566), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(568), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25456] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(347), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(602), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(604), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25494] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(348), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(606), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(608), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25532] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(349), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25570] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(350), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25608] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(351), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25646] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(352), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25684] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(353), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25722] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(354), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25760] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(355), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25798] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(356), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(640), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(642), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25836] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(357), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(594), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(596), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25874] = 14,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(828), 1,
      anon_sym_diagnostic,
    ACTIONS(831), 1,
      anon_sym_enable,
    ACTIONS(834), 1,
      anon_sym_requires,
    ACTIONS(837), 1,
      anon_sym_AT,
    ACTIONS(840), 1,
      anon_sym_const,
    STATE(106), 1,
      sym_attribute,
    STATE(390), 1,
      sym__decorated_global_directive,
    STATE(396), 1,
      sym_global_directive,
    STATE(418), 1,
      aux_sym_import_repeat1,
    STATE(358), 2,
      sym_preproc_custom,
      aux_sym_translation_unit_repeat2,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
    ACTIONS(826), 9,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [25930] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(359), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(644), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(646), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [25968] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(360), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(614), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(616), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26006] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(361), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(656), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(658), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26044] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(362), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(660), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(662), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26082] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(363), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(590), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(592), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26120] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(364), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(343), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(345), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26158] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(365), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(648), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(650), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26196] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(366), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(339), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(341), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26234] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(367), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(224), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(226), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26272] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(368), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(618), 3,
      anon_sym_PIPE,
      anon_sym_AMP,
      anon_sym_SLASH,
    ACTIONS(620), 19,
      sym_template_args_end,
      sym_less_than,
      sym_less_than_equal,
      sym_shift_left,
      sym_greater_than,
      sym_greater_than_equal,
      sym_shift_right,
      anon_sym_COMMA,
      anon_sym_DOT,
      anon_sym_PIPE_PIPE,
      anon_sym_AMP_AMP,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_PERCENT,
      anon_sym_LBRACK,
  [26310] = 11,
    ACTIONS(3), 1,
      sym_preproc_directive,
    ACTIONS(844), 1,
      anon_sym_import,
    ACTIONS(847), 1,
      anon_sym_AT,
    ACTIONS(850), 1,
      anon_sym_const,
    ACTIONS(852), 1,
      anon_sym_POUNDimport,
    STATE(106), 1,
      sym_attribute,
    STATE(496), 1,
      aux_sym_import_repeat1,
    STATE(369), 2,
      sym_preproc_custom,
      aux_sym_translation_unit_repeat1,
    STATE(383), 2,
      sym_import,
      sym_preproc_bevy_import,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(842), 12,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26359] = 19,
    ACTIONS(13), 1,
      anon_sym_SEMI,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(23), 1,
      anon_sym_struct,
    ACTIONS(25), 1,
      anon_sym_alias,
    ACTIONS(27), 1,
      anon_sym_const,
    ACTIONS(29), 1,
      anon_sym_override,
    ACTIONS(31), 1,
      anon_sym_var,
    ACTIONS(33), 1,
      anon_sym_const_assert,
    ACTIONS(35), 1,
      anon_sym_virtual,
    ACTIONS(37), 1,
      anon_sym_fn,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(370), 1,
      sym_preproc_custom,
    STATE(402), 1,
      sym_global_decl,
    STATE(472), 1,
      sym_function_header,
    STATE(580), 1,
      sym_variable_decl,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(414), 6,
      sym_struct_decl,
      sym_type_alias_decl,
      sym_global_variable_decl,
      sym_global_value_decl,
      sym_const_assert_statement,
      sym_function_decl,
  [26424] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(371), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(855), 8,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
    ACTIONS(857), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [26460] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(372), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(859), 8,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
    ACTIONS(861), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [26496] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(373), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(863), 8,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
    ACTIONS(865), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [26532] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(374), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(867), 8,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
    ACTIONS(869), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [26568] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(375), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(871), 8,
      anon_sym_true,
      anon_sym_false,
      aux_sym_decimal_int_literal_token1,
      aux_sym_decimal_int_literal_token2,
      sym_hex_int_literal,
      aux_sym__decimal_float_literal_token4,
      aux_sym__hex_float_literal_token2,
      sym_identifier,
    ACTIONS(873), 12,
      aux_sym__decimal_float_literal_token1,
      aux_sym__decimal_float_literal_token2,
      aux_sym__decimal_float_literal_token3,
      aux_sym__decimal_float_literal_token5,
      aux_sym__hex_float_literal_token1,
      aux_sym__hex_float_literal_token3,
      anon_sym_LPAREN,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_BANG,
      anon_sym_TILDE,
  [26604] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(376), 1,
      sym_preproc_custom,
    ACTIONS(224), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(226), 16,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_as,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26638] = 7,
    ACTIONS(3), 1,
      sym_preproc_directive,
    ACTIONS(877), 1,
      anon_sym_COLON_COLON,
    ACTIONS(879), 1,
      anon_sym_as,
    STATE(377), 1,
      sym_preproc_custom,
    ACTIONS(881), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(875), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26676] = 7,
    ACTIONS(3), 1,
      sym_preproc_directive,
    ACTIONS(879), 1,
      anon_sym_as,
    ACTIONS(883), 1,
      anon_sym_COLON_COLON,
    STATE(378), 1,
      sym_preproc_custom,
    ACTIONS(881), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(875), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26714] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(379), 1,
      sym_preproc_custom,
    ACTIONS(887), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(885), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26746] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(380), 1,
      sym_preproc_custom,
    ACTIONS(891), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(889), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26778] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(381), 1,
      sym_preproc_custom,
    ACTIONS(895), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(893), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26810] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(382), 1,
      sym_preproc_custom,
    ACTIONS(899), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(897), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26842] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(383), 1,
      sym_preproc_custom,
    ACTIONS(903), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(901), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26874] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(384), 1,
      sym_preproc_custom,
    ACTIONS(907), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(905), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26906] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(385), 1,
      sym_preproc_custom,
    ACTIONS(911), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(909), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26938] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(386), 1,
      sym_preproc_custom,
    ACTIONS(915), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(913), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [26970] = 5,
    ACTIONS(3), 1,
      sym_preproc_directive,
    STATE(387), 1,
      sym_preproc_custom,
    ACTIONS(919), 2,
      anon_sym_const,
      anon_sym_POUNDimport,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(917), 14,
      ts_builtin_sym_end,
      anon_sym_import,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27002] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(923), 1,
      anon_sym_const,
    STATE(388), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(921), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27032] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(927), 1,
      anon_sym_const,
    STATE(389), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(925), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27062] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(931), 1,
      anon_sym_const,
    STATE(390), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(929), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27092] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(454), 1,
      anon_sym_const,
    STATE(391), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(456), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_case,
      anon_sym_default,
      anon_sym_virtual,
      anon_sym_fn,
  [27122] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(935), 1,
      anon_sym_const,
    STATE(392), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(933), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27152] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(458), 1,
      anon_sym_const,
    STATE(393), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(460), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_case,
      anon_sym_default,
      anon_sym_virtual,
      anon_sym_fn,
  [27182] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(478), 1,
      anon_sym_const,
    STATE(394), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(480), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_case,
      anon_sym_default,
      anon_sym_virtual,
      anon_sym_fn,
  [27212] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(939), 1,
      anon_sym_const,
    STATE(395), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(937), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27242] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(943), 1,
      anon_sym_const,
    STATE(396), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(941), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27272] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(947), 1,
      anon_sym_const,
    STATE(397), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(945), 13,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_diagnostic,
      anon_sym_enable,
      anon_sym_requires,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27302] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(949), 1,
      sym_identifier,
    STATE(267), 1,
      sym__ident_pattern_token,
    STATE(398), 1,
      sym_preproc_custom,
    STATE(268), 2,
      sym__member_ident,
      sym_swizzle_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(951), 8,
      aux_sym_swizzle_name_token1,
      aux_sym_swizzle_name_token2,
      aux_sym_swizzle_name_token3,
      aux_sym_swizzle_name_token4,
      aux_sym_swizzle_name_token5,
      aux_sym_swizzle_name_token6,
      aux_sym_swizzle_name_token7,
      aux_sym_swizzle_name_token8,
  [27334] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(953), 1,
      sym_identifier,
    STATE(217), 1,
      sym__ident_pattern_token,
    STATE(399), 1,
      sym_preproc_custom,
    STATE(241), 2,
      sym__member_ident,
      sym_swizzle_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(955), 8,
      aux_sym_swizzle_name_token1,
      aux_sym_swizzle_name_token2,
      aux_sym_swizzle_name_token3,
      aux_sym_swizzle_name_token4,
      aux_sym_swizzle_name_token5,
      aux_sym_swizzle_name_token6,
      aux_sym_swizzle_name_token7,
      aux_sym_swizzle_name_token8,
  [27366] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(957), 1,
      sym_identifier,
    STATE(191), 1,
      sym__ident_pattern_token,
    STATE(400), 1,
      sym_preproc_custom,
    STATE(194), 2,
      sym__member_ident,
      sym_swizzle_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(959), 8,
      aux_sym_swizzle_name_token1,
      aux_sym_swizzle_name_token2,
      aux_sym_swizzle_name_token3,
      aux_sym_swizzle_name_token4,
      aux_sym_swizzle_name_token5,
      aux_sym_swizzle_name_token6,
      aux_sym_swizzle_name_token7,
      aux_sym_swizzle_name_token8,
  [27398] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(961), 1,
      sym_identifier,
    STATE(365), 1,
      sym__ident_pattern_token,
    STATE(401), 1,
      sym_preproc_custom,
    STATE(362), 2,
      sym__member_ident,
      sym_swizzle_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(963), 8,
      aux_sym_swizzle_name_token1,
      aux_sym_swizzle_name_token2,
      aux_sym_swizzle_name_token3,
      aux_sym_swizzle_name_token4,
      aux_sym_swizzle_name_token5,
      aux_sym_swizzle_name_token6,
      aux_sym_swizzle_name_token7,
      aux_sym_swizzle_name_token8,
  [27430] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(967), 1,
      anon_sym_const,
    STATE(402), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(965), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27457] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(570), 1,
      anon_sym_const,
    STATE(403), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(572), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27484] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(971), 1,
      anon_sym_const,
    STATE(404), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(969), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27511] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(975), 1,
      anon_sym_const,
    STATE(405), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(973), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27538] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(979), 1,
      anon_sym_const,
    STATE(406), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(977), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27565] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(983), 1,
      anon_sym_const,
    STATE(407), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(981), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27592] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(987), 1,
      anon_sym_const,
    STATE(408), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(985), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27619] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(991), 1,
      anon_sym_const,
    STATE(409), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(989), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27646] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(995), 1,
      anon_sym_const,
    STATE(410), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(993), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27673] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(999), 1,
      anon_sym_const,
    STATE(411), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(997), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27700] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(991), 1,
      anon_sym_const,
    STATE(412), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(989), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27727] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1003), 1,
      anon_sym_const,
    STATE(413), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1001), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27754] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1007), 1,
      anon_sym_const,
    STATE(414), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1005), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27781] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1011), 1,
      anon_sym_const,
    STATE(415), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1009), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27808] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1015), 1,
      anon_sym_const,
    STATE(416), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1013), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27835] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1019), 1,
      anon_sym_const,
    STATE(417), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1017), 10,
      ts_builtin_sym_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_struct,
      anon_sym_alias,
      anon_sym_override,
      anon_sym_var,
      anon_sym_const_assert,
      anon_sym_virtual,
      anon_sym_fn,
  [27862] = 11,
    ACTIONS(15), 1,
      anon_sym_diagnostic,
    ACTIONS(17), 1,
      anon_sym_enable,
    ACTIONS(19), 1,
      anon_sym_requires,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(395), 1,
      sym_global_directive,
    STATE(418), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    STATE(389), 3,
      sym_diagnostic_directive,
      sym_enable_directive,
      sym_requires_directive,
  [27900] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(392), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1021), 1,
      sym_template_args_start,
    STATE(419), 1,
      sym_preproc_custom,
    STATE(437), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(394), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [27930] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(384), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1021), 1,
      sym_template_args_start,
    STATE(420), 1,
      sym_preproc_custom,
    STATE(438), 1,
      sym_template_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(386), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [27960] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    ACTIONS(1025), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      sym_attribute,
    STATE(421), 1,
      sym_preproc_custom,
    STATE(463), 1,
      aux_sym_import_repeat1,
    STATE(503), 1,
      sym_param,
    STATE(589), 1,
      sym__ident,
    STATE(592), 1,
      sym_param_list,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [27999] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(422), 1,
      sym_preproc_custom,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(565), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28038] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(423), 1,
      sym_preproc_custom,
    STATE(431), 1,
      aux_sym_import_repeat1,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(558), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28077] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(424), 1,
      sym_preproc_custom,
    STATE(428), 1,
      aux_sym_import_repeat1,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(571), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28116] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(425), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(448), 9,
      sym_template_args_start,
      anon_sym_SEMI,
      anon_sym_COLON_COLON,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [28139] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(426), 1,
      sym_preproc_custom,
    STATE(427), 1,
      aux_sym_import_repeat1,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(555), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28178] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(427), 1,
      sym_preproc_custom,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(549), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28217] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(428), 1,
      sym_preproc_custom,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(551), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28256] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    ACTIONS(1027), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      sym_attribute,
    STATE(429), 1,
      sym_preproc_custom,
    STATE(463), 1,
      aux_sym_import_repeat1,
    STATE(503), 1,
      sym_param,
    STATE(589), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(613), 1,
      sym_param_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28295] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(422), 1,
      aux_sym_import_repeat1,
    STATE(430), 1,
      sym_preproc_custom,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(553), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28334] = 12,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(419), 1,
      sym__ident,
    STATE(431), 1,
      sym_preproc_custom,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(541), 1,
      sym_ident_path,
    STATE(556), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28373] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(432), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(600), 8,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_identifier,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [28395] = 11,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    ACTIONS(1029), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      sym_attribute,
    STATE(433), 1,
      sym_preproc_custom,
    STATE(463), 1,
      aux_sym_import_repeat1,
    STATE(582), 1,
      sym_param,
    STATE(589), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28431] = 11,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1033), 1,
      anon_sym_RBRACE,
    STATE(106), 1,
      sym_attribute,
    STATE(434), 1,
      sym_preproc_custom,
    STATE(462), 1,
      aux_sym_import_repeat1,
    STATE(552), 1,
      sym_struct_member,
    STATE(588), 1,
      sym__member_ident,
    STATE(637), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28467] = 11,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    ACTIONS(1035), 1,
      anon_sym_RPAREN,
    STATE(106), 1,
      sym_attribute,
    STATE(435), 1,
      sym_preproc_custom,
    STATE(463), 1,
      aux_sym_import_repeat1,
    STATE(582), 1,
      sym_param,
    STATE(589), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28503] = 11,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1037), 1,
      anon_sym_RBRACE,
    STATE(106), 1,
      sym_attribute,
    STATE(436), 1,
      sym_preproc_custom,
    STATE(462), 1,
      aux_sym_import_repeat1,
    STATE(552), 1,
      sym_struct_member,
    STATE(588), 1,
      sym__member_ident,
    STATE(637), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28539] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(437), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(386), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [28560] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(438), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(654), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [28581] = 10,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(439), 1,
      sym_preproc_custom,
    STATE(462), 1,
      aux_sym_import_repeat1,
    STATE(520), 1,
      sym_struct_member,
    STATE(588), 1,
      sym__member_ident,
    STATE(637), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28614] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1039), 1,
      anon_sym_RBRACE,
    ACTIONS(1041), 1,
      anon_sym_case,
    ACTIONS(1043), 1,
      anon_sym_default,
    STATE(440), 1,
      sym_preproc_custom,
    STATE(444), 1,
      aux_sym_switch_body_repeat1,
    STATE(529), 1,
      sym_switch_clause,
    STATE(534), 2,
      sym_case_clause,
      sym_default_alone_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28645] = 10,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(441), 1,
      sym_preproc_custom,
    STATE(463), 1,
      aux_sym_import_repeat1,
    STATE(582), 1,
      sym_param,
    STATE(589), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28678] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1041), 1,
      anon_sym_case,
    ACTIONS(1043), 1,
      anon_sym_default,
    ACTIONS(1045), 1,
      anon_sym_RBRACE,
    STATE(442), 1,
      sym_preproc_custom,
    STATE(444), 1,
      aux_sym_switch_body_repeat1,
    STATE(529), 1,
      sym_switch_clause,
    STATE(534), 2,
      sym_case_clause,
      sym_default_alone_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28709] = 10,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(106), 1,
      sym_attribute,
    STATE(443), 1,
      sym_preproc_custom,
    STATE(462), 1,
      aux_sym_import_repeat1,
    STATE(552), 1,
      sym_struct_member,
    STATE(588), 1,
      sym__member_ident,
    STATE(637), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28742] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1047), 1,
      anon_sym_RBRACE,
    ACTIONS(1049), 1,
      anon_sym_case,
    ACTIONS(1052), 1,
      anon_sym_default,
    STATE(529), 1,
      sym_switch_clause,
    STATE(444), 2,
      sym_preproc_custom,
      aux_sym_switch_body_repeat1,
    STATE(534), 2,
      sym_case_clause,
      sym_default_alone_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28771] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(445), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1055), 7,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_AT,
      anon_sym_EQ,
  [28792] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1041), 1,
      anon_sym_case,
    ACTIONS(1043), 1,
      anon_sym_default,
    STATE(440), 1,
      aux_sym_switch_body_repeat1,
    STATE(446), 1,
      sym_preproc_custom,
    STATE(529), 1,
      sym_switch_clause,
    STATE(534), 2,
      sym_case_clause,
      sym_default_alone_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28820] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(447), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(583), 1,
      sym__ident_pattern_token,
    STATE(596), 1,
      sym_type_specifier,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28850] = 9,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    ACTIONS(1059), 1,
      anon_sym_COLON,
    STATE(106), 1,
      sym_attribute,
    STATE(448), 1,
      sym_preproc_custom,
    STATE(486), 1,
      aux_sym_import_repeat1,
    STATE(507), 1,
      sym_compound_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28880] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1061), 1,
      anon_sym_LBRACE,
    STATE(449), 1,
      sym_preproc_custom,
    STATE(466), 1,
      sym__ident_pattern_token,
    STATE(585), 1,
      sym_import_content,
    STATE(511), 2,
      sym_import_item,
      sym_import_collection,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28908] = 9,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    ACTIONS(1063), 1,
      anon_sym_COLON,
    STATE(106), 1,
      sym_attribute,
    STATE(450), 1,
      sym_preproc_custom,
    STATE(486), 1,
      aux_sym_import_repeat1,
    STATE(510), 1,
      sym_compound_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28938] = 9,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1065), 1,
      anon_sym_if,
    STATE(106), 1,
      sym_attribute,
    STATE(150), 1,
      sym_compound_statement,
    STATE(451), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28968] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(452), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(573), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [28998] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1021), 1,
      sym_template_args_start,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(453), 1,
      sym_preproc_custom,
    STATE(490), 1,
      sym_template_list,
    STATE(539), 1,
      sym__ident,
    STATE(548), 1,
      sym__optionally_typed_ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29028] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(454), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(575), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29058] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1067), 1,
      sym_identifier,
    ACTIONS(1069), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__ident_pattern_token,
    STATE(379), 1,
      sym_import_content,
    STATE(455), 1,
      sym_preproc_custom,
    STATE(381), 2,
      sym_import_item,
      sym_import_collection,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29086] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(456), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(578), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29116] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1061), 1,
      anon_sym_LBRACE,
    STATE(457), 1,
      sym_preproc_custom,
    STATE(466), 1,
      sym__ident_pattern_token,
    STATE(641), 1,
      sym_import_content,
    STATE(511), 2,
      sym_import_item,
      sym_import_collection,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29144] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1041), 1,
      anon_sym_case,
    ACTIONS(1043), 1,
      anon_sym_default,
    STATE(442), 1,
      aux_sym_switch_body_repeat1,
    STATE(458), 1,
      sym_preproc_custom,
    STATE(529), 1,
      sym_switch_clause,
    STATE(534), 2,
      sym_case_clause,
      sym_default_alone_clause,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29172] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(459), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(562), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29202] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1061), 1,
      anon_sym_LBRACE,
    STATE(460), 1,
      sym_preproc_custom,
    STATE(466), 1,
      sym__ident_pattern_token,
    STATE(550), 1,
      sym_import_content,
    STATE(511), 2,
      sym_import_item,
      sym_import_collection,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29230] = 9,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(419), 1,
      sym__ident,
    STATE(445), 1,
      sym__template_elaborated_ident,
    STATE(461), 1,
      sym_preproc_custom,
    STATE(541), 1,
      sym_ident_path,
    STATE(566), 1,
      sym_type_specifier,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29260] = 9,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(462), 1,
      sym_preproc_custom,
    STATE(606), 1,
      sym__member_ident,
    STATE(637), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29290] = 9,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(463), 1,
      sym_preproc_custom,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(631), 1,
      sym__ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29320] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    STATE(106), 1,
      sym_attribute,
    STATE(464), 1,
      sym_preproc_custom,
    STATE(486), 1,
      aux_sym_import_repeat1,
    STATE(515), 1,
      sym_compound_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29347] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1071), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      sym_import_path,
    STATE(465), 1,
      sym_preproc_custom,
    STATE(477), 1,
      aux_sym_import_collection_repeat1,
    STATE(594), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29374] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(877), 1,
      anon_sym_COLON_COLON,
    ACTIONS(881), 1,
      sym_identifier,
    ACTIONS(1073), 1,
      anon_sym_as,
    STATE(466), 1,
      sym_preproc_custom,
    ACTIONS(875), 2,
      anon_sym_SEMI,
      anon_sym_RBRACE,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29399] = 8,
    ACTIONS(41), 1,
      sym_identifier,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1075), 1,
      anon_sym_fn,
    STATE(467), 1,
      sym_preproc_custom,
    STATE(539), 1,
      sym__ident,
    STATE(579), 1,
      sym__optionally_typed_ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29426] = 8,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1077), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      sym_import_path,
    STATE(468), 1,
      sym_preproc_custom,
    STATE(477), 1,
      aux_sym_import_collection_repeat1,
    STATE(594), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29453] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(106), 1,
      sym_attribute,
    STATE(155), 1,
      sym_compound_statement,
    STATE(469), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29480] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1081), 1,
      anon_sym_COMMA,
    STATE(470), 1,
      sym_preproc_custom,
    STATE(473), 1,
      aux_sym__case_selectors_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1079), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_COLON,
  [29503] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    STATE(106), 1,
      sym_attribute,
    STATE(471), 1,
      sym_preproc_custom,
    STATE(486), 1,
      aux_sym_import_repeat1,
    STATE(512), 1,
      sym_compound_statement,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29530] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1057), 1,
      anon_sym_LBRACE,
    STATE(106), 1,
      sym_attribute,
    STATE(413), 1,
      sym_compound_statement,
    STATE(472), 1,
      sym_preproc_custom,
    STATE(486), 1,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29557] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1083), 1,
      anon_sym_COMMA,
    STATE(473), 1,
      sym_preproc_custom,
    STATE(474), 1,
      aux_sym__case_selectors_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(222), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_COLON,
  [29580] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1087), 1,
      anon_sym_COMMA,
    STATE(474), 2,
      sym_preproc_custom,
      aux_sym__case_selectors_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1085), 3,
      anon_sym_LBRACE,
      anon_sym_AT,
      anon_sym_COLON,
  [29601] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(106), 1,
      sym_attribute,
    STATE(139), 1,
      sym_compound_statement,
    STATE(475), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29628] = 8,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(45), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(106), 1,
      sym_attribute,
    STATE(142), 1,
      sym_compound_statement,
    STATE(476), 1,
      sym_preproc_custom,
    STATE(497), 1,
      aux_sym_import_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29655] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1090), 1,
      sym_identifier,
    ACTIONS(1093), 1,
      anon_sym_RBRACE,
    STATE(460), 1,
      sym_import_path,
    STATE(594), 1,
      sym__ident_pattern_token,
    STATE(477), 2,
      sym_preproc_custom,
      aux_sym_import_collection_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29680] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(478), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(448), 5,
      anon_sym_SEMI,
      anon_sym_LBRACE,
      anon_sym_LPAREN,
      anon_sym_COLON,
      anon_sym_EQ,
  [29699] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(479), 1,
      sym_preproc_custom,
    STATE(531), 1,
      sym__software_extension_name,
    STATE(560), 1,
      sym__ident_pattern_token,
    STATE(600), 1,
      sym__software_extension_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29723] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(460), 1,
      sym_import_path,
    STATE(468), 1,
      aux_sym_import_collection_repeat1,
    STATE(480), 1,
      sym_preproc_custom,
    STATE(594), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29747] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(481), 1,
      sym_preproc_custom,
    STATE(525), 1,
      sym__ident_pattern_token,
    STATE(526), 1,
      sym__diagnostic_name_token,
    STATE(554), 1,
      sym__diagnostic_rule_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29771] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1095), 1,
      anon_sym_SEMI,
    STATE(482), 1,
      sym_preproc_custom,
    STATE(547), 1,
      sym__ident_pattern_token,
    STATE(577), 1,
      sym__enable_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29795] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1097), 1,
      anon_sym_SEMI,
    STATE(483), 1,
      sym_preproc_custom,
    STATE(560), 1,
      sym__ident_pattern_token,
    STATE(569), 1,
      sym__software_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29819] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(449), 1,
      sym_import_path,
    STATE(484), 1,
      sym_preproc_custom,
    STATE(518), 1,
      sym__ident_pattern_token,
    STATE(616), 1,
      sym_import_item,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29843] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1099), 1,
      anon_sym_SEMI,
    STATE(485), 1,
      sym_preproc_custom,
    STATE(560), 1,
      sym__ident_pattern_token,
    STATE(569), 1,
      sym__software_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29867] = 7,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1101), 1,
      anon_sym_LBRACE,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(486), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29891] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(487), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(722), 4,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_COLON,
  [29909] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1067), 1,
      sym_identifier,
    STATE(378), 1,
      sym__ident_pattern_token,
    STATE(387), 1,
      sym_import_item,
    STATE(455), 1,
      sym_import_path,
    STATE(488), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29933] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(489), 1,
      sym_preproc_custom,
    STATE(523), 1,
      sym__enable_extension_name,
    STATE(547), 1,
      sym__ident_pattern_token,
    STATE(586), 1,
      sym__enable_extension_list,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29957] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(490), 1,
      sym_preproc_custom,
    STATE(539), 1,
      sym__ident,
    STATE(564), 1,
      sym__optionally_typed_ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [29981] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(457), 1,
      sym_import_path,
    STATE(491), 1,
      sym_preproc_custom,
    STATE(518), 1,
      sym__ident_pattern_token,
    STATE(585), 1,
      sym_import_item,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30005] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(492), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1085), 4,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_AT,
      anon_sym_COLON,
  [30023] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(493), 1,
      sym_preproc_custom,
    STATE(539), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(602), 1,
      sym__optionally_typed_ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30047] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1103), 1,
      anon_sym_SEMI,
    STATE(494), 1,
      sym_preproc_custom,
    STATE(547), 1,
      sym__ident_pattern_token,
    STATE(577), 1,
      sym__enable_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30071] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(495), 1,
      sym_preproc_custom,
    STATE(539), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(624), 1,
      sym__optionally_typed_ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30095] = 7,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(716), 1,
      anon_sym_import,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(496), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30119] = 7,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(190), 1,
      anon_sym_LBRACE,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(497), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30143] = 7,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(460), 1,
      sym_import_path,
    STATE(465), 1,
      aux_sym_import_collection_repeat1,
    STATE(498), 1,
      sym_preproc_custom,
    STATE(594), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30167] = 7,
    ACTIONS(21), 1,
      anon_sym_AT,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1105), 1,
      anon_sym_LBRACE,
    STATE(104), 1,
      aux_sym_import_repeat1,
    STATE(106), 1,
      sym_attribute,
    STATE(499), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30191] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(500), 1,
      sym_preproc_custom,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(619), 1,
      sym__ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30212] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1099), 1,
      anon_sym_SEMI,
    ACTIONS(1107), 1,
      anon_sym_COMMA,
    STATE(501), 1,
      sym_preproc_custom,
    STATE(544), 1,
      aux_sym__software_extension_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30233] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1111), 1,
      anon_sym_DASH_GT,
    STATE(502), 1,
      sym_preproc_custom,
    ACTIONS(1109), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30252] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1113), 1,
      anon_sym_COMMA,
    ACTIONS(1115), 1,
      anon_sym_RPAREN,
    STATE(503), 1,
      sym_preproc_custom,
    STATE(542), 1,
      aux_sym_param_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30273] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(504), 1,
      sym_preproc_custom,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(603), 1,
      sym__ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30294] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(505), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(889), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_identifier,
  [30311] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1117), 1,
      anon_sym_COMMA,
    ACTIONS(1120), 1,
      anon_sym_RPAREN,
    STATE(506), 2,
      sym_preproc_custom,
      aux_sym_param_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30330] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(507), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1122), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30347] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1126), 1,
      anon_sym_DASH_GT,
    STATE(508), 1,
      sym_preproc_custom,
    ACTIONS(1124), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30366] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1128), 1,
      anon_sym_COMMA,
    ACTIONS(1131), 1,
      sym_template_args_end,
    STATE(509), 2,
      sym_preproc_custom,
      aux_sym__template_arg_comma_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30385] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(510), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1133), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30402] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(511), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(893), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_identifier,
  [30419] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(512), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1135), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30436] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(513), 1,
      sym_preproc_custom,
    STATE(567), 1,
      sym__ident,
    STATE(595), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30457] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(114), 1,
      sym__ident,
    STATE(514), 1,
      sym_preproc_custom,
    STATE(597), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30478] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(515), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1137), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30495] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1139), 1,
      anon_sym_SEMI,
    ACTIONS(1141), 1,
      anon_sym_COMMA,
    STATE(516), 2,
      sym_preproc_custom,
      aux_sym__enable_extension_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30514] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(748), 1,
      anon_sym_RPAREN,
    ACTIONS(1144), 1,
      anon_sym_COMMA,
    STATE(517), 2,
      sym_preproc_custom,
      aux_sym_argument_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30533] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(875), 1,
      anon_sym_SEMI,
    ACTIONS(883), 1,
      anon_sym_COLON_COLON,
    ACTIONS(1147), 1,
      anon_sym_as,
    STATE(518), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30554] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(519), 1,
      sym_preproc_custom,
    STATE(525), 1,
      sym__ident_pattern_token,
    STATE(559), 1,
      sym__diagnostic_name_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30575] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1149), 1,
      anon_sym_RBRACE,
    ACTIONS(1151), 1,
      anon_sym_COMMA,
    STATE(520), 1,
      sym_preproc_custom,
    STATE(532), 1,
      aux_sym_struct_body_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30596] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(300), 1,
      sym_template_args_end,
    ACTIONS(1153), 1,
      anon_sym_COMMA,
    STATE(509), 1,
      aux_sym__template_arg_comma_list_repeat1,
    STATE(521), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30617] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(312), 1,
      anon_sym_RPAREN,
    ACTIONS(1155), 1,
      anon_sym_COMMA,
    STATE(517), 1,
      aux_sym_argument_list_repeat1,
    STATE(522), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30638] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1157), 1,
      anon_sym_SEMI,
    ACTIONS(1159), 1,
      anon_sym_COMMA,
    STATE(523), 1,
      sym_preproc_custom,
    STATE(537), 1,
      aux_sym__enable_extension_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30659] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(524), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(909), 3,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      sym_identifier,
  [30676] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(525), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1161), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DOT,
  [30693] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1165), 1,
      anon_sym_DOT,
    STATE(526), 1,
      sym_preproc_custom,
    ACTIONS(1163), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30712] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(245), 1,
      sym__ident,
    STATE(527), 1,
      sym_preproc_custom,
    STATE(610), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30733] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(528), 1,
      sym_preproc_custom,
    STATE(547), 1,
      sym__ident_pattern_token,
    STATE(577), 1,
      sym__enable_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30754] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(529), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1167), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30771] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(530), 1,
      sym_preproc_custom,
    STATE(560), 1,
      sym__ident_pattern_token,
    STATE(569), 1,
      sym__software_extension_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30792] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1169), 1,
      anon_sym_SEMI,
    ACTIONS(1171), 1,
      anon_sym_COMMA,
    STATE(501), 1,
      aux_sym__software_extension_list_repeat1,
    STATE(531), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30813] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1033), 1,
      anon_sym_RBRACE,
    ACTIONS(1173), 1,
      anon_sym_COMMA,
    STATE(532), 1,
      sym_preproc_custom,
    STATE(533), 1,
      aux_sym_struct_body_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30834] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1175), 1,
      anon_sym_RBRACE,
    ACTIONS(1177), 1,
      anon_sym_COMMA,
    STATE(533), 2,
      sym_preproc_custom,
      aux_sym_struct_body_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30853] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(534), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
    ACTIONS(1180), 3,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_default,
  [30870] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(196), 1,
      sym__ident,
    STATE(535), 1,
      sym_preproc_custom,
    STATE(618), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30891] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1184), 1,
      anon_sym_DASH_GT,
    STATE(536), 1,
      sym_preproc_custom,
    ACTIONS(1182), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30910] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1103), 1,
      anon_sym_SEMI,
    ACTIONS(1186), 1,
      anon_sym_COMMA,
    STATE(516), 1,
      aux_sym__enable_extension_list_repeat1,
    STATE(537), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30931] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(298), 1,
      sym__ident,
    STATE(538), 1,
      sym_preproc_custom,
    STATE(626), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30952] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1190), 1,
      anon_sym_COLON,
    STATE(539), 1,
      sym_preproc_custom,
    ACTIONS(1188), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30971] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1194), 1,
      anon_sym_DASH_GT,
    STATE(540), 1,
      sym_preproc_custom,
    ACTIONS(1192), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [30990] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(420), 1,
      sym__ident,
    STATE(541), 1,
      sym_preproc_custom,
    STATE(583), 1,
      sym__ident_pattern_token,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31011] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1035), 1,
      anon_sym_RPAREN,
    ACTIONS(1196), 1,
      anon_sym_COMMA,
    STATE(506), 1,
      aux_sym_param_list_repeat1,
    STATE(542), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31032] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1023), 1,
      sym_identifier,
    STATE(543), 1,
      sym_preproc_custom,
    STATE(595), 1,
      sym__ident_pattern_token,
    STATE(632), 1,
      sym__ident,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31053] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1198), 1,
      anon_sym_SEMI,
    ACTIONS(1200), 1,
      anon_sym_COMMA,
    STATE(544), 2,
      sym_preproc_custom,
      aux_sym__software_extension_list_repeat1,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31072] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1203), 1,
      anon_sym_COMMA,
    ACTIONS(1205), 1,
      sym_template_args_end,
    STATE(521), 1,
      aux_sym__template_arg_comma_list_repeat1,
    STATE(545), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31093] = 6,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(546), 1,
      sym_preproc_custom,
    STATE(590), 1,
      sym__ident_pattern_token,
    STATE(593), 1,
      sym__severity_control_name,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31114] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(547), 1,
      sym_preproc_custom,
    ACTIONS(1207), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31130] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(548), 1,
      sym_preproc_custom,
    ACTIONS(1209), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31146] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(549), 1,
      sym_preproc_custom,
    ACTIONS(1211), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31162] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(550), 1,
      sym_preproc_custom,
    ACTIONS(1093), 2,
      anon_sym_RBRACE,
      sym_identifier,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31178] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(551), 1,
      sym_preproc_custom,
    ACTIONS(1213), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31194] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(552), 1,
      sym_preproc_custom,
    ACTIONS(1175), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31210] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(553), 1,
      sym_preproc_custom,
    ACTIONS(1215), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31226] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1217), 1,
      anon_sym_COMMA,
    ACTIONS(1219), 1,
      anon_sym_RPAREN,
    STATE(554), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31244] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(555), 1,
      sym_preproc_custom,
    ACTIONS(1221), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31260] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(556), 1,
      sym_preproc_custom,
    ACTIONS(1223), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31276] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(105), 1,
      sym__ident_pattern_token,
    STATE(557), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31294] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(558), 1,
      sym_preproc_custom,
    ACTIONS(1225), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31310] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(559), 1,
      sym_preproc_custom,
    ACTIONS(1227), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31326] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(560), 1,
      sym_preproc_custom,
    ACTIONS(1229), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31342] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1067), 1,
      sym_identifier,
    STATE(380), 1,
      sym__ident_pattern_token,
    STATE(561), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31360] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(562), 1,
      sym_preproc_custom,
    ACTIONS(1231), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31376] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(563), 1,
      sym_preproc_custom,
    ACTIONS(1233), 2,
      anon_sym_LBRACE,
      sym_identifier,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31392] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(564), 1,
      sym_preproc_custom,
    ACTIONS(1235), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31408] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(565), 1,
      sym_preproc_custom,
    ACTIONS(1237), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31424] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(566), 1,
      sym_preproc_custom,
    ACTIONS(1239), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31440] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1241), 1,
      anon_sym_LBRACE,
    STATE(411), 1,
      sym_struct_body,
    STATE(567), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31458] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1031), 1,
      sym_identifier,
    STATE(505), 1,
      sym__ident_pattern_token,
    STATE(568), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31476] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(569), 1,
      sym_preproc_custom,
    ACTIONS(1198), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31492] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(570), 1,
      sym_preproc_custom,
    ACTIONS(1131), 2,
      sym_template_args_end,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31508] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(571), 1,
      sym_preproc_custom,
    ACTIONS(1243), 2,
      anon_sym_LBRACE,
      anon_sym_AT,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31524] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1245), 1,
      anon_sym_LPAREN,
    STATE(572), 1,
      sym_preproc_custom,
    STATE(584), 1,
      sym__diagnostic_control,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31542] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(573), 1,
      sym_preproc_custom,
    ACTIONS(1247), 2,
      anon_sym_SEMI,
      anon_sym_EQ,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31558] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1249), 1,
      anon_sym_SEMI,
    ACTIONS(1251), 1,
      anon_sym_if,
    STATE(574), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31576] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(575), 1,
      sym_preproc_custom,
    ACTIONS(1253), 2,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31592] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1255), 1,
      anon_sym_SEMI,
    ACTIONS(1257), 1,
      anon_sym_EQ,
    STATE(576), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31610] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(577), 1,
      sym_preproc_custom,
    ACTIONS(1139), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31626] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(578), 1,
      sym_preproc_custom,
    ACTIONS(1259), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31642] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1261), 1,
      anon_sym_SEMI,
    ACTIONS(1263), 1,
      anon_sym_EQ,
    STATE(579), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31660] = 5,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1265), 1,
      anon_sym_SEMI,
    ACTIONS(1267), 1,
      anon_sym_EQ,
    STATE(580), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31678] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(581), 1,
      sym_preproc_custom,
    ACTIONS(1269), 2,
      anon_sym_LBRACE,
      sym_identifier,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31694] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    STATE(582), 1,
      sym_preproc_custom,
    ACTIONS(1120), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31710] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1271), 1,
      sym__disambiguate_template,
    STATE(583), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31725] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1273), 1,
      anon_sym_SEMI,
    STATE(584), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31740] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1275), 1,
      anon_sym_SEMI,
    STATE(585), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31755] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1277), 1,
      anon_sym_SEMI,
    STATE(586), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31770] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1279), 1,
      sym__disambiguate_template,
    STATE(587), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31785] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1281), 1,
      anon_sym_COLON,
    STATE(588), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31800] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1283), 1,
      anon_sym_COLON,
    STATE(589), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31815] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1285), 1,
      anon_sym_COMMA,
    STATE(590), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31830] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1287), 1,
      sym_identifier,
    STATE(591), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31845] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1289), 1,
      anon_sym_RPAREN,
    STATE(592), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31860] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1291), 1,
      anon_sym_COMMA,
    STATE(593), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31875] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(883), 1,
      anon_sym_COLON_COLON,
    STATE(594), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31890] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1293), 1,
      sym__disambiguate_template,
    STATE(595), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31905] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1295), 1,
      anon_sym_SEMI,
    STATE(596), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31920] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1297), 1,
      sym__disambiguate_template,
    STATE(597), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31935] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1299), 1,
      anon_sym_RPAREN,
    STATE(598), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31950] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1301), 1,
      anon_sym_RPAREN,
    STATE(599), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31965] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1303), 1,
      anon_sym_SEMI,
    STATE(600), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31980] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1065), 1,
      anon_sym_if,
    STATE(601), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [31995] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1305), 1,
      anon_sym_EQ,
    STATE(602), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32010] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1307), 1,
      anon_sym_LPAREN,
    STATE(603), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32025] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1309), 1,
      sym_template_args_end,
    STATE(604), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32040] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1311), 1,
      anon_sym_RPAREN,
    STATE(605), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32055] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1313), 1,
      anon_sym_COLON,
    STATE(606), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32070] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1315), 1,
      anon_sym_fn,
    STATE(607), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32085] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1317), 1,
      anon_sym_SEMI,
    STATE(608), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32100] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1319), 1,
      anon_sym_SEMI,
    STATE(609), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32115] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1321), 1,
      sym__disambiguate_template,
    STATE(610), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32130] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1323), 1,
      anon_sym_RPAREN,
    STATE(611), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32145] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1325), 1,
      anon_sym_EQ,
    STATE(612), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32160] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1327), 1,
      anon_sym_RPAREN,
    STATE(613), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32175] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1329), 1,
      sym_template_args_end,
    STATE(614), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32190] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1331), 1,
      anon_sym_RPAREN,
    STATE(615), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32205] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1333), 1,
      anon_sym_SEMI,
    STATE(616), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32220] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1335), 1,
      sym_identifier,
    STATE(617), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32235] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1337), 1,
      sym__disambiguate_template,
    STATE(618), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32250] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1339), 1,
      anon_sym_EQ,
    STATE(619), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32265] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1341), 1,
      anon_sym_SEMI,
    STATE(620), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32280] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1343), 1,
      anon_sym_SEMI,
    STATE(621), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32295] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1345), 1,
      sym_template_args_end,
    STATE(622), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32310] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1347), 1,
      anon_sym_RPAREN,
    STATE(623), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32325] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1349), 1,
      anon_sym_EQ,
    STATE(624), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32340] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1351), 1,
      anon_sym_RPAREN,
    STATE(625), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32355] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1353), 1,
      sym__disambiguate_template,
    STATE(626), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32370] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1355), 1,
      anon_sym_LPAREN,
    STATE(627), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32385] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1357), 1,
      sym_template_args_end,
    STATE(628), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32400] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1359), 1,
      anon_sym_RPAREN,
    STATE(629), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32415] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1361), 1,
      anon_sym_RPAREN,
    STATE(630), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32430] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1363), 1,
      anon_sym_COLON,
    STATE(631), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32445] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1365), 1,
      anon_sym_LPAREN,
    STATE(632), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32460] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1367), 1,
      anon_sym_RPAREN,
    STATE(633), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32475] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1369), 1,
      sym_template_args_end,
    STATE(634), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32490] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1371), 1,
      anon_sym_RPAREN,
    STATE(635), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32505] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1373), 1,
      anon_sym_SEMI,
    STATE(636), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32520] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(650), 1,
      anon_sym_COLON,
    STATE(637), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32535] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1375), 1,
      anon_sym_SEMI,
    STATE(638), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32550] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1377), 1,
      anon_sym_SEMI,
    STATE(639), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32565] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1379), 1,
      anon_sym_RPAREN,
    STATE(640), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32580] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1381), 1,
      anon_sym_SEMI,
    STATE(641), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32595] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(226), 1,
      sym__disambiguate_template,
    STATE(642), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32610] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1383), 1,
      anon_sym_SEMI,
    STATE(643), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32625] = 4,
    ACTIONS(95), 1,
      sym_preproc_directive,
    ACTIONS(1385), 1,
      ts_builtin_sym_end,
    STATE(644), 1,
      sym_preproc_custom,
    ACTIONS(5), 3,
      sym_block_comment,
      sym_line_comment,
      sym__blankspace,
  [32640] = 1,
    ACTIONS(1387), 1,
      ts_builtin_sym_end,
  [32644] = 1,
    ACTIONS(1389), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(13)] = 0,
  [SMALL_STATE(14)] = 142,
  [SMALL_STATE(15)] = 284,
  [SMALL_STATE(16)] = 426,
  [SMALL_STATE(17)] = 568,
  [SMALL_STATE(18)] = 703,
  [SMALL_STATE(19)] = 838,
  [SMALL_STATE(20)] = 908,
  [SMALL_STATE(21)] = 1041,
  [SMALL_STATE(22)] = 1171,
  [SMALL_STATE(23)] = 1303,
  [SMALL_STATE(24)] = 1433,
  [SMALL_STATE(25)] = 1563,
  [SMALL_STATE(26)] = 1693,
  [SMALL_STATE(27)] = 1823,
  [SMALL_STATE(28)] = 1953,
  [SMALL_STATE(29)] = 2083,
  [SMALL_STATE(30)] = 2213,
  [SMALL_STATE(31)] = 2343,
  [SMALL_STATE(32)] = 2475,
  [SMALL_STATE(33)] = 2605,
  [SMALL_STATE(34)] = 2735,
  [SMALL_STATE(35)] = 2865,
  [SMALL_STATE(36)] = 2995,
  [SMALL_STATE(37)] = 3122,
  [SMALL_STATE(38)] = 3249,
  [SMALL_STATE(39)] = 3376,
  [SMALL_STATE(40)] = 3503,
  [SMALL_STATE(41)] = 3630,
  [SMALL_STATE(42)] = 3757,
  [SMALL_STATE(43)] = 3881,
  [SMALL_STATE(44)] = 4005,
  [SMALL_STATE(45)] = 4129,
  [SMALL_STATE(46)] = 4253,
  [SMALL_STATE(47)] = 4377,
  [SMALL_STATE(48)] = 4501,
  [SMALL_STATE(49)] = 4625,
  [SMALL_STATE(50)] = 4749,
  [SMALL_STATE(51)] = 4873,
  [SMALL_STATE(52)] = 4997,
  [SMALL_STATE(53)] = 5121,
  [SMALL_STATE(54)] = 5245,
  [SMALL_STATE(55)] = 5369,
  [SMALL_STATE(56)] = 5493,
  [SMALL_STATE(57)] = 5617,
  [SMALL_STATE(58)] = 5741,
  [SMALL_STATE(59)] = 5865,
  [SMALL_STATE(60)] = 5989,
  [SMALL_STATE(61)] = 6113,
  [SMALL_STATE(62)] = 6235,
  [SMALL_STATE(63)] = 6359,
  [SMALL_STATE(64)] = 6483,
  [SMALL_STATE(65)] = 6605,
  [SMALL_STATE(66)] = 6729,
  [SMALL_STATE(67)] = 6853,
  [SMALL_STATE(68)] = 6977,
  [SMALL_STATE(69)] = 7101,
  [SMALL_STATE(70)] = 7225,
  [SMALL_STATE(71)] = 7349,
  [SMALL_STATE(72)] = 7473,
  [SMALL_STATE(73)] = 7597,
  [SMALL_STATE(74)] = 7721,
  [SMALL_STATE(75)] = 7843,
  [SMALL_STATE(76)] = 7967,
  [SMALL_STATE(77)] = 8091,
  [SMALL_STATE(78)] = 8215,
  [SMALL_STATE(79)] = 8339,
  [SMALL_STATE(80)] = 8463,
  [SMALL_STATE(81)] = 8587,
  [SMALL_STATE(82)] = 8711,
  [SMALL_STATE(83)] = 8835,
  [SMALL_STATE(84)] = 8959,
  [SMALL_STATE(85)] = 9081,
  [SMALL_STATE(86)] = 9205,
  [SMALL_STATE(87)] = 9329,
  [SMALL_STATE(88)] = 9453,
  [SMALL_STATE(89)] = 9577,
  [SMALL_STATE(90)] = 9701,
  [SMALL_STATE(91)] = 9825,
  [SMALL_STATE(92)] = 9949,
  [SMALL_STATE(93)] = 10073,
  [SMALL_STATE(94)] = 10197,
  [SMALL_STATE(95)] = 10321,
  [SMALL_STATE(96)] = 10445,
  [SMALL_STATE(97)] = 10569,
  [SMALL_STATE(98)] = 10693,
  [SMALL_STATE(99)] = 10817,
  [SMALL_STATE(100)] = 10941,
  [SMALL_STATE(101)] = 11065,
  [SMALL_STATE(102)] = 11189,
  [SMALL_STATE(103)] = 11313,
  [SMALL_STATE(104)] = 11437,
  [SMALL_STATE(105)] = 11506,
  [SMALL_STATE(106)] = 11574,
  [SMALL_STATE(107)] = 11637,
  [SMALL_STATE(108)] = 11700,
  [SMALL_STATE(109)] = 11763,
  [SMALL_STATE(110)] = 11826,
  [SMALL_STATE(111)] = 11893,
  [SMALL_STATE(112)] = 11960,
  [SMALL_STATE(113)] = 12022,
  [SMALL_STATE(114)] = 12101,
  [SMALL_STATE(115)] = 12166,
  [SMALL_STATE(116)] = 12231,
  [SMALL_STATE(117)] = 12308,
  [SMALL_STATE(118)] = 12397,
  [SMALL_STATE(119)] = 12472,
  [SMALL_STATE(120)] = 12545,
  [SMALL_STATE(121)] = 12614,
  [SMALL_STATE(122)] = 12699,
  [SMALL_STATE(123)] = 12786,
  [SMALL_STATE(124)] = 12869,
  [SMALL_STATE(125)] = 12938,
  [SMALL_STATE(126)] = 13019,
  [SMALL_STATE(127)] = 13077,
  [SMALL_STATE(128)] = 13133,
  [SMALL_STATE(129)] = 13189,
  [SMALL_STATE(130)] = 13245,
  [SMALL_STATE(131)] = 13301,
  [SMALL_STATE(132)] = 13357,
  [SMALL_STATE(133)] = 13413,
  [SMALL_STATE(134)] = 13469,
  [SMALL_STATE(135)] = 13525,
  [SMALL_STATE(136)] = 13581,
  [SMALL_STATE(137)] = 13637,
  [SMALL_STATE(138)] = 13693,
  [SMALL_STATE(139)] = 13748,
  [SMALL_STATE(140)] = 13803,
  [SMALL_STATE(141)] = 13858,
  [SMALL_STATE(142)] = 13913,
  [SMALL_STATE(143)] = 13968,
  [SMALL_STATE(144)] = 14023,
  [SMALL_STATE(145)] = 14078,
  [SMALL_STATE(146)] = 14133,
  [SMALL_STATE(147)] = 14188,
  [SMALL_STATE(148)] = 14243,
  [SMALL_STATE(149)] = 14298,
  [SMALL_STATE(150)] = 14353,
  [SMALL_STATE(151)] = 14408,
  [SMALL_STATE(152)] = 14463,
  [SMALL_STATE(153)] = 14518,
  [SMALL_STATE(154)] = 14573,
  [SMALL_STATE(155)] = 14628,
  [SMALL_STATE(156)] = 14683,
  [SMALL_STATE(157)] = 14738,
  [SMALL_STATE(158)] = 14797,
  [SMALL_STATE(159)] = 14852,
  [SMALL_STATE(160)] = 14907,
  [SMALL_STATE(161)] = 14962,
  [SMALL_STATE(162)] = 15017,
  [SMALL_STATE(163)] = 15072,
  [SMALL_STATE(164)] = 15128,
  [SMALL_STATE(165)] = 15184,
  [SMALL_STATE(166)] = 15240,
  [SMALL_STATE(167)] = 15296,
  [SMALL_STATE(168)] = 15352,
  [SMALL_STATE(169)] = 15408,
  [SMALL_STATE(170)] = 15464,
  [SMALL_STATE(171)] = 15520,
  [SMALL_STATE(172)] = 15576,
  [SMALL_STATE(173)] = 15632,
  [SMALL_STATE(174)] = 15688,
  [SMALL_STATE(175)] = 15744,
  [SMALL_STATE(176)] = 15800,
  [SMALL_STATE(177)] = 15856,
  [SMALL_STATE(178)] = 15912,
  [SMALL_STATE(179)] = 16022,
  [SMALL_STATE(180)] = 16078,
  [SMALL_STATE(181)] = 16134,
  [SMALL_STATE(182)] = 16190,
  [SMALL_STATE(183)] = 16246,
  [SMALL_STATE(184)] = 16302,
  [SMALL_STATE(185)] = 16358,
  [SMALL_STATE(186)] = 16414,
  [SMALL_STATE(187)] = 16470,
  [SMALL_STATE(188)] = 16526,
  [SMALL_STATE(189)] = 16582,
  [SMALL_STATE(190)] = 16638,
  [SMALL_STATE(191)] = 16694,
  [SMALL_STATE(192)] = 16750,
  [SMALL_STATE(193)] = 16806,
  [SMALL_STATE(194)] = 16862,
  [SMALL_STATE(195)] = 16918,
  [SMALL_STATE(196)] = 16977,
  [SMALL_STATE(197)] = 17036,
  [SMALL_STATE(198)] = 17123,
  [SMALL_STATE(199)] = 17201,
  [SMALL_STATE(200)] = 17277,
  [SMALL_STATE(201)] = 17351,
  [SMALL_STATE(202)] = 17423,
  [SMALL_STATE(203)] = 17493,
  [SMALL_STATE(204)] = 17561,
  [SMALL_STATE(205)] = 17625,
  [SMALL_STATE(206)] = 17687,
  [SMALL_STATE(207)] = 17749,
  [SMALL_STATE(208)] = 17801,
  [SMALL_STATE(209)] = 17867,
  [SMALL_STATE(210)] = 17922,
  [SMALL_STATE(211)] = 17972,
  [SMALL_STATE(212)] = 18024,
  [SMALL_STATE(213)] = 18074,
  [SMALL_STATE(214)] = 18124,
  [SMALL_STATE(215)] = 18174,
  [SMALL_STATE(216)] = 18224,
  [SMALL_STATE(217)] = 18274,
  [SMALL_STATE(218)] = 18323,
  [SMALL_STATE(219)] = 18372,
  [SMALL_STATE(220)] = 18421,
  [SMALL_STATE(221)] = 18470,
  [SMALL_STATE(222)] = 18519,
  [SMALL_STATE(223)] = 18568,
  [SMALL_STATE(224)] = 18617,
  [SMALL_STATE(225)] = 18666,
  [SMALL_STATE(226)] = 18715,
  [SMALL_STATE(227)] = 18764,
  [SMALL_STATE(228)] = 18861,
  [SMALL_STATE(229)] = 18910,
  [SMALL_STATE(230)] = 18959,
  [SMALL_STATE(231)] = 19008,
  [SMALL_STATE(232)] = 19057,
  [SMALL_STATE(233)] = 19106,
  [SMALL_STATE(234)] = 19155,
  [SMALL_STATE(235)] = 19204,
  [SMALL_STATE(236)] = 19253,
  [SMALL_STATE(237)] = 19302,
  [SMALL_STATE(238)] = 19351,
  [SMALL_STATE(239)] = 19448,
  [SMALL_STATE(240)] = 19497,
  [SMALL_STATE(241)] = 19546,
  [SMALL_STATE(242)] = 19595,
  [SMALL_STATE(243)] = 19644,
  [SMALL_STATE(244)] = 19693,
  [SMALL_STATE(245)] = 19746,
  [SMALL_STATE(246)] = 19799,
  [SMALL_STATE(247)] = 19855,
  [SMALL_STATE(248)] = 19925,
  [SMALL_STATE(249)] = 19989,
  [SMALL_STATE(250)] = 20035,
  [SMALL_STATE(251)] = 20103,
  [SMALL_STATE(252)] = 20169,
  [SMALL_STATE(253)] = 20229,
  [SMALL_STATE(254)] = 20285,
  [SMALL_STATE(255)] = 20355,
  [SMALL_STATE(256)] = 20427,
  [SMALL_STATE(257)] = 20489,
  [SMALL_STATE(258)] = 20538,
  [SMALL_STATE(259)] = 20623,
  [SMALL_STATE(260)] = 20703,
  [SMALL_STATE(261)] = 20785,
  [SMALL_STATE(262)] = 20829,
  [SMALL_STATE(263)] = 20909,
  [SMALL_STATE(264)] = 20989,
  [SMALL_STATE(265)] = 21069,
  [SMALL_STATE(266)] = 21113,
  [SMALL_STATE(267)] = 21157,
  [SMALL_STATE(268)] = 21200,
  [SMALL_STATE(269)] = 21243,
  [SMALL_STATE(270)] = 21286,
  [SMALL_STATE(271)] = 21329,
  [SMALL_STATE(272)] = 21372,
  [SMALL_STATE(273)] = 21415,
  [SMALL_STATE(274)] = 21458,
  [SMALL_STATE(275)] = 21501,
  [SMALL_STATE(276)] = 21544,
  [SMALL_STATE(277)] = 21587,
  [SMALL_STATE(278)] = 21630,
  [SMALL_STATE(279)] = 21673,
  [SMALL_STATE(280)] = 21716,
  [SMALL_STATE(281)] = 21759,
  [SMALL_STATE(282)] = 21802,
  [SMALL_STATE(283)] = 21845,
  [SMALL_STATE(284)] = 21888,
  [SMALL_STATE(285)] = 21931,
  [SMALL_STATE(286)] = 21974,
  [SMALL_STATE(287)] = 22017,
  [SMALL_STATE(288)] = 22088,
  [SMALL_STATE(289)] = 22131,
  [SMALL_STATE(290)] = 22174,
  [SMALL_STATE(291)] = 22217,
  [SMALL_STATE(292)] = 22260,
  [SMALL_STATE(293)] = 22303,
  [SMALL_STATE(294)] = 22346,
  [SMALL_STATE(295)] = 22389,
  [SMALL_STATE(296)] = 22432,
  [SMALL_STATE(297)] = 22506,
  [SMALL_STATE(298)] = 22554,
  [SMALL_STATE(299)] = 22602,
  [SMALL_STATE(300)] = 22667,
  [SMALL_STATE(301)] = 22730,
  [SMALL_STATE(302)] = 22789,
  [SMALL_STATE(303)] = 22844,
  [SMALL_STATE(304)] = 22895,
  [SMALL_STATE(305)] = 22956,
  [SMALL_STATE(306)] = 23025,
  [SMALL_STATE(307)] = 23094,
  [SMALL_STATE(308)] = 23135,
  [SMALL_STATE(309)] = 23186,
  [SMALL_STATE(310)] = 23251,
  [SMALL_STATE(311)] = 23308,
  [SMALL_STATE(312)] = 23375,
  [SMALL_STATE(313)] = 23443,
  [SMALL_STATE(314)] = 23511,
  [SMALL_STATE(315)] = 23579,
  [SMALL_STATE(316)] = 23653,
  [SMALL_STATE(317)] = 23721,
  [SMALL_STATE(318)] = 23789,
  [SMALL_STATE(319)] = 23863,
  [SMALL_STATE(320)] = 23931,
  [SMALL_STATE(321)] = 23999,
  [SMALL_STATE(322)] = 24067,
  [SMALL_STATE(323)] = 24139,
  [SMALL_STATE(324)] = 24183,
  [SMALL_STATE(325)] = 24251,
  [SMALL_STATE(326)] = 24319,
  [SMALL_STATE(327)] = 24393,
  [SMALL_STATE(328)] = 24461,
  [SMALL_STATE(329)] = 24529,
  [SMALL_STATE(330)] = 24597,
  [SMALL_STATE(331)] = 24665,
  [SMALL_STATE(332)] = 24733,
  [SMALL_STATE(333)] = 24801,
  [SMALL_STATE(334)] = 24869,
  [SMALL_STATE(335)] = 24937,
  [SMALL_STATE(336)] = 25005,
  [SMALL_STATE(337)] = 25073,
  [SMALL_STATE(338)] = 25112,
  [SMALL_STATE(339)] = 25151,
  [SMALL_STATE(340)] = 25190,
  [SMALL_STATE(341)] = 25228,
  [SMALL_STATE(342)] = 25266,
  [SMALL_STATE(343)] = 25304,
  [SMALL_STATE(344)] = 25342,
  [SMALL_STATE(345)] = 25380,
  [SMALL_STATE(346)] = 25418,
  [SMALL_STATE(347)] = 25456,
  [SMALL_STATE(348)] = 25494,
  [SMALL_STATE(349)] = 25532,
  [SMALL_STATE(350)] = 25570,
  [SMALL_STATE(351)] = 25608,
  [SMALL_STATE(352)] = 25646,
  [SMALL_STATE(353)] = 25684,
  [SMALL_STATE(354)] = 25722,
  [SMALL_STATE(355)] = 25760,
  [SMALL_STATE(356)] = 25798,
  [SMALL_STATE(357)] = 25836,
  [SMALL_STATE(358)] = 25874,
  [SMALL_STATE(359)] = 25930,
  [SMALL_STATE(360)] = 25968,
  [SMALL_STATE(361)] = 26006,
  [SMALL_STATE(362)] = 26044,
  [SMALL_STATE(363)] = 26082,
  [SMALL_STATE(364)] = 26120,
  [SMALL_STATE(365)] = 26158,
  [SMALL_STATE(366)] = 26196,
  [SMALL_STATE(367)] = 26234,
  [SMALL_STATE(368)] = 26272,
  [SMALL_STATE(369)] = 26310,
  [SMALL_STATE(370)] = 26359,
  [SMALL_STATE(371)] = 26424,
  [SMALL_STATE(372)] = 26460,
  [SMALL_STATE(373)] = 26496,
  [SMALL_STATE(374)] = 26532,
  [SMALL_STATE(375)] = 26568,
  [SMALL_STATE(376)] = 26604,
  [SMALL_STATE(377)] = 26638,
  [SMALL_STATE(378)] = 26676,
  [SMALL_STATE(379)] = 26714,
  [SMALL_STATE(380)] = 26746,
  [SMALL_STATE(381)] = 26778,
  [SMALL_STATE(382)] = 26810,
  [SMALL_STATE(383)] = 26842,
  [SMALL_STATE(384)] = 26874,
  [SMALL_STATE(385)] = 26906,
  [SMALL_STATE(386)] = 26938,
  [SMALL_STATE(387)] = 26970,
  [SMALL_STATE(388)] = 27002,
  [SMALL_STATE(389)] = 27032,
  [SMALL_STATE(390)] = 27062,
  [SMALL_STATE(391)] = 27092,
  [SMALL_STATE(392)] = 27122,
  [SMALL_STATE(393)] = 27152,
  [SMALL_STATE(394)] = 27182,
  [SMALL_STATE(395)] = 27212,
  [SMALL_STATE(396)] = 27242,
  [SMALL_STATE(397)] = 27272,
  [SMALL_STATE(398)] = 27302,
  [SMALL_STATE(399)] = 27334,
  [SMALL_STATE(400)] = 27366,
  [SMALL_STATE(401)] = 27398,
  [SMALL_STATE(402)] = 27430,
  [SMALL_STATE(403)] = 27457,
  [SMALL_STATE(404)] = 27484,
  [SMALL_STATE(405)] = 27511,
  [SMALL_STATE(406)] = 27538,
  [SMALL_STATE(407)] = 27565,
  [SMALL_STATE(408)] = 27592,
  [SMALL_STATE(409)] = 27619,
  [SMALL_STATE(410)] = 27646,
  [SMALL_STATE(411)] = 27673,
  [SMALL_STATE(412)] = 27700,
  [SMALL_STATE(413)] = 27727,
  [SMALL_STATE(414)] = 27754,
  [SMALL_STATE(415)] = 27781,
  [SMALL_STATE(416)] = 27808,
  [SMALL_STATE(417)] = 27835,
  [SMALL_STATE(418)] = 27862,
  [SMALL_STATE(419)] = 27900,
  [SMALL_STATE(420)] = 27930,
  [SMALL_STATE(421)] = 27960,
  [SMALL_STATE(422)] = 27999,
  [SMALL_STATE(423)] = 28038,
  [SMALL_STATE(424)] = 28077,
  [SMALL_STATE(425)] = 28116,
  [SMALL_STATE(426)] = 28139,
  [SMALL_STATE(427)] = 28178,
  [SMALL_STATE(428)] = 28217,
  [SMALL_STATE(429)] = 28256,
  [SMALL_STATE(430)] = 28295,
  [SMALL_STATE(431)] = 28334,
  [SMALL_STATE(432)] = 28373,
  [SMALL_STATE(433)] = 28395,
  [SMALL_STATE(434)] = 28431,
  [SMALL_STATE(435)] = 28467,
  [SMALL_STATE(436)] = 28503,
  [SMALL_STATE(437)] = 28539,
  [SMALL_STATE(438)] = 28560,
  [SMALL_STATE(439)] = 28581,
  [SMALL_STATE(440)] = 28614,
  [SMALL_STATE(441)] = 28645,
  [SMALL_STATE(442)] = 28678,
  [SMALL_STATE(443)] = 28709,
  [SMALL_STATE(444)] = 28742,
  [SMALL_STATE(445)] = 28771,
  [SMALL_STATE(446)] = 28792,
  [SMALL_STATE(447)] = 28820,
  [SMALL_STATE(448)] = 28850,
  [SMALL_STATE(449)] = 28880,
  [SMALL_STATE(450)] = 28908,
  [SMALL_STATE(451)] = 28938,
  [SMALL_STATE(452)] = 28968,
  [SMALL_STATE(453)] = 28998,
  [SMALL_STATE(454)] = 29028,
  [SMALL_STATE(455)] = 29058,
  [SMALL_STATE(456)] = 29086,
  [SMALL_STATE(457)] = 29116,
  [SMALL_STATE(458)] = 29144,
  [SMALL_STATE(459)] = 29172,
  [SMALL_STATE(460)] = 29202,
  [SMALL_STATE(461)] = 29230,
  [SMALL_STATE(462)] = 29260,
  [SMALL_STATE(463)] = 29290,
  [SMALL_STATE(464)] = 29320,
  [SMALL_STATE(465)] = 29347,
  [SMALL_STATE(466)] = 29374,
  [SMALL_STATE(467)] = 29399,
  [SMALL_STATE(468)] = 29426,
  [SMALL_STATE(469)] = 29453,
  [SMALL_STATE(470)] = 29480,
  [SMALL_STATE(471)] = 29503,
  [SMALL_STATE(472)] = 29530,
  [SMALL_STATE(473)] = 29557,
  [SMALL_STATE(474)] = 29580,
  [SMALL_STATE(475)] = 29601,
  [SMALL_STATE(476)] = 29628,
  [SMALL_STATE(477)] = 29655,
  [SMALL_STATE(478)] = 29680,
  [SMALL_STATE(479)] = 29699,
  [SMALL_STATE(480)] = 29723,
  [SMALL_STATE(481)] = 29747,
  [SMALL_STATE(482)] = 29771,
  [SMALL_STATE(483)] = 29795,
  [SMALL_STATE(484)] = 29819,
  [SMALL_STATE(485)] = 29843,
  [SMALL_STATE(486)] = 29867,
  [SMALL_STATE(487)] = 29891,
  [SMALL_STATE(488)] = 29909,
  [SMALL_STATE(489)] = 29933,
  [SMALL_STATE(490)] = 29957,
  [SMALL_STATE(491)] = 29981,
  [SMALL_STATE(492)] = 30005,
  [SMALL_STATE(493)] = 30023,
  [SMALL_STATE(494)] = 30047,
  [SMALL_STATE(495)] = 30071,
  [SMALL_STATE(496)] = 30095,
  [SMALL_STATE(497)] = 30119,
  [SMALL_STATE(498)] = 30143,
  [SMALL_STATE(499)] = 30167,
  [SMALL_STATE(500)] = 30191,
  [SMALL_STATE(501)] = 30212,
  [SMALL_STATE(502)] = 30233,
  [SMALL_STATE(503)] = 30252,
  [SMALL_STATE(504)] = 30273,
  [SMALL_STATE(505)] = 30294,
  [SMALL_STATE(506)] = 30311,
  [SMALL_STATE(507)] = 30330,
  [SMALL_STATE(508)] = 30347,
  [SMALL_STATE(509)] = 30366,
  [SMALL_STATE(510)] = 30385,
  [SMALL_STATE(511)] = 30402,
  [SMALL_STATE(512)] = 30419,
  [SMALL_STATE(513)] = 30436,
  [SMALL_STATE(514)] = 30457,
  [SMALL_STATE(515)] = 30478,
  [SMALL_STATE(516)] = 30495,
  [SMALL_STATE(517)] = 30514,
  [SMALL_STATE(518)] = 30533,
  [SMALL_STATE(519)] = 30554,
  [SMALL_STATE(520)] = 30575,
  [SMALL_STATE(521)] = 30596,
  [SMALL_STATE(522)] = 30617,
  [SMALL_STATE(523)] = 30638,
  [SMALL_STATE(524)] = 30659,
  [SMALL_STATE(525)] = 30676,
  [SMALL_STATE(526)] = 30693,
  [SMALL_STATE(527)] = 30712,
  [SMALL_STATE(528)] = 30733,
  [SMALL_STATE(529)] = 30754,
  [SMALL_STATE(530)] = 30771,
  [SMALL_STATE(531)] = 30792,
  [SMALL_STATE(532)] = 30813,
  [SMALL_STATE(533)] = 30834,
  [SMALL_STATE(534)] = 30853,
  [SMALL_STATE(535)] = 30870,
  [SMALL_STATE(536)] = 30891,
  [SMALL_STATE(537)] = 30910,
  [SMALL_STATE(538)] = 30931,
  [SMALL_STATE(539)] = 30952,
  [SMALL_STATE(540)] = 30971,
  [SMALL_STATE(541)] = 30990,
  [SMALL_STATE(542)] = 31011,
  [SMALL_STATE(543)] = 31032,
  [SMALL_STATE(544)] = 31053,
  [SMALL_STATE(545)] = 31072,
  [SMALL_STATE(546)] = 31093,
  [SMALL_STATE(547)] = 31114,
  [SMALL_STATE(548)] = 31130,
  [SMALL_STATE(549)] = 31146,
  [SMALL_STATE(550)] = 31162,
  [SMALL_STATE(551)] = 31178,
  [SMALL_STATE(552)] = 31194,
  [SMALL_STATE(553)] = 31210,
  [SMALL_STATE(554)] = 31226,
  [SMALL_STATE(555)] = 31244,
  [SMALL_STATE(556)] = 31260,
  [SMALL_STATE(557)] = 31276,
  [SMALL_STATE(558)] = 31294,
  [SMALL_STATE(559)] = 31310,
  [SMALL_STATE(560)] = 31326,
  [SMALL_STATE(561)] = 31342,
  [SMALL_STATE(562)] = 31360,
  [SMALL_STATE(563)] = 31376,
  [SMALL_STATE(564)] = 31392,
  [SMALL_STATE(565)] = 31408,
  [SMALL_STATE(566)] = 31424,
  [SMALL_STATE(567)] = 31440,
  [SMALL_STATE(568)] = 31458,
  [SMALL_STATE(569)] = 31476,
  [SMALL_STATE(570)] = 31492,
  [SMALL_STATE(571)] = 31508,
  [SMALL_STATE(572)] = 31524,
  [SMALL_STATE(573)] = 31542,
  [SMALL_STATE(574)] = 31558,
  [SMALL_STATE(575)] = 31576,
  [SMALL_STATE(576)] = 31592,
  [SMALL_STATE(577)] = 31610,
  [SMALL_STATE(578)] = 31626,
  [SMALL_STATE(579)] = 31642,
  [SMALL_STATE(580)] = 31660,
  [SMALL_STATE(581)] = 31678,
  [SMALL_STATE(582)] = 31694,
  [SMALL_STATE(583)] = 31710,
  [SMALL_STATE(584)] = 31725,
  [SMALL_STATE(585)] = 31740,
  [SMALL_STATE(586)] = 31755,
  [SMALL_STATE(587)] = 31770,
  [SMALL_STATE(588)] = 31785,
  [SMALL_STATE(589)] = 31800,
  [SMALL_STATE(590)] = 31815,
  [SMALL_STATE(591)] = 31830,
  [SMALL_STATE(592)] = 31845,
  [SMALL_STATE(593)] = 31860,
  [SMALL_STATE(594)] = 31875,
  [SMALL_STATE(595)] = 31890,
  [SMALL_STATE(596)] = 31905,
  [SMALL_STATE(597)] = 31920,
  [SMALL_STATE(598)] = 31935,
  [SMALL_STATE(599)] = 31950,
  [SMALL_STATE(600)] = 31965,
  [SMALL_STATE(601)] = 31980,
  [SMALL_STATE(602)] = 31995,
  [SMALL_STATE(603)] = 32010,
  [SMALL_STATE(604)] = 32025,
  [SMALL_STATE(605)] = 32040,
  [SMALL_STATE(606)] = 32055,
  [SMALL_STATE(607)] = 32070,
  [SMALL_STATE(608)] = 32085,
  [SMALL_STATE(609)] = 32100,
  [SMALL_STATE(610)] = 32115,
  [SMALL_STATE(611)] = 32130,
  [SMALL_STATE(612)] = 32145,
  [SMALL_STATE(613)] = 32160,
  [SMALL_STATE(614)] = 32175,
  [SMALL_STATE(615)] = 32190,
  [SMALL_STATE(616)] = 32205,
  [SMALL_STATE(617)] = 32220,
  [SMALL_STATE(618)] = 32235,
  [SMALL_STATE(619)] = 32250,
  [SMALL_STATE(620)] = 32265,
  [SMALL_STATE(621)] = 32280,
  [SMALL_STATE(622)] = 32295,
  [SMALL_STATE(623)] = 32310,
  [SMALL_STATE(624)] = 32325,
  [SMALL_STATE(625)] = 32340,
  [SMALL_STATE(626)] = 32355,
  [SMALL_STATE(627)] = 32370,
  [SMALL_STATE(628)] = 32385,
  [SMALL_STATE(629)] = 32400,
  [SMALL_STATE(630)] = 32415,
  [SMALL_STATE(631)] = 32430,
  [SMALL_STATE(632)] = 32445,
  [SMALL_STATE(633)] = 32460,
  [SMALL_STATE(634)] = 32475,
  [SMALL_STATE(635)] = 32490,
  [SMALL_STATE(636)] = 32505,
  [SMALL_STATE(637)] = 32520,
  [SMALL_STATE(638)] = 32535,
  [SMALL_STATE(639)] = 32550,
  [SMALL_STATE(640)] = 32565,
  [SMALL_STATE(641)] = 32580,
  [SMALL_STATE(642)] = 32595,
  [SMALL_STATE(643)] = 32610,
  [SMALL_STATE(644)] = 32625,
  [SMALL_STATE(645)] = 32640,
  [SMALL_STATE(646)] = 32644,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = false}}, SHIFT(31),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 0, 0, 0),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [23] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(495),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [37] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(642),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [49] = {.entry = {.count = 1, .reusable = false}}, SHIFT(219),
  [51] = {.entry = {.count = 1, .reusable = false}}, SHIFT(220),
  [53] = {.entry = {.count = 1, .reusable = false}}, SHIFT(221),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [57] = {.entry = {.count = 1, .reusable = false}}, SHIFT(222),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(223),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(493),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(587),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(612),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(40),
  [75] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [77] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(627),
  [83] = {.entry = {.count = 1, .reusable = false}}, SHIFT(475),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [89] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [91] = {.entry = {.count = 1, .reusable = false}}, SHIFT(476),
  [93] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [101] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(642),
  [104] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(159),
  [107] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(8),
  [110] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0),
  [112] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(219),
  [115] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(220),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(221),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(222),
  [124] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(222),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [130] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [133] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(101),
  [136] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(557),
  [139] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(493),
  [142] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(587),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(373),
  [148] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(612),
  [151] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(40),
  [154] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(94),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(95),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(627),
  [166] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(475),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(96),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(574),
  [175] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(636),
  [178] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(476),
  [181] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(639),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 2, 0, 0),
  [196] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3, 0, 33),
  [198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3, 0, 35),
  [200] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4, 0, 43),
  [202] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_selectors, 3, 0, 0),
  [204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(286),
  [206] = {.entry = {.count = 1, .reusable = false}}, SHIFT(293),
  [208] = {.entry = {.count = 1, .reusable = false}}, SHIFT(284),
  [210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [212] = {.entry = {.count = 1, .reusable = false}}, SHIFT(277),
  [214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [216] = {.entry = {.count = 1, .reusable = false}}, SHIFT(279),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [220] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [222] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_selectors, 2, 0, 0),
  [224] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ident_pattern_token, 1, 0, 0),
  [226] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ident_pattern_token, 1, 0, 0),
  [228] = {.entry = {.count = 1, .reusable = false}}, SHIFT(341),
  [230] = {.entry = {.count = 1, .reusable = false}}, SHIFT(342),
  [232] = {.entry = {.count = 1, .reusable = false}}, SHIFT(343),
  [234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(344),
  [238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [240] = {.entry = {.count = 1, .reusable = false}}, SHIFT(345),
  [242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [244] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [246] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [248] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [256] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(645),
  [262] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(642),
  [265] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(171),
  [268] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(176),
  [271] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(177),
  [274] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(183),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(183),
  [280] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(184),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(184),
  [286] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(45),
  [289] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0), SHIFT_REPEAT(373),
  [292] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 2, 0, 0),
  [294] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_arg_comma_list, 3, 0, 0),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [300] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_arg_comma_list, 2, 0, 0),
  [302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [308] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3, 0, 0),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [312] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [318] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0),
  [320] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0),
  [322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 2, 0, 0), SHIFT_REPEAT(557),
  [325] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 2, 0, 4),
  [327] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 2, 0, 4),
  [329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [331] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_import_repeat1, 1, 0, 0),
  [333] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_repeat1, 1, 0, 0),
  [335] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_attribute, 3, 0, 9),
  [337] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_attribute, 3, 0, 9),
  [339] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__argument_expression_list, 3, 0, 0),
  [341] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__argument_expression_list, 3, 0, 0),
  [343] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__argument_expression_list, 2, 0, 0),
  [345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__argument_expression_list, 2, 0, 0),
  [347] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 1, 0, 0),
  [349] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 1, 0, 0),
  [351] = {.entry = {.count = 1, .reusable = false}}, SHIFT(451),
  [353] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 2, 0, 0),
  [355] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 2, 0, 0),
  [357] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0),
  [359] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0),
  [361] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(601),
  [364] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__binary_and_expression, 3, 0, 13),
  [366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__binary_and_expression, 3, 0, 13),
  [368] = {.entry = {.count = 1, .reusable = false}}, SHIFT(400),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(372),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [382] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__template_elaborated_ident, 2, 0, 0),
  [384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [386] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_elaborated_ident, 2, 0, 0),
  [388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [390] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__template_elaborated_ident, 1, 0, 0),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [394] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_elaborated_ident, 1, 0, 0),
  [396] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relational_expression, 3, 0, 13),
  [398] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relational_expression, 3, 0, 13),
  [400] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_preproc_custom_repeat1, 1, 0, 0),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_preproc_custom_repeat1, 1, 0, 0),
  [404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [408] = {.entry = {.count = 1, .reusable = false}}, SHIFT(53),
  [410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(55),
  [414] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__shift_expression, 3, 0, 13),
  [416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__shift_expression, 3, 0, 13),
  [418] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__additive_expression, 3, 0, 13),
  [420] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__additive_expression, 3, 0, 13),
  [422] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 6),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 6),
  [426] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__short_circuit_and_expression, 3, 0, 13),
  [428] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__short_circuit_and_expression, 3, 0, 13),
  [430] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__short_circuit_or_expression, 3, 0, 13),
  [432] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__short_circuit_or_expression, 3, 0, 13),
  [434] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__binary_or_expression, 3, 0, 13),
  [436] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__binary_or_expression, 3, 0, 13),
  [438] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiplicative_expression, 3, 0, 13),
  [440] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multiplicative_expression, 3, 0, 13),
  [442] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__binary_xor_expression, 3, 0, 13),
  [444] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__binary_xor_expression, 3, 0, 13),
  [446] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__ident, 2, 0, 0),
  [448] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__ident, 2, 0, 0),
  [450] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decrement_statement, 3, 0, 0),
  [452] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decrement_statement, 3, 0, 0),
  [454] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 2, 0, 0),
  [456] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 2, 0, 0),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 3, 0, 0),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 3, 0, 0),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_func_call_statement, 2, 0, 0),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_func_call_statement, 2, 0, 0),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__variable_updating_statement, 1, 0, 0),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__variable_updating_statement, 1, 0, 0),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_assignment_statement, 4, 0, 13),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_statement, 4, 0, 13),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 1, 0, 0),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_compound_statement, 4, 0, 0),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_compound_statement, 4, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_clause, 3, 0, 24),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_clause, 3, 0, 24),
  [486] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_if_clause, 4, 0, 36),
  [488] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_if_clause, 4, 0, 36),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_increment_statement, 3, 0, 0),
  [492] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_increment_statement, 3, 0, 0),
  [494] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_or_value_statement, 5, 0, 11),
  [496] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_or_value_statement, 5, 0, 11),
  [498] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_loop_statement, 2, 0, 5),
  [500] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_loop_statement, 2, 0, 5),
  [502] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_break_statement, 2, 0, 0),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_statement, 2, 0, 0),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_continue_statement, 2, 0, 0),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continue_statement, 2, 0, 0),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_continuing_statement, 2, 0, 0),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_continuing_statement, 2, 0, 0),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_discard_statement, 2, 0, 0),
  [516] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_discard_statement, 2, 0, 0),
  [518] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_or_value_statement, 2, 0, 0),
  [520] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_or_value_statement, 2, 0, 0),
  [522] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_statement, 2, 0, 0),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_statement, 2, 0, 0),
  [526] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 3, 0, 0),
  [528] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 3, 0, 0),
  [530] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_statement, 3, 0, 25),
  [532] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_statement, 3, 0, 25),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_statement, 3, 0, 24),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_statement, 3, 0, 24),
  [538] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 2, 0, 5),
  [540] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 2, 0, 5),
  [542] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 3, 0, 0),
  [544] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 3, 0, 0),
  [546] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_break_if_statement, 4, 0, 0),
  [548] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_break_if_statement, 4, 0, 0),
  [550] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_or_value_statement, 4, 0, 0),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_or_value_statement, 4, 0, 0),
  [554] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_body, 3, 0, 0),
  [556] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 3, 0, 0),
  [558] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 5, 0, 34),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 5, 0, 34),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch_body, 4, 0, 0),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_body, 4, 0, 0),
  [566] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__primary_expression, 1, 0, 0),
  [568] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__primary_expression, 1, 0, 0),
  [570] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_const_assert_statement, 3, 0, 0),
  [572] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const_assert_statement, 3, 0, 0),
  [574] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__statement, 1, 0, 0),
  [576] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__statement, 1, 0, 0),
  [578] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_compound_statement_repeat1, 1, 0, 0),
  [580] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_compound_statement_repeat1, 1, 0, 0),
  [582] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_statement, 1, 0, 0),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_statement, 1, 0, 0),
  [586] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_return_statement, 2, 0, 0),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2, 0, 0),
  [590] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indexing_expression, 4, 0, 19),
  [592] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indexing_expression, 4, 0, 19),
  [594] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__call_phrase, 2, 0, 0),
  [596] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__call_phrase, 2, 0, 0),
  [598] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_template_list, 3, 0, 0),
  [600] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_template_list, 3, 0, 0),
  [602] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__literal, 1, 0, 0),
  [604] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__literal, 1, 0, 0),
  [606] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_float_literal, 1, 0, 0),
  [608] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_float_literal, 1, 0, 0),
  [610] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [612] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool_literal, 1, 0, 0),
  [614] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 1, 0, 0),
  [616] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 1, 0, 0),
  [618] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 1, 0, 2),
  [620] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 1, 0, 2),
  [622] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_decimal_int_literal, 1, 0, 0),
  [624] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_decimal_int_literal, 1, 0, 0),
  [626] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_int_literal, 1, 0, 0),
  [628] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_int_literal, 1, 0, 0),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 1, 0, 0),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decimal_float_literal, 1, 0, 0),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decimal_float_literal, 1, 0, 0),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__hex_float_literal, 1, 0, 0),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__hex_float_literal, 1, 0, 0),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1, 0, 0),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1, 0, 0),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_paren_expression, 3, 0, 0),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_paren_expression, 3, 0, 0),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__member_ident, 1, 0, 0),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__member_ident, 1, 0, 0),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__template_elaborated_ident, 3, 0, 0),
  [654] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_elaborated_ident, 3, 0, 0),
  [656] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_swizzle_name, 1, 0, 0),
  [658] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_swizzle_name, 1, 0, 0),
  [660] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_named_component_expression, 3, 0, 14),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_component_expression, 3, 0, 14),
  [664] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [666] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [668] = {.entry = {.count = 1, .reusable = false}}, SHIFT(44),
  [670] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [672] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [674] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [676] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [678] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [680] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [682] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [684] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [686] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [696] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 2, 0, 0),
  [698] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [700] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [704] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [708] = {.entry = {.count = 1, .reusable = false}}, SHIFT(70),
  [710] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [712] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [714] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [716] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [718] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [720] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_selector, 1, 0, 0),
  [724] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 0),
  [728] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [730] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [732] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [734] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [736] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [738] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [740] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_arg_expression, 1, 0, 0),
  [742] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [744] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [746] = {.entry = {.count = 1, .reusable = false}}, SHIFT(88),
  [748] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [750] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [760] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0),
  [768] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(414),
  [771] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(557),
  [774] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(513),
  [777] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(500),
  [780] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(495),
  [783] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(467),
  [786] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(587),
  [789] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(67),
  [792] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(607),
  [795] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 2, 0, 0), SHIFT_REPEAT(504),
  [798] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [804] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_translation_unit, 3, 0, 0),
  [806] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [816] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [822] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [826] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0),
  [828] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0), SHIFT_REPEAT(572),
  [831] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0), SHIFT_REPEAT(489),
  [834] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0), SHIFT_REPEAT(479),
  [837] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0), SHIFT_REPEAT(557),
  [840] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat2, 2, 0, 0),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2, 0, 0),
  [844] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2, 0, 0), SHIFT_REPEAT(484),
  [847] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 2, 0, 0), SHIFT_REPEAT(557),
  [850] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat1, 2, 0, 0),
  [852] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat1, 2, 0, 0), SHIFT_REPEAT(488),
  [855] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__relational_operator, 1, 0, 0),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__relational_operator, 1, 0, 0),
  [859] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__multiplicative_operator, 1, 0, 0),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__multiplicative_operator, 1, 0, 0),
  [863] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__unary_operator, 1, 0, 0),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__unary_operator, 1, 0, 0),
  [867] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__compound_assignment_operator, 1, 0, 0),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__compound_assignment_operator, 1, 0, 0),
  [871] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__additive_operator, 1, 0, 0),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__additive_operator, 1, 0, 0),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_item, 1, 0, 3),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [881] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_item, 1, 0, 3),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_bevy_import, 3, 0, 0),
  [887] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_bevy_import, 3, 0, 0),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_item, 3, 0, 15),
  [891] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_item, 3, 0, 15),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_content, 1, 0, 0),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_content, 1, 0, 0),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 4, 0, 0),
  [899] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 4, 0, 0),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat1, 1, 0, 0),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat1, 1, 0, 0),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 3, 0, 0),
  [907] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 3, 0, 0),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_collection, 3, 0, 0),
  [911] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_collection, 3, 0, 0),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import, 5, 0, 0),
  [915] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import, 5, 0, 0),
  [917] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_bevy_import, 2, 0, 0),
  [919] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_preproc_bevy_import, 2, 0, 0),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_requires_directive, 3, 0, 0),
  [923] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_requires_directive, 3, 0, 0),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_directive, 1, 0, 0),
  [927] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_directive, 1, 0, 0),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat2, 1, 0, 0),
  [931] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat2, 1, 0, 0),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_diagnostic_directive, 3, 0, 8),
  [935] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_diagnostic_directive, 3, 0, 8),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_global_directive, 2, 0, 0),
  [939] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_global_directive, 2, 0, 0),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_global_directive, 1, 0, 0),
  [943] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_global_directive, 1, 0, 0),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enable_directive, 3, 0, 0),
  [947] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_enable_directive, 3, 0, 0),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [951] = {.entry = {.count = 1, .reusable = false}}, SHIFT(294),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [955] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [959] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [963] = {.entry = {.count = 1, .reusable = false}}, SHIFT(361),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_global_decl, 2, 0, 0),
  [967] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_global_decl, 2, 0, 0),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_alias_decl, 5, 0, 20),
  [971] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_alias_decl, 5, 0, 20),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 5, 0, 0),
  [975] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_body, 5, 0, 0),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 4, 0, 18),
  [979] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_variable_decl, 4, 0, 18),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 3, 0, 0),
  [983] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_body, 3, 0, 0),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_body, 4, 0, 0),
  [987] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_body, 4, 0, 0),
  [989] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_value_decl, 5, 0, 21),
  [991] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_value_decl, 5, 0, 21),
  [993] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_value_decl, 3, 0, 11),
  [995] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_value_decl, 3, 0, 11),
  [997] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_decl, 3, 0, 10),
  [999] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_struct_decl, 3, 0, 10),
  [1001] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_decl, 2, 0, 5),
  [1003] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_decl, 2, 0, 5),
  [1005] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_decl, 1, 0, 0),
  [1007] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_decl, 1, 0, 0),
  [1009] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_translation_unit_repeat3, 1, 0, 0),
  [1011] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_translation_unit_repeat3, 1, 0, 0),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_global_variable_decl, 2, 0, 0),
  [1015] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_global_variable_decl, 2, 0, 0),
  [1017] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__decorated_global_decl, 1, 0, 0),
  [1019] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__decorated_global_decl, 1, 0, 0),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1029] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 3, 0, 0),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1035] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 2, 0, 0),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1047] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_body_repeat1, 2, 0, 0),
  [1049] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_body_repeat1, 2, 0, 0), SHIFT_REPEAT(20),
  [1052] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_body_repeat1, 2, 0, 0), SHIFT_REPEAT(448),
  [1055] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_specifier, 1, 0, 0),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [1073] = {.entry = {.count = 1, .reusable = false}}, SHIFT(568),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1079] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__case_selectors, 1, 0, 0),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1085] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__case_selectors_repeat1, 2, 0, 0),
  [1087] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__case_selectors_repeat1, 2, 0, 0), SHIFT_REPEAT(26),
  [1090] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_collection_repeat1, 2, 0, 0), SHIFT_REPEAT(19),
  [1093] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_collection_repeat1, 2, 0, 0),
  [1095] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enable_extension_list, 3, 0, 0),
  [1097] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__software_extension_list, 3, 0, 0),
  [1099] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__software_extension_list, 2, 0, 0),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enable_extension_list, 2, 0, 0),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 4, 0, 4),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param_list, 1, 0, 0),
  [1117] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2, 0, 0), SHIFT_REPEAT(441),
  [1120] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_param_list_repeat1, 2, 0, 0),
  [1122] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_alone_clause, 2, 0, 5),
  [1124] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6, 0, 27),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1128] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__template_arg_comma_list_repeat1, 2, 0, 0), SHIFT_REPEAT(41),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__template_arg_comma_list_repeat1, 2, 0, 0),
  [1133] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_clause, 3, 0, 40),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_default_alone_clause, 3, 0, 40),
  [1137] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case_clause, 4, 0, 45),
  [1139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__enable_extension_list_repeat1, 2, 0, 0),
  [1141] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__enable_extension_list_repeat1, 2, 0, 0), SHIFT_REPEAT(528),
  [1144] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(56),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enable_extension_list, 1, 0, 0),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__diagnostic_name_token, 1, 0, 0),
  [1163] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__diagnostic_rule_name, 1, 0, 0),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1167] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_body_repeat1, 1, 0, 0),
  [1169] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__software_extension_list, 1, 0, 0),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1175] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2, 0, 0),
  [1177] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_struct_body_repeat1, 2, 0, 0), SHIFT_REPEAT(443),
  [1180] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch_clause, 1, 0, 0),
  [1182] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5, 0, 22),
  [1184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1188] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__optionally_typed_ident, 1, 0, 3),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1192] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 5, 0, 23),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__software_extension_list_repeat1, 2, 0, 0),
  [1200] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__software_extension_list_repeat1, 2, 0, 0), SHIFT_REPEAT(530),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__template_arg_comma_list, 1, 0, 0),
  [1207] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__enable_extension_name, 1, 0, 0),
  [1209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 3, 0, 12),
  [1211] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7, 0, 30),
  [1213] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8, 0, 37),
  [1215] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8, 0, 38),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 6, 0, 28),
  [1223] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 8, 0, 39),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7, 0, 31),
  [1227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__diagnostic_rule_name, 3, 0, 0),
  [1229] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__software_extension_name, 1, 0, 0),
  [1231] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 4, 0, 20),
  [1233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_path, 3, 0, 0),
  [1235] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_decl, 4, 0, 17),
  [1237] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 9, 0, 44),
  [1239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 4, 0, 20),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_header, 7, 0, 29),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1247] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__optionally_typed_ident, 3, 0, 16),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_struct_member, 3, 0, 16),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_param, 3, 0, 16),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_path, 2, 0, 0),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1279] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [1285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__severity_control_name, 1, 0, 0),
  [1287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_path, 3, 0, 0),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1299] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4, 0, 41),
  [1301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 4, 0, 42),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1317] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__diagnostic_control, 6, 0, 26),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [1323] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 5, 0, 46),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1329] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1335] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_ident_path, 2, 0, 0),
  [1337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1367] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_update, 1, 0, 0),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1371] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_header, 3, 0, 32),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__diagnostic_control, 5, 0, 26),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [1383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__for_init, 1, 0, 0),
  [1385] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_custom, 3, 0, 7),
  [1389] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_preproc_custom, 2, 0, 1),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_block_comment = 0,
  ts_external_token__disambiguate_template = 1,
  ts_external_token_template_args_start = 2,
  ts_external_token_template_args_end = 3,
  ts_external_token_less_than = 4,
  ts_external_token_less_than_equal = 5,
  ts_external_token_shift_left = 6,
  ts_external_token_shift_left_assign = 7,
  ts_external_token_greater_than = 8,
  ts_external_token_greater_than_equal = 9,
  ts_external_token_shift_right = 10,
  ts_external_token_shift_right_assign = 11,
  ts_external_token__error_sentinel = 12,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_block_comment] = sym_block_comment,
  [ts_external_token__disambiguate_template] = sym__disambiguate_template,
  [ts_external_token_template_args_start] = sym_template_args_start,
  [ts_external_token_template_args_end] = sym_template_args_end,
  [ts_external_token_less_than] = sym_less_than,
  [ts_external_token_less_than_equal] = sym_less_than_equal,
  [ts_external_token_shift_left] = sym_shift_left,
  [ts_external_token_shift_left_assign] = sym_shift_left_assign,
  [ts_external_token_greater_than] = sym_greater_than,
  [ts_external_token_greater_than_equal] = sym_greater_than_equal,
  [ts_external_token_shift_right] = sym_shift_right,
  [ts_external_token_shift_right_assign] = sym_shift_right_assign,
  [ts_external_token__error_sentinel] = sym__error_sentinel,
};

static const bool ts_external_scanner_states[12][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__disambiguate_template] = true,
    [ts_external_token_template_args_start] = true,
    [ts_external_token_template_args_end] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_shift_left_assign] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
    [ts_external_token_shift_right_assign] = true,
    [ts_external_token__error_sentinel] = true,
  },
  [2] = {
    [ts_external_token_block_comment] = true,
  },
  [3] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_end] = true,
  },
  [4] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
  },
  [5] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_start] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
  },
  [6] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_start] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_shift_left_assign] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
    [ts_external_token_shift_right_assign] = true,
  },
  [7] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_shift_left_assign] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
    [ts_external_token_shift_right_assign] = true,
  },
  [8] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_start] = true,
    [ts_external_token_template_args_end] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
  },
  [9] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_end] = true,
    [ts_external_token_less_than] = true,
    [ts_external_token_less_than_equal] = true,
    [ts_external_token_shift_left] = true,
    [ts_external_token_greater_than] = true,
    [ts_external_token_greater_than_equal] = true,
    [ts_external_token_shift_right] = true,
  },
  [10] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token_template_args_start] = true,
  },
  [11] = {
    [ts_external_token_block_comment] = true,
    [ts_external_token__disambiguate_template] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_wesl_external_scanner_create(void);
void tree_sitter_wesl_external_scanner_destroy(void *);
bool tree_sitter_wesl_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_wesl_external_scanner_serialize(void *, char *);
void tree_sitter_wesl_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_wesl(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_wesl_external_scanner_create,
      tree_sitter_wesl_external_scanner_destroy,
      tree_sitter_wesl_external_scanner_scan,
      tree_sitter_wesl_external_scanner_serialize,
      tree_sitter_wesl_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
