/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyBaseDocstringInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DocstringQuickFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public final class PyMissingOrEmptyDocstringInspection
extends PyBaseDocstringInspection {
    @Override
    @NotNull
    public PyBaseDocstringInspection.Visitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(1);
        }
        return new PyBaseDocstringInspection.Visitor(holder, PyInspectionVisitor.getContext(session)){

            @Override
            protected void checkDocString(@NotNull PyDocStringOwner node) {
                PyStringLiteralExpression docStringExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((docStringExpression = node.getDocStringExpression()) == null) {
                    PyClass pyClass;
                    PyFunction pyFunction;
                    for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                        if (!extension.ignoreMissingDocstring(node)) continue;
                        return;
                    }
                    Object marker = null;
                    if (node instanceof PyClass) {
                        n = ((PyClass)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFunction) {
                        n = ((PyFunction)node).getNameNode();
                        if (n != null) {
                            marker = n.getPsi();
                        }
                    } else if (node instanceof PyFile) {
                        TextRange tr = new TextRange(0, 0);
                        ProblemsHolder holder = this.getHolder();
                        if (holder != null) {
                            holder.registerProblem((PsiElement)node, tr, PyPsiBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[0]);
                        }
                        return;
                    }
                    if (marker == null) {
                        marker = node;
                    }
                    if (node instanceof PyFunction && !PyMissingOrEmptyDocstringInspection.superFunctionHasDoc(pyFunction = (PyFunction)node, this.myTypeEvalContext)) {
                        this.registerProblem((PsiElement)marker, PyPsiBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[]{new DocstringQuickFix(null, null)});
                    } else if (node instanceof PyClass && !PyMissingOrEmptyDocstringInspection.superClassHasDoc(pyClass = (PyClass)node, this.myTypeEvalContext)) {
                        if (pyClass.findInitOrNew(false, this.myTypeEvalContext) != null) {
                            this.registerProblem((PsiElement)marker, PyPsiBundle.message("INSP.no.docstring", new Object[0]), new LocalQuickFix[]{new DocstringQuickFix(null, null)});
                        } else {
                            this.registerProblem((PsiElement)marker, PyPsiBundle.message("INSP.no.docstring", new Object[0]));
                        }
                    }
                } else if (StringUtil.isEmptyOrSpaces((String)docStringExpression.getStringValue())) {
                    this.registerProblem((PsiElement)docStringExpression, PyPsiBundle.message("INSP.empty.docstring", new Object[0]));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection$1", "checkDocString"));
            }
        };
    }

    private static boolean superClassHasDoc(@NotNull PyClass pyClass, @NotNull TypeEvalContext context) {
        if (pyClass == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(2);
        }
        if (context == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(3);
        }
        for (PyClass ancestor : pyClass.getAncestorClasses(context)) {
            if (!StringUtil.isNotEmpty((String)ancestor.getDocStringValue())) continue;
            return true;
        }
        return false;
    }

    private static boolean superFunctionHasDoc(@NotNull PyFunction pyFunction, @NotNull TypeEvalContext context) {
        PyClass containingClass;
        if (pyFunction == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyMissingOrEmptyDocstringInspection.$$$reportNull$$$0(5);
        }
        if ((containingClass = pyFunction.getContainingClass()) == null) {
            return false;
        }
        for (PyClass ancestor : containingClass.getAncestorClasses(context)) {
            PyFunction superFunction = ancestor.findMethodByName(pyFunction.getName(), false, context);
            if (superFunction == null || !StringUtil.isNotEmpty((String)superFunction.getDocStringValue())) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyMissingOrEmptyDocstringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "superClassHasDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "superFunctionHasDoc";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

