/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstImportElement;
import com.jetbrains.python.ast.PyAstQualifiedExpression;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyPsiUtils {
    private static final Logger LOG = Logger.getInstance((String)PyPsiUtils.class.getName());

    private PyPsiUtils() {
    }

    @Nullable
    public static PsiElement getPrevComma(@NotNull PsiElement element) {
        PsiElement prevNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(0);
        }
        return (prevNode = PyPsiUtils.getPrevNonWhitespaceSibling(element)) != null && prevNode.getNode().getElementType() == PyTokenTypes.COMMA ? prevNode : null;
    }

    @Nullable
    public static PsiElement getPrevNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
    }

    @Nullable
    public static ASTNode getPrevNonWhitespaceSibling(@NotNull ASTNode node) {
        if (node == null) {
            PyPsiUtils.$$$reportNull$$$0(1);
        }
        return PyPsiUtils.skipSiblingsBackward(node, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getPrevNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        if (!(strict || start instanceof PsiWhiteSpace || start instanceof PsiComment)) {
            return start;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)start);
    }

    @Nullable
    public static PsiElement getNextComma(@NotNull PsiElement element) {
        PsiElement nextNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(2);
        }
        return (nextNode = PyPsiUtils.getNextNonWhitespaceSibling(element)) != null && nextNode.getNode().getElementType() == PyTokenTypes.COMMA ? nextNode : null;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
    }

    @Nullable
    public static PsiElement getPrevNonWhitespaceSiblingOnSameLine(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(3);
        }
        for (PsiElement cur = element.getPrevSibling(); cur != null; cur = cur.getPrevSibling()) {
            if (!(cur instanceof PsiWhiteSpace)) {
                return cur;
            }
            if (cur.textContains('\n')) break;
        }
        return null;
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceSibling(@NotNull ASTNode after) {
        if (after == null) {
            PyPsiUtils.$$$reportNull$$$0(4);
        }
        return PyPsiUtils.skipSiblingsForward(after, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getNextNonCommentSibling(@Nullable PsiElement start, boolean strict) {
        return PyPsiUtilsCore.getNextNonCommentSibling((PsiElement)start, (boolean)strict);
    }

    @Nullable
    public static PsiElement getNextSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getPrevSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getAdjacentComma(@NotNull PsiElement element) {
        PsiElement nextComma;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(5);
        }
        return (nextComma = PyPsiUtils.getNextComma(element)) != null ? nextComma : PyPsiUtils.getPrevComma(element);
    }

    @Nullable
    public static ASTNode skipSiblingsForward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.$$$reportNull$$$0(6);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode next = node.getTreeNext(); next != null; next = next.getTreeNext()) {
            if (types.contains(next.getElementType())) continue;
            return next;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipSiblingsBackward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.$$$reportNull$$$0(7);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode prev = node.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
            if (types.contains(prev.getElementType())) continue;
            return prev;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type2) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(8);
        }
        if (type2 == null) {
            PyPsiUtils.$$$reportNull$$$0(9);
        }
        return PyPsiUtilsCore.getFirstChildOfType((PsiElement)element, (PyElementType)type2);
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            PyPsiUtils.$$$reportNull$$$0(11);
        }
        return PyPsiUtilsCore.getChildByFilter((PsiElement)element, (TokenSet)filter, (int)number);
    }

    public static void removeElements(PsiElement ... elements) {
        ASTNode parentNode;
        if (elements == null) {
            PyPsiUtils.$$$reportNull$$$0(12);
        }
        LOG.assertTrue((parentNode = elements[0].getParent().getNode()) != null);
        for (PsiElement element : elements) {
            parentNode.removeChild(element.getNode());
        }
    }

    @Nullable
    public static PsiElement getStatement(@NotNull PsiElement element) {
        PyElement compStatement;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(13);
        }
        if ((compStatement = PyPsiUtils.getStatementList(element)) == null) {
            return null;
        }
        return PyPsiUtils.getParentRightBefore(element, (PsiElement)compStatement);
    }

    public static PyElement getStatementList(PsiElement element) {
        return element instanceof PyFile || element instanceof PyStatementList ? (PyElement)element : (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyStatementList.class});
    }

    @Nullable
    public static PsiElement getParentRightBefore(@NotNull PsiElement element, @NotNull PsiElement superParent) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(14);
        }
        if (superParent == null) {
            PyPsiUtils.$$$reportNull$$$0(15);
        }
        return PyPsiUtilsCore.getParentRightBefore((PsiElement)element, (PsiElement)superParent);
    }

    public static int getElementIndentation(PsiElement element) {
        PyElement compStatement = PyPsiUtils.getStatementList(element);
        PsiElement statement = PyPsiUtils.getParentRightBefore(element, (PsiElement)compStatement);
        if (statement == null) {
            return 0;
        }
        PsiElement sibling = statement.getPrevSibling();
        if (sibling == null) {
            sibling = compStatement.getPrevSibling();
        }
        String whitespace = sibling instanceof PsiWhiteSpace ? sibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        return i != -1 ? whitespace.length() - i - 1 : 0;
    }

    public static void removeRedundantPass(PyStatementList statementList) {
        PyStatement[] statements = statementList.getStatements();
        if (statements.length > 1) {
            for (PyStatement statement : statements) {
                if (!(statement instanceof PyPassStatement)) continue;
                statement.delete();
            }
        }
    }

    public static boolean isMethodContext(PsiElement element) {
        PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyFunction.class, PyClass.class});
        return parent instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{PyFile.class, PyFunction.class, PyClass.class}) instanceof PyClass;
    }

    @NotNull
    public static PsiElement getRealContext(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(16);
        }
        PyPsiUtils.assertValid(element);
        PsiFile file = element.getContainingFile();
        if (file instanceof PyExpressionCodeFragment) {
            PyExpressionCodeFragment fragment = (PyExpressionCodeFragment)file;
            PsiElement context = fragment.getRealContext();
            PsiElement psiElement = context != null ? context : element;
            if (psiElement == null) {
                PyPsiUtils.$$$reportNull$$$0(17);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyPsiUtils.$$$reportNull$$$0(18);
        }
        return psiElement;
    }

    public static void deleteAdjacentCommaWithWhitespaces(@NotNull PsiElement element, @NotNull PsiElement child) {
        PsiElement commaNode;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(19);
        }
        if (child == null) {
            PyPsiUtils.$$$reportNull$$$0(20);
        }
        if ((commaNode = PyPsiUtils.getAdjacentComma(child)) != null) {
            PsiElement nextNonWhitespace = PyPsiUtils.getNextNonWhitespaceSibling(commaNode);
            PsiElement last = nextNonWhitespace == null ? element.getLastChild() : nextNonWhitespace.getPrevSibling();
            PsiElement prevNonWhitespace = PyPsiUtils.getPrevNonWhitespaceSibling(commaNode);
            PsiElement first = prevNonWhitespace == null ? element.getFirstChild() : prevNonWhitespace.getNextSibling();
            element.deleteChildRange(first, last);
        }
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(21);
        }
        return PyPsiUtils.getPrecedingComments(element, true);
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element, boolean stopAtBlankLine) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(22);
        }
        List list = (List)PyPsiUtils.getPrecedingCommentsAndAnchor(element, stopAtBlankLine, true).getFirst();
        if (list == null) {
            PyPsiUtils.$$$reportNull$$$0(23);
        }
        return list;
    }

    @NotNull
    private static Pair<List<PsiComment>, PsiElement> getPrecedingCommentsAndAnchor(PsiElement element, boolean stopAtBlankLine, boolean strict) {
        ArrayList<PsiComment> result2 = new ArrayList<PsiComment>();
        PsiElement cursor = element instanceof PsiComment && !strict ? element : element.getPrevSibling();
        while (true) {
            int newLinesCount = 0;
            while (cursor instanceof PsiWhiteSpace) {
                newLinesCount += StringUtil.getLineBreakCount((CharSequence)cursor.getText());
                cursor = cursor.getPrevSibling();
            }
            if (stopAtBlankLine && newLinesCount > 1 || !(cursor instanceof PsiComment)) break;
            result2.add((PsiComment)cursor);
            cursor = cursor.getPrevSibling();
        }
        Collections.reverse(result2);
        Pair pair = Pair.create(result2, (Object)cursor);
        if (pair == null) {
            PyPsiUtils.$$$reportNull$$$0(24);
        }
        return pair;
    }

    @NotNull
    public static List<List<PsiComment>> getPrecedingCommentBlocks(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(25);
        }
        ArrayList<List<PsiComment>> blocks = new ArrayList<List<PsiComment>>();
        PsiElement anchor = element;
        do {
            Pair<List<PsiComment>, PsiElement> blockAndAnchor = PyPsiUtils.getPrecedingCommentsAndAnchor(anchor, true, false);
            anchor = (PsiElement)blockAndAnchor.getSecond();
            List block = (List)blockAndAnchor.getFirst();
            if (block.isEmpty() && !(anchor instanceof PsiComment)) continue;
            blocks.add(block);
        } while (anchor instanceof PsiComment);
        Collections.reverse(blocks);
        ArrayList<List<PsiComment>> arrayList = blocks;
        if (arrayList == null) {
            PyPsiUtils.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    public static int findArgumentIndex(PyCallExpression call, PsiElement argument) {
        PyExpression[] args = call.getArguments();
        for (int i = 0; i < args.length; ++i) {
            PyExpression expression = args[i];
            if (expression instanceof PyKeywordArgument) {
                expression = ((PyKeywordArgument)expression).getValueExpression();
            }
            if ((expression = PyPsiUtils.flattenParens(expression)) != argument) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PyTargetExpression getAttribute(@NotNull PyFile file, @NotNull String name2) {
        PyTargetExpression attr;
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(27);
        }
        if (name2 == null) {
            PyPsiUtils.$$$reportNull$$$0(28);
        }
        if ((attr = file.findTopLevelAttribute(name2)) == null) {
            for (PyFromImportStatement element : file.getFromImports()) {
                PsiElement resolved;
                PyReferenceExpression expression = element.getImportSource();
                if (expression == null || !((resolved = expression.getReference().resolve()) instanceof PyFile) || resolved == file) continue;
                return ((PyFile)resolved).findTopLevelAttribute(name2);
            }
        }
        return attr;
    }

    @NotNull
    public static List<PyExpression> getAttributeValuesFromFile(@NotNull PyFile file, @NotNull String name2) {
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(29);
        }
        if (name2 == null) {
            PyPsiUtils.$$$reportNull$$$0(30);
        }
        ArrayList<PyExpression> result2 = new ArrayList<PyExpression>();
        PyTargetExpression attr = file.findTopLevelAttribute(name2);
        if (attr != null) {
            PyPsiUtils.sequenceToList(result2, attr.findAssignedValue());
        }
        ArrayList<PyExpression> arrayList = result2;
        if (arrayList == null) {
            PyPsiUtils.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    public static void sequenceToList(List<? super PyExpression> result2, PyExpression value) {
        if ((value = PyPsiUtils.flattenParens(value)) instanceof PySequenceExpression) {
            ContainerUtil.addAll(result2, (Object[])((PySequenceExpression)value).getElements());
        } else {
            result2.add(value);
        }
    }

    public static List<String> getStringValues(PyExpression[] elements) {
        ArrayList<String> results = new ArrayList<String>();
        for (PyExpression element : elements) {
            if (!(element instanceof PyStringLiteralExpression)) continue;
            results.add(((PyStringLiteralExpression)element).getStringValue());
        }
        return results;
    }

    @Nullable
    public static PyExpression flattenParens(@Nullable PyExpression expr) {
        return (PyExpression)PyPsiUtilsCore.flattenParens((PyAstExpression)expr);
    }

    @Nullable
    public static String strValue(@Nullable PyExpression expression) {
        return PyPsiUtilsCore.strValue((PyAstExpression)expression);
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(32);
        }
        if (element2 == null) {
            PyPsiUtils.$$$reportNull$$$0(33);
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyExpression expr) {
        return PyPsiUtilsCore.asQualifiedName((PyAstExpression)expr);
    }

    @NotNull
    public static PyExpression getFirstQualifier(@NotNull PyQualifiedExpression expr) {
        PyExpression qualifier;
        if (expr == null) {
            PyPsiUtils.$$$reportNull$$$0(34);
        }
        if ((qualifier = expr.getQualifier()) instanceof PyQualifiedExpression) {
            return PyPsiUtils.getFirstQualifier((PyQualifiedExpression)qualifier);
        }
        PyQualifiedExpression pyQualifiedExpression = expr;
        if (pyQualifiedExpression == null) {
            PyPsiUtils.$$$reportNull$$$0(35);
        }
        return pyQualifiedExpression;
    }

    @NotNull
    public static String toPath(@Nullable PyQualifiedExpression expr) {
        if (expr != null) {
            QualifiedName qName = expr.asQualifiedName();
            if (qName != null) {
                String string = qName.toString();
                if (string == null) {
                    PyPsiUtils.$$$reportNull$$$0(36);
                }
                return string;
            }
            String name2 = expr.getName();
            if (name2 != null) {
                String string = name2;
                if (string == null) {
                    PyPsiUtils.$$$reportNull$$$0(37);
                }
                return string;
            }
        }
        return "";
    }

    @Nullable
    public static QualifiedName asQualifiedName(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            PyPsiUtils.$$$reportNull$$$0(38);
        }
        return PyPsiUtilsCore.asQualifiedName((PyAstQualifiedExpression)expr);
    }

    public static void assertValid(@Nullable PsiElement element) {
        PyPsiUtilsCore.assertValid((PsiElement)element);
    }

    public static void assertValid(@NotNull Module module2) {
        if (module2 == null) {
            PyPsiUtils.$$$reportNull$$$0(39);
        }
        LOG.assertTrue(!module2.isDisposed(), (Object)String.format("Module %s is disposed", module2));
    }

    @Nullable
    public static PsiFileSystemItem getFileSystemItem(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(40);
        }
        if (element instanceof PsiFileSystemItem) {
            return (PsiFileSystemItem)element;
        }
        return element.getContainingFile();
    }

    @Nullable
    public static String getContainingFilePath(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(41);
        }
        if ((file = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : element.getContainingFile().getVirtualFile()) != null) {
            return FileUtil.toSystemDependentName((String)file.getPath());
        }
        return null;
    }

    public static boolean containsImport(@NotNull PyFile file, @NotNull String source) {
        if (file == null) {
            PyPsiUtils.$$$reportNull$$$0(42);
        }
        if (source == null) {
            PyPsiUtils.$$$reportNull$$$0(43);
        }
        QualifiedName sourceQName = QualifiedName.fromDottedString((String)source);
        return Stream.concat(file.getFromImports().stream().map(PyAstFromImportStatement::getImportSourceQName), file.getImportTargets().stream().map(PyAstImportElement::getImportedQName)).filter(Objects::nonNull).anyMatch(name2 -> name2.matchesPrefix(sourceQName));
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        InjectedLanguageManager manager;
        if (element == null) {
            PyPsiUtils.$$$reportNull$$$0(44);
        }
        if ((manager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment(element.getContainingFile())) {
            String string = manager.getUnescapedText(element);
            if (string == null) {
                PyPsiUtils.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            PyPsiUtils.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Nullable
    public static String getStringValue(@Nullable PsiElement o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyStringLiteralExpression) {
            PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)o;
            return literalExpression.getStringValue();
        }
        return o.getText();
    }

    public static TextRange getStringValueTextRange(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            List ranges = ((PyStringLiteralExpression)element).getStringValueTextRanges();
            return (TextRange)ranges.get(0);
        }
        return new TextRange(0, element.getTextLength());
    }

    @Nullable
    public static PsiComment findSameLineComment(@NotNull PsiElement elem) {
        if (elem == null) {
            PyPsiUtils.$$$reportNull$$$0(47);
        }
        PsiElement next = PsiTreeUtil.getDeepestFirst((PsiElement)elem);
        do {
            if (!(next instanceof PsiComment)) continue;
            return (PsiComment)next;
        } while ((next == elem || !next.textContains('\n')) && (next = PsiTreeUtil.nextLeaf((PsiElement)next)) != null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 23, 24, 26, 31, 35, 36, 37, 45, 46 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParent";
                break;
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 27: 
            case 29: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealContext";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedingComments";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedingCommentsAndAnchor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedingCommentBlocks";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeValuesFromFile";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstQualifier";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "toPath";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextWithoutHostEscaping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComma";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonWhitespaceSibling";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNextComma";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonWhitespaceSiblingOnSameLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSibling";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentComma";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getParentRightBefore";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRealContext";
                break;
            }
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 45: 
            case 46: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deleteAdjacentCommaWithWhitespaces";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedingComments";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedingCommentBlocks";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuesFromFile";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isBefore";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifier";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "asQualifiedName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "assertValid";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystemItem";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilePath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "containsImport";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutHostEscaping";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findSameLineComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 23, 24, 26, 31, 35, 36, 37, 45, 46 -> new IllegalStateException(string);
        };
    }
}

