/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.tables.TableFormattingUtils;
import org.intellij.plugins.markdown.editor.tables.TableModificationUtils;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableCell;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableRow;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTableSeparatorRow;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/intentions/FixTableBordersIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "<init>", "()V", "getFamilyName", "", "getText", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "fixSeparatorRow", "separatorRow", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableSeparatorRow;", "fixRow", "row", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTableRow;", "columnsCount", "", "intellij.markdown"})
public final class FixTableBordersIntention
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @NotNull
    public String getText() {
        String string = MarkdownBundle.message("markdown.fix.table.borders.intention.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        MarkdownTable table;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTable markdownTable = table = TableUtils.findTable(element2);
        return markdownTable != null ? !TableModificationUtils.INSTANCE.hasCorrectBorders(markdownTable) : false;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        MarkdownTable markdownTable = TableUtils.findTable(element2);
        Intrinsics.checkNotNull((Object)markdownTable);
        MarkdownTable table = markdownTable;
        List<MarkdownTableRow> list2 = table.getRows(true);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRows(...)");
        List<MarkdownTableRow> rows = list2;
        Integer n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)rows), FixTableBordersIntention::invoke$lambda$0));
        int columnsCount = n != null ? n : 0;
        Iterator<MarkdownTableRow> iterator = rows.iterator();
        while (iterator.hasNext()) {
            MarkdownTableRow row;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.fixRow(row, columnsCount);
        }
        MarkdownTableSeparatorRow markdownTableSeparatorRow = TableUtils.INSTANCE.getSeparatorRow(table);
        if (markdownTableSeparatorRow != null) {
            MarkdownTableSeparatorRow it = markdownTableSeparatorRow;
            boolean bl = false;
            if (!TableModificationUtils.INSTANCE.hasCorrectBorders(it)) {
                this.fixSeparatorRow(it);
            }
        }
        if (editor2 != null && !TableModificationUtils.isCorrectlyFormatted$default(TableModificationUtils.INSTANCE, table, false, 1, null)) {
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document2);
            TableFormattingUtils.INSTANCE.reformatAllColumns(table, document2, true, false);
        }
    }

    private final void fixSeparatorRow(MarkdownTableSeparatorRow separatorRow) {
        StringBuilder stringBuilder;
        String string = separatorRow.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String currentText = string;
        StringBuilder $this$fixSeparatorRow_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (!StringsKt.startsWith$default((CharSequence)currentText, (char)'|', (boolean)false, (int)2, null)) {
            $this$fixSeparatorRow_u24lambda_u242.append('|');
        }
        $this$fixSeparatorRow_u24lambda_u242.append(currentText);
        if (!StringsKt.endsWith$default((CharSequence)currentText, (char)'|', (boolean)false, (int)2, null)) {
            $this$fixSeparatorRow_u24lambda_u242.append('|');
        }
        String newText = stringBuilder.toString();
        separatorRow.replace((PsiElement)MarkdownPsiElementFactory.createTableSeparatorRow(separatorRow.getProject(), newText));
    }

    private final void fixRow(MarkdownTableRow row, int columnsCount) {
        boolean bl;
        boolean bl2;
        Project project = row.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiElement psiElement = row.getFirstChild();
        if (psiElement != null) {
            IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
            bl2 = !PsiUtilsKt.hasType(psiElement, iElementType);
        } else {
            bl2 = false;
        }
        if (bl2) {
            row.addBefore(MarkdownPsiElementFactory.createTableSeparator(project2), row.getFirstChild());
        }
        PsiElement psiElement2 = row.getLastChild();
        if (psiElement2 != null) {
            IElementType iElementType = MarkdownTokenTypes.TABLE_SEPARATOR;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"TABLE_SEPARATOR");
            bl = !PsiUtilsKt.hasType(psiElement2, iElementType);
        } else {
            bl = false;
        }
        if (bl) {
            row.addAfter(MarkdownPsiElementFactory.createTableSeparator(project2), row.getLastChild());
        }
        int columnsDiff = columnsCount - TableUtils.INSTANCE.getColumnsCount(row);
        int n = 0;
        while (n < columnsDiff) {
            Pair<MarkdownTableCell, PsiElement> pair;
            int it = n++;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(MarkdownPsiElementFactory.createTableCell(project2, StringsKt.repeat((CharSequence)" ", (int)5)), (String)"createTableCell(...)");
            MarkdownTableCell cell = (MarkdownTableCell)ExtensionsKt.component1(pair);
            PsiElement separator = (PsiElement)ExtensionsKt.component2(pair);
            row.addRange((PsiElement)cell, separator);
        }
    }

    private static final int invoke$lambda$0(MarkdownTableRow it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return TableUtils.INSTANCE.getColumnsCount(it);
    }
}

