/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.projectTree;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamer;", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "newName", "", "<init>", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;Ljava/lang/String;)V", "isSelectedByDefault", "", "getDialogTitle", "getDialogDescription", "entityName", "Companion", "intellij.markdown"})
public final class MarkdownRenamer
extends AutomaticRenamer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> docExtensions;

    public MarkdownRenamer(@Nullable MarkdownFile element2, @Nullable String newName) {
        if (element2 != null) {
            List<PsiFile> boundDocuments = Companion.findBoundDocument(element2);
            this.myElements.addAll((Collection)boundDocuments);
            this.suggestAllNames(element2.getName(), newName);
        }
    }

    public boolean isSelectedByDefault() {
        return true;
    }

    @NotNull
    public String getDialogTitle() {
        String string = MarkdownBundle.message("markdown.rename.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDialogDescription() {
        String string = MarkdownBundle.message("markdown.rename.dialog.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String entityName() {
        String string = MarkdownBundle.message("markdown.rename.entity.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    static {
        Object[] objectArray = new String[]{"pdf", "docx", "html"};
        docExtensions = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamer$Companion;", "", "<init>", "()V", "docExtensions", "", "", "findBoundDocument", "Lcom/intellij/psi/PsiFile;", "element", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nMarkdownRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownRenamer.kt\norg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamer$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,40:1\n4135#2,11:41\n774#3:52\n865#3,2:53\n*S KotlinDebug\n*F\n+ 1 MarkdownRenamer.kt\norg/intellij/plugins/markdown/ui/projectTree/MarkdownRenamer$Companion\n*L\n34#1:41,11\n34#1:52\n34#1:53,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PsiFile> findBoundDocument(@NotNull MarkdownFile element2) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            PsiDirectory psiDirectory = element2.getParent();
            if (psiDirectory == null) {
                return CollectionsKt.emptyList();
            }
            PsiDirectory elementDir = psiDirectory;
            String string = element2.getVirtualFile().getNameWithoutExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String elementName = string;
            PsiElement[] psiElementArray = elementDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object $this$filterIsInstance$iv = psiElementArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PsiFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String string2;
                PsiFile it = (PsiFile)element$iv$iv;
                boolean bl = false;
                Iterable iterable = docExtensions;
                String string3 = it.getVirtualFile().getExtension();
                if (string3 != null) {
                    String string4 = string3.toLowerCase(Locale.ROOT);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                } else {
                    string2 = null;
                }
                if (!(CollectionsKt.contains((Iterable)iterable, (Object)string2) && Intrinsics.areEqual((Object)it.getVirtualFile().getNameWithoutExtension(), (Object)elementName))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

