/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.TextMateRange;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/SyntaxMatchUtils;", "", "<init>", "()V", "replaceGroupsWithMatchDataInRegex", "", "string", "", "matchingString", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "matchData", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "BACK_REFERENCE_REPLACEMENT_REGEX", "Lkotlin/text/Regex;", "CAPTURE_GROUP_REGEX", "replaceGroupsWithMatchDataInCaptures", "intellij.textmate.core"})
public final class SyntaxMatchUtils {
    @NotNull
    public static final SyntaxMatchUtils INSTANCE = new SyntaxMatchUtils();
    @NotNull
    private static final Regex BACK_REFERENCE_REPLACEMENT_REGEX = new Regex("[\\-\\\\{}*+?|^$.,\\[\\]()#\\s]");
    @NotNull
    private static final Regex CAPTURE_GROUP_REGEX = new Regex("\\$([0-9]+)|\\$\\{([0-9]+):/(downcase|upcase)}");

    private SyntaxMatchUtils() {
    }

    @NotNull
    public final String replaceGroupsWithMatchDataInRegex(@NotNull CharSequence string, @Nullable TextMateString matchingString, @NotNull MatchData matchData) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)matchData, (String)"matchData");
        if (matchingString == null || !matchData.getMatched()) {
            return ((Object)string).toString();
        }
        StringBuilder $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int charIndex = 0;
        int length = string.length();
        while (charIndex < length) {
            char c = string.charAt(charIndex);
            if (c == '\\') {
                int digitIndex;
                boolean hasGroupIndex = false;
                int groupIndex = 0;
                for (digitIndex = charIndex + 1; digitIndex < length; ++digitIndex) {
                    int digit;
                    Integer n = CharsKt.digitToIntOrNull((char)string.charAt(digitIndex));
                    int n2 = digit = n != null ? n : -1;
                    if (digit == -1) break;
                    hasGroupIndex = true;
                    groupIndex = groupIndex * 10 + digit;
                }
                if (hasGroupIndex && matchData.count() > groupIndex) {
                    TextMateRange range = matchData.byteOffset(groupIndex);
                    String replacement = StringsKt.decodeToString$default((byte[])matchingString.getBytes(), (int)range.getStart(), (int)range.getEnd(), (boolean)false, (int)4, null);
                    $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240.append(BACK_REFERENCE_REPLACEMENT_REGEX.replace((CharSequence)replacement, "\\\\$0"));
                    charIndex = digitIndex;
                    continue;
                }
            }
            $this$replaceGroupsWithMatchDataInRegex_u24lambda_u240.append(c);
            ++charIndex;
        }
        return stringBuilder.toString();
    }

    @NotNull
    public final CharSequence replaceGroupsWithMatchDataInCaptures(@NotNull CharSequence string, @NotNull TextMateString matchingString, @NotNull MatchData matchData) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)matchingString, (String)"matchingString");
        Intrinsics.checkNotNullParameter((Object)matchData, (String)"matchData");
        if (!matchData.getMatched()) {
            return string;
        }
        MatchResult matcher = null;
        StringBuilder $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int lastPosition = 0;
        for (matcher = Regex.find$default((Regex)CAPTURE_GROUP_REGEX, (CharSequence)string, (int)0, (int)2, null); matcher != null; matcher = matcher.next()) {
            String command;
            int groupIndex;
            Object object;
            Object object2 = matcher.getGroups().get(1);
            if (object2 == null) {
                object2 = object = matcher.getGroups().get(2);
            }
            int n = object2 != null && (object = object.getValue()) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (groupIndex = -1);
            if (groupIndex < 0 || matchData.count() <= groupIndex) continue;
            $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241.append(string, lastPosition, (int)matcher.getRange().getStart());
            TextMateRange range = matchData.byteOffset(groupIndex);
            String capturedText = StringsKt.decodeToString$default((byte[])matchingString.getBytes(), (int)range.getStart(), (int)range.getEnd(), (boolean)false, (int)4, null);
            char[] cArray = new char[]{'.'};
            String replacement = StringsKt.trimStart((String)capturedText, (char[])cArray);
            MatchGroup matchGroup = matcher.getGroups().get(3);
            String string2 = command = matchGroup != null ? matchGroup.getValue() : null;
            if (Intrinsics.areEqual((Object)string2, (Object)"downcase")) {
                String string3 = replacement.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241.append(string3);
            } else if (Intrinsics.areEqual((Object)string2, (Object)"upcase")) {
                String string4 = replacement.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241.append(string4);
            } else {
                v5 = $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241.append(replacement);
            }
            lastPosition = matcher.getRange().getEndInclusive() + 1;
        }
        if (lastPosition < string.length()) {
            $this$replaceGroupsWithMatchDataInCaptures_u24lambda_u241.append(string.subSequence(lastPosition, string.length()));
        }
        return stringBuilder.toString();
    }
}

