from collections.abc import Iterable, Iterator

from ._pygit2 import Oid
from .callbacks import RemoteCallbacks
from .enums import SubmoduleIgnore, SubmoduleStatus
from .repository import BaseRepository, Repository

class Submodule:
    def __del__(self) -> None: ...
    def open(self) -> Repository: ...
    def init(self, overwrite: bool = False) -> None: ...
    def update(self, init: bool = False, callbacks: RemoteCallbacks | None = None, depth: int = 0) -> None: ...
    def reload(self, force: bool = False) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def path(self) -> str: ...
    @property
    def url(self) -> str | None: ...
    @property
    def branch(self) -> str: ...
    @property
    def head_id(self) -> Oid | None: ...

class SubmoduleCollection:
    def __init__(self, repository: BaseRepository) -> None: ...
    def __getitem__(self, name: str) -> Submodule: ...
    def __contains__(self, name: str) -> bool: ...
    def __iter__(self) -> Iterator[Submodule]: ...
    def get(self, name: str) -> Submodule | None: ...
    def add(
        self, url: str, path: str, link: bool = True, callbacks: RemoteCallbacks | None = None, depth: int = 0
    ) -> Submodule: ...
    def init(self, submodules: Iterable[str] | None = None, overwrite: bool = False) -> None: ...
    def update(
        self,
        submodules: Iterable[str] | None = None,
        init: bool = False,
        callbacks: RemoteCallbacks | None = None,
        depth: int = 0,
    ) -> None: ...
    def status(self, name: str, ignore: SubmoduleIgnore = ...) -> SubmoduleStatus: ...
    def cache_all(self) -> None: ...
    def cache_clear(self) -> None: ...
