/* virtualdirmode_regcommands.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2014 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "virtualdirmode.hh"
#include "worker.h"
#include "aguix/fieldlistviewdnd.h"

void VirtualDirMode::vdir_from_selected()
{
    if ( ! ce.get() ) return;

    std::string name = AGUIXUtils::formatStringToString( "sel_vdir%d", s_selvdir_number++ );

    if ( s_selvdir_number < 0 ) {
        // avoid negative and zero number
        s_selvdir_number = 1;
    }

    std::unique_ptr< NWC::Dir > selvdir( new NWC::VirtualDir( name ) );

    std::list< NM_specialsourceExt > filelist;

    getSelFiles( filelist, ListerMode::LM_GETFILES_SELORACT );

    for ( auto &sse : filelist ) {
        const FileEntry *tfe = sse.entry();

        if ( tfe ) {
            selvdir->add( NWC::FSEntry( tfe->fullname ) );
        }
    }

    showDir( selvdir );
}

void VirtualDirMode::vdir_add_selected_from_other_side()
{
    std::list< NM_specialsourceExt > filelist;
    ListerMode *lm1 = NULL;
    Lister *ol = NULL;
  
    ol = parentlister->getWorker()->getOtherLister( parentlister );

    if ( ! ol ) return;
    
    lm1 = ol->getActiveMode();

    if ( ! lm1 ) return;
    
    lm1->getSelFiles( filelist, ListerMode::LM_GETFILES_ONLYSELECT, true );

    if ( ! ce.get() || ce->isRealDir() ) {
        std::string name = AGUIXUtils::formatStringToString( "sel_vdir%d", s_selvdir_number++ );

        if ( s_selvdir_number < 0 ) {
            // avoid negative and zero number
            s_selvdir_number = 1;
        }

        std::unique_ptr< NWC::Dir > selvdir( new NWC::VirtualDir( name ) );

        for ( auto &sse : filelist ) {
            const FileEntry *tfe = sse.entry();

            if ( tfe ) {
                selvdir->add( NWC::FSEntry( tfe->fullname ) );
            }
        }

        showDir( selvdir );
    } else {
        ce->beginModification( DMCacheEntryNWC::MOD_INSERTION );

        for ( auto &sse : filelist ) {
            const FileEntry *tfe = sse.entry();

            if ( tfe ) {
                ce->insertEntry( tfe->fullname );
            }
        }

        ce->endModification();

        setCurrentCE( ce );

        m_lv->showActive();
    }
}
