/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.sudo;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.sudo.SudoCommandProvider;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.system.OS;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u001f\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u000b\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\u0006\u0010\u0014\u001a\u00020\rR!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/sudo/LocalSudoCommandProvider;", "Lcom/intellij/execution/sudo/SudoCommandProvider;", "<init>", "()V", "hasGkSudo", "Ljava/util/function/Supplier;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "hasKdeSudo", "hasPkExec", "isAvailable", "sudoCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "wrappedCommand", "prompt", "", "Lorg/jetbrains/annotations/Nls;", "envCommand", "", "commandLine", "intellij.platform.ide.util.io"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLocalSudoCommandProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalSudoCommandProvider.kt\ncom/intellij/execution/sudo/LocalSudoCommandProvider\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,73:1\n126#2:74\n153#2,3:75\n*S KotlinDebug\n*F\n+ 1 LocalSudoCommandProvider.kt\ncom/intellij/execution/sudo/LocalSudoCommandProvider\n*L\n70#1:74\n70#1:75,3\n*E\n"})
public class LocalSudoCommandProvider
implements SudoCommandProvider {
    @NotNull
    private final Supplier<Boolean> hasGkSudo;
    @NotNull
    private final Supplier<Boolean> hasKdeSudo;
    @NotNull
    private final Supplier<Boolean> hasPkExec;

    public LocalSudoCommandProvider() {
        Supplier supplier = PathExecLazyValue.create((String)"gksudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier, (String)"create(...)");
        this.hasGkSudo = supplier;
        Supplier supplier2 = PathExecLazyValue.create((String)"kdesudo");
        Intrinsics.checkNotNullExpressionValue((Object)supplier2, (String)"create(...)");
        this.hasKdeSudo = supplier2;
        Supplier supplier3 = PathExecLazyValue.create((String)"pkexec");
        Intrinsics.checkNotNullExpressionValue((Object)supplier3, (String)"create(...)");
        this.hasPkExec = supplier3;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    @Nullable
    public GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine wrappedCommand, @NotNull String prompt) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)wrappedCommand, (String)"wrappedCommand");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Collection collection = CollectionsKt.listOf((Object)wrappedCommand.getExePath());
        List<String> list = wrappedCommand.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getList(...)");
        List command = CollectionsKt.plus((Collection)collection, (Iterable)list);
        if (OS.CURRENT == OS.Windows) {
            Path path = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"findBinFileWithException(...)");
            Path launcherExe = path;
            Object[] objectArray = new String[]{((Object)launcherExe).toString(), wrappedCommand.getExePath()};
            Collection collection2 = CollectionsKt.listOf((Object[])objectArray);
            List<String> list2 = wrappedCommand.getParametersList().getParameters();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getParameters(...)");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection2, (Iterable)list2));
        } else if (OS.CURRENT == OS.macOS) {
            String escapedCommand = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" & \" \" & ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$0, (int)30, null);
            String string = StringUtil.escapeQuotes((String)prompt);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeQuotes(...)");
            String escapedPrompt = string;
            String[] stringArray = new String[]{ExecUtil.getOsascriptPath(), "-e", StringsKt.trimIndent((String)("\n            tell current application\n                activate\n                do shell script " + escapedCommand + " with prompt \"" + escapedPrompt + "\" with administrator privileges without altering line endings\n            end tell"))};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(stringArray);
            generalCommandLine = generalCommandLine2;
        } else if (this.hasGkSudo.get().booleanValue()) {
            Object[] escapedCommand = new String[]{"gksudo", "--message", prompt, "--"};
            GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
            generalCommandLine = generalCommandLine3;
        } else if (this.hasKdeSudo.get().booleanValue()) {
            Object[] escapedCommand = new String[]{"kdesudo", "--comment", prompt, "--"};
            GeneralCommandLine generalCommandLine4 = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])escapedCommand), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
            generalCommandLine = generalCommandLine4;
        } else if (this.hasPkExec.get().booleanValue()) {
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"pkexec"), (Iterable)this.envCommand(wrappedCommand)), (Iterable)command));
        } else if (ExecUtil.hasTerminalApp()) {
            String escapedCommandLine = CollectionsKt.joinToString$default((Iterable)command, (CharSequence)" ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$1, (int)30, null);
            String escapedEnvCommand = CollectionsKt.joinToString$default((Iterable)this.envCommand(wrappedCommand), (CharSequence)" ", null, null, (int)0, null, LocalSudoCommandProvider::sudoCommand$lambda$2, (int)30, null);
            File script = ExecUtil.createTempExecutableScript("sudo", ".sh", StringsKt.trimIndent((String)("\n            #!/bin/sh\n            echo " + CommandLineUtil.posixQuote((String)prompt) + "\n            echo\n            sudo -- " + escapedEnvCommand + " " + escapedCommandLine + "\n            STATUS=$?\n            echo\n            read -p \"Press Enter to close this window...\" TEMP\n            exit $STATUS")));
            String string = IdeUtilIoBundle.message("terminal.title.install", new Object[0]);
            String string2 = script.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
            generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand(string, string2));
        } else {
            generalCommandLine = null;
        }
        return generalCommandLine;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> envCommand(@NotNull GeneralCommandLine commandLine) {
        List list;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Map<String, String> map = commandLine.getEnvironment();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getEnvironment(...)");
        Map<String, String> env = map;
        if (Intrinsics.areEqual(env, (Object)MapsKt.emptyMap())) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map<String, String> map2 = env;
            Collection collection = CollectionsKt.listOf((Object)"env");
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                void entry;
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(entry.getKey() + "=" + entry.getValue());
            }
            list = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    private static final CharSequence sudoCommand$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return ExecUtil.INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io(it);
    }

    private static final CharSequence sudoCommand$lambda$1(String it) {
        String string = CommandLineUtil.posixQuote((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
        return string;
    }

    private static final CharSequence sudoCommand$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = CommandLineUtil.posixQuote((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
        return string;
    }
}

