/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridLoader;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.run.actions.ChangePageSizeActionGroup;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import org.jetbrains.annotations.NotNull;

public class ChangePageSizeAction
extends DumbAwareAction {
    private final int myPageSize;

    public ChangePageSizeAction(int pageSize) {
        super(pageSize == -1 ? DataGridBundle.message((String)"action.ChangePageSize.text.all", (Object[])new Object[0]) : ChangePageSizeActionGroup.format(pageSize), pageSize == -1 ? DataGridBundle.message((String)"action.ChangePageSize.description.all", (Object[])new Object[0]) : DataGridBundle.message((String)"action.ChangePageSize.description.some", (Object[])new Object[]{ChangePageSizeActionGroup.format(pageSize)}), null);
        this.myPageSize = pageSize;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ChangePageSizeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ChangePageSizeAction.$$$reportNull$$$0(1);
        }
        DataGrid grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY);
        e.getPresentation().setEnabledAndVisible(grid != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ChangePageSizeAction.$$$reportNull$$$0(2);
        }
        if ((grid = (DataGrid)e.getData(DatabaseDataKeys.DATA_GRID_KEY)) == null) {
            return;
        }
        ChangePageSizeAction.setPageSizeAndReload(this.myPageSize, grid);
    }

    public static void setPageSizeAndReload(int pageSize, @NotNull DataGrid grid) {
        if (grid == null) {
            ChangePageSizeAction.$$$reportNull$$$0(3);
        }
        GridPagingModel pageModel = grid.getDataHookup().getPageModel();
        pageModel.setPageSize(pageSize);
        GridLoader loader = grid.getDataHookup().getLoader();
        GridRequestSource source = new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid));
        if (GridUtilCore.isPageSizeUnlimited((int)pageSize)) {
            loader.load(source, 0);
        } else {
            loader.reloadCurrentPage(source);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/ChangePageSizeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/ChangePageSizeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setPageSizeAndReload";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

