/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.backend;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.backend.TerminalSessionPersistedTab;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementState;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="TerminalTabsStorage", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\b\u0010\u000e\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/terminal/backend/TerminalTabsStorage;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/terminal/backend/TerminalTabsStorage$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "getStoredTabs", "", "Lcom/intellij/terminal/backend/TerminalSessionPersistedTab;", "updateStoredTabs", "", "tabs", "getState", "loadState", "restoreStateFromTerminalArrangementManager", "State", "Companion", "intellij.terminal.backend"})
public final class TerminalTabsStorage
implements PersistentStateComponent<State> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private State state;

    public TerminalTabsStorage(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = new State();
    }

    @NotNull
    public final List<TerminalSessionPersistedTab> getStoredTabs() {
        RunOnceUtil.runOnceForProject((Project)this.project, (String)"TerminalTabsStorage.copyFrom.TerminalArrangementManager", () -> TerminalTabsStorage.getStoredTabs$lambda$0(this));
        return this.state.getTabs();
    }

    public final void updateStoredTabs(@NotNull List<TerminalSessionPersistedTab> tabs) {
        Intrinsics.checkNotNullParameter(tabs, (String)"tabs");
        this.state.setTabs(tabs);
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public void loadState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
    }

    private final void restoreStateFromTerminalArrangementManager() {
        Object object = TerminalArrangementManager.getInstance(this.project).getArrangementState();
        if (object == null || (object = ((TerminalArrangementState)object).myTabStates) == null) {
            return;
        }
        Object tabsToCopy = object;
        List newTabs = new ArrayList();
        Iterator iterator = tabsToCopy.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            TerminalTabState tabToCopy = (TerminalTabState)e;
            TerminalSessionPersistedTab tab = new TerminalSessionPersistedTab(tabToCopy.myTabName, tabToCopy.myIsUserDefinedTabTitle, tabToCopy.myShellCommand, tabToCopy.myWorkingDirectory);
            newTabs.add(tab);
        }
        this.state.setTabs(newTabs);
    }

    private static final void getStoredTabs$lambda$0(TerminalTabsStorage this$0) {
        this$0.restoreStateFromTerminalArrangementManager();
    }

    @JvmStatic
    @NotNull
    public static final TerminalTabsStorage getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/terminal/backend/TerminalTabsStorage$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/terminal/backend/TerminalTabsStorage;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.terminal.backend"})
    @SourceDebugExtension(value={"SMAP\nTerminalTabsStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTabsStorage.kt\ncom/intellij/terminal/backend/TerminalTabsStorage$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n31#2,2:65\n*S KotlinDebug\n*F\n+ 1 TerminalTabsStorage.kt\ncom/intellij/terminal/backend/TerminalTabsStorage$Companion\n*L\n61#1:65,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TerminalTabsStorage getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TerminalTabsStorage> serviceClass$iv = TerminalTabsStorage.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (TerminalTabsStorage)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/backend/TerminalTabsStorage$State;", "", "<init>", "()V", "tabs", "", "Lcom/intellij/terminal/backend/TerminalSessionPersistedTab;", "getTabs", "()Ljava/util/List;", "setTabs", "(Ljava/util/List;)V", "intellij.terminal.backend"})
    public static final class State {
        @XCollection
        @NotNull
        private List<TerminalSessionPersistedTab> tabs = CollectionsKt.emptyList();

        @NotNull
        public final List<TerminalSessionPersistedTab> getTabs() {
            return this.tabs;
        }

        public final void setTabs(@NotNull List<TerminalSessionPersistedTab> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.tabs = list;
        }
    }
}

