/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.history;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryListener;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryPresenter;
import org.jetbrains.plugins.terminal.block.history.CommandHistoryUtil;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptModel;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013J\u0006\u0010\u0014\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter;", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "promptController", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptController;)V", "promptModel", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "getPromptModel", "()Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptModel;", "initialCommand", "", "showCommandHistory", "", "history", "", "onCommandHistoryClosed", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCommandHistoryPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,102:1\n25#2:103\n*S KotlinDebug\n*F\n+ 1 CommandHistoryPresenter.kt\norg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter\n*L\n75#1:103\n*E\n"})
public final class CommandHistoryPresenter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final TerminalPromptController promptController;
    @Nullable
    private String initialCommand;
    @NotNull
    private static final Key<Boolean> IS_COMMAND_HISTORY_LOOKUP_KEY;

    public CommandHistoryPresenter(@NotNull Project project, @NotNull Editor editor, @NotNull TerminalPromptController promptController) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)promptController, (String)"promptController");
        this.project = project;
        this.editor = editor;
        this.promptController = promptController;
    }

    private final TerminalPromptModel getPromptModel() {
        return this.promptController.getModel();
    }

    public final void showCommandHistory(@NotNull List<String> history) {
        String command2;
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.initialCommand = command2 = this.getPromptModel().getCommandText();
        LookupImpl lookup = CommandHistoryUtil.INSTANCE.createLookup(this.project, this.editor, ((Object)StringsKt.trim((CharSequence)command2)).toString(), CollectionsKt.asReversed(history));
        lookup.putUserData(IS_COMMAND_HISTORY_LOOKUP_KEY, (Object)true);
        lookup.addLookupListener(new LookupListener(lookup, this){
            final /* synthetic */ LookupImpl $lookup;
            final /* synthetic */ CommandHistoryPresenter this$0;
            {
                this.$lookup = $lookup;
                this.this$0 = $receiver;
            }

            public void currentItemChanged(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Object object = event.getItem();
                if (object == null || (object = object.getLookupString()) == null) {
                    return;
                }
                Object selectedCommand = object;
                ActionsKt.invokeLater$default(null, () -> showCommandHistory.1.currentItemChanged$lambda$2(this.$lookup, this.this$0, (String)selectedCommand), (int)1, null);
            }

            public boolean beforeItemSelected(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return false;
            }

            public void itemSelected(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
                if (event.getCompletionChar() == '\n') {
                    CommandHistoryPresenter.access$getPromptController$p(this.this$0).handleEnterPressed();
                }
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CommandHistoryPresenter.access$setInitialCommand$p(this.this$0, null);
            }

            private static final void currentItemChanged$lambda$2$lambda$1$lambda$0(CommandHistoryPresenter this$0, String $selectedCommand) {
                CommandHistoryPresenter.access$getPromptModel(this$0).setCommandText($selectedCommand);
                CommandHistoryPresenter.access$getEditor$p(this$0).getCaretModel().moveToOffset(CommandHistoryPresenter.access$getEditor$p(this$0).getDocument().getTextLength());
            }

            private static final Unit currentItemChanged$lambda$2$lambda$1(LookupImpl $lookup, CommandHistoryPresenter this$0, String $selectedCommand) {
                $lookup.performGuardedChange(() -> showCommandHistory.1.currentItemChanged$lambda$2$lambda$1$lambda$0(this$0, $selectedCommand));
                return Unit.INSTANCE;
            }

            private static final Unit currentItemChanged$lambda$2(LookupImpl $lookup, CommandHistoryPresenter this$0, String $selectedCommand) {
                if (!$lookup.isLookupDisposed()) {
                    ActionsKt.runWriteAction(() -> showCommandHistory.1.currentItemChanged$lambda$2$lambda$1($lookup, this$0, $selectedCommand));
                }
                return Unit.INSTANCE;
            }
        });
        if (lookup.showLookup()) {
            lookup.ensureSelectionVisible(false);
            ((CommandHistoryListener)this.project.getMessageBus().syncPublisher(CommandHistoryListener.Companion.getTOPIC())).commandHistoryShown(this.getPromptModel());
        } else {
            CommandHistoryPresenter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(CommandHistoryPresenter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to show command history");
        }
    }

    public final void onCommandHistoryClosed() {
        String commandToRestore = this.initialCommand;
        if (commandToRestore != null) {
            this.initialCommand = null;
            TerminalUiUtilsKt.invokeLater$default(TerminalUiUtilsKt.getDisposed(this.editor), null, () -> CommandHistoryPresenter.onCommandHistoryClosed$lambda$0(this, commandToRestore), 2, null);
        }
    }

    private static final void onCommandHistoryClosed$lambda$0(CommandHistoryPresenter this$0, String $commandToRestore) {
        this$0.getPromptModel().setCommandText($commandToRestore);
        this$0.editor.getCaretModel().moveToOffset(this$0.editor.getDocument().getTextLength());
        ((CommandHistoryListener)this$0.project.getMessageBus().syncPublisher(CommandHistoryListener.Companion.getTOPIC())).commandHistoryAborted(this$0.getPromptModel());
    }

    public static final /* synthetic */ void access$setInitialCommand$p(CommandHistoryPresenter $this, String string) {
        $this.initialCommand = string;
    }

    public static final /* synthetic */ TerminalPromptController access$getPromptController$p(CommandHistoryPresenter $this) {
        return $this.promptController;
    }

    public static final /* synthetic */ TerminalPromptModel access$getPromptModel(CommandHistoryPresenter $this) {
        return $this.getPromptModel();
    }

    public static final /* synthetic */ Editor access$getEditor$p(CommandHistoryPresenter $this) {
        return $this.editor;
    }

    static {
        Key key = Key.create((String)"isCommandHistoryLookup");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_COMMAND_HISTORY_LOOKUP_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00020\u0006*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/block/history/CommandHistoryPresenter$Companion;", "", "<init>", "()V", "IS_COMMAND_HISTORY_LOOKUP_KEY", "Lcom/intellij/openapi/util/Key;", "", "isTerminalCommandHistory", "Lcom/intellij/codeInsight/lookup/Lookup;", "(Lcom/intellij/codeInsight/lookup/Lookup;)Z", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isTerminalCommandHistory(@NotNull Lookup $this$isTerminalCommandHistory) {
            Intrinsics.checkNotNullParameter((Object)$this$isTerminalCommandHistory, (String)"<this>");
            UserDataHolder userDataHolder = $this$isTerminalCommandHistory instanceof UserDataHolder ? (UserDataHolder)$this$isTerminalCommandHistory : null;
            return userDataHolder != null ? Intrinsics.areEqual((Object)userDataHolder.getUserData(IS_COMMAND_HISTORY_LOOKUP_KEY), (Object)true) : false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

