/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.imports.AutoImportQuickFix;
import com.jetbrains.python.codeInsight.imports.PyImportCandidateProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.unresolvedReference.PyCommonImportAliasesKt;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.stubs.PyModuleNameIndex;
import com.jetbrains.python.psi.stubs.PyTypeAliasNameIndex;
import com.jetbrains.python.psi.stubs.PyVariableNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyImportCollector {
    private final PyElement myNode;
    private final PsiReference myReference;
    private final String myRefText;
    private final AutoImportQuickFix fix;
    private final Set<String> seenCandidateNames;

    public PyImportCollector(PyElement node, PsiReference reference, String refText) {
        this.myNode = node;
        this.myReference = reference;
        this.myRefText = refText;
        boolean qualify = !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT;
        this.fix = new AutoImportQuickFix((PsiElement)node, reference.getClass(), refText, qualify);
        this.seenCandidateNames = new HashSet<String>();
    }

    public AutoImportQuickFix addCandidates() {
        PsiFile existingImportFile = this.addCandidatesFromExistingImports();
        ProgressManager.checkCanceled();
        this.addSymbolImportCandidates(existingImportFile);
        for (PyImportCandidateProvider provider : PyImportCandidateProvider.EP_NAME.getExtensionList()) {
            provider.addImportCandidates(this.myReference, this.myRefText, this.fix);
        }
        if (!this.fix.getCandidates().isEmpty()) {
            this.fix.sortCandidates();
            return this.fix;
        }
        return null;
    }

    private PsiFile addCandidatesFromExistingImports() {
        PsiFile existingImportFile = null;
        PsiFile file = this.myNode.getContainingFile();
        if (file instanceof PyFile) {
            PyFile pyFile = (PyFile)file;
            for (PyImportElement importElement : pyFile.getImportTargets()) {
                existingImportFile = this.addImportViaElement(existingImportFile, importElement, importElement.resolve());
            }
            existingImportFile = this.addCandidatesViaFromImports(existingImportFile, pyFile);
        }
        return existingImportFile;
    }

    PsiFile addCandidatesViaFromImports(PsiFile existingImportFile, PyFile pyFile) {
        for (PyFromImportStatement fromImportStatement : pyFile.getFromImports()) {
            if (fromImportStatement.isStarImport() || fromImportStatement.getImportElements().length <= 0) continue;
            PsiFileSystemItem source = fromImportStatement.resolveImportSource();
            existingImportFile = this.addImportViaElement(existingImportFile, fromImportStatement.getImportElements()[0], (PsiElement)source);
        }
        return existingImportFile;
    }

    private PsiFile addImportViaElement(PsiFile existingImportFile, PyImportElement importElement, PsiElement source) {
        PyFile sourceFile = PyUtil.as(PyUtil.turnDirIntoInit(source), PyFile.class);
        if (sourceFile instanceof PyFileImpl) {
            String name2;
            PsiElement variant = sourceFile.findExportedName(this.myRefText);
            String string = name2 = variant instanceof PyQualifiedNameOwner ? ((PyQualifiedNameOwner)variant).getQualifiedName() : null;
            if (name2 != null && this.seenCandidateNames.contains(name2)) {
                return existingImportFile;
            }
            PsiNamedElement definition = PyUtil.as(variant, PsiNamedElement.class);
            if (definition != null && !(definition instanceof PyFile) && !(definition instanceof PyImportElement) && definition.getContainingFile() != null && PsiTreeUtil.isAncestor((PsiElement)source, (PsiElement)definition.getContainingFile(), (boolean)false)) {
                existingImportFile = sourceFile;
                this.fix.addImport(definition, sourceFile, importElement);
                if (name2 != null) {
                    this.seenCandidateNames.add(name2);
                }
            }
        }
        return existingImportFile;
    }

    private void addSymbolImportCandidates(PsiFile existingImportFile) {
        Project project = this.myNode.getProject();
        GlobalSearchScope scope = PySearchUtilBase.defaultSuggestionScope((PsiElement)this.myNode);
        TypeEvalContext context = TypeEvalContext.codeAnalysis(project, this.myNode.getContainingFile());
        ArrayList<PyClass> symbols = new ArrayList<PyClass>(PyClassNameIndex.find(this.myRefText, project, scope));
        if (!this.isQualifier()) {
            symbols.addAll(PyFunctionNameIndex.find(this.myRefText, project, scope));
        }
        symbols.addAll(PyVariableNameIndex.find(this.myRefText, project, scope));
        if (PyTypingTypeProvider.isInsideTypeHint((PsiElement)this.myNode, context)) {
            symbols.addAll(PyTypeAliasNameIndex.find(this.myRefText, project, scope));
        }
        if (this.isPossibleModuleReference()) {
            symbols.addAll(this.findImportableModules(this.myRefText, false, scope));
            String packageQName = PyCommonImportAliasesKt.PY_COMMON_IMPORT_ALIASES.get(this.myRefText);
            if (packageQName != null) {
                symbols.addAll(this.findImportableModules(packageQName, true, scope));
            }
        }
        for (PsiNamedElement psiNamedElement : symbols) {
            String name2;
            String symbolImportQName;
            QualifiedName importPath;
            PsiFile srcfile;
            if (!PyImportCollector.isIndexableTopLevel((PsiElement)psiNamedElement) || (srcfile = psiNamedElement instanceof PsiFileSystemItem ? ((PsiFileSystemItem)psiNamedElement).getParent() : psiNamedElement.getContainingFile()) == null || !this.isAcceptableForImport(existingImportFile, (PsiFileSystemItem)srcfile) || (importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)psiNamedElement, (PsiElement)this.myNode)) == null) continue;
            if (psiNamedElement instanceof PsiFileSystemItem) {
                importPath = importPath.removeTail(1);
            }
            if (!this.seenCandidateNames.add(symbolImportQName = importPath.append(name2 = PyUtil.getElementNameWithoutExtension(psiNamedElement)).toString())) continue;
            String alias = name2.equals(this.myRefText) ? null : this.myRefText;
            this.fix.addImport(psiNamedElement, (PsiFileSystemItem)srcfile, importPath, alias);
        }
    }

    PyElement getNode() {
        return this.myNode;
    }

    private boolean isAcceptableForImport(PsiFile existingImportFile, PsiFileSystemItem srcfile) {
        return srcfile != existingImportFile && srcfile != this.myNode.getContainingFile() && (PyUtil.isRoot(srcfile) || PyNames.isIdentifier((String)FileUtilRt.getNameWithoutExtension((String)srcfile.getName()))) && !PyImportCollector.isShadowedModule(srcfile);
    }

    private static boolean isShadowedModule(PsiFileSystemItem file) {
        if (file.isDirectory() || file.getName().equals("__init__.py")) {
            return false;
        }
        String name2 = FileUtilRt.getNameWithoutExtension((String)file.getName());
        PsiDirectory directory = ((PsiFile)file).getContainingDirectory();
        if (directory == null) {
            return false;
        }
        PsiDirectory packageDir = directory.findSubdirectory(name2);
        return packageDir != null && packageDir.findFile("__init__.py") != null;
    }

    private boolean isQualifier() {
        return this.myNode.getParent() instanceof PyReferenceExpression && this.myNode == ((PyReferenceExpression)this.myNode.getParent()).getQualifier();
    }

    private boolean isPossibleModuleReference() {
        PyClass pyClass;
        PyArgumentList argumentList;
        PsiElement psiElement;
        PyCallExpression callExpression = PyUtil.as(this.myNode.getParent(), PyCallExpression.class);
        if (callExpression != null && this.myNode == callExpression.getCallee()) {
            PyDecorator decorator = PyUtil.as(callExpression, PyDecorator.class);
            return decorator != null && !decorator.hasArgumentList();
        }
        PsiElement psiElement2 = this.myNode.getParent();
        return !(psiElement2 instanceof PyArgumentList) || !((psiElement = (argumentList = (PyArgumentList)psiElement2).getParent()) instanceof PyClass) || (pyClass = (PyClass)psiElement).getSuperClassExpressionList() != argumentList;
    }

    @NotNull
    private Collection<PsiFileSystemItem> findImportableModules(@NotNull String name2, boolean matchQualifiedName, @NotNull GlobalSearchScope scope) {
        if (name2 == null) {
            PyImportCollector.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PyImportCollector.$$$reportNull$$$0(1);
        }
        ArrayList<PsiFileSystemItem> result2 = new ArrayList<PsiFileSystemItem>();
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)name2);
        List<PyFile> matchingModules = matchQualifiedName ? PyModuleNameIndex.findByQualifiedName(qualifiedName, this.myNode.getProject(), scope) : PyModuleNameIndex.findByShortName(name2, this.myNode.getProject(), scope);
        for (PyFile module : matchingModules) {
            PsiFileSystemItem candidate = PyUtil.as(PyUtil.turnInitIntoDir((PsiElement)module), PsiFileSystemItem.class);
            if (candidate == null || !PyUtil.isImportable(this.myNode.getContainingFile(), candidate)) continue;
            result2.add(candidate);
        }
        ArrayList<PsiFileSystemItem> arrayList = result2;
        if (arrayList == null) {
            PyImportCollector.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isIndexableTopLevel(PsiElement symbol) {
        if (symbol instanceof PsiFileSystemItem) {
            return true;
        }
        if (symbol instanceof PyClass || symbol instanceof PyFunction) {
            return PyUtil.isTopLevel(symbol);
        }
        return symbol instanceof PyTargetExpression || symbol instanceof PyTypeAliasStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportCollector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findImportableModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findImportableModules";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

