/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.washington.cs.knowitall.regex.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class Match<E> {
    protected List<Group<E>> pairs = new ArrayList<Group<E>>();

    protected Match() {
    }

    protected Match(Match<E> match) {
        this();
        for (Group<E> pair : match.pairs) {
            this.add(new Group(pair.expr, ((Group)pair).tokens));
        }
    }

    public boolean add(Group<E> pair) {
        return this.pairs.add(pair);
    }

    public boolean addAll(Collection<Group<E>> pairs) {
        boolean result2 = true;
        for (Group<E> pair : pairs) {
            result2 &= this.add(pair);
        }
        return result2;
    }

    public boolean add(Expression<E> expr, E token, int pos) {
        return this.add(new Group<E>(expr, token, pos));
    }

    public boolean isEmpty() {
        return this.pairs.isEmpty();
    }

    public String toString() {
        return "[" + Joiner.on((String)", ").join((Iterable)Lists.transform(this.pairs, (Function)Functions.toStringFunction())) + "]";
    }

    public String toMultilineString() {
        return Joiner.on((String)"\n").join((Iterable)Lists.transform(this.pairs, (Function)Functions.toStringFunction()));
    }

    public abstract int startIndex();

    public abstract int endIndex();

    public List<Group<E>> pairs() {
        return Collections.unmodifiableList(this.pairs);
    }

    public abstract List<Group<E>> groups();

    public abstract List<E> tokens();

    public int length() {
        return this.tokens().size();
    }

    public Group<E> group(String name) {
        for (Group<E> group : this.groups()) {
            if (!(group.expr instanceof Expression.NamedGroup)) continue;
            Expression.NamedGroup namedGroup = (Expression.NamedGroup)group.expr;
            if (!namedGroup.name.equals(name)) continue;
            return group;
        }
        return null;
    }

    public static class Group<E> {
        public final Expression<E> expr;
        private final List<Token<E>> tokens;

        public Group(Expression<E> expr, E token, int pos) {
            this(expr, Collections.singletonList(new Token<E>(token, pos)));
        }

        public Group(Expression<E> expr, List<Token<E>> tokens) {
            this.expr = expr;
            this.tokens = new ArrayList<Token<Token<E>>>(tokens);
        }

        public Group(Expression<E> expr) {
            this(expr, new ArrayList<Token<E>>());
        }

        protected void addTokens(Group<E> group) {
            this.tokens.addAll(group.tokens);
        }

        public List<E> tokens() {
            return Lists.transform(this.tokens, (Function)new Function<Token<E>, E>(){

                public E apply(Token<E> token) {
                    return token.entity;
                }
            });
        }

        public int startIndex() {
            int min = -1;
            for (Token<E> token : this.tokens) {
                if (min != -1 && token.index >= min) continue;
                min = token.index;
            }
            return min;
        }

        public int endIndex() {
            int max = -1;
            for (Token<E> token : this.tokens) {
                if (token.index != -1 && token.index <= max) continue;
                max = token.index;
            }
            return max;
        }

        public String text() {
            return Joiner.on((String)" ").join(this.tokens());
        }

        public int tokenCount() {
            return this.tokens.size();
        }

        public String toString() {
            return this.expr.toString() + ":'" + Joiner.on((String)" ").join((Iterable)Lists.transform(this.tokens, (Function)Functions.toStringFunction())) + "'";
        }

        private static class Token<E> {
            public E entity;
            public int index;

            public Token(E entity, int index) {
                this.entity = entity;
                this.index = index;
            }

            public String toString() {
                return this.entity.toString();
            }
        }
    }

    protected static final class IntermediateMatch<E>
    extends Match<E> {
        protected IntermediateMatch() {
        }

        @Override
        public List<E> tokens() {
            ArrayList tokens = new ArrayList();
            for (Group pair : this.pairs) {
                if (!(pair.expr instanceof Expression.BaseExpression)) continue;
                tokens.addAll(pair.tokens());
            }
            return tokens;
        }

        @Override
        public List<Group<E>> groups() {
            ArrayList<Group<Group>> groups = new ArrayList<Group<Group>>();
            for (Group pair : this.pairs) {
                if (!(pair.expr instanceof Expression.MatchingGroup) || pair.expr instanceof Expression.NonMatchingGroup) continue;
                groups.add(pair);
            }
            return groups;
        }

        @Override
        public int startIndex() {
            for (Group pair : this.pairs) {
                if (!(pair.expr instanceof Expression.BaseExpression)) continue;
                return ((Group.Token)((Group)pair).tokens.get((int)0)).index;
            }
            return -1;
        }

        @Override
        public int endIndex() {
            for (Group pair : Lists.reverse((List)this.pairs)) {
                if (!(pair.expr instanceof Expression.BaseExpression)) continue;
                return ((Group.Token)((Group)pair).tokens.get((int)0)).index;
            }
            return -1;
        }
    }

    protected static final class FinalMatch<E>
    extends Match<E> {
        private final int startIndex;
        private final List<E> tokens;
        private final List<Group<E>> groups;

        protected FinalMatch(Match<E> m) {
            super(m);
            this.startIndex = m.startIndex();
            this.tokens = Collections.unmodifiableList(m.tokens());
            this.groups = Collections.unmodifiableList(m.groups());
        }

        @Override
        public int startIndex() {
            return this.startIndex;
        }

        @Override
        public int endIndex() {
            return this.startIndex() + this.tokens.size();
        }

        @Override
        public List<E> tokens() {
            return this.tokens;
        }

        @Override
        public List<Group<E>> groups() {
            return this.groups;
        }
    }
}

