/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.languagetool.markup.AnnotatedText;

public class SentenceRange
implements Comparable<SentenceRange> {
    private static final Pattern BEGINS_WITH_SPACE = Pattern.compile("^\\s*");
    private static final Pattern ENDS_WITH_SPACE = Pattern.compile("\\s+$");
    private final int fromPos;
    private final int toPos;

    SentenceRange(int fromPos, int toPos) {
        this.fromPos = fromPos;
        this.toPos = toPos;
    }

    public static List<SentenceRange> getRangesFromSentences(AnnotatedText annotatedText, List<String> sentences2) {
        ArrayList<SentenceRange> sentenceRanges = new ArrayList<SentenceRange>();
        int pos = 0;
        int markupTextLength = annotatedText.getTextWithMarkup().length();
        int diff = markupTextLength - annotatedText.getPlainText().length();
        for (String sentence : sentences2) {
            if (sentence.trim().isEmpty()) {
                pos += sentence.length();
                continue;
            }
            String sentenceNoBeginWhitespace = BEGINS_WITH_SPACE.matcher(sentence).replaceFirst("");
            String sentenceNoEndWhitespace = ENDS_WITH_SPACE.matcher(sentence).replaceFirst("");
            int fromPos = pos + (sentence.length() - sentenceNoBeginWhitespace.length());
            int toPos = pos + sentenceNoEndWhitespace.length();
            int fromPosOrig = fromPos + diff;
            int toPosOrig = toPos + diff;
            if (fromPosOrig != markupTextLength) {
                fromPosOrig = annotatedText.getOriginalTextPositionFor(fromPos, false);
            }
            if (toPosOrig != markupTextLength) {
                toPosOrig = annotatedText.getOriginalTextPositionFor(toPos, true);
            }
            sentenceRanges.add(new SentenceRange(fromPosOrig, toPosOrig));
            pos += sentence.length();
        }
        return sentenceRanges;
    }

    public int getFromPos() {
        return this.fromPos;
    }

    public int getToPos() {
        return this.toPos;
    }

    public String toString() {
        return this.fromPos + "-" + this.toPos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SentenceRange range = (SentenceRange)o;
        return this.fromPos == range.fromPos && this.toPos == range.toPos;
    }

    public int hashCode() {
        return Objects.hash(this.fromPos, this.toPos);
    }

    @Override
    public int compareTo(@NotNull SentenceRange o) {
        return Integer.compare(this.fromPos, o.fromPos);
    }
}

