/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.report;

import com.google.gson.JsonParseException;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.SarifUtil;
import com.jetbrains.qodana.sarif.model.SarifReport;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.notifications.QodanaNotifications;
import org.jetbrains.qodana.report.LoadedSarif;
import org.jetbrains.qodana.report.NotValidatedSarif;
import org.jetbrains.qodana.report.ReportResult;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/qodana/report/ReportParser;", "", "<init>", "()V", "parseReport", "Lorg/jetbrains/qodana/report/ReportResult;", "Lorg/jetbrains/qodana/report/NotValidatedSarif;", "Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "path", "Ljava/nio/file/Path;", "ParserError", "FileNotExists", "JsonParseFailed", "intellij.qodana"})
public final class ReportParser {
    @NotNull
    public static final ReportParser INSTANCE = new ReportParser();

    private ReportParser() {
    }

    @NotNull
    public final ReportResult<NotValidatedSarif, ParserError> parseReport(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new ReportResult.Fail<ReportResult.Error>(FileNotExists.INSTANCE);
        }
        try {
            SarifReport sarifReport = SarifUtil.readReport(path);
            Intrinsics.checkNotNullExpressionValue((Object)sarifReport, (String)"readReport(...)");
            return new ReportResult.Success<LoadedSarif>(new NotValidatedSarif(sarifReport));
        }
        catch (JsonParseException e) {
            return new ReportResult.Fail<ReportResult.Error>(new JsonParseFailed(e));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/qodana/report/ReportParser$FileNotExists;", "Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "<init>", "()V", "intellij.qodana"})
    public static final class FileNotExists
    extends ParserError {
        @NotNull
        public static final FileNotExists INSTANCE = new FileNotExists();

        private FileNotExists() {
            super(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/report/ReportParser$JsonParseFailed;", "Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "e", "Lcom/google/gson/JsonParseException;", "<init>", "(Lcom/google/gson/JsonParseException;)V", "message", "", "getMessage", "()Ljava/lang/String;", "throwException", "", "intellij.qodana"})
    public static final class JsonParseFailed
    extends ParserError {
        @NotNull
        private final JsonParseException e;
        @Nullable
        private final String message;

        public JsonParseFailed(@NotNull JsonParseException e) {
            Intrinsics.checkNotNullParameter((Object)((Object)e), (String)"e");
            super(null);
            this.e = e;
            Object object = this.e.getCause();
            if (object == null || (object = ((Throwable)object).getLocalizedMessage()) == null) {
                object = this.e.getLocalizedMessage();
            }
            this.message = object;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @Override
        @NotNull
        public Void throwException() {
            throw this.e;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J+\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0017\u0010\n\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000bH\u0016\u0082\u0001\u0002\u000e\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/qodana/report/ReportParser$ParserError;", "Lorg/jetbrains/qodana/report/ReportResult$Error;", "<init>", "()V", "throwException", "", "spawnNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "contentProvider", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "Lorg/jetbrains/qodana/report/ReportParser$FileNotExists;", "Lorg/jetbrains/qodana/report/ReportParser$JsonParseFailed;", "intellij.qodana"})
    public static abstract class ParserError
    implements ReportResult.Error<ParserError> {
        private ParserError() {
        }

        @Override
        @NotNull
        public Void throwException() {
            throw new IllegalStateException(("Error during report parsing, " + this).toString());
        }

        @Override
        public void spawnNotification(@Nullable Project project, @NotNull Function1<? super ParserError, String> contentProvider) {
            Intrinsics.checkNotNullParameter(contentProvider, (String)"contentProvider");
            QodanaNotifications.notification$default(QodanaNotifications.General.INSTANCE, QodanaBundle.message("notification.title.cant.parse.report", new Object[0]), (String)contentProvider.invoke((Object)this), NotificationType.WARNING, false, 8, null).notify(project);
        }

        public /* synthetic */ ParserError(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

